/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	edgefsrookiov1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeS3s implements S3Interface
type FakeS3s struct {
	Fake *FakeEdgefsV1
	ns   string
}

var s3sResource = schema.GroupVersionResource{Group: "edgefs.rook.io", Version: "v1", Resource: "s3s"}

var s3sKind = schema.GroupVersionKind{Group: "edgefs.rook.io", Version: "v1", Kind: "S3"}

// Get takes name of the s3, and returns the corresponding s3 object, and an error if there is any.
func (c *FakeS3s) Get(name string, options v1.GetOptions) (result *edgefsrookiov1.S3, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(s3sResource, c.ns, name), &edgefsrookiov1.S3{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.S3), err
}

// List takes label and field selectors, and returns the list of S3s that match those selectors.
func (c *FakeS3s) List(opts v1.ListOptions) (result *edgefsrookiov1.S3List, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(s3sResource, s3sKind, c.ns, opts), &edgefsrookiov1.S3List{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &edgefsrookiov1.S3List{ListMeta: obj.(*edgefsrookiov1.S3List).ListMeta}
	for _, item := range obj.(*edgefsrookiov1.S3List).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested s3s.
func (c *FakeS3s) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(s3sResource, c.ns, opts))

}

// Create takes the representation of a s3 and creates it.  Returns the server's representation of the s3, and an error, if there is any.
func (c *FakeS3s) Create(s3 *edgefsrookiov1.S3) (result *edgefsrookiov1.S3, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(s3sResource, c.ns, s3), &edgefsrookiov1.S3{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.S3), err
}

// Update takes the representation of a s3 and updates it. Returns the server's representation of the s3, and an error, if there is any.
func (c *FakeS3s) Update(s3 *edgefsrookiov1.S3) (result *edgefsrookiov1.S3, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(s3sResource, c.ns, s3), &edgefsrookiov1.S3{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.S3), err
}

// Delete takes name of the s3 and deletes it. Returns an error if one occurs.
func (c *FakeS3s) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(s3sResource, c.ns, name), &edgefsrookiov1.S3{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeS3s) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(s3sResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &edgefsrookiov1.S3List{})
	return err
}

// Patch applies the patch and returns the patched s3.
func (c *FakeS3s) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *edgefsrookiov1.S3, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(s3sResource, c.ns, name, pt, data, subresources...), &edgefsrookiov1.S3{})

	if obj == nil {
		return nil, err
	}
	return obj.(*edgefsrookiov1.S3), err
}
