package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowJobStatistic invokes the emr.DescribeFlowJobStatistic API synchronously
// api document: https://help.aliyun.com/api/emr/describeflowjobstatistic.html
func (client *Client) DescribeFlowJobStatistic(request *DescribeFlowJobStatisticRequest) (response *DescribeFlowJobStatisticResponse, err error) {
	response = CreateDescribeFlowJobStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowJobStatisticWithChan invokes the emr.DescribeFlowJobStatistic API asynchronously
// api document: https://help.aliyun.com/api/emr/describeflowjobstatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowJobStatisticWithChan(request *DescribeFlowJobStatisticRequest) (<-chan *DescribeFlowJobStatisticResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowJobStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowJobStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowJobStatisticWithCallback invokes the emr.DescribeFlowJobStatistic API asynchronously
// api document: https://help.aliyun.com/api/emr/describeflowjobstatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFlowJobStatisticWithCallback(request *DescribeFlowJobStatisticRequest, callback func(response *DescribeFlowJobStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowJobStatisticResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowJobStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowJobStatisticRequest is the request struct for api DescribeFlowJobStatistic
type DescribeFlowJobStatisticRequest struct {
	*requests.RpcRequest
	FromApp   string `position:"Query" name:"FromApp"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DescribeFlowJobStatisticResponse is the response struct for api DescribeFlowJobStatistic
type DescribeFlowJobStatisticResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	StatisticInfo string `json:"StatisticInfo" xml:"StatisticInfo"`
}

// CreateDescribeFlowJobStatisticRequest creates a request to invoke DescribeFlowJobStatistic API
func CreateDescribeFlowJobStatisticRequest() (request *DescribeFlowJobStatisticRequest) {
	request = &DescribeFlowJobStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeFlowJobStatistic", "emr", "openAPI")
	return
}

// CreateDescribeFlowJobStatisticResponse creates a response to parse from DescribeFlowJobStatistic response
func CreateDescribeFlowJobStatisticResponse() (response *DescribeFlowJobStatisticResponse) {
	response = &DescribeFlowJobStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
