package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/billing/mgmt/2018-11-01-preview/billing"

// AcceptTransferProperties request parameters to accept transfer.
type AcceptTransferProperties struct {
	// ProductDetails - Request parameters to accept transfer.
	ProductDetails *[]ProductDetails `json:"productDetails,omitempty"`
}

// AcceptTransferRequest request parameters to accept transfer.
type AcceptTransferRequest struct {
	// AcceptTransferProperties - Request parameters to accept transfer.
	*AcceptTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AcceptTransferRequest.
func (atr AcceptTransferRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atr.AcceptTransferProperties != nil {
		objectMap["properties"] = atr.AcceptTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AcceptTransferRequest struct.
func (atr *AcceptTransferRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var acceptTransferProperties AcceptTransferProperties
				err = json.Unmarshal(*v, &acceptTransferProperties)
				if err != nil {
					return err
				}
				atr.AcceptTransferProperties = &acceptTransferProperties
			}
		}
	}

	return nil
}

// Account a billing account resource.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - A billing account.
	*AccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountListResult result of listing billing accounts.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing accounts.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AccountListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{fn: getNextPage}
}

// AccountProperties the properties of the billing account.
type AccountProperties struct {
	// DisplayName - READ-ONLY; The billing account name.
	DisplayName *string `json:"displayName,omitempty"`
	// AccountType - READ-ONLY; The billing account Type. Possible values include: 'AccountTypeOrganization', 'AccountTypeEnrollment'
	AccountType AccountType `json:"accountType,omitempty"`
	// Address - The address associated with billing account.
	Address *Address `json:"address,omitempty"`
	// Company - READ-ONLY; Company Name.
	Company *string `json:"company,omitempty"`
	// Country - READ-ONLY; Country Name.
	Country *string `json:"country,omitempty"`
	// InvoiceSections - The invoice sections associated to the billing account. By default this is not populated, unless it's specified in $expand.
	InvoiceSections *[]InvoiceSection `json:"invoiceSections,omitempty"`
	// BillingProfiles - The billing profiles associated to the billing account. By default this is not populated, unless it's specified in $expand.
	BillingProfiles *[]Profile `json:"billingProfiles,omitempty"`
	// EnrollmentDetails - READ-ONLY; The details about the associated legacy enrollment. By default this is not populated, unless it's specified in $expand.
	EnrollmentDetails *Enrollment `json:"enrollmentDetails,omitempty"`
	// Departments - The departments associated to the enrollment.
	Departments *[]Department `json:"departments,omitempty"`
	// EnrollmentAccounts - The accounts associated to the enrollment.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
	// HasReadAccess - READ-ONLY; Specifies whether the user has read access on billing account.
	HasReadAccess *bool `json:"hasReadAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountProperties.
func (ap AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Address != nil {
		objectMap["address"] = ap.Address
	}
	if ap.InvoiceSections != nil {
		objectMap["invoiceSections"] = ap.InvoiceSections
	}
	if ap.BillingProfiles != nil {
		objectMap["billingProfiles"] = ap.BillingProfiles
	}
	if ap.Departments != nil {
		objectMap["departments"] = ap.Departments
	}
	if ap.EnrollmentAccounts != nil {
		objectMap["enrollmentAccounts"] = ap.EnrollmentAccounts
	}
	return json.Marshal(objectMap)
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AccountsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsUpdateFuture) Result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.AccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.AccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.UpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.AccountsUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountUpdateProperties the properties of the billing account that can be updated.
type AccountUpdateProperties struct {
	// AccountProperties - A billing property.
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateProperties.
func (aup AccountUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.AccountProperties != nil {
		objectMap["properties"] = aup.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateProperties struct.
func (aup *AccountUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				aup.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// Address address details.
type Address struct {
	// FirstName - First Name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last Name.
	LastName *string `json:"lastName,omitempty"`
	// CompanyName - Company Name.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressLine1 - Address Line1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - Address Line2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - Address Line3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// City - Address City.
	City *string `json:"city,omitempty"`
	// Region - Address Region.
	Region *string `json:"region,omitempty"`
	// Country - Country code uses ISO2, 2-digit format.
	Country *string `json:"country,omitempty"`
	// PostalCode - Address Postal Code.
	PostalCode *string `json:"postalCode,omitempty"`
}

// Agreement an agreement resource.
type Agreement struct {
	autorest.Response `json:"-"`
	// AgreementProperties - An agreement.
	*AgreementProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Agreement.
func (a Agreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AgreementProperties != nil {
		objectMap["properties"] = a.AgreementProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Agreement struct.
func (a *Agreement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var agreementProperties AgreementProperties
				err = json.Unmarshal(*v, &agreementProperties)
				if err != nil {
					return err
				}
				a.AgreementProperties = &agreementProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AgreementListResult result of listing agreements.
type AgreementListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of agreements.
	Value *[]Agreement `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AgreementListResultIterator provides access to a complete listing of Agreement values.
type AgreementListResultIterator struct {
	i    int
	page AgreementListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgreementListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgreementListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgreementListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgreementListResultIterator) Response() AgreementListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgreementListResultIterator) Value() Agreement {
	if !iter.page.NotDone() {
		return Agreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgreementListResultIterator type.
func NewAgreementListResultIterator(page AgreementListResultPage) AgreementListResultIterator {
	return AgreementListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AgreementListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr AgreementListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// agreementListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AgreementListResult) agreementListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AgreementListResultPage contains a page of Agreement values.
type AgreementListResultPage struct {
	fn  func(context.Context, AgreementListResult) (AgreementListResult, error)
	alr AgreementListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgreementListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgreementListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgreementListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgreementListResultPage) Response() AgreementListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgreementListResultPage) Values() []Agreement {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AgreementListResultPage type.
func NewAgreementListResultPage(getNextPage func(context.Context, AgreementListResult) (AgreementListResult, error)) AgreementListResultPage {
	return AgreementListResultPage{fn: getNextPage}
}

// AgreementProperties the properties of the agreement.
type AgreementProperties struct {
	// AgreementLink - READ-ONLY; The link to the agreement.
	AgreementLink *string `json:"agreementLink,omitempty"`
	// EffectiveDate - READ-ONLY; Effective date.
	EffectiveDate *date.Time `json:"effectiveDate,omitempty"`
	// ExpirationDate - READ-ONLY; Expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Participants - Participants or signer of the agreement.
	Participants *[]Participants `json:"participants,omitempty"`
	// Status - READ-ONLY; The agreement status
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for AgreementProperties.
func (ap AgreementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Participants != nil {
		objectMap["participants"] = ap.Participants
	}
	return json.Marshal(objectMap)
}

// Amount the Amount.
type Amount struct {
	// Currency - READ-ONLY; The currency for the amount value.
	Currency *string `json:"currency,omitempty"`
	// Value - Amount value.
	Value *float64 `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Amount.
func (a Amount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Value != nil {
		objectMap["value"] = a.Value
	}
	return json.Marshal(objectMap)
}

// AvailableBalance latest available balance on Monetary Credit PI.
type AvailableBalance struct {
	autorest.Response           `json:"-"`
	*AvailableBalanceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableBalance.
func (ab AvailableBalance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ab.AvailableBalanceProperties != nil {
		objectMap["properties"] = ab.AvailableBalanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableBalance struct.
func (ab *AvailableBalance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availableBalanceProperties AvailableBalanceProperties
				err = json.Unmarshal(*v, &availableBalanceProperties)
				if err != nil {
					return err
				}
				ab.AvailableBalanceProperties = &availableBalanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ab.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ab.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ab.Type = &typeVar
			}
		}
	}

	return nil
}

// AvailableBalanceProperties the properties of available balance.
type AvailableBalanceProperties struct {
	// Amount - READ-ONLY; Balance Amount.
	Amount *Amount `json:"amount,omitempty"`
}

// Customer a partner's customer.
type Customer struct {
	autorest.Response `json:"-"`
	// CustomerProperties - The customer.
	*CustomerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Customer.
func (c Customer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CustomerProperties != nil {
		objectMap["properties"] = c.CustomerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Customer struct.
func (c *Customer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customerProperties CustomerProperties
				err = json.Unmarshal(*v, &customerProperties)
				if err != nil {
					return err
				}
				c.CustomerProperties = &customerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomerListResult result of listing customers.
type CustomerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of customers.
	Value *[]Customer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomerListResultIterator provides access to a complete listing of Customer values.
type CustomerListResultIterator struct {
	i    int
	page CustomerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomerListResultIterator) Response() CustomerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomerListResultIterator) Value() Customer {
	if !iter.page.NotDone() {
		return Customer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomerListResultIterator type.
func NewCustomerListResultIterator(page CustomerListResultPage) CustomerListResultIterator {
	return CustomerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CustomerListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (clr CustomerListResult) hasNextLink() bool {
	return clr.NextLink != nil && len(*clr.NextLink) != 0
}

// customerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CustomerListResult) customerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !clr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CustomerListResultPage contains a page of Customer values.
type CustomerListResultPage struct {
	fn  func(context.Context, CustomerListResult) (CustomerListResult, error)
	clr CustomerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.clr)
		if err != nil {
			return err
		}
		page.clr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomerListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomerListResultPage) Response() CustomerListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomerListResultPage) Values() []Customer {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CustomerListResultPage type.
func NewCustomerListResultPage(getNextPage func(context.Context, CustomerListResult) (CustomerListResult, error)) CustomerListResultPage {
	return CustomerListResultPage{fn: getNextPage}
}

// CustomerProperties the properties of a customer.
type CustomerProperties struct {
	// DisplayName - The name of the customer.
	DisplayName *string `json:"displayName,omitempty"`
	// EnabledAzureSKUs - Information about the product.
	EnabledAzureSKUs *[]EnabledAzureSKUs `json:"enabledAzureSKUs,omitempty"`
	// Resellers - The resellers which are allowed to provide service to this customer.
	Resellers *[]Reseller `json:"resellers,omitempty"`
}

// Department a department resource.
type Department struct {
	autorest.Response `json:"-"`
	// DepartmentProperties - A department.
	*DepartmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Department.
func (d Department) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DepartmentProperties != nil {
		objectMap["properties"] = d.DepartmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Department struct.
func (d *Department) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var departmentProperties DepartmentProperties
				err = json.Unmarshal(*v, &departmentProperties)
				if err != nil {
					return err
				}
				d.DepartmentProperties = &departmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DepartmentListResult result of listing departments.
type DepartmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of departments.
	Value *[]Department `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DepartmentListResultIterator provides access to a complete listing of Department values.
type DepartmentListResultIterator struct {
	i    int
	page DepartmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DepartmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DepartmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DepartmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DepartmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DepartmentListResultIterator) Response() DepartmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DepartmentListResultIterator) Value() Department {
	if !iter.page.NotDone() {
		return Department{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DepartmentListResultIterator type.
func NewDepartmentListResultIterator(page DepartmentListResultPage) DepartmentListResultIterator {
	return DepartmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DepartmentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DepartmentListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// departmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DepartmentListResult) departmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DepartmentListResultPage contains a page of Department values.
type DepartmentListResultPage struct {
	fn  func(context.Context, DepartmentListResult) (DepartmentListResult, error)
	dlr DepartmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DepartmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DepartmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DepartmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DepartmentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DepartmentListResultPage) Response() DepartmentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DepartmentListResultPage) Values() []Department {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DepartmentListResultPage type.
func NewDepartmentListResultPage(getNextPage func(context.Context, DepartmentListResult) (DepartmentListResult, error)) DepartmentListResultPage {
	return DepartmentListResultPage{fn: getNextPage}
}

// DepartmentProperties the properties of the department.
type DepartmentProperties struct {
	// DepartmentName - The name for department.
	DepartmentName *string `json:"departmentName,omitempty"`
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// Status - The status for department.
	Status *string `json:"status,omitempty"`
	// EnrollmentAccounts - Associated enrollment accounts. By default this is not populated, unless it's specified in $expand.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
}

// DetailedTransferStatus detailed transfer status.
type DetailedTransferStatus struct {
	// ProductType - READ-ONLY; Type of product being transferred. Possible values include: 'ProductTypeAzureSubscription', 'ProductTypeAzureReservation'
	ProductType ProductType `json:"productType,omitempty"`
	// ProductID - READ-ONLY; Id of product being transferred.
	ProductID *string `json:"productId,omitempty"`
	// TransferStatus - READ-ONLY; Transfer status. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'Failed'
	TransferStatus ProductTransferStatus `json:"transferStatus,omitempty"`
	// ErrorDetails - Error details for transfer execution.
	ErrorDetails *Error `json:"errorDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for DetailedTransferStatus.
func (dts DetailedTransferStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dts.ErrorDetails != nil {
		objectMap["errorDetails"] = dts.ErrorDetails
	}
	return json.Marshal(objectMap)
}

// DownloadProperties the properties of the invoice download.
type DownloadProperties struct {
	// Kind - READ-ONLY; Document type. Possible values include: 'Invoice', 'VoidNote', 'Receipt', 'CreditNote'
	Kind Kind `json:"kind,omitempty"`
	// URL - READ-ONLY; Document URL.
	URL *string `json:"url,omitempty"`
}

// DownloadURL a secure URL that can be used to download a an entity until the URL expires.
type DownloadURL struct {
	autorest.Response `json:"-"`
	// ExpiryTime - READ-ONLY; The time in UTC at which this download URL will expire.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// URL - READ-ONLY; The URL to the PDF file.
	URL *string `json:"url,omitempty"`
}

// EnabledAzureSKUs details about the enabled azure sku.
type EnabledAzureSKUs struct {
	// SkuID - The sku id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// MarshalJSON is the custom marshaler for EnabledAzureSKUs.
func (easu EnabledAzureSKUs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if easu.SkuID != nil {
		objectMap["skuId"] = easu.SkuID
	}
	return json.Marshal(objectMap)
}

// Enrollment current entity level details
type Enrollment struct {
	// StartDate - Enrollment Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Enrollment End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// Currency - READ-ONLY; The currency associated with enrollment
	Currency *string `json:"currency,omitempty"`
	// Channel - READ-ONLY; The channel for Enrollment
	Channel *string `json:"channel,omitempty"`
	// Policies - READ-ONLY; The attributes associated with legacy enrollment.
	Policies *EnrollmentPolicies `json:"policies,omitempty"`
	// Language - READ-ONLY; The language for Enrollment
	Language *string `json:"language,omitempty"`
	// CountryCode - READ-ONLY; The countryCode for Enrollment
	CountryCode *string `json:"countryCode,omitempty"`
	// Status - READ-ONLY; Enrollment status
	Status *string `json:"status,omitempty"`
	// BillingCycle - READ-ONLY; Enrollment billing cycle
	BillingCycle *string `json:"billingCycle,omitempty"`
}

// MarshalJSON is the custom marshaler for Enrollment.
func (e Enrollment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.StartDate != nil {
		objectMap["startDate"] = e.StartDate
	}
	if e.EndDate != nil {
		objectMap["endDate"] = e.EndDate
	}
	return json.Marshal(objectMap)
}

// EnrollmentAccount an account resource.
type EnrollmentAccount struct {
	autorest.Response `json:"-"`
	// EnrollmentAccountProperties - An account.
	*EnrollmentAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EnrollmentAccount.
func (ea EnrollmentAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ea.EnrollmentAccountProperties != nil {
		objectMap["properties"] = ea.EnrollmentAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnrollmentAccount struct.
func (ea *EnrollmentAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var enrollmentAccountProperties EnrollmentAccountProperties
				err = json.Unmarshal(*v, &enrollmentAccountProperties)
				if err != nil {
					return err
				}
				ea.EnrollmentAccountProperties = &enrollmentAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ea.Type = &typeVar
			}
		}
	}

	return nil
}

// EnrollmentAccountContext the rating context.
type EnrollmentAccountContext struct {
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// StartDate - Account Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Account End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// EnrollmentAccountName - The enrollment account id.
	EnrollmentAccountName *string `json:"enrollmentAccountName,omitempty"`
}

// EnrollmentAccountListResult result of listing enrollment accounts.
type EnrollmentAccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of enrollment accounts.
	Value *[]EnrollmentAccount `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EnrollmentAccountListResultIterator provides access to a complete listing of EnrollmentAccount values.
type EnrollmentAccountListResultIterator struct {
	i    int
	page EnrollmentAccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EnrollmentAccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnrollmentAccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EnrollmentAccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EnrollmentAccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EnrollmentAccountListResultIterator) Response() EnrollmentAccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EnrollmentAccountListResultIterator) Value() EnrollmentAccount {
	if !iter.page.NotDone() {
		return EnrollmentAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EnrollmentAccountListResultIterator type.
func NewEnrollmentAccountListResultIterator(page EnrollmentAccountListResultPage) EnrollmentAccountListResultIterator {
	return EnrollmentAccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ealr EnrollmentAccountListResult) IsEmpty() bool {
	return ealr.Value == nil || len(*ealr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ealr EnrollmentAccountListResult) hasNextLink() bool {
	return ealr.NextLink != nil && len(*ealr.NextLink) != 0
}

// enrollmentAccountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ealr EnrollmentAccountListResult) enrollmentAccountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ealr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ealr.NextLink)))
}

// EnrollmentAccountListResultPage contains a page of EnrollmentAccount values.
type EnrollmentAccountListResultPage struct {
	fn   func(context.Context, EnrollmentAccountListResult) (EnrollmentAccountListResult, error)
	ealr EnrollmentAccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EnrollmentAccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnrollmentAccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ealr)
		if err != nil {
			return err
		}
		page.ealr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EnrollmentAccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EnrollmentAccountListResultPage) NotDone() bool {
	return !page.ealr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EnrollmentAccountListResultPage) Response() EnrollmentAccountListResult {
	return page.ealr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EnrollmentAccountListResultPage) Values() []EnrollmentAccount {
	if page.ealr.IsEmpty() {
		return nil
	}
	return *page.ealr.Value
}

// Creates a new instance of the EnrollmentAccountListResultPage type.
func NewEnrollmentAccountListResultPage(getNextPage func(context.Context, EnrollmentAccountListResult) (EnrollmentAccountListResult, error)) EnrollmentAccountListResultPage {
	return EnrollmentAccountListResultPage{fn: getNextPage}
}

// EnrollmentAccountProperties the properties of the account.
type EnrollmentAccountProperties struct {
	// AccountName - The account name.
	AccountName *string `json:"accountName,omitempty"`
	// CostCenter - The cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// AccountOwner - The account owner
	AccountOwner *string `json:"accountOwner,omitempty"`
	// Status - The status for account.
	Status *string `json:"status,omitempty"`
	// StartDate - Account Start Date
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Account End Date
	EndDate *date.Time `json:"endDate,omitempty"`
	// Department - Associated department. By default this is not populated, unless it's specified in $expand.
	Department *Department `json:"department,omitempty"`
}

// EnrollmentPolicies the attributes associated with legacy enrollment
type EnrollmentPolicies struct {
	// AccountOwnerViewCharges - READ-ONLY; The accountOwnerViewCharges flag for Enrollment
	AccountOwnerViewCharges *bool `json:"accountOwnerViewCharges,omitempty"`
	// DepartmentAdminViewCharges - READ-ONLY; The departmentAdminViewCharges flag for Enrollment
	DepartmentAdminViewCharges *bool `json:"departmentAdminViewCharges,omitempty"`
	// MarketplacesEnabled - READ-ONLY; The marketplaces flag for Enrollment
	MarketplacesEnabled *bool `json:"marketplacesEnabled,omitempty"`
	// ReservedInstancesEnabled - READ-ONLY; The reserved instances flag for Enrollment
	ReservedInstancesEnabled *bool `json:"reservedInstancesEnabled,omitempty"`
}

// Error error details for transfer execution.
type Error struct {
	// ErrorCode - READ-ONLY; Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// InitiateTransferProperties request parameters to initiate transfer.
type InitiateTransferProperties struct {
	// BillingProfileID - Target Usage context for devTest subscriptions.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// RecipientEmailID - Email Id of recipient for transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
}

// InitiateTransferRequest request parameters to initiate transfer.
type InitiateTransferRequest struct {
	// InitiateTransferProperties - Request parameters to initiate transfer.
	*InitiateTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for InitiateTransferRequest.
func (itr InitiateTransferRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itr.InitiateTransferProperties != nil {
		objectMap["properties"] = itr.InitiateTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InitiateTransferRequest struct.
func (itr *InitiateTransferRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var initiateTransferProperties InitiateTransferProperties
				err = json.Unmarshal(*v, &initiateTransferProperties)
				if err != nil {
					return err
				}
				itr.InitiateTransferProperties = &initiateTransferProperties
			}
		}
	}

	return nil
}

// InvoiceListResult result of listing invoices.
type InvoiceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of invoices.
	Value *[]InvoiceSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceListResultIterator provides access to a complete listing of InvoiceSummary values.
type InvoiceListResultIterator struct {
	i    int
	page InvoiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoiceListResultIterator) Response() InvoiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoiceListResultIterator) Value() InvoiceSummary {
	if !iter.page.NotDone() {
		return InvoiceSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoiceListResultIterator type.
func NewInvoiceListResultIterator(page InvoiceListResultPage) InvoiceListResultIterator {
	return InvoiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InvoiceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InvoiceListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// invoiceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InvoiceListResult) invoiceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InvoiceListResultPage contains a page of InvoiceSummary values.
type InvoiceListResultPage struct {
	fn  func(context.Context, InvoiceListResult) (InvoiceListResult, error)
	ilr InvoiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoiceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoiceListResultPage) Response() InvoiceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoiceListResultPage) Values() []InvoiceSummary {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InvoiceListResultPage type.
func NewInvoiceListResultPage(getNextPage func(context.Context, InvoiceListResult) (InvoiceListResult, error)) InvoiceListResultPage {
	return InvoiceListResultPage{fn: getNextPage}
}

// InvoiceSection an InvoiceSection resource.
type InvoiceSection struct {
	autorest.Response `json:"-"`
	// InvoiceSectionProperties - The InvoiceSection.
	*InvoiceSectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSection.
func (is InvoiceSection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.InvoiceSectionProperties != nil {
		objectMap["properties"] = is.InvoiceSectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InvoiceSection struct.
func (is *InvoiceSection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceSectionProperties InvoiceSectionProperties
				err = json.Unmarshal(*v, &invoiceSectionProperties)
				if err != nil {
					return err
				}
				is.InvoiceSectionProperties = &invoiceSectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceSectionCreationRequest the properties of an InvoiceSection.
type InvoiceSectionCreationRequest struct {
	// DisplayName - The name of the InvoiceSection.
	DisplayName *string `json:"displayName,omitempty"`
	// BillingProfileID - The billing profile id.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
}

// InvoiceSectionListResult result of listing invoice sections.
type InvoiceSectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of invoice sections.
	Value *[]InvoiceSection `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceSectionListResultIterator provides access to a complete listing of InvoiceSection values.
type InvoiceSectionListResultIterator struct {
	i    int
	page InvoiceSectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoiceSectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoiceSectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoiceSectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoiceSectionListResultIterator) Response() InvoiceSectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoiceSectionListResultIterator) Value() InvoiceSection {
	if !iter.page.NotDone() {
		return InvoiceSection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoiceSectionListResultIterator type.
func NewInvoiceSectionListResultIterator(page InvoiceSectionListResultPage) InvoiceSectionListResultIterator {
	return InvoiceSectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (islr InvoiceSectionListResult) IsEmpty() bool {
	return islr.Value == nil || len(*islr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (islr InvoiceSectionListResult) hasNextLink() bool {
	return islr.NextLink != nil && len(*islr.NextLink) != 0
}

// invoiceSectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (islr InvoiceSectionListResult) invoiceSectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !islr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(islr.NextLink)))
}

// InvoiceSectionListResultPage contains a page of InvoiceSection values.
type InvoiceSectionListResultPage struct {
	fn   func(context.Context, InvoiceSectionListResult) (InvoiceSectionListResult, error)
	islr InvoiceSectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoiceSectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.islr)
		if err != nil {
			return err
		}
		page.islr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoiceSectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoiceSectionListResultPage) NotDone() bool {
	return !page.islr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoiceSectionListResultPage) Response() InvoiceSectionListResult {
	return page.islr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoiceSectionListResultPage) Values() []InvoiceSection {
	if page.islr.IsEmpty() {
		return nil
	}
	return *page.islr.Value
}

// Creates a new instance of the InvoiceSectionListResultPage type.
func NewInvoiceSectionListResultPage(getNextPage func(context.Context, InvoiceSectionListResult) (InvoiceSectionListResult, error)) InvoiceSectionListResultPage {
	return InvoiceSectionListResultPage{fn: getNextPage}
}

// InvoiceSectionProperties the properties of an InvoiceSection.
type InvoiceSectionProperties struct {
	// DisplayName - The name of the InvoiceSection.
	DisplayName *string `json:"displayName,omitempty"`
	// BillingProfiles - The billing profiles associated to the billing account.
	BillingProfiles *[]Profile `json:"billingProfiles,omitempty"`
}

// InvoiceSectionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InvoiceSectionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoiceSectionsCreateFuture) Result(client InvoiceSectionsClient) (is InvoiceSection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoiceSectionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.CreateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSectionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InvoiceSectionsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoiceSectionsUpdateFuture) Result(client InvoiceSectionsClient) (is InvoiceSection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoiceSectionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.UpdateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsUpdateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSummary an invoice resource.
type InvoiceSummary struct {
	autorest.Response `json:"-"`
	// InvoiceSummaryProperties - An invoice.
	*InvoiceSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSummary.
func (is InvoiceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.InvoiceSummaryProperties != nil {
		objectMap["properties"] = is.InvoiceSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InvoiceSummary struct.
func (is *InvoiceSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceSummaryProperties InvoiceSummaryProperties
				err = json.Unmarshal(*v, &invoiceSummaryProperties)
				if err != nil {
					return err
				}
				is.InvoiceSummaryProperties = &invoiceSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceSummaryProperties the properties of the invoice.
type InvoiceSummaryProperties struct {
	// DueDate - READ-ONLY; The due date for invoice.
	DueDate *date.Time `json:"dueDate,omitempty"`
	// InvoiceDate - READ-ONLY; The date when invoice was created.
	InvoiceDate *date.Time `json:"invoiceDate,omitempty"`
	// Status - READ-ONLY; Invoice status. Possible values include: 'Status1PastDue', 'Status1Due', 'Status1Paid', 'Status1Void'
	Status Status1 `json:"status,omitempty"`
	// AmountDue - READ-ONLY; Amount due.
	AmountDue *Amount `json:"amountDue,omitempty"`
	// BilledAmount - READ-ONLY; Amount billed.
	BilledAmount *Amount `json:"billedAmount,omitempty"`
	// InvoicePeriodStartDate - READ-ONLY; The start date of the billing period.
	InvoicePeriodStartDate *date.Time `json:"invoicePeriodStartDate,omitempty"`
	// InvoicePeriodEndDate - READ-ONLY; The end date of the billing period.
	InvoicePeriodEndDate *date.Time `json:"invoicePeriodEndDate,omitempty"`
	// BillingProfileID - READ-ONLY; The billing profile id this invoice belongs to.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; The profile name this invoice belongs to.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// PurchaseOrderNumber - READ-ONLY; The purchase identifier for the invoice.
	PurchaseOrderNumber *string `json:"purchaseOrderNumber,omitempty"`
	// DocumentUrls - READ-ONLY; List of document urls available to download including invoice and tax documents.
	DocumentUrls *[]DownloadProperties `json:"documentUrls,omitempty"`
	// Payments - READ-ONLY; List of payments.
	Payments *[]PaymentProperties `json:"payments,omitempty"`
}

// LineOfCredit line of credit resource.
type LineOfCredit struct {
	autorest.Response `json:"-"`
	// LineOfCreditProperties - A line of credit.
	*LineOfCreditProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LineOfCredit.
func (loc LineOfCredit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if loc.LineOfCreditProperties != nil {
		objectMap["properties"] = loc.LineOfCreditProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LineOfCredit struct.
func (loc *LineOfCredit) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var lineOfCreditProperties LineOfCreditProperties
				err = json.Unmarshal(*v, &lineOfCreditProperties)
				if err != nil {
					return err
				}
				loc.LineOfCreditProperties = &lineOfCreditProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				loc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				loc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				loc.Type = &typeVar
			}
		}
	}

	return nil
}

// LineOfCreditProperties the properties of the line of credit.
type LineOfCreditProperties struct {
	// CreditLimit - The current credit limit.
	CreditLimit *Amount `json:"creditLimit,omitempty"`
	// Reason - READ-ONLY; The reason for the line of credit status when not approved.
	Reason *string `json:"reason,omitempty"`
	// RemainingBalance - READ-ONLY; Remaining balance.
	RemainingBalance *Amount `json:"remainingBalance,omitempty"`
	// Status - The line of credit status. Possible values include: 'Approved', 'Rejected'
	Status Status `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for LineOfCreditProperties.
func (locp LineOfCreditProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if locp.CreditLimit != nil {
		objectMap["creditLimit"] = locp.CreditLimit
	}
	if locp.Status != "" {
		objectMap["status"] = locp.Status
	}
	return json.Marshal(objectMap)
}

// LineOfCreditsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LineOfCreditsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LineOfCreditsUpdateFuture) Result(client LineOfCreditsClient) (loc LineOfCredit, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.LineOfCreditsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.LineOfCreditsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if loc.Response.Response, err = future.GetResult(sender); err == nil && loc.Response.Response.StatusCode != http.StatusNoContent {
		loc, err = client.UpdateResponder(loc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.LineOfCreditsUpdateFuture", "Result", loc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Operation a Billing REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Billing.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result listing billing operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of billing operations supported by the Microsoft.Billing resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationStatus status of the Billing POST/PUT operation.
type OperationStatus struct {
	// ID - READ-ONLY; The operation Id.
	ID *string `json:"id,omitempty"`
	// Status - Status of the pending operation
	Status *string `json:"status,omitempty"`
	// StatusDetail - Status Detail of the pending operation
	StatusDetail *string `json:"statusDetail,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatus.
func (osVar OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if osVar.Status != nil {
		objectMap["status"] = osVar.Status
	}
	if osVar.StatusDetail != nil {
		objectMap["statusDetail"] = osVar.StatusDetail
	}
	return json.Marshal(objectMap)
}

// Participants details about the participant or signer.
type Participants struct {
	// Status - READ-ONLY; The signing status
	Status *string `json:"status,omitempty"`
	// StatusDate - READ-ONLY; The date when status got changed.
	StatusDate *date.Time `json:"statusDate,omitempty"`
	// Email - READ-ONLY; The email address of the participant or signer.
	Email *string `json:"email,omitempty"`
}

// PaymentMethod a payment method resource.
type PaymentMethod struct {
	*PaymentMethodProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PaymentMethod.
func (pm PaymentMethod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.PaymentMethodProperties != nil {
		objectMap["properties"] = pm.PaymentMethodProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PaymentMethod struct.
func (pm *PaymentMethod) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var paymentMethodProperties PaymentMethodProperties
				err = json.Unmarshal(*v, &paymentMethodProperties)
				if err != nil {
					return err
				}
				pm.PaymentMethodProperties = &paymentMethodProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pm.Type = &typeVar
			}
		}
	}

	return nil
}

// PaymentMethodProperties the properties of the payment method.
type PaymentMethodProperties struct {
	// PaymentMethodType - Payment method type. Possible values include: 'Credits', 'ChequeWire'
	PaymentMethodType PaymentMethodType `json:"paymentMethodType,omitempty"`
	// Details - READ-ONLY; Details about the payment method.
	Details *string `json:"details,omitempty"`
	// Expiration - READ-ONLY; Expiration date.
	Expiration *date.Time `json:"expiration,omitempty"`
	// Currency - READ-ONLY; The currency associated with the payment method.
	Currency *string `json:"currency,omitempty"`
}

// MarshalJSON is the custom marshaler for PaymentMethodProperties.
func (pmp PaymentMethodProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmp.PaymentMethodType != "" {
		objectMap["paymentMethodType"] = pmp.PaymentMethodType
	}
	return json.Marshal(objectMap)
}

// PaymentMethodsListResult result of listing payment methods.
type PaymentMethodsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of payment methods.
	Value *[]PaymentMethod `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaymentMethodsListResultIterator provides access to a complete listing of PaymentMethod values.
type PaymentMethodsListResultIterator struct {
	i    int
	page PaymentMethodsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaymentMethodsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaymentMethodsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaymentMethodsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaymentMethodsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaymentMethodsListResultIterator) Response() PaymentMethodsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaymentMethodsListResultIterator) Value() PaymentMethod {
	if !iter.page.NotDone() {
		return PaymentMethod{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaymentMethodsListResultIterator type.
func NewPaymentMethodsListResultIterator(page PaymentMethodsListResultPage) PaymentMethodsListResultIterator {
	return PaymentMethodsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmlr PaymentMethodsListResult) IsEmpty() bool {
	return pmlr.Value == nil || len(*pmlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pmlr PaymentMethodsListResult) hasNextLink() bool {
	return pmlr.NextLink != nil && len(*pmlr.NextLink) != 0
}

// paymentMethodsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmlr PaymentMethodsListResult) paymentMethodsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pmlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmlr.NextLink)))
}

// PaymentMethodsListResultPage contains a page of PaymentMethod values.
type PaymentMethodsListResultPage struct {
	fn   func(context.Context, PaymentMethodsListResult) (PaymentMethodsListResult, error)
	pmlr PaymentMethodsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaymentMethodsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaymentMethodsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pmlr)
		if err != nil {
			return err
		}
		page.pmlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaymentMethodsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaymentMethodsListResultPage) NotDone() bool {
	return !page.pmlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaymentMethodsListResultPage) Response() PaymentMethodsListResult {
	return page.pmlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaymentMethodsListResultPage) Values() []PaymentMethod {
	if page.pmlr.IsEmpty() {
		return nil
	}
	return *page.pmlr.Value
}

// Creates a new instance of the PaymentMethodsListResultPage type.
func NewPaymentMethodsListResultPage(getNextPage func(context.Context, PaymentMethodsListResult) (PaymentMethodsListResult, error)) PaymentMethodsListResultPage {
	return PaymentMethodsListResultPage{fn: getNextPage}
}

// PaymentProperties the properties of the payment.
type PaymentProperties struct {
	// PaymentType - READ-ONLY; The type of payment.
	PaymentType *string `json:"paymentType,omitempty"`
	// Amount - READ-ONLY; The paid amount.
	Amount *Amount `json:"amount,omitempty"`
	// Date - READ-ONLY; The date of the payment.
	Date *date.Time `json:"date,omitempty"`
}

// PermissionsListResult result of list billingPermissions a caller has on a billing account.
type PermissionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list OF billingPermissions a caller has on a billing account.
	Value *[]PermissionsProperties `json:"value,omitempty"`
}

// PermissionsProperties the set of allowed action and not allowed actions a caller has on a billing account
type PermissionsProperties struct {
	// Actions - READ-ONLY; The set of actions that the caller is allowed to do
	Actions *[]string `json:"actions,omitempty"`
	// NotActions - READ-ONLY; The set of actions the caller is not allowed to do
	NotActions *[]string `json:"notActions,omitempty"`
}

// Policy the Policy.
type Policy struct {
	autorest.Response `json:"-"`
	*PolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PolicyProperties the properties of policy.
type PolicyProperties struct {
	// MarketplacePurchasesAllowed - The marketplacePurchasesAllowed flag.
	MarketplacePurchasesAllowed *bool `json:"marketplacePurchasesAllowed,omitempty"`
	// ReservationPurchasesAllowed - The reservationPurchasesAllowed flag.
	ReservationPurchasesAllowed *bool `json:"reservationPurchasesAllowed,omitempty"`
	// SubscriptionOwnerCanViewCharges - The subscriptionOwnerCanViewCharges flag.
	SubscriptionOwnerCanViewCharges *bool `json:"subscriptionOwnerCanViewCharges,omitempty"`
}

// PriceSheetDownloadFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PriceSheetDownloadFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PriceSheetDownloadFuture) Result(client PriceSheetClient) (du DownloadURL, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.PriceSheetDownloadFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.PriceSheetDownloadFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if du.Response.Response, err = future.GetResult(sender); err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
		du, err = client.DownloadResponder(du.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.PriceSheetDownloadFuture", "Result", du.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProductDetails details of the product to be transferred.
type ProductDetails struct {
	// ProductType - Type of the product to be transferred. Possible values include: 'ProductTypeAzureSubscription', 'ProductTypeAzureReservation'
	ProductType ProductType `json:"productType,omitempty"`
	// ProductID - Id of product to be transferred.
	ProductID *string `json:"productId,omitempty"`
}

// ProductsListResult result of listing products summary. It contains a list of available products summaries in
// reverse chronological order by purchase date.
type ProductsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of products summary.
	Value *[]ProductSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductsListResultIterator provides access to a complete listing of ProductSummary values.
type ProductsListResultIterator struct {
	i    int
	page ProductsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductsListResultIterator) Response() ProductsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductsListResultIterator) Value() ProductSummary {
	if !iter.page.NotDone() {
		return ProductSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductsListResultIterator type.
func NewProductsListResultIterator(page ProductsListResultPage) ProductsListResultIterator {
	return ProductsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProductsListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProductsListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// productsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProductsListResult) productsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProductsListResultPage contains a page of ProductSummary values.
type ProductsListResultPage struct {
	fn  func(context.Context, ProductsListResult) (ProductsListResult, error)
	plr ProductsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductsListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductsListResultPage) Response() ProductsListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductsListResultPage) Values() []ProductSummary {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProductsListResultPage type.
func NewProductsListResultPage(getNextPage func(context.Context, ProductsListResult) (ProductsListResult, error)) ProductsListResultPage {
	return ProductsListResultPage{fn: getNextPage}
}

// ProductSummary a product summary resource.
type ProductSummary struct {
	autorest.Response         `json:"-"`
	*ProductSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductSummary.
func (ps ProductSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.ProductSummaryProperties != nil {
		objectMap["properties"] = ps.ProductSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProductSummary struct.
func (ps *ProductSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productSummaryProperties ProductSummaryProperties
				err = json.Unmarshal(*v, &productSummaryProperties)
				if err != nil {
					return err
				}
				ps.ProductSummaryProperties = &productSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		}
	}

	return nil
}

// ProductSummaryProperties the properties of the product summary.
type ProductSummaryProperties struct {
	// DisplayName - READ-ONLY; The display name of the product.
	DisplayName *string `json:"displayName,omitempty"`
	// PurchaseDate - READ-ONLY; The date of purchase.
	PurchaseDate *date.Time `json:"purchaseDate,omitempty"`
	// ProductTypeID - READ-ONLY; The product type id.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - READ-ONLY; The type of product.
	ProductType *string `json:"productType,omitempty"`
	// Status - Product status. Possible values include: 'Active', 'Inactive', 'PastDue', 'Expiring', 'Expired', 'Disabled', 'Cancelled', 'AutoRenew'
	Status ProductStatusType `json:"status,omitempty"`
	// EndDate - READ-ONLY; end date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// BillingFrequency - Billing frequency. Possible values include: 'OneTime', 'Monthly', 'UsageBased'
	BillingFrequency Frequency `json:"billingFrequency,omitempty"`
	// LastCharge - READ-ONLY; Last month charges.
	LastCharge *Amount `json:"lastCharge,omitempty"`
	// LastChargeDate - READ-ONLY; The date of the last charge.
	LastChargeDate *date.Time `json:"lastChargeDate,omitempty"`
	// Quantity - READ-ONLY; The purchased product quantity.
	Quantity *float64 `json:"quantity,omitempty"`
	// SkuID - READ-ONLY; Sku Id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; Sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
	// AvailabilityID - READ-ONLY; Availability Id.
	AvailabilityID *string `json:"availabilityId,omitempty"`
	// ParentProductID - READ-ONLY; Parent Product Id.
	ParentProductID *string `json:"parentProductId,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice section id to which this product belongs.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Invoice section name to which this product belongs.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// BillingProfileID - READ-ONLY; Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
}

// MarshalJSON is the custom marshaler for ProductSummaryProperties.
func (psp ProductSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psp.Status != "" {
		objectMap["status"] = psp.Status
	}
	if psp.BillingFrequency != "" {
		objectMap["billingFrequency"] = psp.BillingFrequency
	}
	return json.Marshal(objectMap)
}

// Profile a billing profile resource.
type Profile struct {
	autorest.Response `json:"-"`
	// ProfileProperties - A billing profile.
	*ProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileCreationParameters the parameters for creating a new billing profile.
type ProfileCreationParameters struct {
	// DisplayName - The billing profile name.
	DisplayName *string `json:"displayName,omitempty"`
	// PoNumber - Purchase order number.
	PoNumber *string `json:"poNumber,omitempty"`
	// Address - Billing address.
	Address *Address `json:"address,omitempty"`
	// InvoiceEmailOptIn - If the billing profile is opted in to receive invoices via email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`
	// EnableAzureSKUs - Azure skus to enable for this billing profile..
	EnableAzureSKUs *[]EnabledAzureSKUs `json:"enableAzureSKUs,omitempty"`
}

// ProfileListResult result of listing billing profiles.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing profiles.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProfileListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{fn: getNextPage}
}

// ProfileProperties the properties of the billing profile.
type ProfileProperties struct {
	// DisplayName - The billing profile name.
	DisplayName *string `json:"displayName,omitempty"`
	// PoNumber - Purchase order number.
	PoNumber *string `json:"poNumber,omitempty"`
	// Address - Billing address.
	Address *Address `json:"address,omitempty"`
	// InvoiceEmailOptIn - READ-ONLY; If the billing profile is opted in to receive invoices via email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`
	// IsClassic - READ-ONLY; Is OMS bootstrapped billing profile.
	IsClassic *bool `json:"isClassic,omitempty"`
	// InvoiceDay - READ-ONLY; Invoice day.
	InvoiceDay *int32 `json:"invoiceDay,omitempty"`
	// Currency - READ-ONLY; The currency associated with the billing profile.
	Currency *string `json:"currency,omitempty"`
	// EnabledAzureSKUs - Information about the product.
	EnabledAzureSKUs *[]EnabledAzureSKUs `json:"enabledAzureSKUs,omitempty"`
	// InvoiceSections - The invoice sections associated to the billing profile.
	InvoiceSections *[]InvoiceSection `json:"invoiceSections,omitempty"`
}

// MarshalJSON is the custom marshaler for ProfileProperties.
func (pp ProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.DisplayName != nil {
		objectMap["displayName"] = pp.DisplayName
	}
	if pp.PoNumber != nil {
		objectMap["poNumber"] = pp.PoNumber
	}
	if pp.Address != nil {
		objectMap["address"] = pp.Address
	}
	if pp.EnabledAzureSKUs != nil {
		objectMap["enabledAzureSKUs"] = pp.EnabledAzureSKUs
	}
	if pp.InvoiceSections != nil {
		objectMap["invoiceSections"] = pp.InvoiceSections
	}
	return json.Marshal(objectMap)
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesCreateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.ProfilesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.ProfilesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.ProfilesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Property a billing property resource.
type Property struct {
	autorest.Response `json:"-"`
	// PropertySummary - A billing property.
	*PropertySummary `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Property.
func (p Property) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PropertySummary != nil {
		objectMap["properties"] = p.PropertySummary
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Property struct.
func (p *Property) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertySummary PropertySummary
				err = json.Unmarshal(*v, &propertySummary)
				if err != nil {
					return err
				}
				p.PropertySummary = &propertySummary
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PropertySummary the billing property.
type PropertySummary struct {
	// BillingTenantID - READ-ONLY; Billing tenant Id.
	BillingTenantID *string `json:"billingTenantId,omitempty"`
	// BillingAccountID - READ-ONLY; Billing account Id.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingAccountName - READ-ONLY; Billing account name.
	BillingAccountName *string `json:"billingAccountName,omitempty"`
	// BillingProfileID - READ-ONLY; Billing profile Id.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing profile name.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// CostCenter - READ-ONLY; Cost center name.
	CostCenter *string `json:"costCenter,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice Section Id.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Invoice Section name.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// ProductID - READ-ONLY; Product Id.
	ProductID *string `json:"productId,omitempty"`
	// ProductName - READ-ONLY; Product name.
	ProductName *string `json:"productName,omitempty"`
	// SkuID - READ-ONLY; SKU Id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; SKU description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// RecipientTransferDetails details of the transfer.
type RecipientTransferDetails struct {
	autorest.Response `json:"-"`
	// RecipientTransferProperties - Details of the transfer.
	*RecipientTransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RecipientTransferDetails.
func (rtd RecipientTransferDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rtd.RecipientTransferProperties != nil {
		objectMap["properties"] = rtd.RecipientTransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecipientTransferDetails struct.
func (rtd *RecipientTransferDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recipientTransferProperties RecipientTransferProperties
				err = json.Unmarshal(*v, &recipientTransferProperties)
				if err != nil {
					return err
				}
				rtd.RecipientTransferProperties = &recipientTransferProperties
			}
		}
	}

	return nil
}

// RecipientTransferDetailsListResult result of listing details of the transfer received by caller.
type RecipientTransferDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of transfers received by caller.
	Value *[]RecipientTransferDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecipientTransferDetailsListResultIterator provides access to a complete listing of RecipientTransferDetails
// values.
type RecipientTransferDetailsListResultIterator struct {
	i    int
	page RecipientTransferDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecipientTransferDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecipientTransferDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecipientTransferDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecipientTransferDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecipientTransferDetailsListResultIterator) Response() RecipientTransferDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecipientTransferDetailsListResultIterator) Value() RecipientTransferDetails {
	if !iter.page.NotDone() {
		return RecipientTransferDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecipientTransferDetailsListResultIterator type.
func NewRecipientTransferDetailsListResultIterator(page RecipientTransferDetailsListResultPage) RecipientTransferDetailsListResultIterator {
	return RecipientTransferDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rtdlr RecipientTransferDetailsListResult) IsEmpty() bool {
	return rtdlr.Value == nil || len(*rtdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rtdlr RecipientTransferDetailsListResult) hasNextLink() bool {
	return rtdlr.NextLink != nil && len(*rtdlr.NextLink) != 0
}

// recipientTransferDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rtdlr RecipientTransferDetailsListResult) recipientTransferDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rtdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rtdlr.NextLink)))
}

// RecipientTransferDetailsListResultPage contains a page of RecipientTransferDetails values.
type RecipientTransferDetailsListResultPage struct {
	fn    func(context.Context, RecipientTransferDetailsListResult) (RecipientTransferDetailsListResult, error)
	rtdlr RecipientTransferDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecipientTransferDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecipientTransferDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rtdlr)
		if err != nil {
			return err
		}
		page.rtdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecipientTransferDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecipientTransferDetailsListResultPage) NotDone() bool {
	return !page.rtdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecipientTransferDetailsListResultPage) Response() RecipientTransferDetailsListResult {
	return page.rtdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecipientTransferDetailsListResultPage) Values() []RecipientTransferDetails {
	if page.rtdlr.IsEmpty() {
		return nil
	}
	return *page.rtdlr.Value
}

// Creates a new instance of the RecipientTransferDetailsListResultPage type.
func NewRecipientTransferDetailsListResultPage(getNextPage func(context.Context, RecipientTransferDetailsListResult) (RecipientTransferDetailsListResult, error)) RecipientTransferDetailsListResultPage {
	return RecipientTransferDetailsListResultPage{fn: getNextPage}
}

// RecipientTransferProperties transfer Details.
type RecipientTransferProperties struct {
	// CreationTime - READ-ONLY; Transfer creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExpirationTime - READ-ONLY; Transfer expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// AllowedProductType - READ-ONLY; Type of subscriptions that can be transferred.
	AllowedProductType *[]EligibleProductType `json:"allowedProductType,omitempty"`
	// TransferStatus - READ-ONLY; Overall transfer status. Possible values include: 'TransferStatusPending', 'TransferStatusInProgress', 'TransferStatusCompleted', 'TransferStatusCompletedWithErrors', 'TransferStatusFailed', 'TransferStatusCanceled', 'TransferStatusDeclined'
	TransferStatus TransferStatus `json:"transferStatus,omitempty"`
	// RecipientEmailID - READ-ONLY; Email Id of recipient of transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
	// InitiatorEmailID - READ-ONLY; Email Id of initiator of transfer.
	InitiatorEmailID *string `json:"initiatorEmailId,omitempty"`
	// CanceledBy - READ-ONLY; Email Id who user canceled the transfer.
	CanceledBy *string `json:"canceledBy,omitempty"`
	// LastModifiedTime - READ-ONLY; Transfer last modification time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// DetailedTransferStatus - READ-ONLY; Detailed transfer status.
	DetailedTransferStatus *[]DetailedTransferStatus `json:"detailedTransferStatus,omitempty"`
}

// Reseller details about a reseller.
type Reseller struct {
	// ResellerID - READ-ONLY; The reseller id.
	ResellerID *string `json:"resellerId,omitempty"`
	// Description - READ-ONLY; A description of the reseller.
	Description *string `json:"description,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// RoleAssignment a role assignment
type RoleAssignment struct {
	autorest.Response `json:"-"`
	// RoleAssignmentProperties - The role assignment the caller has
	*RoleAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignment.
func (ra RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RoleAssignmentProperties != nil {
		objectMap["properties"] = ra.RoleAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignment struct.
func (ra *RoleAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignmentProperties RoleAssignmentProperties
				err = json.Unmarshal(*v, &roleAssignmentProperties)
				if err != nil {
					return err
				}
				ra.RoleAssignmentProperties = &roleAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleAssignmentListResult result of get list of role assignments
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list role assignments
	Value *[]RoleAssignment `json:"value,omitempty"`
}

// RoleAssignmentPayload the payload use to update role assignment on a scope
type RoleAssignmentPayload struct {
	// PrincipalID - The user's principal id that the role gets assigned to
	PrincipalID *string `json:"principalId,omitempty"`
	// BillingRoleDefinitionID - The role definition id
	BillingRoleDefinitionID *string `json:"billingRoleDefinitionId,omitempty"`
}

// RoleAssignmentProperties the properties of the a role assignment.
type RoleAssignmentProperties struct {
	// CreatedOn - READ-ONLY; the date the role assignment is created
	CreatedOn *string `json:"createdOn,omitempty"`
	// CreatedByPrincipalTenantID - READ-ONLY; the creator's tenant Id
	CreatedByPrincipalTenantID *string `json:"createdByPrincipalTenantId,omitempty"`
	// CreatedByPrincipalID - READ-ONLY; the creator's principal Id
	CreatedByPrincipalID *string `json:"createdByPrincipalId,omitempty"`
	// Name - READ-ONLY; the name of the role assignment
	Name *string `json:"name,omitempty"`
	// PrincipalID - READ-ONLY; The user's principal id that the role gets assigned to
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionName - READ-ONLY; The role definition id
	RoleDefinitionName *string `json:"roleDefinitionName,omitempty"`
	// Scope - READ-ONLY; The scope the role get assigned to
	Scope *string `json:"scope,omitempty"`
}

// RoleDefinition result of get role definition for a role.
type RoleDefinition struct {
	autorest.Response `json:"-"`
	// RoleDefinitionProperties - The role definition for a role.
	*RoleDefinitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinition.
func (rd RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RoleDefinitionProperties != nil {
		objectMap["properties"] = rd.RoleDefinitionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinition struct.
func (rd *RoleDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleDefinitionProperties RoleDefinitionProperties
				err = json.Unmarshal(*v, &roleDefinitionProperties)
				if err != nil {
					return err
				}
				rd.RoleDefinitionProperties = &roleDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleDefinitionListResult list the role definitions.
type RoleDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of role definitions.
	Value *[]RoleDefinition `json:"value,omitempty"`
}

// RoleDefinitionProperties the properties of the a role definition.
type RoleDefinitionProperties struct {
	// Description - READ-ONLY; The role description
	Description *string `json:"description,omitempty"`
	// PermissionsListResult - The billingPermissions the role has
	*PermissionsListResult `json:"permissions,omitempty"`
	// RoleName - READ-ONLY; The name of the role
	RoleName *string `json:"roleName,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinitionProperties.
func (rdp RoleDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdp.PermissionsListResult != nil {
		objectMap["permissions"] = rdp.PermissionsListResult
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinitionProperties struct.
func (rdp *RoleDefinitionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				rdp.Description = &description
			}
		case "permissions":
			if v != nil {
				var permissionsListResult PermissionsListResult
				err = json.Unmarshal(*v, &permissionsListResult)
				if err != nil {
					return err
				}
				rdp.PermissionsListResult = &permissionsListResult
			}
		case "roleName":
			if v != nil {
				var roleName string
				err = json.Unmarshal(*v, &roleName)
				if err != nil {
					return err
				}
				rdp.RoleName = &roleName
			}
		}
	}

	return nil
}

// SubscriptionProperties the usage context properties.
type SubscriptionProperties struct {
	// DisplayName - READ-ONLY; display name.
	DisplayName *string `json:"displayName,omitempty"`
	// SubscriptionID - READ-ONLY; Subscription Id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// SubscriptionBillingStatus - Subscription billing status. Possible values include: 'SubscriptionStatusTypeActive', 'SubscriptionStatusTypeInactive', 'SubscriptionStatusTypeAbandoned', 'SubscriptionStatusTypeDeleted', 'SubscriptionStatusTypeWarning'
	SubscriptionBillingStatus SubscriptionStatusType `json:"subscriptionBillingStatus,omitempty"`
	// LastMonthCharges - READ-ONLY; Last month charges.
	LastMonthCharges *Amount `json:"lastMonthCharges,omitempty"`
	// MonthToDateCharges - READ-ONLY; Month to date charges.
	MonthToDateCharges *Amount `json:"monthToDateCharges,omitempty"`
	// BillingProfileID - READ-ONLY; Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// CustomerID - READ-ONLY; Customer id to which this product belongs.
	CustomerID *string `json:"customerId,omitempty"`
	// CustomerDisplayName - READ-ONLY; Display name of customer to which this product belongs.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice section id to which this product belongs.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Invoice section name to which this product belongs.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// SkuID - The sku id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
	// Reseller - READ-ONLY; Reseller for this subscription.
	Reseller *Reseller `json:"reseller,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionProperties.
func (sp SubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.SubscriptionBillingStatus != "" {
		objectMap["subscriptionBillingStatus"] = sp.SubscriptionBillingStatus
	}
	if sp.SkuID != nil {
		objectMap["skuId"] = sp.SkuID
	}
	return json.Marshal(objectMap)
}

// SubscriptionsListResult result of listing billing subscriptions summary.
type SubscriptionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing subscriptions summary.
	Value *[]SubscriptionSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionsListResultIterator provides access to a complete listing of SubscriptionSummary values.
type SubscriptionsListResultIterator struct {
	i    int
	page SubscriptionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionsListResultIterator) Response() SubscriptionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionsListResultIterator) Value() SubscriptionSummary {
	if !iter.page.NotDone() {
		return SubscriptionSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionsListResultIterator type.
func NewSubscriptionsListResultIterator(page SubscriptionsListResultPage) SubscriptionsListResultIterator {
	return SubscriptionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubscriptionsListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SubscriptionsListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// subscriptionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubscriptionsListResult) subscriptionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubscriptionsListResultPage contains a page of SubscriptionSummary values.
type SubscriptionsListResultPage struct {
	fn  func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)
	slr SubscriptionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionsListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionsListResultPage) Response() SubscriptionsListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionsListResultPage) Values() []SubscriptionSummary {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubscriptionsListResultPage type.
func NewSubscriptionsListResultPage(getNextPage func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)) SubscriptionsListResultPage {
	return SubscriptionsListResultPage{fn: getNextPage}
}

// SubscriptionsTransferFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubscriptionsTransferFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SubscriptionsTransferFuture) Result(client SubscriptionsClient) (tbsr TransferBillingSubscriptionResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.SubscriptionsTransferFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.SubscriptionsTransferFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tbsr.Response.Response, err = future.GetResult(sender); err == nil && tbsr.Response.Response.StatusCode != http.StatusNoContent {
		tbsr, err = client.TransferResponder(tbsr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.SubscriptionsTransferFuture", "Result", tbsr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SubscriptionSummary a billing Subscription summary resource.
type SubscriptionSummary struct {
	autorest.Response       `json:"-"`
	*SubscriptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionSummary.
func (ss SubscriptionSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.SubscriptionProperties != nil {
		objectMap["properties"] = ss.SubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionSummary struct.
func (ss *SubscriptionSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				ss.SubscriptionProperties = &subscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ss.Type = &typeVar
			}
		}
	}

	return nil
}

// TransactionsListResult result of listing reservation transactions summary.
type TransactionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of reservation transactions summary.
	Value *[]TransactionsSummary `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransactionsListResultIterator provides access to a complete listing of TransactionsSummary values.
type TransactionsListResultIterator struct {
	i    int
	page TransactionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransactionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransactionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransactionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransactionsListResultIterator) Response() TransactionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransactionsListResultIterator) Value() TransactionsSummary {
	if !iter.page.NotDone() {
		return TransactionsSummary{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransactionsListResultIterator type.
func NewTransactionsListResultIterator(page TransactionsListResultPage) TransactionsListResultIterator {
	return TransactionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TransactionsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TransactionsListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// transactionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TransactionsListResult) transactionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TransactionsListResultPage contains a page of TransactionsSummary values.
type TransactionsListResultPage struct {
	fn  func(context.Context, TransactionsListResult) (TransactionsListResult, error)
	tlr TransactionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransactionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransactionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransactionsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransactionsListResultPage) Response() TransactionsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransactionsListResultPage) Values() []TransactionsSummary {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TransactionsListResultPage type.
func NewTransactionsListResultPage(getNextPage func(context.Context, TransactionsListResult) (TransactionsListResult, error)) TransactionsListResultPage {
	return TransactionsListResultPage{fn: getNextPage}
}

// TransactionsSummary a reservation transaction summary resource.
type TransactionsSummary struct {
	*TransactionsSummaryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionsSummary.
func (ts TransactionsSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.TransactionsSummaryProperties != nil {
		objectMap["properties"] = ts.TransactionsSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransactionsSummary struct.
func (ts *TransactionsSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transactionsSummaryProperties TransactionsSummaryProperties
				err = json.Unmarshal(*v, &transactionsSummaryProperties)
				if err != nil {
					return err
				}
				ts.TransactionsSummaryProperties = &transactionsSummaryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		}
	}

	return nil
}

// TransactionsSummaryProperties the properties of the reservation transaction summary.
type TransactionsSummaryProperties struct {
	// Kind - The kind of transaction. Choices are all and reservation. Possible values include: 'All', 'Reservation'
	Kind TransactionTypeKind `json:"kind,omitempty"`
	// Date - READ-ONLY; The date of reservation transaction.
	Date *date.Time `json:"date,omitempty"`
	// Invoice - READ-ONLY; Invoice number or 'pending' if not invoiced.
	Invoice *string `json:"invoice,omitempty"`
	// OrderID - READ-ONLY; The reservation order id.
	OrderID *string `json:"orderId,omitempty"`
	// OrderName - READ-ONLY; The reservation order name.
	OrderName *string `json:"orderName,omitempty"`
	// ProductFamily - READ-ONLY; The product family.
	ProductFamily *string `json:"productFamily,omitempty"`
	// ProductTypeID - READ-ONLY; The product type id.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - READ-ONLY; The type of product.
	ProductType *string `json:"productType,omitempty"`
	// ProductDescription - READ-ONLY; Product description.
	ProductDescription *string `json:"productDescription,omitempty"`
	// TransactionType - Transaction types. Possible values include: 'Purchase', 'UsageCharge'
	TransactionType ReservationType `json:"transactionType,omitempty"`
	// TransactionAmount - READ-ONLY; Last charge associated with the purchase.
	TransactionAmount *Amount `json:"transactionAmount,omitempty"`
	// Quantity - READ-ONLY; Purchase quantity.
	Quantity *int32 `json:"quantity,omitempty"`
	// CustomerID - READ-ONLY; Customer id to which this product belongs.
	CustomerID *string `json:"customerId,omitempty"`
	// CustomerDisplayName - READ-ONLY; Display name of customer to which this product belongs.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty"`
	// InvoiceSectionID - READ-ONLY; Invoice section id to which this product belongs.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionName - READ-ONLY; Invoice section name to which this product belongs.
	InvoiceSectionName *string `json:"invoiceSectionName,omitempty"`
	// BillingProfileID - READ-ONLY; Billing Profile id to which this product belongs.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileName - READ-ONLY; Billing Profile name to which this product belongs.
	BillingProfileName *string `json:"billingProfileName,omitempty"`
	// SubscriptionID - READ-ONLY; The subscription id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SubscriptionName - READ-ONLY; The subscription name.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
}

// MarshalJSON is the custom marshaler for TransactionsSummaryProperties.
func (tsp TransactionsSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsp.Kind != "" {
		objectMap["kind"] = tsp.Kind
	}
	if tsp.TransactionType != "" {
		objectMap["transactionType"] = tsp.TransactionType
	}
	return json.Marshal(objectMap)
}

// TransferBillingSubscriptionRequest request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequest struct {
	// TransferBillingSubscriptionRequestProperties - Request parameters to transfer billing subscription.
	*TransferBillingSubscriptionRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferBillingSubscriptionRequest.
func (tbsr TransferBillingSubscriptionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tbsr.TransferBillingSubscriptionRequestProperties != nil {
		objectMap["properties"] = tbsr.TransferBillingSubscriptionRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferBillingSubscriptionRequest struct.
func (tbsr *TransferBillingSubscriptionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferBillingSubscriptionRequestProperties TransferBillingSubscriptionRequestProperties
				err = json.Unmarshal(*v, &transferBillingSubscriptionRequestProperties)
				if err != nil {
					return err
				}
				tbsr.TransferBillingSubscriptionRequestProperties = &transferBillingSubscriptionRequestProperties
			}
		}
	}

	return nil
}

// TransferBillingSubscriptionRequestProperties request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequestProperties struct {
	// DestinationInvoiceSectionID - The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
	// DestinationBillingProfileID - The destination billing profile id.
	DestinationBillingProfileID *string `json:"destinationBillingProfileId,omitempty"`
}

// TransferBillingSubscriptionResult request parameters to transfer billing subscription.
type TransferBillingSubscriptionResult struct {
	autorest.Response `json:"-"`
	// TransferBillingSubscriptionResultProperties - Request parameters to transfer billing subscription.
	*TransferBillingSubscriptionResultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferBillingSubscriptionResult.
func (tbsr TransferBillingSubscriptionResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tbsr.TransferBillingSubscriptionResultProperties != nil {
		objectMap["properties"] = tbsr.TransferBillingSubscriptionResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferBillingSubscriptionResult struct.
func (tbsr *TransferBillingSubscriptionResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferBillingSubscriptionResultProperties TransferBillingSubscriptionResultProperties
				err = json.Unmarshal(*v, &transferBillingSubscriptionResultProperties)
				if err != nil {
					return err
				}
				tbsr.TransferBillingSubscriptionResultProperties = &transferBillingSubscriptionResultProperties
			}
		}
	}

	return nil
}

// TransferBillingSubscriptionResultProperties transfer billing subscription result properties.
type TransferBillingSubscriptionResultProperties struct {
	// BillingSubscriptionName - The destination billing subscription id.
	BillingSubscriptionName *string `json:"billingSubscriptionName,omitempty"`
}

// TransferDetails details of the transfer.
type TransferDetails struct {
	autorest.Response `json:"-"`
	// TransferProperties - Details of the transfer.
	*TransferProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TransferDetails.
func (td TransferDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if td.TransferProperties != nil {
		objectMap["properties"] = td.TransferProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransferDetails struct.
func (td *TransferDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transferProperties TransferProperties
				err = json.Unmarshal(*v, &transferProperties)
				if err != nil {
					return err
				}
				td.TransferProperties = &transferProperties
			}
		}
	}

	return nil
}

// TransferDetailsListResult result of listing details of the transfer initiated by caller.
type TransferDetailsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of transfers initiated by caller.
	Value *[]TransferDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransferDetailsListResultIterator provides access to a complete listing of TransferDetails values.
type TransferDetailsListResultIterator struct {
	i    int
	page TransferDetailsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransferDetailsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransferDetailsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransferDetailsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransferDetailsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransferDetailsListResultIterator) Response() TransferDetailsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransferDetailsListResultIterator) Value() TransferDetails {
	if !iter.page.NotDone() {
		return TransferDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransferDetailsListResultIterator type.
func NewTransferDetailsListResultIterator(page TransferDetailsListResultPage) TransferDetailsListResultIterator {
	return TransferDetailsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tdlr TransferDetailsListResult) IsEmpty() bool {
	return tdlr.Value == nil || len(*tdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tdlr TransferDetailsListResult) hasNextLink() bool {
	return tdlr.NextLink != nil && len(*tdlr.NextLink) != 0
}

// transferDetailsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tdlr TransferDetailsListResult) transferDetailsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tdlr.NextLink)))
}

// TransferDetailsListResultPage contains a page of TransferDetails values.
type TransferDetailsListResultPage struct {
	fn   func(context.Context, TransferDetailsListResult) (TransferDetailsListResult, error)
	tdlr TransferDetailsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransferDetailsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransferDetailsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tdlr)
		if err != nil {
			return err
		}
		page.tdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransferDetailsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransferDetailsListResultPage) NotDone() bool {
	return !page.tdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransferDetailsListResultPage) Response() TransferDetailsListResult {
	return page.tdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransferDetailsListResultPage) Values() []TransferDetails {
	if page.tdlr.IsEmpty() {
		return nil
	}
	return *page.tdlr.Value
}

// Creates a new instance of the TransferDetailsListResultPage type.
func NewTransferDetailsListResultPage(getNextPage func(context.Context, TransferDetailsListResult) (TransferDetailsListResult, error)) TransferDetailsListResultPage {
	return TransferDetailsListResultPage{fn: getNextPage}
}

// TransferProductRequestProperties the properties of the product to initiate a transfer.
type TransferProductRequestProperties struct {
	// DestinationInvoiceSectionID - The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
	// DestinationBillingProfileID - The destination billing profile id.
	DestinationBillingProfileID *string `json:"destinationBillingProfileId,omitempty"`
}

// TransferProperties transfer details
type TransferProperties struct {
	// CreationTime - READ-ONLY; Transfer creation time.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// ExpirationTime - READ-ONLY; Transfer expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// InvoiceSectionID - READ-ONLY; Target invoice section Id.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// BillingAccountID - READ-ONLY; Target billing account Id.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// TransferStatus - READ-ONLY; Overall transfer status. Possible values include: 'TransferStatusPending', 'TransferStatusInProgress', 'TransferStatusCompleted', 'TransferStatusCompletedWithErrors', 'TransferStatusFailed', 'TransferStatusCanceled', 'TransferStatusDeclined'
	TransferStatus TransferStatus `json:"transferStatus,omitempty"`
	// RecipientEmailID - READ-ONLY; Email Id of recipient of transfer.
	RecipientEmailID *string `json:"recipientEmailId,omitempty"`
	// InitiatorEmailID - READ-ONLY; Email Id of initiator of transfer.
	InitiatorEmailID *string `json:"initiatorEmailId,omitempty"`
	// CanceledBy - READ-ONLY; Email Id who user canceled the transfer.
	CanceledBy *string `json:"canceledBy,omitempty"`
	// LastModifiedTime - READ-ONLY; Transfer last modification time.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// DetailedTransferStatus - READ-ONLY; Detailed transfer status.
	DetailedTransferStatus *[]DetailedTransferStatus `json:"detailedTransferStatus,omitempty"`
}

// UpdateAutoRenewOperationSummary summary of cancel product operation
type UpdateAutoRenewOperationSummary struct {
	autorest.Response `json:"-"`
	// UpdateAutoRenewOperationSummaryProperties - Summary of update auto renew operation summary properties
	*UpdateAutoRenewOperationSummaryProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateAutoRenewOperationSummary.
func (uaros UpdateAutoRenewOperationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uaros.UpdateAutoRenewOperationSummaryProperties != nil {
		objectMap["properties"] = uaros.UpdateAutoRenewOperationSummaryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateAutoRenewOperationSummary struct.
func (uaros *UpdateAutoRenewOperationSummary) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateAutoRenewOperationSummaryProperties UpdateAutoRenewOperationSummaryProperties
				err = json.Unmarshal(*v, &updateAutoRenewOperationSummaryProperties)
				if err != nil {
					return err
				}
				uaros.UpdateAutoRenewOperationSummaryProperties = &updateAutoRenewOperationSummaryProperties
			}
		}
	}

	return nil
}

// UpdateAutoRenewOperationSummaryProperties update auto renew operation summary properties
type UpdateAutoRenewOperationSummaryProperties struct {
	// EndDate - The end date of this asset
	EndDate *date.Time `json:"endDate,omitempty"`
}

// UpdateAutoRenewRequest request parameters to update auto renew for support product.
type UpdateAutoRenewRequest struct {
	// AutoRenew - Request parameters to update auto renew policy a product. Possible values include: 'True', 'False'
	AutoRenew UpdateAutoRenew `json:"autoRenew,omitempty"`
}

// ValidateAddressResponse result of the address validation
type ValidateAddressResponse struct {
	autorest.Response `json:"-"`
	// Status - status of the address validation. Possible values include: 'Valid', 'Invalid'
	Status AddressValidationStatus `json:"status,omitempty"`
	// SuggestedAddresses - list of suggested addresses.
	SuggestedAddresses *[]Address `json:"suggestedAddresses,omitempty"`
	// ValidationMessage - Validation error message.
	ValidationMessage *string `json:"validationMessage,omitempty"`
}

// ValidateProductTransferEligibilityError error details of the product transfer eligibility validation.
type ValidateProductTransferEligibilityError struct {
	// Code - Error code for the product transfer validation. Possible values include: 'InvalidSource', 'ProductNotActive', 'InsufficientPermissionOnSource', 'InsufficientPermissionOnDestination', 'DestinationBillingProfilePastDue', 'ProductTypeNotSupported', 'CrossBillingAccountNotAllowed', 'NotAvailableForDestinationMarket', 'OneTimePurchaseProductTransferNotAllowed'
	Code ProductTransferValidationErrorCode `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`
}

// ValidateProductTransferEligibilityResult result of the product transfer eligibility validation.
type ValidateProductTransferEligibilityResult struct {
	autorest.Response `json:"-"`
	// IsTransferEligible - READ-ONLY; Specifies whether the transfer is eligible or not.
	IsTransferEligible *bool `json:"isTransferEligible,omitempty"`
	// ErrorDetails - Validation error details.
	ErrorDetails *ValidateProductTransferEligibilityError `json:"errorDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateProductTransferEligibilityResult.
func (vpter ValidateProductTransferEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vpter.ErrorDetails != nil {
		objectMap["errorDetails"] = vpter.ErrorDetails
	}
	return json.Marshal(objectMap)
}

// ValidateSubscriptionTransferEligibilityError error details of the transfer eligibility validation
type ValidateSubscriptionTransferEligibilityError struct {
	// Code - Error code for the product transfer validation. Possible values include: 'SubscriptionTransferValidationErrorCodeInvalidSource', 'SubscriptionTransferValidationErrorCodeSubscriptionNotActive', 'SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource', 'SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination', 'SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue', 'SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported', 'SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed', 'SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket'
	Code SubscriptionTransferValidationErrorCode `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`
}

// ValidateSubscriptionTransferEligibilityResult result of the transfer eligibility validation.
type ValidateSubscriptionTransferEligibilityResult struct {
	autorest.Response `json:"-"`
	// IsTransferEligible - READ-ONLY; Specifies whether the transfer is eligible or not.
	IsTransferEligible *bool `json:"isTransferEligible,omitempty"`
	// ErrorDetails - Validation error details.
	ErrorDetails *ValidateSubscriptionTransferEligibilityError `json:"errorDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateSubscriptionTransferEligibilityResult.
func (vster ValidateSubscriptionTransferEligibilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vster.ErrorDetails != nil {
		objectMap["errorDetails"] = vster.ErrorDetails
	}
	return json.Marshal(objectMap)
}
