package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadBizview invokes the baas.DownloadBizview API synchronously
// api document: https://help.aliyun.com/api/baas/downloadbizview.html
func (client *Client) DownloadBizview(request *DownloadBizviewRequest) (response *DownloadBizviewResponse, err error) {
	response = CreateDownloadBizviewResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadBizviewWithChan invokes the baas.DownloadBizview API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadbizview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadBizviewWithChan(request *DownloadBizviewRequest) (<-chan *DownloadBizviewResponse, <-chan error) {
	responseChan := make(chan *DownloadBizviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadBizview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadBizviewWithCallback invokes the baas.DownloadBizview API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadbizview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadBizviewWithCallback(request *DownloadBizviewRequest, callback func(response *DownloadBizviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadBizviewResponse
		var err error
		defer close(result)
		response, err = client.DownloadBizview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadBizviewRequest is the request struct for api DownloadBizview
type DownloadBizviewRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DownloadBizviewResponse is the response struct for api DownloadBizview
type DownloadBizviewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDownloadBizviewRequest creates a request to invoke DownloadBizview API
func CreateDownloadBizviewRequest() (request *DownloadBizviewRequest) {
	request = &DownloadBizviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DownloadBizview", "", "")
	return
}

// CreateDownloadBizviewResponse creates a response to parse from DownloadBizview response
func CreateDownloadBizviewResponse() (response *DownloadBizviewResponse) {
	response = &DownloadBizviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
