/*
Copyright 2017 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Package attachment to manage Kubernetes storage attach events.
package attachment

import (
	"reflect"

	rook "github.com/rook/rook/pkg/apis/rook.io"
	rookalpha "github.com/rook/rook/pkg/apis/rook.io/v1alpha2"
	"github.com/rook/rook/pkg/operator/k8sutil"
)

const (
	CustomResourceName       = "volume"
	CustomResourceNamePlural = "volumes"
)

// VolumeResource represents the Volume custom resource object
var VolumeResource = k8sutil.CustomResource{
	Name:    CustomResourceName,
	Plural:  CustomResourceNamePlural,
	Group:   rook.CustomResourceGroupName,
	Version: rookalpha.Version,
	Kind:    reflect.TypeOf(rookalpha.Volume{}).Name(),
}
