// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package braket

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelQuantumTask = "CancelQuantumTask"

// CancelQuantumTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelQuantumTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelQuantumTask for more information on using the CancelQuantumTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelQuantumTaskRequest method.
//    req, resp := client.CancelQuantumTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelQuantumTask
func (c *Braket) CancelQuantumTaskRequest(input *CancelQuantumTaskInput) (req *request.Request, output *CancelQuantumTaskOutput) {
	op := &request.Operation{
		Name:       opCancelQuantumTask,
		HTTPMethod: "PUT",
		HTTPPath:   "/quantum-task/{quantumTaskArn}/cancel",
	}

	if input == nil {
		input = &CancelQuantumTaskInput{}
	}

	output = &CancelQuantumTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelQuantumTask API operation for Braket.
//
// Cancels the specified task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation CancelQuantumTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ConflictException
//   An error occurred due to a conflict.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CancelQuantumTask
func (c *Braket) CancelQuantumTask(input *CancelQuantumTaskInput) (*CancelQuantumTaskOutput, error) {
	req, out := c.CancelQuantumTaskRequest(input)
	return out, req.Send()
}

// CancelQuantumTaskWithContext is the same as CancelQuantumTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelQuantumTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) CancelQuantumTaskWithContext(ctx aws.Context, input *CancelQuantumTaskInput, opts ...request.Option) (*CancelQuantumTaskOutput, error) {
	req, out := c.CancelQuantumTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQuantumTask = "CreateQuantumTask"

// CreateQuantumTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateQuantumTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQuantumTask for more information on using the CreateQuantumTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateQuantumTaskRequest method.
//    req, resp := client.CreateQuantumTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateQuantumTask
func (c *Braket) CreateQuantumTaskRequest(input *CreateQuantumTaskInput) (req *request.Request, output *CreateQuantumTaskOutput) {
	op := &request.Operation{
		Name:       opCreateQuantumTask,
		HTTPMethod: "POST",
		HTTPPath:   "/quantum-task",
	}

	if input == nil {
		input = &CreateQuantumTaskInput{}
	}

	output = &CreateQuantumTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQuantumTask API operation for Braket.
//
// Creates a quantum task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation CreateQuantumTask for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * DeviceOfflineException
//   The specified device is currently offline.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ServiceQuotaExceededException
//   The request failed because a service quota is exceeded.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/CreateQuantumTask
func (c *Braket) CreateQuantumTask(input *CreateQuantumTaskInput) (*CreateQuantumTaskOutput, error) {
	req, out := c.CreateQuantumTaskRequest(input)
	return out, req.Send()
}

// CreateQuantumTaskWithContext is the same as CreateQuantumTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQuantumTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) CreateQuantumTaskWithContext(ctx aws.Context, input *CreateQuantumTaskInput, opts ...request.Option) (*CreateQuantumTaskOutput, error) {
	req, out := c.CreateQuantumTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevice for more information on using the GetDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetDevice
func (c *Braket) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/device/{deviceArn}",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for Braket.
//
// Retrieves the devices available in Amazon Braket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation GetDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * DeviceOfflineException
//   The specified device is currently offline.
//
//   * DeviceRetiredException
//   The specified device has been retired.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetDevice
func (c *Braket) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	return out, req.Send()
}

// GetDeviceWithContext is the same as GetDevice with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) GetDeviceWithContext(ctx aws.Context, input *GetDeviceInput, opts ...request.Option) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQuantumTask = "GetQuantumTask"

// GetQuantumTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetQuantumTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQuantumTask for more information on using the GetQuantumTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQuantumTaskRequest method.
//    req, resp := client.GetQuantumTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetQuantumTask
func (c *Braket) GetQuantumTaskRequest(input *GetQuantumTaskInput) (req *request.Request, output *GetQuantumTaskOutput) {
	op := &request.Operation{
		Name:       opGetQuantumTask,
		HTTPMethod: "GET",
		HTTPPath:   "/quantum-task/{quantumTaskArn}",
	}

	if input == nil {
		input = &GetQuantumTaskInput{}
	}

	output = &GetQuantumTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQuantumTask API operation for Braket.
//
// Retrieves the specified quantum task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation GetQuantumTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/GetQuantumTask
func (c *Braket) GetQuantumTask(input *GetQuantumTaskInput) (*GetQuantumTaskOutput, error) {
	req, out := c.GetQuantumTaskRequest(input)
	return out, req.Send()
}

// GetQuantumTaskWithContext is the same as GetQuantumTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetQuantumTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) GetQuantumTaskWithContext(ctx aws.Context, input *GetQuantumTaskInput, opts ...request.Option) (*GetQuantumTaskOutput, error) {
	req, out := c.GetQuantumTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/ListTagsForResource
func (c *Braket) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Braket.
//
// Shows the tags associated with this resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/ListTagsForResource
func (c *Braket) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchDevices = "SearchDevices"

// SearchDevicesRequest generates a "aws/request.Request" representing the
// client's request for the SearchDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDevices for more information on using the SearchDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchDevicesRequest method.
//    req, resp := client.SearchDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices
func (c *Braket) SearchDevicesRequest(input *SearchDevicesInput) (req *request.Request, output *SearchDevicesOutput) {
	op := &request.Operation{
		Name:       opSearchDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/devices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDevicesInput{}
	}

	output = &SearchDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDevices API operation for Braket.
//
// Searches for devices using the specified filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation SearchDevices for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchDevices
func (c *Braket) SearchDevices(input *SearchDevicesInput) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	return out, req.Send()
}

// SearchDevicesWithContext is the same as SearchDevices with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) SearchDevicesWithContext(ctx aws.Context, input *SearchDevicesInput, opts ...request.Option) (*SearchDevicesOutput, error) {
	req, out := c.SearchDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDevicesPages iterates over the pages of a SearchDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchDevices operation.
//    pageNum := 0
//    err := client.SearchDevicesPages(params,
//        func(page *braket.SearchDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Braket) SearchDevicesPages(input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool) error {
	return c.SearchDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDevicesPagesWithContext same as SearchDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) SearchDevicesPagesWithContext(ctx aws.Context, input *SearchDevicesInput, fn func(*SearchDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchQuantumTasks = "SearchQuantumTasks"

// SearchQuantumTasksRequest generates a "aws/request.Request" representing the
// client's request for the SearchQuantumTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchQuantumTasks for more information on using the SearchQuantumTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchQuantumTasksRequest method.
//    req, resp := client.SearchQuantumTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks
func (c *Braket) SearchQuantumTasksRequest(input *SearchQuantumTasksInput) (req *request.Request, output *SearchQuantumTasksOutput) {
	op := &request.Operation{
		Name:       opSearchQuantumTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/quantum-tasks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchQuantumTasksInput{}
	}

	output = &SearchQuantumTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchQuantumTasks API operation for Braket.
//
// Searches for tasks that match the specified filter values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation SearchQuantumTasks for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   The throttling rate limit is met.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/SearchQuantumTasks
func (c *Braket) SearchQuantumTasks(input *SearchQuantumTasksInput) (*SearchQuantumTasksOutput, error) {
	req, out := c.SearchQuantumTasksRequest(input)
	return out, req.Send()
}

// SearchQuantumTasksWithContext is the same as SearchQuantumTasks with the addition of
// the ability to pass a context and additional request options.
//
// See SearchQuantumTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) SearchQuantumTasksWithContext(ctx aws.Context, input *SearchQuantumTasksInput, opts ...request.Option) (*SearchQuantumTasksOutput, error) {
	req, out := c.SearchQuantumTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchQuantumTasksPages iterates over the pages of a SearchQuantumTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchQuantumTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchQuantumTasks operation.
//    pageNum := 0
//    err := client.SearchQuantumTasksPages(params,
//        func(page *braket.SearchQuantumTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Braket) SearchQuantumTasksPages(input *SearchQuantumTasksInput, fn func(*SearchQuantumTasksOutput, bool) bool) error {
	return c.SearchQuantumTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchQuantumTasksPagesWithContext same as SearchQuantumTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) SearchQuantumTasksPagesWithContext(ctx aws.Context, input *SearchQuantumTasksInput, fn func(*SearchQuantumTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchQuantumTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchQuantumTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchQuantumTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/TagResource
func (c *Braket) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Braket.
//
// Add a tag to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/TagResource
func (c *Braket) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/UntagResource
func (c *Braket) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Braket.
//
// Remove tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Braket's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InternalServiceException
//   The request processing has failed because of an unknown error, exception,
//   or failure.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/UntagResource
func (c *Braket) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Braket) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelQuantumTaskInput struct {
	_ struct{} `type:"structure"`

	// The client token associated with the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the task to cancel.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `location:"uri" locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelQuantumTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelQuantumTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelQuantumTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelQuantumTaskInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.QuantumTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("QuantumTaskArn"))
	}
	if s.QuantumTaskArn != nil && len(*s.QuantumTaskArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuantumTaskArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CancelQuantumTaskInput) SetClientToken(v string) *CancelQuantumTaskInput {
	s.ClientToken = &v
	return s
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *CancelQuantumTaskInput) SetQuantumTaskArn(v string) *CancelQuantumTaskInput {
	s.QuantumTaskArn = &v
	return s
}

type CancelQuantumTaskOutput struct {
	_ struct{} `type:"structure"`

	// The status of the cancellation request.
	//
	// CancellationStatus is a required field
	CancellationStatus *string `locationName:"cancellationStatus" type:"string" required:"true" enum:"CancellationStatus"`

	// The ARN of the task.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelQuantumTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelQuantumTaskOutput) GoString() string {
	return s.String()
}

// SetCancellationStatus sets the CancellationStatus field's value.
func (s *CancelQuantumTaskOutput) SetCancellationStatus(v string) *CancelQuantumTaskOutput {
	s.CancellationStatus = &v
	return s
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *CancelQuantumTaskOutput) SetQuantumTaskArn(v string) *CancelQuantumTaskOutput {
	s.QuantumTaskArn = &v
	return s
}

// An error occurred due to a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateQuantumTaskInput struct {
	_ struct{} `type:"structure"`

	// The action associated with the task.
	//
	// Action is a required field
	Action aws.JSONValue `locationName:"action" type:"jsonvalue" required:"true"`

	// The client token associated with the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the device to run the task on.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"1" type:"string" required:"true"`

	// The parameters for the device to run the task on.
	DeviceParameters aws.JSONValue `locationName:"deviceParameters" type:"jsonvalue"`

	// The S3 bucket to store task result files in.
	//
	// OutputS3Bucket is a required field
	OutputS3Bucket *string `locationName:"outputS3Bucket" min:"3" type:"string" required:"true"`

	// The key prefix for the location in the S3 bucket to store task results in.
	//
	// OutputS3KeyPrefix is a required field
	OutputS3KeyPrefix *string `locationName:"outputS3KeyPrefix" min:"1" type:"string" required:"true"`

	// The number of shots to use for the task.
	//
	// Shots is a required field
	Shots *int64 `locationName:"shots" type:"long" required:"true"`

	// Tags to be added to the quantum task you're creating.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateQuantumTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQuantumTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQuantumTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQuantumTaskInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.DeviceArn != nil && len(*s.DeviceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceArn", 1))
	}
	if s.OutputS3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Bucket"))
	}
	if s.OutputS3Bucket != nil && len(*s.OutputS3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3Bucket", 3))
	}
	if s.OutputS3KeyPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3KeyPrefix"))
	}
	if s.OutputS3KeyPrefix != nil && len(*s.OutputS3KeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3KeyPrefix", 1))
	}
	if s.Shots == nil {
		invalidParams.Add(request.NewErrParamRequired("Shots"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateQuantumTaskInput) SetAction(v aws.JSONValue) *CreateQuantumTaskInput {
	s.Action = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateQuantumTaskInput) SetClientToken(v string) *CreateQuantumTaskInput {
	s.ClientToken = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *CreateQuantumTaskInput) SetDeviceArn(v string) *CreateQuantumTaskInput {
	s.DeviceArn = &v
	return s
}

// SetDeviceParameters sets the DeviceParameters field's value.
func (s *CreateQuantumTaskInput) SetDeviceParameters(v aws.JSONValue) *CreateQuantumTaskInput {
	s.DeviceParameters = v
	return s
}

// SetOutputS3Bucket sets the OutputS3Bucket field's value.
func (s *CreateQuantumTaskInput) SetOutputS3Bucket(v string) *CreateQuantumTaskInput {
	s.OutputS3Bucket = &v
	return s
}

// SetOutputS3KeyPrefix sets the OutputS3KeyPrefix field's value.
func (s *CreateQuantumTaskInput) SetOutputS3KeyPrefix(v string) *CreateQuantumTaskInput {
	s.OutputS3KeyPrefix = &v
	return s
}

// SetShots sets the Shots field's value.
func (s *CreateQuantumTaskInput) SetShots(v int64) *CreateQuantumTaskInput {
	s.Shots = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQuantumTaskInput) SetTags(v map[string]*string) *CreateQuantumTaskInput {
	s.Tags = v
	return s
}

type CreateQuantumTaskOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the task created by the request.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateQuantumTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQuantumTaskOutput) GoString() string {
	return s.String()
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *CreateQuantumTaskOutput) SetQuantumTaskArn(v string) *CreateQuantumTaskOutput {
	s.QuantumTaskArn = &v
	return s
}

// The specified device is currently offline.
type DeviceOfflineException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DeviceOfflineException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceOfflineException) GoString() string {
	return s.String()
}

func newErrorDeviceOfflineException(v protocol.ResponseMetadata) error {
	return &DeviceOfflineException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeviceOfflineException) Code() string {
	return "DeviceOfflineException"
}

// Message returns the exception's message.
func (s *DeviceOfflineException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeviceOfflineException) OrigErr() error {
	return nil
}

func (s *DeviceOfflineException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeviceOfflineException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeviceOfflineException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified device has been retired.
type DeviceRetiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DeviceRetiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceRetiredException) GoString() string {
	return s.String()
}

func newErrorDeviceRetiredException(v protocol.ResponseMetadata) error {
	return &DeviceRetiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DeviceRetiredException) Code() string {
	return "DeviceRetiredException"
}

// Message returns the exception's message.
func (s *DeviceRetiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DeviceRetiredException) OrigErr() error {
	return nil
}

func (s *DeviceRetiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DeviceRetiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DeviceRetiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Includes information about the device.
type DeviceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the device.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"1" type:"string" required:"true"`

	// The name of the device.
	//
	// DeviceName is a required field
	DeviceName *string `locationName:"deviceName" type:"string" required:"true"`

	// The status of the device.
	//
	// DeviceStatus is a required field
	DeviceStatus *string `locationName:"deviceStatus" type:"string" required:"true" enum:"DeviceStatus"`

	// The type of the device.
	//
	// DeviceType is a required field
	DeviceType *string `locationName:"deviceType" type:"string" required:"true" enum:"DeviceType"`

	// The provider of the device.
	//
	// ProviderName is a required field
	ProviderName *string `locationName:"providerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceSummary) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *DeviceSummary) SetDeviceArn(v string) *DeviceSummary {
	s.DeviceArn = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *DeviceSummary) SetDeviceName(v string) *DeviceSummary {
	s.DeviceName = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *DeviceSummary) SetDeviceStatus(v string) *DeviceSummary {
	s.DeviceStatus = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceSummary) SetDeviceType(v string) *DeviceSummary {
	s.DeviceType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DeviceSummary) SetProviderName(v string) *DeviceSummary {
	s.ProviderName = &v
	return s
}

type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to retrieve.
	//
	// DeviceArn is a required field
	DeviceArn *string `location:"uri" locationName:"deviceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.DeviceArn != nil && len(*s.DeviceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *GetDeviceInput) SetDeviceArn(v string) *GetDeviceInput {
	s.DeviceArn = &v
	return s
}

type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"1" type:"string" required:"true"`

	// Details about the capabilities of the device.
	//
	// DeviceCapabilities is a required field
	DeviceCapabilities aws.JSONValue `locationName:"deviceCapabilities" type:"jsonvalue" required:"true"`

	// The name of the device.
	//
	// DeviceName is a required field
	DeviceName *string `locationName:"deviceName" type:"string" required:"true"`

	// The status of the device.
	//
	// DeviceStatus is a required field
	DeviceStatus *string `locationName:"deviceStatus" type:"string" required:"true" enum:"DeviceStatus"`

	// The type of the device.
	//
	// DeviceType is a required field
	DeviceType *string `locationName:"deviceType" type:"string" required:"true" enum:"DeviceType"`

	// The name of the partner company for the device.
	//
	// ProviderName is a required field
	ProviderName *string `locationName:"providerName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *GetDeviceOutput) SetDeviceArn(v string) *GetDeviceOutput {
	s.DeviceArn = &v
	return s
}

// SetDeviceCapabilities sets the DeviceCapabilities field's value.
func (s *GetDeviceOutput) SetDeviceCapabilities(v aws.JSONValue) *GetDeviceOutput {
	s.DeviceCapabilities = v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *GetDeviceOutput) SetDeviceName(v string) *GetDeviceOutput {
	s.DeviceName = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *GetDeviceOutput) SetDeviceStatus(v string) *GetDeviceOutput {
	s.DeviceStatus = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *GetDeviceOutput) SetDeviceType(v string) *GetDeviceOutput {
	s.DeviceType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *GetDeviceOutput) SetProviderName(v string) *GetDeviceOutput {
	s.ProviderName = &v
	return s
}

type GetQuantumTaskInput struct {
	_ struct{} `type:"structure"`

	// the ARN of the task to retrieve.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `location:"uri" locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQuantumTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQuantumTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQuantumTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQuantumTaskInput"}
	if s.QuantumTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("QuantumTaskArn"))
	}
	if s.QuantumTaskArn != nil && len(*s.QuantumTaskArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuantumTaskArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *GetQuantumTaskInput) SetQuantumTaskArn(v string) *GetQuantumTaskInput {
	s.QuantumTaskArn = &v
	return s
}

type GetQuantumTaskOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the task was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the device the task was run on.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"1" type:"string" required:"true"`

	// The parameters for the device on which the task ran.
	//
	// DeviceParameters is a required field
	DeviceParameters aws.JSONValue `locationName:"deviceParameters" type:"jsonvalue" required:"true"`

	// The time at which the task ended.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The reason that a task failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The S3 bucket where task results are stored.
	//
	// OutputS3Bucket is a required field
	OutputS3Bucket *string `locationName:"outputS3Bucket" type:"string" required:"true"`

	// The folder in the S3 bucket where task results are stored.
	//
	// OutputS3Directory is a required field
	OutputS3Directory *string `locationName:"outputS3Directory" type:"string" required:"true"`

	// The ARN of the task.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`

	// The number of shots used in the task.
	//
	// Shots is a required field
	Shots *int64 `locationName:"shots" type:"long" required:"true"`

	// The status of the task.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QuantumTaskStatus"`

	// The tags that belong to this task.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetQuantumTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQuantumTaskOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetQuantumTaskOutput) SetCreatedAt(v time.Time) *GetQuantumTaskOutput {
	s.CreatedAt = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *GetQuantumTaskOutput) SetDeviceArn(v string) *GetQuantumTaskOutput {
	s.DeviceArn = &v
	return s
}

// SetDeviceParameters sets the DeviceParameters field's value.
func (s *GetQuantumTaskOutput) SetDeviceParameters(v aws.JSONValue) *GetQuantumTaskOutput {
	s.DeviceParameters = v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetQuantumTaskOutput) SetEndedAt(v time.Time) *GetQuantumTaskOutput {
	s.EndedAt = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetQuantumTaskOutput) SetFailureReason(v string) *GetQuantumTaskOutput {
	s.FailureReason = &v
	return s
}

// SetOutputS3Bucket sets the OutputS3Bucket field's value.
func (s *GetQuantumTaskOutput) SetOutputS3Bucket(v string) *GetQuantumTaskOutput {
	s.OutputS3Bucket = &v
	return s
}

// SetOutputS3Directory sets the OutputS3Directory field's value.
func (s *GetQuantumTaskOutput) SetOutputS3Directory(v string) *GetQuantumTaskOutput {
	s.OutputS3Directory = &v
	return s
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *GetQuantumTaskOutput) SetQuantumTaskArn(v string) *GetQuantumTaskOutput {
	s.QuantumTaskArn = &v
	return s
}

// SetShots sets the Shots field's value.
func (s *GetQuantumTaskOutput) SetShots(v int64) *GetQuantumTaskOutput {
	s.Shots = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetQuantumTaskOutput) SetStatus(v string) *GetQuantumTaskOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetQuantumTaskOutput) SetTags(v map[string]*string) *GetQuantumTaskOutput {
	s.Tags = v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the resourceArn for the resource whose tags to display.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Displays the key, value pairs of tags associated with this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Includes information about a quantum task.
type QuantumTaskSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the task was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The ARN of the device the task ran on.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"1" type:"string" required:"true"`

	// The time at which the task finished.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The S3 bucket where the task result file is stored..
	//
	// OutputS3Bucket is a required field
	OutputS3Bucket *string `locationName:"outputS3Bucket" type:"string" required:"true"`

	// The folder in the S3 bucket where the task result file is stored.
	//
	// OutputS3Directory is a required field
	OutputS3Directory *string `locationName:"outputS3Directory" type:"string" required:"true"`

	// The ARN of the task.
	//
	// QuantumTaskArn is a required field
	QuantumTaskArn *string `locationName:"quantumTaskArn" min:"1" type:"string" required:"true"`

	// The shots used for the task.
	//
	// Shots is a required field
	Shots *int64 `locationName:"shots" type:"long" required:"true"`

	// The status of the task.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QuantumTaskStatus"`

	// Displays the key, value pairs of tags associated with this quantum task.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s QuantumTaskSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuantumTaskSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *QuantumTaskSummary) SetCreatedAt(v time.Time) *QuantumTaskSummary {
	s.CreatedAt = &v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *QuantumTaskSummary) SetDeviceArn(v string) *QuantumTaskSummary {
	s.DeviceArn = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *QuantumTaskSummary) SetEndedAt(v time.Time) *QuantumTaskSummary {
	s.EndedAt = &v
	return s
}

// SetOutputS3Bucket sets the OutputS3Bucket field's value.
func (s *QuantumTaskSummary) SetOutputS3Bucket(v string) *QuantumTaskSummary {
	s.OutputS3Bucket = &v
	return s
}

// SetOutputS3Directory sets the OutputS3Directory field's value.
func (s *QuantumTaskSummary) SetOutputS3Directory(v string) *QuantumTaskSummary {
	s.OutputS3Directory = &v
	return s
}

// SetQuantumTaskArn sets the QuantumTaskArn field's value.
func (s *QuantumTaskSummary) SetQuantumTaskArn(v string) *QuantumTaskSummary {
	s.QuantumTaskArn = &v
	return s
}

// SetShots sets the Shots field's value.
func (s *QuantumTaskSummary) SetShots(v int64) *QuantumTaskSummary {
	s.Shots = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QuantumTaskSummary) SetStatus(v string) *QuantumTaskSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *QuantumTaskSummary) SetTags(v map[string]*string) *QuantumTaskSummary {
	s.Tags = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter to use for searching devices.
type SearchDevicesFilter struct {
	_ struct{} `type:"structure"`

	// The name to use to filter results.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The values to use to filter results.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SearchDevicesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDevicesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDevicesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDevicesFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SearchDevicesFilter) SetName(v string) *SearchDevicesFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchDevicesFilter) SetValues(v []*string) *SearchDevicesFilter {
	s.Values = v
	return s
}

type SearchDevicesInput struct {
	_ struct{} `type:"structure"`

	// The filter values to use to search for a device.
	//
	// Filters is a required field
	Filters []*SearchDevicesFilter `locationName:"filters" type:"list" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token used for pagination of results returned in the response. Use the
	// token returned from the previous request continue results where the previous
	// request ended.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchDevicesInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchDevicesInput) SetFilters(v []*SearchDevicesFilter) *SearchDevicesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchDevicesInput) SetMaxResults(v int64) *SearchDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesInput) SetNextToken(v string) *SearchDevicesInput {
	s.NextToken = &v
	return s
}

type SearchDevicesOutput struct {
	_ struct{} `type:"structure"`

	// An array of DeviceSummary objects for devices that match the specified filter
	// values.
	//
	// Devices is a required field
	Devices []*DeviceSummary `locationName:"devices" type:"list" required:"true"`

	// A token used for pagination of results, or null if there are no additional
	// results. Use the token value in a subsequent request to continue results
	// where the previous request ended.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *SearchDevicesOutput) SetDevices(v []*DeviceSummary) *SearchDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchDevicesOutput) SetNextToken(v string) *SearchDevicesOutput {
	s.NextToken = &v
	return s
}

// A filter to use to search for tasks.
type SearchQuantumTasksFilter struct {
	_ struct{} `type:"structure"`

	// The name of the device used for the task.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// An operator to use in the filter.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"SearchQuantumTasksFilterOperator"`

	// The values to use for the filter.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SearchQuantumTasksFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchQuantumTasksFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchQuantumTasksFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchQuantumTasksFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SearchQuantumTasksFilter) SetName(v string) *SearchQuantumTasksFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *SearchQuantumTasksFilter) SetOperator(v string) *SearchQuantumTasksFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchQuantumTasksFilter) SetValues(v []*string) *SearchQuantumTasksFilter {
	s.Values = v
	return s
}

type SearchQuantumTasksInput struct {
	_ struct{} `type:"structure"`

	// Array of SearchQuantumTasksFilter objects.
	//
	// Filters is a required field
	Filters []*SearchQuantumTasksFilter `locationName:"filters" type:"list" required:"true"`

	// Maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token used for pagination of results returned in the response. Use the
	// token returned from the previous request continue results where the previous
	// request ended.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchQuantumTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchQuantumTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchQuantumTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchQuantumTasksInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchQuantumTasksInput) SetFilters(v []*SearchQuantumTasksFilter) *SearchQuantumTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchQuantumTasksInput) SetMaxResults(v int64) *SearchQuantumTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchQuantumTasksInput) SetNextToken(v string) *SearchQuantumTasksInput {
	s.NextToken = &v
	return s
}

type SearchQuantumTasksOutput struct {
	_ struct{} `type:"structure"`

	// A token used for pagination of results, or null if there are no additional
	// results. Use the token value in a subsequent request to continue results
	// where the previous request ended.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of QuantumTaskSummary objects for tasks that match the specified
	// filters.
	//
	// QuantumTasks is a required field
	QuantumTasks []*QuantumTaskSummary `locationName:"quantumTasks" type:"list" required:"true"`
}

// String returns the string representation
func (s SearchQuantumTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchQuantumTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchQuantumTasksOutput) SetNextToken(v string) *SearchQuantumTasksOutput {
	s.NextToken = &v
	return s
}

// SetQuantumTasks sets the QuantumTasks field's value.
func (s *SearchQuantumTasksOutput) SetQuantumTasks(v []*QuantumTaskSummary) *SearchQuantumTasksOutput {
	s.QuantumTasks = v
	return s
}

// The request failed because a service quota is exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the resourceArn of the resource to which a tag will be added.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Specify the tags to add to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The throttling rate limit is met.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Specify the resourceArn for the resource from which to remove the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Specify the keys for the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// CancellationStatusCancelling is a CancellationStatus enum value
	CancellationStatusCancelling = "CANCELLING"

	// CancellationStatusCancelled is a CancellationStatus enum value
	CancellationStatusCancelled = "CANCELLED"
)

// CancellationStatus_Values returns all elements of the CancellationStatus enum
func CancellationStatus_Values() []string {
	return []string{
		CancellationStatusCancelling,
		CancellationStatusCancelled,
	}
}

const (
	// DeviceStatusOnline is a DeviceStatus enum value
	DeviceStatusOnline = "ONLINE"

	// DeviceStatusOffline is a DeviceStatus enum value
	DeviceStatusOffline = "OFFLINE"

	// DeviceStatusRetired is a DeviceStatus enum value
	DeviceStatusRetired = "RETIRED"
)

// DeviceStatus_Values returns all elements of the DeviceStatus enum
func DeviceStatus_Values() []string {
	return []string{
		DeviceStatusOnline,
		DeviceStatusOffline,
		DeviceStatusRetired,
	}
}

const (
	// DeviceTypeQpu is a DeviceType enum value
	DeviceTypeQpu = "QPU"

	// DeviceTypeSimulator is a DeviceType enum value
	DeviceTypeSimulator = "SIMULATOR"
)

// DeviceType_Values returns all elements of the DeviceType enum
func DeviceType_Values() []string {
	return []string{
		DeviceTypeQpu,
		DeviceTypeSimulator,
	}
}

const (
	// QuantumTaskStatusCreated is a QuantumTaskStatus enum value
	QuantumTaskStatusCreated = "CREATED"

	// QuantumTaskStatusQueued is a QuantumTaskStatus enum value
	QuantumTaskStatusQueued = "QUEUED"

	// QuantumTaskStatusRunning is a QuantumTaskStatus enum value
	QuantumTaskStatusRunning = "RUNNING"

	// QuantumTaskStatusCompleted is a QuantumTaskStatus enum value
	QuantumTaskStatusCompleted = "COMPLETED"

	// QuantumTaskStatusFailed is a QuantumTaskStatus enum value
	QuantumTaskStatusFailed = "FAILED"

	// QuantumTaskStatusCancelling is a QuantumTaskStatus enum value
	QuantumTaskStatusCancelling = "CANCELLING"

	// QuantumTaskStatusCancelled is a QuantumTaskStatus enum value
	QuantumTaskStatusCancelled = "CANCELLED"
)

// QuantumTaskStatus_Values returns all elements of the QuantumTaskStatus enum
func QuantumTaskStatus_Values() []string {
	return []string{
		QuantumTaskStatusCreated,
		QuantumTaskStatusQueued,
		QuantumTaskStatusRunning,
		QuantumTaskStatusCompleted,
		QuantumTaskStatusFailed,
		QuantumTaskStatusCancelling,
		QuantumTaskStatusCancelled,
	}
}

const (
	// SearchQuantumTasksFilterOperatorLt is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorLt = "LT"

	// SearchQuantumTasksFilterOperatorLte is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorLte = "LTE"

	// SearchQuantumTasksFilterOperatorEqual is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorEqual = "EQUAL"

	// SearchQuantumTasksFilterOperatorGt is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorGt = "GT"

	// SearchQuantumTasksFilterOperatorGte is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorGte = "GTE"

	// SearchQuantumTasksFilterOperatorBetween is a SearchQuantumTasksFilterOperator enum value
	SearchQuantumTasksFilterOperatorBetween = "BETWEEN"
)

// SearchQuantumTasksFilterOperator_Values returns all elements of the SearchQuantumTasksFilterOperator enum
func SearchQuantumTasksFilterOperator_Values() []string {
	return []string{
		SearchQuantumTasksFilterOperatorLt,
		SearchQuantumTasksFilterOperatorLte,
		SearchQuantumTasksFilterOperatorEqual,
		SearchQuantumTasksFilterOperatorGt,
		SearchQuantumTasksFilterOperatorGte,
		SearchQuantumTasksFilterOperatorBetween,
	}
}
