// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package polly

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteLexicon = "DeleteLexicon"

// DeleteLexiconRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLexicon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLexicon for more information on using the DeleteLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLexiconRequest method.
//    req, resp := client.DeleteLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon
func (c *Polly) DeleteLexiconRequest(input *DeleteLexiconInput) (req *request.Request, output *DeleteLexiconOutput) {
	op := &request.Operation{
		Name:       opDeleteLexicon,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &DeleteLexiconInput{}
	}

	output = &DeleteLexiconOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLexicon API operation for Amazon Polly.
//
// Deletes the specified pronunciation lexicon stored in an Amazon Web Services
// Region. A lexicon which has been deleted is not available for speech synthesis,
// nor is it possible to retrieve it using either the GetLexicon or ListLexicon
// APIs.
//
// For more information, see Managing Lexicons (https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation DeleteLexicon for usage and error information.
//
// Returned Error Types:
//   * LexiconNotFoundException
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon
func (c *Polly) DeleteLexicon(input *DeleteLexiconInput) (*DeleteLexiconOutput, error) {
	req, out := c.DeleteLexiconRequest(input)
	return out, req.Send()
}

// DeleteLexiconWithContext is the same as DeleteLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) DeleteLexiconWithContext(ctx aws.Context, input *DeleteLexiconInput, opts ...request.Option) (*DeleteLexiconOutput, error) {
	req, out := c.DeleteLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVoices = "DescribeVoices"

// DescribeVoicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVoices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVoices for more information on using the DescribeVoices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVoicesRequest method.
//    req, resp := client.DescribeVoicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices
func (c *Polly) DescribeVoicesRequest(input *DescribeVoicesInput) (req *request.Request, output *DescribeVoicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVoices,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/voices",
	}

	if input == nil {
		input = &DescribeVoicesInput{}
	}

	output = &DescribeVoicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVoices API operation for Amazon Polly.
//
// Returns the list of voices that are available for use when requesting speech
// synthesis. Each voice speaks a specified language, is either male or female,
// and is identified by an ID, which is the ASCII version of the voice name.
//
// When synthesizing speech ( SynthesizeSpeech ), you provide the voice ID for
// the voice you want from the list of voices returned by DescribeVoices.
//
// For example, you want your news reader application to read news in a specific
// language, but giving a user the option to choose the voice. Using the DescribeVoices
// operation you can provide the user with a list of available voices to select
// from.
//
// You can optionally specify a language code to filter the available voices.
// For example, if you specify en-US, the operation returns a list of all available
// US English voices.
//
// This operation requires permissions to perform the polly:DescribeVoices action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation DescribeVoices for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken is invalid. Verify that it's spelled correctly, and then try
//   again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices
func (c *Polly) DescribeVoices(input *DescribeVoicesInput) (*DescribeVoicesOutput, error) {
	req, out := c.DescribeVoicesRequest(input)
	return out, req.Send()
}

// DescribeVoicesWithContext is the same as DescribeVoices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVoices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) DescribeVoicesWithContext(ctx aws.Context, input *DescribeVoicesInput, opts ...request.Option) (*DescribeVoicesOutput, error) {
	req, out := c.DescribeVoicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLexicon = "GetLexicon"

// GetLexiconRequest generates a "aws/request.Request" representing the
// client's request for the GetLexicon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLexicon for more information on using the GetLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLexiconRequest method.
//    req, resp := client.GetLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon
func (c *Polly) GetLexiconRequest(input *GetLexiconInput) (req *request.Request, output *GetLexiconOutput) {
	op := &request.Operation{
		Name:       opGetLexicon,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &GetLexiconInput{}
	}

	output = &GetLexiconOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLexicon API operation for Amazon Polly.
//
// Returns the content of the specified pronunciation lexicon stored in an Amazon
// Web Services Region. For more information, see Managing Lexicons (https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation GetLexicon for usage and error information.
//
// Returned Error Types:
//   * LexiconNotFoundException
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon
func (c *Polly) GetLexicon(input *GetLexiconInput) (*GetLexiconOutput, error) {
	req, out := c.GetLexiconRequest(input)
	return out, req.Send()
}

// GetLexiconWithContext is the same as GetLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See GetLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) GetLexiconWithContext(ctx aws.Context, input *GetLexiconInput, opts ...request.Option) (*GetLexiconOutput, error) {
	req, out := c.GetLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSpeechSynthesisTask = "GetSpeechSynthesisTask"

// GetSpeechSynthesisTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetSpeechSynthesisTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSpeechSynthesisTask for more information on using the GetSpeechSynthesisTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSpeechSynthesisTaskRequest method.
//    req, resp := client.GetSpeechSynthesisTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetSpeechSynthesisTask
func (c *Polly) GetSpeechSynthesisTaskRequest(input *GetSpeechSynthesisTaskInput) (req *request.Request, output *GetSpeechSynthesisTaskOutput) {
	op := &request.Operation{
		Name:       opGetSpeechSynthesisTask,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/synthesisTasks/{TaskId}",
	}

	if input == nil {
		input = &GetSpeechSynthesisTaskInput{}
	}

	output = &GetSpeechSynthesisTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSpeechSynthesisTask API operation for Amazon Polly.
//
// Retrieves a specific SpeechSynthesisTask object based on its TaskID. This
// object contains information about the given speech synthesis task, including
// the status of the task, and a link to the S3 bucket containing the output
// of the task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation GetSpeechSynthesisTask for usage and error information.
//
// Returned Error Types:
//   * InvalidTaskIdException
//   The provided Task ID is not valid. Please provide a valid Task ID and try
//   again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
//   * SynthesisTaskNotFoundException
//   The Speech Synthesis task with requested Task ID cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetSpeechSynthesisTask
func (c *Polly) GetSpeechSynthesisTask(input *GetSpeechSynthesisTaskInput) (*GetSpeechSynthesisTaskOutput, error) {
	req, out := c.GetSpeechSynthesisTaskRequest(input)
	return out, req.Send()
}

// GetSpeechSynthesisTaskWithContext is the same as GetSpeechSynthesisTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetSpeechSynthesisTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) GetSpeechSynthesisTaskWithContext(ctx aws.Context, input *GetSpeechSynthesisTaskInput, opts ...request.Option) (*GetSpeechSynthesisTaskOutput, error) {
	req, out := c.GetSpeechSynthesisTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLexicons = "ListLexicons"

// ListLexiconsRequest generates a "aws/request.Request" representing the
// client's request for the ListLexicons operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLexicons for more information on using the ListLexicons
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLexiconsRequest method.
//    req, resp := client.ListLexiconsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons
func (c *Polly) ListLexiconsRequest(input *ListLexiconsInput) (req *request.Request, output *ListLexiconsOutput) {
	op := &request.Operation{
		Name:       opListLexicons,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/lexicons",
	}

	if input == nil {
		input = &ListLexiconsInput{}
	}

	output = &ListLexiconsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLexicons API operation for Amazon Polly.
//
// Returns a list of pronunciation lexicons stored in an Amazon Web Services
// Region. For more information, see Managing Lexicons (https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation ListLexicons for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken is invalid. Verify that it's spelled correctly, and then try
//   again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons
func (c *Polly) ListLexicons(input *ListLexiconsInput) (*ListLexiconsOutput, error) {
	req, out := c.ListLexiconsRequest(input)
	return out, req.Send()
}

// ListLexiconsWithContext is the same as ListLexicons with the addition of
// the ability to pass a context and additional request options.
//
// See ListLexicons for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) ListLexiconsWithContext(ctx aws.Context, input *ListLexiconsInput, opts ...request.Option) (*ListLexiconsOutput, error) {
	req, out := c.ListLexiconsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSpeechSynthesisTasks = "ListSpeechSynthesisTasks"

// ListSpeechSynthesisTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListSpeechSynthesisTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSpeechSynthesisTasks for more information on using the ListSpeechSynthesisTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSpeechSynthesisTasksRequest method.
//    req, resp := client.ListSpeechSynthesisTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks
func (c *Polly) ListSpeechSynthesisTasksRequest(input *ListSpeechSynthesisTasksInput) (req *request.Request, output *ListSpeechSynthesisTasksOutput) {
	op := &request.Operation{
		Name:       opListSpeechSynthesisTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/synthesisTasks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSpeechSynthesisTasksInput{}
	}

	output = &ListSpeechSynthesisTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSpeechSynthesisTasks API operation for Amazon Polly.
//
// Returns a list of SpeechSynthesisTask objects ordered by their creation date.
// This operation can filter the tasks by their status, for example, allowing
// users to list only tasks that are completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation ListSpeechSynthesisTasks for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken is invalid. Verify that it's spelled correctly, and then try
//   again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks
func (c *Polly) ListSpeechSynthesisTasks(input *ListSpeechSynthesisTasksInput) (*ListSpeechSynthesisTasksOutput, error) {
	req, out := c.ListSpeechSynthesisTasksRequest(input)
	return out, req.Send()
}

// ListSpeechSynthesisTasksWithContext is the same as ListSpeechSynthesisTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListSpeechSynthesisTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) ListSpeechSynthesisTasksWithContext(ctx aws.Context, input *ListSpeechSynthesisTasksInput, opts ...request.Option) (*ListSpeechSynthesisTasksOutput, error) {
	req, out := c.ListSpeechSynthesisTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSpeechSynthesisTasksPages iterates over the pages of a ListSpeechSynthesisTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSpeechSynthesisTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSpeechSynthesisTasks operation.
//    pageNum := 0
//    err := client.ListSpeechSynthesisTasksPages(params,
//        func(page *polly.ListSpeechSynthesisTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Polly) ListSpeechSynthesisTasksPages(input *ListSpeechSynthesisTasksInput, fn func(*ListSpeechSynthesisTasksOutput, bool) bool) error {
	return c.ListSpeechSynthesisTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSpeechSynthesisTasksPagesWithContext same as ListSpeechSynthesisTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) ListSpeechSynthesisTasksPagesWithContext(ctx aws.Context, input *ListSpeechSynthesisTasksInput, fn func(*ListSpeechSynthesisTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSpeechSynthesisTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSpeechSynthesisTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSpeechSynthesisTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutLexicon = "PutLexicon"

// PutLexiconRequest generates a "aws/request.Request" representing the
// client's request for the PutLexicon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLexicon for more information on using the PutLexicon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLexiconRequest method.
//    req, resp := client.PutLexiconRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon
func (c *Polly) PutLexiconRequest(input *PutLexiconInput) (req *request.Request, output *PutLexiconOutput) {
	op := &request.Operation{
		Name:       opPutLexicon,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/lexicons/{LexiconName}",
	}

	if input == nil {
		input = &PutLexiconInput{}
	}

	output = &PutLexiconOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutLexicon API operation for Amazon Polly.
//
// Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon
// with the same name already exists in the region, it is overwritten by the
// new lexicon. Lexicon operations have eventual consistency, therefore, it
// might take some time before the lexicon is available to the SynthesizeSpeech
// operation.
//
// For more information, see Managing Lexicons (https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation PutLexicon for usage and error information.
//
// Returned Error Types:
//   * InvalidLexiconException
//   Amazon Polly can't find the specified lexicon. Verify that the lexicon's
//   name is spelled correctly, and then try again.
//
//   * UnsupportedPlsAlphabetException
//   The alphabet specified by the lexicon is not a supported alphabet. Valid
//   values are x-sampa and ipa.
//
//   * UnsupportedPlsLanguageException
//   The language specified in the lexicon is unsupported. For a list of supported
//   languages, see Lexicon Attributes (https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html).
//
//   * LexiconSizeExceededException
//   The maximum size of the specified lexicon would be exceeded by this operation.
//
//   * MaxLexemeLengthExceededException
//   The maximum size of the lexeme would be exceeded by this operation.
//
//   * MaxLexiconsNumberExceededException
//   The maximum number of lexicons would be exceeded by this operation.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon
func (c *Polly) PutLexicon(input *PutLexiconInput) (*PutLexiconOutput, error) {
	req, out := c.PutLexiconRequest(input)
	return out, req.Send()
}

// PutLexiconWithContext is the same as PutLexicon with the addition of
// the ability to pass a context and additional request options.
//
// See PutLexicon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) PutLexiconWithContext(ctx aws.Context, input *PutLexiconInput, opts ...request.Option) (*PutLexiconOutput, error) {
	req, out := c.PutLexiconRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSpeechSynthesisTask = "StartSpeechSynthesisTask"

// StartSpeechSynthesisTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartSpeechSynthesisTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSpeechSynthesisTask for more information on using the StartSpeechSynthesisTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSpeechSynthesisTaskRequest method.
//    req, resp := client.StartSpeechSynthesisTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/StartSpeechSynthesisTask
func (c *Polly) StartSpeechSynthesisTaskRequest(input *StartSpeechSynthesisTaskInput) (req *request.Request, output *StartSpeechSynthesisTaskOutput) {
	op := &request.Operation{
		Name:       opStartSpeechSynthesisTask,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/synthesisTasks",
	}

	if input == nil {
		input = &StartSpeechSynthesisTaskInput{}
	}

	output = &StartSpeechSynthesisTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSpeechSynthesisTask API operation for Amazon Polly.
//
// Allows the creation of an asynchronous synthesis task, by starting a new
// SpeechSynthesisTask. This operation requires all the standard information
// needed for speech synthesis, plus the name of an Amazon S3 bucket for the
// service to store the output of the synthesis task and two optional parameters
// (OutputS3KeyPrefix and SnsTopicArn). Once the synthesis task is created,
// this operation will return a SpeechSynthesisTask object, which will include
// an identifier of this task as well as the current status. The SpeechSynthesisTask
// object is available for 72 hours after starting the asynchronous synthesis
// task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation StartSpeechSynthesisTask for usage and error information.
//
// Returned Error Types:
//   * TextLengthExceededException
//   The value of the "Text" parameter is longer than the accepted limits. For
//   the SynthesizeSpeech API, the limit for input text is a maximum of 6000 characters
//   total, of which no more than 3000 can be billed characters. For the StartSpeechSynthesisTask
//   API, the maximum is 200,000 characters, of which no more than 100,000 can
//   be billed characters. SSML tags are not counted as billed characters.
//
//   * InvalidS3BucketException
//   The provided Amazon S3 bucket name is invalid. Please check your input with
//   S3 bucket naming requirements and try again.
//
//   * InvalidS3KeyException
//   The provided Amazon S3 key prefix is invalid. Please provide a valid S3 object
//   key name.
//
//   * InvalidSampleRateException
//   The specified sample rate is not valid.
//
//   * InvalidSnsTopicArnException
//   The provided SNS topic ARN is invalid. Please provide a valid SNS topic ARN
//   and try again.
//
//   * InvalidSsmlException
//   The SSML you provided is invalid. Verify the SSML syntax, spelling of tags
//   and values, and then try again.
//
//   * EngineNotSupportedException
//   This engine is not compatible with the voice that you have designated. Choose
//   a new voice that is compatible with the engine or change the engine and restart
//   the operation.
//
//   * LexiconNotFoundException
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
//   * MarksNotSupportedForFormatException
//   Speech marks are not supported for the OutputFormat selected. Speech marks
//   are only available for content in json format.
//
//   * SsmlMarksNotSupportedForTextTypeException
//   SSML speech marks are not supported for plain text-type input.
//
//   * LanguageNotSupportedException
//   The language specified is not currently supported by Amazon Polly in this
//   capacity.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/StartSpeechSynthesisTask
func (c *Polly) StartSpeechSynthesisTask(input *StartSpeechSynthesisTaskInput) (*StartSpeechSynthesisTaskOutput, error) {
	req, out := c.StartSpeechSynthesisTaskRequest(input)
	return out, req.Send()
}

// StartSpeechSynthesisTaskWithContext is the same as StartSpeechSynthesisTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartSpeechSynthesisTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) StartSpeechSynthesisTaskWithContext(ctx aws.Context, input *StartSpeechSynthesisTaskInput, opts ...request.Option) (*StartSpeechSynthesisTaskOutput, error) {
	req, out := c.StartSpeechSynthesisTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSynthesizeSpeech = "SynthesizeSpeech"

// SynthesizeSpeechRequest generates a "aws/request.Request" representing the
// client's request for the SynthesizeSpeech operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SynthesizeSpeech for more information on using the SynthesizeSpeech
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SynthesizeSpeechRequest method.
//    req, resp := client.SynthesizeSpeechRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech
func (c *Polly) SynthesizeSpeechRequest(input *SynthesizeSpeechInput) (req *request.Request, output *SynthesizeSpeechOutput) {
	op := &request.Operation{
		Name:       opSynthesizeSpeech,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/speech",
	}

	if input == nil {
		input = &SynthesizeSpeechInput{}
	}

	output = &SynthesizeSpeechOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SynthesizeSpeech API operation for Amazon Polly.
//
// Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input
// must be valid, well-formed SSML. Some alphabets might not be available with
// all the voices (for example, Cyrillic might not be read at all by English
// voices) unless phoneme mapping is used. For more information, see How it
// Works (https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Polly's
// API operation SynthesizeSpeech for usage and error information.
//
// Returned Error Types:
//   * TextLengthExceededException
//   The value of the "Text" parameter is longer than the accepted limits. For
//   the SynthesizeSpeech API, the limit for input text is a maximum of 6000 characters
//   total, of which no more than 3000 can be billed characters. For the StartSpeechSynthesisTask
//   API, the maximum is 200,000 characters, of which no more than 100,000 can
//   be billed characters. SSML tags are not counted as billed characters.
//
//   * InvalidSampleRateException
//   The specified sample rate is not valid.
//
//   * InvalidSsmlException
//   The SSML you provided is invalid. Verify the SSML syntax, spelling of tags
//   and values, and then try again.
//
//   * LexiconNotFoundException
//   Amazon Polly can't find the specified lexicon. This could be caused by a
//   lexicon that is missing, its name is misspelled or specifying a lexicon that
//   is in a different region.
//
//   Verify that the lexicon exists, is in the region (see ListLexicons) and that
//   you spelled its name is spelled correctly. Then try again.
//
//   * ServiceFailureException
//   An unknown condition has caused a service failure.
//
//   * MarksNotSupportedForFormatException
//   Speech marks are not supported for the OutputFormat selected. Speech marks
//   are only available for content in json format.
//
//   * SsmlMarksNotSupportedForTextTypeException
//   SSML speech marks are not supported for plain text-type input.
//
//   * LanguageNotSupportedException
//   The language specified is not currently supported by Amazon Polly in this
//   capacity.
//
//   * EngineNotSupportedException
//   This engine is not compatible with the voice that you have designated. Choose
//   a new voice that is compatible with the engine or change the engine and restart
//   the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech
func (c *Polly) SynthesizeSpeech(input *SynthesizeSpeechInput) (*SynthesizeSpeechOutput, error) {
	req, out := c.SynthesizeSpeechRequest(input)
	return out, req.Send()
}

// SynthesizeSpeechWithContext is the same as SynthesizeSpeech with the addition of
// the ability to pass a context and additional request options.
//
// See SynthesizeSpeech for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Polly) SynthesizeSpeechWithContext(ctx aws.Context, input *SynthesizeSpeechInput, opts ...request.Option) (*SynthesizeSpeechOutput, error) {
	req, out := c.SynthesizeSpeechRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DeleteLexiconInput struct {
	_ struct{} `type:"structure"`

	// The name of the lexicon to delete. Must be an existing lexicon in the region.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLexiconInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteLexiconInput) SetName(v string) *DeleteLexiconInput {
	s.Name = &v
	return s
}

type DeleteLexiconOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLexiconOutput) GoString() string {
	return s.String()
}

type DescribeVoicesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the engine (standard or neural) used by Amazon Polly when processing
	// input text for speech synthesis.
	Engine *string `location:"querystring" locationName:"Engine" type:"string" enum:"Engine"`

	// Boolean value indicating whether to return any bilingual voices that use
	// the specified language as an additional language. For instance, if you request
	// all languages that use US English (es-US), and there is an Italian voice
	// that speaks both Italian (it-IT) and US English, that voice will be included
	// if you specify yes but not if you specify no.
	IncludeAdditionalLanguageCodes *bool `location:"querystring" locationName:"IncludeAdditionalLanguageCodes" type:"boolean"`

	// The language identification tag (ISO 639 code for the language name-ISO 3166
	// country code) for filtering the list of voices returned. If you don't specify
	// this optional parameter, all available voices are returned.
	LanguageCode *string `location:"querystring" locationName:"LanguageCode" type:"string" enum:"LanguageCode"`

	// An opaque pagination token returned from the previous DescribeVoices operation.
	// If present, this indicates where to continue the listing.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeVoicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVoicesInput) GoString() string {
	return s.String()
}

// SetEngine sets the Engine field's value.
func (s *DescribeVoicesInput) SetEngine(v string) *DescribeVoicesInput {
	s.Engine = &v
	return s
}

// SetIncludeAdditionalLanguageCodes sets the IncludeAdditionalLanguageCodes field's value.
func (s *DescribeVoicesInput) SetIncludeAdditionalLanguageCodes(v bool) *DescribeVoicesInput {
	s.IncludeAdditionalLanguageCodes = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DescribeVoicesInput) SetLanguageCode(v string) *DescribeVoicesInput {
	s.LanguageCode = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVoicesInput) SetNextToken(v string) *DescribeVoicesInput {
	s.NextToken = &v
	return s
}

type DescribeVoicesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use in the next request to continue the listing of
	// voices. NextToken is returned only if the response is truncated.
	NextToken *string `type:"string"`

	// A list of voices with their properties.
	Voices []*Voice `type:"list"`
}

// String returns the string representation
func (s DescribeVoicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVoicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeVoicesOutput) SetNextToken(v string) *DescribeVoicesOutput {
	s.NextToken = &v
	return s
}

// SetVoices sets the Voices field's value.
func (s *DescribeVoicesOutput) SetVoices(v []*Voice) *DescribeVoicesOutput {
	s.Voices = v
	return s
}

// This engine is not compatible with the voice that you have designated. Choose
// a new voice that is compatible with the engine or change the engine and restart
// the operation.
type EngineNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s EngineNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineNotSupportedException) GoString() string {
	return s.String()
}

func newErrorEngineNotSupportedException(v protocol.ResponseMetadata) error {
	return &EngineNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EngineNotSupportedException) Code() string {
	return "EngineNotSupportedException"
}

// Message returns the exception's message.
func (s *EngineNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EngineNotSupportedException) OrigErr() error {
	return nil
}

func (s *EngineNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EngineNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EngineNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetLexiconInput struct {
	_ struct{} `type:"structure"`

	// Name of the lexicon.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLexiconInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetLexiconInput) SetName(v string) *GetLexiconInput {
	s.Name = &v
	return s
}

type GetLexiconOutput struct {
	_ struct{} `type:"structure"`

	// Lexicon object that provides name and the string content of the lexicon.
	Lexicon *Lexicon `type:"structure"`

	// Metadata of the lexicon, including phonetic alphabetic used, language code,
	// lexicon ARN, number of lexemes defined in the lexicon, and size of lexicon
	// in bytes.
	LexiconAttributes *LexiconAttributes `type:"structure"`
}

// String returns the string representation
func (s GetLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLexiconOutput) GoString() string {
	return s.String()
}

// SetLexicon sets the Lexicon field's value.
func (s *GetLexiconOutput) SetLexicon(v *Lexicon) *GetLexiconOutput {
	s.Lexicon = v
	return s
}

// SetLexiconAttributes sets the LexiconAttributes field's value.
func (s *GetLexiconOutput) SetLexiconAttributes(v *LexiconAttributes) *GetLexiconOutput {
	s.LexiconAttributes = v
	return s
}

type GetSpeechSynthesisTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Polly generated identifier for a speech synthesis task.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"TaskId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSpeechSynthesisTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSpeechSynthesisTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSpeechSynthesisTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSpeechSynthesisTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *GetSpeechSynthesisTaskInput) SetTaskId(v string) *GetSpeechSynthesisTaskInput {
	s.TaskId = &v
	return s
}

type GetSpeechSynthesisTaskOutput struct {
	_ struct{} `type:"structure"`

	// SynthesisTask object that provides information from the requested task, including
	// output format, creation time, task status, and so on.
	SynthesisTask *SynthesisTask `type:"structure"`
}

// String returns the string representation
func (s GetSpeechSynthesisTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSpeechSynthesisTaskOutput) GoString() string {
	return s.String()
}

// SetSynthesisTask sets the SynthesisTask field's value.
func (s *GetSpeechSynthesisTaskOutput) SetSynthesisTask(v *SynthesisTask) *GetSpeechSynthesisTaskOutput {
	s.SynthesisTask = v
	return s
}

// Amazon Polly can't find the specified lexicon. Verify that the lexicon's
// name is spelled correctly, and then try again.
type InvalidLexiconException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidLexiconException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidLexiconException) GoString() string {
	return s.String()
}

func newErrorInvalidLexiconException(v protocol.ResponseMetadata) error {
	return &InvalidLexiconException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLexiconException) Code() string {
	return "InvalidLexiconException"
}

// Message returns the exception's message.
func (s *InvalidLexiconException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLexiconException) OrigErr() error {
	return nil
}

func (s *InvalidLexiconException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLexiconException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLexiconException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken is invalid. Verify that it's spelled correctly, and then try
// again.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided Amazon S3 bucket name is invalid. Please check your input with
// S3 bucket naming requirements and try again.
type InvalidS3BucketException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidS3BucketException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidS3BucketException) GoString() string {
	return s.String()
}

func newErrorInvalidS3BucketException(v protocol.ResponseMetadata) error {
	return &InvalidS3BucketException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3BucketException) Code() string {
	return "InvalidS3BucketException"
}

// Message returns the exception's message.
func (s *InvalidS3BucketException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3BucketException) OrigErr() error {
	return nil
}

func (s *InvalidS3BucketException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3BucketException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3BucketException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided Amazon S3 key prefix is invalid. Please provide a valid S3 object
// key name.
type InvalidS3KeyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidS3KeyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidS3KeyException) GoString() string {
	return s.String()
}

func newErrorInvalidS3KeyException(v protocol.ResponseMetadata) error {
	return &InvalidS3KeyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3KeyException) Code() string {
	return "InvalidS3KeyException"
}

// Message returns the exception's message.
func (s *InvalidS3KeyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3KeyException) OrigErr() error {
	return nil
}

func (s *InvalidS3KeyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3KeyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3KeyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified sample rate is not valid.
type InvalidSampleRateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidSampleRateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSampleRateException) GoString() string {
	return s.String()
}

func newErrorInvalidSampleRateException(v protocol.ResponseMetadata) error {
	return &InvalidSampleRateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSampleRateException) Code() string {
	return "InvalidSampleRateException"
}

// Message returns the exception's message.
func (s *InvalidSampleRateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSampleRateException) OrigErr() error {
	return nil
}

func (s *InvalidSampleRateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSampleRateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSampleRateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided SNS topic ARN is invalid. Please provide a valid SNS topic ARN
// and try again.
type InvalidSnsTopicArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidSnsTopicArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSnsTopicArnException) GoString() string {
	return s.String()
}

func newErrorInvalidSnsTopicArnException(v protocol.ResponseMetadata) error {
	return &InvalidSnsTopicArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSnsTopicArnException) Code() string {
	return "InvalidSnsTopicArnException"
}

// Message returns the exception's message.
func (s *InvalidSnsTopicArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSnsTopicArnException) OrigErr() error {
	return nil
}

func (s *InvalidSnsTopicArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSnsTopicArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSnsTopicArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The SSML you provided is invalid. Verify the SSML syntax, spelling of tags
// and values, and then try again.
type InvalidSsmlException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidSsmlException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSsmlException) GoString() string {
	return s.String()
}

func newErrorInvalidSsmlException(v protocol.ResponseMetadata) error {
	return &InvalidSsmlException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSsmlException) Code() string {
	return "InvalidSsmlException"
}

// Message returns the exception's message.
func (s *InvalidSsmlException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSsmlException) OrigErr() error {
	return nil
}

func (s *InvalidSsmlException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSsmlException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSsmlException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided Task ID is not valid. Please provide a valid Task ID and try
// again.
type InvalidTaskIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidTaskIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTaskIdException) GoString() string {
	return s.String()
}

func newErrorInvalidTaskIdException(v protocol.ResponseMetadata) error {
	return &InvalidTaskIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTaskIdException) Code() string {
	return "InvalidTaskIdException"
}

// Message returns the exception's message.
func (s *InvalidTaskIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTaskIdException) OrigErr() error {
	return nil
}

func (s *InvalidTaskIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTaskIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTaskIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The language specified is not currently supported by Amazon Polly in this
// capacity.
type LanguageNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LanguageNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LanguageNotSupportedException) GoString() string {
	return s.String()
}

func newErrorLanguageNotSupportedException(v protocol.ResponseMetadata) error {
	return &LanguageNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LanguageNotSupportedException) Code() string {
	return "LanguageNotSupportedException"
}

// Message returns the exception's message.
func (s *LanguageNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LanguageNotSupportedException) OrigErr() error {
	return nil
}

func (s *LanguageNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LanguageNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LanguageNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides lexicon name and lexicon content in string format. For more information,
// see Pronunciation Lexicon Specification (PLS) Version 1.0 (https://www.w3.org/TR/pronunciation-lexicon/).
type Lexicon struct {
	_ struct{} `type:"structure"`

	// Lexicon content in string format. The content of a lexicon must be in PLS
	// format.
	Content *string `type:"string" sensitive:"true"`

	// Name of the lexicon.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Lexicon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Lexicon) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *Lexicon) SetContent(v string) *Lexicon {
	s.Content = &v
	return s
}

// SetName sets the Name field's value.
func (s *Lexicon) SetName(v string) *Lexicon {
	s.Name = &v
	return s
}

// Contains metadata describing the lexicon such as the number of lexemes, language
// code, and so on. For more information, see Managing Lexicons (https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
type LexiconAttributes struct {
	_ struct{} `type:"structure"`

	// Phonetic alphabet used in the lexicon. Valid values are ipa and x-sampa.
	Alphabet *string `type:"string"`

	// Language code that the lexicon applies to. A lexicon with a language code
	// such as "en" would be applied to all English languages (en-GB, en-US, en-AUS,
	// en-WLS, and so on.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Date lexicon was last modified (a timestamp value).
	LastModified *time.Time `type:"timestamp"`

	// Number of lexemes in the lexicon.
	LexemesCount *int64 `type:"integer"`

	// Amazon Resource Name (ARN) of the lexicon.
	LexiconArn *string `type:"string"`

	// Total size of the lexicon, in characters.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s LexiconAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconAttributes) GoString() string {
	return s.String()
}

// SetAlphabet sets the Alphabet field's value.
func (s *LexiconAttributes) SetAlphabet(v string) *LexiconAttributes {
	s.Alphabet = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LexiconAttributes) SetLanguageCode(v string) *LexiconAttributes {
	s.LanguageCode = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *LexiconAttributes) SetLastModified(v time.Time) *LexiconAttributes {
	s.LastModified = &v
	return s
}

// SetLexemesCount sets the LexemesCount field's value.
func (s *LexiconAttributes) SetLexemesCount(v int64) *LexiconAttributes {
	s.LexemesCount = &v
	return s
}

// SetLexiconArn sets the LexiconArn field's value.
func (s *LexiconAttributes) SetLexiconArn(v string) *LexiconAttributes {
	s.LexiconArn = &v
	return s
}

// SetSize sets the Size field's value.
func (s *LexiconAttributes) SetSize(v int64) *LexiconAttributes {
	s.Size = &v
	return s
}

// Describes the content of the lexicon.
type LexiconDescription struct {
	_ struct{} `type:"structure"`

	// Provides lexicon metadata.
	Attributes *LexiconAttributes `type:"structure"`

	// Name of the lexicon.
	Name *string `type:"string"`
}

// String returns the string representation
func (s LexiconDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconDescription) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *LexiconDescription) SetAttributes(v *LexiconAttributes) *LexiconDescription {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *LexiconDescription) SetName(v string) *LexiconDescription {
	s.Name = &v
	return s
}

// Amazon Polly can't find the specified lexicon. This could be caused by a
// lexicon that is missing, its name is misspelled or specifying a lexicon that
// is in a different region.
//
// Verify that the lexicon exists, is in the region (see ListLexicons) and that
// you spelled its name is spelled correctly. Then try again.
type LexiconNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LexiconNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconNotFoundException) GoString() string {
	return s.String()
}

func newErrorLexiconNotFoundException(v protocol.ResponseMetadata) error {
	return &LexiconNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LexiconNotFoundException) Code() string {
	return "LexiconNotFoundException"
}

// Message returns the exception's message.
func (s *LexiconNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LexiconNotFoundException) OrigErr() error {
	return nil
}

func (s *LexiconNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LexiconNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LexiconNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum size of the specified lexicon would be exceeded by this operation.
type LexiconSizeExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LexiconSizeExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LexiconSizeExceededException) GoString() string {
	return s.String()
}

func newErrorLexiconSizeExceededException(v protocol.ResponseMetadata) error {
	return &LexiconSizeExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LexiconSizeExceededException) Code() string {
	return "LexiconSizeExceededException"
}

// Message returns the exception's message.
func (s *LexiconSizeExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LexiconSizeExceededException) OrigErr() error {
	return nil
}

func (s *LexiconSizeExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LexiconSizeExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LexiconSizeExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListLexiconsInput struct {
	_ struct{} `type:"structure"`

	// An opaque pagination token returned from previous ListLexicons operation.
	// If present, indicates where to continue the list of lexicons.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListLexiconsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLexiconsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListLexiconsInput) SetNextToken(v string) *ListLexiconsInput {
	s.NextToken = &v
	return s
}

type ListLexiconsOutput struct {
	_ struct{} `type:"structure"`

	// A list of lexicon names and attributes.
	Lexicons []*LexiconDescription `type:"list"`

	// The pagination token to use in the next request to continue the listing of
	// lexicons. NextToken is returned only if the response is truncated.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLexiconsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLexiconsOutput) GoString() string {
	return s.String()
}

// SetLexicons sets the Lexicons field's value.
func (s *ListLexiconsOutput) SetLexicons(v []*LexiconDescription) *ListLexiconsOutput {
	s.Lexicons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLexiconsOutput) SetNextToken(v string) *ListLexiconsOutput {
	s.NextToken = &v
	return s
}

type ListSpeechSynthesisTasksInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of speech synthesis tasks returned in a List operation.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token to use in the next request to continue the listing of
	// speech synthesis tasks.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Status of the speech synthesis tasks returned in a List operation
	Status *string `location:"querystring" locationName:"Status" type:"string" enum:"TaskStatus"`
}

// String returns the string representation
func (s ListSpeechSynthesisTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSpeechSynthesisTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSpeechSynthesisTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSpeechSynthesisTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSpeechSynthesisTasksInput) SetMaxResults(v int64) *ListSpeechSynthesisTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeechSynthesisTasksInput) SetNextToken(v string) *ListSpeechSynthesisTasksInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListSpeechSynthesisTasksInput) SetStatus(v string) *ListSpeechSynthesisTasksInput {
	s.Status = &v
	return s
}

type ListSpeechSynthesisTasksOutput struct {
	_ struct{} `type:"structure"`

	// An opaque pagination token returned from the previous List operation in this
	// request. If present, this indicates where to continue the listing.
	NextToken *string `type:"string"`

	// List of SynthesisTask objects that provides information from the specified
	// task in the list request, including output format, creation time, task status,
	// and so on.
	SynthesisTasks []*SynthesisTask `type:"list"`
}

// String returns the string representation
func (s ListSpeechSynthesisTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSpeechSynthesisTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSpeechSynthesisTasksOutput) SetNextToken(v string) *ListSpeechSynthesisTasksOutput {
	s.NextToken = &v
	return s
}

// SetSynthesisTasks sets the SynthesisTasks field's value.
func (s *ListSpeechSynthesisTasksOutput) SetSynthesisTasks(v []*SynthesisTask) *ListSpeechSynthesisTasksOutput {
	s.SynthesisTasks = v
	return s
}

// Speech marks are not supported for the OutputFormat selected. Speech marks
// are only available for content in json format.
type MarksNotSupportedForFormatException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MarksNotSupportedForFormatException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarksNotSupportedForFormatException) GoString() string {
	return s.String()
}

func newErrorMarksNotSupportedForFormatException(v protocol.ResponseMetadata) error {
	return &MarksNotSupportedForFormatException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MarksNotSupportedForFormatException) Code() string {
	return "MarksNotSupportedForFormatException"
}

// Message returns the exception's message.
func (s *MarksNotSupportedForFormatException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MarksNotSupportedForFormatException) OrigErr() error {
	return nil
}

func (s *MarksNotSupportedForFormatException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MarksNotSupportedForFormatException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MarksNotSupportedForFormatException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum size of the lexeme would be exceeded by this operation.
type MaxLexemeLengthExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxLexemeLengthExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxLexemeLengthExceededException) GoString() string {
	return s.String()
}

func newErrorMaxLexemeLengthExceededException(v protocol.ResponseMetadata) error {
	return &MaxLexemeLengthExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxLexemeLengthExceededException) Code() string {
	return "MaxLexemeLengthExceededException"
}

// Message returns the exception's message.
func (s *MaxLexemeLengthExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxLexemeLengthExceededException) OrigErr() error {
	return nil
}

func (s *MaxLexemeLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxLexemeLengthExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxLexemeLengthExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of lexicons would be exceeded by this operation.
type MaxLexiconsNumberExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MaxLexiconsNumberExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaxLexiconsNumberExceededException) GoString() string {
	return s.String()
}

func newErrorMaxLexiconsNumberExceededException(v protocol.ResponseMetadata) error {
	return &MaxLexiconsNumberExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MaxLexiconsNumberExceededException) Code() string {
	return "MaxLexiconsNumberExceededException"
}

// Message returns the exception's message.
func (s *MaxLexiconsNumberExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MaxLexiconsNumberExceededException) OrigErr() error {
	return nil
}

func (s *MaxLexiconsNumberExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MaxLexiconsNumberExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MaxLexiconsNumberExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutLexiconInput struct {
	_ struct{} `type:"structure"`

	// Content of the PLS lexicon as string data.
	//
	// Content is a required field
	Content *string `type:"string" required:"true" sensitive:"true"`

	// Name of the lexicon. The name must follow the regular express format [0-9A-Za-z]{1,20}.
	// That is, the name is a case-sensitive alphanumeric string up to 20 characters
	// long.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"LexiconName" type:"string" required:"true"`
}

// String returns the string representation
func (s PutLexiconInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLexiconInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLexiconInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLexiconInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *PutLexiconInput) SetContent(v string) *PutLexiconInput {
	s.Content = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutLexiconInput) SetName(v string) *PutLexiconInput {
	s.Name = &v
	return s
}

type PutLexiconOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLexiconOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLexiconOutput) GoString() string {
	return s.String()
}

// An unknown condition has caused a service failure.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// SSML speech marks are not supported for plain text-type input.
type SsmlMarksNotSupportedForTextTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SsmlMarksNotSupportedForTextTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SsmlMarksNotSupportedForTextTypeException) GoString() string {
	return s.String()
}

func newErrorSsmlMarksNotSupportedForTextTypeException(v protocol.ResponseMetadata) error {
	return &SsmlMarksNotSupportedForTextTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SsmlMarksNotSupportedForTextTypeException) Code() string {
	return "SsmlMarksNotSupportedForTextTypeException"
}

// Message returns the exception's message.
func (s *SsmlMarksNotSupportedForTextTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SsmlMarksNotSupportedForTextTypeException) OrigErr() error {
	return nil
}

func (s *SsmlMarksNotSupportedForTextTypeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SsmlMarksNotSupportedForTextTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SsmlMarksNotSupportedForTextTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartSpeechSynthesisTaskInput struct {
	_ struct{} `type:"structure"`

	// Specifies the engine (standard or neural) for Amazon Polly to use when processing
	// input text for speech synthesis. Using a voice that is not supported for
	// the engine selected will result in an error.
	Engine *string `type:"string" enum:"Engine"`

	// Optional language code for the Speech Synthesis request. This is only necessary
	// if using a bilingual voice, such as Aditi, which can be used for either Indian
	// English (en-IN) or Hindi (hi-IN).
	//
	// If a bilingual voice is used and no language code is specified, Amazon Polly
	// uses the default language of the bilingual voice. The default language for
	// any voice is the one returned by the DescribeVoices (https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
	// operation for the LanguageCode parameter. For example, if no language code
	// is specified, Aditi will use Indian English rather than Hindi.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// List of one or more pronunciation lexicon names you want the service to apply
	// during synthesis. Lexicons are applied only if the language of the lexicon
	// is the same as the language of the voice.
	LexiconNames []*string `type:"list"`

	// The format in which the returned output will be encoded. For audio stream,
	// this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
	//
	// OutputFormat is a required field
	OutputFormat *string `type:"string" required:"true" enum:"OutputFormat"`

	// Amazon S3 bucket name to which the output file will be saved.
	//
	// OutputS3BucketName is a required field
	OutputS3BucketName *string `type:"string" required:"true"`

	// The Amazon S3 key prefix for the output speech file.
	OutputS3KeyPrefix *string `type:"string"`

	// The audio frequency specified in Hz.
	//
	// The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and
	// "24000". The default value for standard voices is "22050". The default value
	// for neural voices is "24000".
	//
	// Valid values for pcm are "8000" and "16000" The default value is "16000".
	SampleRate *string `type:"string"`

	// ARN for the SNS topic optionally used for providing status notification for
	// a speech synthesis task.
	SnsTopicArn *string `type:"string"`

	// The type of speech marks returned for the input text.
	SpeechMarkTypes []*string `type:"list"`

	// The input text to synthesize. If you specify ssml as the TextType, follow
	// the SSML format for the input text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// Specifies whether the input text is plain text or SSML. The default value
	// is plain text.
	TextType *string `type:"string" enum:"TextType"`

	// Voice ID to use for the synthesis.
	//
	// VoiceId is a required field
	VoiceId *string `type:"string" required:"true" enum:"VoiceId"`
}

// String returns the string representation
func (s StartSpeechSynthesisTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSpeechSynthesisTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSpeechSynthesisTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSpeechSynthesisTaskInput"}
	if s.OutputFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputFormat"))
	}
	if s.OutputS3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3BucketName"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.VoiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngine sets the Engine field's value.
func (s *StartSpeechSynthesisTaskInput) SetEngine(v string) *StartSpeechSynthesisTaskInput {
	s.Engine = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartSpeechSynthesisTaskInput) SetLanguageCode(v string) *StartSpeechSynthesisTaskInput {
	s.LanguageCode = &v
	return s
}

// SetLexiconNames sets the LexiconNames field's value.
func (s *StartSpeechSynthesisTaskInput) SetLexiconNames(v []*string) *StartSpeechSynthesisTaskInput {
	s.LexiconNames = v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *StartSpeechSynthesisTaskInput) SetOutputFormat(v string) *StartSpeechSynthesisTaskInput {
	s.OutputFormat = &v
	return s
}

// SetOutputS3BucketName sets the OutputS3BucketName field's value.
func (s *StartSpeechSynthesisTaskInput) SetOutputS3BucketName(v string) *StartSpeechSynthesisTaskInput {
	s.OutputS3BucketName = &v
	return s
}

// SetOutputS3KeyPrefix sets the OutputS3KeyPrefix field's value.
func (s *StartSpeechSynthesisTaskInput) SetOutputS3KeyPrefix(v string) *StartSpeechSynthesisTaskInput {
	s.OutputS3KeyPrefix = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *StartSpeechSynthesisTaskInput) SetSampleRate(v string) *StartSpeechSynthesisTaskInput {
	s.SampleRate = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *StartSpeechSynthesisTaskInput) SetSnsTopicArn(v string) *StartSpeechSynthesisTaskInput {
	s.SnsTopicArn = &v
	return s
}

// SetSpeechMarkTypes sets the SpeechMarkTypes field's value.
func (s *StartSpeechSynthesisTaskInput) SetSpeechMarkTypes(v []*string) *StartSpeechSynthesisTaskInput {
	s.SpeechMarkTypes = v
	return s
}

// SetText sets the Text field's value.
func (s *StartSpeechSynthesisTaskInput) SetText(v string) *StartSpeechSynthesisTaskInput {
	s.Text = &v
	return s
}

// SetTextType sets the TextType field's value.
func (s *StartSpeechSynthesisTaskInput) SetTextType(v string) *StartSpeechSynthesisTaskInput {
	s.TextType = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *StartSpeechSynthesisTaskInput) SetVoiceId(v string) *StartSpeechSynthesisTaskInput {
	s.VoiceId = &v
	return s
}

type StartSpeechSynthesisTaskOutput struct {
	_ struct{} `type:"structure"`

	// SynthesisTask object that provides information and attributes about a newly
	// submitted speech synthesis task.
	SynthesisTask *SynthesisTask `type:"structure"`
}

// String returns the string representation
func (s StartSpeechSynthesisTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSpeechSynthesisTaskOutput) GoString() string {
	return s.String()
}

// SetSynthesisTask sets the SynthesisTask field's value.
func (s *StartSpeechSynthesisTaskOutput) SetSynthesisTask(v *SynthesisTask) *StartSpeechSynthesisTaskOutput {
	s.SynthesisTask = v
	return s
}

// SynthesisTask object that provides information about a speech synthesis task.
type SynthesisTask struct {
	_ struct{} `type:"structure"`

	// Timestamp for the time the synthesis task was started.
	CreationTime *time.Time `type:"timestamp"`

	// Specifies the engine (standard or neural) for Amazon Polly to use when processing
	// input text for speech synthesis. Using a voice that is not supported for
	// the engine selected will result in an error.
	Engine *string `type:"string" enum:"Engine"`

	// Optional language code for a synthesis task. This is only necessary if using
	// a bilingual voice, such as Aditi, which can be used for either Indian English
	// (en-IN) or Hindi (hi-IN).
	//
	// If a bilingual voice is used and no language code is specified, Amazon Polly
	// uses the default language of the bilingual voice. The default language for
	// any voice is the one returned by the DescribeVoices (https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
	// operation for the LanguageCode parameter. For example, if no language code
	// is specified, Aditi will use Indian English rather than Hindi.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// List of one or more pronunciation lexicon names you want the service to apply
	// during synthesis. Lexicons are applied only if the language of the lexicon
	// is the same as the language of the voice.
	LexiconNames []*string `type:"list"`

	// The format in which the returned output will be encoded. For audio stream,
	// this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
	OutputFormat *string `type:"string" enum:"OutputFormat"`

	// Pathway for the output speech file.
	OutputUri *string `type:"string"`

	// Number of billable characters synthesized.
	RequestCharacters *int64 `type:"integer"`

	// The audio frequency specified in Hz.
	//
	// The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and
	// "24000". The default value for standard voices is "22050". The default value
	// for neural voices is "24000".
	//
	// Valid values for pcm are "8000" and "16000" The default value is "16000".
	SampleRate *string `type:"string"`

	// ARN for the SNS topic optionally used for providing status notification for
	// a speech synthesis task.
	SnsTopicArn *string `type:"string"`

	// The type of speech marks returned for the input text.
	SpeechMarkTypes []*string `type:"list"`

	// The Amazon Polly generated identifier for a speech synthesis task.
	TaskId *string `type:"string"`

	// Current status of the individual speech synthesis task.
	TaskStatus *string `type:"string" enum:"TaskStatus"`

	// Reason for the current status of a specific speech synthesis task, including
	// errors if the task has failed.
	TaskStatusReason *string `type:"string"`

	// Specifies whether the input text is plain text or SSML. The default value
	// is plain text.
	TextType *string `type:"string" enum:"TextType"`

	// Voice ID to use for the synthesis.
	VoiceId *string `type:"string" enum:"VoiceId"`
}

// String returns the string representation
func (s SynthesisTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesisTask) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *SynthesisTask) SetCreationTime(v time.Time) *SynthesisTask {
	s.CreationTime = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *SynthesisTask) SetEngine(v string) *SynthesisTask {
	s.Engine = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SynthesisTask) SetLanguageCode(v string) *SynthesisTask {
	s.LanguageCode = &v
	return s
}

// SetLexiconNames sets the LexiconNames field's value.
func (s *SynthesisTask) SetLexiconNames(v []*string) *SynthesisTask {
	s.LexiconNames = v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *SynthesisTask) SetOutputFormat(v string) *SynthesisTask {
	s.OutputFormat = &v
	return s
}

// SetOutputUri sets the OutputUri field's value.
func (s *SynthesisTask) SetOutputUri(v string) *SynthesisTask {
	s.OutputUri = &v
	return s
}

// SetRequestCharacters sets the RequestCharacters field's value.
func (s *SynthesisTask) SetRequestCharacters(v int64) *SynthesisTask {
	s.RequestCharacters = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *SynthesisTask) SetSampleRate(v string) *SynthesisTask {
	s.SampleRate = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *SynthesisTask) SetSnsTopicArn(v string) *SynthesisTask {
	s.SnsTopicArn = &v
	return s
}

// SetSpeechMarkTypes sets the SpeechMarkTypes field's value.
func (s *SynthesisTask) SetSpeechMarkTypes(v []*string) *SynthesisTask {
	s.SpeechMarkTypes = v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *SynthesisTask) SetTaskId(v string) *SynthesisTask {
	s.TaskId = &v
	return s
}

// SetTaskStatus sets the TaskStatus field's value.
func (s *SynthesisTask) SetTaskStatus(v string) *SynthesisTask {
	s.TaskStatus = &v
	return s
}

// SetTaskStatusReason sets the TaskStatusReason field's value.
func (s *SynthesisTask) SetTaskStatusReason(v string) *SynthesisTask {
	s.TaskStatusReason = &v
	return s
}

// SetTextType sets the TextType field's value.
func (s *SynthesisTask) SetTextType(v string) *SynthesisTask {
	s.TextType = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *SynthesisTask) SetVoiceId(v string) *SynthesisTask {
	s.VoiceId = &v
	return s
}

// The Speech Synthesis task with requested Task ID cannot be found.
type SynthesisTaskNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SynthesisTaskNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesisTaskNotFoundException) GoString() string {
	return s.String()
}

func newErrorSynthesisTaskNotFoundException(v protocol.ResponseMetadata) error {
	return &SynthesisTaskNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SynthesisTaskNotFoundException) Code() string {
	return "SynthesisTaskNotFoundException"
}

// Message returns the exception's message.
func (s *SynthesisTaskNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SynthesisTaskNotFoundException) OrigErr() error {
	return nil
}

func (s *SynthesisTaskNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SynthesisTaskNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SynthesisTaskNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SynthesizeSpeechInput struct {
	_ struct{} `type:"structure"`

	// Specifies the engine (standard or neural) for Amazon Polly to use when processing
	// input text for speech synthesis. For information on Amazon Polly voices and
	// which voices are available in standard-only, NTTS-only, and both standard
	// and NTTS formats, see Available Voices (https://docs.aws.amazon.com/polly/latest/dg/voicelist.html).
	//
	// NTTS-only voices
	//
	// When using NTTS-only voices such as Kevin (en-US), this parameter is required
	// and must be set to neural. If the engine is not specified, or is set to standard,
	// this will result in an error.
	//
	// Type: String
	//
	// Valid Values: standard | neural
	//
	// Required: Yes
	//
	// Standard voices
	//
	// For standard voices, this is not required; the engine parameter defaults
	// to standard. If the engine is not specified, or is set to standard and an
	// NTTS-only voice is selected, this will result in an error.
	Engine *string `type:"string" enum:"Engine"`

	// Optional language code for the Synthesize Speech request. This is only necessary
	// if using a bilingual voice, such as Aditi, which can be used for either Indian
	// English (en-IN) or Hindi (hi-IN).
	//
	// If a bilingual voice is used and no language code is specified, Amazon Polly
	// uses the default language of the bilingual voice. The default language for
	// any voice is the one returned by the DescribeVoices (https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
	// operation for the LanguageCode parameter. For example, if no language code
	// is specified, Aditi will use Indian English rather than Hindi.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// List of one or more pronunciation lexicon names you want the service to apply
	// during synthesis. Lexicons are applied only if the language of the lexicon
	// is the same as the language of the voice. For information about storing lexicons,
	// see PutLexicon (https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html).
	LexiconNames []*string `type:"list"`

	// The format in which the returned output will be encoded. For audio stream,
	// this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.
	//
	// When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1
	// channel (mono), little-endian format.
	//
	// OutputFormat is a required field
	OutputFormat *string `type:"string" required:"true" enum:"OutputFormat"`

	// The audio frequency specified in Hz.
	//
	// The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and
	// "24000". The default value for standard voices is "22050". The default value
	// for neural voices is "24000".
	//
	// Valid values for pcm are "8000" and "16000" The default value is "16000".
	SampleRate *string `type:"string"`

	// The type of speech marks returned for the input text.
	SpeechMarkTypes []*string `type:"list"`

	// Input text to synthesize. If you specify ssml as the TextType, follow the
	// SSML format for the input text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// Specifies whether the input text is plain text or SSML. The default value
	// is plain text. For more information, see Using SSML (https://docs.aws.amazon.com/polly/latest/dg/ssml.html).
	TextType *string `type:"string" enum:"TextType"`

	// Voice ID to use for the synthesis. You can get a list of available voice
	// IDs by calling the DescribeVoices (https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html)
	// operation.
	//
	// VoiceId is a required field
	VoiceId *string `type:"string" required:"true" enum:"VoiceId"`
}

// String returns the string representation
func (s SynthesizeSpeechInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesizeSpeechInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SynthesizeSpeechInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SynthesizeSpeechInput"}
	if s.OutputFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputFormat"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.VoiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngine sets the Engine field's value.
func (s *SynthesizeSpeechInput) SetEngine(v string) *SynthesizeSpeechInput {
	s.Engine = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SynthesizeSpeechInput) SetLanguageCode(v string) *SynthesizeSpeechInput {
	s.LanguageCode = &v
	return s
}

// SetLexiconNames sets the LexiconNames field's value.
func (s *SynthesizeSpeechInput) SetLexiconNames(v []*string) *SynthesizeSpeechInput {
	s.LexiconNames = v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *SynthesizeSpeechInput) SetOutputFormat(v string) *SynthesizeSpeechInput {
	s.OutputFormat = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *SynthesizeSpeechInput) SetSampleRate(v string) *SynthesizeSpeechInput {
	s.SampleRate = &v
	return s
}

// SetSpeechMarkTypes sets the SpeechMarkTypes field's value.
func (s *SynthesizeSpeechInput) SetSpeechMarkTypes(v []*string) *SynthesizeSpeechInput {
	s.SpeechMarkTypes = v
	return s
}

// SetText sets the Text field's value.
func (s *SynthesizeSpeechInput) SetText(v string) *SynthesizeSpeechInput {
	s.Text = &v
	return s
}

// SetTextType sets the TextType field's value.
func (s *SynthesizeSpeechInput) SetTextType(v string) *SynthesizeSpeechInput {
	s.TextType = &v
	return s
}

// SetVoiceId sets the VoiceId field's value.
func (s *SynthesizeSpeechInput) SetVoiceId(v string) *SynthesizeSpeechInput {
	s.VoiceId = &v
	return s
}

type SynthesizeSpeechOutput struct {
	_ struct{} `type:"structure" payload:"AudioStream"`

	// Stream containing the synthesized speech.
	AudioStream io.ReadCloser `type:"blob"`

	// Specifies the type audio stream. This should reflect the OutputFormat parameter
	// in your request.
	//
	//    * If you request mp3 as the OutputFormat, the ContentType returned is
	//    audio/mpeg.
	//
	//    * If you request ogg_vorbis as the OutputFormat, the ContentType returned
	//    is audio/ogg.
	//
	//    * If you request pcm as the OutputFormat, the ContentType returned is
	//    audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.
	//
	//    * If you request json as the OutputFormat, the ContentType returned is
	//    audio/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Number of characters synthesized.
	RequestCharacters *int64 `location:"header" locationName:"x-amzn-RequestCharacters" type:"integer"`
}

// String returns the string representation
func (s SynthesizeSpeechOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SynthesizeSpeechOutput) GoString() string {
	return s.String()
}

// SetAudioStream sets the AudioStream field's value.
func (s *SynthesizeSpeechOutput) SetAudioStream(v io.ReadCloser) *SynthesizeSpeechOutput {
	s.AudioStream = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SynthesizeSpeechOutput) SetContentType(v string) *SynthesizeSpeechOutput {
	s.ContentType = &v
	return s
}

// SetRequestCharacters sets the RequestCharacters field's value.
func (s *SynthesizeSpeechOutput) SetRequestCharacters(v int64) *SynthesizeSpeechOutput {
	s.RequestCharacters = &v
	return s
}

// The value of the "Text" parameter is longer than the accepted limits. For
// the SynthesizeSpeech API, the limit for input text is a maximum of 6000 characters
// total, of which no more than 3000 can be billed characters. For the StartSpeechSynthesisTask
// API, the maximum is 200,000 characters, of which no more than 100,000 can
// be billed characters. SSML tags are not counted as billed characters.
type TextLengthExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TextLengthExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextLengthExceededException) GoString() string {
	return s.String()
}

func newErrorTextLengthExceededException(v protocol.ResponseMetadata) error {
	return &TextLengthExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TextLengthExceededException) Code() string {
	return "TextLengthExceededException"
}

// Message returns the exception's message.
func (s *TextLengthExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TextLengthExceededException) OrigErr() error {
	return nil
}

func (s *TextLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TextLengthExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TextLengthExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The alphabet specified by the lexicon is not a supported alphabet. Valid
// values are x-sampa and ipa.
type UnsupportedPlsAlphabetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsupportedPlsAlphabetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedPlsAlphabetException) GoString() string {
	return s.String()
}

func newErrorUnsupportedPlsAlphabetException(v protocol.ResponseMetadata) error {
	return &UnsupportedPlsAlphabetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedPlsAlphabetException) Code() string {
	return "UnsupportedPlsAlphabetException"
}

// Message returns the exception's message.
func (s *UnsupportedPlsAlphabetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedPlsAlphabetException) OrigErr() error {
	return nil
}

func (s *UnsupportedPlsAlphabetException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedPlsAlphabetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedPlsAlphabetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The language specified in the lexicon is unsupported. For a list of supported
// languages, see Lexicon Attributes (https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html).
type UnsupportedPlsLanguageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsupportedPlsLanguageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedPlsLanguageException) GoString() string {
	return s.String()
}

func newErrorUnsupportedPlsLanguageException(v protocol.ResponseMetadata) error {
	return &UnsupportedPlsLanguageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedPlsLanguageException) Code() string {
	return "UnsupportedPlsLanguageException"
}

// Message returns the exception's message.
func (s *UnsupportedPlsLanguageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedPlsLanguageException) OrigErr() error {
	return nil
}

func (s *UnsupportedPlsLanguageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedPlsLanguageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedPlsLanguageException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Description of the voice.
type Voice struct {
	_ struct{} `type:"structure"`

	// Additional codes for languages available for the specified voice in addition
	// to its default language.
	//
	// For example, the default language for Aditi is Indian English (en-IN) because
	// it was first used for that language. Since Aditi is bilingual and fluent
	// in both Indian English and Hindi, this parameter would show the code hi-IN.
	AdditionalLanguageCodes []*string `type:"list"`

	// Gender of the voice.
	Gender *string `type:"string" enum:"Gender"`

	// Amazon Polly assigned voice ID. This is the ID that you specify when calling
	// the SynthesizeSpeech operation.
	Id *string `type:"string" enum:"VoiceId"`

	// Language code of the voice.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Human readable name of the language in English.
	LanguageName *string `type:"string"`

	// Name of the voice (for example, Salli, Kendra, etc.). This provides a human
	// readable voice name that you might display in your application.
	Name *string `type:"string"`

	// Specifies which engines (standard or neural) that are supported by a given
	// voice.
	SupportedEngines []*string `type:"list"`
}

// String returns the string representation
func (s Voice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Voice) GoString() string {
	return s.String()
}

// SetAdditionalLanguageCodes sets the AdditionalLanguageCodes field's value.
func (s *Voice) SetAdditionalLanguageCodes(v []*string) *Voice {
	s.AdditionalLanguageCodes = v
	return s
}

// SetGender sets the Gender field's value.
func (s *Voice) SetGender(v string) *Voice {
	s.Gender = &v
	return s
}

// SetId sets the Id field's value.
func (s *Voice) SetId(v string) *Voice {
	s.Id = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *Voice) SetLanguageCode(v string) *Voice {
	s.LanguageCode = &v
	return s
}

// SetLanguageName sets the LanguageName field's value.
func (s *Voice) SetLanguageName(v string) *Voice {
	s.LanguageName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Voice) SetName(v string) *Voice {
	s.Name = &v
	return s
}

// SetSupportedEngines sets the SupportedEngines field's value.
func (s *Voice) SetSupportedEngines(v []*string) *Voice {
	s.SupportedEngines = v
	return s
}

const (
	// EngineStandard is a Engine enum value
	EngineStandard = "standard"

	// EngineNeural is a Engine enum value
	EngineNeural = "neural"
)

// Engine_Values returns all elements of the Engine enum
func Engine_Values() []string {
	return []string{
		EngineStandard,
		EngineNeural,
	}
}

const (
	// GenderFemale is a Gender enum value
	GenderFemale = "Female"

	// GenderMale is a Gender enum value
	GenderMale = "Male"
)

// Gender_Values returns all elements of the Gender enum
func Gender_Values() []string {
	return []string{
		GenderFemale,
		GenderMale,
	}
}

const (
	// LanguageCodeArb is a LanguageCode enum value
	LanguageCodeArb = "arb"

	// LanguageCodeCmnCn is a LanguageCode enum value
	LanguageCodeCmnCn = "cmn-CN"

	// LanguageCodeCyGb is a LanguageCode enum value
	LanguageCodeCyGb = "cy-GB"

	// LanguageCodeDaDk is a LanguageCode enum value
	LanguageCodeDaDk = "da-DK"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEnGbWls is a LanguageCode enum value
	LanguageCodeEnGbWls = "en-GB-WLS"

	// LanguageCodeEnIn is a LanguageCode enum value
	LanguageCodeEnIn = "en-IN"

	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEsEs is a LanguageCode enum value
	LanguageCodeEsEs = "es-ES"

	// LanguageCodeEsMx is a LanguageCode enum value
	LanguageCodeEsMx = "es-MX"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeIsIs is a LanguageCode enum value
	LanguageCodeIsIs = "is-IS"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeHiIn is a LanguageCode enum value
	LanguageCodeHiIn = "hi-IN"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeNbNo is a LanguageCode enum value
	LanguageCodeNbNo = "nb-NO"

	// LanguageCodeNlNl is a LanguageCode enum value
	LanguageCodeNlNl = "nl-NL"

	// LanguageCodePlPl is a LanguageCode enum value
	LanguageCodePlPl = "pl-PL"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodePtPt is a LanguageCode enum value
	LanguageCodePtPt = "pt-PT"

	// LanguageCodeRoRo is a LanguageCode enum value
	LanguageCodeRoRo = "ro-RO"

	// LanguageCodeRuRu is a LanguageCode enum value
	LanguageCodeRuRu = "ru-RU"

	// LanguageCodeSvSe is a LanguageCode enum value
	LanguageCodeSvSe = "sv-SE"

	// LanguageCodeTrTr is a LanguageCode enum value
	LanguageCodeTrTr = "tr-TR"

	// LanguageCodeEnNz is a LanguageCode enum value
	LanguageCodeEnNz = "en-NZ"

	// LanguageCodeEnZa is a LanguageCode enum value
	LanguageCodeEnZa = "en-ZA"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeArb,
		LanguageCodeCmnCn,
		LanguageCodeCyGb,
		LanguageCodeDaDk,
		LanguageCodeDeDe,
		LanguageCodeEnAu,
		LanguageCodeEnGb,
		LanguageCodeEnGbWls,
		LanguageCodeEnIn,
		LanguageCodeEnUs,
		LanguageCodeEsEs,
		LanguageCodeEsMx,
		LanguageCodeEsUs,
		LanguageCodeFrCa,
		LanguageCodeFrFr,
		LanguageCodeIsIs,
		LanguageCodeItIt,
		LanguageCodeJaJp,
		LanguageCodeHiIn,
		LanguageCodeKoKr,
		LanguageCodeNbNo,
		LanguageCodeNlNl,
		LanguageCodePlPl,
		LanguageCodePtBr,
		LanguageCodePtPt,
		LanguageCodeRoRo,
		LanguageCodeRuRu,
		LanguageCodeSvSe,
		LanguageCodeTrTr,
		LanguageCodeEnNz,
		LanguageCodeEnZa,
	}
}

const (
	// OutputFormatJson is a OutputFormat enum value
	OutputFormatJson = "json"

	// OutputFormatMp3 is a OutputFormat enum value
	OutputFormatMp3 = "mp3"

	// OutputFormatOggVorbis is a OutputFormat enum value
	OutputFormatOggVorbis = "ogg_vorbis"

	// OutputFormatPcm is a OutputFormat enum value
	OutputFormatPcm = "pcm"
)

// OutputFormat_Values returns all elements of the OutputFormat enum
func OutputFormat_Values() []string {
	return []string{
		OutputFormatJson,
		OutputFormatMp3,
		OutputFormatOggVorbis,
		OutputFormatPcm,
	}
}

const (
	// SpeechMarkTypeSentence is a SpeechMarkType enum value
	SpeechMarkTypeSentence = "sentence"

	// SpeechMarkTypeSsml is a SpeechMarkType enum value
	SpeechMarkTypeSsml = "ssml"

	// SpeechMarkTypeViseme is a SpeechMarkType enum value
	SpeechMarkTypeViseme = "viseme"

	// SpeechMarkTypeWord is a SpeechMarkType enum value
	SpeechMarkTypeWord = "word"
)

// SpeechMarkType_Values returns all elements of the SpeechMarkType enum
func SpeechMarkType_Values() []string {
	return []string{
		SpeechMarkTypeSentence,
		SpeechMarkTypeSsml,
		SpeechMarkTypeViseme,
		SpeechMarkTypeWord,
	}
}

const (
	// TaskStatusScheduled is a TaskStatus enum value
	TaskStatusScheduled = "scheduled"

	// TaskStatusInProgress is a TaskStatus enum value
	TaskStatusInProgress = "inProgress"

	// TaskStatusCompleted is a TaskStatus enum value
	TaskStatusCompleted = "completed"

	// TaskStatusFailed is a TaskStatus enum value
	TaskStatusFailed = "failed"
)

// TaskStatus_Values returns all elements of the TaskStatus enum
func TaskStatus_Values() []string {
	return []string{
		TaskStatusScheduled,
		TaskStatusInProgress,
		TaskStatusCompleted,
		TaskStatusFailed,
	}
}

const (
	// TextTypeSsml is a TextType enum value
	TextTypeSsml = "ssml"

	// TextTypeText is a TextType enum value
	TextTypeText = "text"
)

// TextType_Values returns all elements of the TextType enum
func TextType_Values() []string {
	return []string{
		TextTypeSsml,
		TextTypeText,
	}
}

const (
	// VoiceIdAditi is a VoiceId enum value
	VoiceIdAditi = "Aditi"

	// VoiceIdAmy is a VoiceId enum value
	VoiceIdAmy = "Amy"

	// VoiceIdAstrid is a VoiceId enum value
	VoiceIdAstrid = "Astrid"

	// VoiceIdBianca is a VoiceId enum value
	VoiceIdBianca = "Bianca"

	// VoiceIdBrian is a VoiceId enum value
	VoiceIdBrian = "Brian"

	// VoiceIdCamila is a VoiceId enum value
	VoiceIdCamila = "Camila"

	// VoiceIdCarla is a VoiceId enum value
	VoiceIdCarla = "Carla"

	// VoiceIdCarmen is a VoiceId enum value
	VoiceIdCarmen = "Carmen"

	// VoiceIdCeline is a VoiceId enum value
	VoiceIdCeline = "Celine"

	// VoiceIdChantal is a VoiceId enum value
	VoiceIdChantal = "Chantal"

	// VoiceIdConchita is a VoiceId enum value
	VoiceIdConchita = "Conchita"

	// VoiceIdCristiano is a VoiceId enum value
	VoiceIdCristiano = "Cristiano"

	// VoiceIdDora is a VoiceId enum value
	VoiceIdDora = "Dora"

	// VoiceIdEmma is a VoiceId enum value
	VoiceIdEmma = "Emma"

	// VoiceIdEnrique is a VoiceId enum value
	VoiceIdEnrique = "Enrique"

	// VoiceIdEwa is a VoiceId enum value
	VoiceIdEwa = "Ewa"

	// VoiceIdFiliz is a VoiceId enum value
	VoiceIdFiliz = "Filiz"

	// VoiceIdGabrielle is a VoiceId enum value
	VoiceIdGabrielle = "Gabrielle"

	// VoiceIdGeraint is a VoiceId enum value
	VoiceIdGeraint = "Geraint"

	// VoiceIdGiorgio is a VoiceId enum value
	VoiceIdGiorgio = "Giorgio"

	// VoiceIdGwyneth is a VoiceId enum value
	VoiceIdGwyneth = "Gwyneth"

	// VoiceIdHans is a VoiceId enum value
	VoiceIdHans = "Hans"

	// VoiceIdInes is a VoiceId enum value
	VoiceIdInes = "Ines"

	// VoiceIdIvy is a VoiceId enum value
	VoiceIdIvy = "Ivy"

	// VoiceIdJacek is a VoiceId enum value
	VoiceIdJacek = "Jacek"

	// VoiceIdJan is a VoiceId enum value
	VoiceIdJan = "Jan"

	// VoiceIdJoanna is a VoiceId enum value
	VoiceIdJoanna = "Joanna"

	// VoiceIdJoey is a VoiceId enum value
	VoiceIdJoey = "Joey"

	// VoiceIdJustin is a VoiceId enum value
	VoiceIdJustin = "Justin"

	// VoiceIdKarl is a VoiceId enum value
	VoiceIdKarl = "Karl"

	// VoiceIdKendra is a VoiceId enum value
	VoiceIdKendra = "Kendra"

	// VoiceIdKevin is a VoiceId enum value
	VoiceIdKevin = "Kevin"

	// VoiceIdKimberly is a VoiceId enum value
	VoiceIdKimberly = "Kimberly"

	// VoiceIdLea is a VoiceId enum value
	VoiceIdLea = "Lea"

	// VoiceIdLiv is a VoiceId enum value
	VoiceIdLiv = "Liv"

	// VoiceIdLotte is a VoiceId enum value
	VoiceIdLotte = "Lotte"

	// VoiceIdLucia is a VoiceId enum value
	VoiceIdLucia = "Lucia"

	// VoiceIdLupe is a VoiceId enum value
	VoiceIdLupe = "Lupe"

	// VoiceIdMads is a VoiceId enum value
	VoiceIdMads = "Mads"

	// VoiceIdMaja is a VoiceId enum value
	VoiceIdMaja = "Maja"

	// VoiceIdMarlene is a VoiceId enum value
	VoiceIdMarlene = "Marlene"

	// VoiceIdMathieu is a VoiceId enum value
	VoiceIdMathieu = "Mathieu"

	// VoiceIdMatthew is a VoiceId enum value
	VoiceIdMatthew = "Matthew"

	// VoiceIdMaxim is a VoiceId enum value
	VoiceIdMaxim = "Maxim"

	// VoiceIdMia is a VoiceId enum value
	VoiceIdMia = "Mia"

	// VoiceIdMiguel is a VoiceId enum value
	VoiceIdMiguel = "Miguel"

	// VoiceIdMizuki is a VoiceId enum value
	VoiceIdMizuki = "Mizuki"

	// VoiceIdNaja is a VoiceId enum value
	VoiceIdNaja = "Naja"

	// VoiceIdNicole is a VoiceId enum value
	VoiceIdNicole = "Nicole"

	// VoiceIdOlivia is a VoiceId enum value
	VoiceIdOlivia = "Olivia"

	// VoiceIdPenelope is a VoiceId enum value
	VoiceIdPenelope = "Penelope"

	// VoiceIdRaveena is a VoiceId enum value
	VoiceIdRaveena = "Raveena"

	// VoiceIdRicardo is a VoiceId enum value
	VoiceIdRicardo = "Ricardo"

	// VoiceIdRuben is a VoiceId enum value
	VoiceIdRuben = "Ruben"

	// VoiceIdRussell is a VoiceId enum value
	VoiceIdRussell = "Russell"

	// VoiceIdSalli is a VoiceId enum value
	VoiceIdSalli = "Salli"

	// VoiceIdSeoyeon is a VoiceId enum value
	VoiceIdSeoyeon = "Seoyeon"

	// VoiceIdTakumi is a VoiceId enum value
	VoiceIdTakumi = "Takumi"

	// VoiceIdTatyana is a VoiceId enum value
	VoiceIdTatyana = "Tatyana"

	// VoiceIdVicki is a VoiceId enum value
	VoiceIdVicki = "Vicki"

	// VoiceIdVitoria is a VoiceId enum value
	VoiceIdVitoria = "Vitoria"

	// VoiceIdZeina is a VoiceId enum value
	VoiceIdZeina = "Zeina"

	// VoiceIdZhiyu is a VoiceId enum value
	VoiceIdZhiyu = "Zhiyu"

	// VoiceIdAria is a VoiceId enum value
	VoiceIdAria = "Aria"

	// VoiceIdAyanda is a VoiceId enum value
	VoiceIdAyanda = "Ayanda"
)

// VoiceId_Values returns all elements of the VoiceId enum
func VoiceId_Values() []string {
	return []string{
		VoiceIdAditi,
		VoiceIdAmy,
		VoiceIdAstrid,
		VoiceIdBianca,
		VoiceIdBrian,
		VoiceIdCamila,
		VoiceIdCarla,
		VoiceIdCarmen,
		VoiceIdCeline,
		VoiceIdChantal,
		VoiceIdConchita,
		VoiceIdCristiano,
		VoiceIdDora,
		VoiceIdEmma,
		VoiceIdEnrique,
		VoiceIdEwa,
		VoiceIdFiliz,
		VoiceIdGabrielle,
		VoiceIdGeraint,
		VoiceIdGiorgio,
		VoiceIdGwyneth,
		VoiceIdHans,
		VoiceIdInes,
		VoiceIdIvy,
		VoiceIdJacek,
		VoiceIdJan,
		VoiceIdJoanna,
		VoiceIdJoey,
		VoiceIdJustin,
		VoiceIdKarl,
		VoiceIdKendra,
		VoiceIdKevin,
		VoiceIdKimberly,
		VoiceIdLea,
		VoiceIdLiv,
		VoiceIdLotte,
		VoiceIdLucia,
		VoiceIdLupe,
		VoiceIdMads,
		VoiceIdMaja,
		VoiceIdMarlene,
		VoiceIdMathieu,
		VoiceIdMatthew,
		VoiceIdMaxim,
		VoiceIdMia,
		VoiceIdMiguel,
		VoiceIdMizuki,
		VoiceIdNaja,
		VoiceIdNicole,
		VoiceIdOlivia,
		VoiceIdPenelope,
		VoiceIdRaveena,
		VoiceIdRicardo,
		VoiceIdRuben,
		VoiceIdRussell,
		VoiceIdSalli,
		VoiceIdSeoyeon,
		VoiceIdTakumi,
		VoiceIdTatyana,
		VoiceIdVicki,
		VoiceIdVitoria,
		VoiceIdZeina,
		VoiceIdZhiyu,
		VoiceIdAria,
		VoiceIdAyanda,
	}
}
