/*
Copyright 2017 The Portworx Operator Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	clientset "github.com/portworx/talisman/pkg/client/clientset/versioned"
	portworxv1beta1 "github.com/portworx/talisman/pkg/client/clientset/versioned/typed/portworx/v1beta1"
	fakeportworxv1beta1 "github.com/portworx/talisman/pkg/client/clientset/versioned/typed/portworx/v1beta1/fake"
	portworxv1beta2 "github.com/portworx/talisman/pkg/client/clientset/versioned/typed/portworx/v1beta2"
	fakeportworxv1beta2 "github.com/portworx/talisman/pkg/client/clientset/versioned/typed/portworx/v1beta2/fake"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/watch"
	"k8s.io/client-go/discovery"
	fakediscovery "k8s.io/client-go/discovery/fake"
	"k8s.io/client-go/testing"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewSimpleClientset(objects ...runtime.Object) *Clientset {
	o := testing.NewObjectTracker(scheme, codecs.UniversalDecoder())
	for _, obj := range objects {
		if err := o.Add(obj); err != nil {
			panic(err)
		}
	}

	cs := &Clientset{}
	cs.discovery = &fakediscovery.FakeDiscovery{Fake: &cs.Fake}
	cs.AddReactor("*", "*", testing.ObjectReaction(o))
	cs.AddWatchReactor("*", func(action testing.Action) (handled bool, ret watch.Interface, err error) {
		gvr := action.GetResource()
		ns := action.GetNamespace()
		watch, err := o.Watch(gvr, ns)
		if err != nil {
			return false, nil, err
		}
		return true, watch, nil
	})

	return cs
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	testing.Fake
	discovery *fakediscovery.FakeDiscovery
}

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

var _ clientset.Interface = &Clientset{}

// PortworxV1beta1 retrieves the PortworxV1beta1Client
func (c *Clientset) PortworxV1beta1() portworxv1beta1.PortworxV1beta1Interface {
	return &fakeportworxv1beta1.FakePortworxV1beta1{Fake: &c.Fake}
}

// PortworxV1beta2 retrieves the PortworxV1beta2Client
func (c *Clientset) PortworxV1beta2() portworxv1beta2.PortworxV1beta2Interface {
	return &fakeportworxv1beta2.FakePortworxV1beta2{Fake: &c.Fake}
}

// Portworx retrieves the PortworxV1beta2Client
func (c *Clientset) Portworx() portworxv1beta2.PortworxV1beta2Interface {
	return &fakeportworxv1beta2.FakePortworxV1beta2{Fake: &c.Fake}
}
