/*
Copyright 2017 The Portworx Operator Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1beta2

import (
	time "time"

	portworxv1beta2 "github.com/portworx/talisman/pkg/apis/portworx/v1beta2"
	versioned "github.com/portworx/talisman/pkg/client/clientset/versioned"
	internalinterfaces "github.com/portworx/talisman/pkg/client/informers/externalversions/internalinterfaces"
	v1beta2 "github.com/portworx/talisman/pkg/client/listers/portworx/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// VolumePlacementStrategyInformer provides access to a shared informer and lister for
// VolumePlacementStrategies.
type VolumePlacementStrategyInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta2.VolumePlacementStrategyLister
}

type volumePlacementStrategyInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewVolumePlacementStrategyInformer constructs a new informer for VolumePlacementStrategy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewVolumePlacementStrategyInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredVolumePlacementStrategyInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredVolumePlacementStrategyInformer constructs a new informer for VolumePlacementStrategy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredVolumePlacementStrategyInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.PortworxV1beta2().VolumePlacementStrategies().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.PortworxV1beta2().VolumePlacementStrategies().Watch(options)
			},
		},
		&portworxv1beta2.VolumePlacementStrategy{},
		resyncPeriod,
		indexers,
	)
}

func (f *volumePlacementStrategyInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredVolumePlacementStrategyInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *volumePlacementStrategyInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&portworxv1beta2.VolumePlacementStrategy{}, f.defaultInformer)
}

func (f *volumePlacementStrategyInformer) Lister() v1beta2.VolumePlacementStrategyLister {
	return v1beta2.NewVolumePlacementStrategyLister(f.Informer().GetIndexer())
}
