// Code generated by protoc-gen-go. DO NOT EDIT.
// source: api/api.proto

package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Status int32

const (
	Status_STATUS_NONE                     Status = 0
	Status_STATUS_INIT                     Status = 1
	Status_STATUS_OK                       Status = 2
	Status_STATUS_OFFLINE                  Status = 3
	Status_STATUS_ERROR                    Status = 4
	Status_STATUS_NOT_IN_QUORUM            Status = 5
	Status_STATUS_DECOMMISSION             Status = 6
	Status_STATUS_MAINTENANCE              Status = 7
	Status_STATUS_STORAGE_DOWN             Status = 8
	Status_STATUS_STORAGE_DEGRADED         Status = 9
	Status_STATUS_NEEDS_REBOOT             Status = 10
	Status_STATUS_STORAGE_REBALANCE        Status = 11
	Status_STATUS_STORAGE_DRIVE_REPLACE    Status = 12
	Status_STATUS_NOT_IN_QUORUM_NO_STORAGE Status = 13
	// Add statuses before MAX and update the number for MAX
	Status_STATUS_MAX Status = 14
)

var Status_name = map[int32]string{
	0:  "STATUS_NONE",
	1:  "STATUS_INIT",
	2:  "STATUS_OK",
	3:  "STATUS_OFFLINE",
	4:  "STATUS_ERROR",
	5:  "STATUS_NOT_IN_QUORUM",
	6:  "STATUS_DECOMMISSION",
	7:  "STATUS_MAINTENANCE",
	8:  "STATUS_STORAGE_DOWN",
	9:  "STATUS_STORAGE_DEGRADED",
	10: "STATUS_NEEDS_REBOOT",
	11: "STATUS_STORAGE_REBALANCE",
	12: "STATUS_STORAGE_DRIVE_REPLACE",
	13: "STATUS_NOT_IN_QUORUM_NO_STORAGE",
	14: "STATUS_MAX",
}
var Status_value = map[string]int32{
	"STATUS_NONE":                     0,
	"STATUS_INIT":                     1,
	"STATUS_OK":                       2,
	"STATUS_OFFLINE":                  3,
	"STATUS_ERROR":                    4,
	"STATUS_NOT_IN_QUORUM":            5,
	"STATUS_DECOMMISSION":             6,
	"STATUS_MAINTENANCE":              7,
	"STATUS_STORAGE_DOWN":             8,
	"STATUS_STORAGE_DEGRADED":         9,
	"STATUS_NEEDS_REBOOT":             10,
	"STATUS_STORAGE_REBALANCE":        11,
	"STATUS_STORAGE_DRIVE_REPLACE":    12,
	"STATUS_NOT_IN_QUORUM_NO_STORAGE": 13,
	"STATUS_MAX":                      14,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{0}
}

type DriverType int32

const (
	DriverType_DRIVER_TYPE_NONE      DriverType = 0
	DriverType_DRIVER_TYPE_FILE      DriverType = 1
	DriverType_DRIVER_TYPE_BLOCK     DriverType = 2
	DriverType_DRIVER_TYPE_OBJECT    DriverType = 3
	DriverType_DRIVER_TYPE_CLUSTERED DriverType = 4
	DriverType_DRIVER_TYPE_GRAPH     DriverType = 5
)

var DriverType_name = map[int32]string{
	0: "DRIVER_TYPE_NONE",
	1: "DRIVER_TYPE_FILE",
	2: "DRIVER_TYPE_BLOCK",
	3: "DRIVER_TYPE_OBJECT",
	4: "DRIVER_TYPE_CLUSTERED",
	5: "DRIVER_TYPE_GRAPH",
}
var DriverType_value = map[string]int32{
	"DRIVER_TYPE_NONE":      0,
	"DRIVER_TYPE_FILE":      1,
	"DRIVER_TYPE_BLOCK":     2,
	"DRIVER_TYPE_OBJECT":    3,
	"DRIVER_TYPE_CLUSTERED": 4,
	"DRIVER_TYPE_GRAPH":     5,
}

func (x DriverType) String() string {
	return proto.EnumName(DriverType_name, int32(x))
}
func (DriverType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{1}
}

type FSType int32

const (
	FSType_FS_TYPE_NONE  FSType = 0
	FSType_FS_TYPE_BTRFS FSType = 1
	FSType_FS_TYPE_EXT4  FSType = 2
	FSType_FS_TYPE_FUSE  FSType = 3
	FSType_FS_TYPE_NFS   FSType = 4
	FSType_FS_TYPE_VFS   FSType = 5
	FSType_FS_TYPE_XFS   FSType = 6
	FSType_FS_TYPE_ZFS   FSType = 7
	FSType_FS_TYPE_XFSv2 FSType = 8
)

var FSType_name = map[int32]string{
	0: "FS_TYPE_NONE",
	1: "FS_TYPE_BTRFS",
	2: "FS_TYPE_EXT4",
	3: "FS_TYPE_FUSE",
	4: "FS_TYPE_NFS",
	5: "FS_TYPE_VFS",
	6: "FS_TYPE_XFS",
	7: "FS_TYPE_ZFS",
	8: "FS_TYPE_XFSv2",
}
var FSType_value = map[string]int32{
	"FS_TYPE_NONE":  0,
	"FS_TYPE_BTRFS": 1,
	"FS_TYPE_EXT4":  2,
	"FS_TYPE_FUSE":  3,
	"FS_TYPE_NFS":   4,
	"FS_TYPE_VFS":   5,
	"FS_TYPE_XFS":   6,
	"FS_TYPE_ZFS":   7,
	"FS_TYPE_XFSv2": 8,
}

func (x FSType) String() string {
	return proto.EnumName(FSType_name, int32(x))
}
func (FSType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{2}
}

type GraphDriverChangeType int32

const (
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE     GraphDriverChangeType = 0
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_MODIFIED GraphDriverChangeType = 1
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_ADDED    GraphDriverChangeType = 2
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_DELETED  GraphDriverChangeType = 3
)

var GraphDriverChangeType_name = map[int32]string{
	0: "GRAPH_DRIVER_CHANGE_TYPE_NONE",
	1: "GRAPH_DRIVER_CHANGE_TYPE_MODIFIED",
	2: "GRAPH_DRIVER_CHANGE_TYPE_ADDED",
	3: "GRAPH_DRIVER_CHANGE_TYPE_DELETED",
}
var GraphDriverChangeType_value = map[string]int32{
	"GRAPH_DRIVER_CHANGE_TYPE_NONE":     0,
	"GRAPH_DRIVER_CHANGE_TYPE_MODIFIED": 1,
	"GRAPH_DRIVER_CHANGE_TYPE_ADDED":    2,
	"GRAPH_DRIVER_CHANGE_TYPE_DELETED":  3,
}

func (x GraphDriverChangeType) String() string {
	return proto.EnumName(GraphDriverChangeType_name, int32(x))
}
func (GraphDriverChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{3}
}

type SeverityType int32

const (
	SeverityType_SEVERITY_TYPE_NONE    SeverityType = 0
	SeverityType_SEVERITY_TYPE_ALARM   SeverityType = 1
	SeverityType_SEVERITY_TYPE_WARNING SeverityType = 2
	SeverityType_SEVERITY_TYPE_NOTIFY  SeverityType = 3
)

var SeverityType_name = map[int32]string{
	0: "SEVERITY_TYPE_NONE",
	1: "SEVERITY_TYPE_ALARM",
	2: "SEVERITY_TYPE_WARNING",
	3: "SEVERITY_TYPE_NOTIFY",
}
var SeverityType_value = map[string]int32{
	"SEVERITY_TYPE_NONE":    0,
	"SEVERITY_TYPE_ALARM":   1,
	"SEVERITY_TYPE_WARNING": 2,
	"SEVERITY_TYPE_NOTIFY":  3,
}

func (x SeverityType) String() string {
	return proto.EnumName(SeverityType_name, int32(x))
}
func (SeverityType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{4}
}

type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_NONE    ResourceType = 0
	ResourceType_RESOURCE_TYPE_VOLUME  ResourceType = 1
	ResourceType_RESOURCE_TYPE_NODE    ResourceType = 2
	ResourceType_RESOURCE_TYPE_CLUSTER ResourceType = 3
	ResourceType_RESOURCE_TYPE_DRIVE   ResourceType = 4
)

var ResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_NONE",
	1: "RESOURCE_TYPE_VOLUME",
	2: "RESOURCE_TYPE_NODE",
	3: "RESOURCE_TYPE_CLUSTER",
	4: "RESOURCE_TYPE_DRIVE",
}
var ResourceType_value = map[string]int32{
	"RESOURCE_TYPE_NONE":    0,
	"RESOURCE_TYPE_VOLUME":  1,
	"RESOURCE_TYPE_NODE":    2,
	"RESOURCE_TYPE_CLUSTER": 3,
	"RESOURCE_TYPE_DRIVE":   4,
}

func (x ResourceType) String() string {
	return proto.EnumName(ResourceType_name, int32(x))
}
func (ResourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{5}
}

type AlertActionType int32

const (
	AlertActionType_ALERT_ACTION_TYPE_NONE   AlertActionType = 0
	AlertActionType_ALERT_ACTION_TYPE_DELETE AlertActionType = 1
	AlertActionType_ALERT_ACTION_TYPE_CREATE AlertActionType = 2
	AlertActionType_ALERT_ACTION_TYPE_UPDATE AlertActionType = 3
)

var AlertActionType_name = map[int32]string{
	0: "ALERT_ACTION_TYPE_NONE",
	1: "ALERT_ACTION_TYPE_DELETE",
	2: "ALERT_ACTION_TYPE_CREATE",
	3: "ALERT_ACTION_TYPE_UPDATE",
}
var AlertActionType_value = map[string]int32{
	"ALERT_ACTION_TYPE_NONE":   0,
	"ALERT_ACTION_TYPE_DELETE": 1,
	"ALERT_ACTION_TYPE_CREATE": 2,
	"ALERT_ACTION_TYPE_UPDATE": 3,
}

func (x AlertActionType) String() string {
	return proto.EnumName(AlertActionType_name, int32(x))
}
func (AlertActionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{6}
}

type VolumeActionParam int32

const (
	VolumeActionParam_VOLUME_ACTION_PARAM_NONE VolumeActionParam = 0
	// Maps to the boolean value false
	VolumeActionParam_VOLUME_ACTION_PARAM_OFF VolumeActionParam = 1
	// Maps to the boolean value true.
	VolumeActionParam_VOLUME_ACTION_PARAM_ON VolumeActionParam = 2
)

var VolumeActionParam_name = map[int32]string{
	0: "VOLUME_ACTION_PARAM_NONE",
	1: "VOLUME_ACTION_PARAM_OFF",
	2: "VOLUME_ACTION_PARAM_ON",
}
var VolumeActionParam_value = map[string]int32{
	"VOLUME_ACTION_PARAM_NONE": 0,
	"VOLUME_ACTION_PARAM_OFF":  1,
	"VOLUME_ACTION_PARAM_ON":   2,
}

func (x VolumeActionParam) String() string {
	return proto.EnumName(VolumeActionParam_name, int32(x))
}
func (VolumeActionParam) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{7}
}

type CosType int32

const (
	CosType_NONE   CosType = 0
	CosType_LOW    CosType = 1
	CosType_MEDIUM CosType = 2
	CosType_HIGH   CosType = 3
)

var CosType_name = map[int32]string{
	0: "NONE",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}
var CosType_value = map[string]int32{
	"NONE":   0,
	"LOW":    1,
	"MEDIUM": 2,
	"HIGH":   3,
}

func (x CosType) String() string {
	return proto.EnumName(CosType_name, int32(x))
}
func (CosType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{8}
}

type IoProfile int32

const (
	IoProfile_IO_PROFILE_SEQUENTIAL IoProfile = 0
	IoProfile_IO_PROFILE_RANDOM     IoProfile = 1
	IoProfile_IO_PROFILE_DB         IoProfile = 2
	IoProfile_IO_PROFILE_DB_REMOTE  IoProfile = 3
	IoProfile_IO_PROFILE_CMS        IoProfile = 4
)

var IoProfile_name = map[int32]string{
	0: "IO_PROFILE_SEQUENTIAL",
	1: "IO_PROFILE_RANDOM",
	2: "IO_PROFILE_DB",
	3: "IO_PROFILE_DB_REMOTE",
	4: "IO_PROFILE_CMS",
}
var IoProfile_value = map[string]int32{
	"IO_PROFILE_SEQUENTIAL": 0,
	"IO_PROFILE_RANDOM":     1,
	"IO_PROFILE_DB":         2,
	"IO_PROFILE_DB_REMOTE":  3,
	"IO_PROFILE_CMS":        4,
}

func (x IoProfile) String() string {
	return proto.EnumName(IoProfile_name, int32(x))
}
func (IoProfile) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{9}
}

// VolumeState represents the state of a volume.
type VolumeState int32

const (
	VolumeState_VOLUME_STATE_NONE VolumeState = 0
	// Volume is transitioning to new state
	VolumeState_VOLUME_STATE_PENDING VolumeState = 1
	// Volume is ready to be assigned to a container
	VolumeState_VOLUME_STATE_AVAILABLE VolumeState = 2
	// Volume is attached to container
	VolumeState_VOLUME_STATE_ATTACHED VolumeState = 3
	// Volume is detached but associated with a container
	VolumeState_VOLUME_STATE_DETACHED VolumeState = 4
	// Volume detach is in progress
	VolumeState_VOLUME_STATE_DETATCHING VolumeState = 5
	// Volume is in error state
	VolumeState_VOLUME_STATE_ERROR VolumeState = 6
	// Volume is deleted, it will remain in this state
	// while resources are asynchronously reclaimed
	VolumeState_VOLUME_STATE_DELETED VolumeState = 7
	// Volume is trying to be detached
	VolumeState_VOLUME_STATE_TRY_DETACHING VolumeState = 8
	// Volume is undergoing restore
	VolumeState_VOLUME_STATE_RESTORE VolumeState = 9
)

var VolumeState_name = map[int32]string{
	0: "VOLUME_STATE_NONE",
	1: "VOLUME_STATE_PENDING",
	2: "VOLUME_STATE_AVAILABLE",
	3: "VOLUME_STATE_ATTACHED",
	4: "VOLUME_STATE_DETACHED",
	5: "VOLUME_STATE_DETATCHING",
	6: "VOLUME_STATE_ERROR",
	7: "VOLUME_STATE_DELETED",
	8: "VOLUME_STATE_TRY_DETACHING",
	9: "VOLUME_STATE_RESTORE",
}
var VolumeState_value = map[string]int32{
	"VOLUME_STATE_NONE":          0,
	"VOLUME_STATE_PENDING":       1,
	"VOLUME_STATE_AVAILABLE":     2,
	"VOLUME_STATE_ATTACHED":      3,
	"VOLUME_STATE_DETACHED":      4,
	"VOLUME_STATE_DETATCHING":    5,
	"VOLUME_STATE_ERROR":         6,
	"VOLUME_STATE_DELETED":       7,
	"VOLUME_STATE_TRY_DETACHING": 8,
	"VOLUME_STATE_RESTORE":       9,
}

func (x VolumeState) String() string {
	return proto.EnumName(VolumeState_name, int32(x))
}
func (VolumeState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{10}
}

// VolumeStatus represents a health status for a volume.
type VolumeStatus int32

const (
	VolumeStatus_VOLUME_STATUS_NONE VolumeStatus = 0
	// Volume is not present
	VolumeStatus_VOLUME_STATUS_NOT_PRESENT VolumeStatus = 1
	// Volume is healthy
	VolumeStatus_VOLUME_STATUS_UP VolumeStatus = 2
	// Volume is in fail mode
	VolumeStatus_VOLUME_STATUS_DOWN VolumeStatus = 3
	// Volume is up but with degraded performance
	// In a RAID group, this may indicate a problem with one or more drives
	VolumeStatus_VOLUME_STATUS_DEGRADED VolumeStatus = 4
)

var VolumeStatus_name = map[int32]string{
	0: "VOLUME_STATUS_NONE",
	1: "VOLUME_STATUS_NOT_PRESENT",
	2: "VOLUME_STATUS_UP",
	3: "VOLUME_STATUS_DOWN",
	4: "VOLUME_STATUS_DEGRADED",
}
var VolumeStatus_value = map[string]int32{
	"VOLUME_STATUS_NONE":        0,
	"VOLUME_STATUS_NOT_PRESENT": 1,
	"VOLUME_STATUS_UP":          2,
	"VOLUME_STATUS_DOWN":        3,
	"VOLUME_STATUS_DEGRADED":    4,
}

func (x VolumeStatus) String() string {
	return proto.EnumName(VolumeStatus_name, int32(x))
}
func (VolumeStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{11}
}

type StorageMedium int32

const (
	// Magnetic spinning disk.
	StorageMedium_STORAGE_MEDIUM_MAGNETIC StorageMedium = 0
	// SSD disk
	StorageMedium_STORAGE_MEDIUM_SSD StorageMedium = 1
	// NVME disk
	StorageMedium_STORAGE_MEDIUM_NVME StorageMedium = 2
)

var StorageMedium_name = map[int32]string{
	0: "STORAGE_MEDIUM_MAGNETIC",
	1: "STORAGE_MEDIUM_SSD",
	2: "STORAGE_MEDIUM_NVME",
}
var StorageMedium_value = map[string]int32{
	"STORAGE_MEDIUM_MAGNETIC": 0,
	"STORAGE_MEDIUM_SSD":      1,
	"STORAGE_MEDIUM_NVME":     2,
}

func (x StorageMedium) String() string {
	return proto.EnumName(StorageMedium_name, int32(x))
}
func (StorageMedium) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{12}
}

type AttachState int32

const (
	// Attached and available externally
	AttachState_ATTACH_STATE_EXTERNAL AttachState = 0
	// Attached but only available internally
	AttachState_ATTACH_STATE_INTERNAL AttachState = 1
	// Switching from External to Internal
	AttachState_ATTACH_STATE_INTERNAL_SWITCH AttachState = 2
)

var AttachState_name = map[int32]string{
	0: "ATTACH_STATE_EXTERNAL",
	1: "ATTACH_STATE_INTERNAL",
	2: "ATTACH_STATE_INTERNAL_SWITCH",
}
var AttachState_value = map[string]int32{
	"ATTACH_STATE_EXTERNAL":        0,
	"ATTACH_STATE_INTERNAL":        1,
	"ATTACH_STATE_INTERNAL_SWITCH": 2,
}

func (x AttachState) String() string {
	return proto.EnumName(AttachState_name, int32(x))
}
func (AttachState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{13}
}

type OperationFlags int32

const (
	OperationFlags_OP_FLAGS_UNKNOWN OperationFlags = 0
	OperationFlags_OP_FLAGS_NONE    OperationFlags = 1
	// Perform a force_detach during detach operation
	OperationFlags_OP_FLAGS_DETACH_FORCE OperationFlags = 2
)

var OperationFlags_name = map[int32]string{
	0: "OP_FLAGS_UNKNOWN",
	1: "OP_FLAGS_NONE",
	2: "OP_FLAGS_DETACH_FORCE",
}
var OperationFlags_value = map[string]int32{
	"OP_FLAGS_UNKNOWN":      0,
	"OP_FLAGS_NONE":         1,
	"OP_FLAGS_DETACH_FORCE": 2,
}

func (x OperationFlags) String() string {
	return proto.EnumName(OperationFlags_name, int32(x))
}
func (OperationFlags) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{14}
}

// Defines times of day
type SdkTimeWeekday int32

const (
	// Sunday
	SdkTimeWeekday_SdkTimeWeekdaySunday SdkTimeWeekday = 0
	// Monday
	SdkTimeWeekday_SdkTimeWeekdayMonday SdkTimeWeekday = 1
	// Tuesday
	SdkTimeWeekday_SdkTimeWeekdayTuesday SdkTimeWeekday = 2
	// Wednesday
	SdkTimeWeekday_SdkTimeWeekdayWednesday SdkTimeWeekday = 3
	// Thursday
	SdkTimeWeekday_SdkTimeWeekdayThursday SdkTimeWeekday = 4
	// Friday
	SdkTimeWeekday_SdkTimeWeekdayFriday SdkTimeWeekday = 5
	// Saturday
	SdkTimeWeekday_SdkTimeWeekdaySaturday SdkTimeWeekday = 6
)

var SdkTimeWeekday_name = map[int32]string{
	0: "SdkTimeWeekdaySunday",
	1: "SdkTimeWeekdayMonday",
	2: "SdkTimeWeekdayTuesday",
	3: "SdkTimeWeekdayWednesday",
	4: "SdkTimeWeekdayThursday",
	5: "SdkTimeWeekdayFriday",
	6: "SdkTimeWeekdaySaturday",
}
var SdkTimeWeekday_value = map[string]int32{
	"SdkTimeWeekdaySunday":    0,
	"SdkTimeWeekdayMonday":    1,
	"SdkTimeWeekdayTuesday":   2,
	"SdkTimeWeekdayWednesday": 3,
	"SdkTimeWeekdayThursday":  4,
	"SdkTimeWeekdayFriday":    5,
	"SdkTimeWeekdaySaturday":  6,
}

func (x SdkTimeWeekday) String() string {
	return proto.EnumName(SdkTimeWeekday_name, int32(x))
}
func (SdkTimeWeekday) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{15}
}

// CloudBackup operations types
type SdkCloudBackupOpType int32

const (
	// Unknown
	SdkCloudBackupOpType_SdkCloudBackupOpTypeUnknown SdkCloudBackupOpType = 0
	// Backup
	SdkCloudBackupOpType_SdkCloudBackupOpTypeBackupOp SdkCloudBackupOpType = 1
	// Restore
	SdkCloudBackupOpType_SdkCloudBackupOpTypeRestoreOp SdkCloudBackupOpType = 2
)

var SdkCloudBackupOpType_name = map[int32]string{
	0: "SdkCloudBackupOpTypeUnknown",
	1: "SdkCloudBackupOpTypeBackupOp",
	2: "SdkCloudBackupOpTypeRestoreOp",
}
var SdkCloudBackupOpType_value = map[string]int32{
	"SdkCloudBackupOpTypeUnknown":   0,
	"SdkCloudBackupOpTypeBackupOp":  1,
	"SdkCloudBackupOpTypeRestoreOp": 2,
}

func (x SdkCloudBackupOpType) String() string {
	return proto.EnumName(SdkCloudBackupOpType_name, int32(x))
}
func (SdkCloudBackupOpType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{16}
}

// CloudBackup status types
type SdkCloudBackupStatusType int32

const (
	// Unkonwn
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeUnknown SdkCloudBackupStatusType = 0
	// Not started
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeNotStarted SdkCloudBackupStatusType = 1
	// Done
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeDone SdkCloudBackupStatusType = 2
	// Aborted
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeAborted SdkCloudBackupStatusType = 3
	// Paused
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypePaused SdkCloudBackupStatusType = 4
	// Stopped
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeStopped SdkCloudBackupStatusType = 5
	// Active
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeActive SdkCloudBackupStatusType = 6
	// Failed
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeFailed SdkCloudBackupStatusType = 7
	// Queued
	SdkCloudBackupStatusType_SdkCloudBackupStatusTypeQueued SdkCloudBackupStatusType = 8
)

var SdkCloudBackupStatusType_name = map[int32]string{
	0: "SdkCloudBackupStatusTypeUnknown",
	1: "SdkCloudBackupStatusTypeNotStarted",
	2: "SdkCloudBackupStatusTypeDone",
	3: "SdkCloudBackupStatusTypeAborted",
	4: "SdkCloudBackupStatusTypePaused",
	5: "SdkCloudBackupStatusTypeStopped",
	6: "SdkCloudBackupStatusTypeActive",
	7: "SdkCloudBackupStatusTypeFailed",
	8: "SdkCloudBackupStatusTypeQueued",
}
var SdkCloudBackupStatusType_value = map[string]int32{
	"SdkCloudBackupStatusTypeUnknown":    0,
	"SdkCloudBackupStatusTypeNotStarted": 1,
	"SdkCloudBackupStatusTypeDone":       2,
	"SdkCloudBackupStatusTypeAborted":    3,
	"SdkCloudBackupStatusTypePaused":     4,
	"SdkCloudBackupStatusTypeStopped":    5,
	"SdkCloudBackupStatusTypeActive":     6,
	"SdkCloudBackupStatusTypeFailed":     7,
	"SdkCloudBackupStatusTypeQueued":     8,
}

func (x SdkCloudBackupStatusType) String() string {
	return proto.EnumName(SdkCloudBackupStatusType_name, int32(x))
}
func (SdkCloudBackupStatusType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{17}
}

// SdkCloudBackupRequestedState defines states to set a specified backup or restore
// to or from a cloud provider
type SdkCloudBackupRequestedState int32

const (
	// Unknown state
	SdkCloudBackupRequestedState_SdkCloudBackupRequestedStateUnknown SdkCloudBackupRequestedState = 0
	// Pause the backup or restore
	SdkCloudBackupRequestedState_SdkCloudBackupRequestedStatePause SdkCloudBackupRequestedState = 1
	// Resume the backup or restore
	SdkCloudBackupRequestedState_SdkCloudBackupRequestedStateResume SdkCloudBackupRequestedState = 2
	// Stop a backup or restore
	SdkCloudBackupRequestedState_SdkCloudBackupRequestedStateStop SdkCloudBackupRequestedState = 3
)

var SdkCloudBackupRequestedState_name = map[int32]string{
	0: "SdkCloudBackupRequestedStateUnknown",
	1: "SdkCloudBackupRequestedStatePause",
	2: "SdkCloudBackupRequestedStateResume",
	3: "SdkCloudBackupRequestedStateStop",
}
var SdkCloudBackupRequestedState_value = map[string]int32{
	"SdkCloudBackupRequestedStateUnknown": 0,
	"SdkCloudBackupRequestedStatePause":   1,
	"SdkCloudBackupRequestedStateResume":  2,
	"SdkCloudBackupRequestedStateStop":    3,
}

func (x SdkCloudBackupRequestedState) String() string {
	return proto.EnumName(SdkCloudBackupRequestedState_name, int32(x))
}
func (SdkCloudBackupRequestedState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{18}
}

// This defines an operator for the policy comparisons
type VolumeSpecPolicy_PolicyOp int32

const (
	// Policy will make sure the value must be equal
	VolumeSpecPolicy_Equal VolumeSpecPolicy_PolicyOp = 0
	// Policy will make sure the requested value must be greater than or equal
	VolumeSpecPolicy_Minimum VolumeSpecPolicy_PolicyOp = 1
	// Policy will make sure the requested value must be less than or equal
	VolumeSpecPolicy_Maximum VolumeSpecPolicy_PolicyOp = 2
)

var VolumeSpecPolicy_PolicyOp_name = map[int32]string{
	0: "Equal",
	1: "Minimum",
	2: "Maximum",
}
var VolumeSpecPolicy_PolicyOp_value = map[string]int32{
	"Equal":   0,
	"Minimum": 1,
	"Maximum": 2,
}

func (x VolumeSpecPolicy_PolicyOp) String() string {
	return proto.EnumName(VolumeSpecPolicy_PolicyOp_name, int32(x))
}
func (VolumeSpecPolicy_PolicyOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{9, 0}
}

// Access types can be set by owner to have different levels of access to
// a resource.
//
// It is up to the resource to interpret what the types mean and are
// used for.
type Ownership_AccessType int32

const (
	// Read access only and cannot affect the resource.
	Ownership_Read Ownership_AccessType = 0
	// Write access and can affect the resource.
	// This type automatically provides Read access also.
	Ownership_Write Ownership_AccessType = 1
	// Administrator access.
	// This type automatically provides Read and Write access also.
	Ownership_Admin Ownership_AccessType = 2
)

var Ownership_AccessType_name = map[int32]string{
	0: "Read",
	1: "Write",
	2: "Admin",
}
var Ownership_AccessType_value = map[string]int32{
	"Read":  0,
	"Write": 1,
	"Admin": 2,
}

func (x Ownership_AccessType) String() string {
	return proto.EnumName(Ownership_AccessType_name, int32(x))
}
func (Ownership_AccessType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{12, 0}
}

type SdkServiceCapability_OpenStorageService_Type int32

const (
	// Unknown service
	SdkServiceCapability_OpenStorageService_UNKNOWN SdkServiceCapability_OpenStorageService_Type = 0
	// Cluster management
	SdkServiceCapability_OpenStorageService_CLUSTER SdkServiceCapability_OpenStorageService_Type = 1
	// Cloud backup of volumes management
	SdkServiceCapability_OpenStorageService_CLOUD_BACKUP SdkServiceCapability_OpenStorageService_Type = 2
	// Credentials management
	SdkServiceCapability_OpenStorageService_CREDENTIALS SdkServiceCapability_OpenStorageService_Type = 3
	// Node management
	SdkServiceCapability_OpenStorageService_NODE SdkServiceCapability_OpenStorageService_Type = 4
	// Object Storage management
	SdkServiceCapability_OpenStorageService_OBJECT_STORAGE SdkServiceCapability_OpenStorageService_Type = 5
	// Schedule policy management
	SdkServiceCapability_OpenStorageService_SCHEDULE_POLICY SdkServiceCapability_OpenStorageService_Type = 6
	// Volume management
	SdkServiceCapability_OpenStorageService_VOLUME SdkServiceCapability_OpenStorageService_Type = 7
	// Alert enumeration
	SdkServiceCapability_OpenStorageService_ALERTS SdkServiceCapability_OpenStorageService_Type = 8
	// Mount/Attach Support
	SdkServiceCapability_OpenStorageService_MOUNT_ATTACH SdkServiceCapability_OpenStorageService_Type = 9
	// Role service
	SdkServiceCapability_OpenStorageService_ROLE SdkServiceCapability_OpenStorageService_Type = 10
	// Cluster Pair service
	SdkServiceCapability_OpenStorageService_CLUSTER_PAIR SdkServiceCapability_OpenStorageService_Type = 11
	// Migrate service
	SdkServiceCapability_OpenStorageService_MIGRATE SdkServiceCapability_OpenStorageService_Type = 12
	// StoragePolicy Service
	SdkServiceCapability_OpenStorageService_STORAGE_POLICY SdkServiceCapability_OpenStorageService_Type = 13
)

var SdkServiceCapability_OpenStorageService_Type_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "CLUSTER",
	2:  "CLOUD_BACKUP",
	3:  "CREDENTIALS",
	4:  "NODE",
	5:  "OBJECT_STORAGE",
	6:  "SCHEDULE_POLICY",
	7:  "VOLUME",
	8:  "ALERTS",
	9:  "MOUNT_ATTACH",
	10: "ROLE",
	11: "CLUSTER_PAIR",
	12: "MIGRATE",
	13: "STORAGE_POLICY",
}
var SdkServiceCapability_OpenStorageService_Type_value = map[string]int32{
	"UNKNOWN":         0,
	"CLUSTER":         1,
	"CLOUD_BACKUP":    2,
	"CREDENTIALS":     3,
	"NODE":            4,
	"OBJECT_STORAGE":  5,
	"SCHEDULE_POLICY": 6,
	"VOLUME":          7,
	"ALERTS":          8,
	"MOUNT_ATTACH":    9,
	"ROLE":            10,
	"CLUSTER_PAIR":    11,
	"MIGRATE":         12,
	"STORAGE_POLICY":  13,
}

func (x SdkServiceCapability_OpenStorageService_Type) String() string {
	return proto.EnumName(SdkServiceCapability_OpenStorageService_Type_name, int32(x))
}
func (SdkServiceCapability_OpenStorageService_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{206, 0, 0}
}

// These values are constants that can be used by the
// client and server applications
type SdkVersion_Version int32

const (
	// Must be set in the proto file; ignore.
	SdkVersion_MUST_HAVE_ZERO_VALUE SdkVersion_Version = 0
	// SDK version major value of this specification
	SdkVersion_Major SdkVersion_Version = 0
	// SDK version minor value of this specification
	SdkVersion_Minor SdkVersion_Version = 52
	// SDK version patch value of this specification
	SdkVersion_Patch SdkVersion_Version = 0
)

var SdkVersion_Version_name = map[int32]string{
	0: "MUST_HAVE_ZERO_VALUE",
	// Duplicate value: 0: "Major",
	52: "Minor",
	// Duplicate value: 0: "Patch",
}
var SdkVersion_Version_value = map[string]int32{
	"MUST_HAVE_ZERO_VALUE": 0,
	"Major":                0,
	"Minor":                52,
	"Patch":                0,
}

func (x SdkVersion_Version) String() string {
	return proto.EnumName(SdkVersion_Version_name, int32(x))
}
func (SdkVersion_Version) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{207, 0}
}

type CloudMigrate_OperationType int32

const (
	CloudMigrate_InvalidType CloudMigrate_OperationType = 0
	// Migrate all volumes in the cluster
	CloudMigrate_MigrateCluster CloudMigrate_OperationType = 1
	// Migrate a single volume
	CloudMigrate_MigrateVolume CloudMigrate_OperationType = 2
	// Migrate a group of volumes
	CloudMigrate_MigrateVolumeGroup CloudMigrate_OperationType = 3
)

var CloudMigrate_OperationType_name = map[int32]string{
	0: "InvalidType",
	1: "MigrateCluster",
	2: "MigrateVolume",
	3: "MigrateVolumeGroup",
}
var CloudMigrate_OperationType_value = map[string]int32{
	"InvalidType":        0,
	"MigrateCluster":     1,
	"MigrateVolume":      2,
	"MigrateVolumeGroup": 3,
}

func (x CloudMigrate_OperationType) String() string {
	return proto.EnumName(CloudMigrate_OperationType_name, int32(x))
}
func (CloudMigrate_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{209, 0}
}

type CloudMigrate_Stage int32

const (
	CloudMigrate_InvalidStage CloudMigrate_Stage = 0
	CloudMigrate_Backup       CloudMigrate_Stage = 1
	CloudMigrate_Restore      CloudMigrate_Stage = 2
	CloudMigrate_VolumeUpdate CloudMigrate_Stage = 3
	CloudMigrate_Done         CloudMigrate_Stage = 4
)

var CloudMigrate_Stage_name = map[int32]string{
	0: "InvalidStage",
	1: "Backup",
	2: "Restore",
	3: "VolumeUpdate",
	4: "Done",
}
var CloudMigrate_Stage_value = map[string]int32{
	"InvalidStage": 0,
	"Backup":       1,
	"Restore":      2,
	"VolumeUpdate": 3,
	"Done":         4,
}

func (x CloudMigrate_Stage) String() string {
	return proto.EnumName(CloudMigrate_Stage_name, int32(x))
}
func (CloudMigrate_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{209, 1}
}

type CloudMigrate_Status int32

const (
	CloudMigrate_InvalidStatus CloudMigrate_Status = 0
	CloudMigrate_Queued        CloudMigrate_Status = 1
	CloudMigrate_Initialized   CloudMigrate_Status = 2
	CloudMigrate_InProgress    CloudMigrate_Status = 3
	CloudMigrate_Failed        CloudMigrate_Status = 4
	CloudMigrate_Complete      CloudMigrate_Status = 5
	CloudMigrate_Canceled      CloudMigrate_Status = 6
)

var CloudMigrate_Status_name = map[int32]string{
	0: "InvalidStatus",
	1: "Queued",
	2: "Initialized",
	3: "InProgress",
	4: "Failed",
	5: "Complete",
	6: "Canceled",
}
var CloudMigrate_Status_value = map[string]int32{
	"InvalidStatus": 0,
	"Queued":        1,
	"Initialized":   2,
	"InProgress":    3,
	"Failed":        4,
	"Complete":      5,
	"Canceled":      6,
}

func (x CloudMigrate_Status) String() string {
	return proto.EnumName(CloudMigrate_Status_name, int32(x))
}
func (CloudMigrate_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{209, 2}
}

type ClusterPairMode_Mode int32

const (
	// Default pairing mode
	ClusterPairMode_Default ClusterPairMode_Mode = 0
	// Paired for DisasterRecovery
	ClusterPairMode_DisasterRecovery ClusterPairMode_Mode = 1
)

var ClusterPairMode_Mode_name = map[int32]string{
	0: "Default",
	1: "DisasterRecovery",
}
var ClusterPairMode_Mode_value = map[string]int32{
	"Default":          0,
	"DisasterRecovery": 1,
}

func (x ClusterPairMode_Mode) String() string {
	return proto.EnumName(ClusterPairMode_Mode_name, int32(x))
}
func (ClusterPairMode_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{223, 0}
}

// Defines the types of enforcement on the given rules
type VolumePlacementRule_EnforcementType int32

const (
	// This specifies that the rule is required and must be strictly enforced
	VolumePlacementRule_required VolumePlacementRule_EnforcementType = 0
	// This specifies that the rule is preferred and can be best effort
	VolumePlacementRule_preferred VolumePlacementRule_EnforcementType = 1
)

var VolumePlacementRule_EnforcementType_name = map[int32]string{
	0: "required",
	1: "preferred",
}
var VolumePlacementRule_EnforcementType_value = map[string]int32{
	"required":  0,
	"preferred": 1,
}

func (x VolumePlacementRule_EnforcementType) String() string {
	return proto.EnumName(VolumePlacementRule_EnforcementType_name, int32(x))
}
func (VolumePlacementRule_EnforcementType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{249, 0}
}

// This specifies the type an affinity rule can take
type VolumePlacementRule_AffinityRuleType int32

const (
	// Affinity means the rule specifies an affinity to objects that match the below label selector requirements
	VolumePlacementRule_affinity VolumePlacementRule_AffinityRuleType = 0
	// AntiAffinity means the rule specifies an anti-affinity to objects that match the below label selector requirements
	VolumePlacementRule_antiAffinity VolumePlacementRule_AffinityRuleType = 1
)

var VolumePlacementRule_AffinityRuleType_name = map[int32]string{
	0: "affinity",
	1: "antiAffinity",
}
var VolumePlacementRule_AffinityRuleType_value = map[string]int32{
	"affinity":     0,
	"antiAffinity": 1,
}

func (x VolumePlacementRule_AffinityRuleType) String() string {
	return proto.EnumName(VolumePlacementRule_AffinityRuleType_name, int32(x))
}
func (VolumePlacementRule_AffinityRuleType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{249, 1}
}

// This defines operator types used in a label matching rule
type LabelSelectorRequirement_Operator int32

const (
	// In means the value for 'key' should be in one of the given value(s)
	LabelSelectorRequirement_In LabelSelectorRequirement_Operator = 0
	// NotIn means the value for 'key' should NOT be in one of the given value(s)
	LabelSelectorRequirement_NotIn LabelSelectorRequirement_Operator = 1
	// Exists means the 'key' should just exist regardless of the value
	LabelSelectorRequirement_Exists LabelSelectorRequirement_Operator = 2
	// DoesNotExist means the 'key' should NOT exist
	LabelSelectorRequirement_DoesNotExist LabelSelectorRequirement_Operator = 3
	// Gt means the 'key' should be greater than the value(s)
	LabelSelectorRequirement_Gt LabelSelectorRequirement_Operator = 4
	// Lt means the 'key' should be less than the value(s)
	LabelSelectorRequirement_Lt LabelSelectorRequirement_Operator = 5
)

var LabelSelectorRequirement_Operator_name = map[int32]string{
	0: "In",
	1: "NotIn",
	2: "Exists",
	3: "DoesNotExist",
	4: "Gt",
	5: "Lt",
}
var LabelSelectorRequirement_Operator_value = map[string]int32{
	"In":           0,
	"NotIn":        1,
	"Exists":       2,
	"DoesNotExist": 3,
	"Gt":           4,
	"Lt":           5,
}

func (x LabelSelectorRequirement_Operator) String() string {
	return proto.EnumName(LabelSelectorRequirement_Operator_name, int32(x))
}
func (LabelSelectorRequirement_Operator) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{250, 0}
}

// StorageResource groups properties of a storage device.
type StorageResource struct {
	// Id is the LUN identifier.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Path device path for this storage resource.
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Storage medium.
	Medium StorageMedium `protobuf:"varint,3,opt,name=medium,enum=openstorage.api.StorageMedium" json:"medium,omitempty"`
	// True if this device is online.
	Online bool `protobuf:"varint,4,opt,name=online" json:"online,omitempty"`
	// IOPS
	Iops uint64 `protobuf:"varint,5,opt,name=iops" json:"iops,omitempty"`
	// SeqWrite
	SeqWrite float64 `protobuf:"fixed64,6,opt,name=seq_write,json=seqWrite" json:"seq_write,omitempty"`
	// SeqRead
	SeqRead float64 `protobuf:"fixed64,7,opt,name=seq_read,json=seqRead" json:"seq_read,omitempty"`
	// RandRW
	RandRW float64 `protobuf:"fixed64,8,opt,name=randRW" json:"randRW,omitempty"`
	// Total size in bytes.
	Size uint64 `protobuf:"varint,9,opt,name=size" json:"size,omitempty"`
	// Physical Bytes used.
	Used uint64 `protobuf:"varint,10,opt,name=used" json:"used,omitempty"`
	// True if this device is rotational.
	RotationSpeed string `protobuf:"bytes,11,opt,name=rotation_speed,json=rotationSpeed" json:"rotation_speed,omitempty"`
	// Timestamp of last time this device was scanned.
	LastScan *timestamp.Timestamp `protobuf:"bytes,12,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
	// True if dedicated for metadata.
	Metadata bool `protobuf:"varint,13,opt,name=metadata" json:"metadata,omitempty"`
	// True if dedicated as cache
	Cache                bool     `protobuf:"varint,14,opt,name=cache" json:"cache,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageResource) Reset()         { *m = StorageResource{} }
func (m *StorageResource) String() string { return proto.CompactTextString(m) }
func (*StorageResource) ProtoMessage()    {}
func (*StorageResource) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{0}
}
func (m *StorageResource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageResource.Unmarshal(m, b)
}
func (m *StorageResource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageResource.Marshal(b, m, deterministic)
}
func (dst *StorageResource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageResource.Merge(dst, src)
}
func (m *StorageResource) XXX_Size() int {
	return xxx_messageInfo_StorageResource.Size(m)
}
func (m *StorageResource) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageResource.DiscardUnknown(m)
}

var xxx_messageInfo_StorageResource proto.InternalMessageInfo

func (m *StorageResource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StorageResource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *StorageResource) GetMedium() StorageMedium {
	if m != nil {
		return m.Medium
	}
	return StorageMedium_STORAGE_MEDIUM_MAGNETIC
}

func (m *StorageResource) GetOnline() bool {
	if m != nil {
		return m.Online
	}
	return false
}

func (m *StorageResource) GetIops() uint64 {
	if m != nil {
		return m.Iops
	}
	return 0
}

func (m *StorageResource) GetSeqWrite() float64 {
	if m != nil {
		return m.SeqWrite
	}
	return 0
}

func (m *StorageResource) GetSeqRead() float64 {
	if m != nil {
		return m.SeqRead
	}
	return 0
}

func (m *StorageResource) GetRandRW() float64 {
	if m != nil {
		return m.RandRW
	}
	return 0
}

func (m *StorageResource) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *StorageResource) GetUsed() uint64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *StorageResource) GetRotationSpeed() string {
	if m != nil {
		return m.RotationSpeed
	}
	return ""
}

func (m *StorageResource) GetLastScan() *timestamp.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

func (m *StorageResource) GetMetadata() bool {
	if m != nil {
		return m.Metadata
	}
	return false
}

func (m *StorageResource) GetCache() bool {
	if m != nil {
		return m.Cache
	}
	return false
}

// StoragePool groups different storage devices based on their CosType
type StoragePool struct {
	// ID pool ID
	ID int32 `protobuf:"varint,1,opt,name=ID" json:"ID,omitempty"`
	// Cos reflects the capabilities of this drive pool
	Cos CosType `protobuf:"varint,2,opt,name=Cos,enum=openstorage.api.CosType" json:"Cos,omitempty"`
	// Medium underlying storage type
	Medium StorageMedium `protobuf:"varint,3,opt,name=Medium,enum=openstorage.api.StorageMedium" json:"Medium,omitempty"`
	// RaidLevel storage raid level
	RaidLevel string `protobuf:"bytes,4,opt,name=RaidLevel" json:"RaidLevel,omitempty"`
	// TotalSize of the pool
	TotalSize uint64 `protobuf:"varint,7,opt,name=TotalSize" json:"TotalSize,omitempty"`
	// Used size of the pool
	Used uint64 `protobuf:"varint,8,opt,name=Used" json:"Used,omitempty"`
	// Labels is a list of user defined name-value pairs
	Labels               map[string]string `protobuf:"bytes,9,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StoragePool) Reset()         { *m = StoragePool{} }
func (m *StoragePool) String() string { return proto.CompactTextString(m) }
func (*StoragePool) ProtoMessage()    {}
func (*StoragePool) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{1}
}
func (m *StoragePool) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoragePool.Unmarshal(m, b)
}
func (m *StoragePool) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoragePool.Marshal(b, m, deterministic)
}
func (dst *StoragePool) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoragePool.Merge(dst, src)
}
func (m *StoragePool) XXX_Size() int {
	return xxx_messageInfo_StoragePool.Size(m)
}
func (m *StoragePool) XXX_DiscardUnknown() {
	xxx_messageInfo_StoragePool.DiscardUnknown(m)
}

var xxx_messageInfo_StoragePool proto.InternalMessageInfo

func (m *StoragePool) GetID() int32 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *StoragePool) GetCos() CosType {
	if m != nil {
		return m.Cos
	}
	return CosType_NONE
}

func (m *StoragePool) GetMedium() StorageMedium {
	if m != nil {
		return m.Medium
	}
	return StorageMedium_STORAGE_MEDIUM_MAGNETIC
}

func (m *StoragePool) GetRaidLevel() string {
	if m != nil {
		return m.RaidLevel
	}
	return ""
}

func (m *StoragePool) GetTotalSize() uint64 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

func (m *StoragePool) GetUsed() uint64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *StoragePool) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// VolumeLocator is a structure that is attached to a volume
// and is used to carry opaque metadata.
type VolumeLocator struct {
	// User friendly identifier
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A set of name-value pairs that acts as search filters
	VolumeLabels map[string]string `protobuf:"bytes,2,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Filter with ownership
	Ownership *Ownership `protobuf:"bytes,3,opt,name=ownership" json:"ownership,omitempty"`
	// Filter by group
	Group *Group `protobuf:"bytes,4,opt,name=group" json:"group,omitempty"`
	// Volume Ids to match
	VolumeIds            []string `protobuf:"bytes,5,rep,name=volume_ids,json=volumeIds" json:"volume_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeLocator) Reset()         { *m = VolumeLocator{} }
func (m *VolumeLocator) String() string { return proto.CompactTextString(m) }
func (*VolumeLocator) ProtoMessage()    {}
func (*VolumeLocator) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{2}
}
func (m *VolumeLocator) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeLocator.Unmarshal(m, b)
}
func (m *VolumeLocator) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeLocator.Marshal(b, m, deterministic)
}
func (dst *VolumeLocator) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeLocator.Merge(dst, src)
}
func (m *VolumeLocator) XXX_Size() int {
	return xxx_messageInfo_VolumeLocator.Size(m)
}
func (m *VolumeLocator) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeLocator.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeLocator proto.InternalMessageInfo

func (m *VolumeLocator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeLocator) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

func (m *VolumeLocator) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *VolumeLocator) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *VolumeLocator) GetVolumeIds() []string {
	if m != nil {
		return m.VolumeIds
	}
	return nil
}

// Options used for volume inspection
type VolumeInspectOptions struct {
	// Deep inspection is used to collect more information about
	// the volume. Setting this value may delay the request.
	Deep                 bool     `protobuf:"varint,1,opt,name=deep" json:"deep,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeInspectOptions) Reset()         { *m = VolumeInspectOptions{} }
func (m *VolumeInspectOptions) String() string { return proto.CompactTextString(m) }
func (*VolumeInspectOptions) ProtoMessage()    {}
func (*VolumeInspectOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{3}
}
func (m *VolumeInspectOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeInspectOptions.Unmarshal(m, b)
}
func (m *VolumeInspectOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeInspectOptions.Marshal(b, m, deterministic)
}
func (dst *VolumeInspectOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeInspectOptions.Merge(dst, src)
}
func (m *VolumeInspectOptions) XXX_Size() int {
	return xxx_messageInfo_VolumeInspectOptions.Size(m)
}
func (m *VolumeInspectOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeInspectOptions.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeInspectOptions proto.InternalMessageInfo

func (m *VolumeInspectOptions) GetDeep() bool {
	if m != nil {
		return m.Deep
	}
	return false
}

// Source is a structure that can be given to a volume
// to seed the volume with data.
type Source struct {
	// A volume id, if specified will create a clone of the parent.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Seed will seed the volume from the specified URI
	// Any additional config for the source comes from the labels in the spec
	Seed                 string   `protobuf:"bytes,2,opt,name=seed" json:"seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{4}
}
func (m *Source) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Source.Unmarshal(m, b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Source.Marshal(b, m, deterministic)
}
func (dst *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(dst, src)
}
func (m *Source) XXX_Size() int {
	return xxx_messageInfo_Source.Size(m)
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

func (m *Source) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Source) GetSeed() string {
	if m != nil {
		return m.Seed
	}
	return ""
}

// Group represents VolumeGroup / namespace
// All volumes in the same group share this object.
type Group struct {
	// Id common identifier across volumes that have the same group.
	Id                   string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{5}
}
func (m *Group) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Group.Unmarshal(m, b)
}
func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Group.Marshal(b, m, deterministic)
}
func (dst *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(dst, src)
}
func (m *Group) XXX_Size() int {
	return xxx_messageInfo_Group.Size(m)
}
func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// IoStrategy defines how I/O should be performed to backing storage media.
type IoStrategy struct {
	// AsyncIO enables kaio.
	AsyncIo bool `protobuf:"varint,1,opt,name=async_io,json=asyncIo" json:"async_io,omitempty"`
	// EarlyAck enables acks for async I/O at the source.
	EarlyAck             bool     `protobuf:"varint,2,opt,name=early_ack,json=earlyAck" json:"early_ack,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IoStrategy) Reset()         { *m = IoStrategy{} }
func (m *IoStrategy) String() string { return proto.CompactTextString(m) }
func (*IoStrategy) ProtoMessage()    {}
func (*IoStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{6}
}
func (m *IoStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IoStrategy.Unmarshal(m, b)
}
func (m *IoStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IoStrategy.Marshal(b, m, deterministic)
}
func (dst *IoStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IoStrategy.Merge(dst, src)
}
func (m *IoStrategy) XXX_Size() int {
	return xxx_messageInfo_IoStrategy.Size(m)
}
func (m *IoStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_IoStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_IoStrategy proto.InternalMessageInfo

func (m *IoStrategy) GetAsyncIo() bool {
	if m != nil {
		return m.AsyncIo
	}
	return false
}

func (m *IoStrategy) GetEarlyAck() bool {
	if m != nil {
		return m.EarlyAck
	}
	return false
}

// VolumeSpec has the properties needed to create a volume.
type VolumeSpec struct {
	// Ephemeral storage
	Ephemeral bool `protobuf:"varint,1,opt,name=ephemeral" json:"ephemeral,omitempty"`
	// Size specifies the thin provisioned volume size in bytes
	Size uint64 `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	// Format specifies the filesystem for this volume.
	Format FSType `protobuf:"varint,3,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	// BlockSize for the filesystem.
	BlockSize int64 `protobuf:"varint,4,opt,name=block_size,json=blockSize" json:"block_size,omitempty"`
	// HaLevel specifies the number of copies of data.
	HaLevel int64 `protobuf:"varint,5,opt,name=ha_level,json=haLevel" json:"ha_level,omitempty"`
	// Cos specifies the relative class of service.
	Cos CosType `protobuf:"varint,6,opt,name=cos,enum=openstorage.api.CosType" json:"cos,omitempty"`
	// IoProfile provides a hint about application using this volume.
	IoProfile IoProfile `protobuf:"varint,7,opt,name=io_profile,json=ioProfile,enum=openstorage.api.IoProfile" json:"io_profile,omitempty"`
	// Dedupe specifies if the volume data is to be de-duplicated.
	Dedupe bool `protobuf:"varint,8,opt,name=dedupe" json:"dedupe,omitempty"`
	// SnapshotInterval in minutes, set to 0 to disable snapshots
	SnapshotInterval uint32 `protobuf:"varint,9,opt,name=snapshot_interval,json=snapshotInterval" json:"snapshot_interval,omitempty"`
	// (deprecated, do not use) VolumeLabels configuration labels
	VolumeLabels map[string]string `protobuf:"bytes,10,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Shared is true if this volume can be concurrently accessed by multiple users.
	Shared bool `protobuf:"varint,11,opt,name=shared" json:"shared,omitempty"`
	// ReplicaSet is the desired set of nodes for the volume data.
	ReplicaSet *ReplicaSet `protobuf:"bytes,12,opt,name=replica_set,json=replicaSet" json:"replica_set,omitempty"`
	// Aggregation level Specifies the number of parts the volume can be aggregated from.
	AggregationLevel uint32 `protobuf:"varint,13,opt,name=aggregation_level,json=aggregationLevel" json:"aggregation_level,omitempty"`
	// Encrypted is true if this volume will be cryptographically secured.
	Encrypted bool `protobuf:"varint,14,opt,name=encrypted" json:"encrypted,omitempty"`
	// Passphrase for an encrypted volume
	Passphrase string `protobuf:"bytes,15,opt,name=passphrase" json:"passphrase,omitempty"`
	// SnapshotSchedule a well known string that specifies when snapshots should be taken.
	SnapshotSchedule string `protobuf:"bytes,16,opt,name=snapshot_schedule,json=snapshotSchedule" json:"snapshot_schedule,omitempty"`
	// Scale allows autocreation of volumes.
	Scale uint32 `protobuf:"varint,17,opt,name=scale" json:"scale,omitempty"`
	// Sticky volumes cannot be deleted until the flag is removed.
	Sticky bool `protobuf:"varint,18,opt,name=sticky" json:"sticky,omitempty"`
	// Group identifies a consistency group
	Group *Group `protobuf:"bytes,21,opt,name=group" json:"group,omitempty"`
	// GroupEnforced is true if consistency group creation is enforced.
	GroupEnforced bool `protobuf:"varint,22,opt,name=group_enforced,json=groupEnforced" json:"group_enforced,omitempty"`
	// Compressed is true if this volume is to be compressed.
	Compressed bool `protobuf:"varint,23,opt,name=compressed" json:"compressed,omitempty"`
	// Cascaded is true if this volume can be populated on any node from an external source.
	Cascaded bool `protobuf:"varint,24,opt,name=cascaded" json:"cascaded,omitempty"`
	// Journal is true if data for the volume goes into the journal.
	Journal bool `protobuf:"varint,25,opt,name=journal" json:"journal,omitempty"`
	// Sharedv4 is true if this volume can be accessed via sharedv4.
	Sharedv4 bool `protobuf:"varint,26,opt,name=sharedv4" json:"sharedv4,omitempty"`
	// QueueDepth defines the desired block device queue depth
	QueueDepth uint32 `protobuf:"varint,27,opt,name=queue_depth,json=queueDepth" json:"queue_depth,omitempty"`
	// Use to force a file system type which is not recommended.
	// The driver may still refuse to use the file system type.
	ForceUnsupportedFsType bool `protobuf:"varint,28,opt,name=force_unsupported_fs_type,json=forceUnsupportedFsType" json:"force_unsupported_fs_type,omitempty"`
	// Nodiscard specifies if the volume will be mounted with discard support disabled.
	// i.e. FS will not release allocated blocks back to the backing storage pool.
	Nodiscard bool `protobuf:"varint,29,opt,name=nodiscard" json:"nodiscard,omitempty"`
	// IoStrategy preferred strategy for I/O.
	IoStrategy *IoStrategy `protobuf:"bytes,30,opt,name=io_strategy,json=ioStrategy" json:"io_strategy,omitempty"`
	// PlacementStrategy specifies a spec to indicate where to place the volume.
	PlacementStrategy *VolumePlacementStrategy `protobuf:"bytes,31,opt,name=placement_strategy,json=placementStrategy" json:"placement_strategy,omitempty"`
	// StoragePolicy if applied/specified while creating volume
	StoragePolicy string `protobuf:"bytes,32,opt,name=storage_policy,json=storagePolicy" json:"storage_policy,omitempty"`
	// Owner
	Ownership            *Ownership `protobuf:"bytes,33,opt,name=ownership" json:"ownership,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *VolumeSpec) Reset()         { *m = VolumeSpec{} }
func (m *VolumeSpec) String() string { return proto.CompactTextString(m) }
func (*VolumeSpec) ProtoMessage()    {}
func (*VolumeSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{7}
}
func (m *VolumeSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeSpec.Unmarshal(m, b)
}
func (m *VolumeSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeSpec.Marshal(b, m, deterministic)
}
func (dst *VolumeSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSpec.Merge(dst, src)
}
func (m *VolumeSpec) XXX_Size() int {
	return xxx_messageInfo_VolumeSpec.Size(m)
}
func (m *VolumeSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSpec.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSpec proto.InternalMessageInfo

func (m *VolumeSpec) GetEphemeral() bool {
	if m != nil {
		return m.Ephemeral
	}
	return false
}

func (m *VolumeSpec) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *VolumeSpec) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *VolumeSpec) GetBlockSize() int64 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

func (m *VolumeSpec) GetHaLevel() int64 {
	if m != nil {
		return m.HaLevel
	}
	return 0
}

func (m *VolumeSpec) GetCos() CosType {
	if m != nil {
		return m.Cos
	}
	return CosType_NONE
}

func (m *VolumeSpec) GetIoProfile() IoProfile {
	if m != nil {
		return m.IoProfile
	}
	return IoProfile_IO_PROFILE_SEQUENTIAL
}

func (m *VolumeSpec) GetDedupe() bool {
	if m != nil {
		return m.Dedupe
	}
	return false
}

func (m *VolumeSpec) GetSnapshotInterval() uint32 {
	if m != nil {
		return m.SnapshotInterval
	}
	return 0
}

func (m *VolumeSpec) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

func (m *VolumeSpec) GetShared() bool {
	if m != nil {
		return m.Shared
	}
	return false
}

func (m *VolumeSpec) GetReplicaSet() *ReplicaSet {
	if m != nil {
		return m.ReplicaSet
	}
	return nil
}

func (m *VolumeSpec) GetAggregationLevel() uint32 {
	if m != nil {
		return m.AggregationLevel
	}
	return 0
}

func (m *VolumeSpec) GetEncrypted() bool {
	if m != nil {
		return m.Encrypted
	}
	return false
}

func (m *VolumeSpec) GetPassphrase() string {
	if m != nil {
		return m.Passphrase
	}
	return ""
}

func (m *VolumeSpec) GetSnapshotSchedule() string {
	if m != nil {
		return m.SnapshotSchedule
	}
	return ""
}

func (m *VolumeSpec) GetScale() uint32 {
	if m != nil {
		return m.Scale
	}
	return 0
}

func (m *VolumeSpec) GetSticky() bool {
	if m != nil {
		return m.Sticky
	}
	return false
}

func (m *VolumeSpec) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *VolumeSpec) GetGroupEnforced() bool {
	if m != nil {
		return m.GroupEnforced
	}
	return false
}

func (m *VolumeSpec) GetCompressed() bool {
	if m != nil {
		return m.Compressed
	}
	return false
}

func (m *VolumeSpec) GetCascaded() bool {
	if m != nil {
		return m.Cascaded
	}
	return false
}

func (m *VolumeSpec) GetJournal() bool {
	if m != nil {
		return m.Journal
	}
	return false
}

func (m *VolumeSpec) GetSharedv4() bool {
	if m != nil {
		return m.Sharedv4
	}
	return false
}

func (m *VolumeSpec) GetQueueDepth() uint32 {
	if m != nil {
		return m.QueueDepth
	}
	return 0
}

func (m *VolumeSpec) GetForceUnsupportedFsType() bool {
	if m != nil {
		return m.ForceUnsupportedFsType
	}
	return false
}

func (m *VolumeSpec) GetNodiscard() bool {
	if m != nil {
		return m.Nodiscard
	}
	return false
}

func (m *VolumeSpec) GetIoStrategy() *IoStrategy {
	if m != nil {
		return m.IoStrategy
	}
	return nil
}

func (m *VolumeSpec) GetPlacementStrategy() *VolumePlacementStrategy {
	if m != nil {
		return m.PlacementStrategy
	}
	return nil
}

func (m *VolumeSpec) GetStoragePolicy() string {
	if m != nil {
		return m.StoragePolicy
	}
	return ""
}

func (m *VolumeSpec) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

// VolumeSpecUpdate provides a method to set any of the VolumeSpec of an existing volume
type VolumeSpecUpdate struct {
	// Size specifies the thin provisioned volume size in bytes
	//
	// Types that are valid to be assigned to SizeOpt:
	//	*VolumeSpecUpdate_Size
	SizeOpt isVolumeSpecUpdate_SizeOpt `protobuf_oneof:"size_opt"`
	// HaLevel specifies the number of copies of data.
	//
	// Types that are valid to be assigned to HaLevelOpt:
	//	*VolumeSpecUpdate_HaLevel
	HaLevelOpt isVolumeSpecUpdate_HaLevelOpt `protobuf_oneof:"ha_level_opt"`
	// Cos specifies the relative class of service.
	//
	// Types that are valid to be assigned to CosOpt:
	//	*VolumeSpecUpdate_Cos
	CosOpt isVolumeSpecUpdate_CosOpt `protobuf_oneof:"cos_opt"`
	// IoProfile provides a hint about application using this volume.
	//
	// Types that are valid to be assigned to IoProfileOpt:
	//	*VolumeSpecUpdate_IoProfile
	IoProfileOpt isVolumeSpecUpdate_IoProfileOpt `protobuf_oneof:"io_profile_opt"`
	// Dedupe specifies if the volume data is to be de-duplicated.
	//
	// Types that are valid to be assigned to DedupeOpt:
	//	*VolumeSpecUpdate_Dedupe
	DedupeOpt isVolumeSpecUpdate_DedupeOpt `protobuf_oneof:"dedupe_opt"`
	// SnapshotInterval in minutes, set to 0 to disable snapshots
	//
	// Types that are valid to be assigned to SnapshotIntervalOpt:
	//	*VolumeSpecUpdate_SnapshotInterval
	SnapshotIntervalOpt isVolumeSpecUpdate_SnapshotIntervalOpt `protobuf_oneof:"snapshot_interval_opt"`
	// Shared is true if this volume can be remotely accessed.
	//
	// Types that are valid to be assigned to SharedOpt:
	//	*VolumeSpecUpdate_Shared
	SharedOpt isVolumeSpecUpdate_SharedOpt `protobuf_oneof:"shared_opt"`
	// ReplicaSet is the desired set of nodes for the volume data.
	ReplicaSet *ReplicaSet `protobuf:"bytes,12,opt,name=replica_set,json=replicaSet" json:"replica_set,omitempty"`
	// Passphrase for an encrypted volume
	//
	// Types that are valid to be assigned to PassphraseOpt:
	//	*VolumeSpecUpdate_Passphrase
	PassphraseOpt isVolumeSpecUpdate_PassphraseOpt `protobuf_oneof:"passphrase_opt"`
	// SnapshotSchedule a well known string that specifies when snapshots should be taken.
	//
	// Types that are valid to be assigned to SnapshotScheduleOpt:
	//	*VolumeSpecUpdate_SnapshotSchedule
	SnapshotScheduleOpt isVolumeSpecUpdate_SnapshotScheduleOpt `protobuf_oneof:"snapshot_schedule_opt"`
	// Scale allows autocreation of volumes.
	//
	// Types that are valid to be assigned to ScaleOpt:
	//	*VolumeSpecUpdate_Scale
	ScaleOpt isVolumeSpecUpdate_ScaleOpt `protobuf_oneof:"scale_opt"`
	// Sticky volumes cannot be deleted until the flag is removed.
	//
	// Types that are valid to be assigned to StickyOpt:
	//	*VolumeSpecUpdate_Sticky
	StickyOpt isVolumeSpecUpdate_StickyOpt `protobuf_oneof:"sticky_opt"`
	// Group identifies a consistency group
	//
	// Types that are valid to be assigned to GroupOpt:
	//	*VolumeSpecUpdate_Group
	GroupOpt isVolumeSpecUpdate_GroupOpt `protobuf_oneof:"group_opt"`
	// Journal is true if data for the volume goes into the journal.
	//
	// Types that are valid to be assigned to JournalOpt:
	//	*VolumeSpecUpdate_Journal
	JournalOpt isVolumeSpecUpdate_JournalOpt `protobuf_oneof:"journal_opt"`
	// Sharedv4 is true if this volume can be accessed via sharedv4.
	//
	// Types that are valid to be assigned to Sharedv4Opt:
	//	*VolumeSpecUpdate_Sharedv4
	Sharedv4Opt isVolumeSpecUpdate_Sharedv4Opt `protobuf_oneof:"sharedv4_opt"`
	// QueueDepth defines the desired block device queue depth
	//
	// Types that are valid to be assigned to QueueDepthOpt:
	//	*VolumeSpecUpdate_QueueDepth
	QueueDepthOpt isVolumeSpecUpdate_QueueDepthOpt `protobuf_oneof:"queue_depth_opt"`
	// Ownership volume information to update. If the value of `owner` in the
	// `ownership` message is an empty string then the value of `owner` in
	// the `VolumeSpec.Ownership.owner` will not be updated.
	Ownership *Ownership `protobuf:"bytes,26,opt,name=ownership" json:"ownership,omitempty"`
	// Nodiscard specifies if the volume will be mounted with discard support disabled.
	// i.e. FS will not release allocated blocks back to the backing storage pool.
	//
	// Types that are valid to be assigned to NodiscardOpt:
	//	*VolumeSpecUpdate_Nodiscard
	NodiscardOpt isVolumeSpecUpdate_NodiscardOpt `protobuf_oneof:"nodiscard_opt"`
	// IoStrategy preferred strategy for I/O.
	IoStrategy           *IoStrategy `protobuf:"bytes,28,opt,name=io_strategy,json=ioStrategy" json:"io_strategy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *VolumeSpecUpdate) Reset()         { *m = VolumeSpecUpdate{} }
func (m *VolumeSpecUpdate) String() string { return proto.CompactTextString(m) }
func (*VolumeSpecUpdate) ProtoMessage()    {}
func (*VolumeSpecUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{8}
}
func (m *VolumeSpecUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeSpecUpdate.Unmarshal(m, b)
}
func (m *VolumeSpecUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeSpecUpdate.Marshal(b, m, deterministic)
}
func (dst *VolumeSpecUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSpecUpdate.Merge(dst, src)
}
func (m *VolumeSpecUpdate) XXX_Size() int {
	return xxx_messageInfo_VolumeSpecUpdate.Size(m)
}
func (m *VolumeSpecUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSpecUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSpecUpdate proto.InternalMessageInfo

type isVolumeSpecUpdate_SizeOpt interface {
	isVolumeSpecUpdate_SizeOpt()
}
type isVolumeSpecUpdate_HaLevelOpt interface {
	isVolumeSpecUpdate_HaLevelOpt()
}
type isVolumeSpecUpdate_CosOpt interface {
	isVolumeSpecUpdate_CosOpt()
}
type isVolumeSpecUpdate_IoProfileOpt interface {
	isVolumeSpecUpdate_IoProfileOpt()
}
type isVolumeSpecUpdate_DedupeOpt interface {
	isVolumeSpecUpdate_DedupeOpt()
}
type isVolumeSpecUpdate_SnapshotIntervalOpt interface {
	isVolumeSpecUpdate_SnapshotIntervalOpt()
}
type isVolumeSpecUpdate_SharedOpt interface {
	isVolumeSpecUpdate_SharedOpt()
}
type isVolumeSpecUpdate_PassphraseOpt interface {
	isVolumeSpecUpdate_PassphraseOpt()
}
type isVolumeSpecUpdate_SnapshotScheduleOpt interface {
	isVolumeSpecUpdate_SnapshotScheduleOpt()
}
type isVolumeSpecUpdate_ScaleOpt interface {
	isVolumeSpecUpdate_ScaleOpt()
}
type isVolumeSpecUpdate_StickyOpt interface {
	isVolumeSpecUpdate_StickyOpt()
}
type isVolumeSpecUpdate_GroupOpt interface {
	isVolumeSpecUpdate_GroupOpt()
}
type isVolumeSpecUpdate_JournalOpt interface {
	isVolumeSpecUpdate_JournalOpt()
}
type isVolumeSpecUpdate_Sharedv4Opt interface {
	isVolumeSpecUpdate_Sharedv4Opt()
}
type isVolumeSpecUpdate_QueueDepthOpt interface {
	isVolumeSpecUpdate_QueueDepthOpt()
}
type isVolumeSpecUpdate_NodiscardOpt interface {
	isVolumeSpecUpdate_NodiscardOpt()
}

type VolumeSpecUpdate_Size struct {
	Size uint64 `protobuf:"varint,2,opt,name=size,oneof"`
}
type VolumeSpecUpdate_HaLevel struct {
	HaLevel int64 `protobuf:"varint,5,opt,name=ha_level,json=haLevel,oneof"`
}
type VolumeSpecUpdate_Cos struct {
	Cos CosType `protobuf:"varint,6,opt,name=cos,enum=openstorage.api.CosType,oneof"`
}
type VolumeSpecUpdate_IoProfile struct {
	IoProfile IoProfile `protobuf:"varint,7,opt,name=io_profile,json=ioProfile,enum=openstorage.api.IoProfile,oneof"`
}
type VolumeSpecUpdate_Dedupe struct {
	Dedupe bool `protobuf:"varint,8,opt,name=dedupe,oneof"`
}
type VolumeSpecUpdate_SnapshotInterval struct {
	SnapshotInterval uint32 `protobuf:"varint,9,opt,name=snapshot_interval,json=snapshotInterval,oneof"`
}
type VolumeSpecUpdate_Shared struct {
	Shared bool `protobuf:"varint,11,opt,name=shared,oneof"`
}
type VolumeSpecUpdate_Passphrase struct {
	Passphrase string `protobuf:"bytes,15,opt,name=passphrase,oneof"`
}
type VolumeSpecUpdate_SnapshotSchedule struct {
	SnapshotSchedule string `protobuf:"bytes,16,opt,name=snapshot_schedule,json=snapshotSchedule,oneof"`
}
type VolumeSpecUpdate_Scale struct {
	Scale uint32 `protobuf:"varint,17,opt,name=scale,oneof"`
}
type VolumeSpecUpdate_Sticky struct {
	Sticky bool `protobuf:"varint,18,opt,name=sticky,oneof"`
}
type VolumeSpecUpdate_Group struct {
	Group *Group `protobuf:"bytes,19,opt,name=group,oneof"`
}
type VolumeSpecUpdate_Journal struct {
	Journal bool `protobuf:"varint,23,opt,name=journal,oneof"`
}
type VolumeSpecUpdate_Sharedv4 struct {
	Sharedv4 bool `protobuf:"varint,24,opt,name=sharedv4,oneof"`
}
type VolumeSpecUpdate_QueueDepth struct {
	QueueDepth uint32 `protobuf:"varint,25,opt,name=queue_depth,json=queueDepth,oneof"`
}
type VolumeSpecUpdate_Nodiscard struct {
	Nodiscard bool `protobuf:"varint,27,opt,name=nodiscard,oneof"`
}

func (*VolumeSpecUpdate_Size) isVolumeSpecUpdate_SizeOpt()                         {}
func (*VolumeSpecUpdate_HaLevel) isVolumeSpecUpdate_HaLevelOpt()                   {}
func (*VolumeSpecUpdate_Cos) isVolumeSpecUpdate_CosOpt()                           {}
func (*VolumeSpecUpdate_IoProfile) isVolumeSpecUpdate_IoProfileOpt()               {}
func (*VolumeSpecUpdate_Dedupe) isVolumeSpecUpdate_DedupeOpt()                     {}
func (*VolumeSpecUpdate_SnapshotInterval) isVolumeSpecUpdate_SnapshotIntervalOpt() {}
func (*VolumeSpecUpdate_Shared) isVolumeSpecUpdate_SharedOpt()                     {}
func (*VolumeSpecUpdate_Passphrase) isVolumeSpecUpdate_PassphraseOpt()             {}
func (*VolumeSpecUpdate_SnapshotSchedule) isVolumeSpecUpdate_SnapshotScheduleOpt() {}
func (*VolumeSpecUpdate_Scale) isVolumeSpecUpdate_ScaleOpt()                       {}
func (*VolumeSpecUpdate_Sticky) isVolumeSpecUpdate_StickyOpt()                     {}
func (*VolumeSpecUpdate_Group) isVolumeSpecUpdate_GroupOpt()                       {}
func (*VolumeSpecUpdate_Journal) isVolumeSpecUpdate_JournalOpt()                   {}
func (*VolumeSpecUpdate_Sharedv4) isVolumeSpecUpdate_Sharedv4Opt()                 {}
func (*VolumeSpecUpdate_QueueDepth) isVolumeSpecUpdate_QueueDepthOpt()             {}
func (*VolumeSpecUpdate_Nodiscard) isVolumeSpecUpdate_NodiscardOpt()               {}

func (m *VolumeSpecUpdate) GetSizeOpt() isVolumeSpecUpdate_SizeOpt {
	if m != nil {
		return m.SizeOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetHaLevelOpt() isVolumeSpecUpdate_HaLevelOpt {
	if m != nil {
		return m.HaLevelOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetCosOpt() isVolumeSpecUpdate_CosOpt {
	if m != nil {
		return m.CosOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetIoProfileOpt() isVolumeSpecUpdate_IoProfileOpt {
	if m != nil {
		return m.IoProfileOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetDedupeOpt() isVolumeSpecUpdate_DedupeOpt {
	if m != nil {
		return m.DedupeOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetSnapshotIntervalOpt() isVolumeSpecUpdate_SnapshotIntervalOpt {
	if m != nil {
		return m.SnapshotIntervalOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetSharedOpt() isVolumeSpecUpdate_SharedOpt {
	if m != nil {
		return m.SharedOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetPassphraseOpt() isVolumeSpecUpdate_PassphraseOpt {
	if m != nil {
		return m.PassphraseOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetSnapshotScheduleOpt() isVolumeSpecUpdate_SnapshotScheduleOpt {
	if m != nil {
		return m.SnapshotScheduleOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetScaleOpt() isVolumeSpecUpdate_ScaleOpt {
	if m != nil {
		return m.ScaleOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetStickyOpt() isVolumeSpecUpdate_StickyOpt {
	if m != nil {
		return m.StickyOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetGroupOpt() isVolumeSpecUpdate_GroupOpt {
	if m != nil {
		return m.GroupOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetJournalOpt() isVolumeSpecUpdate_JournalOpt {
	if m != nil {
		return m.JournalOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetSharedv4Opt() isVolumeSpecUpdate_Sharedv4Opt {
	if m != nil {
		return m.Sharedv4Opt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetQueueDepthOpt() isVolumeSpecUpdate_QueueDepthOpt {
	if m != nil {
		return m.QueueDepthOpt
	}
	return nil
}
func (m *VolumeSpecUpdate) GetNodiscardOpt() isVolumeSpecUpdate_NodiscardOpt {
	if m != nil {
		return m.NodiscardOpt
	}
	return nil
}

func (m *VolumeSpecUpdate) GetSize() uint64 {
	if x, ok := m.GetSizeOpt().(*VolumeSpecUpdate_Size); ok {
		return x.Size
	}
	return 0
}

func (m *VolumeSpecUpdate) GetHaLevel() int64 {
	if x, ok := m.GetHaLevelOpt().(*VolumeSpecUpdate_HaLevel); ok {
		return x.HaLevel
	}
	return 0
}

func (m *VolumeSpecUpdate) GetCos() CosType {
	if x, ok := m.GetCosOpt().(*VolumeSpecUpdate_Cos); ok {
		return x.Cos
	}
	return CosType_NONE
}

func (m *VolumeSpecUpdate) GetIoProfile() IoProfile {
	if x, ok := m.GetIoProfileOpt().(*VolumeSpecUpdate_IoProfile); ok {
		return x.IoProfile
	}
	return IoProfile_IO_PROFILE_SEQUENTIAL
}

func (m *VolumeSpecUpdate) GetDedupe() bool {
	if x, ok := m.GetDedupeOpt().(*VolumeSpecUpdate_Dedupe); ok {
		return x.Dedupe
	}
	return false
}

func (m *VolumeSpecUpdate) GetSnapshotInterval() uint32 {
	if x, ok := m.GetSnapshotIntervalOpt().(*VolumeSpecUpdate_SnapshotInterval); ok {
		return x.SnapshotInterval
	}
	return 0
}

func (m *VolumeSpecUpdate) GetShared() bool {
	if x, ok := m.GetSharedOpt().(*VolumeSpecUpdate_Shared); ok {
		return x.Shared
	}
	return false
}

func (m *VolumeSpecUpdate) GetReplicaSet() *ReplicaSet {
	if m != nil {
		return m.ReplicaSet
	}
	return nil
}

func (m *VolumeSpecUpdate) GetPassphrase() string {
	if x, ok := m.GetPassphraseOpt().(*VolumeSpecUpdate_Passphrase); ok {
		return x.Passphrase
	}
	return ""
}

func (m *VolumeSpecUpdate) GetSnapshotSchedule() string {
	if x, ok := m.GetSnapshotScheduleOpt().(*VolumeSpecUpdate_SnapshotSchedule); ok {
		return x.SnapshotSchedule
	}
	return ""
}

func (m *VolumeSpecUpdate) GetScale() uint32 {
	if x, ok := m.GetScaleOpt().(*VolumeSpecUpdate_Scale); ok {
		return x.Scale
	}
	return 0
}

func (m *VolumeSpecUpdate) GetSticky() bool {
	if x, ok := m.GetStickyOpt().(*VolumeSpecUpdate_Sticky); ok {
		return x.Sticky
	}
	return false
}

func (m *VolumeSpecUpdate) GetGroup() *Group {
	if x, ok := m.GetGroupOpt().(*VolumeSpecUpdate_Group); ok {
		return x.Group
	}
	return nil
}

func (m *VolumeSpecUpdate) GetJournal() bool {
	if x, ok := m.GetJournalOpt().(*VolumeSpecUpdate_Journal); ok {
		return x.Journal
	}
	return false
}

func (m *VolumeSpecUpdate) GetSharedv4() bool {
	if x, ok := m.GetSharedv4Opt().(*VolumeSpecUpdate_Sharedv4); ok {
		return x.Sharedv4
	}
	return false
}

func (m *VolumeSpecUpdate) GetQueueDepth() uint32 {
	if x, ok := m.GetQueueDepthOpt().(*VolumeSpecUpdate_QueueDepth); ok {
		return x.QueueDepth
	}
	return 0
}

func (m *VolumeSpecUpdate) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *VolumeSpecUpdate) GetNodiscard() bool {
	if x, ok := m.GetNodiscardOpt().(*VolumeSpecUpdate_Nodiscard); ok {
		return x.Nodiscard
	}
	return false
}

func (m *VolumeSpecUpdate) GetIoStrategy() *IoStrategy {
	if m != nil {
		return m.IoStrategy
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VolumeSpecUpdate) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VolumeSpecUpdate_OneofMarshaler, _VolumeSpecUpdate_OneofUnmarshaler, _VolumeSpecUpdate_OneofSizer, []interface{}{
		(*VolumeSpecUpdate_Size)(nil),
		(*VolumeSpecUpdate_HaLevel)(nil),
		(*VolumeSpecUpdate_Cos)(nil),
		(*VolumeSpecUpdate_IoProfile)(nil),
		(*VolumeSpecUpdate_Dedupe)(nil),
		(*VolumeSpecUpdate_SnapshotInterval)(nil),
		(*VolumeSpecUpdate_Shared)(nil),
		(*VolumeSpecUpdate_Passphrase)(nil),
		(*VolumeSpecUpdate_SnapshotSchedule)(nil),
		(*VolumeSpecUpdate_Scale)(nil),
		(*VolumeSpecUpdate_Sticky)(nil),
		(*VolumeSpecUpdate_Group)(nil),
		(*VolumeSpecUpdate_Journal)(nil),
		(*VolumeSpecUpdate_Sharedv4)(nil),
		(*VolumeSpecUpdate_QueueDepth)(nil),
		(*VolumeSpecUpdate_Nodiscard)(nil),
	}
}

func _VolumeSpecUpdate_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VolumeSpecUpdate)
	// size_opt
	switch x := m.SizeOpt.(type) {
	case *VolumeSpecUpdate_Size:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Size))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.SizeOpt has unexpected type %T", x)
	}
	// ha_level_opt
	switch x := m.HaLevelOpt.(type) {
	case *VolumeSpecUpdate_HaLevel:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.HaLevel))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.HaLevelOpt has unexpected type %T", x)
	}
	// cos_opt
	switch x := m.CosOpt.(type) {
	case *VolumeSpecUpdate_Cos:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Cos))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.CosOpt has unexpected type %T", x)
	}
	// io_profile_opt
	switch x := m.IoProfileOpt.(type) {
	case *VolumeSpecUpdate_IoProfile:
		b.EncodeVarint(7<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IoProfile))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.IoProfileOpt has unexpected type %T", x)
	}
	// dedupe_opt
	switch x := m.DedupeOpt.(type) {
	case *VolumeSpecUpdate_Dedupe:
		t := uint64(0)
		if x.Dedupe {
			t = 1
		}
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.DedupeOpt has unexpected type %T", x)
	}
	// snapshot_interval_opt
	switch x := m.SnapshotIntervalOpt.(type) {
	case *VolumeSpecUpdate_SnapshotInterval:
		b.EncodeVarint(9<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.SnapshotInterval))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.SnapshotIntervalOpt has unexpected type %T", x)
	}
	// shared_opt
	switch x := m.SharedOpt.(type) {
	case *VolumeSpecUpdate_Shared:
		t := uint64(0)
		if x.Shared {
			t = 1
		}
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.SharedOpt has unexpected type %T", x)
	}
	// passphrase_opt
	switch x := m.PassphraseOpt.(type) {
	case *VolumeSpecUpdate_Passphrase:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Passphrase)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.PassphraseOpt has unexpected type %T", x)
	}
	// snapshot_schedule_opt
	switch x := m.SnapshotScheduleOpt.(type) {
	case *VolumeSpecUpdate_SnapshotSchedule:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SnapshotSchedule)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.SnapshotScheduleOpt has unexpected type %T", x)
	}
	// scale_opt
	switch x := m.ScaleOpt.(type) {
	case *VolumeSpecUpdate_Scale:
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Scale))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.ScaleOpt has unexpected type %T", x)
	}
	// sticky_opt
	switch x := m.StickyOpt.(type) {
	case *VolumeSpecUpdate_Sticky:
		t := uint64(0)
		if x.Sticky {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.StickyOpt has unexpected type %T", x)
	}
	// group_opt
	switch x := m.GroupOpt.(type) {
	case *VolumeSpecUpdate_Group:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Group); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.GroupOpt has unexpected type %T", x)
	}
	// journal_opt
	switch x := m.JournalOpt.(type) {
	case *VolumeSpecUpdate_Journal:
		t := uint64(0)
		if x.Journal {
			t = 1
		}
		b.EncodeVarint(23<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.JournalOpt has unexpected type %T", x)
	}
	// sharedv4_opt
	switch x := m.Sharedv4Opt.(type) {
	case *VolumeSpecUpdate_Sharedv4:
		t := uint64(0)
		if x.Sharedv4 {
			t = 1
		}
		b.EncodeVarint(24<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.Sharedv4Opt has unexpected type %T", x)
	}
	// queue_depth_opt
	switch x := m.QueueDepthOpt.(type) {
	case *VolumeSpecUpdate_QueueDepth:
		b.EncodeVarint(25<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.QueueDepth))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.QueueDepthOpt has unexpected type %T", x)
	}
	// nodiscard_opt
	switch x := m.NodiscardOpt.(type) {
	case *VolumeSpecUpdate_Nodiscard:
		t := uint64(0)
		if x.Nodiscard {
			t = 1
		}
		b.EncodeVarint(27<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecUpdate.NodiscardOpt has unexpected type %T", x)
	}
	return nil
}

func _VolumeSpecUpdate_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VolumeSpecUpdate)
	switch tag {
	case 2: // size_opt.size
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SizeOpt = &VolumeSpecUpdate_Size{x}
		return true, err
	case 5: // ha_level_opt.ha_level
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.HaLevelOpt = &VolumeSpecUpdate_HaLevel{int64(x)}
		return true, err
	case 6: // cos_opt.cos
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.CosOpt = &VolumeSpecUpdate_Cos{CosType(x)}
		return true, err
	case 7: // io_profile_opt.io_profile
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IoProfileOpt = &VolumeSpecUpdate_IoProfile{IoProfile(x)}
		return true, err
	case 8: // dedupe_opt.dedupe
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.DedupeOpt = &VolumeSpecUpdate_Dedupe{x != 0}
		return true, err
	case 9: // snapshot_interval_opt.snapshot_interval
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SnapshotIntervalOpt = &VolumeSpecUpdate_SnapshotInterval{uint32(x)}
		return true, err
	case 11: // shared_opt.shared
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SharedOpt = &VolumeSpecUpdate_Shared{x != 0}
		return true, err
	case 15: // passphrase_opt.passphrase
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PassphraseOpt = &VolumeSpecUpdate_Passphrase{x}
		return true, err
	case 16: // snapshot_schedule_opt.snapshot_schedule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.SnapshotScheduleOpt = &VolumeSpecUpdate_SnapshotSchedule{x}
		return true, err
	case 17: // scale_opt.scale
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ScaleOpt = &VolumeSpecUpdate_Scale{uint32(x)}
		return true, err
	case 18: // sticky_opt.sticky
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.StickyOpt = &VolumeSpecUpdate_Sticky{x != 0}
		return true, err
	case 19: // group_opt.group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Group)
		err := b.DecodeMessage(msg)
		m.GroupOpt = &VolumeSpecUpdate_Group{msg}
		return true, err
	case 23: // journal_opt.journal
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.JournalOpt = &VolumeSpecUpdate_Journal{x != 0}
		return true, err
	case 24: // sharedv4_opt.sharedv4
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Sharedv4Opt = &VolumeSpecUpdate_Sharedv4{x != 0}
		return true, err
	case 25: // queue_depth_opt.queue_depth
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.QueueDepthOpt = &VolumeSpecUpdate_QueueDepth{uint32(x)}
		return true, err
	case 27: // nodiscard_opt.nodiscard
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.NodiscardOpt = &VolumeSpecUpdate_Nodiscard{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _VolumeSpecUpdate_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VolumeSpecUpdate)
	// size_opt
	switch x := m.SizeOpt.(type) {
	case *VolumeSpecUpdate_Size:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Size))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// ha_level_opt
	switch x := m.HaLevelOpt.(type) {
	case *VolumeSpecUpdate_HaLevel:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.HaLevel))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// cos_opt
	switch x := m.CosOpt.(type) {
	case *VolumeSpecUpdate_Cos:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Cos))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// io_profile_opt
	switch x := m.IoProfileOpt.(type) {
	case *VolumeSpecUpdate_IoProfile:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IoProfile))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// dedupe_opt
	switch x := m.DedupeOpt.(type) {
	case *VolumeSpecUpdate_Dedupe:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// snapshot_interval_opt
	switch x := m.SnapshotIntervalOpt.(type) {
	case *VolumeSpecUpdate_SnapshotInterval:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.SnapshotInterval))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// shared_opt
	switch x := m.SharedOpt.(type) {
	case *VolumeSpecUpdate_Shared:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// passphrase_opt
	switch x := m.PassphraseOpt.(type) {
	case *VolumeSpecUpdate_Passphrase:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Passphrase)))
		n += len(x.Passphrase)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// snapshot_schedule_opt
	switch x := m.SnapshotScheduleOpt.(type) {
	case *VolumeSpecUpdate_SnapshotSchedule:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SnapshotSchedule)))
		n += len(x.SnapshotSchedule)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// scale_opt
	switch x := m.ScaleOpt.(type) {
	case *VolumeSpecUpdate_Scale:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.Scale))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// sticky_opt
	switch x := m.StickyOpt.(type) {
	case *VolumeSpecUpdate_Sticky:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// group_opt
	switch x := m.GroupOpt.(type) {
	case *VolumeSpecUpdate_Group:
		s := proto.Size(x.Group)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// journal_opt
	switch x := m.JournalOpt.(type) {
	case *VolumeSpecUpdate_Journal:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// sharedv4_opt
	switch x := m.Sharedv4Opt.(type) {
	case *VolumeSpecUpdate_Sharedv4:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// queue_depth_opt
	switch x := m.QueueDepthOpt.(type) {
	case *VolumeSpecUpdate_QueueDepth:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.QueueDepth))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// nodiscard_opt
	switch x := m.NodiscardOpt.(type) {
	case *VolumeSpecUpdate_Nodiscard:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// VolumeSpecPolicy provides a method to set volume storage policy
type VolumeSpecPolicy struct {
	// Size specifies the thin provisioned volume size in bytes.
	// Use `size_operator` to show if this value is the min, max, or set.
	//
	// Types that are valid to be assigned to SizeOpt:
	//	*VolumeSpecPolicy_Size
	SizeOpt isVolumeSpecPolicy_SizeOpt `protobuf_oneof:"size_opt"`
	// HaLevel specifies the number of copies of data.
	// Use `ha_level_operator` to show if this value is the min, max, or set.
	//
	// Types that are valid to be assigned to HaLevelOpt:
	//	*VolumeSpecPolicy_HaLevel
	HaLevelOpt isVolumeSpecPolicy_HaLevelOpt `protobuf_oneof:"ha_level_opt"`
	// Cos specifies the relative class of service.
	//
	// Types that are valid to be assigned to CosOpt:
	//	*VolumeSpecPolicy_Cos
	CosOpt isVolumeSpecPolicy_CosOpt `protobuf_oneof:"cos_opt"`
	// IoProfile provides a hint about application using this volume.
	//
	// Types that are valid to be assigned to IoProfileOpt:
	//	*VolumeSpecPolicy_IoProfile
	IoProfileOpt isVolumeSpecPolicy_IoProfileOpt `protobuf_oneof:"io_profile_opt"`
	// Dedupe specifies if the volume data is to be de-duplicated.
	//
	// Types that are valid to be assigned to DedupeOpt:
	//	*VolumeSpecPolicy_Dedupe
	DedupeOpt isVolumeSpecPolicy_DedupeOpt `protobuf_oneof:"dedupe_opt"`
	// SnapshotInterval in minutes, set to 0 to disable snapshots
	//
	// Types that are valid to be assigned to SnapshotIntervalOpt:
	//	*VolumeSpecPolicy_SnapshotInterval
	SnapshotIntervalOpt isVolumeSpecPolicy_SnapshotIntervalOpt `protobuf_oneof:"snapshot_interval_opt"`
	// VolumeLabels configuration labels
	VolumeLabels map[string]string `protobuf:"bytes,7,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Shared is true if this volume can be remotely accessed.
	//
	// Types that are valid to be assigned to SharedOpt:
	//	*VolumeSpecPolicy_Shared
	SharedOpt isVolumeSpecPolicy_SharedOpt `protobuf_oneof:"shared_opt"`
	// ReplicaSet is the desired set of nodes for the volume data.
	ReplicaSet *ReplicaSet `protobuf:"bytes,9,opt,name=replica_set,json=replicaSet" json:"replica_set,omitempty"`
	// Passphrase for an encrypted volume
	//
	// Types that are valid to be assigned to PassphraseOpt:
	//	*VolumeSpecPolicy_Passphrase
	PassphraseOpt isVolumeSpecPolicy_PassphraseOpt `protobuf_oneof:"passphrase_opt"`
	// SnapshotSchedule a well known string that specifies when snapshots should be taken.
	//
	// Types that are valid to be assigned to SnapshotScheduleOpt:
	//	*VolumeSpecPolicy_SnapshotSchedule
	SnapshotScheduleOpt isVolumeSpecPolicy_SnapshotScheduleOpt `protobuf_oneof:"snapshot_schedule_opt"`
	// Scale allows autocreation of volumes.
	//
	// Types that are valid to be assigned to ScaleOpt:
	//	*VolumeSpecPolicy_Scale
	ScaleOpt isVolumeSpecPolicy_ScaleOpt `protobuf_oneof:"scale_opt"`
	// Sticky volumes cannot be deleted until the flag is removed.
	//
	// Types that are valid to be assigned to StickyOpt:
	//	*VolumeSpecPolicy_Sticky
	StickyOpt isVolumeSpecPolicy_StickyOpt `protobuf_oneof:"sticky_opt"`
	// Group identifies a consistency group
	//
	// Types that are valid to be assigned to GroupOpt:
	//	*VolumeSpecPolicy_Group
	GroupOpt isVolumeSpecPolicy_GroupOpt `protobuf_oneof:"group_opt"`
	// Journal is true if data for the volume goes into the journal.
	//
	// Types that are valid to be assigned to JournalOpt:
	//	*VolumeSpecPolicy_Journal
	JournalOpt isVolumeSpecPolicy_JournalOpt `protobuf_oneof:"journal_opt"`
	// Sharedv4 is true if this volume can be accessed via sharedv4.
	//
	// Types that are valid to be assigned to Sharedv4Opt:
	//	*VolumeSpecPolicy_Sharedv4
	Sharedv4Opt isVolumeSpecPolicy_Sharedv4Opt `protobuf_oneof:"sharedv4_opt"`
	// QueueDepth defines the desired block device queue depth
	//
	// Types that are valid to be assigned to QueueDepthOpt:
	//	*VolumeSpecPolicy_QueueDepth
	QueueDepthOpt isVolumeSpecPolicy_QueueDepthOpt `protobuf_oneof:"queue_depth_opt"`
	// Encrypted is true if this volume will be cryptographically secured.
	//
	// Types that are valid to be assigned to EncryptedOpt:
	//	*VolumeSpecPolicy_Encrypted
	EncryptedOpt isVolumeSpecPolicy_EncryptedOpt `protobuf_oneof:"encrypted_opt"`
	// Aggregation level Specifies the number of parts the volume can be aggregated from.
	//
	// Types that are valid to be assigned to AggregationLevelOpt:
	//	*VolumeSpecPolicy_AggregationLevel
	AggregationLevelOpt isVolumeSpecPolicy_AggregationLevelOpt `protobuf_oneof:"aggregation_level_opt"`
	// Operator to check size
	SizeOperator VolumeSpecPolicy_PolicyOp `protobuf:"varint,50,opt,name=size_operator,json=sizeOperator,enum=openstorage.api.VolumeSpecPolicy_PolicyOp" json:"size_operator,omitempty"`
	// Operator to check ha_level
	HaLevelOperator VolumeSpecPolicy_PolicyOp `protobuf:"varint,51,opt,name=ha_level_operator,json=haLevelOperator,enum=openstorage.api.VolumeSpecPolicy_PolicyOp" json:"ha_level_operator,omitempty"`
	// Operator to check scale
	ScaleOperator VolumeSpecPolicy_PolicyOp `protobuf:"varint,52,opt,name=scale_operator,json=scaleOperator,enum=openstorage.api.VolumeSpecPolicy_PolicyOp" json:"scale_operator,omitempty"`
	// Operator to check snapshot_interval
	SnapshotIntervalOperator VolumeSpecPolicy_PolicyOp `protobuf:"varint,53,opt,name=snapshot_interval_operator,json=snapshotIntervalOperator,enum=openstorage.api.VolumeSpecPolicy_PolicyOp" json:"snapshot_interval_operator,omitempty"`
	// Nodiscard specifies if the volume will be mounted with discard support disabled.
	// i.e. FS will not release allocated blocks back to the backing storage pool.
	//
	// Types that are valid to be assigned to NodiscardOpt:
	//	*VolumeSpecPolicy_Nodiscard
	NodiscardOpt isVolumeSpecPolicy_NodiscardOpt `protobuf_oneof:"nodiscard_opt"`
	// IoStrategy preferred strategy for I/O.
	IoStrategy           *IoStrategy `protobuf:"bytes,55,opt,name=io_strategy,json=ioStrategy" json:"io_strategy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *VolumeSpecPolicy) Reset()         { *m = VolumeSpecPolicy{} }
func (m *VolumeSpecPolicy) String() string { return proto.CompactTextString(m) }
func (*VolumeSpecPolicy) ProtoMessage()    {}
func (*VolumeSpecPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{9}
}
func (m *VolumeSpecPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeSpecPolicy.Unmarshal(m, b)
}
func (m *VolumeSpecPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeSpecPolicy.Marshal(b, m, deterministic)
}
func (dst *VolumeSpecPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSpecPolicy.Merge(dst, src)
}
func (m *VolumeSpecPolicy) XXX_Size() int {
	return xxx_messageInfo_VolumeSpecPolicy.Size(m)
}
func (m *VolumeSpecPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSpecPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSpecPolicy proto.InternalMessageInfo

type isVolumeSpecPolicy_SizeOpt interface {
	isVolumeSpecPolicy_SizeOpt()
}
type isVolumeSpecPolicy_HaLevelOpt interface {
	isVolumeSpecPolicy_HaLevelOpt()
}
type isVolumeSpecPolicy_CosOpt interface {
	isVolumeSpecPolicy_CosOpt()
}
type isVolumeSpecPolicy_IoProfileOpt interface {
	isVolumeSpecPolicy_IoProfileOpt()
}
type isVolumeSpecPolicy_DedupeOpt interface {
	isVolumeSpecPolicy_DedupeOpt()
}
type isVolumeSpecPolicy_SnapshotIntervalOpt interface {
	isVolumeSpecPolicy_SnapshotIntervalOpt()
}
type isVolumeSpecPolicy_SharedOpt interface {
	isVolumeSpecPolicy_SharedOpt()
}
type isVolumeSpecPolicy_PassphraseOpt interface {
	isVolumeSpecPolicy_PassphraseOpt()
}
type isVolumeSpecPolicy_SnapshotScheduleOpt interface {
	isVolumeSpecPolicy_SnapshotScheduleOpt()
}
type isVolumeSpecPolicy_ScaleOpt interface {
	isVolumeSpecPolicy_ScaleOpt()
}
type isVolumeSpecPolicy_StickyOpt interface {
	isVolumeSpecPolicy_StickyOpt()
}
type isVolumeSpecPolicy_GroupOpt interface {
	isVolumeSpecPolicy_GroupOpt()
}
type isVolumeSpecPolicy_JournalOpt interface {
	isVolumeSpecPolicy_JournalOpt()
}
type isVolumeSpecPolicy_Sharedv4Opt interface {
	isVolumeSpecPolicy_Sharedv4Opt()
}
type isVolumeSpecPolicy_QueueDepthOpt interface {
	isVolumeSpecPolicy_QueueDepthOpt()
}
type isVolumeSpecPolicy_EncryptedOpt interface {
	isVolumeSpecPolicy_EncryptedOpt()
}
type isVolumeSpecPolicy_AggregationLevelOpt interface {
	isVolumeSpecPolicy_AggregationLevelOpt()
}
type isVolumeSpecPolicy_NodiscardOpt interface {
	isVolumeSpecPolicy_NodiscardOpt()
}

type VolumeSpecPolicy_Size struct {
	Size uint64 `protobuf:"varint,1,opt,name=size,oneof"`
}
type VolumeSpecPolicy_HaLevel struct {
	HaLevel int64 `protobuf:"varint,2,opt,name=ha_level,json=haLevel,oneof"`
}
type VolumeSpecPolicy_Cos struct {
	Cos CosType `protobuf:"varint,3,opt,name=cos,enum=openstorage.api.CosType,oneof"`
}
type VolumeSpecPolicy_IoProfile struct {
	IoProfile IoProfile `protobuf:"varint,4,opt,name=io_profile,json=ioProfile,enum=openstorage.api.IoProfile,oneof"`
}
type VolumeSpecPolicy_Dedupe struct {
	Dedupe bool `protobuf:"varint,5,opt,name=dedupe,oneof"`
}
type VolumeSpecPolicy_SnapshotInterval struct {
	SnapshotInterval uint32 `protobuf:"varint,6,opt,name=snapshot_interval,json=snapshotInterval,oneof"`
}
type VolumeSpecPolicy_Shared struct {
	Shared bool `protobuf:"varint,8,opt,name=shared,oneof"`
}
type VolumeSpecPolicy_Passphrase struct {
	Passphrase string `protobuf:"bytes,10,opt,name=passphrase,oneof"`
}
type VolumeSpecPolicy_SnapshotSchedule struct {
	SnapshotSchedule string `protobuf:"bytes,11,opt,name=snapshot_schedule,json=snapshotSchedule,oneof"`
}
type VolumeSpecPolicy_Scale struct {
	Scale uint32 `protobuf:"varint,12,opt,name=scale,oneof"`
}
type VolumeSpecPolicy_Sticky struct {
	Sticky bool `protobuf:"varint,13,opt,name=sticky,oneof"`
}
type VolumeSpecPolicy_Group struct {
	Group *Group `protobuf:"bytes,14,opt,name=group,oneof"`
}
type VolumeSpecPolicy_Journal struct {
	Journal bool `protobuf:"varint,15,opt,name=journal,oneof"`
}
type VolumeSpecPolicy_Sharedv4 struct {
	Sharedv4 bool `protobuf:"varint,16,opt,name=sharedv4,oneof"`
}
type VolumeSpecPolicy_QueueDepth struct {
	QueueDepth uint32 `protobuf:"varint,17,opt,name=queue_depth,json=queueDepth,oneof"`
}
type VolumeSpecPolicy_Encrypted struct {
	Encrypted bool `protobuf:"varint,18,opt,name=encrypted,oneof"`
}
type VolumeSpecPolicy_AggregationLevel struct {
	AggregationLevel uint32 `protobuf:"varint,19,opt,name=aggregation_level,json=aggregationLevel,oneof"`
}
type VolumeSpecPolicy_Nodiscard struct {
	Nodiscard bool `protobuf:"varint,54,opt,name=nodiscard,oneof"`
}

func (*VolumeSpecPolicy_Size) isVolumeSpecPolicy_SizeOpt()                         {}
func (*VolumeSpecPolicy_HaLevel) isVolumeSpecPolicy_HaLevelOpt()                   {}
func (*VolumeSpecPolicy_Cos) isVolumeSpecPolicy_CosOpt()                           {}
func (*VolumeSpecPolicy_IoProfile) isVolumeSpecPolicy_IoProfileOpt()               {}
func (*VolumeSpecPolicy_Dedupe) isVolumeSpecPolicy_DedupeOpt()                     {}
func (*VolumeSpecPolicy_SnapshotInterval) isVolumeSpecPolicy_SnapshotIntervalOpt() {}
func (*VolumeSpecPolicy_Shared) isVolumeSpecPolicy_SharedOpt()                     {}
func (*VolumeSpecPolicy_Passphrase) isVolumeSpecPolicy_PassphraseOpt()             {}
func (*VolumeSpecPolicy_SnapshotSchedule) isVolumeSpecPolicy_SnapshotScheduleOpt() {}
func (*VolumeSpecPolicy_Scale) isVolumeSpecPolicy_ScaleOpt()                       {}
func (*VolumeSpecPolicy_Sticky) isVolumeSpecPolicy_StickyOpt()                     {}
func (*VolumeSpecPolicy_Group) isVolumeSpecPolicy_GroupOpt()                       {}
func (*VolumeSpecPolicy_Journal) isVolumeSpecPolicy_JournalOpt()                   {}
func (*VolumeSpecPolicy_Sharedv4) isVolumeSpecPolicy_Sharedv4Opt()                 {}
func (*VolumeSpecPolicy_QueueDepth) isVolumeSpecPolicy_QueueDepthOpt()             {}
func (*VolumeSpecPolicy_Encrypted) isVolumeSpecPolicy_EncryptedOpt()               {}
func (*VolumeSpecPolicy_AggregationLevel) isVolumeSpecPolicy_AggregationLevelOpt() {}
func (*VolumeSpecPolicy_Nodiscard) isVolumeSpecPolicy_NodiscardOpt()               {}

func (m *VolumeSpecPolicy) GetSizeOpt() isVolumeSpecPolicy_SizeOpt {
	if m != nil {
		return m.SizeOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetHaLevelOpt() isVolumeSpecPolicy_HaLevelOpt {
	if m != nil {
		return m.HaLevelOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetCosOpt() isVolumeSpecPolicy_CosOpt {
	if m != nil {
		return m.CosOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetIoProfileOpt() isVolumeSpecPolicy_IoProfileOpt {
	if m != nil {
		return m.IoProfileOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetDedupeOpt() isVolumeSpecPolicy_DedupeOpt {
	if m != nil {
		return m.DedupeOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetSnapshotIntervalOpt() isVolumeSpecPolicy_SnapshotIntervalOpt {
	if m != nil {
		return m.SnapshotIntervalOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetSharedOpt() isVolumeSpecPolicy_SharedOpt {
	if m != nil {
		return m.SharedOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetPassphraseOpt() isVolumeSpecPolicy_PassphraseOpt {
	if m != nil {
		return m.PassphraseOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetSnapshotScheduleOpt() isVolumeSpecPolicy_SnapshotScheduleOpt {
	if m != nil {
		return m.SnapshotScheduleOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetScaleOpt() isVolumeSpecPolicy_ScaleOpt {
	if m != nil {
		return m.ScaleOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetStickyOpt() isVolumeSpecPolicy_StickyOpt {
	if m != nil {
		return m.StickyOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetGroupOpt() isVolumeSpecPolicy_GroupOpt {
	if m != nil {
		return m.GroupOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetJournalOpt() isVolumeSpecPolicy_JournalOpt {
	if m != nil {
		return m.JournalOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetSharedv4Opt() isVolumeSpecPolicy_Sharedv4Opt {
	if m != nil {
		return m.Sharedv4Opt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetQueueDepthOpt() isVolumeSpecPolicy_QueueDepthOpt {
	if m != nil {
		return m.QueueDepthOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetEncryptedOpt() isVolumeSpecPolicy_EncryptedOpt {
	if m != nil {
		return m.EncryptedOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetAggregationLevelOpt() isVolumeSpecPolicy_AggregationLevelOpt {
	if m != nil {
		return m.AggregationLevelOpt
	}
	return nil
}
func (m *VolumeSpecPolicy) GetNodiscardOpt() isVolumeSpecPolicy_NodiscardOpt {
	if m != nil {
		return m.NodiscardOpt
	}
	return nil
}

func (m *VolumeSpecPolicy) GetSize() uint64 {
	if x, ok := m.GetSizeOpt().(*VolumeSpecPolicy_Size); ok {
		return x.Size
	}
	return 0
}

func (m *VolumeSpecPolicy) GetHaLevel() int64 {
	if x, ok := m.GetHaLevelOpt().(*VolumeSpecPolicy_HaLevel); ok {
		return x.HaLevel
	}
	return 0
}

func (m *VolumeSpecPolicy) GetCos() CosType {
	if x, ok := m.GetCosOpt().(*VolumeSpecPolicy_Cos); ok {
		return x.Cos
	}
	return CosType_NONE
}

func (m *VolumeSpecPolicy) GetIoProfile() IoProfile {
	if x, ok := m.GetIoProfileOpt().(*VolumeSpecPolicy_IoProfile); ok {
		return x.IoProfile
	}
	return IoProfile_IO_PROFILE_SEQUENTIAL
}

func (m *VolumeSpecPolicy) GetDedupe() bool {
	if x, ok := m.GetDedupeOpt().(*VolumeSpecPolicy_Dedupe); ok {
		return x.Dedupe
	}
	return false
}

func (m *VolumeSpecPolicy) GetSnapshotInterval() uint32 {
	if x, ok := m.GetSnapshotIntervalOpt().(*VolumeSpecPolicy_SnapshotInterval); ok {
		return x.SnapshotInterval
	}
	return 0
}

func (m *VolumeSpecPolicy) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

func (m *VolumeSpecPolicy) GetShared() bool {
	if x, ok := m.GetSharedOpt().(*VolumeSpecPolicy_Shared); ok {
		return x.Shared
	}
	return false
}

func (m *VolumeSpecPolicy) GetReplicaSet() *ReplicaSet {
	if m != nil {
		return m.ReplicaSet
	}
	return nil
}

func (m *VolumeSpecPolicy) GetPassphrase() string {
	if x, ok := m.GetPassphraseOpt().(*VolumeSpecPolicy_Passphrase); ok {
		return x.Passphrase
	}
	return ""
}

func (m *VolumeSpecPolicy) GetSnapshotSchedule() string {
	if x, ok := m.GetSnapshotScheduleOpt().(*VolumeSpecPolicy_SnapshotSchedule); ok {
		return x.SnapshotSchedule
	}
	return ""
}

func (m *VolumeSpecPolicy) GetScale() uint32 {
	if x, ok := m.GetScaleOpt().(*VolumeSpecPolicy_Scale); ok {
		return x.Scale
	}
	return 0
}

func (m *VolumeSpecPolicy) GetSticky() bool {
	if x, ok := m.GetStickyOpt().(*VolumeSpecPolicy_Sticky); ok {
		return x.Sticky
	}
	return false
}

func (m *VolumeSpecPolicy) GetGroup() *Group {
	if x, ok := m.GetGroupOpt().(*VolumeSpecPolicy_Group); ok {
		return x.Group
	}
	return nil
}

func (m *VolumeSpecPolicy) GetJournal() bool {
	if x, ok := m.GetJournalOpt().(*VolumeSpecPolicy_Journal); ok {
		return x.Journal
	}
	return false
}

func (m *VolumeSpecPolicy) GetSharedv4() bool {
	if x, ok := m.GetSharedv4Opt().(*VolumeSpecPolicy_Sharedv4); ok {
		return x.Sharedv4
	}
	return false
}

func (m *VolumeSpecPolicy) GetQueueDepth() uint32 {
	if x, ok := m.GetQueueDepthOpt().(*VolumeSpecPolicy_QueueDepth); ok {
		return x.QueueDepth
	}
	return 0
}

func (m *VolumeSpecPolicy) GetEncrypted() bool {
	if x, ok := m.GetEncryptedOpt().(*VolumeSpecPolicy_Encrypted); ok {
		return x.Encrypted
	}
	return false
}

func (m *VolumeSpecPolicy) GetAggregationLevel() uint32 {
	if x, ok := m.GetAggregationLevelOpt().(*VolumeSpecPolicy_AggregationLevel); ok {
		return x.AggregationLevel
	}
	return 0
}

func (m *VolumeSpecPolicy) GetSizeOperator() VolumeSpecPolicy_PolicyOp {
	if m != nil {
		return m.SizeOperator
	}
	return VolumeSpecPolicy_Equal
}

func (m *VolumeSpecPolicy) GetHaLevelOperator() VolumeSpecPolicy_PolicyOp {
	if m != nil {
		return m.HaLevelOperator
	}
	return VolumeSpecPolicy_Equal
}

func (m *VolumeSpecPolicy) GetScaleOperator() VolumeSpecPolicy_PolicyOp {
	if m != nil {
		return m.ScaleOperator
	}
	return VolumeSpecPolicy_Equal
}

func (m *VolumeSpecPolicy) GetSnapshotIntervalOperator() VolumeSpecPolicy_PolicyOp {
	if m != nil {
		return m.SnapshotIntervalOperator
	}
	return VolumeSpecPolicy_Equal
}

func (m *VolumeSpecPolicy) GetNodiscard() bool {
	if x, ok := m.GetNodiscardOpt().(*VolumeSpecPolicy_Nodiscard); ok {
		return x.Nodiscard
	}
	return false
}

func (m *VolumeSpecPolicy) GetIoStrategy() *IoStrategy {
	if m != nil {
		return m.IoStrategy
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VolumeSpecPolicy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VolumeSpecPolicy_OneofMarshaler, _VolumeSpecPolicy_OneofUnmarshaler, _VolumeSpecPolicy_OneofSizer, []interface{}{
		(*VolumeSpecPolicy_Size)(nil),
		(*VolumeSpecPolicy_HaLevel)(nil),
		(*VolumeSpecPolicy_Cos)(nil),
		(*VolumeSpecPolicy_IoProfile)(nil),
		(*VolumeSpecPolicy_Dedupe)(nil),
		(*VolumeSpecPolicy_SnapshotInterval)(nil),
		(*VolumeSpecPolicy_Shared)(nil),
		(*VolumeSpecPolicy_Passphrase)(nil),
		(*VolumeSpecPolicy_SnapshotSchedule)(nil),
		(*VolumeSpecPolicy_Scale)(nil),
		(*VolumeSpecPolicy_Sticky)(nil),
		(*VolumeSpecPolicy_Group)(nil),
		(*VolumeSpecPolicy_Journal)(nil),
		(*VolumeSpecPolicy_Sharedv4)(nil),
		(*VolumeSpecPolicy_QueueDepth)(nil),
		(*VolumeSpecPolicy_Encrypted)(nil),
		(*VolumeSpecPolicy_AggregationLevel)(nil),
		(*VolumeSpecPolicy_Nodiscard)(nil),
	}
}

func _VolumeSpecPolicy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VolumeSpecPolicy)
	// size_opt
	switch x := m.SizeOpt.(type) {
	case *VolumeSpecPolicy_Size:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Size))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.SizeOpt has unexpected type %T", x)
	}
	// ha_level_opt
	switch x := m.HaLevelOpt.(type) {
	case *VolumeSpecPolicy_HaLevel:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.HaLevel))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.HaLevelOpt has unexpected type %T", x)
	}
	// cos_opt
	switch x := m.CosOpt.(type) {
	case *VolumeSpecPolicy_Cos:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Cos))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.CosOpt has unexpected type %T", x)
	}
	// io_profile_opt
	switch x := m.IoProfileOpt.(type) {
	case *VolumeSpecPolicy_IoProfile:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IoProfile))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.IoProfileOpt has unexpected type %T", x)
	}
	// dedupe_opt
	switch x := m.DedupeOpt.(type) {
	case *VolumeSpecPolicy_Dedupe:
		t := uint64(0)
		if x.Dedupe {
			t = 1
		}
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.DedupeOpt has unexpected type %T", x)
	}
	// snapshot_interval_opt
	switch x := m.SnapshotIntervalOpt.(type) {
	case *VolumeSpecPolicy_SnapshotInterval:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.SnapshotInterval))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.SnapshotIntervalOpt has unexpected type %T", x)
	}
	// shared_opt
	switch x := m.SharedOpt.(type) {
	case *VolumeSpecPolicy_Shared:
		t := uint64(0)
		if x.Shared {
			t = 1
		}
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.SharedOpt has unexpected type %T", x)
	}
	// passphrase_opt
	switch x := m.PassphraseOpt.(type) {
	case *VolumeSpecPolicy_Passphrase:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Passphrase)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.PassphraseOpt has unexpected type %T", x)
	}
	// snapshot_schedule_opt
	switch x := m.SnapshotScheduleOpt.(type) {
	case *VolumeSpecPolicy_SnapshotSchedule:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.SnapshotSchedule)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.SnapshotScheduleOpt has unexpected type %T", x)
	}
	// scale_opt
	switch x := m.ScaleOpt.(type) {
	case *VolumeSpecPolicy_Scale:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Scale))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.ScaleOpt has unexpected type %T", x)
	}
	// sticky_opt
	switch x := m.StickyOpt.(type) {
	case *VolumeSpecPolicy_Sticky:
		t := uint64(0)
		if x.Sticky {
			t = 1
		}
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.StickyOpt has unexpected type %T", x)
	}
	// group_opt
	switch x := m.GroupOpt.(type) {
	case *VolumeSpecPolicy_Group:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Group); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.GroupOpt has unexpected type %T", x)
	}
	// journal_opt
	switch x := m.JournalOpt.(type) {
	case *VolumeSpecPolicy_Journal:
		t := uint64(0)
		if x.Journal {
			t = 1
		}
		b.EncodeVarint(15<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.JournalOpt has unexpected type %T", x)
	}
	// sharedv4_opt
	switch x := m.Sharedv4Opt.(type) {
	case *VolumeSpecPolicy_Sharedv4:
		t := uint64(0)
		if x.Sharedv4 {
			t = 1
		}
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.Sharedv4Opt has unexpected type %T", x)
	}
	// queue_depth_opt
	switch x := m.QueueDepthOpt.(type) {
	case *VolumeSpecPolicy_QueueDepth:
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.QueueDepth))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.QueueDepthOpt has unexpected type %T", x)
	}
	// encrypted_opt
	switch x := m.EncryptedOpt.(type) {
	case *VolumeSpecPolicy_Encrypted:
		t := uint64(0)
		if x.Encrypted {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.EncryptedOpt has unexpected type %T", x)
	}
	// aggregation_level_opt
	switch x := m.AggregationLevelOpt.(type) {
	case *VolumeSpecPolicy_AggregationLevel:
		b.EncodeVarint(19<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.AggregationLevel))
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.AggregationLevelOpt has unexpected type %T", x)
	}
	// nodiscard_opt
	switch x := m.NodiscardOpt.(type) {
	case *VolumeSpecPolicy_Nodiscard:
		t := uint64(0)
		if x.Nodiscard {
			t = 1
		}
		b.EncodeVarint(54<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("VolumeSpecPolicy.NodiscardOpt has unexpected type %T", x)
	}
	return nil
}

func _VolumeSpecPolicy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VolumeSpecPolicy)
	switch tag {
	case 1: // size_opt.size
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SizeOpt = &VolumeSpecPolicy_Size{x}
		return true, err
	case 2: // ha_level_opt.ha_level
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.HaLevelOpt = &VolumeSpecPolicy_HaLevel{int64(x)}
		return true, err
	case 3: // cos_opt.cos
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.CosOpt = &VolumeSpecPolicy_Cos{CosType(x)}
		return true, err
	case 4: // io_profile_opt.io_profile
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IoProfileOpt = &VolumeSpecPolicy_IoProfile{IoProfile(x)}
		return true, err
	case 5: // dedupe_opt.dedupe
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.DedupeOpt = &VolumeSpecPolicy_Dedupe{x != 0}
		return true, err
	case 6: // snapshot_interval_opt.snapshot_interval
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SnapshotIntervalOpt = &VolumeSpecPolicy_SnapshotInterval{uint32(x)}
		return true, err
	case 8: // shared_opt.shared
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.SharedOpt = &VolumeSpecPolicy_Shared{x != 0}
		return true, err
	case 10: // passphrase_opt.passphrase
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PassphraseOpt = &VolumeSpecPolicy_Passphrase{x}
		return true, err
	case 11: // snapshot_schedule_opt.snapshot_schedule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.SnapshotScheduleOpt = &VolumeSpecPolicy_SnapshotSchedule{x}
		return true, err
	case 12: // scale_opt.scale
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ScaleOpt = &VolumeSpecPolicy_Scale{uint32(x)}
		return true, err
	case 13: // sticky_opt.sticky
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.StickyOpt = &VolumeSpecPolicy_Sticky{x != 0}
		return true, err
	case 14: // group_opt.group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Group)
		err := b.DecodeMessage(msg)
		m.GroupOpt = &VolumeSpecPolicy_Group{msg}
		return true, err
	case 15: // journal_opt.journal
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.JournalOpt = &VolumeSpecPolicy_Journal{x != 0}
		return true, err
	case 16: // sharedv4_opt.sharedv4
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Sharedv4Opt = &VolumeSpecPolicy_Sharedv4{x != 0}
		return true, err
	case 17: // queue_depth_opt.queue_depth
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.QueueDepthOpt = &VolumeSpecPolicy_QueueDepth{uint32(x)}
		return true, err
	case 18: // encrypted_opt.encrypted
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.EncryptedOpt = &VolumeSpecPolicy_Encrypted{x != 0}
		return true, err
	case 19: // aggregation_level_opt.aggregation_level
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.AggregationLevelOpt = &VolumeSpecPolicy_AggregationLevel{uint32(x)}
		return true, err
	case 54: // nodiscard_opt.nodiscard
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.NodiscardOpt = &VolumeSpecPolicy_Nodiscard{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _VolumeSpecPolicy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VolumeSpecPolicy)
	// size_opt
	switch x := m.SizeOpt.(type) {
	case *VolumeSpecPolicy_Size:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Size))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// ha_level_opt
	switch x := m.HaLevelOpt.(type) {
	case *VolumeSpecPolicy_HaLevel:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.HaLevel))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// cos_opt
	switch x := m.CosOpt.(type) {
	case *VolumeSpecPolicy_Cos:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Cos))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// io_profile_opt
	switch x := m.IoProfileOpt.(type) {
	case *VolumeSpecPolicy_IoProfile:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.IoProfile))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// dedupe_opt
	switch x := m.DedupeOpt.(type) {
	case *VolumeSpecPolicy_Dedupe:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// snapshot_interval_opt
	switch x := m.SnapshotIntervalOpt.(type) {
	case *VolumeSpecPolicy_SnapshotInterval:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.SnapshotInterval))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// shared_opt
	switch x := m.SharedOpt.(type) {
	case *VolumeSpecPolicy_Shared:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// passphrase_opt
	switch x := m.PassphraseOpt.(type) {
	case *VolumeSpecPolicy_Passphrase:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Passphrase)))
		n += len(x.Passphrase)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// snapshot_schedule_opt
	switch x := m.SnapshotScheduleOpt.(type) {
	case *VolumeSpecPolicy_SnapshotSchedule:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.SnapshotSchedule)))
		n += len(x.SnapshotSchedule)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// scale_opt
	switch x := m.ScaleOpt.(type) {
	case *VolumeSpecPolicy_Scale:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Scale))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// sticky_opt
	switch x := m.StickyOpt.(type) {
	case *VolumeSpecPolicy_Sticky:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// group_opt
	switch x := m.GroupOpt.(type) {
	case *VolumeSpecPolicy_Group:
		s := proto.Size(x.Group)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// journal_opt
	switch x := m.JournalOpt.(type) {
	case *VolumeSpecPolicy_Journal:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// sharedv4_opt
	switch x := m.Sharedv4Opt.(type) {
	case *VolumeSpecPolicy_Sharedv4:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// queue_depth_opt
	switch x := m.QueueDepthOpt.(type) {
	case *VolumeSpecPolicy_QueueDepth:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.QueueDepth))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// encrypted_opt
	switch x := m.EncryptedOpt.(type) {
	case *VolumeSpecPolicy_Encrypted:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// aggregation_level_opt
	switch x := m.AggregationLevelOpt.(type) {
	case *VolumeSpecPolicy_AggregationLevel:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(x.AggregationLevel))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// nodiscard_opt
	switch x := m.NodiscardOpt.(type) {
	case *VolumeSpecPolicy_Nodiscard:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// ReplicaSet set of machine IDs (nodes) to which part of this volume is erasure
// coded - for clustered storage arrays
type ReplicaSet struct {
	Nodes                []string `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReplicaSet) Reset()         { *m = ReplicaSet{} }
func (m *ReplicaSet) String() string { return proto.CompactTextString(m) }
func (*ReplicaSet) ProtoMessage()    {}
func (*ReplicaSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{10}
}
func (m *ReplicaSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReplicaSet.Unmarshal(m, b)
}
func (m *ReplicaSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReplicaSet.Marshal(b, m, deterministic)
}
func (dst *ReplicaSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaSet.Merge(dst, src)
}
func (m *ReplicaSet) XXX_Size() int {
	return xxx_messageInfo_ReplicaSet.Size(m)
}
func (m *ReplicaSet) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaSet.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaSet proto.InternalMessageInfo

func (m *ReplicaSet) GetNodes() []string {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// RuntimeStateMap is a list of name value mapping of driver specific runtime
// information.
type RuntimeStateMap struct {
	RuntimeState         map[string]string `protobuf:"bytes,1,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RuntimeStateMap) Reset()         { *m = RuntimeStateMap{} }
func (m *RuntimeStateMap) String() string { return proto.CompactTextString(m) }
func (*RuntimeStateMap) ProtoMessage()    {}
func (*RuntimeStateMap) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{11}
}
func (m *RuntimeStateMap) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RuntimeStateMap.Unmarshal(m, b)
}
func (m *RuntimeStateMap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RuntimeStateMap.Marshal(b, m, deterministic)
}
func (dst *RuntimeStateMap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RuntimeStateMap.Merge(dst, src)
}
func (m *RuntimeStateMap) XXX_Size() int {
	return xxx_messageInfo_RuntimeStateMap.Size(m)
}
func (m *RuntimeStateMap) XXX_DiscardUnknown() {
	xxx_messageInfo_RuntimeStateMap.DiscardUnknown(m)
}

var xxx_messageInfo_RuntimeStateMap proto.InternalMessageInfo

func (m *RuntimeStateMap) GetRuntimeState() map[string]string {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

// Ownership information for resource.
// Administrators are users who belong to the group `*`, meaning, every group.
type Ownership struct {
	// Username of owner.
	//
	// The storage system uses the username taken from the security authorization
	// token and is saved on this field. Only users with system administration
	// can edit this value.
	Owner string `protobuf:"bytes,1,opt,name=owner" json:"owner,omitempty"`
	// Permissions to share resource which can be set by the owner.
	//
	// NOTE: To create an "admin" user which has access to any resource set the group value
	// in the token of the user to `*`.
	Acls                 *Ownership_AccessControl `protobuf:"bytes,2,opt,name=acls" json:"acls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Ownership) Reset()         { *m = Ownership{} }
func (m *Ownership) String() string { return proto.CompactTextString(m) }
func (*Ownership) ProtoMessage()    {}
func (*Ownership) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{12}
}
func (m *Ownership) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ownership.Unmarshal(m, b)
}
func (m *Ownership) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ownership.Marshal(b, m, deterministic)
}
func (dst *Ownership) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ownership.Merge(dst, src)
}
func (m *Ownership) XXX_Size() int {
	return xxx_messageInfo_Ownership.Size(m)
}
func (m *Ownership) XXX_DiscardUnknown() {
	xxx_messageInfo_Ownership.DiscardUnknown(m)
}

var xxx_messageInfo_Ownership proto.InternalMessageInfo

func (m *Ownership) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *Ownership) GetAcls() *Ownership_AccessControl {
	if m != nil {
		return m.Acls
	}
	return nil
}

type Ownership_AccessControl struct {
	// Group access to resource which must match the group set in the
	// authorization token.
	// Can be set by the owner or the system administrator only.
	// Possible values are:
	// 1. no groups: Means no groups are given access.
	// 2. `["*"]`: All groups are allowed.
	// 3. `["group1", "group2"]`: Only certain groups are allowed. In this example only
	// _group1_ and _group2_ are allowed.
	Groups map[string]Ownership_AccessType `protobuf:"bytes,1,rep,name=groups" json:"groups,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=openstorage.api.Ownership_AccessType"`
	// Collaborator access to resource gives access to other user.
	// Must be the username (unique id) set in the authorization token.
	// The owner or the administrator can set this value. Possible values are:
	// 1. no collaborators: Means no users are given access.
	// 2. `["*"]`: All users are allowed.
	// 3. `["username1", "username2"]`: Only certain usernames are allowed. In this example only
	// _username1_ and _username2_ are allowed.
	Collaborators        map[string]Ownership_AccessType `protobuf:"bytes,2,rep,name=collaborators" json:"collaborators,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=openstorage.api.Ownership_AccessType"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Ownership_AccessControl) Reset()         { *m = Ownership_AccessControl{} }
func (m *Ownership_AccessControl) String() string { return proto.CompactTextString(m) }
func (*Ownership_AccessControl) ProtoMessage()    {}
func (*Ownership_AccessControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{12, 0}
}
func (m *Ownership_AccessControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Ownership_AccessControl.Unmarshal(m, b)
}
func (m *Ownership_AccessControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Ownership_AccessControl.Marshal(b, m, deterministic)
}
func (dst *Ownership_AccessControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ownership_AccessControl.Merge(dst, src)
}
func (m *Ownership_AccessControl) XXX_Size() int {
	return xxx_messageInfo_Ownership_AccessControl.Size(m)
}
func (m *Ownership_AccessControl) XXX_DiscardUnknown() {
	xxx_messageInfo_Ownership_AccessControl.DiscardUnknown(m)
}

var xxx_messageInfo_Ownership_AccessControl proto.InternalMessageInfo

func (m *Ownership_AccessControl) GetGroups() map[string]Ownership_AccessType {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *Ownership_AccessControl) GetCollaborators() map[string]Ownership_AccessType {
	if m != nil {
		return m.Collaborators
	}
	return nil
}

// Volume represents an abstract storage volume.
type Volume struct {
	// Self referential volume ID.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Source specified seed data for the volume.
	Source *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	// Group volumes in the same group have the same group id.
	Group *Group `protobuf:"bytes,3,opt,name=group" json:"group,omitempty"`
	// Readonly is true if this volume is to be mounted with readonly access.
	Readonly bool `protobuf:"varint,4,opt,name=readonly" json:"readonly,omitempty"`
	// User specified locator
	Locator *VolumeLocator `protobuf:"bytes,5,opt,name=locator" json:"locator,omitempty"`
	// Volume creation time
	Ctime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=ctime" json:"ctime,omitempty"`
	// User specified VolumeSpec
	Spec *VolumeSpec `protobuf:"bytes,7,opt,name=spec" json:"spec,omitempty"`
	// Usage is bytes consumed by vtheis volume.
	Usage uint64 `protobuf:"varint,8,opt,name=usage" json:"usage,omitempty"`
	// LastScan is the time when an integrity check was run.
	LastScan *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
	// Format specifies the filesytem for this volume.
	Format FSType `protobuf:"varint,10,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	// Status is the availability status of this volume.
	Status VolumeStatus `protobuf:"varint,11,opt,name=status,enum=openstorage.api.VolumeStatus" json:"status,omitempty"`
	// State is the current runtime state of this volume.
	State VolumeState `protobuf:"varint,12,opt,name=state,enum=openstorage.api.VolumeState" json:"state,omitempty"`
	// AttachedOn is the node instance identifier for clustered systems.
	AttachedOn string `protobuf:"bytes,13,opt,name=attached_on,json=attachedOn" json:"attached_on,omitempty"`
	// AttachedState shows whether the device is attached for internal or external use.
	AttachedState AttachState `protobuf:"varint,14,opt,name=attached_state,json=attachedState,enum=openstorage.api.AttachState" json:"attached_state,omitempty"`
	// DevicePath is the device exported by block device implementations.
	DevicePath string `protobuf:"bytes,15,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	// SecureDevicePath is the device path for an encrypted volume.
	SecureDevicePath string `protobuf:"bytes,16,opt,name=secure_device_path,json=secureDevicePath" json:"secure_device_path,omitempty"`
	// AttachPath is the mounted path in the host namespace.
	AttachPath []string `protobuf:"bytes,17,rep,name=attach_path,json=attachPath" json:"attach_path,omitempty"`
	// AttachInfo is a list of name value mappings that provides attach information.
	AttachInfo map[string]string `protobuf:"bytes,18,rep,name=attach_info,json=attachInfo" json:"attach_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ReplicatSets storage for this volumefor clustered storage arrays.
	ReplicaSets []*ReplicaSet `protobuf:"bytes,19,rep,name=replica_sets,json=replicaSets" json:"replica_sets,omitempty"`
	// RuntimeState is a lst of name value mapping of driver specific runtime
	// information.
	RuntimeState []*RuntimeStateMap `protobuf:"bytes,20,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty"`
	// Error is the Last recorded error.
	Error string `protobuf:"bytes,21,opt,name=error" json:"error,omitempty"`
	// VolumeConsumers are entities that consume this volume
	VolumeConsumers []*VolumeConsumer `protobuf:"bytes,22,rep,name=volume_consumers,json=volumeConsumers" json:"volume_consumers,omitempty"`
	// FsResizeRequired if an FS resize is required on the volume.
	FsResizeRequired     bool     `protobuf:"varint,23,opt,name=fs_resize_required,json=fsResizeRequired" json:"fs_resize_required,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Volume) Reset()         { *m = Volume{} }
func (m *Volume) String() string { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()    {}
func (*Volume) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{13}
}
func (m *Volume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Volume.Unmarshal(m, b)
}
func (m *Volume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Volume.Marshal(b, m, deterministic)
}
func (dst *Volume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Volume.Merge(dst, src)
}
func (m *Volume) XXX_Size() int {
	return xxx_messageInfo_Volume.Size(m)
}
func (m *Volume) XXX_DiscardUnknown() {
	xxx_messageInfo_Volume.DiscardUnknown(m)
}

var xxx_messageInfo_Volume proto.InternalMessageInfo

func (m *Volume) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Volume) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Volume) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *Volume) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *Volume) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *Volume) GetCtime() *timestamp.Timestamp {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *Volume) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Volume) GetUsage() uint64 {
	if m != nil {
		return m.Usage
	}
	return 0
}

func (m *Volume) GetLastScan() *timestamp.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

func (m *Volume) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *Volume) GetStatus() VolumeStatus {
	if m != nil {
		return m.Status
	}
	return VolumeStatus_VOLUME_STATUS_NONE
}

func (m *Volume) GetState() VolumeState {
	if m != nil {
		return m.State
	}
	return VolumeState_VOLUME_STATE_NONE
}

func (m *Volume) GetAttachedOn() string {
	if m != nil {
		return m.AttachedOn
	}
	return ""
}

func (m *Volume) GetAttachedState() AttachState {
	if m != nil {
		return m.AttachedState
	}
	return AttachState_ATTACH_STATE_EXTERNAL
}

func (m *Volume) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

func (m *Volume) GetSecureDevicePath() string {
	if m != nil {
		return m.SecureDevicePath
	}
	return ""
}

func (m *Volume) GetAttachPath() []string {
	if m != nil {
		return m.AttachPath
	}
	return nil
}

func (m *Volume) GetAttachInfo() map[string]string {
	if m != nil {
		return m.AttachInfo
	}
	return nil
}

func (m *Volume) GetReplicaSets() []*ReplicaSet {
	if m != nil {
		return m.ReplicaSets
	}
	return nil
}

func (m *Volume) GetRuntimeState() []*RuntimeStateMap {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

func (m *Volume) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Volume) GetVolumeConsumers() []*VolumeConsumer {
	if m != nil {
		return m.VolumeConsumers
	}
	return nil
}

func (m *Volume) GetFsResizeRequired() bool {
	if m != nil {
		return m.FsResizeRequired
	}
	return false
}

// Stats is a structure that represents last collected stats for a volume
type Stats struct {
	// Reads completed successfully
	Reads uint64 `protobuf:"varint,1,opt,name=reads" json:"reads,omitempty"`
	// Time spent in reads in ms
	ReadMs uint64 `protobuf:"varint,2,opt,name=read_ms,json=readMs" json:"read_ms,omitempty"`
	// Number of bytes read
	ReadBytes uint64 `protobuf:"varint,3,opt,name=read_bytes,json=readBytes" json:"read_bytes,omitempty"`
	// Writes completed successfully
	Writes uint64 `protobuf:"varint,4,opt,name=writes" json:"writes,omitempty"`
	// Time spent in writes in ms
	WriteMs uint64 `protobuf:"varint,5,opt,name=write_ms,json=writeMs" json:"write_ms,omitempty"`
	// Number of bytes written
	WriteBytes uint64 `protobuf:"varint,6,opt,name=write_bytes,json=writeBytes" json:"write_bytes,omitempty"`
	// IOs curently in progress
	IoProgress uint64 `protobuf:"varint,7,opt,name=io_progress,json=ioProgress" json:"io_progress,omitempty"`
	// Time spent doing IOs ms
	IoMs uint64 `protobuf:"varint,8,opt,name=io_ms,json=ioMs" json:"io_ms,omitempty"`
	// BytesUsed
	BytesUsed uint64 `protobuf:"varint,9,opt,name=bytes_used,json=bytesUsed" json:"bytes_used,omitempty"`
	// Interval in ms during which stats were collected
	IntervalMs           uint64   `protobuf:"varint,10,opt,name=interval_ms,json=intervalMs" json:"interval_ms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Stats) Reset()         { *m = Stats{} }
func (m *Stats) String() string { return proto.CompactTextString(m) }
func (*Stats) ProtoMessage()    {}
func (*Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{14}
}
func (m *Stats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Stats.Unmarshal(m, b)
}
func (m *Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Stats.Marshal(b, m, deterministic)
}
func (dst *Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stats.Merge(dst, src)
}
func (m *Stats) XXX_Size() int {
	return xxx_messageInfo_Stats.Size(m)
}
func (m *Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_Stats.DiscardUnknown(m)
}

var xxx_messageInfo_Stats proto.InternalMessageInfo

func (m *Stats) GetReads() uint64 {
	if m != nil {
		return m.Reads
	}
	return 0
}

func (m *Stats) GetReadMs() uint64 {
	if m != nil {
		return m.ReadMs
	}
	return 0
}

func (m *Stats) GetReadBytes() uint64 {
	if m != nil {
		return m.ReadBytes
	}
	return 0
}

func (m *Stats) GetWrites() uint64 {
	if m != nil {
		return m.Writes
	}
	return 0
}

func (m *Stats) GetWriteMs() uint64 {
	if m != nil {
		return m.WriteMs
	}
	return 0
}

func (m *Stats) GetWriteBytes() uint64 {
	if m != nil {
		return m.WriteBytes
	}
	return 0
}

func (m *Stats) GetIoProgress() uint64 {
	if m != nil {
		return m.IoProgress
	}
	return 0
}

func (m *Stats) GetIoMs() uint64 {
	if m != nil {
		return m.IoMs
	}
	return 0
}

func (m *Stats) GetBytesUsed() uint64 {
	if m != nil {
		return m.BytesUsed
	}
	return 0
}

func (m *Stats) GetIntervalMs() uint64 {
	if m != nil {
		return m.IntervalMs
	}
	return 0
}

// Provides details on exclusive and shared storage used by
// snapshot/volume specifically for copy-on-write(COW) snapshots. Deletion
// of snapshots and overwirte of volume will affect the exclusive storage
// used by the other dependent snaps and parent volume.
type CapacityUsageInfo struct {
	// Storage consumed exclusively by this single snapshot. Deletion of this
	// snapshot may increase the free storage available by this amount.
	ExclusiveBytes int64 `protobuf:"varint,1,opt,name=exclusive_bytes,json=exclusiveBytes" json:"exclusive_bytes,omitempty"`
	// Storage consumed by this snapshot that is shared with parent and children
	SharedBytes int64 `protobuf:"varint,2,opt,name=shared_bytes,json=sharedBytes" json:"shared_bytes,omitempty"`
	// TotalBytes used by this volume
	TotalBytes           int64    `protobuf:"varint,3,opt,name=total_bytes,json=totalBytes" json:"total_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CapacityUsageInfo) Reset()         { *m = CapacityUsageInfo{} }
func (m *CapacityUsageInfo) String() string { return proto.CompactTextString(m) }
func (*CapacityUsageInfo) ProtoMessage()    {}
func (*CapacityUsageInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{15}
}
func (m *CapacityUsageInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CapacityUsageInfo.Unmarshal(m, b)
}
func (m *CapacityUsageInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CapacityUsageInfo.Marshal(b, m, deterministic)
}
func (dst *CapacityUsageInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CapacityUsageInfo.Merge(dst, src)
}
func (m *CapacityUsageInfo) XXX_Size() int {
	return xxx_messageInfo_CapacityUsageInfo.Size(m)
}
func (m *CapacityUsageInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CapacityUsageInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CapacityUsageInfo proto.InternalMessageInfo

func (m *CapacityUsageInfo) GetExclusiveBytes() int64 {
	if m != nil {
		return m.ExclusiveBytes
	}
	return 0
}

func (m *CapacityUsageInfo) GetSharedBytes() int64 {
	if m != nil {
		return m.SharedBytes
	}
	return 0
}

func (m *CapacityUsageInfo) GetTotalBytes() int64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

// A SdkStoragePolicy represents minimum set of volume specs to be
// follow while creating volumes.
// If storage policy is set default in OpenStoragePolicy service, VolumeSpecPolicy will be
// used before creating volume to validate volume specs or ensure minimum volume creation
// rules followed
type SdkStoragePolicy struct {
	// Name of storage policy.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// VolumeSpecs to apply while creating volume.
	Policy *VolumeSpecPolicy `protobuf:"bytes,2,opt,name=policy" json:"policy,omitempty"`
	// Force if set to true volume specs will be overwritten, otherwise
	// volume creation will fail if the volume specifications are not inline with storage policy
	Force bool `protobuf:"varint,3,opt,name=force" json:"force,omitempty"`
	// If set a volume can be updated without storage Policy
	// restriction, otherwise volume update will be followed as per storage policy
	// specification
	AllowUpdate bool `protobuf:"varint,4,opt,name=allow_update,json=allowUpdate" json:"allow_update,omitempty"`
	// Owner info of storage policy
	Ownership            *Ownership `protobuf:"bytes,5,opt,name=ownership" json:"ownership,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SdkStoragePolicy) Reset()         { *m = SdkStoragePolicy{} }
func (m *SdkStoragePolicy) String() string { return proto.CompactTextString(m) }
func (*SdkStoragePolicy) ProtoMessage()    {}
func (*SdkStoragePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{16}
}
func (m *SdkStoragePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkStoragePolicy.Unmarshal(m, b)
}
func (m *SdkStoragePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkStoragePolicy.Marshal(b, m, deterministic)
}
func (dst *SdkStoragePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkStoragePolicy.Merge(dst, src)
}
func (m *SdkStoragePolicy) XXX_Size() int {
	return xxx_messageInfo_SdkStoragePolicy.Size(m)
}
func (m *SdkStoragePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkStoragePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SdkStoragePolicy proto.InternalMessageInfo

func (m *SdkStoragePolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkStoragePolicy) GetPolicy() *VolumeSpecPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *SdkStoragePolicy) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *SdkStoragePolicy) GetAllowUpdate() bool {
	if m != nil {
		return m.AllowUpdate
	}
	return false
}

func (m *SdkStoragePolicy) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

// Alert is a structure that represents an alert object
type Alert struct {
	// Id for Alert
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Severity of the Alert
	Severity SeverityType `protobuf:"varint,2,opt,name=severity,enum=openstorage.api.SeverityType" json:"severity,omitempty"`
	// AlertType user defined alert type
	AlertType int64 `protobuf:"varint,3,opt,name=alert_type,json=alertType" json:"alert_type,omitempty"`
	// Message describing the Alert
	Message string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	// Timestamp when Alert occured
	Timestamp *timestamp.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp,omitempty"`
	// ResourceId where Alert occured
	ResourceId string `protobuf:"bytes,6,opt,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	// Resource where Alert occured
	Resource ResourceType `protobuf:"varint,7,opt,name=resource,enum=openstorage.api.ResourceType" json:"resource,omitempty"`
	// Cleared Flag
	Cleared bool `protobuf:"varint,8,opt,name=cleared" json:"cleared,omitempty"`
	// Time-to-live in seconds for this Alert
	Ttl uint64 `protobuf:"varint,9,opt,name=ttl" json:"ttl,omitempty"`
	// UniqueTag helps identify a unique alert for a given resouce
	UniqueTag string `protobuf:"bytes,10,opt,name=unique_tag,json=uniqueTag" json:"unique_tag,omitempty"`
	// Count of such alerts raised so far.
	Count int64 `protobuf:"varint,11,opt,name=count" json:"count,omitempty"`
	// Timestamp when such alert was raised the very first time.
	FirstSeen            *timestamp.Timestamp `protobuf:"bytes,12,opt,name=first_seen,json=firstSeen" json:"first_seen,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Alert) Reset()         { *m = Alert{} }
func (m *Alert) String() string { return proto.CompactTextString(m) }
func (*Alert) ProtoMessage()    {}
func (*Alert) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{17}
}
func (m *Alert) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Alert.Unmarshal(m, b)
}
func (m *Alert) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Alert.Marshal(b, m, deterministic)
}
func (dst *Alert) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alert.Merge(dst, src)
}
func (m *Alert) XXX_Size() int {
	return xxx_messageInfo_Alert.Size(m)
}
func (m *Alert) XXX_DiscardUnknown() {
	xxx_messageInfo_Alert.DiscardUnknown(m)
}

var xxx_messageInfo_Alert proto.InternalMessageInfo

func (m *Alert) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Alert) GetSeverity() SeverityType {
	if m != nil {
		return m.Severity
	}
	return SeverityType_SEVERITY_TYPE_NONE
}

func (m *Alert) GetAlertType() int64 {
	if m != nil {
		return m.AlertType
	}
	return 0
}

func (m *Alert) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *Alert) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *Alert) GetResource() ResourceType {
	if m != nil {
		return m.Resource
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

func (m *Alert) GetCleared() bool {
	if m != nil {
		return m.Cleared
	}
	return false
}

func (m *Alert) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *Alert) GetUniqueTag() string {
	if m != nil {
		return m.UniqueTag
	}
	return ""
}

func (m *Alert) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Alert) GetFirstSeen() *timestamp.Timestamp {
	if m != nil {
		return m.FirstSeen
	}
	return nil
}

// SdkAlertsTimeSpan to store time window information.
type SdkAlertsTimeSpan struct {
	// Start timestamp when Alert occured
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End timestamp when Alert occured
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SdkAlertsTimeSpan) Reset()         { *m = SdkAlertsTimeSpan{} }
func (m *SdkAlertsTimeSpan) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsTimeSpan) ProtoMessage()    {}
func (*SdkAlertsTimeSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{18}
}
func (m *SdkAlertsTimeSpan) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsTimeSpan.Unmarshal(m, b)
}
func (m *SdkAlertsTimeSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsTimeSpan.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsTimeSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsTimeSpan.Merge(dst, src)
}
func (m *SdkAlertsTimeSpan) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsTimeSpan.Size(m)
}
func (m *SdkAlertsTimeSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsTimeSpan.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsTimeSpan proto.InternalMessageInfo

func (m *SdkAlertsTimeSpan) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *SdkAlertsTimeSpan) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// SdkAlertsCountSpan to store count range information.
type SdkAlertsCountSpan struct {
	// Min count of such alerts raised so far.
	MinCount int64 `protobuf:"varint,1,opt,name=min_count,json=minCount" json:"min_count,omitempty"`
	// Max count of such alerts raised so far.
	MaxCount             int64    `protobuf:"varint,2,opt,name=max_count,json=maxCount" json:"max_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAlertsCountSpan) Reset()         { *m = SdkAlertsCountSpan{} }
func (m *SdkAlertsCountSpan) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsCountSpan) ProtoMessage()    {}
func (*SdkAlertsCountSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{19}
}
func (m *SdkAlertsCountSpan) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsCountSpan.Unmarshal(m, b)
}
func (m *SdkAlertsCountSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsCountSpan.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsCountSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsCountSpan.Merge(dst, src)
}
func (m *SdkAlertsCountSpan) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsCountSpan.Size(m)
}
func (m *SdkAlertsCountSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsCountSpan.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsCountSpan proto.InternalMessageInfo

func (m *SdkAlertsCountSpan) GetMinCount() int64 {
	if m != nil {
		return m.MinCount
	}
	return 0
}

func (m *SdkAlertsCountSpan) GetMaxCount() int64 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

// SdkAlertsOption contains options for filtering alerts.
type SdkAlertsOption struct {
	// Types that are valid to be assigned to Opt:
	//	*SdkAlertsOption_MinSeverityType
	//	*SdkAlertsOption_IsCleared
	//	*SdkAlertsOption_TimeSpan
	//	*SdkAlertsOption_CountSpan
	Opt                  isSdkAlertsOption_Opt `protobuf_oneof:"opt"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SdkAlertsOption) Reset()         { *m = SdkAlertsOption{} }
func (m *SdkAlertsOption) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsOption) ProtoMessage()    {}
func (*SdkAlertsOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{20}
}
func (m *SdkAlertsOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsOption.Unmarshal(m, b)
}
func (m *SdkAlertsOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsOption.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsOption.Merge(dst, src)
}
func (m *SdkAlertsOption) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsOption.Size(m)
}
func (m *SdkAlertsOption) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsOption.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsOption proto.InternalMessageInfo

type isSdkAlertsOption_Opt interface {
	isSdkAlertsOption_Opt()
}

type SdkAlertsOption_MinSeverityType struct {
	MinSeverityType SeverityType `protobuf:"varint,1,opt,name=min_severity_type,json=minSeverityType,enum=openstorage.api.SeverityType,oneof"`
}
type SdkAlertsOption_IsCleared struct {
	IsCleared bool `protobuf:"varint,2,opt,name=is_cleared,json=isCleared,oneof"`
}
type SdkAlertsOption_TimeSpan struct {
	TimeSpan *SdkAlertsTimeSpan `protobuf:"bytes,3,opt,name=time_span,json=timeSpan,oneof"`
}
type SdkAlertsOption_CountSpan struct {
	CountSpan *SdkAlertsCountSpan `protobuf:"bytes,4,opt,name=count_span,json=countSpan,oneof"`
}

func (*SdkAlertsOption_MinSeverityType) isSdkAlertsOption_Opt() {}
func (*SdkAlertsOption_IsCleared) isSdkAlertsOption_Opt()       {}
func (*SdkAlertsOption_TimeSpan) isSdkAlertsOption_Opt()        {}
func (*SdkAlertsOption_CountSpan) isSdkAlertsOption_Opt()       {}

func (m *SdkAlertsOption) GetOpt() isSdkAlertsOption_Opt {
	if m != nil {
		return m.Opt
	}
	return nil
}

func (m *SdkAlertsOption) GetMinSeverityType() SeverityType {
	if x, ok := m.GetOpt().(*SdkAlertsOption_MinSeverityType); ok {
		return x.MinSeverityType
	}
	return SeverityType_SEVERITY_TYPE_NONE
}

func (m *SdkAlertsOption) GetIsCleared() bool {
	if x, ok := m.GetOpt().(*SdkAlertsOption_IsCleared); ok {
		return x.IsCleared
	}
	return false
}

func (m *SdkAlertsOption) GetTimeSpan() *SdkAlertsTimeSpan {
	if x, ok := m.GetOpt().(*SdkAlertsOption_TimeSpan); ok {
		return x.TimeSpan
	}
	return nil
}

func (m *SdkAlertsOption) GetCountSpan() *SdkAlertsCountSpan {
	if x, ok := m.GetOpt().(*SdkAlertsOption_CountSpan); ok {
		return x.CountSpan
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkAlertsOption) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkAlertsOption_OneofMarshaler, _SdkAlertsOption_OneofUnmarshaler, _SdkAlertsOption_OneofSizer, []interface{}{
		(*SdkAlertsOption_MinSeverityType)(nil),
		(*SdkAlertsOption_IsCleared)(nil),
		(*SdkAlertsOption_TimeSpan)(nil),
		(*SdkAlertsOption_CountSpan)(nil),
	}
}

func _SdkAlertsOption_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkAlertsOption)
	// opt
	switch x := m.Opt.(type) {
	case *SdkAlertsOption_MinSeverityType:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.MinSeverityType))
	case *SdkAlertsOption_IsCleared:
		t := uint64(0)
		if x.IsCleared {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *SdkAlertsOption_TimeSpan:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimeSpan); err != nil {
			return err
		}
	case *SdkAlertsOption_CountSpan:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CountSpan); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkAlertsOption.Opt has unexpected type %T", x)
	}
	return nil
}

func _SdkAlertsOption_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkAlertsOption)
	switch tag {
	case 1: // opt.min_severity_type
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Opt = &SdkAlertsOption_MinSeverityType{SeverityType(x)}
		return true, err
	case 2: // opt.is_cleared
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Opt = &SdkAlertsOption_IsCleared{x != 0}
		return true, err
	case 3: // opt.time_span
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAlertsTimeSpan)
		err := b.DecodeMessage(msg)
		m.Opt = &SdkAlertsOption_TimeSpan{msg}
		return true, err
	case 4: // opt.count_span
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAlertsCountSpan)
		err := b.DecodeMessage(msg)
		m.Opt = &SdkAlertsOption_CountSpan{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkAlertsOption_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkAlertsOption)
	// opt
	switch x := m.Opt.(type) {
	case *SdkAlertsOption_MinSeverityType:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.MinSeverityType))
	case *SdkAlertsOption_IsCleared:
		n += 1 // tag and wire
		n += 1
	case *SdkAlertsOption_TimeSpan:
		s := proto.Size(x.TimeSpan)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkAlertsOption_CountSpan:
		s := proto.Size(x.CountSpan)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// SdkAlertsResourceTypeQuery queries for alerts using only resource id.
type SdkAlertsResourceTypeQuery struct {
	// Resource type used to build query.
	ResourceType         ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,enum=openstorage.api.ResourceType" json:"resource_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SdkAlertsResourceTypeQuery) Reset()         { *m = SdkAlertsResourceTypeQuery{} }
func (m *SdkAlertsResourceTypeQuery) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsResourceTypeQuery) ProtoMessage()    {}
func (*SdkAlertsResourceTypeQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{21}
}
func (m *SdkAlertsResourceTypeQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsResourceTypeQuery.Unmarshal(m, b)
}
func (m *SdkAlertsResourceTypeQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsResourceTypeQuery.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsResourceTypeQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsResourceTypeQuery.Merge(dst, src)
}
func (m *SdkAlertsResourceTypeQuery) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsResourceTypeQuery.Size(m)
}
func (m *SdkAlertsResourceTypeQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsResourceTypeQuery.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsResourceTypeQuery proto.InternalMessageInfo

func (m *SdkAlertsResourceTypeQuery) GetResourceType() ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

// SdkAlertsAlertTypeQuery queries for alerts using alert type
// and it requires that resource type be provided as well.
type SdkAlertsAlertTypeQuery struct {
	// Resource type used to build query.
	ResourceType ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,enum=openstorage.api.ResourceType" json:"resource_type,omitempty"`
	// Alert type used to build query.
	AlertType            int64    `protobuf:"varint,2,opt,name=alert_type,json=alertType" json:"alert_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAlertsAlertTypeQuery) Reset()         { *m = SdkAlertsAlertTypeQuery{} }
func (m *SdkAlertsAlertTypeQuery) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsAlertTypeQuery) ProtoMessage()    {}
func (*SdkAlertsAlertTypeQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{22}
}
func (m *SdkAlertsAlertTypeQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsAlertTypeQuery.Unmarshal(m, b)
}
func (m *SdkAlertsAlertTypeQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsAlertTypeQuery.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsAlertTypeQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsAlertTypeQuery.Merge(dst, src)
}
func (m *SdkAlertsAlertTypeQuery) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsAlertTypeQuery.Size(m)
}
func (m *SdkAlertsAlertTypeQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsAlertTypeQuery.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsAlertTypeQuery proto.InternalMessageInfo

func (m *SdkAlertsAlertTypeQuery) GetResourceType() ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

func (m *SdkAlertsAlertTypeQuery) GetAlertType() int64 {
	if m != nil {
		return m.AlertType
	}
	return 0
}

// SdkAlertsResourceIdQuery queries for alerts using resource id
// and it requires that both alert type and resource type be provided
// as well.
type SdkAlertsResourceIdQuery struct {
	// Resource type used to build query.
	ResourceType ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,enum=openstorage.api.ResourceType" json:"resource_type,omitempty"`
	// Alert type used to build query.
	AlertType int64 `protobuf:"varint,2,opt,name=alert_type,json=alertType" json:"alert_type,omitempty"`
	// Resource ID used to build query.
	ResourceId           string   `protobuf:"bytes,3,opt,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAlertsResourceIdQuery) Reset()         { *m = SdkAlertsResourceIdQuery{} }
func (m *SdkAlertsResourceIdQuery) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsResourceIdQuery) ProtoMessage()    {}
func (*SdkAlertsResourceIdQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{23}
}
func (m *SdkAlertsResourceIdQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsResourceIdQuery.Unmarshal(m, b)
}
func (m *SdkAlertsResourceIdQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsResourceIdQuery.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsResourceIdQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsResourceIdQuery.Merge(dst, src)
}
func (m *SdkAlertsResourceIdQuery) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsResourceIdQuery.Size(m)
}
func (m *SdkAlertsResourceIdQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsResourceIdQuery.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsResourceIdQuery proto.InternalMessageInfo

func (m *SdkAlertsResourceIdQuery) GetResourceType() ResourceType {
	if m != nil {
		return m.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

func (m *SdkAlertsResourceIdQuery) GetAlertType() int64 {
	if m != nil {
		return m.AlertType
	}
	return 0
}

func (m *SdkAlertsResourceIdQuery) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

// SdkAlertsQuery is one of the query types and a list of options.
// Each query object is one of the three query types and a list of
// options.
type SdkAlertsQuery struct {
	// One of the query types can be used to build SdkAlertsQuery.
	//
	// Types that are valid to be assigned to Query:
	//	*SdkAlertsQuery_ResourceTypeQuery
	//	*SdkAlertsQuery_AlertTypeQuery
	//	*SdkAlertsQuery_ResourceIdQuery
	Query isSdkAlertsQuery_Query `protobuf_oneof:"query"`
	// Opts is a list of options associated with one of the queries.
	Opts                 []*SdkAlertsOption `protobuf:"bytes,4,rep,name=opts" json:"opts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdkAlertsQuery) Reset()         { *m = SdkAlertsQuery{} }
func (m *SdkAlertsQuery) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsQuery) ProtoMessage()    {}
func (*SdkAlertsQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{24}
}
func (m *SdkAlertsQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsQuery.Unmarshal(m, b)
}
func (m *SdkAlertsQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsQuery.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsQuery.Merge(dst, src)
}
func (m *SdkAlertsQuery) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsQuery.Size(m)
}
func (m *SdkAlertsQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsQuery.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsQuery proto.InternalMessageInfo

type isSdkAlertsQuery_Query interface {
	isSdkAlertsQuery_Query()
}

type SdkAlertsQuery_ResourceTypeQuery struct {
	ResourceTypeQuery *SdkAlertsResourceTypeQuery `protobuf:"bytes,1,opt,name=resource_type_query,json=resourceTypeQuery,oneof"`
}
type SdkAlertsQuery_AlertTypeQuery struct {
	AlertTypeQuery *SdkAlertsAlertTypeQuery `protobuf:"bytes,2,opt,name=alert_type_query,json=alertTypeQuery,oneof"`
}
type SdkAlertsQuery_ResourceIdQuery struct {
	ResourceIdQuery *SdkAlertsResourceIdQuery `protobuf:"bytes,3,opt,name=resource_id_query,json=resourceIdQuery,oneof"`
}

func (*SdkAlertsQuery_ResourceTypeQuery) isSdkAlertsQuery_Query() {}
func (*SdkAlertsQuery_AlertTypeQuery) isSdkAlertsQuery_Query()    {}
func (*SdkAlertsQuery_ResourceIdQuery) isSdkAlertsQuery_Query()   {}

func (m *SdkAlertsQuery) GetQuery() isSdkAlertsQuery_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SdkAlertsQuery) GetResourceTypeQuery() *SdkAlertsResourceTypeQuery {
	if x, ok := m.GetQuery().(*SdkAlertsQuery_ResourceTypeQuery); ok {
		return x.ResourceTypeQuery
	}
	return nil
}

func (m *SdkAlertsQuery) GetAlertTypeQuery() *SdkAlertsAlertTypeQuery {
	if x, ok := m.GetQuery().(*SdkAlertsQuery_AlertTypeQuery); ok {
		return x.AlertTypeQuery
	}
	return nil
}

func (m *SdkAlertsQuery) GetResourceIdQuery() *SdkAlertsResourceIdQuery {
	if x, ok := m.GetQuery().(*SdkAlertsQuery_ResourceIdQuery); ok {
		return x.ResourceIdQuery
	}
	return nil
}

func (m *SdkAlertsQuery) GetOpts() []*SdkAlertsOption {
	if m != nil {
		return m.Opts
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkAlertsQuery) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkAlertsQuery_OneofMarshaler, _SdkAlertsQuery_OneofUnmarshaler, _SdkAlertsQuery_OneofSizer, []interface{}{
		(*SdkAlertsQuery_ResourceTypeQuery)(nil),
		(*SdkAlertsQuery_AlertTypeQuery)(nil),
		(*SdkAlertsQuery_ResourceIdQuery)(nil),
	}
}

func _SdkAlertsQuery_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkAlertsQuery)
	// query
	switch x := m.Query.(type) {
	case *SdkAlertsQuery_ResourceTypeQuery:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceTypeQuery); err != nil {
			return err
		}
	case *SdkAlertsQuery_AlertTypeQuery:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AlertTypeQuery); err != nil {
			return err
		}
	case *SdkAlertsQuery_ResourceIdQuery:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResourceIdQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkAlertsQuery.Query has unexpected type %T", x)
	}
	return nil
}

func _SdkAlertsQuery_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkAlertsQuery)
	switch tag {
	case 1: // query.resource_type_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAlertsResourceTypeQuery)
		err := b.DecodeMessage(msg)
		m.Query = &SdkAlertsQuery_ResourceTypeQuery{msg}
		return true, err
	case 2: // query.alert_type_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAlertsAlertTypeQuery)
		err := b.DecodeMessage(msg)
		m.Query = &SdkAlertsQuery_AlertTypeQuery{msg}
		return true, err
	case 3: // query.resource_id_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAlertsResourceIdQuery)
		err := b.DecodeMessage(msg)
		m.Query = &SdkAlertsQuery_ResourceIdQuery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkAlertsQuery_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkAlertsQuery)
	// query
	switch x := m.Query.(type) {
	case *SdkAlertsQuery_ResourceTypeQuery:
		s := proto.Size(x.ResourceTypeQuery)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkAlertsQuery_AlertTypeQuery:
		s := proto.Size(x.AlertTypeQuery)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkAlertsQuery_ResourceIdQuery:
		s := proto.Size(x.ResourceIdQuery)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// SdkAlertsEnumerateRequest is a request message to enumerate alerts.
type SdkAlertsEnumerateWithFiltersRequest struct {
	// It is a list of queries to find matching alerts.
	// Output of each of these queries is added to a global pool
	// and returned as output of an RPC call.
	// In that sense alerts are fetched if they match any of the
	// queries.
	Queries              []*SdkAlertsQuery `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkAlertsEnumerateWithFiltersRequest) Reset()         { *m = SdkAlertsEnumerateWithFiltersRequest{} }
func (m *SdkAlertsEnumerateWithFiltersRequest) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsEnumerateWithFiltersRequest) ProtoMessage()    {}
func (*SdkAlertsEnumerateWithFiltersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{25}
}
func (m *SdkAlertsEnumerateWithFiltersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest.Unmarshal(m, b)
}
func (m *SdkAlertsEnumerateWithFiltersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsEnumerateWithFiltersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest.Merge(dst, src)
}
func (m *SdkAlertsEnumerateWithFiltersRequest) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest.Size(m)
}
func (m *SdkAlertsEnumerateWithFiltersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsEnumerateWithFiltersRequest proto.InternalMessageInfo

func (m *SdkAlertsEnumerateWithFiltersRequest) GetQueries() []*SdkAlertsQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

// SdkAlertsEnumerateResponse is a list of alerts.
type SdkAlertsEnumerateWithFiltersResponse struct {
	// Response contains a list of alerts.
	Alerts               []*Alert `protobuf:"bytes,1,rep,name=alerts" json:"alerts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAlertsEnumerateWithFiltersResponse) Reset()         { *m = SdkAlertsEnumerateWithFiltersResponse{} }
func (m *SdkAlertsEnumerateWithFiltersResponse) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsEnumerateWithFiltersResponse) ProtoMessage()    {}
func (*SdkAlertsEnumerateWithFiltersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{26}
}
func (m *SdkAlertsEnumerateWithFiltersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse.Unmarshal(m, b)
}
func (m *SdkAlertsEnumerateWithFiltersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsEnumerateWithFiltersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse.Merge(dst, src)
}
func (m *SdkAlertsEnumerateWithFiltersResponse) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse.Size(m)
}
func (m *SdkAlertsEnumerateWithFiltersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsEnumerateWithFiltersResponse proto.InternalMessageInfo

func (m *SdkAlertsEnumerateWithFiltersResponse) GetAlerts() []*Alert {
	if m != nil {
		return m.Alerts
	}
	return nil
}

// SdkAlertsDeleteRequest is a request message to delete alerts.
type SdkAlertsDeleteRequest struct {
	// It takes a list of queries to find matching alerts.
	// Matching alerts are deleted.
	Queries              []*SdkAlertsQuery `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkAlertsDeleteRequest) Reset()         { *m = SdkAlertsDeleteRequest{} }
func (m *SdkAlertsDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsDeleteRequest) ProtoMessage()    {}
func (*SdkAlertsDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{27}
}
func (m *SdkAlertsDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsDeleteRequest.Unmarshal(m, b)
}
func (m *SdkAlertsDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsDeleteRequest.Merge(dst, src)
}
func (m *SdkAlertsDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsDeleteRequest.Size(m)
}
func (m *SdkAlertsDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsDeleteRequest proto.InternalMessageInfo

func (m *SdkAlertsDeleteRequest) GetQueries() []*SdkAlertsQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

// SdkAlertsDeleteResponse is empty.
type SdkAlertsDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAlertsDeleteResponse) Reset()         { *m = SdkAlertsDeleteResponse{} }
func (m *SdkAlertsDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkAlertsDeleteResponse) ProtoMessage()    {}
func (*SdkAlertsDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{28}
}
func (m *SdkAlertsDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAlertsDeleteResponse.Unmarshal(m, b)
}
func (m *SdkAlertsDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAlertsDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkAlertsDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAlertsDeleteResponse.Merge(dst, src)
}
func (m *SdkAlertsDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkAlertsDeleteResponse.Size(m)
}
func (m *SdkAlertsDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAlertsDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAlertsDeleteResponse proto.InternalMessageInfo

// Alerts is an array of Alert objects
type Alerts struct {
	Alert                []*Alert `protobuf:"bytes,1,rep,name=alert" json:"alert,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Alerts) Reset()         { *m = Alerts{} }
func (m *Alerts) String() string { return proto.CompactTextString(m) }
func (*Alerts) ProtoMessage()    {}
func (*Alerts) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{29}
}
func (m *Alerts) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Alerts.Unmarshal(m, b)
}
func (m *Alerts) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Alerts.Marshal(b, m, deterministic)
}
func (dst *Alerts) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Alerts.Merge(dst, src)
}
func (m *Alerts) XXX_Size() int {
	return xxx_messageInfo_Alerts.Size(m)
}
func (m *Alerts) XXX_DiscardUnknown() {
	xxx_messageInfo_Alerts.DiscardUnknown(m)
}

var xxx_messageInfo_Alerts proto.InternalMessageInfo

func (m *Alerts) GetAlert() []*Alert {
	if m != nil {
		return m.Alert
	}
	return nil
}

// ObjectstoreInfo is a structure that has current objectstore info
type ObjectstoreInfo struct {
	// UUID of objectstore
	Uuid string `protobuf:"bytes,1,opt,name=uuid" json:"uuid,omitempty"`
	// VolumeID of volume used by object store
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Enable/Disable created objectstore
	Enabled bool `protobuf:"varint,3,opt,name=enabled" json:"enabled,omitempty"`
	// Status of objectstore running/failed
	Status string `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	// Action being taken on this objectstore
	Action int64 `protobuf:"varint,5,opt,name=action" json:"action,omitempty"`
	// AccessKey for login into objectstore
	AccessKey string `protobuf:"bytes,6,opt,name=access_key,json=accessKey" json:"access_key,omitempty"`
	// SecretKey for login into objectstore
	SecretKey string `protobuf:"bytes,7,opt,name=secret_key,json=secretKey" json:"secret_key,omitempty"`
	// Endpoints for accessing objectstore
	Endpoints []string `protobuf:"bytes,8,rep,name=endpoints" json:"endpoints,omitempty"`
	// CurrentEndpoint on which objectstore server is accessible
	CurrentEndpoint string `protobuf:"bytes,9,opt,name=current_endpoint,json=currentEndpoint" json:"current_endpoint,omitempty"`
	// AccessPort is objectstore server port
	AccessPort int64 `protobuf:"varint,10,opt,name=access_port,json=accessPort" json:"access_port,omitempty"`
	// Region for this objectstore
	Region               string   `protobuf:"bytes,11,opt,name=region" json:"region,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectstoreInfo) Reset()         { *m = ObjectstoreInfo{} }
func (m *ObjectstoreInfo) String() string { return proto.CompactTextString(m) }
func (*ObjectstoreInfo) ProtoMessage()    {}
func (*ObjectstoreInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{30}
}
func (m *ObjectstoreInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectstoreInfo.Unmarshal(m, b)
}
func (m *ObjectstoreInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectstoreInfo.Marshal(b, m, deterministic)
}
func (dst *ObjectstoreInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectstoreInfo.Merge(dst, src)
}
func (m *ObjectstoreInfo) XXX_Size() int {
	return xxx_messageInfo_ObjectstoreInfo.Size(m)
}
func (m *ObjectstoreInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectstoreInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectstoreInfo proto.InternalMessageInfo

func (m *ObjectstoreInfo) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *ObjectstoreInfo) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ObjectstoreInfo) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *ObjectstoreInfo) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *ObjectstoreInfo) GetAction() int64 {
	if m != nil {
		return m.Action
	}
	return 0
}

func (m *ObjectstoreInfo) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *ObjectstoreInfo) GetSecretKey() string {
	if m != nil {
		return m.SecretKey
	}
	return ""
}

func (m *ObjectstoreInfo) GetEndpoints() []string {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *ObjectstoreInfo) GetCurrentEndpoint() string {
	if m != nil {
		return m.CurrentEndpoint
	}
	return ""
}

func (m *ObjectstoreInfo) GetAccessPort() int64 {
	if m != nil {
		return m.AccessPort
	}
	return 0
}

func (m *ObjectstoreInfo) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

// VolumeCreateRequest is a structure that has the locator, source and spec
// to create a volume
type VolumeCreateRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// Source to create volume
	Source *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	// The storage spec for the volume
	Spec                 *VolumeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *VolumeCreateRequest) Reset()         { *m = VolumeCreateRequest{} }
func (m *VolumeCreateRequest) String() string { return proto.CompactTextString(m) }
func (*VolumeCreateRequest) ProtoMessage()    {}
func (*VolumeCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{31}
}
func (m *VolumeCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCreateRequest.Unmarshal(m, b)
}
func (m *VolumeCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCreateRequest.Marshal(b, m, deterministic)
}
func (dst *VolumeCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCreateRequest.Merge(dst, src)
}
func (m *VolumeCreateRequest) XXX_Size() int {
	return xxx_messageInfo_VolumeCreateRequest.Size(m)
}
func (m *VolumeCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCreateRequest proto.InternalMessageInfo

func (m *VolumeCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeCreateRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *VolumeCreateRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// VolumeResponse is a structure that wraps an error.
type VolumeResponse struct {
	// Error message
	//
	// in: body
	// Required: true
	Error                string   `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeResponse) Reset()         { *m = VolumeResponse{} }
func (m *VolumeResponse) String() string { return proto.CompactTextString(m) }
func (*VolumeResponse) ProtoMessage()    {}
func (*VolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{32}
}
func (m *VolumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeResponse.Unmarshal(m, b)
}
func (m *VolumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeResponse.Marshal(b, m, deterministic)
}
func (dst *VolumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeResponse.Merge(dst, src)
}
func (m *VolumeResponse) XXX_Size() int {
	return xxx_messageInfo_VolumeResponse.Size(m)
}
func (m *VolumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeResponse proto.InternalMessageInfo

func (m *VolumeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// VolumeCreateResponse
type VolumeCreateResponse struct {
	// ID of the newly created volume
	//
	// in: body
	// Required: true
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Volume Response
	//
	// in: body
	// Required: true
	VolumeResponse       *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *VolumeCreateResponse) Reset()         { *m = VolumeCreateResponse{} }
func (m *VolumeCreateResponse) String() string { return proto.CompactTextString(m) }
func (*VolumeCreateResponse) ProtoMessage()    {}
func (*VolumeCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{33}
}
func (m *VolumeCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeCreateResponse.Unmarshal(m, b)
}
func (m *VolumeCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeCreateResponse.Marshal(b, m, deterministic)
}
func (dst *VolumeCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeCreateResponse.Merge(dst, src)
}
func (m *VolumeCreateResponse) XXX_Size() int {
	return xxx_messageInfo_VolumeCreateResponse.Size(m)
}
func (m *VolumeCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeCreateResponse proto.InternalMessageInfo

func (m *VolumeCreateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VolumeCreateResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

// VolumeStateAction specifies desired actions.
type VolumeStateAction struct {
	// Attach or Detach volume
	Attach VolumeActionParam `protobuf:"varint,1,opt,name=attach,enum=openstorage.api.VolumeActionParam" json:"attach,omitempty"`
	// Mount or unmount volume
	Mount VolumeActionParam `protobuf:"varint,2,opt,name=mount,enum=openstorage.api.VolumeActionParam" json:"mount,omitempty"`
	// MountPath Path where the device is mounted
	MountPath string `protobuf:"bytes,3,opt,name=mount_path,json=mountPath" json:"mount_path,omitempty"`
	// DevicePath Path returned in attach
	DevicePath           string   `protobuf:"bytes,4,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeStateAction) Reset()         { *m = VolumeStateAction{} }
func (m *VolumeStateAction) String() string { return proto.CompactTextString(m) }
func (*VolumeStateAction) ProtoMessage()    {}
func (*VolumeStateAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{34}
}
func (m *VolumeStateAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeStateAction.Unmarshal(m, b)
}
func (m *VolumeStateAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeStateAction.Marshal(b, m, deterministic)
}
func (dst *VolumeStateAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeStateAction.Merge(dst, src)
}
func (m *VolumeStateAction) XXX_Size() int {
	return xxx_messageInfo_VolumeStateAction.Size(m)
}
func (m *VolumeStateAction) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeStateAction.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeStateAction proto.InternalMessageInfo

func (m *VolumeStateAction) GetAttach() VolumeActionParam {
	if m != nil {
		return m.Attach
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMount() VolumeActionParam {
	if m != nil {
		return m.Mount
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *VolumeStateAction) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

// VolumeSet specifies a request to update a volume.
type VolumeSetRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// The storage spec for the volume
	Spec *VolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// State modification on this volume.
	Action *VolumeStateAction `protobuf:"bytes,3,opt,name=action" json:"action,omitempty"`
	// additional options
	// required for the Set operation.
	Options              map[string]string `protobuf:"bytes,4,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *VolumeSetRequest) Reset()         { *m = VolumeSetRequest{} }
func (m *VolumeSetRequest) String() string { return proto.CompactTextString(m) }
func (*VolumeSetRequest) ProtoMessage()    {}
func (*VolumeSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{35}
}
func (m *VolumeSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeSetRequest.Unmarshal(m, b)
}
func (m *VolumeSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeSetRequest.Marshal(b, m, deterministic)
}
func (dst *VolumeSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSetRequest.Merge(dst, src)
}
func (m *VolumeSetRequest) XXX_Size() int {
	return xxx_messageInfo_VolumeSetRequest.Size(m)
}
func (m *VolumeSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSetRequest proto.InternalMessageInfo

func (m *VolumeSetRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeSetRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *VolumeSetRequest) GetAction() *VolumeStateAction {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *VolumeSetRequest) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// VolumeSetResponse
type VolumeSetResponse struct {
	// Volume
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
	// VolumeResponse
	VolumeResponse       *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *VolumeSetResponse) Reset()         { *m = VolumeSetResponse{} }
func (m *VolumeSetResponse) String() string { return proto.CompactTextString(m) }
func (*VolumeSetResponse) ProtoMessage()    {}
func (*VolumeSetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{36}
}
func (m *VolumeSetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeSetResponse.Unmarshal(m, b)
}
func (m *VolumeSetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeSetResponse.Marshal(b, m, deterministic)
}
func (dst *VolumeSetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeSetResponse.Merge(dst, src)
}
func (m *VolumeSetResponse) XXX_Size() int {
	return xxx_messageInfo_VolumeSetResponse.Size(m)
}
func (m *VolumeSetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeSetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeSetResponse proto.InternalMessageInfo

func (m *VolumeSetResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *VolumeSetResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

// SnapCreateRequest specifies a request to create a snapshot of given volume.
type SnapCreateRequest struct {
	// volume id
	Id       string         `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Locator  *VolumeLocator `protobuf:"bytes,2,opt,name=locator" json:"locator,omitempty"`
	Readonly bool           `protobuf:"varint,3,opt,name=readonly" json:"readonly,omitempty"`
	// NoRetry indicates not to retry snapshot creation in the background.
	NoRetry              bool     `protobuf:"varint,4,opt,name=no_retry,json=noRetry" json:"no_retry,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapCreateRequest) Reset()         { *m = SnapCreateRequest{} }
func (m *SnapCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SnapCreateRequest) ProtoMessage()    {}
func (*SnapCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{37}
}
func (m *SnapCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapCreateRequest.Unmarshal(m, b)
}
func (m *SnapCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SnapCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapCreateRequest.Merge(dst, src)
}
func (m *SnapCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SnapCreateRequest.Size(m)
}
func (m *SnapCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SnapCreateRequest proto.InternalMessageInfo

func (m *SnapCreateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SnapCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *SnapCreateRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *SnapCreateRequest) GetNoRetry() bool {
	if m != nil {
		return m.NoRetry
	}
	return false
}

// SnapCreateRequest specifies a response that get's returned when creating a snapshot.
type SnapCreateResponse struct {
	// VolumeCreateResponse
	//
	// in: body
	// Required: true
	VolumeCreateResponse *VolumeCreateResponse `protobuf:"bytes,1,opt,name=volume_create_response,json=volumeCreateResponse" json:"volume_create_response,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SnapCreateResponse) Reset()         { *m = SnapCreateResponse{} }
func (m *SnapCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SnapCreateResponse) ProtoMessage()    {}
func (*SnapCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{38}
}
func (m *SnapCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapCreateResponse.Unmarshal(m, b)
}
func (m *SnapCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SnapCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapCreateResponse.Merge(dst, src)
}
func (m *SnapCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SnapCreateResponse.Size(m)
}
func (m *SnapCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SnapCreateResponse proto.InternalMessageInfo

func (m *SnapCreateResponse) GetVolumeCreateResponse() *VolumeCreateResponse {
	if m != nil {
		return m.VolumeCreateResponse
	}
	return nil
}

// VolumeInfo
type VolumeInfo struct {
	VolumeId             string      `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	Path                 string      `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	Storage              *VolumeSpec `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *VolumeInfo) Reset()         { *m = VolumeInfo{} }
func (m *VolumeInfo) String() string { return proto.CompactTextString(m) }
func (*VolumeInfo) ProtoMessage()    {}
func (*VolumeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{39}
}
func (m *VolumeInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeInfo.Unmarshal(m, b)
}
func (m *VolumeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeInfo.Marshal(b, m, deterministic)
}
func (dst *VolumeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeInfo.Merge(dst, src)
}
func (m *VolumeInfo) XXX_Size() int {
	return xxx_messageInfo_VolumeInfo.Size(m)
}
func (m *VolumeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeInfo proto.InternalMessageInfo

func (m *VolumeInfo) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *VolumeInfo) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *VolumeInfo) GetStorage() *VolumeSpec {
	if m != nil {
		return m.Storage
	}
	return nil
}

// VolumeConsumer identifies a consumer for a Volume. An example of a VolumeConsumer
// would be a Pod in Kubernetes who has mounted the PersistentVolumeClaim for the
// Volume
type VolumeConsumer struct {
	// Name is the name of the volume consumer
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Namespace is the namespace of the volume consumer
	Namespace string `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	// Type is the type of the consumer. E.g a Kubernetes pod
	Type string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	// NodeID is the identifier of the node on which the consumer is running. This
	// identifier would be from the perspective of the container runtime or
	// orchestrator under which the volume consumer resides. For example, NodeID
	//  can be name of a minion in Kubernetes.
	NodeId string `protobuf:"bytes,4,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// OwnerName is the name of the entity who owns this volume consumer
	OwnerName string `protobuf:"bytes,5,opt,name=owner_name,json=ownerName" json:"owner_name,omitempty"`
	// OwnerType is the type of the entity who owns this volume consumer. The type would
	// be from the perspective of the container runtime or the orchestrator under which
	// the volume consumer resides. For e.g OwnerType can be a Deployment in Kubernetes.
	OwnerType            string   `protobuf:"bytes,6,opt,name=owner_type,json=ownerType" json:"owner_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VolumeConsumer) Reset()         { *m = VolumeConsumer{} }
func (m *VolumeConsumer) String() string { return proto.CompactTextString(m) }
func (*VolumeConsumer) ProtoMessage()    {}
func (*VolumeConsumer) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{40}
}
func (m *VolumeConsumer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumeConsumer.Unmarshal(m, b)
}
func (m *VolumeConsumer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumeConsumer.Marshal(b, m, deterministic)
}
func (dst *VolumeConsumer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumeConsumer.Merge(dst, src)
}
func (m *VolumeConsumer) XXX_Size() int {
	return xxx_messageInfo_VolumeConsumer.Size(m)
}
func (m *VolumeConsumer) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumeConsumer.DiscardUnknown(m)
}

var xxx_messageInfo_VolumeConsumer proto.InternalMessageInfo

func (m *VolumeConsumer) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeConsumer) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *VolumeConsumer) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *VolumeConsumer) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *VolumeConsumer) GetOwnerName() string {
	if m != nil {
		return m.OwnerName
	}
	return ""
}

func (m *VolumeConsumer) GetOwnerType() string {
	if m != nil {
		return m.OwnerType
	}
	return ""
}

// GraphDriverChanges represent a list of changes between the filesystem layers
// specified by the ID and Parent.  // Parent may be an empty string, in which
// case there is no parent.
// Where the Path is the filesystem path within the layered filesystem
type GraphDriverChanges struct {
	Path                 string                `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Kind                 GraphDriverChangeType `protobuf:"varint,2,opt,name=kind,enum=openstorage.api.GraphDriverChangeType" json:"kind,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GraphDriverChanges) Reset()         { *m = GraphDriverChanges{} }
func (m *GraphDriverChanges) String() string { return proto.CompactTextString(m) }
func (*GraphDriverChanges) ProtoMessage()    {}
func (*GraphDriverChanges) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{41}
}
func (m *GraphDriverChanges) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GraphDriverChanges.Unmarshal(m, b)
}
func (m *GraphDriverChanges) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GraphDriverChanges.Marshal(b, m, deterministic)
}
func (dst *GraphDriverChanges) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GraphDriverChanges.Merge(dst, src)
}
func (m *GraphDriverChanges) XXX_Size() int {
	return xxx_messageInfo_GraphDriverChanges.Size(m)
}
func (m *GraphDriverChanges) XXX_DiscardUnknown() {
	xxx_messageInfo_GraphDriverChanges.DiscardUnknown(m)
}

var xxx_messageInfo_GraphDriverChanges proto.InternalMessageInfo

func (m *GraphDriverChanges) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GraphDriverChanges) GetKind() GraphDriverChangeType {
	if m != nil {
		return m.Kind
	}
	return GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE
}

// ClusterResponse specifies a response that gets returned when requesting the cluster
type ClusterResponse struct {
	// Error code
	//
	// in: body
	Error                string   `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterResponse) Reset()         { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()    {}
func (*ClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{42}
}
func (m *ClusterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterResponse.Unmarshal(m, b)
}
func (m *ClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterResponse.Merge(dst, src)
}
func (m *ClusterResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterResponse.Size(m)
}
func (m *ClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterResponse proto.InternalMessageInfo

func (m *ClusterResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Active Request
type ActiveRequest struct {
	ReqestKV             map[int64]string `protobuf:"bytes,1,rep,name=ReqestKV" json:"ReqestKV,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveRequest) Reset()         { *m = ActiveRequest{} }
func (m *ActiveRequest) String() string { return proto.CompactTextString(m) }
func (*ActiveRequest) ProtoMessage()    {}
func (*ActiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{43}
}
func (m *ActiveRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveRequest.Unmarshal(m, b)
}
func (m *ActiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveRequest.Marshal(b, m, deterministic)
}
func (dst *ActiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveRequest.Merge(dst, src)
}
func (m *ActiveRequest) XXX_Size() int {
	return xxx_messageInfo_ActiveRequest.Size(m)
}
func (m *ActiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveRequest proto.InternalMessageInfo

func (m *ActiveRequest) GetReqestKV() map[int64]string {
	if m != nil {
		return m.ReqestKV
	}
	return nil
}

// Active Requests
type ActiveRequests struct {
	RequestCount         int64            `protobuf:"varint,1,opt,name=RequestCount" json:"RequestCount,omitempty"`
	ActiveRequest        []*ActiveRequest `protobuf:"bytes,2,rep,name=ActiveRequest" json:"ActiveRequest,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ActiveRequests) Reset()         { *m = ActiveRequests{} }
func (m *ActiveRequests) String() string { return proto.CompactTextString(m) }
func (*ActiveRequests) ProtoMessage()    {}
func (*ActiveRequests) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{44}
}
func (m *ActiveRequests) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActiveRequests.Unmarshal(m, b)
}
func (m *ActiveRequests) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActiveRequests.Marshal(b, m, deterministic)
}
func (dst *ActiveRequests) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveRequests.Merge(dst, src)
}
func (m *ActiveRequests) XXX_Size() int {
	return xxx_messageInfo_ActiveRequests.Size(m)
}
func (m *ActiveRequests) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveRequests.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveRequests proto.InternalMessageInfo

func (m *ActiveRequests) GetRequestCount() int64 {
	if m != nil {
		return m.RequestCount
	}
	return 0
}

func (m *ActiveRequests) GetActiveRequest() []*ActiveRequest {
	if m != nil {
		return m.ActiveRequest
	}
	return nil
}

// GroupSnapCreateRequest specifies a request to create a snapshot of given group.
type GroupSnapCreateRequest struct {
	Id                   string            `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Labels               map[string]string `protobuf:"bytes,2,rep,name=Labels" json:"Labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	VolumeIds            []string          `protobuf:"bytes,3,rep,name=volume_ids,json=volumeIds" json:"volume_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GroupSnapCreateRequest) Reset()         { *m = GroupSnapCreateRequest{} }
func (m *GroupSnapCreateRequest) String() string { return proto.CompactTextString(m) }
func (*GroupSnapCreateRequest) ProtoMessage()    {}
func (*GroupSnapCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{45}
}
func (m *GroupSnapCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupSnapCreateRequest.Unmarshal(m, b)
}
func (m *GroupSnapCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupSnapCreateRequest.Marshal(b, m, deterministic)
}
func (dst *GroupSnapCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupSnapCreateRequest.Merge(dst, src)
}
func (m *GroupSnapCreateRequest) XXX_Size() int {
	return xxx_messageInfo_GroupSnapCreateRequest.Size(m)
}
func (m *GroupSnapCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupSnapCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupSnapCreateRequest proto.InternalMessageInfo

func (m *GroupSnapCreateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GroupSnapCreateRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *GroupSnapCreateRequest) GetVolumeIds() []string {
	if m != nil {
		return m.VolumeIds
	}
	return nil
}

// GroupSnapCreateRequest specifies a response that get's returned when creating a group snapshot.
type GroupSnapCreateResponse struct {
	// Created snapshots
	//
	// in: body
	// Required: true
	Snapshots map[string]*SnapCreateResponse `protobuf:"bytes,1,rep,name=snapshots" json:"snapshots,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Error message
	//
	// in: body
	// Required: true
	Error                string   `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupSnapCreateResponse) Reset()         { *m = GroupSnapCreateResponse{} }
func (m *GroupSnapCreateResponse) String() string { return proto.CompactTextString(m) }
func (*GroupSnapCreateResponse) ProtoMessage()    {}
func (*GroupSnapCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{46}
}
func (m *GroupSnapCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupSnapCreateResponse.Unmarshal(m, b)
}
func (m *GroupSnapCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupSnapCreateResponse.Marshal(b, m, deterministic)
}
func (dst *GroupSnapCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupSnapCreateResponse.Merge(dst, src)
}
func (m *GroupSnapCreateResponse) XXX_Size() int {
	return xxx_messageInfo_GroupSnapCreateResponse.Size(m)
}
func (m *GroupSnapCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupSnapCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GroupSnapCreateResponse proto.InternalMessageInfo

func (m *GroupSnapCreateResponse) GetSnapshots() map[string]*SnapCreateResponse {
	if m != nil {
		return m.Snapshots
	}
	return nil
}

func (m *GroupSnapCreateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// StorageNode describes the state of the node
type StorageNode struct {
	// Id of the node
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Cpu usage of the node
	Cpu float64 `protobuf:"fixed64,2,opt,name=cpu" json:"cpu,omitempty"`
	// Total memory of the node
	MemTotal uint64 `protobuf:"varint,3,opt,name=mem_total,json=memTotal" json:"mem_total,omitempty"`
	// Used memory of the node
	MemUsed uint64 `protobuf:"varint,4,opt,name=mem_used,json=memUsed" json:"mem_used,omitempty"`
	// Free memory of the node
	MemFree uint64 `protobuf:"varint,5,opt,name=mem_free,json=memFree" json:"mem_free,omitempty"`
	// Average load (percentage)
	AvgLoad int64 `protobuf:"varint,6,opt,name=avg_load,json=avgLoad" json:"avg_load,omitempty"`
	// Node status
	Status Status `protobuf:"varint,7,opt,name=status,enum=openstorage.api.Status" json:"status,omitempty"`
	// List of disks on the node
	Disks map[string]*StorageResource `protobuf:"bytes,9,rep,name=disks" json:"disks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// List of storage pools this node supports
	Pools []*StoragePool `protobuf:"bytes,10,rep,name=pools" json:"pools,omitempty"`
	// Management IP
	MgmtIp string `protobuf:"bytes,11,opt,name=mgmt_ip,json=mgmtIp" json:"mgmt_ip,omitempty"`
	// Data IP
	DataIp string `protobuf:"bytes,12,opt,name=data_ip,json=dataIp" json:"data_ip,omitempty"`
	// Hostname of the node
	Hostname string `protobuf:"bytes,15,opt,name=hostname" json:"hostname,omitempty"`
	// User defined labels for the node
	NodeLabels map[string]string `protobuf:"bytes,16,rep,name=node_labels,json=nodeLabels" json:"node_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// SchedulerNodeName is name of the node in scheduler context. It can be
	// empty if unable to get the name from the scheduler.
	SchedulerNodeName    string   `protobuf:"bytes,17,opt,name=scheduler_node_name,json=schedulerNodeName" json:"scheduler_node_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageNode) Reset()         { *m = StorageNode{} }
func (m *StorageNode) String() string { return proto.CompactTextString(m) }
func (*StorageNode) ProtoMessage()    {}
func (*StorageNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{47}
}
func (m *StorageNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageNode.Unmarshal(m, b)
}
func (m *StorageNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageNode.Marshal(b, m, deterministic)
}
func (dst *StorageNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageNode.Merge(dst, src)
}
func (m *StorageNode) XXX_Size() int {
	return xxx_messageInfo_StorageNode.Size(m)
}
func (m *StorageNode) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageNode.DiscardUnknown(m)
}

var xxx_messageInfo_StorageNode proto.InternalMessageInfo

func (m *StorageNode) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StorageNode) GetCpu() float64 {
	if m != nil {
		return m.Cpu
	}
	return 0
}

func (m *StorageNode) GetMemTotal() uint64 {
	if m != nil {
		return m.MemTotal
	}
	return 0
}

func (m *StorageNode) GetMemUsed() uint64 {
	if m != nil {
		return m.MemUsed
	}
	return 0
}

func (m *StorageNode) GetMemFree() uint64 {
	if m != nil {
		return m.MemFree
	}
	return 0
}

func (m *StorageNode) GetAvgLoad() int64 {
	if m != nil {
		return m.AvgLoad
	}
	return 0
}

func (m *StorageNode) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_STATUS_NONE
}

func (m *StorageNode) GetDisks() map[string]*StorageResource {
	if m != nil {
		return m.Disks
	}
	return nil
}

func (m *StorageNode) GetPools() []*StoragePool {
	if m != nil {
		return m.Pools
	}
	return nil
}

func (m *StorageNode) GetMgmtIp() string {
	if m != nil {
		return m.MgmtIp
	}
	return ""
}

func (m *StorageNode) GetDataIp() string {
	if m != nil {
		return m.DataIp
	}
	return ""
}

func (m *StorageNode) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *StorageNode) GetNodeLabels() map[string]string {
	if m != nil {
		return m.NodeLabels
	}
	return nil
}

func (m *StorageNode) GetSchedulerNodeName() string {
	if m != nil {
		return m.SchedulerNodeName
	}
	return ""
}

// StorageCluster represents the state and information about the cluster
type StorageCluster struct {
	// Status of the cluster
	Status Status `protobuf:"varint,1,opt,name=status,enum=openstorage.api.Status" json:"status,omitempty"`
	// Id of the cluster
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Name of the cluster
	Name                 string   `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StorageCluster) Reset()         { *m = StorageCluster{} }
func (m *StorageCluster) String() string { return proto.CompactTextString(m) }
func (*StorageCluster) ProtoMessage()    {}
func (*StorageCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{48}
}
func (m *StorageCluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageCluster.Unmarshal(m, b)
}
func (m *StorageCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageCluster.Marshal(b, m, deterministic)
}
func (dst *StorageCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageCluster.Merge(dst, src)
}
func (m *StorageCluster) XXX_Size() int {
	return xxx_messageInfo_StorageCluster.Size(m)
}
func (m *StorageCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageCluster.DiscardUnknown(m)
}

var xxx_messageInfo_StorageCluster proto.InternalMessageInfo

func (m *StorageCluster) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_STATUS_NONE
}

func (m *StorageCluster) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StorageCluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Define a request to create storage policy
type SdkOpenStoragePolicyCreateRequest struct {
	// storage policy to create
	StoragePolicy        *SdkStoragePolicy `protobuf:"bytes,1,opt,name=storage_policy,json=storagePolicy" json:"storage_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkOpenStoragePolicyCreateRequest) Reset()         { *m = SdkOpenStoragePolicyCreateRequest{} }
func (m *SdkOpenStoragePolicyCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyCreateRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{49}
}
func (m *SdkOpenStoragePolicyCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyCreateRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateRequest.Size(m)
}
func (m *SdkOpenStoragePolicyCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyCreateRequest proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyCreateRequest) GetStoragePolicy() *SdkStoragePolicy {
	if m != nil {
		return m.StoragePolicy
	}
	return nil
}

// Empty response
type SdkOpenStoragePolicyCreateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyCreateResponse) Reset()         { *m = SdkOpenStoragePolicyCreateResponse{} }
func (m *SdkOpenStoragePolicyCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyCreateResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{50}
}
func (m *SdkOpenStoragePolicyCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyCreateResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyCreateResponse.Size(m)
}
func (m *SdkOpenStoragePolicyCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyCreateResponse proto.InternalMessageInfo

// Empty request
type SdkOpenStoragePolicyEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyEnumerateRequest) Reset()         { *m = SdkOpenStoragePolicyEnumerateRequest{} }
func (m *SdkOpenStoragePolicyEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyEnumerateRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{51}
}
func (m *SdkOpenStoragePolicyEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest.Size(m)
}
func (m *SdkOpenStoragePolicyEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyEnumerateRequest proto.InternalMessageInfo

// Define a storage policy enumerate response
type SdkOpenStoragePolicyEnumerateResponse struct {
	// List of storage policies
	StoragePolicies      []*SdkStoragePolicy `protobuf:"bytes,1,rep,name=storage_policies,json=storagePolicies" json:"storage_policies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SdkOpenStoragePolicyEnumerateResponse) Reset()         { *m = SdkOpenStoragePolicyEnumerateResponse{} }
func (m *SdkOpenStoragePolicyEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyEnumerateResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{52}
}
func (m *SdkOpenStoragePolicyEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse.Size(m)
}
func (m *SdkOpenStoragePolicyEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyEnumerateResponse proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyEnumerateResponse) GetStoragePolicies() []*SdkStoragePolicy {
	if m != nil {
		return m.StoragePolicies
	}
	return nil
}

// Define a request to inspect storage policy
type SdkOpenStoragePolicyInspectRequest struct {
	// name of storage policy to retrive
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyInspectRequest) Reset()         { *m = SdkOpenStoragePolicyInspectRequest{} }
func (m *SdkOpenStoragePolicyInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyInspectRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{53}
}
func (m *SdkOpenStoragePolicyInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyInspectRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectRequest.Size(m)
}
func (m *SdkOpenStoragePolicyInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyInspectRequest proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyInspectRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Define a storage policy inspect response
type SdkOpenStoragePolicyInspectResponse struct {
	// storage policy information requested by name
	StoragePolicy        *SdkStoragePolicy `protobuf:"bytes,1,opt,name=storage_policy,json=storagePolicy" json:"storage_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkOpenStoragePolicyInspectResponse) Reset()         { *m = SdkOpenStoragePolicyInspectResponse{} }
func (m *SdkOpenStoragePolicyInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyInspectResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{54}
}
func (m *SdkOpenStoragePolicyInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyInspectResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyInspectResponse.Size(m)
}
func (m *SdkOpenStoragePolicyInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyInspectResponse proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyInspectResponse) GetStoragePolicy() *SdkStoragePolicy {
	if m != nil {
		return m.StoragePolicy
	}
	return nil
}

// Define a request to delete storage policy
type SdkOpenStoragePolicyDeleteRequest struct {
	// name of storage policy to delete
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyDeleteRequest) Reset()         { *m = SdkOpenStoragePolicyDeleteRequest{} }
func (m *SdkOpenStoragePolicyDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyDeleteRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{55}
}
func (m *SdkOpenStoragePolicyDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest.Size(m)
}
func (m *SdkOpenStoragePolicyDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyDeleteRequest proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyDeleteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Empty Response
type SdkOpenStoragePolicyDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyDeleteResponse) Reset()         { *m = SdkOpenStoragePolicyDeleteResponse{} }
func (m *SdkOpenStoragePolicyDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyDeleteResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{56}
}
func (m *SdkOpenStoragePolicyDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse.Size(m)
}
func (m *SdkOpenStoragePolicyDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyDeleteResponse proto.InternalMessageInfo

// Define a request to update storage policy
type SdkOpenStoragePolicyUpdateRequest struct {
	// storage policy to update
	StoragePolicy        *SdkStoragePolicy `protobuf:"bytes,1,opt,name=storage_policy,json=storagePolicy" json:"storage_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkOpenStoragePolicyUpdateRequest) Reset()         { *m = SdkOpenStoragePolicyUpdateRequest{} }
func (m *SdkOpenStoragePolicyUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyUpdateRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{57}
}
func (m *SdkOpenStoragePolicyUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest.Size(m)
}
func (m *SdkOpenStoragePolicyUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyUpdateRequest proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyUpdateRequest) GetStoragePolicy() *SdkStoragePolicy {
	if m != nil {
		return m.StoragePolicy
	}
	return nil
}

// Empty Response
type SdkOpenStoragePolicyUpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyUpdateResponse) Reset()         { *m = SdkOpenStoragePolicyUpdateResponse{} }
func (m *SdkOpenStoragePolicyUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyUpdateResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{58}
}
func (m *SdkOpenStoragePolicyUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse.Size(m)
}
func (m *SdkOpenStoragePolicyUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyUpdateResponse proto.InternalMessageInfo

// Define a request to set default storage policy
type SdkOpenStoragePolicySetDefaultRequest struct {
	// name of policy to set as default storage policy
	// for volume creation
	// This policy will be used to validate/update volume configuration
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicySetDefaultRequest) Reset()         { *m = SdkOpenStoragePolicySetDefaultRequest{} }
func (m *SdkOpenStoragePolicySetDefaultRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicySetDefaultRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicySetDefaultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{59}
}
func (m *SdkOpenStoragePolicySetDefaultRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicySetDefaultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicySetDefaultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicySetDefaultRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest.Size(m)
}
func (m *SdkOpenStoragePolicySetDefaultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicySetDefaultRequest proto.InternalMessageInfo

func (m *SdkOpenStoragePolicySetDefaultRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Empty Response
type SdkOpenStoragePolicySetDefaultResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicySetDefaultResponse) Reset() {
	*m = SdkOpenStoragePolicySetDefaultResponse{}
}
func (m *SdkOpenStoragePolicySetDefaultResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicySetDefaultResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicySetDefaultResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{60}
}
func (m *SdkOpenStoragePolicySetDefaultResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicySetDefaultResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicySetDefaultResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicySetDefaultResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse.Size(m)
}
func (m *SdkOpenStoragePolicySetDefaultResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicySetDefaultResponse proto.InternalMessageInfo

// Empty Request
type SdkOpenStoragePolicyReleaseRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyReleaseRequest) Reset()         { *m = SdkOpenStoragePolicyReleaseRequest{} }
func (m *SdkOpenStoragePolicyReleaseRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyReleaseRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyReleaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{61}
}
func (m *SdkOpenStoragePolicyReleaseRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyReleaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyReleaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyReleaseRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest.Size(m)
}
func (m *SdkOpenStoragePolicyReleaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyReleaseRequest proto.InternalMessageInfo

// Empty Response
type SdkOpenStoragePolicyReleaseResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyReleaseResponse) Reset()         { *m = SdkOpenStoragePolicyReleaseResponse{} }
func (m *SdkOpenStoragePolicyReleaseResponse) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyReleaseResponse) ProtoMessage()    {}
func (*SdkOpenStoragePolicyReleaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{62}
}
func (m *SdkOpenStoragePolicyReleaseResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyReleaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyReleaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyReleaseResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse.Size(m)
}
func (m *SdkOpenStoragePolicyReleaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyReleaseResponse proto.InternalMessageInfo

// Empty Request
type SdkOpenStoragePolicyDefaultInspectRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkOpenStoragePolicyDefaultInspectRequest) Reset() {
	*m = SdkOpenStoragePolicyDefaultInspectRequest{}
}
func (m *SdkOpenStoragePolicyDefaultInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkOpenStoragePolicyDefaultInspectRequest) ProtoMessage()    {}
func (*SdkOpenStoragePolicyDefaultInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{63}
}
func (m *SdkOpenStoragePolicyDefaultInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyDefaultInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyDefaultInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyDefaultInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest.Size(m)
}
func (m *SdkOpenStoragePolicyDefaultInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectRequest proto.InternalMessageInfo

// Define default storage policy response
type SdkOpenStoragePolicyDefaultInspectResponse struct {
	// storage policy information which is set as default
	StoragePolicy        *SdkStoragePolicy `protobuf:"bytes,1,opt,name=storage_policy,json=storagePolicy" json:"storage_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkOpenStoragePolicyDefaultInspectResponse) Reset() {
	*m = SdkOpenStoragePolicyDefaultInspectResponse{}
}
func (m *SdkOpenStoragePolicyDefaultInspectResponse) String() string {
	return proto.CompactTextString(m)
}
func (*SdkOpenStoragePolicyDefaultInspectResponse) ProtoMessage() {}
func (*SdkOpenStoragePolicyDefaultInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{64}
}
func (m *SdkOpenStoragePolicyDefaultInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse.Unmarshal(m, b)
}
func (m *SdkOpenStoragePolicyDefaultInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkOpenStoragePolicyDefaultInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse.Merge(dst, src)
}
func (m *SdkOpenStoragePolicyDefaultInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse.Size(m)
}
func (m *SdkOpenStoragePolicyDefaultInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkOpenStoragePolicyDefaultInspectResponse proto.InternalMessageInfo

func (m *SdkOpenStoragePolicyDefaultInspectResponse) GetStoragePolicy() *SdkStoragePolicy {
	if m != nil {
		return m.StoragePolicy
	}
	return nil
}

// Define a schedule policy request
type SdkSchedulePolicyCreateRequest struct {
	// Schedule Policy
	SchedulePolicy       *SdkSchedulePolicy `protobuf:"bytes,1,opt,name=schedule_policy,json=schedulePolicy" json:"schedule_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdkSchedulePolicyCreateRequest) Reset()         { *m = SdkSchedulePolicyCreateRequest{} }
func (m *SdkSchedulePolicyCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyCreateRequest) ProtoMessage()    {}
func (*SdkSchedulePolicyCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{65}
}
func (m *SdkSchedulePolicyCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyCreateRequest.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyCreateRequest.Merge(dst, src)
}
func (m *SdkSchedulePolicyCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyCreateRequest.Size(m)
}
func (m *SdkSchedulePolicyCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyCreateRequest proto.InternalMessageInfo

func (m *SdkSchedulePolicyCreateRequest) GetSchedulePolicy() *SdkSchedulePolicy {
	if m != nil {
		return m.SchedulePolicy
	}
	return nil
}

// Empty response
type SdkSchedulePolicyCreateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyCreateResponse) Reset()         { *m = SdkSchedulePolicyCreateResponse{} }
func (m *SdkSchedulePolicyCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyCreateResponse) ProtoMessage()    {}
func (*SdkSchedulePolicyCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{66}
}
func (m *SdkSchedulePolicyCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyCreateResponse.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyCreateResponse.Merge(dst, src)
}
func (m *SdkSchedulePolicyCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyCreateResponse.Size(m)
}
func (m *SdkSchedulePolicyCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyCreateResponse proto.InternalMessageInfo

// Define a request to update a schedule policy
type SdkSchedulePolicyUpdateRequest struct {
	// Schedule Policy
	SchedulePolicy       *SdkSchedulePolicy `protobuf:"bytes,1,opt,name=schedule_policy,json=schedulePolicy" json:"schedule_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdkSchedulePolicyUpdateRequest) Reset()         { *m = SdkSchedulePolicyUpdateRequest{} }
func (m *SdkSchedulePolicyUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyUpdateRequest) ProtoMessage()    {}
func (*SdkSchedulePolicyUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{67}
}
func (m *SdkSchedulePolicyUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyUpdateRequest.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyUpdateRequest.Merge(dst, src)
}
func (m *SdkSchedulePolicyUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyUpdateRequest.Size(m)
}
func (m *SdkSchedulePolicyUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyUpdateRequest proto.InternalMessageInfo

func (m *SdkSchedulePolicyUpdateRequest) GetSchedulePolicy() *SdkSchedulePolicy {
	if m != nil {
		return m.SchedulePolicy
	}
	return nil
}

// Empty response
type SdkSchedulePolicyUpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyUpdateResponse) Reset()         { *m = SdkSchedulePolicyUpdateResponse{} }
func (m *SdkSchedulePolicyUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyUpdateResponse) ProtoMessage()    {}
func (*SdkSchedulePolicyUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{68}
}
func (m *SdkSchedulePolicyUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyUpdateResponse.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyUpdateResponse.Merge(dst, src)
}
func (m *SdkSchedulePolicyUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyUpdateResponse.Size(m)
}
func (m *SdkSchedulePolicyUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyUpdateResponse proto.InternalMessageInfo

// Empty request
type SdkSchedulePolicyEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyEnumerateRequest) Reset()         { *m = SdkSchedulePolicyEnumerateRequest{} }
func (m *SdkSchedulePolicyEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyEnumerateRequest) ProtoMessage()    {}
func (*SdkSchedulePolicyEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{69}
}
func (m *SdkSchedulePolicyEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyEnumerateRequest.Merge(dst, src)
}
func (m *SdkSchedulePolicyEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateRequest.Size(m)
}
func (m *SdkSchedulePolicyEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyEnumerateRequest proto.InternalMessageInfo

// Defines a schedule policy enumerate response
type SdkSchedulePolicyEnumerateResponse struct {
	// List of Schedule Policy
	Policies             []*SdkSchedulePolicy `protobuf:"bytes,1,rep,name=policies" json:"policies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SdkSchedulePolicyEnumerateResponse) Reset()         { *m = SdkSchedulePolicyEnumerateResponse{} }
func (m *SdkSchedulePolicyEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyEnumerateResponse) ProtoMessage()    {}
func (*SdkSchedulePolicyEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{70}
}
func (m *SdkSchedulePolicyEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyEnumerateResponse.Merge(dst, src)
}
func (m *SdkSchedulePolicyEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyEnumerateResponse.Size(m)
}
func (m *SdkSchedulePolicyEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyEnumerateResponse proto.InternalMessageInfo

func (m *SdkSchedulePolicyEnumerateResponse) GetPolicies() []*SdkSchedulePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

// Define a schedule policy inspection request
type SdkSchedulePolicyInspectRequest struct {
	// Name of the schedule Policy
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyInspectRequest) Reset()         { *m = SdkSchedulePolicyInspectRequest{} }
func (m *SdkSchedulePolicyInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyInspectRequest) ProtoMessage()    {}
func (*SdkSchedulePolicyInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{71}
}
func (m *SdkSchedulePolicyInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyInspectRequest.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyInspectRequest.Merge(dst, src)
}
func (m *SdkSchedulePolicyInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyInspectRequest.Size(m)
}
func (m *SdkSchedulePolicyInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyInspectRequest proto.InternalMessageInfo

func (m *SdkSchedulePolicyInspectRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Defines a schedule policy inspection response
type SdkSchedulePolicyInspectResponse struct {
	// List of Schedule Policy
	Policy               *SdkSchedulePolicy `protobuf:"bytes,1,opt,name=policy" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdkSchedulePolicyInspectResponse) Reset()         { *m = SdkSchedulePolicyInspectResponse{} }
func (m *SdkSchedulePolicyInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyInspectResponse) ProtoMessage()    {}
func (*SdkSchedulePolicyInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{72}
}
func (m *SdkSchedulePolicyInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyInspectResponse.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyInspectResponse.Merge(dst, src)
}
func (m *SdkSchedulePolicyInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyInspectResponse.Size(m)
}
func (m *SdkSchedulePolicyInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyInspectResponse proto.InternalMessageInfo

func (m *SdkSchedulePolicyInspectResponse) GetPolicy() *SdkSchedulePolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// Define schedule policy deletion request
type SdkSchedulePolicyDeleteRequest struct {
	// Name of the schedule policy
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyDeleteRequest) Reset()         { *m = SdkSchedulePolicyDeleteRequest{} }
func (m *SdkSchedulePolicyDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyDeleteRequest) ProtoMessage()    {}
func (*SdkSchedulePolicyDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{73}
}
func (m *SdkSchedulePolicyDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyDeleteRequest.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyDeleteRequest.Merge(dst, src)
}
func (m *SdkSchedulePolicyDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyDeleteRequest.Size(m)
}
func (m *SdkSchedulePolicyDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyDeleteRequest proto.InternalMessageInfo

func (m *SdkSchedulePolicyDeleteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Empty response
type SdkSchedulePolicyDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyDeleteResponse) Reset()         { *m = SdkSchedulePolicyDeleteResponse{} }
func (m *SdkSchedulePolicyDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyDeleteResponse) ProtoMessage()    {}
func (*SdkSchedulePolicyDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{74}
}
func (m *SdkSchedulePolicyDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyDeleteResponse.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyDeleteResponse.Merge(dst, src)
}
func (m *SdkSchedulePolicyDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyDeleteResponse.Size(m)
}
func (m *SdkSchedulePolicyDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyDeleteResponse proto.InternalMessageInfo

// Defines a daily schedule
type SdkSchedulePolicyIntervalDaily struct {
	// Range: 0-23
	Hour int32 `protobuf:"varint,1,opt,name=hour" json:"hour,omitempty"`
	// Range: 0-59
	Minute               int32    `protobuf:"varint,2,opt,name=minute" json:"minute,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyIntervalDaily) Reset()         { *m = SdkSchedulePolicyIntervalDaily{} }
func (m *SdkSchedulePolicyIntervalDaily) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyIntervalDaily) ProtoMessage()    {}
func (*SdkSchedulePolicyIntervalDaily) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{75}
}
func (m *SdkSchedulePolicyIntervalDaily) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyIntervalDaily.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyIntervalDaily) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyIntervalDaily.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyIntervalDaily) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyIntervalDaily.Merge(dst, src)
}
func (m *SdkSchedulePolicyIntervalDaily) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyIntervalDaily.Size(m)
}
func (m *SdkSchedulePolicyIntervalDaily) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyIntervalDaily.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyIntervalDaily proto.InternalMessageInfo

func (m *SdkSchedulePolicyIntervalDaily) GetHour() int32 {
	if m != nil {
		return m.Hour
	}
	return 0
}

func (m *SdkSchedulePolicyIntervalDaily) GetMinute() int32 {
	if m != nil {
		return m.Minute
	}
	return 0
}

// Defines a weekly schedule
type SdkSchedulePolicyIntervalWeekly struct {
	Day SdkTimeWeekday `protobuf:"varint,1,opt,name=day,enum=openstorage.api.SdkTimeWeekday" json:"day,omitempty"`
	// Range: 0-23
	Hour int32 `protobuf:"varint,2,opt,name=hour" json:"hour,omitempty"`
	// Range: 0-59
	Minute               int32    `protobuf:"varint,3,opt,name=minute" json:"minute,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyIntervalWeekly) Reset()         { *m = SdkSchedulePolicyIntervalWeekly{} }
func (m *SdkSchedulePolicyIntervalWeekly) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyIntervalWeekly) ProtoMessage()    {}
func (*SdkSchedulePolicyIntervalWeekly) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{76}
}
func (m *SdkSchedulePolicyIntervalWeekly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyIntervalWeekly.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyIntervalWeekly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyIntervalWeekly.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyIntervalWeekly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyIntervalWeekly.Merge(dst, src)
}
func (m *SdkSchedulePolicyIntervalWeekly) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyIntervalWeekly.Size(m)
}
func (m *SdkSchedulePolicyIntervalWeekly) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyIntervalWeekly.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyIntervalWeekly proto.InternalMessageInfo

func (m *SdkSchedulePolicyIntervalWeekly) GetDay() SdkTimeWeekday {
	if m != nil {
		return m.Day
	}
	return SdkTimeWeekday_SdkTimeWeekdaySunday
}

func (m *SdkSchedulePolicyIntervalWeekly) GetHour() int32 {
	if m != nil {
		return m.Hour
	}
	return 0
}

func (m *SdkSchedulePolicyIntervalWeekly) GetMinute() int32 {
	if m != nil {
		return m.Minute
	}
	return 0
}

// Defines a monthly schedule
type SdkSchedulePolicyIntervalMonthly struct {
	// Range: 1-28
	Day int32 `protobuf:"varint,1,opt,name=day" json:"day,omitempty"`
	// Range: 0-59
	Hour int32 `protobuf:"varint,2,opt,name=hour" json:"hour,omitempty"`
	// Range: 0-59
	Minute               int32    `protobuf:"varint,3,opt,name=minute" json:"minute,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyIntervalMonthly) Reset()         { *m = SdkSchedulePolicyIntervalMonthly{} }
func (m *SdkSchedulePolicyIntervalMonthly) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyIntervalMonthly) ProtoMessage()    {}
func (*SdkSchedulePolicyIntervalMonthly) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{77}
}
func (m *SdkSchedulePolicyIntervalMonthly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyIntervalMonthly.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyIntervalMonthly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyIntervalMonthly.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyIntervalMonthly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyIntervalMonthly.Merge(dst, src)
}
func (m *SdkSchedulePolicyIntervalMonthly) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyIntervalMonthly.Size(m)
}
func (m *SdkSchedulePolicyIntervalMonthly) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyIntervalMonthly.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyIntervalMonthly proto.InternalMessageInfo

func (m *SdkSchedulePolicyIntervalMonthly) GetDay() int32 {
	if m != nil {
		return m.Day
	}
	return 0
}

func (m *SdkSchedulePolicyIntervalMonthly) GetHour() int32 {
	if m != nil {
		return m.Hour
	}
	return 0
}

func (m *SdkSchedulePolicyIntervalMonthly) GetMinute() int32 {
	if m != nil {
		return m.Minute
	}
	return 0
}

// Defines a periodic schedule
type SdkSchedulePolicyIntervalPeriodic struct {
	// Specify the number of seconds between intervals
	Seconds              int64    `protobuf:"varint,1,opt,name=seconds" json:"seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkSchedulePolicyIntervalPeriodic) Reset()         { *m = SdkSchedulePolicyIntervalPeriodic{} }
func (m *SdkSchedulePolicyIntervalPeriodic) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyIntervalPeriodic) ProtoMessage()    {}
func (*SdkSchedulePolicyIntervalPeriodic) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{78}
}
func (m *SdkSchedulePolicyIntervalPeriodic) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyIntervalPeriodic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyIntervalPeriodic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic.Merge(dst, src)
}
func (m *SdkSchedulePolicyIntervalPeriodic) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic.Size(m)
}
func (m *SdkSchedulePolicyIntervalPeriodic) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyIntervalPeriodic proto.InternalMessageInfo

func (m *SdkSchedulePolicyIntervalPeriodic) GetSeconds() int64 {
	if m != nil {
		return m.Seconds
	}
	return 0
}

// Defines a schedule policy interval
type SdkSchedulePolicyInterval struct {
	// Number of instances to retain
	Retain int64 `protobuf:"varint,1,opt,name=retain" json:"retain,omitempty"`
	// Start oneof at field number 200 to allow for expansion
	//
	// Types that are valid to be assigned to PeriodType:
	//	*SdkSchedulePolicyInterval_Daily
	//	*SdkSchedulePolicyInterval_Weekly
	//	*SdkSchedulePolicyInterval_Monthly
	//	*SdkSchedulePolicyInterval_Periodic
	PeriodType           isSdkSchedulePolicyInterval_PeriodType `protobuf_oneof:"period_type"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *SdkSchedulePolicyInterval) Reset()         { *m = SdkSchedulePolicyInterval{} }
func (m *SdkSchedulePolicyInterval) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicyInterval) ProtoMessage()    {}
func (*SdkSchedulePolicyInterval) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{79}
}
func (m *SdkSchedulePolicyInterval) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicyInterval.Unmarshal(m, b)
}
func (m *SdkSchedulePolicyInterval) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicyInterval.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicyInterval) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicyInterval.Merge(dst, src)
}
func (m *SdkSchedulePolicyInterval) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicyInterval.Size(m)
}
func (m *SdkSchedulePolicyInterval) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicyInterval.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicyInterval proto.InternalMessageInfo

type isSdkSchedulePolicyInterval_PeriodType interface {
	isSdkSchedulePolicyInterval_PeriodType()
}

type SdkSchedulePolicyInterval_Daily struct {
	Daily *SdkSchedulePolicyIntervalDaily `protobuf:"bytes,200,opt,name=daily,oneof"`
}
type SdkSchedulePolicyInterval_Weekly struct {
	Weekly *SdkSchedulePolicyIntervalWeekly `protobuf:"bytes,201,opt,name=weekly,oneof"`
}
type SdkSchedulePolicyInterval_Monthly struct {
	Monthly *SdkSchedulePolicyIntervalMonthly `protobuf:"bytes,202,opt,name=monthly,oneof"`
}
type SdkSchedulePolicyInterval_Periodic struct {
	Periodic *SdkSchedulePolicyIntervalPeriodic `protobuf:"bytes,203,opt,name=periodic,oneof"`
}

func (*SdkSchedulePolicyInterval_Daily) isSdkSchedulePolicyInterval_PeriodType()    {}
func (*SdkSchedulePolicyInterval_Weekly) isSdkSchedulePolicyInterval_PeriodType()   {}
func (*SdkSchedulePolicyInterval_Monthly) isSdkSchedulePolicyInterval_PeriodType()  {}
func (*SdkSchedulePolicyInterval_Periodic) isSdkSchedulePolicyInterval_PeriodType() {}

func (m *SdkSchedulePolicyInterval) GetPeriodType() isSdkSchedulePolicyInterval_PeriodType {
	if m != nil {
		return m.PeriodType
	}
	return nil
}

func (m *SdkSchedulePolicyInterval) GetRetain() int64 {
	if m != nil {
		return m.Retain
	}
	return 0
}

func (m *SdkSchedulePolicyInterval) GetDaily() *SdkSchedulePolicyIntervalDaily {
	if x, ok := m.GetPeriodType().(*SdkSchedulePolicyInterval_Daily); ok {
		return x.Daily
	}
	return nil
}

func (m *SdkSchedulePolicyInterval) GetWeekly() *SdkSchedulePolicyIntervalWeekly {
	if x, ok := m.GetPeriodType().(*SdkSchedulePolicyInterval_Weekly); ok {
		return x.Weekly
	}
	return nil
}

func (m *SdkSchedulePolicyInterval) GetMonthly() *SdkSchedulePolicyIntervalMonthly {
	if x, ok := m.GetPeriodType().(*SdkSchedulePolicyInterval_Monthly); ok {
		return x.Monthly
	}
	return nil
}

func (m *SdkSchedulePolicyInterval) GetPeriodic() *SdkSchedulePolicyIntervalPeriodic {
	if x, ok := m.GetPeriodType().(*SdkSchedulePolicyInterval_Periodic); ok {
		return x.Periodic
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkSchedulePolicyInterval) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkSchedulePolicyInterval_OneofMarshaler, _SdkSchedulePolicyInterval_OneofUnmarshaler, _SdkSchedulePolicyInterval_OneofSizer, []interface{}{
		(*SdkSchedulePolicyInterval_Daily)(nil),
		(*SdkSchedulePolicyInterval_Weekly)(nil),
		(*SdkSchedulePolicyInterval_Monthly)(nil),
		(*SdkSchedulePolicyInterval_Periodic)(nil),
	}
}

func _SdkSchedulePolicyInterval_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkSchedulePolicyInterval)
	// period_type
	switch x := m.PeriodType.(type) {
	case *SdkSchedulePolicyInterval_Daily:
		b.EncodeVarint(200<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Daily); err != nil {
			return err
		}
	case *SdkSchedulePolicyInterval_Weekly:
		b.EncodeVarint(201<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Weekly); err != nil {
			return err
		}
	case *SdkSchedulePolicyInterval_Monthly:
		b.EncodeVarint(202<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Monthly); err != nil {
			return err
		}
	case *SdkSchedulePolicyInterval_Periodic:
		b.EncodeVarint(203<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Periodic); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkSchedulePolicyInterval.PeriodType has unexpected type %T", x)
	}
	return nil
}

func _SdkSchedulePolicyInterval_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkSchedulePolicyInterval)
	switch tag {
	case 200: // period_type.daily
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkSchedulePolicyIntervalDaily)
		err := b.DecodeMessage(msg)
		m.PeriodType = &SdkSchedulePolicyInterval_Daily{msg}
		return true, err
	case 201: // period_type.weekly
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkSchedulePolicyIntervalWeekly)
		err := b.DecodeMessage(msg)
		m.PeriodType = &SdkSchedulePolicyInterval_Weekly{msg}
		return true, err
	case 202: // period_type.monthly
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkSchedulePolicyIntervalMonthly)
		err := b.DecodeMessage(msg)
		m.PeriodType = &SdkSchedulePolicyInterval_Monthly{msg}
		return true, err
	case 203: // period_type.periodic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkSchedulePolicyIntervalPeriodic)
		err := b.DecodeMessage(msg)
		m.PeriodType = &SdkSchedulePolicyInterval_Periodic{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkSchedulePolicyInterval_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkSchedulePolicyInterval)
	// period_type
	switch x := m.PeriodType.(type) {
	case *SdkSchedulePolicyInterval_Daily:
		s := proto.Size(x.Daily)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkSchedulePolicyInterval_Weekly:
		s := proto.Size(x.Weekly)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkSchedulePolicyInterval_Monthly:
		s := proto.Size(x.Monthly)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkSchedulePolicyInterval_Periodic:
		s := proto.Size(x.Periodic)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines a schedule policy
type SdkSchedulePolicy struct {
	// Name of the schedule policy
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Schedule policies
	Schedules            []*SdkSchedulePolicyInterval `protobuf:"bytes,2,rep,name=schedules" json:"schedules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SdkSchedulePolicy) Reset()         { *m = SdkSchedulePolicy{} }
func (m *SdkSchedulePolicy) String() string { return proto.CompactTextString(m) }
func (*SdkSchedulePolicy) ProtoMessage()    {}
func (*SdkSchedulePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{80}
}
func (m *SdkSchedulePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkSchedulePolicy.Unmarshal(m, b)
}
func (m *SdkSchedulePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkSchedulePolicy.Marshal(b, m, deterministic)
}
func (dst *SdkSchedulePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkSchedulePolicy.Merge(dst, src)
}
func (m *SdkSchedulePolicy) XXX_Size() int {
	return xxx_messageInfo_SdkSchedulePolicy.Size(m)
}
func (m *SdkSchedulePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkSchedulePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_SdkSchedulePolicy proto.InternalMessageInfo

func (m *SdkSchedulePolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkSchedulePolicy) GetSchedules() []*SdkSchedulePolicyInterval {
	if m != nil {
		return m.Schedules
	}
	return nil
}

// Defines a request to create credentials
type SdkCredentialCreateRequest struct {
	// Name of the credential
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// (optional) Name of bucket
	Bucket string `protobuf:"bytes,2,opt,name=bucket" json:"bucket,omitempty"`
	// (optional) Key used to encrypt the data
	EncryptionKey string `protobuf:"bytes,3,opt,name=encryption_key,json=encryptionKey" json:"encryption_key,omitempty"`
	// Ownership of the credential. Collaborators and groups may be
	// added here with their appropriate ACLS.
	Ownership *Ownership `protobuf:"bytes,4,opt,name=ownership" json:"ownership,omitempty"`
	// Start at field number 200 to allow for expansion
	//
	// Types that are valid to be assigned to CredentialType:
	//	*SdkCredentialCreateRequest_AwsCredential
	//	*SdkCredentialCreateRequest_AzureCredential
	//	*SdkCredentialCreateRequest_GoogleCredential
	CredentialType       isSdkCredentialCreateRequest_CredentialType `protobuf_oneof:"credential_type"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *SdkCredentialCreateRequest) Reset()         { *m = SdkCredentialCreateRequest{} }
func (m *SdkCredentialCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialCreateRequest) ProtoMessage()    {}
func (*SdkCredentialCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{81}
}
func (m *SdkCredentialCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialCreateRequest.Unmarshal(m, b)
}
func (m *SdkCredentialCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialCreateRequest.Merge(dst, src)
}
func (m *SdkCredentialCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialCreateRequest.Size(m)
}
func (m *SdkCredentialCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialCreateRequest proto.InternalMessageInfo

type isSdkCredentialCreateRequest_CredentialType interface {
	isSdkCredentialCreateRequest_CredentialType()
}

type SdkCredentialCreateRequest_AwsCredential struct {
	AwsCredential *SdkAwsCredentialRequest `protobuf:"bytes,200,opt,name=aws_credential,json=awsCredential,oneof"`
}
type SdkCredentialCreateRequest_AzureCredential struct {
	AzureCredential *SdkAzureCredentialRequest `protobuf:"bytes,201,opt,name=azure_credential,json=azureCredential,oneof"`
}
type SdkCredentialCreateRequest_GoogleCredential struct {
	GoogleCredential *SdkGoogleCredentialRequest `protobuf:"bytes,202,opt,name=google_credential,json=googleCredential,oneof"`
}

func (*SdkCredentialCreateRequest_AwsCredential) isSdkCredentialCreateRequest_CredentialType()    {}
func (*SdkCredentialCreateRequest_AzureCredential) isSdkCredentialCreateRequest_CredentialType()  {}
func (*SdkCredentialCreateRequest_GoogleCredential) isSdkCredentialCreateRequest_CredentialType() {}

func (m *SdkCredentialCreateRequest) GetCredentialType() isSdkCredentialCreateRequest_CredentialType {
	if m != nil {
		return m.CredentialType
	}
	return nil
}

func (m *SdkCredentialCreateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkCredentialCreateRequest) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *SdkCredentialCreateRequest) GetEncryptionKey() string {
	if m != nil {
		return m.EncryptionKey
	}
	return ""
}

func (m *SdkCredentialCreateRequest) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *SdkCredentialCreateRequest) GetAwsCredential() *SdkAwsCredentialRequest {
	if x, ok := m.GetCredentialType().(*SdkCredentialCreateRequest_AwsCredential); ok {
		return x.AwsCredential
	}
	return nil
}

func (m *SdkCredentialCreateRequest) GetAzureCredential() *SdkAzureCredentialRequest {
	if x, ok := m.GetCredentialType().(*SdkCredentialCreateRequest_AzureCredential); ok {
		return x.AzureCredential
	}
	return nil
}

func (m *SdkCredentialCreateRequest) GetGoogleCredential() *SdkGoogleCredentialRequest {
	if x, ok := m.GetCredentialType().(*SdkCredentialCreateRequest_GoogleCredential); ok {
		return x.GoogleCredential
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkCredentialCreateRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkCredentialCreateRequest_OneofMarshaler, _SdkCredentialCreateRequest_OneofUnmarshaler, _SdkCredentialCreateRequest_OneofSizer, []interface{}{
		(*SdkCredentialCreateRequest_AwsCredential)(nil),
		(*SdkCredentialCreateRequest_AzureCredential)(nil),
		(*SdkCredentialCreateRequest_GoogleCredential)(nil),
	}
}

func _SdkCredentialCreateRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkCredentialCreateRequest)
	// credential_type
	switch x := m.CredentialType.(type) {
	case *SdkCredentialCreateRequest_AwsCredential:
		b.EncodeVarint(200<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AwsCredential); err != nil {
			return err
		}
	case *SdkCredentialCreateRequest_AzureCredential:
		b.EncodeVarint(201<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AzureCredential); err != nil {
			return err
		}
	case *SdkCredentialCreateRequest_GoogleCredential:
		b.EncodeVarint(202<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GoogleCredential); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkCredentialCreateRequest.CredentialType has unexpected type %T", x)
	}
	return nil
}

func _SdkCredentialCreateRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkCredentialCreateRequest)
	switch tag {
	case 200: // credential_type.aws_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAwsCredentialRequest)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialCreateRequest_AwsCredential{msg}
		return true, err
	case 201: // credential_type.azure_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAzureCredentialRequest)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialCreateRequest_AzureCredential{msg}
		return true, err
	case 202: // credential_type.google_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkGoogleCredentialRequest)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialCreateRequest_GoogleCredential{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkCredentialCreateRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkCredentialCreateRequest)
	// credential_type
	switch x := m.CredentialType.(type) {
	case *SdkCredentialCreateRequest_AwsCredential:
		s := proto.Size(x.AwsCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCredentialCreateRequest_AzureCredential:
		s := proto.Size(x.AzureCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCredentialCreateRequest_GoogleCredential:
		s := proto.Size(x.GoogleCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines a response from creating a credential
type SdkCredentialCreateResponse struct {
	// Id of the credentials
	CredentialId         string   `protobuf:"bytes,1,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialCreateResponse) Reset()         { *m = SdkCredentialCreateResponse{} }
func (m *SdkCredentialCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialCreateResponse) ProtoMessage()    {}
func (*SdkCredentialCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{82}
}
func (m *SdkCredentialCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialCreateResponse.Unmarshal(m, b)
}
func (m *SdkCredentialCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialCreateResponse.Merge(dst, src)
}
func (m *SdkCredentialCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialCreateResponse.Size(m)
}
func (m *SdkCredentialCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialCreateResponse proto.InternalMessageInfo

func (m *SdkCredentialCreateResponse) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Defines credentials for Aws/S3 endpoints
type SdkAwsCredentialRequest struct {
	// Access key
	AccessKey string `protobuf:"bytes,1,opt,name=access_key,json=accessKey" json:"access_key,omitempty"`
	// Secret key
	SecretKey string `protobuf:"bytes,2,opt,name=secret_key,json=secretKey" json:"secret_key,omitempty"`
	// Endpoint
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint" json:"endpoint,omitempty"`
	// Region
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// (optional) Disable SSL connection
	DisableSsl           bool     `protobuf:"varint,5,opt,name=disable_ssl,json=disableSsl" json:"disable_ssl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAwsCredentialRequest) Reset()         { *m = SdkAwsCredentialRequest{} }
func (m *SdkAwsCredentialRequest) String() string { return proto.CompactTextString(m) }
func (*SdkAwsCredentialRequest) ProtoMessage()    {}
func (*SdkAwsCredentialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{83}
}
func (m *SdkAwsCredentialRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAwsCredentialRequest.Unmarshal(m, b)
}
func (m *SdkAwsCredentialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAwsCredentialRequest.Marshal(b, m, deterministic)
}
func (dst *SdkAwsCredentialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAwsCredentialRequest.Merge(dst, src)
}
func (m *SdkAwsCredentialRequest) XXX_Size() int {
	return xxx_messageInfo_SdkAwsCredentialRequest.Size(m)
}
func (m *SdkAwsCredentialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAwsCredentialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAwsCredentialRequest proto.InternalMessageInfo

func (m *SdkAwsCredentialRequest) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *SdkAwsCredentialRequest) GetSecretKey() string {
	if m != nil {
		return m.SecretKey
	}
	return ""
}

func (m *SdkAwsCredentialRequest) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *SdkAwsCredentialRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *SdkAwsCredentialRequest) GetDisableSsl() bool {
	if m != nil {
		return m.DisableSsl
	}
	return false
}

// Defines credentials for Azure
type SdkAzureCredentialRequest struct {
	// Account name
	AccountName string `protobuf:"bytes,1,opt,name=account_name,json=accountName" json:"account_name,omitempty"`
	// Account key
	AccountKey           string   `protobuf:"bytes,2,opt,name=account_key,json=accountKey" json:"account_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAzureCredentialRequest) Reset()         { *m = SdkAzureCredentialRequest{} }
func (m *SdkAzureCredentialRequest) String() string { return proto.CompactTextString(m) }
func (*SdkAzureCredentialRequest) ProtoMessage()    {}
func (*SdkAzureCredentialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{84}
}
func (m *SdkAzureCredentialRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAzureCredentialRequest.Unmarshal(m, b)
}
func (m *SdkAzureCredentialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAzureCredentialRequest.Marshal(b, m, deterministic)
}
func (dst *SdkAzureCredentialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAzureCredentialRequest.Merge(dst, src)
}
func (m *SdkAzureCredentialRequest) XXX_Size() int {
	return xxx_messageInfo_SdkAzureCredentialRequest.Size(m)
}
func (m *SdkAzureCredentialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAzureCredentialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAzureCredentialRequest proto.InternalMessageInfo

func (m *SdkAzureCredentialRequest) GetAccountName() string {
	if m != nil {
		return m.AccountName
	}
	return ""
}

func (m *SdkAzureCredentialRequest) GetAccountKey() string {
	if m != nil {
		return m.AccountKey
	}
	return ""
}

// Defines credentials for Google
type SdkGoogleCredentialRequest struct {
	// Project ID
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// JSON Key
	JsonKey              string   `protobuf:"bytes,2,opt,name=json_key,json=jsonKey" json:"json_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkGoogleCredentialRequest) Reset()         { *m = SdkGoogleCredentialRequest{} }
func (m *SdkGoogleCredentialRequest) String() string { return proto.CompactTextString(m) }
func (*SdkGoogleCredentialRequest) ProtoMessage()    {}
func (*SdkGoogleCredentialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{85}
}
func (m *SdkGoogleCredentialRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkGoogleCredentialRequest.Unmarshal(m, b)
}
func (m *SdkGoogleCredentialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkGoogleCredentialRequest.Marshal(b, m, deterministic)
}
func (dst *SdkGoogleCredentialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkGoogleCredentialRequest.Merge(dst, src)
}
func (m *SdkGoogleCredentialRequest) XXX_Size() int {
	return xxx_messageInfo_SdkGoogleCredentialRequest.Size(m)
}
func (m *SdkGoogleCredentialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkGoogleCredentialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkGoogleCredentialRequest proto.InternalMessageInfo

func (m *SdkGoogleCredentialRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SdkGoogleCredentialRequest) GetJsonKey() string {
	if m != nil {
		return m.JsonKey
	}
	return ""
}

// Defines the response for AWS/S3 credentials
type SdkAwsCredentialResponse struct {
	// Access key
	AccessKey string `protobuf:"bytes,2,opt,name=access_key,json=accessKey" json:"access_key,omitempty"`
	// Endpoint
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint" json:"endpoint,omitempty"`
	// Region
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// (optional) Disable SSL connection
	DisableSsl           bool     `protobuf:"varint,5,opt,name=disable_ssl,json=disableSsl" json:"disable_ssl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAwsCredentialResponse) Reset()         { *m = SdkAwsCredentialResponse{} }
func (m *SdkAwsCredentialResponse) String() string { return proto.CompactTextString(m) }
func (*SdkAwsCredentialResponse) ProtoMessage()    {}
func (*SdkAwsCredentialResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{86}
}
func (m *SdkAwsCredentialResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAwsCredentialResponse.Unmarshal(m, b)
}
func (m *SdkAwsCredentialResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAwsCredentialResponse.Marshal(b, m, deterministic)
}
func (dst *SdkAwsCredentialResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAwsCredentialResponse.Merge(dst, src)
}
func (m *SdkAwsCredentialResponse) XXX_Size() int {
	return xxx_messageInfo_SdkAwsCredentialResponse.Size(m)
}
func (m *SdkAwsCredentialResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAwsCredentialResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAwsCredentialResponse proto.InternalMessageInfo

func (m *SdkAwsCredentialResponse) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *SdkAwsCredentialResponse) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *SdkAwsCredentialResponse) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *SdkAwsCredentialResponse) GetDisableSsl() bool {
	if m != nil {
		return m.DisableSsl
	}
	return false
}

// Defines the response for Azure credentials
type SdkAzureCredentialResponse struct {
	// Account name
	AccountName          string   `protobuf:"bytes,2,opt,name=account_name,json=accountName" json:"account_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkAzureCredentialResponse) Reset()         { *m = SdkAzureCredentialResponse{} }
func (m *SdkAzureCredentialResponse) String() string { return proto.CompactTextString(m) }
func (*SdkAzureCredentialResponse) ProtoMessage()    {}
func (*SdkAzureCredentialResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{87}
}
func (m *SdkAzureCredentialResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkAzureCredentialResponse.Unmarshal(m, b)
}
func (m *SdkAzureCredentialResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkAzureCredentialResponse.Marshal(b, m, deterministic)
}
func (dst *SdkAzureCredentialResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkAzureCredentialResponse.Merge(dst, src)
}
func (m *SdkAzureCredentialResponse) XXX_Size() int {
	return xxx_messageInfo_SdkAzureCredentialResponse.Size(m)
}
func (m *SdkAzureCredentialResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkAzureCredentialResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkAzureCredentialResponse proto.InternalMessageInfo

func (m *SdkAzureCredentialResponse) GetAccountName() string {
	if m != nil {
		return m.AccountName
	}
	return ""
}

// Defines the response for Google credentials
type SdkGoogleCredentialResponse struct {
	// Project ID
	ProjectId            string   `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkGoogleCredentialResponse) Reset()         { *m = SdkGoogleCredentialResponse{} }
func (m *SdkGoogleCredentialResponse) String() string { return proto.CompactTextString(m) }
func (*SdkGoogleCredentialResponse) ProtoMessage()    {}
func (*SdkGoogleCredentialResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{88}
}
func (m *SdkGoogleCredentialResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkGoogleCredentialResponse.Unmarshal(m, b)
}
func (m *SdkGoogleCredentialResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkGoogleCredentialResponse.Marshal(b, m, deterministic)
}
func (dst *SdkGoogleCredentialResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkGoogleCredentialResponse.Merge(dst, src)
}
func (m *SdkGoogleCredentialResponse) XXX_Size() int {
	return xxx_messageInfo_SdkGoogleCredentialResponse.Size(m)
}
func (m *SdkGoogleCredentialResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkGoogleCredentialResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkGoogleCredentialResponse proto.InternalMessageInfo

func (m *SdkGoogleCredentialResponse) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Empty request
type SdkCredentialEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialEnumerateRequest) Reset()         { *m = SdkCredentialEnumerateRequest{} }
func (m *SdkCredentialEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialEnumerateRequest) ProtoMessage()    {}
func (*SdkCredentialEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{89}
}
func (m *SdkCredentialEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkCredentialEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialEnumerateRequest.Merge(dst, src)
}
func (m *SdkCredentialEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialEnumerateRequest.Size(m)
}
func (m *SdkCredentialEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialEnumerateRequest proto.InternalMessageInfo

// Defines response for a enumeration of credentials
type SdkCredentialEnumerateResponse struct {
	// List of credentials
	CredentialIds        []string `protobuf:"bytes,1,rep,name=credential_ids,json=credentialIds" json:"credential_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialEnumerateResponse) Reset()         { *m = SdkCredentialEnumerateResponse{} }
func (m *SdkCredentialEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialEnumerateResponse) ProtoMessage()    {}
func (*SdkCredentialEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{90}
}
func (m *SdkCredentialEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkCredentialEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialEnumerateResponse.Merge(dst, src)
}
func (m *SdkCredentialEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialEnumerateResponse.Size(m)
}
func (m *SdkCredentialEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialEnumerateResponse proto.InternalMessageInfo

func (m *SdkCredentialEnumerateResponse) GetCredentialIds() []string {
	if m != nil {
		return m.CredentialIds
	}
	return nil
}

// Defines the request to inspection for credentials
type SdkCredentialInspectRequest struct {
	// Id of the credential
	CredentialId         string   `protobuf:"bytes,1,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialInspectRequest) Reset()         { *m = SdkCredentialInspectRequest{} }
func (m *SdkCredentialInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialInspectRequest) ProtoMessage()    {}
func (*SdkCredentialInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{91}
}
func (m *SdkCredentialInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialInspectRequest.Unmarshal(m, b)
}
func (m *SdkCredentialInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialInspectRequest.Merge(dst, src)
}
func (m *SdkCredentialInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialInspectRequest.Size(m)
}
func (m *SdkCredentialInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialInspectRequest proto.InternalMessageInfo

func (m *SdkCredentialInspectRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Defines the response to an inspection of a credential.
// This response uses OneOf proto style. Depending on your programming language
// you will need to check if the value of credential_type is one of the ones below.
type SdkCredentialInspectResponse struct {
	// Credential id
	CredentialId string `protobuf:"bytes,1,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// Name of the credential
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// (optional) Name of bucket
	Bucket string `protobuf:"bytes,3,opt,name=bucket" json:"bucket,omitempty"`
	// Ownership of the credential
	Ownership *Ownership `protobuf:"bytes,4,opt,name=ownership" json:"ownership,omitempty"`
	// Start at field number 200 for expansion support
	//
	// Types that are valid to be assigned to CredentialType:
	//	*SdkCredentialInspectResponse_AwsCredential
	//	*SdkCredentialInspectResponse_AzureCredential
	//	*SdkCredentialInspectResponse_GoogleCredential
	CredentialType       isSdkCredentialInspectResponse_CredentialType `protobuf_oneof:"credential_type"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *SdkCredentialInspectResponse) Reset()         { *m = SdkCredentialInspectResponse{} }
func (m *SdkCredentialInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialInspectResponse) ProtoMessage()    {}
func (*SdkCredentialInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{92}
}
func (m *SdkCredentialInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialInspectResponse.Unmarshal(m, b)
}
func (m *SdkCredentialInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialInspectResponse.Merge(dst, src)
}
func (m *SdkCredentialInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialInspectResponse.Size(m)
}
func (m *SdkCredentialInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialInspectResponse proto.InternalMessageInfo

type isSdkCredentialInspectResponse_CredentialType interface {
	isSdkCredentialInspectResponse_CredentialType()
}

type SdkCredentialInspectResponse_AwsCredential struct {
	AwsCredential *SdkAwsCredentialResponse `protobuf:"bytes,200,opt,name=aws_credential,json=awsCredential,oneof"`
}
type SdkCredentialInspectResponse_AzureCredential struct {
	AzureCredential *SdkAzureCredentialResponse `protobuf:"bytes,201,opt,name=azure_credential,json=azureCredential,oneof"`
}
type SdkCredentialInspectResponse_GoogleCredential struct {
	GoogleCredential *SdkGoogleCredentialResponse `protobuf:"bytes,202,opt,name=google_credential,json=googleCredential,oneof"`
}

func (*SdkCredentialInspectResponse_AwsCredential) isSdkCredentialInspectResponse_CredentialType()   {}
func (*SdkCredentialInspectResponse_AzureCredential) isSdkCredentialInspectResponse_CredentialType() {}
func (*SdkCredentialInspectResponse_GoogleCredential) isSdkCredentialInspectResponse_CredentialType() {
}

func (m *SdkCredentialInspectResponse) GetCredentialType() isSdkCredentialInspectResponse_CredentialType {
	if m != nil {
		return m.CredentialType
	}
	return nil
}

func (m *SdkCredentialInspectResponse) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCredentialInspectResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkCredentialInspectResponse) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *SdkCredentialInspectResponse) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *SdkCredentialInspectResponse) GetAwsCredential() *SdkAwsCredentialResponse {
	if x, ok := m.GetCredentialType().(*SdkCredentialInspectResponse_AwsCredential); ok {
		return x.AwsCredential
	}
	return nil
}

func (m *SdkCredentialInspectResponse) GetAzureCredential() *SdkAzureCredentialResponse {
	if x, ok := m.GetCredentialType().(*SdkCredentialInspectResponse_AzureCredential); ok {
		return x.AzureCredential
	}
	return nil
}

func (m *SdkCredentialInspectResponse) GetGoogleCredential() *SdkGoogleCredentialResponse {
	if x, ok := m.GetCredentialType().(*SdkCredentialInspectResponse_GoogleCredential); ok {
		return x.GoogleCredential
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkCredentialInspectResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkCredentialInspectResponse_OneofMarshaler, _SdkCredentialInspectResponse_OneofUnmarshaler, _SdkCredentialInspectResponse_OneofSizer, []interface{}{
		(*SdkCredentialInspectResponse_AwsCredential)(nil),
		(*SdkCredentialInspectResponse_AzureCredential)(nil),
		(*SdkCredentialInspectResponse_GoogleCredential)(nil),
	}
}

func _SdkCredentialInspectResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkCredentialInspectResponse)
	// credential_type
	switch x := m.CredentialType.(type) {
	case *SdkCredentialInspectResponse_AwsCredential:
		b.EncodeVarint(200<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AwsCredential); err != nil {
			return err
		}
	case *SdkCredentialInspectResponse_AzureCredential:
		b.EncodeVarint(201<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AzureCredential); err != nil {
			return err
		}
	case *SdkCredentialInspectResponse_GoogleCredential:
		b.EncodeVarint(202<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GoogleCredential); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkCredentialInspectResponse.CredentialType has unexpected type %T", x)
	}
	return nil
}

func _SdkCredentialInspectResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkCredentialInspectResponse)
	switch tag {
	case 200: // credential_type.aws_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAwsCredentialResponse)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialInspectResponse_AwsCredential{msg}
		return true, err
	case 201: // credential_type.azure_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkAzureCredentialResponse)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialInspectResponse_AzureCredential{msg}
		return true, err
	case 202: // credential_type.google_credential
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkGoogleCredentialResponse)
		err := b.DecodeMessage(msg)
		m.CredentialType = &SdkCredentialInspectResponse_GoogleCredential{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkCredentialInspectResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkCredentialInspectResponse)
	// credential_type
	switch x := m.CredentialType.(type) {
	case *SdkCredentialInspectResponse_AwsCredential:
		s := proto.Size(x.AwsCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCredentialInspectResponse_AzureCredential:
		s := proto.Size(x.AzureCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCredentialInspectResponse_GoogleCredential:
		s := proto.Size(x.GoogleCredential)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines the request to delete credentials
type SdkCredentialDeleteRequest struct {
	// Id for credentials
	CredentialId         string   `protobuf:"bytes,1,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialDeleteRequest) Reset()         { *m = SdkCredentialDeleteRequest{} }
func (m *SdkCredentialDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialDeleteRequest) ProtoMessage()    {}
func (*SdkCredentialDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{93}
}
func (m *SdkCredentialDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialDeleteRequest.Unmarshal(m, b)
}
func (m *SdkCredentialDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialDeleteRequest.Merge(dst, src)
}
func (m *SdkCredentialDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialDeleteRequest.Size(m)
}
func (m *SdkCredentialDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialDeleteRequest proto.InternalMessageInfo

func (m *SdkCredentialDeleteRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Empty response
type SdkCredentialDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialDeleteResponse) Reset()         { *m = SdkCredentialDeleteResponse{} }
func (m *SdkCredentialDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialDeleteResponse) ProtoMessage()    {}
func (*SdkCredentialDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{94}
}
func (m *SdkCredentialDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialDeleteResponse.Unmarshal(m, b)
}
func (m *SdkCredentialDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialDeleteResponse.Merge(dst, src)
}
func (m *SdkCredentialDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialDeleteResponse.Size(m)
}
func (m *SdkCredentialDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialDeleteResponse proto.InternalMessageInfo

// Defines a request to validate credentials
type SdkCredentialValidateRequest struct {
	// Id of the credentials
	CredentialId         string   `protobuf:"bytes,1,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialValidateRequest) Reset()         { *m = SdkCredentialValidateRequest{} }
func (m *SdkCredentialValidateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialValidateRequest) ProtoMessage()    {}
func (*SdkCredentialValidateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{95}
}
func (m *SdkCredentialValidateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialValidateRequest.Unmarshal(m, b)
}
func (m *SdkCredentialValidateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialValidateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialValidateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialValidateRequest.Merge(dst, src)
}
func (m *SdkCredentialValidateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialValidateRequest.Size(m)
}
func (m *SdkCredentialValidateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialValidateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialValidateRequest proto.InternalMessageInfo

func (m *SdkCredentialValidateRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Empty response
type SdkCredentialValidateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCredentialValidateResponse) Reset()         { *m = SdkCredentialValidateResponse{} }
func (m *SdkCredentialValidateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCredentialValidateResponse) ProtoMessage()    {}
func (*SdkCredentialValidateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{96}
}
func (m *SdkCredentialValidateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCredentialValidateResponse.Unmarshal(m, b)
}
func (m *SdkCredentialValidateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCredentialValidateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCredentialValidateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCredentialValidateResponse.Merge(dst, src)
}
func (m *SdkCredentialValidateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCredentialValidateResponse.Size(m)
}
func (m *SdkCredentialValidateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCredentialValidateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCredentialValidateResponse proto.InternalMessageInfo

// Options to attach device
type SdkVolumeAttachOptions struct {
	// Indicates the name of the secret stored in a secret store
	// In case of Hashicorp's Vault, it will be the key from the key-value pair stored in its kv backend.
	// In case of Kubernetes secret, it is the name of the secret object itself
	SecretName string `protobuf:"bytes,1,opt,name=secret_name,json=secretName" json:"secret_name,omitempty"`
	// In case of Kubernetes, this will be the key stored in the Kubernetes secret
	SecretKey string `protobuf:"bytes,2,opt,name=secret_key,json=secretKey" json:"secret_key,omitempty"`
	// It indicates the additional context which could be used to retrieve the secret.
	// In case of Kubernetes, this is the namespace in which the secret is created.
	SecretContext        string   `protobuf:"bytes,3,opt,name=secret_context,json=secretContext" json:"secret_context,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeAttachOptions) Reset()         { *m = SdkVolumeAttachOptions{} }
func (m *SdkVolumeAttachOptions) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeAttachOptions) ProtoMessage()    {}
func (*SdkVolumeAttachOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{97}
}
func (m *SdkVolumeAttachOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeAttachOptions.Unmarshal(m, b)
}
func (m *SdkVolumeAttachOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeAttachOptions.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeAttachOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeAttachOptions.Merge(dst, src)
}
func (m *SdkVolumeAttachOptions) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeAttachOptions.Size(m)
}
func (m *SdkVolumeAttachOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeAttachOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeAttachOptions proto.InternalMessageInfo

func (m *SdkVolumeAttachOptions) GetSecretName() string {
	if m != nil {
		return m.SecretName
	}
	return ""
}

func (m *SdkVolumeAttachOptions) GetSecretKey() string {
	if m != nil {
		return m.SecretKey
	}
	return ""
}

func (m *SdkVolumeAttachOptions) GetSecretContext() string {
	if m != nil {
		return m.SecretContext
	}
	return ""
}

// Defines a request to mount a volume to the node receiving this request
type SdkVolumeMountRequest struct {
	// Id of the volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Mount path for mounting the volume.
	MountPath string `protobuf:"bytes,2,opt,name=mount_path,json=mountPath" json:"mount_path,omitempty"`
	// Options to attach device
	Options *SdkVolumeAttachOptions `protobuf:"bytes,3,opt,name=options" json:"options,omitempty"`
	// The following options are private to the driver plugin running the
	// OpenStorage SDK. Contact your driver developer for any special
	// values that need to be provided here.
	DriverOptions        map[string]string `protobuf:"bytes,4,rep,name=driver_options,json=driverOptions" json:"driver_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeMountRequest) Reset()         { *m = SdkVolumeMountRequest{} }
func (m *SdkVolumeMountRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeMountRequest) ProtoMessage()    {}
func (*SdkVolumeMountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{98}
}
func (m *SdkVolumeMountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeMountRequest.Unmarshal(m, b)
}
func (m *SdkVolumeMountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeMountRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeMountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeMountRequest.Merge(dst, src)
}
func (m *SdkVolumeMountRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeMountRequest.Size(m)
}
func (m *SdkVolumeMountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeMountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeMountRequest proto.InternalMessageInfo

func (m *SdkVolumeMountRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeMountRequest) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *SdkVolumeMountRequest) GetOptions() *SdkVolumeAttachOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *SdkVolumeMountRequest) GetDriverOptions() map[string]string {
	if m != nil {
		return m.DriverOptions
	}
	return nil
}

// Empty response
type SdkVolumeMountResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeMountResponse) Reset()         { *m = SdkVolumeMountResponse{} }
func (m *SdkVolumeMountResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeMountResponse) ProtoMessage()    {}
func (*SdkVolumeMountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{99}
}
func (m *SdkVolumeMountResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeMountResponse.Unmarshal(m, b)
}
func (m *SdkVolumeMountResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeMountResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeMountResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeMountResponse.Merge(dst, src)
}
func (m *SdkVolumeMountResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeMountResponse.Size(m)
}
func (m *SdkVolumeMountResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeMountResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeMountResponse proto.InternalMessageInfo

// Options to unmount device
type SdkVolumeUnmountOptions struct {
	// Delete the mount path on the node after unmounting
	DeleteMountPath bool `protobuf:"varint,1,opt,name=delete_mount_path,json=deleteMountPath" json:"delete_mount_path,omitempty"`
	// Do not wait for a delay before deleting path.
	// Normally a storage driver may delay before deleting the mount path,
	// which may be necessary to reduce the risk of race conditions. This
	// choice will remove that delay. This value is only usable when
	// `delete_mount_path` is set.
	NoDelayBeforeDeletingMountPath bool     `protobuf:"varint,2,opt,name=no_delay_before_deleting_mount_path,json=noDelayBeforeDeletingMountPath" json:"no_delay_before_deleting_mount_path,omitempty"`
	XXX_NoUnkeyedLiteral           struct{} `json:"-"`
	XXX_unrecognized               []byte   `json:"-"`
	XXX_sizecache                  int32    `json:"-"`
}

func (m *SdkVolumeUnmountOptions) Reset()         { *m = SdkVolumeUnmountOptions{} }
func (m *SdkVolumeUnmountOptions) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeUnmountOptions) ProtoMessage()    {}
func (*SdkVolumeUnmountOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{100}
}
func (m *SdkVolumeUnmountOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeUnmountOptions.Unmarshal(m, b)
}
func (m *SdkVolumeUnmountOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeUnmountOptions.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeUnmountOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeUnmountOptions.Merge(dst, src)
}
func (m *SdkVolumeUnmountOptions) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeUnmountOptions.Size(m)
}
func (m *SdkVolumeUnmountOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeUnmountOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeUnmountOptions proto.InternalMessageInfo

func (m *SdkVolumeUnmountOptions) GetDeleteMountPath() bool {
	if m != nil {
		return m.DeleteMountPath
	}
	return false
}

func (m *SdkVolumeUnmountOptions) GetNoDelayBeforeDeletingMountPath() bool {
	if m != nil {
		return m.NoDelayBeforeDeletingMountPath
	}
	return false
}

// Defines a request to unmount a volume on the node receiving this request
type SdkVolumeUnmountRequest struct {
	// Id of volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// MountPath for device
	MountPath string `protobuf:"bytes,2,opt,name=mount_path,json=mountPath" json:"mount_path,omitempty"`
	// Options to unmount device
	Options *SdkVolumeUnmountOptions `protobuf:"bytes,3,opt,name=options" json:"options,omitempty"`
	// The following options are private to the driver plugin running the
	// OpenStorage SDK. Contact your driver developer for any special
	// values that need to be provided here.
	DriverOptions        map[string]string `protobuf:"bytes,4,rep,name=driver_options,json=driverOptions" json:"driver_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeUnmountRequest) Reset()         { *m = SdkVolumeUnmountRequest{} }
func (m *SdkVolumeUnmountRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeUnmountRequest) ProtoMessage()    {}
func (*SdkVolumeUnmountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{101}
}
func (m *SdkVolumeUnmountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeUnmountRequest.Unmarshal(m, b)
}
func (m *SdkVolumeUnmountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeUnmountRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeUnmountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeUnmountRequest.Merge(dst, src)
}
func (m *SdkVolumeUnmountRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeUnmountRequest.Size(m)
}
func (m *SdkVolumeUnmountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeUnmountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeUnmountRequest proto.InternalMessageInfo

func (m *SdkVolumeUnmountRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeUnmountRequest) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *SdkVolumeUnmountRequest) GetOptions() *SdkVolumeUnmountOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *SdkVolumeUnmountRequest) GetDriverOptions() map[string]string {
	if m != nil {
		return m.DriverOptions
	}
	return nil
}

// Empty response
type SdkVolumeUnmountResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeUnmountResponse) Reset()         { *m = SdkVolumeUnmountResponse{} }
func (m *SdkVolumeUnmountResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeUnmountResponse) ProtoMessage()    {}
func (*SdkVolumeUnmountResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{102}
}
func (m *SdkVolumeUnmountResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeUnmountResponse.Unmarshal(m, b)
}
func (m *SdkVolumeUnmountResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeUnmountResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeUnmountResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeUnmountResponse.Merge(dst, src)
}
func (m *SdkVolumeUnmountResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeUnmountResponse.Size(m)
}
func (m *SdkVolumeUnmountResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeUnmountResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeUnmountResponse proto.InternalMessageInfo

// Defines a request to attach a volume to the node receiving this request
type SdkVolumeAttachRequest struct {
	// Id of volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Options to attach device
	Options *SdkVolumeAttachOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
	// The following options are private to the driver plugin running the
	// OpenStorage SDK. Contact your driver developer for any special
	// values that need to be provided here.
	DriverOptions        map[string]string `protobuf:"bytes,3,rep,name=driver_options,json=driverOptions" json:"driver_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeAttachRequest) Reset()         { *m = SdkVolumeAttachRequest{} }
func (m *SdkVolumeAttachRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeAttachRequest) ProtoMessage()    {}
func (*SdkVolumeAttachRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{103}
}
func (m *SdkVolumeAttachRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeAttachRequest.Unmarshal(m, b)
}
func (m *SdkVolumeAttachRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeAttachRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeAttachRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeAttachRequest.Merge(dst, src)
}
func (m *SdkVolumeAttachRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeAttachRequest.Size(m)
}
func (m *SdkVolumeAttachRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeAttachRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeAttachRequest proto.InternalMessageInfo

func (m *SdkVolumeAttachRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeAttachRequest) GetOptions() *SdkVolumeAttachOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *SdkVolumeAttachRequest) GetDriverOptions() map[string]string {
	if m != nil {
		return m.DriverOptions
	}
	return nil
}

// Defines a response from the node which received the request to attach
type SdkVolumeAttachResponse struct {
	// Device path where device is exported
	DevicePath           string   `protobuf:"bytes,1,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeAttachResponse) Reset()         { *m = SdkVolumeAttachResponse{} }
func (m *SdkVolumeAttachResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeAttachResponse) ProtoMessage()    {}
func (*SdkVolumeAttachResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{104}
}
func (m *SdkVolumeAttachResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeAttachResponse.Unmarshal(m, b)
}
func (m *SdkVolumeAttachResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeAttachResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeAttachResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeAttachResponse.Merge(dst, src)
}
func (m *SdkVolumeAttachResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeAttachResponse.Size(m)
}
func (m *SdkVolumeAttachResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeAttachResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeAttachResponse proto.InternalMessageInfo

func (m *SdkVolumeAttachResponse) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

type SdkVolumeDetachOptions struct {
	// Forcefully detach device from the kernel
	Force bool `protobuf:"varint,1,opt,name=force" json:"force,omitempty"`
	// Unmount the volume before detaching
	UnmountBeforeDetach  bool     `protobuf:"varint,2,opt,name=unmount_before_detach,json=unmountBeforeDetach" json:"unmount_before_detach,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeDetachOptions) Reset()         { *m = SdkVolumeDetachOptions{} }
func (m *SdkVolumeDetachOptions) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeDetachOptions) ProtoMessage()    {}
func (*SdkVolumeDetachOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{105}
}
func (m *SdkVolumeDetachOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeDetachOptions.Unmarshal(m, b)
}
func (m *SdkVolumeDetachOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeDetachOptions.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeDetachOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeDetachOptions.Merge(dst, src)
}
func (m *SdkVolumeDetachOptions) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeDetachOptions.Size(m)
}
func (m *SdkVolumeDetachOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeDetachOptions.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeDetachOptions proto.InternalMessageInfo

func (m *SdkVolumeDetachOptions) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *SdkVolumeDetachOptions) GetUnmountBeforeDetach() bool {
	if m != nil {
		return m.UnmountBeforeDetach
	}
	return false
}

// Defines a request to detach a volume
type SdkVolumeDetachRequest struct {
	// Id of the volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Options to detach device
	Options *SdkVolumeDetachOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
	// The following options are private to the driver plugin running the
	// OpenStorage SDK. Contact your driver developer for any special
	// values that need to be provided here.
	DriverOptions        map[string]string `protobuf:"bytes,3,rep,name=driver_options,json=driverOptions" json:"driver_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeDetachRequest) Reset()         { *m = SdkVolumeDetachRequest{} }
func (m *SdkVolumeDetachRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeDetachRequest) ProtoMessage()    {}
func (*SdkVolumeDetachRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{106}
}
func (m *SdkVolumeDetachRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeDetachRequest.Unmarshal(m, b)
}
func (m *SdkVolumeDetachRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeDetachRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeDetachRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeDetachRequest.Merge(dst, src)
}
func (m *SdkVolumeDetachRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeDetachRequest.Size(m)
}
func (m *SdkVolumeDetachRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeDetachRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeDetachRequest proto.InternalMessageInfo

func (m *SdkVolumeDetachRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeDetachRequest) GetOptions() *SdkVolumeDetachOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *SdkVolumeDetachRequest) GetDriverOptions() map[string]string {
	if m != nil {
		return m.DriverOptions
	}
	return nil
}

// Empty response
type SdkVolumeDetachResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeDetachResponse) Reset()         { *m = SdkVolumeDetachResponse{} }
func (m *SdkVolumeDetachResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeDetachResponse) ProtoMessage()    {}
func (*SdkVolumeDetachResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{107}
}
func (m *SdkVolumeDetachResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeDetachResponse.Unmarshal(m, b)
}
func (m *SdkVolumeDetachResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeDetachResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeDetachResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeDetachResponse.Merge(dst, src)
}
func (m *SdkVolumeDetachResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeDetachResponse.Size(m)
}
func (m *SdkVolumeDetachResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeDetachResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeDetachResponse proto.InternalMessageInfo

// Defines a request to create a volume. Use OpenStorageVolume.Update()
// to update any labels on the volume.
type SdkVolumeCreateRequest struct {
	// Unique name of the volume. This will be used for idempotency.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Volume specification
	Spec *VolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// Labels to apply to the volume
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeCreateRequest) Reset()         { *m = SdkVolumeCreateRequest{} }
func (m *SdkVolumeCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCreateRequest) ProtoMessage()    {}
func (*SdkVolumeCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{108}
}
func (m *SdkVolumeCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCreateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCreateRequest.Merge(dst, src)
}
func (m *SdkVolumeCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCreateRequest.Size(m)
}
func (m *SdkVolumeCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCreateRequest proto.InternalMessageInfo

func (m *SdkVolumeCreateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeCreateRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *SdkVolumeCreateRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Defines a response to the creation of a volume
type SdkVolumeCreateResponse struct {
	// Id of new volume
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeCreateResponse) Reset()         { *m = SdkVolumeCreateResponse{} }
func (m *SdkVolumeCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCreateResponse) ProtoMessage()    {}
func (*SdkVolumeCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{109}
}
func (m *SdkVolumeCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCreateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCreateResponse.Merge(dst, src)
}
func (m *SdkVolumeCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCreateResponse.Size(m)
}
func (m *SdkVolumeCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCreateResponse proto.InternalMessageInfo

func (m *SdkVolumeCreateResponse) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines a request to clone a volume or create a volume from a snapshot
type SdkVolumeCloneRequest struct {
	// Unique name of the volume. This will be used for idempotency.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Parent volume id or snapshot id will create a new volume as a clone of the parent.
	ParentId             string   `protobuf:"bytes,2,opt,name=parent_id,json=parentId" json:"parent_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeCloneRequest) Reset()         { *m = SdkVolumeCloneRequest{} }
func (m *SdkVolumeCloneRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCloneRequest) ProtoMessage()    {}
func (*SdkVolumeCloneRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{110}
}
func (m *SdkVolumeCloneRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCloneRequest.Unmarshal(m, b)
}
func (m *SdkVolumeCloneRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCloneRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCloneRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCloneRequest.Merge(dst, src)
}
func (m *SdkVolumeCloneRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCloneRequest.Size(m)
}
func (m *SdkVolumeCloneRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCloneRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCloneRequest proto.InternalMessageInfo

func (m *SdkVolumeCloneRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeCloneRequest) GetParentId() string {
	if m != nil {
		return m.ParentId
	}
	return ""
}

// Defines the response when creating a clone from a volume or a snapshot
type SdkVolumeCloneResponse struct {
	// Id of new volume
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeCloneResponse) Reset()         { *m = SdkVolumeCloneResponse{} }
func (m *SdkVolumeCloneResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCloneResponse) ProtoMessage()    {}
func (*SdkVolumeCloneResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{111}
}
func (m *SdkVolumeCloneResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCloneResponse.Unmarshal(m, b)
}
func (m *SdkVolumeCloneResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCloneResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCloneResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCloneResponse.Merge(dst, src)
}
func (m *SdkVolumeCloneResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCloneResponse.Size(m)
}
func (m *SdkVolumeCloneResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCloneResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCloneResponse proto.InternalMessageInfo

func (m *SdkVolumeCloneResponse) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines the request to delete a volume
type SdkVolumeDeleteRequest struct {
	// Id of volume to delete
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeDeleteRequest) Reset()         { *m = SdkVolumeDeleteRequest{} }
func (m *SdkVolumeDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeDeleteRequest) ProtoMessage()    {}
func (*SdkVolumeDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{112}
}
func (m *SdkVolumeDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeDeleteRequest.Unmarshal(m, b)
}
func (m *SdkVolumeDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeDeleteRequest.Merge(dst, src)
}
func (m *SdkVolumeDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeDeleteRequest.Size(m)
}
func (m *SdkVolumeDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeDeleteRequest proto.InternalMessageInfo

func (m *SdkVolumeDeleteRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Empty response
type SdkVolumeDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeDeleteResponse) Reset()         { *m = SdkVolumeDeleteResponse{} }
func (m *SdkVolumeDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeDeleteResponse) ProtoMessage()    {}
func (*SdkVolumeDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{113}
}
func (m *SdkVolumeDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeDeleteResponse.Unmarshal(m, b)
}
func (m *SdkVolumeDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeDeleteResponse.Merge(dst, src)
}
func (m *SdkVolumeDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeDeleteResponse.Size(m)
}
func (m *SdkVolumeDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeDeleteResponse proto.InternalMessageInfo

// Defines the request to inspect a volume
type SdkVolumeInspectRequest struct {
	// Id of volume to inspect
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Options during inspection
	Options              *VolumeInspectOptions `protobuf:"bytes,2,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SdkVolumeInspectRequest) Reset()         { *m = SdkVolumeInspectRequest{} }
func (m *SdkVolumeInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeInspectRequest) ProtoMessage()    {}
func (*SdkVolumeInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{114}
}
func (m *SdkVolumeInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeInspectRequest.Unmarshal(m, b)
}
func (m *SdkVolumeInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeInspectRequest.Merge(dst, src)
}
func (m *SdkVolumeInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeInspectRequest.Size(m)
}
func (m *SdkVolumeInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeInspectRequest proto.InternalMessageInfo

func (m *SdkVolumeInspectRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeInspectRequest) GetOptions() *VolumeInspectOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Defines the response when inspecting a volume
type SdkVolumeInspectResponse struct {
	// Information about the volume
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
	// Name of volume
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// Volume labels
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeInspectResponse) Reset()         { *m = SdkVolumeInspectResponse{} }
func (m *SdkVolumeInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeInspectResponse) ProtoMessage()    {}
func (*SdkVolumeInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{115}
}
func (m *SdkVolumeInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeInspectResponse.Unmarshal(m, b)
}
func (m *SdkVolumeInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeInspectResponse.Merge(dst, src)
}
func (m *SdkVolumeInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeInspectResponse.Size(m)
}
func (m *SdkVolumeInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeInspectResponse proto.InternalMessageInfo

func (m *SdkVolumeInspectResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *SdkVolumeInspectResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeInspectResponse) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Defines the request to inspect volumes using a filter
type SdkVolumeInspectWithFiltersRequest struct {
	// (optional) Name to search
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// (optional) Labels to search
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (optional) Ownership to match
	Ownership *Ownership `protobuf:"bytes,4,opt,name=ownership" json:"ownership,omitempty"`
	// (optional) Group to match
	Group *Group `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	// Options during inspection
	Options              *VolumeInspectOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SdkVolumeInspectWithFiltersRequest) Reset()         { *m = SdkVolumeInspectWithFiltersRequest{} }
func (m *SdkVolumeInspectWithFiltersRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeInspectWithFiltersRequest) ProtoMessage()    {}
func (*SdkVolumeInspectWithFiltersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{116}
}
func (m *SdkVolumeInspectWithFiltersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersRequest.Unmarshal(m, b)
}
func (m *SdkVolumeInspectWithFiltersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeInspectWithFiltersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeInspectWithFiltersRequest.Merge(dst, src)
}
func (m *SdkVolumeInspectWithFiltersRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersRequest.Size(m)
}
func (m *SdkVolumeInspectWithFiltersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeInspectWithFiltersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeInspectWithFiltersRequest proto.InternalMessageInfo

func (m *SdkVolumeInspectWithFiltersRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeInspectWithFiltersRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SdkVolumeInspectWithFiltersRequest) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *SdkVolumeInspectWithFiltersRequest) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

func (m *SdkVolumeInspectWithFiltersRequest) GetOptions() *VolumeInspectOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Defines the response when inspecting volumes using a filter
type SdkVolumeInspectWithFiltersResponse struct {
	// List of `SdkVolumeInspectResponse` objects describing the volumes
	Volumes              []*SdkVolumeInspectResponse `protobuf:"bytes,1,rep,name=volumes" json:"volumes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SdkVolumeInspectWithFiltersResponse) Reset()         { *m = SdkVolumeInspectWithFiltersResponse{} }
func (m *SdkVolumeInspectWithFiltersResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeInspectWithFiltersResponse) ProtoMessage()    {}
func (*SdkVolumeInspectWithFiltersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{117}
}
func (m *SdkVolumeInspectWithFiltersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersResponse.Unmarshal(m, b)
}
func (m *SdkVolumeInspectWithFiltersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeInspectWithFiltersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeInspectWithFiltersResponse.Merge(dst, src)
}
func (m *SdkVolumeInspectWithFiltersResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeInspectWithFiltersResponse.Size(m)
}
func (m *SdkVolumeInspectWithFiltersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeInspectWithFiltersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeInspectWithFiltersResponse proto.InternalMessageInfo

func (m *SdkVolumeInspectWithFiltersResponse) GetVolumes() []*SdkVolumeInspectResponse {
	if m != nil {
		return m.Volumes
	}
	return nil
}

// This request is used to adjust or set new values in the volume
type SdkVolumeUpdateRequest struct {
	// Id of the volume to update
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Change label values. Some of these values may not be able to be changed.
	// New labels will be added to the current volume labels. To delete a label, set the
	// value of the label to an empty string.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// VolumeSpecUpdate provides a method to request that certain values
	// in the VolumeSpec are changed. This is necessary as a separate variable
	// because values like int and bool in the VolumeSpec cannot be determined
	// if they are being requested to change in gRPC proto3. Some of these
	// values may not be able to be changed.
	//
	// Here are a few examples of actions that can be accomplished using the VolumeSpec:
	//
	// * To resize the volume: Set a new value in spec.size_opt.size.
	// * To change number of replicas: Adjust spec.ha_level_opt.ha_level.
	// * To change the I/O Profile: Adjust spec.io_profile_opt.io_profile.
	Spec                 *VolumeSpecUpdate `protobuf:"bytes,4,opt,name=spec" json:"spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeUpdateRequest) Reset()         { *m = SdkVolumeUpdateRequest{} }
func (m *SdkVolumeUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeUpdateRequest) ProtoMessage()    {}
func (*SdkVolumeUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{118}
}
func (m *SdkVolumeUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeUpdateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeUpdateRequest.Merge(dst, src)
}
func (m *SdkVolumeUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeUpdateRequest.Size(m)
}
func (m *SdkVolumeUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeUpdateRequest proto.InternalMessageInfo

func (m *SdkVolumeUpdateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeUpdateRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SdkVolumeUpdateRequest) GetSpec() *VolumeSpecUpdate {
	if m != nil {
		return m.Spec
	}
	return nil
}

// Empty response
type SdkVolumeUpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeUpdateResponse) Reset()         { *m = SdkVolumeUpdateResponse{} }
func (m *SdkVolumeUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeUpdateResponse) ProtoMessage()    {}
func (*SdkVolumeUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{119}
}
func (m *SdkVolumeUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeUpdateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeUpdateResponse.Merge(dst, src)
}
func (m *SdkVolumeUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeUpdateResponse.Size(m)
}
func (m *SdkVolumeUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeUpdateResponse proto.InternalMessageInfo

// Defines a request to retreive volume statistics
type SdkVolumeStatsRequest struct {
	// Id of the volume to get statistics
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// When set to false the stats are in /proc/diskstats style stats.
	// When set to true the stats are stats for a specific duration.
	NotCumulative        bool     `protobuf:"varint,2,opt,name=not_cumulative,json=notCumulative" json:"not_cumulative,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeStatsRequest) Reset()         { *m = SdkVolumeStatsRequest{} }
func (m *SdkVolumeStatsRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeStatsRequest) ProtoMessage()    {}
func (*SdkVolumeStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{120}
}
func (m *SdkVolumeStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeStatsRequest.Unmarshal(m, b)
}
func (m *SdkVolumeStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeStatsRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeStatsRequest.Merge(dst, src)
}
func (m *SdkVolumeStatsRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeStatsRequest.Size(m)
}
func (m *SdkVolumeStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeStatsRequest proto.InternalMessageInfo

func (m *SdkVolumeStatsRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeStatsRequest) GetNotCumulative() bool {
	if m != nil {
		return m.NotCumulative
	}
	return false
}

// Defines a response containing drive statistics
type SdkVolumeStatsResponse struct {
	// Statistics for a single volume
	Stats                *Stats   `protobuf:"bytes,1,opt,name=stats" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeStatsResponse) Reset()         { *m = SdkVolumeStatsResponse{} }
func (m *SdkVolumeStatsResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeStatsResponse) ProtoMessage()    {}
func (*SdkVolumeStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{121}
}
func (m *SdkVolumeStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeStatsResponse.Unmarshal(m, b)
}
func (m *SdkVolumeStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeStatsResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeStatsResponse.Merge(dst, src)
}
func (m *SdkVolumeStatsResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeStatsResponse.Size(m)
}
func (m *SdkVolumeStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeStatsResponse proto.InternalMessageInfo

func (m *SdkVolumeStatsResponse) GetStats() *Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

// Defines request to retrieve volume/snapshot capacity usage details
type SdkVolumeCapacityUsageRequest struct {
	// Id of the snapshot/volume to get capacity usage details
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeCapacityUsageRequest) Reset()         { *m = SdkVolumeCapacityUsageRequest{} }
func (m *SdkVolumeCapacityUsageRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCapacityUsageRequest) ProtoMessage()    {}
func (*SdkVolumeCapacityUsageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{122}
}
func (m *SdkVolumeCapacityUsageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCapacityUsageRequest.Unmarshal(m, b)
}
func (m *SdkVolumeCapacityUsageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCapacityUsageRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCapacityUsageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCapacityUsageRequest.Merge(dst, src)
}
func (m *SdkVolumeCapacityUsageRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCapacityUsageRequest.Size(m)
}
func (m *SdkVolumeCapacityUsageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCapacityUsageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCapacityUsageRequest proto.InternalMessageInfo

func (m *SdkVolumeCapacityUsageRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines response containing volume/snapshot capacity usage details
type SdkVolumeCapacityUsageResponse struct {
	// CapacityUsage details
	CapacityUsageInfo    *CapacityUsageInfo `protobuf:"bytes,1,opt,name=capacity_usage_info,json=capacityUsageInfo" json:"capacity_usage_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdkVolumeCapacityUsageResponse) Reset()         { *m = SdkVolumeCapacityUsageResponse{} }
func (m *SdkVolumeCapacityUsageResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeCapacityUsageResponse) ProtoMessage()    {}
func (*SdkVolumeCapacityUsageResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{123}
}
func (m *SdkVolumeCapacityUsageResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeCapacityUsageResponse.Unmarshal(m, b)
}
func (m *SdkVolumeCapacityUsageResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeCapacityUsageResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeCapacityUsageResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeCapacityUsageResponse.Merge(dst, src)
}
func (m *SdkVolumeCapacityUsageResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeCapacityUsageResponse.Size(m)
}
func (m *SdkVolumeCapacityUsageResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeCapacityUsageResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeCapacityUsageResponse proto.InternalMessageInfo

func (m *SdkVolumeCapacityUsageResponse) GetCapacityUsageInfo() *CapacityUsageInfo {
	if m != nil {
		return m.CapacityUsageInfo
	}
	return nil
}

// Defines a request to list volumes
type SdkVolumeEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeEnumerateRequest) Reset()         { *m = SdkVolumeEnumerateRequest{} }
func (m *SdkVolumeEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeEnumerateRequest) ProtoMessage()    {}
func (*SdkVolumeEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{124}
}
func (m *SdkVolumeEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeEnumerateRequest.Merge(dst, src)
}
func (m *SdkVolumeEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeEnumerateRequest.Size(m)
}
func (m *SdkVolumeEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeEnumerateRequest proto.InternalMessageInfo

// Defines the response when listing volumes
type SdkVolumeEnumerateResponse struct {
	// List of volumes matching label
	VolumeIds            []string `protobuf:"bytes,1,rep,name=volume_ids,json=volumeIds" json:"volume_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeEnumerateResponse) Reset()         { *m = SdkVolumeEnumerateResponse{} }
func (m *SdkVolumeEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeEnumerateResponse) ProtoMessage()    {}
func (*SdkVolumeEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{125}
}
func (m *SdkVolumeEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeEnumerateResponse.Merge(dst, src)
}
func (m *SdkVolumeEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeEnumerateResponse.Size(m)
}
func (m *SdkVolumeEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeEnumerateResponse proto.InternalMessageInfo

func (m *SdkVolumeEnumerateResponse) GetVolumeIds() []string {
	if m != nil {
		return m.VolumeIds
	}
	return nil
}

// Defines a request to list volumes
type SdkVolumeEnumerateWithFiltersRequest struct {
	// (optional) Name to search
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// (optional) Labels to search
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (optional) Ownership to match
	Ownership *Ownership `protobuf:"bytes,4,opt,name=ownership" json:"ownership,omitempty"`
	// (optional) Group to match
	Group                *Group   `protobuf:"bytes,5,opt,name=group" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeEnumerateWithFiltersRequest) Reset()         { *m = SdkVolumeEnumerateWithFiltersRequest{} }
func (m *SdkVolumeEnumerateWithFiltersRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeEnumerateWithFiltersRequest) ProtoMessage()    {}
func (*SdkVolumeEnumerateWithFiltersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{126}
}
func (m *SdkVolumeEnumerateWithFiltersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest.Unmarshal(m, b)
}
func (m *SdkVolumeEnumerateWithFiltersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeEnumerateWithFiltersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest.Merge(dst, src)
}
func (m *SdkVolumeEnumerateWithFiltersRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest.Size(m)
}
func (m *SdkVolumeEnumerateWithFiltersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeEnumerateWithFiltersRequest proto.InternalMessageInfo

func (m *SdkVolumeEnumerateWithFiltersRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeEnumerateWithFiltersRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SdkVolumeEnumerateWithFiltersRequest) GetOwnership() *Ownership {
	if m != nil {
		return m.Ownership
	}
	return nil
}

func (m *SdkVolumeEnumerateWithFiltersRequest) GetGroup() *Group {
	if m != nil {
		return m.Group
	}
	return nil
}

// Defines the response when listing volumes
type SdkVolumeEnumerateWithFiltersResponse struct {
	// List of volumes matching label
	VolumeIds            []string `protobuf:"bytes,1,rep,name=volume_ids,json=volumeIds" json:"volume_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeEnumerateWithFiltersResponse) Reset()         { *m = SdkVolumeEnumerateWithFiltersResponse{} }
func (m *SdkVolumeEnumerateWithFiltersResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeEnumerateWithFiltersResponse) ProtoMessage()    {}
func (*SdkVolumeEnumerateWithFiltersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{127}
}
func (m *SdkVolumeEnumerateWithFiltersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse.Unmarshal(m, b)
}
func (m *SdkVolumeEnumerateWithFiltersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeEnumerateWithFiltersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse.Merge(dst, src)
}
func (m *SdkVolumeEnumerateWithFiltersResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse.Size(m)
}
func (m *SdkVolumeEnumerateWithFiltersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeEnumerateWithFiltersResponse proto.InternalMessageInfo

func (m *SdkVolumeEnumerateWithFiltersResponse) GetVolumeIds() []string {
	if m != nil {
		return m.VolumeIds
	}
	return nil
}

// Defines the request when creating a snapshot from a volume.
type SdkVolumeSnapshotCreateRequest struct {
	// Id of volume to take the snapshot from
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Name of the snapshot.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// Labels to apply to snapshot
	Labels               map[string]string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeSnapshotCreateRequest) Reset()         { *m = SdkVolumeSnapshotCreateRequest{} }
func (m *SdkVolumeSnapshotCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotCreateRequest) ProtoMessage()    {}
func (*SdkVolumeSnapshotCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{128}
}
func (m *SdkVolumeSnapshotCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotCreateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotCreateRequest.Merge(dst, src)
}
func (m *SdkVolumeSnapshotCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotCreateRequest.Size(m)
}
func (m *SdkVolumeSnapshotCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotCreateRequest proto.InternalMessageInfo

func (m *SdkVolumeSnapshotCreateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeSnapshotCreateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkVolumeSnapshotCreateRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Defines a response after creating a snapshot of a volume
type SdkVolumeSnapshotCreateResponse struct {
	// Id of immutable snapshot
	SnapshotId           string   `protobuf:"bytes,1,opt,name=snapshot_id,json=snapshotId" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotCreateResponse) Reset()         { *m = SdkVolumeSnapshotCreateResponse{} }
func (m *SdkVolumeSnapshotCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotCreateResponse) ProtoMessage()    {}
func (*SdkVolumeSnapshotCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{129}
}
func (m *SdkVolumeSnapshotCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotCreateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotCreateResponse.Merge(dst, src)
}
func (m *SdkVolumeSnapshotCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotCreateResponse.Size(m)
}
func (m *SdkVolumeSnapshotCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotCreateResponse proto.InternalMessageInfo

func (m *SdkVolumeSnapshotCreateResponse) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

// Defines a request to restore a volume to a snapshot
type SdkVolumeSnapshotRestoreRequest struct {
	// Id of volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Snapshot id to apply to `volume_id`
	SnapshotId           string   `protobuf:"bytes,2,opt,name=snapshot_id,json=snapshotId" json:"snapshot_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotRestoreRequest) Reset()         { *m = SdkVolumeSnapshotRestoreRequest{} }
func (m *SdkVolumeSnapshotRestoreRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotRestoreRequest) ProtoMessage()    {}
func (*SdkVolumeSnapshotRestoreRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{130}
}
func (m *SdkVolumeSnapshotRestoreRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreRequest.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotRestoreRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotRestoreRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotRestoreRequest.Merge(dst, src)
}
func (m *SdkVolumeSnapshotRestoreRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreRequest.Size(m)
}
func (m *SdkVolumeSnapshotRestoreRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotRestoreRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotRestoreRequest proto.InternalMessageInfo

func (m *SdkVolumeSnapshotRestoreRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeSnapshotRestoreRequest) GetSnapshotId() string {
	if m != nil {
		return m.SnapshotId
	}
	return ""
}

// Empty response
type SdkVolumeSnapshotRestoreResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotRestoreResponse) Reset()         { *m = SdkVolumeSnapshotRestoreResponse{} }
func (m *SdkVolumeSnapshotRestoreResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotRestoreResponse) ProtoMessage()    {}
func (*SdkVolumeSnapshotRestoreResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{131}
}
func (m *SdkVolumeSnapshotRestoreResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreResponse.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotRestoreResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotRestoreResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotRestoreResponse.Merge(dst, src)
}
func (m *SdkVolumeSnapshotRestoreResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotRestoreResponse.Size(m)
}
func (m *SdkVolumeSnapshotRestoreResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotRestoreResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotRestoreResponse proto.InternalMessageInfo

// Defines a request to list the snaphots
type SdkVolumeSnapshotEnumerateRequest struct {
	// Get the snapshots for this volume id
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotEnumerateRequest) Reset()         { *m = SdkVolumeSnapshotEnumerateRequest{} }
func (m *SdkVolumeSnapshotEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotEnumerateRequest) ProtoMessage()    {}
func (*SdkVolumeSnapshotEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{132}
}
func (m *SdkVolumeSnapshotEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest.Merge(dst, src)
}
func (m *SdkVolumeSnapshotEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest.Size(m)
}
func (m *SdkVolumeSnapshotEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotEnumerateRequest proto.InternalMessageInfo

func (m *SdkVolumeSnapshotEnumerateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines a response when listing snapshots
type SdkVolumeSnapshotEnumerateResponse struct {
	// List of immutable snapshots
	VolumeSnapshotIds    []string `protobuf:"bytes,1,rep,name=volume_snapshot_ids,json=volumeSnapshotIds" json:"volume_snapshot_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotEnumerateResponse) Reset()         { *m = SdkVolumeSnapshotEnumerateResponse{} }
func (m *SdkVolumeSnapshotEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotEnumerateResponse) ProtoMessage()    {}
func (*SdkVolumeSnapshotEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{133}
}
func (m *SdkVolumeSnapshotEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse.Merge(dst, src)
}
func (m *SdkVolumeSnapshotEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse.Size(m)
}
func (m *SdkVolumeSnapshotEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotEnumerateResponse proto.InternalMessageInfo

func (m *SdkVolumeSnapshotEnumerateResponse) GetVolumeSnapshotIds() []string {
	if m != nil {
		return m.VolumeSnapshotIds
	}
	return nil
}

// Defines a request to list the snaphots
type SdkVolumeSnapshotEnumerateWithFiltersRequest struct {
	// (optional) Get the snapshots for this volume id
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// (optional) Get snapshots that match these labels
	Labels               map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) Reset() {
	*m = SdkVolumeSnapshotEnumerateWithFiltersRequest{}
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) String() string {
	return proto.CompactTextString(m)
}
func (*SdkVolumeSnapshotEnumerateWithFiltersRequest) ProtoMessage() {}
func (*SdkVolumeSnapshotEnumerateWithFiltersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{134}
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotEnumerateWithFiltersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest.Merge(dst, src)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest.Size(m)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersRequest proto.InternalMessageInfo

func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeSnapshotEnumerateWithFiltersRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Defines a response when listing snapshots
type SdkVolumeSnapshotEnumerateWithFiltersResponse struct {
	// List of immutable snapshots
	VolumeSnapshotIds    []string `protobuf:"bytes,1,rep,name=volume_snapshot_ids,json=volumeSnapshotIds" json:"volume_snapshot_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) Reset() {
	*m = SdkVolumeSnapshotEnumerateWithFiltersResponse{}
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) String() string {
	return proto.CompactTextString(m)
}
func (*SdkVolumeSnapshotEnumerateWithFiltersResponse) ProtoMessage() {}
func (*SdkVolumeSnapshotEnumerateWithFiltersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{135}
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotEnumerateWithFiltersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse.Merge(dst, src)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse.Size(m)
}
func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotEnumerateWithFiltersResponse proto.InternalMessageInfo

func (m *SdkVolumeSnapshotEnumerateWithFiltersResponse) GetVolumeSnapshotIds() []string {
	if m != nil {
		return m.VolumeSnapshotIds
	}
	return nil
}

// Defines a request to update the snapshot schedule of a volume
type SdkVolumeSnapshotScheduleUpdateRequest struct {
	// Id of volume
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Names of schedule policies
	SnapshotScheduleNames []string `protobuf:"bytes,2,rep,name=snapshot_schedule_names,json=snapshotScheduleNames" json:"snapshot_schedule_names,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *SdkVolumeSnapshotScheduleUpdateRequest) Reset() {
	*m = SdkVolumeSnapshotScheduleUpdateRequest{}
}
func (m *SdkVolumeSnapshotScheduleUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotScheduleUpdateRequest) ProtoMessage()    {}
func (*SdkVolumeSnapshotScheduleUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{136}
}
func (m *SdkVolumeSnapshotScheduleUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotScheduleUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotScheduleUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest.Merge(dst, src)
}
func (m *SdkVolumeSnapshotScheduleUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest.Size(m)
}
func (m *SdkVolumeSnapshotScheduleUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateRequest proto.InternalMessageInfo

func (m *SdkVolumeSnapshotScheduleUpdateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkVolumeSnapshotScheduleUpdateRequest) GetSnapshotScheduleNames() []string {
	if m != nil {
		return m.SnapshotScheduleNames
	}
	return nil
}

// Empty response
type SdkVolumeSnapshotScheduleUpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVolumeSnapshotScheduleUpdateResponse) Reset() {
	*m = SdkVolumeSnapshotScheduleUpdateResponse{}
}
func (m *SdkVolumeSnapshotScheduleUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkVolumeSnapshotScheduleUpdateResponse) ProtoMessage()    {}
func (*SdkVolumeSnapshotScheduleUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{137}
}
func (m *SdkVolumeSnapshotScheduleUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse.Unmarshal(m, b)
}
func (m *SdkVolumeSnapshotScheduleUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkVolumeSnapshotScheduleUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse.Merge(dst, src)
}
func (m *SdkVolumeSnapshotScheduleUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse.Size(m)
}
func (m *SdkVolumeSnapshotScheduleUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVolumeSnapshotScheduleUpdateResponse proto.InternalMessageInfo

// Empty request
type SdkClusterDomainsEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainsEnumerateRequest) Reset()         { *m = SdkClusterDomainsEnumerateRequest{} }
func (m *SdkClusterDomainsEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainsEnumerateRequest) ProtoMessage()    {}
func (*SdkClusterDomainsEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{138}
}
func (m *SdkClusterDomainsEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainsEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkClusterDomainsEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainsEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainsEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainsEnumerateRequest.Merge(dst, src)
}
func (m *SdkClusterDomainsEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainsEnumerateRequest.Size(m)
}
func (m *SdkClusterDomainsEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainsEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainsEnumerateRequest proto.InternalMessageInfo

// Defines a response when enumerating cluster domains
type SdkClusterDomainsEnumerateResponse struct {
	// List of names of all the cluster domains in a cluster
	ClusterDomainNames   []string `protobuf:"bytes,1,rep,name=cluster_domain_names,json=clusterDomainNames" json:"cluster_domain_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainsEnumerateResponse) Reset()         { *m = SdkClusterDomainsEnumerateResponse{} }
func (m *SdkClusterDomainsEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainsEnumerateResponse) ProtoMessage()    {}
func (*SdkClusterDomainsEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{139}
}
func (m *SdkClusterDomainsEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainsEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkClusterDomainsEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainsEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainsEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainsEnumerateResponse.Merge(dst, src)
}
func (m *SdkClusterDomainsEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainsEnumerateResponse.Size(m)
}
func (m *SdkClusterDomainsEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainsEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainsEnumerateResponse proto.InternalMessageInfo

func (m *SdkClusterDomainsEnumerateResponse) GetClusterDomainNames() []string {
	if m != nil {
		return m.ClusterDomainNames
	}
	return nil
}

// Defines a request to inspect a cluster domain
type SdkClusterDomainInspectRequest struct {
	// Name of the cluster domain to inspect
	ClusterDomainName    string   `protobuf:"bytes,1,opt,name=cluster_domain_name,json=clusterDomainName" json:"cluster_domain_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainInspectRequest) Reset()         { *m = SdkClusterDomainInspectRequest{} }
func (m *SdkClusterDomainInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainInspectRequest) ProtoMessage()    {}
func (*SdkClusterDomainInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{140}
}
func (m *SdkClusterDomainInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainInspectRequest.Unmarshal(m, b)
}
func (m *SdkClusterDomainInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainInspectRequest.Merge(dst, src)
}
func (m *SdkClusterDomainInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainInspectRequest.Size(m)
}
func (m *SdkClusterDomainInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainInspectRequest proto.InternalMessageInfo

func (m *SdkClusterDomainInspectRequest) GetClusterDomainName() string {
	if m != nil {
		return m.ClusterDomainName
	}
	return ""
}

// Defines a response to inspecting a cluster domain
type SdkClusterDomainInspectResponse struct {
	// Name of the cluster domain
	ClusterDomainName string `protobuf:"bytes,1,opt,name=cluster_domain_name,json=clusterDomainName" json:"cluster_domain_name,omitempty"`
	// IsActive indicates whether this cluster domain is active
	IsActive             bool     `protobuf:"varint,2,opt,name=is_active,json=isActive" json:"is_active,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainInspectResponse) Reset()         { *m = SdkClusterDomainInspectResponse{} }
func (m *SdkClusterDomainInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainInspectResponse) ProtoMessage()    {}
func (*SdkClusterDomainInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{141}
}
func (m *SdkClusterDomainInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainInspectResponse.Unmarshal(m, b)
}
func (m *SdkClusterDomainInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainInspectResponse.Merge(dst, src)
}
func (m *SdkClusterDomainInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainInspectResponse.Size(m)
}
func (m *SdkClusterDomainInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainInspectResponse proto.InternalMessageInfo

func (m *SdkClusterDomainInspectResponse) GetClusterDomainName() string {
	if m != nil {
		return m.ClusterDomainName
	}
	return ""
}

func (m *SdkClusterDomainInspectResponse) GetIsActive() bool {
	if m != nil {
		return m.IsActive
	}
	return false
}

// Defines a request to activate a cluster domain
type SdkClusterDomainActivateRequest struct {
	// Name of the cluster domain to activate
	ClusterDomainName    string   `protobuf:"bytes,1,opt,name=cluster_domain_name,json=clusterDomainName" json:"cluster_domain_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainActivateRequest) Reset()         { *m = SdkClusterDomainActivateRequest{} }
func (m *SdkClusterDomainActivateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainActivateRequest) ProtoMessage()    {}
func (*SdkClusterDomainActivateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{142}
}
func (m *SdkClusterDomainActivateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainActivateRequest.Unmarshal(m, b)
}
func (m *SdkClusterDomainActivateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainActivateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainActivateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainActivateRequest.Merge(dst, src)
}
func (m *SdkClusterDomainActivateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainActivateRequest.Size(m)
}
func (m *SdkClusterDomainActivateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainActivateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainActivateRequest proto.InternalMessageInfo

func (m *SdkClusterDomainActivateRequest) GetClusterDomainName() string {
	if m != nil {
		return m.ClusterDomainName
	}
	return ""
}

// Empty response
type SdkClusterDomainActivateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainActivateResponse) Reset()         { *m = SdkClusterDomainActivateResponse{} }
func (m *SdkClusterDomainActivateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainActivateResponse) ProtoMessage()    {}
func (*SdkClusterDomainActivateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{143}
}
func (m *SdkClusterDomainActivateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainActivateResponse.Unmarshal(m, b)
}
func (m *SdkClusterDomainActivateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainActivateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainActivateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainActivateResponse.Merge(dst, src)
}
func (m *SdkClusterDomainActivateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainActivateResponse.Size(m)
}
func (m *SdkClusterDomainActivateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainActivateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainActivateResponse proto.InternalMessageInfo

// Defines a request to deactivate a cluster domain
type SdkClusterDomainDeactivateRequest struct {
	// Name of the cluster domain to deactivate
	ClusterDomainName    string   `protobuf:"bytes,1,opt,name=cluster_domain_name,json=clusterDomainName" json:"cluster_domain_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainDeactivateRequest) Reset()         { *m = SdkClusterDomainDeactivateRequest{} }
func (m *SdkClusterDomainDeactivateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainDeactivateRequest) ProtoMessage()    {}
func (*SdkClusterDomainDeactivateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{144}
}
func (m *SdkClusterDomainDeactivateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainDeactivateRequest.Unmarshal(m, b)
}
func (m *SdkClusterDomainDeactivateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainDeactivateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainDeactivateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainDeactivateRequest.Merge(dst, src)
}
func (m *SdkClusterDomainDeactivateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainDeactivateRequest.Size(m)
}
func (m *SdkClusterDomainDeactivateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainDeactivateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainDeactivateRequest proto.InternalMessageInfo

func (m *SdkClusterDomainDeactivateRequest) GetClusterDomainName() string {
	if m != nil {
		return m.ClusterDomainName
	}
	return ""
}

// Empty response
type SdkClusterDomainDeactivateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterDomainDeactivateResponse) Reset()         { *m = SdkClusterDomainDeactivateResponse{} }
func (m *SdkClusterDomainDeactivateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterDomainDeactivateResponse) ProtoMessage()    {}
func (*SdkClusterDomainDeactivateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{145}
}
func (m *SdkClusterDomainDeactivateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterDomainDeactivateResponse.Unmarshal(m, b)
}
func (m *SdkClusterDomainDeactivateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterDomainDeactivateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterDomainDeactivateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterDomainDeactivateResponse.Merge(dst, src)
}
func (m *SdkClusterDomainDeactivateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterDomainDeactivateResponse.Size(m)
}
func (m *SdkClusterDomainDeactivateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterDomainDeactivateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterDomainDeactivateResponse proto.InternalMessageInfo

// Empty request
type SdkClusterInspectCurrentRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterInspectCurrentRequest) Reset()         { *m = SdkClusterInspectCurrentRequest{} }
func (m *SdkClusterInspectCurrentRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterInspectCurrentRequest) ProtoMessage()    {}
func (*SdkClusterInspectCurrentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{146}
}
func (m *SdkClusterInspectCurrentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterInspectCurrentRequest.Unmarshal(m, b)
}
func (m *SdkClusterInspectCurrentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterInspectCurrentRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterInspectCurrentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterInspectCurrentRequest.Merge(dst, src)
}
func (m *SdkClusterInspectCurrentRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterInspectCurrentRequest.Size(m)
}
func (m *SdkClusterInspectCurrentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterInspectCurrentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterInspectCurrentRequest proto.InternalMessageInfo

// Defines a response when inspecting the current cluster
type SdkClusterInspectCurrentResponse struct {
	// Cluster information
	Cluster              *StorageCluster `protobuf:"bytes,1,opt,name=cluster" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SdkClusterInspectCurrentResponse) Reset()         { *m = SdkClusterInspectCurrentResponse{} }
func (m *SdkClusterInspectCurrentResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterInspectCurrentResponse) ProtoMessage()    {}
func (*SdkClusterInspectCurrentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{147}
}
func (m *SdkClusterInspectCurrentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterInspectCurrentResponse.Unmarshal(m, b)
}
func (m *SdkClusterInspectCurrentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterInspectCurrentResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterInspectCurrentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterInspectCurrentResponse.Merge(dst, src)
}
func (m *SdkClusterInspectCurrentResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterInspectCurrentResponse.Size(m)
}
func (m *SdkClusterInspectCurrentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterInspectCurrentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterInspectCurrentResponse proto.InternalMessageInfo

func (m *SdkClusterInspectCurrentResponse) GetCluster() *StorageCluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// Defines a request when inspecting a node
type SdkNodeInspectRequest struct {
	// Id of node to inspect
	NodeId               string   `protobuf:"bytes,1,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkNodeInspectRequest) Reset()         { *m = SdkNodeInspectRequest{} }
func (m *SdkNodeInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkNodeInspectRequest) ProtoMessage()    {}
func (*SdkNodeInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{148}
}
func (m *SdkNodeInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeInspectRequest.Unmarshal(m, b)
}
func (m *SdkNodeInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkNodeInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeInspectRequest.Merge(dst, src)
}
func (m *SdkNodeInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkNodeInspectRequest.Size(m)
}
func (m *SdkNodeInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeInspectRequest proto.InternalMessageInfo

func (m *SdkNodeInspectRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

// Defines a response when inspecting a node
type SdkNodeInspectResponse struct {
	// Node information
	Node                 *StorageNode `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SdkNodeInspectResponse) Reset()         { *m = SdkNodeInspectResponse{} }
func (m *SdkNodeInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkNodeInspectResponse) ProtoMessage()    {}
func (*SdkNodeInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{149}
}
func (m *SdkNodeInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeInspectResponse.Unmarshal(m, b)
}
func (m *SdkNodeInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkNodeInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeInspectResponse.Merge(dst, src)
}
func (m *SdkNodeInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkNodeInspectResponse.Size(m)
}
func (m *SdkNodeInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeInspectResponse proto.InternalMessageInfo

func (m *SdkNodeInspectResponse) GetNode() *StorageNode {
	if m != nil {
		return m.Node
	}
	return nil
}

// Empty request
type SdkNodeInspectCurrentRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkNodeInspectCurrentRequest) Reset()         { *m = SdkNodeInspectCurrentRequest{} }
func (m *SdkNodeInspectCurrentRequest) String() string { return proto.CompactTextString(m) }
func (*SdkNodeInspectCurrentRequest) ProtoMessage()    {}
func (*SdkNodeInspectCurrentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{150}
}
func (m *SdkNodeInspectCurrentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeInspectCurrentRequest.Unmarshal(m, b)
}
func (m *SdkNodeInspectCurrentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeInspectCurrentRequest.Marshal(b, m, deterministic)
}
func (dst *SdkNodeInspectCurrentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeInspectCurrentRequest.Merge(dst, src)
}
func (m *SdkNodeInspectCurrentRequest) XXX_Size() int {
	return xxx_messageInfo_SdkNodeInspectCurrentRequest.Size(m)
}
func (m *SdkNodeInspectCurrentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeInspectCurrentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeInspectCurrentRequest proto.InternalMessageInfo

// Defines a response when inspecting a node
type SdkNodeInspectCurrentResponse struct {
	// Node information
	Node                 *StorageNode `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SdkNodeInspectCurrentResponse) Reset()         { *m = SdkNodeInspectCurrentResponse{} }
func (m *SdkNodeInspectCurrentResponse) String() string { return proto.CompactTextString(m) }
func (*SdkNodeInspectCurrentResponse) ProtoMessage()    {}
func (*SdkNodeInspectCurrentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{151}
}
func (m *SdkNodeInspectCurrentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeInspectCurrentResponse.Unmarshal(m, b)
}
func (m *SdkNodeInspectCurrentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeInspectCurrentResponse.Marshal(b, m, deterministic)
}
func (dst *SdkNodeInspectCurrentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeInspectCurrentResponse.Merge(dst, src)
}
func (m *SdkNodeInspectCurrentResponse) XXX_Size() int {
	return xxx_messageInfo_SdkNodeInspectCurrentResponse.Size(m)
}
func (m *SdkNodeInspectCurrentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeInspectCurrentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeInspectCurrentResponse proto.InternalMessageInfo

func (m *SdkNodeInspectCurrentResponse) GetNode() *StorageNode {
	if m != nil {
		return m.Node
	}
	return nil
}

// Empty request
type SdkNodeEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkNodeEnumerateRequest) Reset()         { *m = SdkNodeEnumerateRequest{} }
func (m *SdkNodeEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkNodeEnumerateRequest) ProtoMessage()    {}
func (*SdkNodeEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{152}
}
func (m *SdkNodeEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkNodeEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkNodeEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeEnumerateRequest.Merge(dst, src)
}
func (m *SdkNodeEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkNodeEnumerateRequest.Size(m)
}
func (m *SdkNodeEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeEnumerateRequest proto.InternalMessageInfo

// Defines a response with a list of nodes
type SdkNodeEnumerateResponse struct {
	// List of all the node ids in the cluster
	NodeIds              []string `protobuf:"bytes,1,rep,name=node_ids,json=nodeIds" json:"node_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkNodeEnumerateResponse) Reset()         { *m = SdkNodeEnumerateResponse{} }
func (m *SdkNodeEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkNodeEnumerateResponse) ProtoMessage()    {}
func (*SdkNodeEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{153}
}
func (m *SdkNodeEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkNodeEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkNodeEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkNodeEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkNodeEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkNodeEnumerateResponse.Merge(dst, src)
}
func (m *SdkNodeEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkNodeEnumerateResponse.Size(m)
}
func (m *SdkNodeEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkNodeEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkNodeEnumerateResponse proto.InternalMessageInfo

func (m *SdkNodeEnumerateResponse) GetNodeIds() []string {
	if m != nil {
		return m.NodeIds
	}
	return nil
}

// Defines a request to get information about an object store endpoint
type SdkObjectstoreInspectRequest struct {
	// Id of the object store
	ObjectstoreId        string   `protobuf:"bytes,1,opt,name=objectstore_id,json=objectstoreId" json:"objectstore_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreInspectRequest) Reset()         { *m = SdkObjectstoreInspectRequest{} }
func (m *SdkObjectstoreInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreInspectRequest) ProtoMessage()    {}
func (*SdkObjectstoreInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{154}
}
func (m *SdkObjectstoreInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreInspectRequest.Unmarshal(m, b)
}
func (m *SdkObjectstoreInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreInspectRequest.Merge(dst, src)
}
func (m *SdkObjectstoreInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreInspectRequest.Size(m)
}
func (m *SdkObjectstoreInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreInspectRequest proto.InternalMessageInfo

func (m *SdkObjectstoreInspectRequest) GetObjectstoreId() string {
	if m != nil {
		return m.ObjectstoreId
	}
	return ""
}

// Defines a response when inspecting an object store endpoint
type SdkObjectstoreInspectResponse struct {
	// Contains information about the object store requested
	ObjectstoreStatus    *ObjectstoreInfo `protobuf:"bytes,1,opt,name=objectstore_status,json=objectstoreStatus" json:"objectstore_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SdkObjectstoreInspectResponse) Reset()         { *m = SdkObjectstoreInspectResponse{} }
func (m *SdkObjectstoreInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreInspectResponse) ProtoMessage()    {}
func (*SdkObjectstoreInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{155}
}
func (m *SdkObjectstoreInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreInspectResponse.Unmarshal(m, b)
}
func (m *SdkObjectstoreInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreInspectResponse.Merge(dst, src)
}
func (m *SdkObjectstoreInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreInspectResponse.Size(m)
}
func (m *SdkObjectstoreInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreInspectResponse proto.InternalMessageInfo

func (m *SdkObjectstoreInspectResponse) GetObjectstoreStatus() *ObjectstoreInfo {
	if m != nil {
		return m.ObjectstoreStatus
	}
	return nil
}

// Defines a request to create an object store
type SdkObjectstoreCreateRequest struct {
	// Volume on which objectstore will be running
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreCreateRequest) Reset()         { *m = SdkObjectstoreCreateRequest{} }
func (m *SdkObjectstoreCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreCreateRequest) ProtoMessage()    {}
func (*SdkObjectstoreCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{156}
}
func (m *SdkObjectstoreCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreCreateRequest.Unmarshal(m, b)
}
func (m *SdkObjectstoreCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreCreateRequest.Merge(dst, src)
}
func (m *SdkObjectstoreCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreCreateRequest.Size(m)
}
func (m *SdkObjectstoreCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreCreateRequest proto.InternalMessageInfo

func (m *SdkObjectstoreCreateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines a response when an object store has been created for a
// specified volume
type SdkObjectstoreCreateResponse struct {
	// Created objecstore status
	ObjectstoreStatus    *ObjectstoreInfo `protobuf:"bytes,1,opt,name=objectstore_status,json=objectstoreStatus" json:"objectstore_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SdkObjectstoreCreateResponse) Reset()         { *m = SdkObjectstoreCreateResponse{} }
func (m *SdkObjectstoreCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreCreateResponse) ProtoMessage()    {}
func (*SdkObjectstoreCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{157}
}
func (m *SdkObjectstoreCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreCreateResponse.Unmarshal(m, b)
}
func (m *SdkObjectstoreCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreCreateResponse.Merge(dst, src)
}
func (m *SdkObjectstoreCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreCreateResponse.Size(m)
}
func (m *SdkObjectstoreCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreCreateResponse proto.InternalMessageInfo

func (m *SdkObjectstoreCreateResponse) GetObjectstoreStatus() *ObjectstoreInfo {
	if m != nil {
		return m.ObjectstoreStatus
	}
	return nil
}

// Defines a request to delete an object store service from a volume
type SdkObjectstoreDeleteRequest struct {
	// Id of the object store to delete
	ObjectstoreId        string   `protobuf:"bytes,1,opt,name=objectstore_id,json=objectstoreId" json:"objectstore_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreDeleteRequest) Reset()         { *m = SdkObjectstoreDeleteRequest{} }
func (m *SdkObjectstoreDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreDeleteRequest) ProtoMessage()    {}
func (*SdkObjectstoreDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{158}
}
func (m *SdkObjectstoreDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreDeleteRequest.Unmarshal(m, b)
}
func (m *SdkObjectstoreDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreDeleteRequest.Merge(dst, src)
}
func (m *SdkObjectstoreDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreDeleteRequest.Size(m)
}
func (m *SdkObjectstoreDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreDeleteRequest proto.InternalMessageInfo

func (m *SdkObjectstoreDeleteRequest) GetObjectstoreId() string {
	if m != nil {
		return m.ObjectstoreId
	}
	return ""
}

// Empty response
type SdkObjectstoreDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreDeleteResponse) Reset()         { *m = SdkObjectstoreDeleteResponse{} }
func (m *SdkObjectstoreDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreDeleteResponse) ProtoMessage()    {}
func (*SdkObjectstoreDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{159}
}
func (m *SdkObjectstoreDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreDeleteResponse.Unmarshal(m, b)
}
func (m *SdkObjectstoreDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreDeleteResponse.Merge(dst, src)
}
func (m *SdkObjectstoreDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreDeleteResponse.Size(m)
}
func (m *SdkObjectstoreDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreDeleteResponse proto.InternalMessageInfo

// Defines a request to update an object store
type SdkObjectstoreUpdateRequest struct {
	// Objectstore Id to update
	ObjectstoreId string `protobuf:"bytes,1,opt,name=objectstore_id,json=objectstoreId" json:"objectstore_id,omitempty"`
	// enable/disable objectstore
	Enable               bool     `protobuf:"varint,2,opt,name=enable" json:"enable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreUpdateRequest) Reset()         { *m = SdkObjectstoreUpdateRequest{} }
func (m *SdkObjectstoreUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreUpdateRequest) ProtoMessage()    {}
func (*SdkObjectstoreUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{160}
}
func (m *SdkObjectstoreUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreUpdateRequest.Unmarshal(m, b)
}
func (m *SdkObjectstoreUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreUpdateRequest.Merge(dst, src)
}
func (m *SdkObjectstoreUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreUpdateRequest.Size(m)
}
func (m *SdkObjectstoreUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreUpdateRequest proto.InternalMessageInfo

func (m *SdkObjectstoreUpdateRequest) GetObjectstoreId() string {
	if m != nil {
		return m.ObjectstoreId
	}
	return ""
}

func (m *SdkObjectstoreUpdateRequest) GetEnable() bool {
	if m != nil {
		return m.Enable
	}
	return false
}

// Empty response
type SdkObjectstoreUpdateResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkObjectstoreUpdateResponse) Reset()         { *m = SdkObjectstoreUpdateResponse{} }
func (m *SdkObjectstoreUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkObjectstoreUpdateResponse) ProtoMessage()    {}
func (*SdkObjectstoreUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{161}
}
func (m *SdkObjectstoreUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkObjectstoreUpdateResponse.Unmarshal(m, b)
}
func (m *SdkObjectstoreUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkObjectstoreUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkObjectstoreUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkObjectstoreUpdateResponse.Merge(dst, src)
}
func (m *SdkObjectstoreUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkObjectstoreUpdateResponse.Size(m)
}
func (m *SdkObjectstoreUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkObjectstoreUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkObjectstoreUpdateResponse proto.InternalMessageInfo

// Defines a request to create a backup of a volume to the cloud
type SdkCloudBackupCreateRequest struct {
	// VolumeID of the volume for which cloudbackup is requested
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Credential id refers to the cloud credentials needed to backup
	CredentialId string `protobuf:"bytes,2,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// Full indicates if full backup is desired even though incremental is possible
	Full bool `protobuf:"varint,3,opt,name=full" json:"full,omitempty"`
	// TaskId of the task performing this backup. This value can be used for
	// idempotency.
	TaskId string `protobuf:"bytes,4,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	// Labels are list of key value pairs to tag the cloud backup. These labels
	// are stored in the metadata associated with the backup.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SdkCloudBackupCreateRequest) Reset()         { *m = SdkCloudBackupCreateRequest{} }
func (m *SdkCloudBackupCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupCreateRequest) ProtoMessage()    {}
func (*SdkCloudBackupCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{162}
}
func (m *SdkCloudBackupCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupCreateRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupCreateRequest.Merge(dst, src)
}
func (m *SdkCloudBackupCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupCreateRequest.Size(m)
}
func (m *SdkCloudBackupCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupCreateRequest proto.InternalMessageInfo

func (m *SdkCloudBackupCreateRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkCloudBackupCreateRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupCreateRequest) GetFull() bool {
	if m != nil {
		return m.Full
	}
	return false
}

func (m *SdkCloudBackupCreateRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *SdkCloudBackupCreateRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Empty response
type SdkCloudBackupCreateResponse struct {
	// TaskId of the task performing the backup
	TaskId               string   `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupCreateResponse) Reset()         { *m = SdkCloudBackupCreateResponse{} }
func (m *SdkCloudBackupCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupCreateResponse) ProtoMessage()    {}
func (*SdkCloudBackupCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{163}
}
func (m *SdkCloudBackupCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupCreateResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupCreateResponse.Merge(dst, src)
}
func (m *SdkCloudBackupCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupCreateResponse.Size(m)
}
func (m *SdkCloudBackupCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupCreateResponse proto.InternalMessageInfo

func (m *SdkCloudBackupCreateResponse) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a request to restore a volume from an existing backup stored by
// a cloud provider
type SdkCloudBackupRestoreRequest struct {
	// Backup ID being restored
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId" json:"backup_id,omitempty"`
	// Optional volume Name of the new volume to be created
	// in the cluster for restoring the cloudbackup
	RestoreVolumeName string `protobuf:"bytes,2,opt,name=restore_volume_name,json=restoreVolumeName" json:"restore_volume_name,omitempty"`
	// The credential to be used for restore operation
	CredentialId string `protobuf:"bytes,3,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// Optional for provisioning restore
	// volume (ResoreVolumeName should not be specified)
	NodeId string `protobuf:"bytes,4,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// TaskId of the task performing this restore
	TaskId               string   `protobuf:"bytes,5,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupRestoreRequest) Reset()         { *m = SdkCloudBackupRestoreRequest{} }
func (m *SdkCloudBackupRestoreRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupRestoreRequest) ProtoMessage()    {}
func (*SdkCloudBackupRestoreRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{164}
}
func (m *SdkCloudBackupRestoreRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupRestoreRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupRestoreRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupRestoreRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupRestoreRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupRestoreRequest.Merge(dst, src)
}
func (m *SdkCloudBackupRestoreRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupRestoreRequest.Size(m)
}
func (m *SdkCloudBackupRestoreRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupRestoreRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupRestoreRequest proto.InternalMessageInfo

func (m *SdkCloudBackupRestoreRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *SdkCloudBackupRestoreRequest) GetRestoreVolumeName() string {
	if m != nil {
		return m.RestoreVolumeName
	}
	return ""
}

func (m *SdkCloudBackupRestoreRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupRestoreRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *SdkCloudBackupRestoreRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a response when restoring a volume from a backup stored by
// a cloud provider
type SdkCloudBackupRestoreResponse struct {
	// VolumeID to which the backup is being restored
	RestoreVolumeId string `protobuf:"bytes,1,opt,name=restore_volume_id,json=restoreVolumeId" json:"restore_volume_id,omitempty"`
	// TaskId of the task performing the restore
	TaskId               string   `protobuf:"bytes,2,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupRestoreResponse) Reset()         { *m = SdkCloudBackupRestoreResponse{} }
func (m *SdkCloudBackupRestoreResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupRestoreResponse) ProtoMessage()    {}
func (*SdkCloudBackupRestoreResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{165}
}
func (m *SdkCloudBackupRestoreResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupRestoreResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupRestoreResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupRestoreResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupRestoreResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupRestoreResponse.Merge(dst, src)
}
func (m *SdkCloudBackupRestoreResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupRestoreResponse.Size(m)
}
func (m *SdkCloudBackupRestoreResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupRestoreResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupRestoreResponse proto.InternalMessageInfo

func (m *SdkCloudBackupRestoreResponse) GetRestoreVolumeId() string {
	if m != nil {
		return m.RestoreVolumeId
	}
	return ""
}

func (m *SdkCloudBackupRestoreResponse) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a request to delete a single backup stored by a cloud provider
type SdkCloudBackupDeleteRequest struct {
	// ID is the ID of the cloud backup
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId" json:"backup_id,omitempty"`
	// Credential id is the credential for cloud to be used for the request
	CredentialId string `protobuf:"bytes,2,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// Force Delete cloudbackup even if there are dependencies. This may be
	// needed if the backup is an incremental backup and subsequent backups
	// depend on this backup specified by `backup_id`.
	Force                bool     `protobuf:"varint,3,opt,name=force" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupDeleteRequest) Reset()         { *m = SdkCloudBackupDeleteRequest{} }
func (m *SdkCloudBackupDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupDeleteRequest) ProtoMessage()    {}
func (*SdkCloudBackupDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{166}
}
func (m *SdkCloudBackupDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupDeleteRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupDeleteRequest.Merge(dst, src)
}
func (m *SdkCloudBackupDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupDeleteRequest.Size(m)
}
func (m *SdkCloudBackupDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupDeleteRequest proto.InternalMessageInfo

func (m *SdkCloudBackupDeleteRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *SdkCloudBackupDeleteRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupDeleteRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Empty response
type SdkCloudBackupDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupDeleteResponse) Reset()         { *m = SdkCloudBackupDeleteResponse{} }
func (m *SdkCloudBackupDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupDeleteResponse) ProtoMessage()    {}
func (*SdkCloudBackupDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{167}
}
func (m *SdkCloudBackupDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupDeleteResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupDeleteResponse.Merge(dst, src)
}
func (m *SdkCloudBackupDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupDeleteResponse.Size(m)
}
func (m *SdkCloudBackupDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupDeleteResponse proto.InternalMessageInfo

// Defines a request to delete all the backups stored by a cloud provider
// for a specified volume
type SdkCloudBackupDeleteAllRequest struct {
	// id of the volume for the request
	SrcVolumeId string `protobuf:"bytes,1,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// Credential id is the credential for cloud to be used for the request
	CredentialId         string   `protobuf:"bytes,2,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupDeleteAllRequest) Reset()         { *m = SdkCloudBackupDeleteAllRequest{} }
func (m *SdkCloudBackupDeleteAllRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupDeleteAllRequest) ProtoMessage()    {}
func (*SdkCloudBackupDeleteAllRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{168}
}
func (m *SdkCloudBackupDeleteAllRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupDeleteAllRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupDeleteAllRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupDeleteAllRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupDeleteAllRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupDeleteAllRequest.Merge(dst, src)
}
func (m *SdkCloudBackupDeleteAllRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupDeleteAllRequest.Size(m)
}
func (m *SdkCloudBackupDeleteAllRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupDeleteAllRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupDeleteAllRequest proto.InternalMessageInfo

func (m *SdkCloudBackupDeleteAllRequest) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupDeleteAllRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Empty response
type SdkCloudBackupDeleteAllResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupDeleteAllResponse) Reset()         { *m = SdkCloudBackupDeleteAllResponse{} }
func (m *SdkCloudBackupDeleteAllResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupDeleteAllResponse) ProtoMessage()    {}
func (*SdkCloudBackupDeleteAllResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{169}
}
func (m *SdkCloudBackupDeleteAllResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupDeleteAllResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupDeleteAllResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupDeleteAllResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupDeleteAllResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupDeleteAllResponse.Merge(dst, src)
}
func (m *SdkCloudBackupDeleteAllResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupDeleteAllResponse.Size(m)
}
func (m *SdkCloudBackupDeleteAllResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupDeleteAllResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupDeleteAllResponse proto.InternalMessageInfo

// Defines a request to list the backups stored by a cloud provider.
// The following combinations can be used to get cloud backup information:
//
// * For a specific volume in current cluster: Set `src_volume_id` to your desired volume id
// and do not provide `cluster_id` and `all`.
// * For a specific volume in a specific cluster: Set `src_volume_id` to your desired volume id
// and specify `cluster_id`.
// * For a specific volume in all clusters: Set `src_volume_id` to your desired volume id
// and set `all` to true, do not provide `cluster_id`.
// * For all volumes in current cluster: do not provide `cluster_id`, `volume_id` and `all`.
// * For all volumes in a specific cluster: Set `cluster_id` to your desired cluster id
// and do not provide `volume_id` and `all`.
// * For all volumes in all clusters: Set `all` to true do not provide `volume_id` and `cluster_id`.
type SdkCloudBackupEnumerateWithFiltersRequest struct {
	// (optional) Source id of the volume for the request.
	SrcVolumeId string `protobuf:"bytes,1,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// (optional) Cluster id specifies the cluster for the request
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Credential id is the credential for cloud to be used for the request
	CredentialId string `protobuf:"bytes,3,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// (optional) All indicates if the request should show cloud backups for all clusters or the current cluster.
	All                  bool     `protobuf:"varint,4,opt,name=all" json:"all,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupEnumerateWithFiltersRequest) Reset() {
	*m = SdkCloudBackupEnumerateWithFiltersRequest{}
}
func (m *SdkCloudBackupEnumerateWithFiltersRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupEnumerateWithFiltersRequest) ProtoMessage()    {}
func (*SdkCloudBackupEnumerateWithFiltersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{170}
}
func (m *SdkCloudBackupEnumerateWithFiltersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupEnumerateWithFiltersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupEnumerateWithFiltersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest.Merge(dst, src)
}
func (m *SdkCloudBackupEnumerateWithFiltersRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest.Size(m)
}
func (m *SdkCloudBackupEnumerateWithFiltersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersRequest proto.InternalMessageInfo

func (m *SdkCloudBackupEnumerateWithFiltersRequest) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupEnumerateWithFiltersRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SdkCloudBackupEnumerateWithFiltersRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupEnumerateWithFiltersRequest) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

// SdkCloudBackupInfo has information about a backup stored by a cloud provider
type SdkCloudBackupInfo struct {
	// This is the id as represented by the cloud provider
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Source volumeID of the backup
	SrcVolumeId string `protobuf:"bytes,2,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// Name of the sourceVolume of the backup
	SrcVolumeName string `protobuf:"bytes,3,opt,name=src_volume_name,json=srcVolumeName" json:"src_volume_name,omitempty"`
	// Timestamp is the timestamp at which the source volume
	// was backed up to cloud
	Timestamp *timestamp.Timestamp `protobuf:"bytes,4,opt,name=timestamp" json:"timestamp,omitempty"`
	// Metadata associated with the backup
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Status indicates the status of the backup
	Status               SdkCloudBackupStatusType `protobuf:"varint,6,opt,name=status,enum=openstorage.api.SdkCloudBackupStatusType" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SdkCloudBackupInfo) Reset()         { *m = SdkCloudBackupInfo{} }
func (m *SdkCloudBackupInfo) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupInfo) ProtoMessage()    {}
func (*SdkCloudBackupInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{171}
}
func (m *SdkCloudBackupInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupInfo.Unmarshal(m, b)
}
func (m *SdkCloudBackupInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupInfo.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupInfo.Merge(dst, src)
}
func (m *SdkCloudBackupInfo) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupInfo.Size(m)
}
func (m *SdkCloudBackupInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupInfo proto.InternalMessageInfo

func (m *SdkCloudBackupInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SdkCloudBackupInfo) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupInfo) GetSrcVolumeName() string {
	if m != nil {
		return m.SrcVolumeName
	}
	return ""
}

func (m *SdkCloudBackupInfo) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *SdkCloudBackupInfo) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SdkCloudBackupInfo) GetStatus() SdkCloudBackupStatusType {
	if m != nil {
		return m.Status
	}
	return SdkCloudBackupStatusType_SdkCloudBackupStatusTypeUnknown
}

// Defines a response which lists all the backups stored by a cloud provider
type SdkCloudBackupEnumerateWithFiltersResponse struct {
	Backups              []*SdkCloudBackupInfo `protobuf:"bytes,1,rep,name=backups" json:"backups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SdkCloudBackupEnumerateWithFiltersResponse) Reset() {
	*m = SdkCloudBackupEnumerateWithFiltersResponse{}
}
func (m *SdkCloudBackupEnumerateWithFiltersResponse) String() string {
	return proto.CompactTextString(m)
}
func (*SdkCloudBackupEnumerateWithFiltersResponse) ProtoMessage() {}
func (*SdkCloudBackupEnumerateWithFiltersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{172}
}
func (m *SdkCloudBackupEnumerateWithFiltersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupEnumerateWithFiltersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupEnumerateWithFiltersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse.Merge(dst, src)
}
func (m *SdkCloudBackupEnumerateWithFiltersResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse.Size(m)
}
func (m *SdkCloudBackupEnumerateWithFiltersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupEnumerateWithFiltersResponse proto.InternalMessageInfo

func (m *SdkCloudBackupEnumerateWithFiltersResponse) GetBackups() []*SdkCloudBackupInfo {
	if m != nil {
		return m.Backups
	}
	return nil
}

// SdkCloudBackupStatus defines the status of a backup stored by a cloud provider
type SdkCloudBackupStatus struct {
	// This is the id as represented by the cloud provider
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId" json:"backup_id,omitempty"`
	// OpType indicates if this is a backup or restore
	Optype SdkCloudBackupOpType `protobuf:"varint,2,opt,name=optype,enum=openstorage.api.SdkCloudBackupOpType" json:"optype,omitempty"`
	// State indicates if the op is currently active/done/failed
	Status SdkCloudBackupStatusType `protobuf:"varint,3,opt,name=status,enum=openstorage.api.SdkCloudBackupStatusType" json:"status,omitempty"`
	// BytesDone indicates total Bytes uploaded/downloaded
	BytesDone uint64 `protobuf:"varint,4,opt,name=bytes_done,json=bytesDone" json:"bytes_done,omitempty"`
	// StartTime indicates Op's start time
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// CompletedTime indicates Op's completed time
	CompletedTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=completed_time,json=completedTime" json:"completed_time,omitempty"`
	// NodeID is the ID of the node where this Op is active
	NodeId string `protobuf:"bytes,7,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// SourceVolumeID is the the volume that is either being backed up to cloud
	// or target volume to which a backup is being restored
	SrcVolumeId string `protobuf:"bytes,8,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// Info currently indicates the failure cause for failed backup/restore
	Info []string `protobuf:"bytes,9,rep,name=info" json:"info,omitempty"`
	// CredentialId is the credential used for cloud with this backup/restore op
	CredentialId string `protobuf:"bytes,10,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// BytesTotal is the total number of bytes being transferred
	BytesTotal uint64 `protobuf:"varint,11,opt,name=bytes_total,json=bytesTotal" json:"bytes_total,omitempty"`
	// ETASeconds is the number of seconds for cloud backup completion
	EtaSeconds int64 `protobuf:"varint,12,opt,name=eta_seconds,json=etaSeconds" json:"eta_seconds,omitempty"`
	// string group_id volume's group id if this was group cloud backup
	GroupId              string   `protobuf:"bytes,13,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupStatus) Reset()         { *m = SdkCloudBackupStatus{} }
func (m *SdkCloudBackupStatus) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupStatus) ProtoMessage()    {}
func (*SdkCloudBackupStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{173}
}
func (m *SdkCloudBackupStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupStatus.Unmarshal(m, b)
}
func (m *SdkCloudBackupStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupStatus.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupStatus.Merge(dst, src)
}
func (m *SdkCloudBackupStatus) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupStatus.Size(m)
}
func (m *SdkCloudBackupStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupStatus proto.InternalMessageInfo

func (m *SdkCloudBackupStatus) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *SdkCloudBackupStatus) GetOptype() SdkCloudBackupOpType {
	if m != nil {
		return m.Optype
	}
	return SdkCloudBackupOpType_SdkCloudBackupOpTypeUnknown
}

func (m *SdkCloudBackupStatus) GetStatus() SdkCloudBackupStatusType {
	if m != nil {
		return m.Status
	}
	return SdkCloudBackupStatusType_SdkCloudBackupStatusTypeUnknown
}

func (m *SdkCloudBackupStatus) GetBytesDone() uint64 {
	if m != nil {
		return m.BytesDone
	}
	return 0
}

func (m *SdkCloudBackupStatus) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *SdkCloudBackupStatus) GetCompletedTime() *timestamp.Timestamp {
	if m != nil {
		return m.CompletedTime
	}
	return nil
}

func (m *SdkCloudBackupStatus) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *SdkCloudBackupStatus) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupStatus) GetInfo() []string {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *SdkCloudBackupStatus) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupStatus) GetBytesTotal() uint64 {
	if m != nil {
		return m.BytesTotal
	}
	return 0
}

func (m *SdkCloudBackupStatus) GetEtaSeconds() int64 {
	if m != nil {
		return m.EtaSeconds
	}
	return 0
}

func (m *SdkCloudBackupStatus) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

// Defines a request to retreive the status of a backup or restore for a
// specified volume
type SdkCloudBackupStatusRequest struct {
	// (optional) VolumeId is a value which is used to get information on the
	// status of a backup for the specified volume. If no volume id and task_id
	// is provided, then status for all volumes is returned.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Local indicates if only those backups/restores that are
	// active on current node must be returned
	Local bool `protobuf:"varint,2,opt,name=local" json:"local,omitempty"`
	// TaskId of the backup/restore task, if this is specified,
	// volume_id is ignored.
	TaskId               string   `protobuf:"bytes,3,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupStatusRequest) Reset()         { *m = SdkCloudBackupStatusRequest{} }
func (m *SdkCloudBackupStatusRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupStatusRequest) ProtoMessage()    {}
func (*SdkCloudBackupStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{174}
}
func (m *SdkCloudBackupStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupStatusRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupStatusRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupStatusRequest.Merge(dst, src)
}
func (m *SdkCloudBackupStatusRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupStatusRequest.Size(m)
}
func (m *SdkCloudBackupStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupStatusRequest proto.InternalMessageInfo

func (m *SdkCloudBackupStatusRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *SdkCloudBackupStatusRequest) GetLocal() bool {
	if m != nil {
		return m.Local
	}
	return false
}

func (m *SdkCloudBackupStatusRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a response containing the status of the backups for a specified volume
type SdkCloudBackupStatusResponse struct {
	// Statuses is list of currently active/failed/done backup/restores where
	// the key is the id of the task performing backup/restore.
	Statuses             map[string]*SdkCloudBackupStatus `protobuf:"bytes,1,rep,name=statuses" json:"statuses,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *SdkCloudBackupStatusResponse) Reset()         { *m = SdkCloudBackupStatusResponse{} }
func (m *SdkCloudBackupStatusResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupStatusResponse) ProtoMessage()    {}
func (*SdkCloudBackupStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{175}
}
func (m *SdkCloudBackupStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupStatusResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupStatusResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupStatusResponse.Merge(dst, src)
}
func (m *SdkCloudBackupStatusResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupStatusResponse.Size(m)
}
func (m *SdkCloudBackupStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupStatusResponse proto.InternalMessageInfo

func (m *SdkCloudBackupStatusResponse) GetStatuses() map[string]*SdkCloudBackupStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Defines a request to get catalog of a backup stored by a cloud provider
type SdkCloudBackupCatalogRequest struct {
	// Id of the backup
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId" json:"backup_id,omitempty"`
	// Credential id describe the credentials for the cloud
	CredentialId         string   `protobuf:"bytes,2,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupCatalogRequest) Reset()         { *m = SdkCloudBackupCatalogRequest{} }
func (m *SdkCloudBackupCatalogRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupCatalogRequest) ProtoMessage()    {}
func (*SdkCloudBackupCatalogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{176}
}
func (m *SdkCloudBackupCatalogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupCatalogRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupCatalogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupCatalogRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupCatalogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupCatalogRequest.Merge(dst, src)
}
func (m *SdkCloudBackupCatalogRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupCatalogRequest.Size(m)
}
func (m *SdkCloudBackupCatalogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupCatalogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupCatalogRequest proto.InternalMessageInfo

func (m *SdkCloudBackupCatalogRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *SdkCloudBackupCatalogRequest) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

// Defines a response containing the contents of a backup stored by a cloud provider
type SdkCloudBackupCatalogResponse struct {
	// Contents is listing of backup contents
	Contents             []string `protobuf:"bytes,1,rep,name=contents" json:"contents,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupCatalogResponse) Reset()         { *m = SdkCloudBackupCatalogResponse{} }
func (m *SdkCloudBackupCatalogResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupCatalogResponse) ProtoMessage()    {}
func (*SdkCloudBackupCatalogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{177}
}
func (m *SdkCloudBackupCatalogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupCatalogResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupCatalogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupCatalogResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupCatalogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupCatalogResponse.Merge(dst, src)
}
func (m *SdkCloudBackupCatalogResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupCatalogResponse.Size(m)
}
func (m *SdkCloudBackupCatalogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupCatalogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupCatalogResponse proto.InternalMessageInfo

func (m *SdkCloudBackupCatalogResponse) GetContents() []string {
	if m != nil {
		return m.Contents
	}
	return nil
}

// SdkCloudBackupHistoryItem contains information about a backup for a
// specific volume
type SdkCloudBackupHistoryItem struct {
	// SrcVolumeID is volume ID which was backedup
	SrcVolumeId string `protobuf:"bytes,1,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// TimeStamp is the time at which either backup completed/failed
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	// Status indicates whether backup was completed/failed
	Status               SdkCloudBackupStatusType `protobuf:"varint,3,opt,name=status,enum=openstorage.api.SdkCloudBackupStatusType" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SdkCloudBackupHistoryItem) Reset()         { *m = SdkCloudBackupHistoryItem{} }
func (m *SdkCloudBackupHistoryItem) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupHistoryItem) ProtoMessage()    {}
func (*SdkCloudBackupHistoryItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{178}
}
func (m *SdkCloudBackupHistoryItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupHistoryItem.Unmarshal(m, b)
}
func (m *SdkCloudBackupHistoryItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupHistoryItem.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupHistoryItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupHistoryItem.Merge(dst, src)
}
func (m *SdkCloudBackupHistoryItem) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupHistoryItem.Size(m)
}
func (m *SdkCloudBackupHistoryItem) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupHistoryItem.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupHistoryItem proto.InternalMessageInfo

func (m *SdkCloudBackupHistoryItem) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupHistoryItem) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *SdkCloudBackupHistoryItem) GetStatus() SdkCloudBackupStatusType {
	if m != nil {
		return m.Status
	}
	return SdkCloudBackupStatusType_SdkCloudBackupStatusTypeUnknown
}

// Defines a request to retreive the history of the backups for
// a specific volume to a cloud provider
type SdkCloudBackupHistoryRequest struct {
	// This optional value defines which history of backups is being
	// requested. If not provided, it will return the history for all volumes.
	SrcVolumeId          string   `protobuf:"bytes,1,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupHistoryRequest) Reset()         { *m = SdkCloudBackupHistoryRequest{} }
func (m *SdkCloudBackupHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupHistoryRequest) ProtoMessage()    {}
func (*SdkCloudBackupHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{179}
}
func (m *SdkCloudBackupHistoryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupHistoryRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupHistoryRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupHistoryRequest.Merge(dst, src)
}
func (m *SdkCloudBackupHistoryRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupHistoryRequest.Size(m)
}
func (m *SdkCloudBackupHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupHistoryRequest proto.InternalMessageInfo

func (m *SdkCloudBackupHistoryRequest) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

// Defines a response containing a list of history of backups to a cloud provider
type SdkCloudBackupHistoryResponse struct {
	// HistoryList is list of past backups on this volume
	HistoryList          []*SdkCloudBackupHistoryItem `protobuf:"bytes,1,rep,name=history_list,json=historyList" json:"history_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SdkCloudBackupHistoryResponse) Reset()         { *m = SdkCloudBackupHistoryResponse{} }
func (m *SdkCloudBackupHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupHistoryResponse) ProtoMessage()    {}
func (*SdkCloudBackupHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{180}
}
func (m *SdkCloudBackupHistoryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupHistoryResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupHistoryResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupHistoryResponse.Merge(dst, src)
}
func (m *SdkCloudBackupHistoryResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupHistoryResponse.Size(m)
}
func (m *SdkCloudBackupHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupHistoryResponse proto.InternalMessageInfo

func (m *SdkCloudBackupHistoryResponse) GetHistoryList() []*SdkCloudBackupHistoryItem {
	if m != nil {
		return m.HistoryList
	}
	return nil
}

// Defines a request to change the state of a backup or restore to or
// from a cloud provider
type SdkCloudBackupStateChangeRequest struct {
	// Describes the backup/restore task
	// state change is being requested
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	// The desired state of the operation
	RequestedState       SdkCloudBackupRequestedState `protobuf:"varint,2,opt,name=requested_state,json=requestedState,enum=openstorage.api.SdkCloudBackupRequestedState" json:"requested_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SdkCloudBackupStateChangeRequest) Reset()         { *m = SdkCloudBackupStateChangeRequest{} }
func (m *SdkCloudBackupStateChangeRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupStateChangeRequest) ProtoMessage()    {}
func (*SdkCloudBackupStateChangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{181}
}
func (m *SdkCloudBackupStateChangeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupStateChangeRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupStateChangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupStateChangeRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupStateChangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupStateChangeRequest.Merge(dst, src)
}
func (m *SdkCloudBackupStateChangeRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupStateChangeRequest.Size(m)
}
func (m *SdkCloudBackupStateChangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupStateChangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupStateChangeRequest proto.InternalMessageInfo

func (m *SdkCloudBackupStateChangeRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *SdkCloudBackupStateChangeRequest) GetRequestedState() SdkCloudBackupRequestedState {
	if m != nil {
		return m.RequestedState
	}
	return SdkCloudBackupRequestedState_SdkCloudBackupRequestedStateUnknown
}

// Empty response
type SdkCloudBackupStateChangeResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupStateChangeResponse) Reset()         { *m = SdkCloudBackupStateChangeResponse{} }
func (m *SdkCloudBackupStateChangeResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupStateChangeResponse) ProtoMessage()    {}
func (*SdkCloudBackupStateChangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{182}
}
func (m *SdkCloudBackupStateChangeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupStateChangeResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupStateChangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupStateChangeResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupStateChangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupStateChangeResponse.Merge(dst, src)
}
func (m *SdkCloudBackupStateChangeResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupStateChangeResponse.Size(m)
}
func (m *SdkCloudBackupStateChangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupStateChangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupStateChangeResponse proto.InternalMessageInfo

// SdkCloudBackupScheduleInfo describes a schedule for volume backups to
// a cloud provider
type SdkCloudBackupScheduleInfo struct {
	// The schedule's source volume
	SrcVolumeId string `protobuf:"bytes,1,opt,name=src_volume_id,json=srcVolumeId" json:"src_volume_id,omitempty"`
	// The cloud credential used with this schedule
	CredentialId string `protobuf:"bytes,2,opt,name=credential_id,json=credentialId" json:"credential_id,omitempty"`
	// Schedules are the frequencies of the backup
	Schedules []*SdkSchedulePolicyInterval `protobuf:"bytes,3,rep,name=schedules" json:"schedules,omitempty"`
	// MaxBackups are the maximum number of backups retained
	// in cloud.Older backups are deleted
	MaxBackups uint64 `protobuf:"varint,4,opt,name=max_backups,json=maxBackups" json:"max_backups,omitempty"`
	// Full indicates if scheduled backups should always be full and never incremental.
	Full                 bool     `protobuf:"varint,5,opt,name=full" json:"full,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupScheduleInfo) Reset()         { *m = SdkCloudBackupScheduleInfo{} }
func (m *SdkCloudBackupScheduleInfo) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupScheduleInfo) ProtoMessage()    {}
func (*SdkCloudBackupScheduleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{183}
}
func (m *SdkCloudBackupScheduleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupScheduleInfo.Unmarshal(m, b)
}
func (m *SdkCloudBackupScheduleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupScheduleInfo.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupScheduleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupScheduleInfo.Merge(dst, src)
}
func (m *SdkCloudBackupScheduleInfo) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupScheduleInfo.Size(m)
}
func (m *SdkCloudBackupScheduleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupScheduleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupScheduleInfo proto.InternalMessageInfo

func (m *SdkCloudBackupScheduleInfo) GetSrcVolumeId() string {
	if m != nil {
		return m.SrcVolumeId
	}
	return ""
}

func (m *SdkCloudBackupScheduleInfo) GetCredentialId() string {
	if m != nil {
		return m.CredentialId
	}
	return ""
}

func (m *SdkCloudBackupScheduleInfo) GetSchedules() []*SdkSchedulePolicyInterval {
	if m != nil {
		return m.Schedules
	}
	return nil
}

func (m *SdkCloudBackupScheduleInfo) GetMaxBackups() uint64 {
	if m != nil {
		return m.MaxBackups
	}
	return 0
}

func (m *SdkCloudBackupScheduleInfo) GetFull() bool {
	if m != nil {
		return m.Full
	}
	return false
}

// Defines a request to create a schedule for volume backups to a
// cloud provider
type SdkCloudBackupSchedCreateRequest struct {
	// Cloud Backup Schedule info
	CloudSchedInfo       *SdkCloudBackupScheduleInfo `protobuf:"bytes,1,opt,name=cloud_sched_info,json=cloudSchedInfo" json:"cloud_sched_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SdkCloudBackupSchedCreateRequest) Reset()         { *m = SdkCloudBackupSchedCreateRequest{} }
func (m *SdkCloudBackupSchedCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedCreateRequest) ProtoMessage()    {}
func (*SdkCloudBackupSchedCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{184}
}
func (m *SdkCloudBackupSchedCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedCreateRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedCreateRequest.Merge(dst, src)
}
func (m *SdkCloudBackupSchedCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedCreateRequest.Size(m)
}
func (m *SdkCloudBackupSchedCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedCreateRequest proto.InternalMessageInfo

func (m *SdkCloudBackupSchedCreateRequest) GetCloudSchedInfo() *SdkCloudBackupScheduleInfo {
	if m != nil {
		return m.CloudSchedInfo
	}
	return nil
}

// Defines a response containing the id of a schedule for a volume backup
// to a cloud provider
type SdkCloudBackupSchedCreateResponse struct {
	// Id of newly created backup schedule
	BackupScheduleId     string   `protobuf:"bytes,1,opt,name=backup_schedule_id,json=backupScheduleId" json:"backup_schedule_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupSchedCreateResponse) Reset()         { *m = SdkCloudBackupSchedCreateResponse{} }
func (m *SdkCloudBackupSchedCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedCreateResponse) ProtoMessage()    {}
func (*SdkCloudBackupSchedCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{185}
}
func (m *SdkCloudBackupSchedCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedCreateResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedCreateResponse.Merge(dst, src)
}
func (m *SdkCloudBackupSchedCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedCreateResponse.Size(m)
}
func (m *SdkCloudBackupSchedCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedCreateResponse proto.InternalMessageInfo

func (m *SdkCloudBackupSchedCreateResponse) GetBackupScheduleId() string {
	if m != nil {
		return m.BackupScheduleId
	}
	return ""
}

// Defines a request to delete a backup schedule
type SdkCloudBackupSchedDeleteRequest struct {
	// Id of cloud backup to delete
	BackupScheduleId     string   `protobuf:"bytes,1,opt,name=backup_schedule_id,json=backupScheduleId" json:"backup_schedule_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupSchedDeleteRequest) Reset()         { *m = SdkCloudBackupSchedDeleteRequest{} }
func (m *SdkCloudBackupSchedDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedDeleteRequest) ProtoMessage()    {}
func (*SdkCloudBackupSchedDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{186}
}
func (m *SdkCloudBackupSchedDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedDeleteRequest.Merge(dst, src)
}
func (m *SdkCloudBackupSchedDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteRequest.Size(m)
}
func (m *SdkCloudBackupSchedDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedDeleteRequest proto.InternalMessageInfo

func (m *SdkCloudBackupSchedDeleteRequest) GetBackupScheduleId() string {
	if m != nil {
		return m.BackupScheduleId
	}
	return ""
}

// Empty response
type SdkCloudBackupSchedDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupSchedDeleteResponse) Reset()         { *m = SdkCloudBackupSchedDeleteResponse{} }
func (m *SdkCloudBackupSchedDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedDeleteResponse) ProtoMessage()    {}
func (*SdkCloudBackupSchedDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{187}
}
func (m *SdkCloudBackupSchedDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedDeleteResponse.Merge(dst, src)
}
func (m *SdkCloudBackupSchedDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedDeleteResponse.Size(m)
}
func (m *SdkCloudBackupSchedDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedDeleteResponse proto.InternalMessageInfo

// Empty request
type SdkCloudBackupSchedEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudBackupSchedEnumerateRequest) Reset()         { *m = SdkCloudBackupSchedEnumerateRequest{} }
func (m *SdkCloudBackupSchedEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedEnumerateRequest) ProtoMessage()    {}
func (*SdkCloudBackupSchedEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{188}
}
func (m *SdkCloudBackupSchedEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest.Merge(dst, src)
}
func (m *SdkCloudBackupSchedEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest.Size(m)
}
func (m *SdkCloudBackupSchedEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedEnumerateRequest proto.InternalMessageInfo

// Defines a response containing a map listing the schedules for volume
// backups to a cloud provider
type SdkCloudBackupSchedEnumerateResponse struct {
	// Returns list of backup schedules
	CloudSchedList       map[string]*SdkCloudBackupScheduleInfo `protobuf:"bytes,1,rep,name=cloud_sched_list,json=cloudSchedList" json:"cloud_sched_list,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *SdkCloudBackupSchedEnumerateResponse) Reset()         { *m = SdkCloudBackupSchedEnumerateResponse{} }
func (m *SdkCloudBackupSchedEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudBackupSchedEnumerateResponse) ProtoMessage()    {}
func (*SdkCloudBackupSchedEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{189}
}
func (m *SdkCloudBackupSchedEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkCloudBackupSchedEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudBackupSchedEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse.Merge(dst, src)
}
func (m *SdkCloudBackupSchedEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse.Size(m)
}
func (m *SdkCloudBackupSchedEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudBackupSchedEnumerateResponse proto.InternalMessageInfo

func (m *SdkCloudBackupSchedEnumerateResponse) GetCloudSchedList() map[string]*SdkCloudBackupScheduleInfo {
	if m != nil {
		return m.CloudSchedList
	}
	return nil
}

//
// SdkRule is the message used to construct custom roles in the OpenStorage SDK.
//
// ### Format
// The following shows the supported format for SdkRule:
//
// * Services: Is the gRPC service name in `OpenStorage<service name>` in lowercase
// * Apis: Is the API name in the service in lowercase
//
// Values can also be set to `*`, or start or end with `*` to allow multiple matches in services or apis.
//
// ### Examples
//
// * Allow any call:
//
// ```yaml
// SdkRule:
//   - Services: ["*"]
//     Apis: ["*"]
// ```
//
// * Allow only cluster operations:
//
// ```yaml
// SdkRule:
//   - services: ["cluster"]
//     apis: ["*"]
// ```
//
// * Allow inspection of any object and listings of only volumes
//
// ```yaml
// SdkRule:
//   - Services: ["volumes"]
//     Apis: ["*enumerate*"]
//   - Services: ["*"]
//     Apis: ["inspect*"]
// ```
//
type SdkRule struct {
	// The gRPC service name in `OpenStorage<service name>` in lowercase
	Services []string `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// The API name in the service in lowercase
	Apis                 []string `protobuf:"bytes,2,rep,name=apis" json:"apis,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRule) Reset()         { *m = SdkRule{} }
func (m *SdkRule) String() string { return proto.CompactTextString(m) }
func (*SdkRule) ProtoMessage()    {}
func (*SdkRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{190}
}
func (m *SdkRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRule.Unmarshal(m, b)
}
func (m *SdkRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRule.Marshal(b, m, deterministic)
}
func (dst *SdkRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRule.Merge(dst, src)
}
func (m *SdkRule) XXX_Size() int {
	return xxx_messageInfo_SdkRule.Size(m)
}
func (m *SdkRule) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRule.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRule proto.InternalMessageInfo

func (m *SdkRule) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *SdkRule) GetApis() []string {
	if m != nil {
		return m.Apis
	}
	return nil
}

type SdkRole struct {
	Name                 string     `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Rules                []*SdkRule `protobuf:"bytes,2,rep,name=rules" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SdkRole) Reset()         { *m = SdkRole{} }
func (m *SdkRole) String() string { return proto.CompactTextString(m) }
func (*SdkRole) ProtoMessage()    {}
func (*SdkRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{191}
}
func (m *SdkRole) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRole.Unmarshal(m, b)
}
func (m *SdkRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRole.Marshal(b, m, deterministic)
}
func (dst *SdkRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRole.Merge(dst, src)
}
func (m *SdkRole) XXX_Size() int {
	return xxx_messageInfo_SdkRole.Size(m)
}
func (m *SdkRole) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRole.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRole proto.InternalMessageInfo

func (m *SdkRole) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdkRole) GetRules() []*SdkRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Defines a request for creating a role
type SdkRoleCreateRequest struct {
	// Role
	Role                 *SdkRole `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleCreateRequest) Reset()         { *m = SdkRoleCreateRequest{} }
func (m *SdkRoleCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkRoleCreateRequest) ProtoMessage()    {}
func (*SdkRoleCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{192}
}
func (m *SdkRoleCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleCreateRequest.Unmarshal(m, b)
}
func (m *SdkRoleCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkRoleCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleCreateRequest.Merge(dst, src)
}
func (m *SdkRoleCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkRoleCreateRequest.Size(m)
}
func (m *SdkRoleCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleCreateRequest proto.InternalMessageInfo

func (m *SdkRoleCreateRequest) GetRole() *SdkRole {
	if m != nil {
		return m.Role
	}
	return nil
}

// Response contains informaiton about the creation of the role
type SdkRoleCreateResponse struct {
	// Role created
	Role                 *SdkRole `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleCreateResponse) Reset()         { *m = SdkRoleCreateResponse{} }
func (m *SdkRoleCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkRoleCreateResponse) ProtoMessage()    {}
func (*SdkRoleCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{193}
}
func (m *SdkRoleCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleCreateResponse.Unmarshal(m, b)
}
func (m *SdkRoleCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkRoleCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleCreateResponse.Merge(dst, src)
}
func (m *SdkRoleCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkRoleCreateResponse.Size(m)
}
func (m *SdkRoleCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleCreateResponse proto.InternalMessageInfo

func (m *SdkRoleCreateResponse) GetRole() *SdkRole {
	if m != nil {
		return m.Role
	}
	return nil
}

// Empty request
type SdkRoleEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleEnumerateRequest) Reset()         { *m = SdkRoleEnumerateRequest{} }
func (m *SdkRoleEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkRoleEnumerateRequest) ProtoMessage()    {}
func (*SdkRoleEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{194}
}
func (m *SdkRoleEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkRoleEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkRoleEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleEnumerateRequest.Merge(dst, src)
}
func (m *SdkRoleEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkRoleEnumerateRequest.Size(m)
}
func (m *SdkRoleEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleEnumerateRequest proto.InternalMessageInfo

// Respose to enumerate all roles
type SdkRoleEnumerateResponse struct {
	// List of role names
	Names                []string `protobuf:"bytes,1,rep,name=names" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleEnumerateResponse) Reset()         { *m = SdkRoleEnumerateResponse{} }
func (m *SdkRoleEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkRoleEnumerateResponse) ProtoMessage()    {}
func (*SdkRoleEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{195}
}
func (m *SdkRoleEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkRoleEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkRoleEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleEnumerateResponse.Merge(dst, src)
}
func (m *SdkRoleEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkRoleEnumerateResponse.Size(m)
}
func (m *SdkRoleEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleEnumerateResponse proto.InternalMessageInfo

func (m *SdkRoleEnumerateResponse) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

// Defines a request to inspect a role
type SdkRoleInspectRequest struct {
	// Name of role
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleInspectRequest) Reset()         { *m = SdkRoleInspectRequest{} }
func (m *SdkRoleInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkRoleInspectRequest) ProtoMessage()    {}
func (*SdkRoleInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{196}
}
func (m *SdkRoleInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleInspectRequest.Unmarshal(m, b)
}
func (m *SdkRoleInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkRoleInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleInspectRequest.Merge(dst, src)
}
func (m *SdkRoleInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkRoleInspectRequest.Size(m)
}
func (m *SdkRoleInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleInspectRequest proto.InternalMessageInfo

func (m *SdkRoleInspectRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response to inspection request
type SdkRoleInspectResponse struct {
	// Role requested
	Role                 *SdkRole `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleInspectResponse) Reset()         { *m = SdkRoleInspectResponse{} }
func (m *SdkRoleInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkRoleInspectResponse) ProtoMessage()    {}
func (*SdkRoleInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{197}
}
func (m *SdkRoleInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleInspectResponse.Unmarshal(m, b)
}
func (m *SdkRoleInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkRoleInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleInspectResponse.Merge(dst, src)
}
func (m *SdkRoleInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkRoleInspectResponse.Size(m)
}
func (m *SdkRoleInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleInspectResponse proto.InternalMessageInfo

func (m *SdkRoleInspectResponse) GetRole() *SdkRole {
	if m != nil {
		return m.Role
	}
	return nil
}

// Defines a request to delete a role
type SdkRoleDeleteRequest struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleDeleteRequest) Reset()         { *m = SdkRoleDeleteRequest{} }
func (m *SdkRoleDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkRoleDeleteRequest) ProtoMessage()    {}
func (*SdkRoleDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{198}
}
func (m *SdkRoleDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleDeleteRequest.Unmarshal(m, b)
}
func (m *SdkRoleDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkRoleDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleDeleteRequest.Merge(dst, src)
}
func (m *SdkRoleDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkRoleDeleteRequest.Size(m)
}
func (m *SdkRoleDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleDeleteRequest proto.InternalMessageInfo

func (m *SdkRoleDeleteRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Empty response
type SdkRoleDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleDeleteResponse) Reset()         { *m = SdkRoleDeleteResponse{} }
func (m *SdkRoleDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkRoleDeleteResponse) ProtoMessage()    {}
func (*SdkRoleDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{199}
}
func (m *SdkRoleDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleDeleteResponse.Unmarshal(m, b)
}
func (m *SdkRoleDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkRoleDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleDeleteResponse.Merge(dst, src)
}
func (m *SdkRoleDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkRoleDeleteResponse.Size(m)
}
func (m *SdkRoleDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleDeleteResponse proto.InternalMessageInfo

// Defines a request to update an existing role
type SdkRoleUpdateRequest struct {
	// New role update
	Role                 *SdkRole `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleUpdateRequest) Reset()         { *m = SdkRoleUpdateRequest{} }
func (m *SdkRoleUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkRoleUpdateRequest) ProtoMessage()    {}
func (*SdkRoleUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{200}
}
func (m *SdkRoleUpdateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleUpdateRequest.Unmarshal(m, b)
}
func (m *SdkRoleUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleUpdateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkRoleUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleUpdateRequest.Merge(dst, src)
}
func (m *SdkRoleUpdateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkRoleUpdateRequest.Size(m)
}
func (m *SdkRoleUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleUpdateRequest proto.InternalMessageInfo

func (m *SdkRoleUpdateRequest) GetRole() *SdkRole {
	if m != nil {
		return m.Role
	}
	return nil
}

// Response contains information about the updated role
type SdkRoleUpdateResponse struct {
	// Role updated
	Role                 *SdkRole `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkRoleUpdateResponse) Reset()         { *m = SdkRoleUpdateResponse{} }
func (m *SdkRoleUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkRoleUpdateResponse) ProtoMessage()    {}
func (*SdkRoleUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{201}
}
func (m *SdkRoleUpdateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkRoleUpdateResponse.Unmarshal(m, b)
}
func (m *SdkRoleUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkRoleUpdateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkRoleUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkRoleUpdateResponse.Merge(dst, src)
}
func (m *SdkRoleUpdateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkRoleUpdateResponse.Size(m)
}
func (m *SdkRoleUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkRoleUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkRoleUpdateResponse proto.InternalMessageInfo

func (m *SdkRoleUpdateResponse) GetRole() *SdkRole {
	if m != nil {
		return m.Role
	}
	return nil
}

// Empty request
type SdkIdentityCapabilitiesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkIdentityCapabilitiesRequest) Reset()         { *m = SdkIdentityCapabilitiesRequest{} }
func (m *SdkIdentityCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*SdkIdentityCapabilitiesRequest) ProtoMessage()    {}
func (*SdkIdentityCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{202}
}
func (m *SdkIdentityCapabilitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkIdentityCapabilitiesRequest.Unmarshal(m, b)
}
func (m *SdkIdentityCapabilitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkIdentityCapabilitiesRequest.Marshal(b, m, deterministic)
}
func (dst *SdkIdentityCapabilitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkIdentityCapabilitiesRequest.Merge(dst, src)
}
func (m *SdkIdentityCapabilitiesRequest) XXX_Size() int {
	return xxx_messageInfo_SdkIdentityCapabilitiesRequest.Size(m)
}
func (m *SdkIdentityCapabilitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkIdentityCapabilitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkIdentityCapabilitiesRequest proto.InternalMessageInfo

// Defines a response containing the capabilites of the cluster
type SdkIdentityCapabilitiesResponse struct {
	// Provides all the capabilites supported by the cluster
	Capabilities         []*SdkServiceCapability `protobuf:"bytes,1,rep,name=capabilities" json:"capabilities,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *SdkIdentityCapabilitiesResponse) Reset()         { *m = SdkIdentityCapabilitiesResponse{} }
func (m *SdkIdentityCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*SdkIdentityCapabilitiesResponse) ProtoMessage()    {}
func (*SdkIdentityCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{203}
}
func (m *SdkIdentityCapabilitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkIdentityCapabilitiesResponse.Unmarshal(m, b)
}
func (m *SdkIdentityCapabilitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkIdentityCapabilitiesResponse.Marshal(b, m, deterministic)
}
func (dst *SdkIdentityCapabilitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkIdentityCapabilitiesResponse.Merge(dst, src)
}
func (m *SdkIdentityCapabilitiesResponse) XXX_Size() int {
	return xxx_messageInfo_SdkIdentityCapabilitiesResponse.Size(m)
}
func (m *SdkIdentityCapabilitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkIdentityCapabilitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkIdentityCapabilitiesResponse proto.InternalMessageInfo

func (m *SdkIdentityCapabilitiesResponse) GetCapabilities() []*SdkServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Empty request
type SdkIdentityVersionRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkIdentityVersionRequest) Reset()         { *m = SdkIdentityVersionRequest{} }
func (m *SdkIdentityVersionRequest) String() string { return proto.CompactTextString(m) }
func (*SdkIdentityVersionRequest) ProtoMessage()    {}
func (*SdkIdentityVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{204}
}
func (m *SdkIdentityVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkIdentityVersionRequest.Unmarshal(m, b)
}
func (m *SdkIdentityVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkIdentityVersionRequest.Marshal(b, m, deterministic)
}
func (dst *SdkIdentityVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkIdentityVersionRequest.Merge(dst, src)
}
func (m *SdkIdentityVersionRequest) XXX_Size() int {
	return xxx_messageInfo_SdkIdentityVersionRequest.Size(m)
}
func (m *SdkIdentityVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkIdentityVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkIdentityVersionRequest proto.InternalMessageInfo

// Defines a response containing version information
type SdkIdentityVersionResponse struct {
	// OpenStorage SDK version used by the server
	SdkVersion *SdkVersion `protobuf:"bytes,1,opt,name=sdk_version,json=sdkVersion" json:"sdk_version,omitempty"`
	// Version information about the storage system
	Version              *StorageVersion `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SdkIdentityVersionResponse) Reset()         { *m = SdkIdentityVersionResponse{} }
func (m *SdkIdentityVersionResponse) String() string { return proto.CompactTextString(m) }
func (*SdkIdentityVersionResponse) ProtoMessage()    {}
func (*SdkIdentityVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{205}
}
func (m *SdkIdentityVersionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkIdentityVersionResponse.Unmarshal(m, b)
}
func (m *SdkIdentityVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkIdentityVersionResponse.Marshal(b, m, deterministic)
}
func (dst *SdkIdentityVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkIdentityVersionResponse.Merge(dst, src)
}
func (m *SdkIdentityVersionResponse) XXX_Size() int {
	return xxx_messageInfo_SdkIdentityVersionResponse.Size(m)
}
func (m *SdkIdentityVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkIdentityVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkIdentityVersionResponse proto.InternalMessageInfo

func (m *SdkIdentityVersionResponse) GetSdkVersion() *SdkVersion {
	if m != nil {
		return m.SdkVersion
	}
	return nil
}

func (m *SdkIdentityVersionResponse) GetVersion() *StorageVersion {
	if m != nil {
		return m.Version
	}
	return nil
}

// Defines a capability of he cluster
type SdkServiceCapability struct {
	// Use oneof to have only one type of service defined making it
	// future proof to add other types.
	//
	// Types that are valid to be assigned to Type:
	//	*SdkServiceCapability_Service
	Type                 isSdkServiceCapability_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SdkServiceCapability) Reset()         { *m = SdkServiceCapability{} }
func (m *SdkServiceCapability) String() string { return proto.CompactTextString(m) }
func (*SdkServiceCapability) ProtoMessage()    {}
func (*SdkServiceCapability) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{206}
}
func (m *SdkServiceCapability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkServiceCapability.Unmarshal(m, b)
}
func (m *SdkServiceCapability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkServiceCapability.Marshal(b, m, deterministic)
}
func (dst *SdkServiceCapability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkServiceCapability.Merge(dst, src)
}
func (m *SdkServiceCapability) XXX_Size() int {
	return xxx_messageInfo_SdkServiceCapability.Size(m)
}
func (m *SdkServiceCapability) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkServiceCapability.DiscardUnknown(m)
}

var xxx_messageInfo_SdkServiceCapability proto.InternalMessageInfo

type isSdkServiceCapability_Type interface {
	isSdkServiceCapability_Type()
}

type SdkServiceCapability_Service struct {
	Service *SdkServiceCapability_OpenStorageService `protobuf:"bytes,1,opt,name=service,oneof"`
}

func (*SdkServiceCapability_Service) isSdkServiceCapability_Type() {}

func (m *SdkServiceCapability) GetType() isSdkServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *SdkServiceCapability) GetService() *SdkServiceCapability_OpenStorageService {
	if x, ok := m.GetType().(*SdkServiceCapability_Service); ok {
		return x.Service
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkServiceCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkServiceCapability_OneofMarshaler, _SdkServiceCapability_OneofUnmarshaler, _SdkServiceCapability_OneofSizer, []interface{}{
		(*SdkServiceCapability_Service)(nil),
	}
}

func _SdkServiceCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *SdkServiceCapability_Service:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Service); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkServiceCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _SdkServiceCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkServiceCapability)
	switch tag {
	case 1: // type.service
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkServiceCapability_OpenStorageService)
		err := b.DecodeMessage(msg)
		m.Type = &SdkServiceCapability_Service{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkServiceCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *SdkServiceCapability_Service:
		s := proto.Size(x.Service)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type SdkServiceCapability_OpenStorageService struct {
	// Type of service supported
	Type                 SdkServiceCapability_OpenStorageService_Type `protobuf:"varint,1,opt,name=type,enum=openstorage.api.SdkServiceCapability_OpenStorageService_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *SdkServiceCapability_OpenStorageService) Reset() {
	*m = SdkServiceCapability_OpenStorageService{}
}
func (m *SdkServiceCapability_OpenStorageService) String() string { return proto.CompactTextString(m) }
func (*SdkServiceCapability_OpenStorageService) ProtoMessage()    {}
func (*SdkServiceCapability_OpenStorageService) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{206, 0}
}
func (m *SdkServiceCapability_OpenStorageService) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkServiceCapability_OpenStorageService.Unmarshal(m, b)
}
func (m *SdkServiceCapability_OpenStorageService) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkServiceCapability_OpenStorageService.Marshal(b, m, deterministic)
}
func (dst *SdkServiceCapability_OpenStorageService) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkServiceCapability_OpenStorageService.Merge(dst, src)
}
func (m *SdkServiceCapability_OpenStorageService) XXX_Size() int {
	return xxx_messageInfo_SdkServiceCapability_OpenStorageService.Size(m)
}
func (m *SdkServiceCapability_OpenStorageService) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkServiceCapability_OpenStorageService.DiscardUnknown(m)
}

var xxx_messageInfo_SdkServiceCapability_OpenStorageService proto.InternalMessageInfo

func (m *SdkServiceCapability_OpenStorageService) GetType() SdkServiceCapability_OpenStorageService_Type {
	if m != nil {
		return m.Type
	}
	return SdkServiceCapability_OpenStorageService_UNKNOWN
}

// SDK version in Major.Minor.Patch format. The goal of this
// message is to provide clients a method to determine the SDK
// version run by an SDK server.
type SdkVersion struct {
	// SDK version major number
	Major int32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	// SDK version minor number
	Minor int32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	// SDK version patch number
	Patch int32 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	// String representation of the SDK version. Must be
	// in `major.minor.patch` format.
	Version              string   `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkVersion) Reset()         { *m = SdkVersion{} }
func (m *SdkVersion) String() string { return proto.CompactTextString(m) }
func (*SdkVersion) ProtoMessage()    {}
func (*SdkVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{207}
}
func (m *SdkVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkVersion.Unmarshal(m, b)
}
func (m *SdkVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkVersion.Marshal(b, m, deterministic)
}
func (dst *SdkVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkVersion.Merge(dst, src)
}
func (m *SdkVersion) XXX_Size() int {
	return xxx_messageInfo_SdkVersion.Size(m)
}
func (m *SdkVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkVersion.DiscardUnknown(m)
}

var xxx_messageInfo_SdkVersion proto.InternalMessageInfo

func (m *SdkVersion) GetMajor() int32 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *SdkVersion) GetMinor() int32 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *SdkVersion) GetPatch() int32 {
	if m != nil {
		return m.Patch
	}
	return 0
}

func (m *SdkVersion) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// Version information about the storage system
type StorageVersion struct {
	// OpenStorage driver name
	Driver string `protobuf:"bytes,1,opt,name=driver" json:"driver,omitempty"`
	// Version of the server
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// Extra information provided by the storage system
	Details              map[string]string `protobuf:"bytes,3,rep,name=details" json:"details,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *StorageVersion) Reset()         { *m = StorageVersion{} }
func (m *StorageVersion) String() string { return proto.CompactTextString(m) }
func (*StorageVersion) ProtoMessage()    {}
func (*StorageVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{208}
}
func (m *StorageVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageVersion.Unmarshal(m, b)
}
func (m *StorageVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageVersion.Marshal(b, m, deterministic)
}
func (dst *StorageVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageVersion.Merge(dst, src)
}
func (m *StorageVersion) XXX_Size() int {
	return xxx_messageInfo_StorageVersion.Size(m)
}
func (m *StorageVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageVersion.DiscardUnknown(m)
}

var xxx_messageInfo_StorageVersion proto.InternalMessageInfo

func (m *StorageVersion) GetDriver() string {
	if m != nil {
		return m.Driver
	}
	return ""
}

func (m *StorageVersion) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *StorageVersion) GetDetails() map[string]string {
	if m != nil {
		return m.Details
	}
	return nil
}

type CloudMigrate struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrate) Reset()         { *m = CloudMigrate{} }
func (m *CloudMigrate) String() string { return proto.CompactTextString(m) }
func (*CloudMigrate) ProtoMessage()    {}
func (*CloudMigrate) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{209}
}
func (m *CloudMigrate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrate.Unmarshal(m, b)
}
func (m *CloudMigrate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrate.Marshal(b, m, deterministic)
}
func (dst *CloudMigrate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrate.Merge(dst, src)
}
func (m *CloudMigrate) XXX_Size() int {
	return xxx_messageInfo_CloudMigrate.Size(m)
}
func (m *CloudMigrate) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrate.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrate proto.InternalMessageInfo

// Request to start a cloud migration
type CloudMigrateStartRequest struct {
	// The type of operation to start
	Operation CloudMigrate_OperationType `protobuf:"varint,1,opt,name=operation,enum=openstorage.api.CloudMigrate_OperationType" json:"operation,omitempty"`
	// ID of the cluster to which volumes are to be migrated
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Depending on the operation type this can be a VolumeID or VolumeGroupID
	TargetId string `protobuf:"bytes,3,opt,name=target_id,json=targetId" json:"target_id,omitempty"`
	// (Optional) Unique TaskId assocaiated with this migration. If not provided one will
	// be generated and returned in the response
	TaskId               string   `protobuf:"bytes,4,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrateStartRequest) Reset()         { *m = CloudMigrateStartRequest{} }
func (m *CloudMigrateStartRequest) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateStartRequest) ProtoMessage()    {}
func (*CloudMigrateStartRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{210}
}
func (m *CloudMigrateStartRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateStartRequest.Unmarshal(m, b)
}
func (m *CloudMigrateStartRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateStartRequest.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateStartRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateStartRequest.Merge(dst, src)
}
func (m *CloudMigrateStartRequest) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateStartRequest.Size(m)
}
func (m *CloudMigrateStartRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateStartRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateStartRequest proto.InternalMessageInfo

func (m *CloudMigrateStartRequest) GetOperation() CloudMigrate_OperationType {
	if m != nil {
		return m.Operation
	}
	return CloudMigrate_InvalidType
}

func (m *CloudMigrateStartRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CloudMigrateStartRequest) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *CloudMigrateStartRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a migration request
type SdkCloudMigrateStartRequest struct {
	// ID of the cluster to which volumes are to be migrated
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Unique name assocaiated with this migration.
	// This is a Optional field for idempotency
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	// Types that are valid to be assigned to Opt:
	//	*SdkCloudMigrateStartRequest_Volume
	//	*SdkCloudMigrateStartRequest_VolumeGroup
	//	*SdkCloudMigrateStartRequest_AllVolumes
	Opt                  isSdkCloudMigrateStartRequest_Opt `protobuf_oneof:"opt"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *SdkCloudMigrateStartRequest) Reset()         { *m = SdkCloudMigrateStartRequest{} }
func (m *SdkCloudMigrateStartRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateStartRequest) ProtoMessage()    {}
func (*SdkCloudMigrateStartRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{211}
}
func (m *SdkCloudMigrateStartRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStartRequest.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStartRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStartRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStartRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStartRequest.Merge(dst, src)
}
func (m *SdkCloudMigrateStartRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStartRequest.Size(m)
}
func (m *SdkCloudMigrateStartRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStartRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStartRequest proto.InternalMessageInfo

type isSdkCloudMigrateStartRequest_Opt interface {
	isSdkCloudMigrateStartRequest_Opt()
}

type SdkCloudMigrateStartRequest_Volume struct {
	Volume *SdkCloudMigrateStartRequest_MigrateVolume `protobuf:"bytes,200,opt,name=volume,oneof"`
}
type SdkCloudMigrateStartRequest_VolumeGroup struct {
	VolumeGroup *SdkCloudMigrateStartRequest_MigrateVolumeGroup `protobuf:"bytes,201,opt,name=volume_group,json=volumeGroup,oneof"`
}
type SdkCloudMigrateStartRequest_AllVolumes struct {
	AllVolumes *SdkCloudMigrateStartRequest_MigrateAllVolumes `protobuf:"bytes,202,opt,name=all_volumes,json=allVolumes,oneof"`
}

func (*SdkCloudMigrateStartRequest_Volume) isSdkCloudMigrateStartRequest_Opt()      {}
func (*SdkCloudMigrateStartRequest_VolumeGroup) isSdkCloudMigrateStartRequest_Opt() {}
func (*SdkCloudMigrateStartRequest_AllVolumes) isSdkCloudMigrateStartRequest_Opt()  {}

func (m *SdkCloudMigrateStartRequest) GetOpt() isSdkCloudMigrateStartRequest_Opt {
	if m != nil {
		return m.Opt
	}
	return nil
}

func (m *SdkCloudMigrateStartRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SdkCloudMigrateStartRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *SdkCloudMigrateStartRequest) GetVolume() *SdkCloudMigrateStartRequest_MigrateVolume {
	if x, ok := m.GetOpt().(*SdkCloudMigrateStartRequest_Volume); ok {
		return x.Volume
	}
	return nil
}

func (m *SdkCloudMigrateStartRequest) GetVolumeGroup() *SdkCloudMigrateStartRequest_MigrateVolumeGroup {
	if x, ok := m.GetOpt().(*SdkCloudMigrateStartRequest_VolumeGroup); ok {
		return x.VolumeGroup
	}
	return nil
}

func (m *SdkCloudMigrateStartRequest) GetAllVolumes() *SdkCloudMigrateStartRequest_MigrateAllVolumes {
	if x, ok := m.GetOpt().(*SdkCloudMigrateStartRequest_AllVolumes); ok {
		return x.AllVolumes
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SdkCloudMigrateStartRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SdkCloudMigrateStartRequest_OneofMarshaler, _SdkCloudMigrateStartRequest_OneofUnmarshaler, _SdkCloudMigrateStartRequest_OneofSizer, []interface{}{
		(*SdkCloudMigrateStartRequest_Volume)(nil),
		(*SdkCloudMigrateStartRequest_VolumeGroup)(nil),
		(*SdkCloudMigrateStartRequest_AllVolumes)(nil),
	}
}

func _SdkCloudMigrateStartRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SdkCloudMigrateStartRequest)
	// opt
	switch x := m.Opt.(type) {
	case *SdkCloudMigrateStartRequest_Volume:
		b.EncodeVarint(200<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Volume); err != nil {
			return err
		}
	case *SdkCloudMigrateStartRequest_VolumeGroup:
		b.EncodeVarint(201<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VolumeGroup); err != nil {
			return err
		}
	case *SdkCloudMigrateStartRequest_AllVolumes:
		b.EncodeVarint(202<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AllVolumes); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SdkCloudMigrateStartRequest.Opt has unexpected type %T", x)
	}
	return nil
}

func _SdkCloudMigrateStartRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SdkCloudMigrateStartRequest)
	switch tag {
	case 200: // opt.volume
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkCloudMigrateStartRequest_MigrateVolume)
		err := b.DecodeMessage(msg)
		m.Opt = &SdkCloudMigrateStartRequest_Volume{msg}
		return true, err
	case 201: // opt.volume_group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkCloudMigrateStartRequest_MigrateVolumeGroup)
		err := b.DecodeMessage(msg)
		m.Opt = &SdkCloudMigrateStartRequest_VolumeGroup{msg}
		return true, err
	case 202: // opt.all_volumes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkCloudMigrateStartRequest_MigrateAllVolumes)
		err := b.DecodeMessage(msg)
		m.Opt = &SdkCloudMigrateStartRequest_AllVolumes{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SdkCloudMigrateStartRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SdkCloudMigrateStartRequest)
	// opt
	switch x := m.Opt.(type) {
	case *SdkCloudMigrateStartRequest_Volume:
		s := proto.Size(x.Volume)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCloudMigrateStartRequest_VolumeGroup:
		s := proto.Size(x.VolumeGroup)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SdkCloudMigrateStartRequest_AllVolumes:
		s := proto.Size(x.AllVolumes)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines a migration request for a volume
type SdkCloudMigrateStartRequest_MigrateVolume struct {
	VolumeId             string   `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudMigrateStartRequest_MigrateVolume) Reset() {
	*m = SdkCloudMigrateStartRequest_MigrateVolume{}
}
func (m *SdkCloudMigrateStartRequest_MigrateVolume) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateStartRequest_MigrateVolume) ProtoMessage()    {}
func (*SdkCloudMigrateStartRequest_MigrateVolume) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{211, 0}
}
func (m *SdkCloudMigrateStartRequest_MigrateVolume) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolume) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStartRequest_MigrateVolume) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume.Merge(dst, src)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolume) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume.Size(m)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolume) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolume proto.InternalMessageInfo

func (m *SdkCloudMigrateStartRequest_MigrateVolume) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

// Defines a migration request for a volume group
type SdkCloudMigrateStartRequest_MigrateVolumeGroup struct {
	GroupId              string   `protobuf:"bytes,1,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) Reset() {
	*m = SdkCloudMigrateStartRequest_MigrateVolumeGroup{}
}
func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) String() string {
	return proto.CompactTextString(m)
}
func (*SdkCloudMigrateStartRequest_MigrateVolumeGroup) ProtoMessage() {}
func (*SdkCloudMigrateStartRequest_MigrateVolumeGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{211, 1}
}
func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStartRequest_MigrateVolumeGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup.Merge(dst, src)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup.Size(m)
}
func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateVolumeGroup proto.InternalMessageInfo

func (m *SdkCloudMigrateStartRequest_MigrateVolumeGroup) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

// Defines a migration request for all volumes in a cluster
type SdkCloudMigrateStartRequest_MigrateAllVolumes struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) Reset() {
	*m = SdkCloudMigrateStartRequest_MigrateAllVolumes{}
}
func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) String() string {
	return proto.CompactTextString(m)
}
func (*SdkCloudMigrateStartRequest_MigrateAllVolumes) ProtoMessage() {}
func (*SdkCloudMigrateStartRequest_MigrateAllVolumes) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{211, 2}
}
func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStartRequest_MigrateAllVolumes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes.Merge(dst, src)
}
func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes.Size(m)
}
func (m *SdkCloudMigrateStartRequest_MigrateAllVolumes) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStartRequest_MigrateAllVolumes proto.InternalMessageInfo

// Response to start a cloud migration
type CloudMigrateStartResponse struct {
	// TaskId assocaiated with the migration that was started
	TaskId               string   `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrateStartResponse) Reset()         { *m = CloudMigrateStartResponse{} }
func (m *CloudMigrateStartResponse) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateStartResponse) ProtoMessage()    {}
func (*CloudMigrateStartResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{212}
}
func (m *CloudMigrateStartResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateStartResponse.Unmarshal(m, b)
}
func (m *CloudMigrateStartResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateStartResponse.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateStartResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateStartResponse.Merge(dst, src)
}
func (m *CloudMigrateStartResponse) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateStartResponse.Size(m)
}
func (m *CloudMigrateStartResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateStartResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateStartResponse proto.InternalMessageInfo

func (m *CloudMigrateStartResponse) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a response for the migration that was started
type SdkCloudMigrateStartResponse struct {
	// Result assocaiated with the migration that was started
	Result               *CloudMigrateStartResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SdkCloudMigrateStartResponse) Reset()         { *m = SdkCloudMigrateStartResponse{} }
func (m *SdkCloudMigrateStartResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateStartResponse) ProtoMessage()    {}
func (*SdkCloudMigrateStartResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{213}
}
func (m *SdkCloudMigrateStartResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStartResponse.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStartResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStartResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStartResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStartResponse.Merge(dst, src)
}
func (m *SdkCloudMigrateStartResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStartResponse.Size(m)
}
func (m *SdkCloudMigrateStartResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStartResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStartResponse proto.InternalMessageInfo

func (m *SdkCloudMigrateStartResponse) GetResult() *CloudMigrateStartResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

// Request to stop a cloud migration
type CloudMigrateCancelRequest struct {
	// The id of the task to cancel
	TaskId               string   `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrateCancelRequest) Reset()         { *m = CloudMigrateCancelRequest{} }
func (m *CloudMigrateCancelRequest) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateCancelRequest) ProtoMessage()    {}
func (*CloudMigrateCancelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{214}
}
func (m *CloudMigrateCancelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateCancelRequest.Unmarshal(m, b)
}
func (m *CloudMigrateCancelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateCancelRequest.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateCancelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateCancelRequest.Merge(dst, src)
}
func (m *CloudMigrateCancelRequest) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateCancelRequest.Size(m)
}
func (m *CloudMigrateCancelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateCancelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateCancelRequest proto.InternalMessageInfo

func (m *CloudMigrateCancelRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

// Defines a request to stop a cloud migration
type SdkCloudMigrateCancelRequest struct {
	// Request containing the task id to be cancelled
	Request              *CloudMigrateCancelRequest `protobuf:"bytes,1,opt,name=request" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SdkCloudMigrateCancelRequest) Reset()         { *m = SdkCloudMigrateCancelRequest{} }
func (m *SdkCloudMigrateCancelRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateCancelRequest) ProtoMessage()    {}
func (*SdkCloudMigrateCancelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{215}
}
func (m *SdkCloudMigrateCancelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateCancelRequest.Unmarshal(m, b)
}
func (m *SdkCloudMigrateCancelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateCancelRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateCancelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateCancelRequest.Merge(dst, src)
}
func (m *SdkCloudMigrateCancelRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateCancelRequest.Size(m)
}
func (m *SdkCloudMigrateCancelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateCancelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateCancelRequest proto.InternalMessageInfo

func (m *SdkCloudMigrateCancelRequest) GetRequest() *CloudMigrateCancelRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

// Empty Response
type SdkCloudMigrateCancelResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkCloudMigrateCancelResponse) Reset()         { *m = SdkCloudMigrateCancelResponse{} }
func (m *SdkCloudMigrateCancelResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateCancelResponse) ProtoMessage()    {}
func (*SdkCloudMigrateCancelResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{216}
}
func (m *SdkCloudMigrateCancelResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateCancelResponse.Unmarshal(m, b)
}
func (m *SdkCloudMigrateCancelResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateCancelResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateCancelResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateCancelResponse.Merge(dst, src)
}
func (m *SdkCloudMigrateCancelResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateCancelResponse.Size(m)
}
func (m *SdkCloudMigrateCancelResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateCancelResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateCancelResponse proto.InternalMessageInfo

type CloudMigrateInfo struct {
	// Task id associated with this migration
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	// ID of the cluster where the volume is being migrated
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// ID of the volume on the local cluster
	LocalVolumeId string `protobuf:"bytes,3,opt,name=local_volume_id,json=localVolumeId" json:"local_volume_id,omitempty"`
	// Name of the volume on the local cluster
	LocalVolumeName string `protobuf:"bytes,4,opt,name=local_volume_name,json=localVolumeName" json:"local_volume_name,omitempty"`
	// ID of the volume on the remote cluster
	RemoteVolumeId string `protobuf:"bytes,5,opt,name=remote_volume_id,json=remoteVolumeId" json:"remote_volume_id,omitempty"`
	// ID of the cloudbackup used for the migration
	CloudbackupId string `protobuf:"bytes,6,opt,name=cloudbackup_id,json=cloudbackupId" json:"cloudbackup_id,omitempty"`
	// Current stage of the volume migration
	CurrentStage CloudMigrate_Stage `protobuf:"varint,7,opt,name=current_stage,json=currentStage,enum=openstorage.api.CloudMigrate_Stage" json:"current_stage,omitempty"`
	// Status of the current stage
	Status CloudMigrate_Status `protobuf:"varint,8,opt,name=status,enum=openstorage.api.CloudMigrate_Status" json:"status,omitempty"`
	// Last time the status was updated
	LastUpdate *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_update,json=lastUpdate" json:"last_update,omitempty"`
	// Contains the reason for the migration error
	ErrorReason string `protobuf:"bytes,10,opt,name=error_reason,json=errorReason" json:"error_reason,omitempty"`
	// StartTime indicates Op's start time
	StartTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// CompletedTime indicates Op's completed time
	CompletedTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=completed_time,json=completedTime" json:"completed_time,omitempty"`
	// BytesTotal is the number of bytes being transferred
	BytesTotal uint64 `protobuf:"varint,13,opt,name=bytes_total,json=bytesTotal" json:"bytes_total,omitempty"`
	// BytesDone is the number of bytes already transferred
	BytesDone uint64 `protobuf:"varint,14,opt,name=bytes_done,json=bytesDone" json:"bytes_done,omitempty"`
	// ETASeconds the time duration in seconds for cloud migration completion
	EtaSeconds           int64    `protobuf:"varint,15,opt,name=eta_seconds,json=etaSeconds" json:"eta_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrateInfo) Reset()         { *m = CloudMigrateInfo{} }
func (m *CloudMigrateInfo) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateInfo) ProtoMessage()    {}
func (*CloudMigrateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{217}
}
func (m *CloudMigrateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateInfo.Unmarshal(m, b)
}
func (m *CloudMigrateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateInfo.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateInfo.Merge(dst, src)
}
func (m *CloudMigrateInfo) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateInfo.Size(m)
}
func (m *CloudMigrateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateInfo proto.InternalMessageInfo

func (m *CloudMigrateInfo) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *CloudMigrateInfo) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CloudMigrateInfo) GetLocalVolumeId() string {
	if m != nil {
		return m.LocalVolumeId
	}
	return ""
}

func (m *CloudMigrateInfo) GetLocalVolumeName() string {
	if m != nil {
		return m.LocalVolumeName
	}
	return ""
}

func (m *CloudMigrateInfo) GetRemoteVolumeId() string {
	if m != nil {
		return m.RemoteVolumeId
	}
	return ""
}

func (m *CloudMigrateInfo) GetCloudbackupId() string {
	if m != nil {
		return m.CloudbackupId
	}
	return ""
}

func (m *CloudMigrateInfo) GetCurrentStage() CloudMigrate_Stage {
	if m != nil {
		return m.CurrentStage
	}
	return CloudMigrate_InvalidStage
}

func (m *CloudMigrateInfo) GetStatus() CloudMigrate_Status {
	if m != nil {
		return m.Status
	}
	return CloudMigrate_InvalidStatus
}

func (m *CloudMigrateInfo) GetLastUpdate() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdate
	}
	return nil
}

func (m *CloudMigrateInfo) GetErrorReason() string {
	if m != nil {
		return m.ErrorReason
	}
	return ""
}

func (m *CloudMigrateInfo) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *CloudMigrateInfo) GetCompletedTime() *timestamp.Timestamp {
	if m != nil {
		return m.CompletedTime
	}
	return nil
}

func (m *CloudMigrateInfo) GetBytesTotal() uint64 {
	if m != nil {
		return m.BytesTotal
	}
	return 0
}

func (m *CloudMigrateInfo) GetBytesDone() uint64 {
	if m != nil {
		return m.BytesDone
	}
	return 0
}

func (m *CloudMigrateInfo) GetEtaSeconds() int64 {
	if m != nil {
		return m.EtaSeconds
	}
	return 0
}

type CloudMigrateInfoList struct {
	List                 []*CloudMigrateInfo `protobuf:"bytes,1,rep,name=list" json:"list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CloudMigrateInfoList) Reset()         { *m = CloudMigrateInfoList{} }
func (m *CloudMigrateInfoList) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateInfoList) ProtoMessage()    {}
func (*CloudMigrateInfoList) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{218}
}
func (m *CloudMigrateInfoList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateInfoList.Unmarshal(m, b)
}
func (m *CloudMigrateInfoList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateInfoList.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateInfoList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateInfoList.Merge(dst, src)
}
func (m *CloudMigrateInfoList) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateInfoList.Size(m)
}
func (m *CloudMigrateInfoList) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateInfoList.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateInfoList proto.InternalMessageInfo

func (m *CloudMigrateInfoList) GetList() []*CloudMigrateInfo {
	if m != nil {
		return m.List
	}
	return nil
}

// Request for cloud migration operation status
type SdkCloudMigrateStatusRequest struct {
	// Request contains the task id and cluster id for which status should be
	// returned
	Request              *CloudMigrateStatusRequest `protobuf:"bytes,1,opt,name=request" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SdkCloudMigrateStatusRequest) Reset()         { *m = SdkCloudMigrateStatusRequest{} }
func (m *SdkCloudMigrateStatusRequest) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateStatusRequest) ProtoMessage()    {}
func (*SdkCloudMigrateStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{219}
}
func (m *SdkCloudMigrateStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStatusRequest.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStatusRequest.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStatusRequest.Merge(dst, src)
}
func (m *SdkCloudMigrateStatusRequest) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStatusRequest.Size(m)
}
func (m *SdkCloudMigrateStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStatusRequest proto.InternalMessageInfo

func (m *SdkCloudMigrateStatusRequest) GetRequest() *CloudMigrateStatusRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

// Request for cloud migration operation status
type CloudMigrateStatusRequest struct {
	// Task id for which to return status
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId" json:"task_id,omitempty"`
	// ID of the cluster for which to return migration statuses
	ClusterId            string   `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudMigrateStatusRequest) Reset()         { *m = CloudMigrateStatusRequest{} }
func (m *CloudMigrateStatusRequest) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateStatusRequest) ProtoMessage()    {}
func (*CloudMigrateStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{220}
}
func (m *CloudMigrateStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateStatusRequest.Unmarshal(m, b)
}
func (m *CloudMigrateStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateStatusRequest.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateStatusRequest.Merge(dst, src)
}
func (m *CloudMigrateStatusRequest) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateStatusRequest.Size(m)
}
func (m *CloudMigrateStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateStatusRequest proto.InternalMessageInfo

func (m *CloudMigrateStatusRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *CloudMigrateStatusRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Response with a status of the cloud migration operations
type CloudMigrateStatusResponse struct {
	// Map of cluster id to the status of volumes being migrated
	Info                 map[string]*CloudMigrateInfoList `protobuf:"bytes,1,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *CloudMigrateStatusResponse) Reset()         { *m = CloudMigrateStatusResponse{} }
func (m *CloudMigrateStatusResponse) String() string { return proto.CompactTextString(m) }
func (*CloudMigrateStatusResponse) ProtoMessage()    {}
func (*CloudMigrateStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{221}
}
func (m *CloudMigrateStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudMigrateStatusResponse.Unmarshal(m, b)
}
func (m *CloudMigrateStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudMigrateStatusResponse.Marshal(b, m, deterministic)
}
func (dst *CloudMigrateStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudMigrateStatusResponse.Merge(dst, src)
}
func (m *CloudMigrateStatusResponse) XXX_Size() int {
	return xxx_messageInfo_CloudMigrateStatusResponse.Size(m)
}
func (m *CloudMigrateStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudMigrateStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CloudMigrateStatusResponse proto.InternalMessageInfo

func (m *CloudMigrateStatusResponse) GetInfo() map[string]*CloudMigrateInfoList {
	if m != nil {
		return m.Info
	}
	return nil
}

// Defines a response for the status request
type SdkCloudMigrateStatusResponse struct {
	// Status of all migration requests
	Result               *CloudMigrateStatusResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SdkCloudMigrateStatusResponse) Reset()         { *m = SdkCloudMigrateStatusResponse{} }
func (m *SdkCloudMigrateStatusResponse) String() string { return proto.CompactTextString(m) }
func (*SdkCloudMigrateStatusResponse) ProtoMessage()    {}
func (*SdkCloudMigrateStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{222}
}
func (m *SdkCloudMigrateStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkCloudMigrateStatusResponse.Unmarshal(m, b)
}
func (m *SdkCloudMigrateStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkCloudMigrateStatusResponse.Marshal(b, m, deterministic)
}
func (dst *SdkCloudMigrateStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkCloudMigrateStatusResponse.Merge(dst, src)
}
func (m *SdkCloudMigrateStatusResponse) XXX_Size() int {
	return xxx_messageInfo_SdkCloudMigrateStatusResponse.Size(m)
}
func (m *SdkCloudMigrateStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkCloudMigrateStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkCloudMigrateStatusResponse proto.InternalMessageInfo

func (m *SdkCloudMigrateStatusResponse) GetResult() *CloudMigrateStatusResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

type ClusterPairMode struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterPairMode) Reset()         { *m = ClusterPairMode{} }
func (m *ClusterPairMode) String() string { return proto.CompactTextString(m) }
func (*ClusterPairMode) ProtoMessage()    {}
func (*ClusterPairMode) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{223}
}
func (m *ClusterPairMode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairMode.Unmarshal(m, b)
}
func (m *ClusterPairMode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairMode.Marshal(b, m, deterministic)
}
func (dst *ClusterPairMode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairMode.Merge(dst, src)
}
func (m *ClusterPairMode) XXX_Size() int {
	return xxx_messageInfo_ClusterPairMode.Size(m)
}
func (m *ClusterPairMode) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairMode.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairMode proto.InternalMessageInfo

// Used to send a request to create a cluster pair
type ClusterPairCreateRequest struct {
	// IP of the remote cluster
	RemoteClusterIp string `protobuf:"bytes,1,opt,name=remote_cluster_ip,json=remoteClusterIp" json:"remote_cluster_ip,omitempty"`
	// Port for the remote cluster
	RemoteClusterPort uint32 `protobuf:"varint,2,opt,name=remote_cluster_port,json=remoteClusterPort" json:"remote_cluster_port,omitempty"`
	// Token used to authenticate with the remote cluster
	RemoteClusterToken string `protobuf:"bytes,3,opt,name=remote_cluster_token,json=remoteClusterToken" json:"remote_cluster_token,omitempty"`
	// Set the new pair as the default
	SetDefault bool `protobuf:"varint,4,opt,name=set_default,json=setDefault" json:"set_default,omitempty"`
	// The mode to use for the cluster pair
	Mode                 ClusterPairMode_Mode `protobuf:"varint,5,opt,name=mode,enum=openstorage.api.ClusterPairMode_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterPairCreateRequest) Reset()         { *m = ClusterPairCreateRequest{} }
func (m *ClusterPairCreateRequest) String() string { return proto.CompactTextString(m) }
func (*ClusterPairCreateRequest) ProtoMessage()    {}
func (*ClusterPairCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{224}
}
func (m *ClusterPairCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairCreateRequest.Unmarshal(m, b)
}
func (m *ClusterPairCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairCreateRequest.Marshal(b, m, deterministic)
}
func (dst *ClusterPairCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairCreateRequest.Merge(dst, src)
}
func (m *ClusterPairCreateRequest) XXX_Size() int {
	return xxx_messageInfo_ClusterPairCreateRequest.Size(m)
}
func (m *ClusterPairCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairCreateRequest proto.InternalMessageInfo

func (m *ClusterPairCreateRequest) GetRemoteClusterIp() string {
	if m != nil {
		return m.RemoteClusterIp
	}
	return ""
}

func (m *ClusterPairCreateRequest) GetRemoteClusterPort() uint32 {
	if m != nil {
		return m.RemoteClusterPort
	}
	return 0
}

func (m *ClusterPairCreateRequest) GetRemoteClusterToken() string {
	if m != nil {
		return m.RemoteClusterToken
	}
	return ""
}

func (m *ClusterPairCreateRequest) GetSetDefault() bool {
	if m != nil {
		return m.SetDefault
	}
	return false
}

func (m *ClusterPairCreateRequest) GetMode() ClusterPairMode_Mode {
	if m != nil {
		return m.Mode
	}
	return ClusterPairMode_Default
}

// Response for a pair request
type ClusterPairCreateResponse struct {
	// ID of the remote cluster
	RemoteClusterId string `protobuf:"bytes,1,opt,name=remote_cluster_id,json=remoteClusterId" json:"remote_cluster_id,omitempty"`
	// Name of the remote cluster
	RemoteClusterName    string   `protobuf:"bytes,2,opt,name=remote_cluster_name,json=remoteClusterName" json:"remote_cluster_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterPairCreateResponse) Reset()         { *m = ClusterPairCreateResponse{} }
func (m *ClusterPairCreateResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterPairCreateResponse) ProtoMessage()    {}
func (*ClusterPairCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{225}
}
func (m *ClusterPairCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairCreateResponse.Unmarshal(m, b)
}
func (m *ClusterPairCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairCreateResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterPairCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairCreateResponse.Merge(dst, src)
}
func (m *ClusterPairCreateResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterPairCreateResponse.Size(m)
}
func (m *ClusterPairCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairCreateResponse proto.InternalMessageInfo

func (m *ClusterPairCreateResponse) GetRemoteClusterId() string {
	if m != nil {
		return m.RemoteClusterId
	}
	return ""
}

func (m *ClusterPairCreateResponse) GetRemoteClusterName() string {
	if m != nil {
		return m.RemoteClusterName
	}
	return ""
}

// Defines a request for creating a cluster pair
type SdkClusterPairCreateRequest struct {
	Request              *ClusterPairCreateRequest `protobuf:"bytes,1,opt,name=request" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SdkClusterPairCreateRequest) Reset()         { *m = SdkClusterPairCreateRequest{} }
func (m *SdkClusterPairCreateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairCreateRequest) ProtoMessage()    {}
func (*SdkClusterPairCreateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{226}
}
func (m *SdkClusterPairCreateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairCreateRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairCreateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairCreateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairCreateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairCreateRequest.Merge(dst, src)
}
func (m *SdkClusterPairCreateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairCreateRequest.Size(m)
}
func (m *SdkClusterPairCreateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairCreateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairCreateRequest proto.InternalMessageInfo

func (m *SdkClusterPairCreateRequest) GetRequest() *ClusterPairCreateRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

// Defines a result of the cluster pair
type SdkClusterPairCreateResponse struct {
	// Contains the information about cluster pair
	Result               *ClusterPairCreateResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SdkClusterPairCreateResponse) Reset()         { *m = SdkClusterPairCreateResponse{} }
func (m *SdkClusterPairCreateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairCreateResponse) ProtoMessage()    {}
func (*SdkClusterPairCreateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{227}
}
func (m *SdkClusterPairCreateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairCreateResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairCreateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairCreateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairCreateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairCreateResponse.Merge(dst, src)
}
func (m *SdkClusterPairCreateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairCreateResponse.Size(m)
}
func (m *SdkClusterPairCreateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairCreateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairCreateResponse proto.InternalMessageInfo

func (m *SdkClusterPairCreateResponse) GetResult() *ClusterPairCreateResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

// Used to process a pair request from a remote cluster
type ClusterPairProcessRequest struct {
	// ID of the cluster requesting the pairing
	SourceClusterId string `protobuf:"bytes,1,opt,name=source_cluster_id,json=sourceClusterId" json:"source_cluster_id,omitempty"`
	// Token used to authenticate with the remote cluster
	RemoteClusterToken string `protobuf:"bytes,2,opt,name=remote_cluster_token,json=remoteClusterToken" json:"remote_cluster_token,omitempty"`
	// The mode to use for the cluster pair
	Mode                 ClusterPairMode_Mode `protobuf:"varint,3,opt,name=mode,enum=openstorage.api.ClusterPairMode_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterPairProcessRequest) Reset()         { *m = ClusterPairProcessRequest{} }
func (m *ClusterPairProcessRequest) String() string { return proto.CompactTextString(m) }
func (*ClusterPairProcessRequest) ProtoMessage()    {}
func (*ClusterPairProcessRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{228}
}
func (m *ClusterPairProcessRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairProcessRequest.Unmarshal(m, b)
}
func (m *ClusterPairProcessRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairProcessRequest.Marshal(b, m, deterministic)
}
func (dst *ClusterPairProcessRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairProcessRequest.Merge(dst, src)
}
func (m *ClusterPairProcessRequest) XXX_Size() int {
	return xxx_messageInfo_ClusterPairProcessRequest.Size(m)
}
func (m *ClusterPairProcessRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairProcessRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairProcessRequest proto.InternalMessageInfo

func (m *ClusterPairProcessRequest) GetSourceClusterId() string {
	if m != nil {
		return m.SourceClusterId
	}
	return ""
}

func (m *ClusterPairProcessRequest) GetRemoteClusterToken() string {
	if m != nil {
		return m.RemoteClusterToken
	}
	return ""
}

func (m *ClusterPairProcessRequest) GetMode() ClusterPairMode_Mode {
	if m != nil {
		return m.Mode
	}
	return ClusterPairMode_Default
}

// Response after a pairing has been processed
type ClusterPairProcessResponse struct {
	// ID of the cluster which processed the pair request
	RemoteClusterId string `protobuf:"bytes,1,opt,name=remote_cluster_id,json=remoteClusterId" json:"remote_cluster_id,omitempty"`
	// Name of the cluster which processed the pair request
	RemoteClusterName string `protobuf:"bytes,2,opt,name=remote_cluster_name,json=remoteClusterName" json:"remote_cluster_name,omitempty"`
	// List of endpoints that can be used to communicate with the cluster
	RemoteClusterEndpoints []string `protobuf:"bytes,3,rep,name=remote_cluster_endpoints,json=remoteClusterEndpoints" json:"remote_cluster_endpoints,omitempty"`
	// Key/value pair of options returned on successful pairing.
	// Opaque to openstorage and interpreted by the drivers
	Options              map[string]string `protobuf:"bytes,4,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ClusterPairProcessResponse) Reset()         { *m = ClusterPairProcessResponse{} }
func (m *ClusterPairProcessResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterPairProcessResponse) ProtoMessage()    {}
func (*ClusterPairProcessResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{229}
}
func (m *ClusterPairProcessResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairProcessResponse.Unmarshal(m, b)
}
func (m *ClusterPairProcessResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairProcessResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterPairProcessResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairProcessResponse.Merge(dst, src)
}
func (m *ClusterPairProcessResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterPairProcessResponse.Size(m)
}
func (m *ClusterPairProcessResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairProcessResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairProcessResponse proto.InternalMessageInfo

func (m *ClusterPairProcessResponse) GetRemoteClusterId() string {
	if m != nil {
		return m.RemoteClusterId
	}
	return ""
}

func (m *ClusterPairProcessResponse) GetRemoteClusterName() string {
	if m != nil {
		return m.RemoteClusterName
	}
	return ""
}

func (m *ClusterPairProcessResponse) GetRemoteClusterEndpoints() []string {
	if m != nil {
		return m.RemoteClusterEndpoints
	}
	return nil
}

func (m *ClusterPairProcessResponse) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

// Defines a delete request for a cluster pair
type SdkClusterPairDeleteRequest struct {
	// ID of the cluster pair to be deleted
	ClusterId            string   `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairDeleteRequest) Reset()         { *m = SdkClusterPairDeleteRequest{} }
func (m *SdkClusterPairDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairDeleteRequest) ProtoMessage()    {}
func (*SdkClusterPairDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{230}
}
func (m *SdkClusterPairDeleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairDeleteRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairDeleteRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairDeleteRequest.Merge(dst, src)
}
func (m *SdkClusterPairDeleteRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairDeleteRequest.Size(m)
}
func (m *SdkClusterPairDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairDeleteRequest proto.InternalMessageInfo

func (m *SdkClusterPairDeleteRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// Empty response
type SdkClusterPairDeleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairDeleteResponse) Reset()         { *m = SdkClusterPairDeleteResponse{} }
func (m *SdkClusterPairDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairDeleteResponse) ProtoMessage()    {}
func (*SdkClusterPairDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{231}
}
func (m *SdkClusterPairDeleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairDeleteResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairDeleteResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairDeleteResponse.Merge(dst, src)
}
func (m *SdkClusterPairDeleteResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairDeleteResponse.Size(m)
}
func (m *SdkClusterPairDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairDeleteResponse proto.InternalMessageInfo

// Response to get the cluster token
type ClusterPairTokenGetResponse struct {
	// Token used to authenticate clusters
	Token                string   `protobuf:"bytes,1,opt,name=token" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterPairTokenGetResponse) Reset()         { *m = ClusterPairTokenGetResponse{} }
func (m *ClusterPairTokenGetResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterPairTokenGetResponse) ProtoMessage()    {}
func (*ClusterPairTokenGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{232}
}
func (m *ClusterPairTokenGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairTokenGetResponse.Unmarshal(m, b)
}
func (m *ClusterPairTokenGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairTokenGetResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterPairTokenGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairTokenGetResponse.Merge(dst, src)
}
func (m *ClusterPairTokenGetResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterPairTokenGetResponse.Size(m)
}
func (m *ClusterPairTokenGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairTokenGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairTokenGetResponse proto.InternalMessageInfo

func (m *ClusterPairTokenGetResponse) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

// Empty request
type SdkClusterPairGetTokenRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairGetTokenRequest) Reset()         { *m = SdkClusterPairGetTokenRequest{} }
func (m *SdkClusterPairGetTokenRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairGetTokenRequest) ProtoMessage()    {}
func (*SdkClusterPairGetTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{233}
}
func (m *SdkClusterPairGetTokenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairGetTokenRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairGetTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairGetTokenRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairGetTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairGetTokenRequest.Merge(dst, src)
}
func (m *SdkClusterPairGetTokenRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairGetTokenRequest.Size(m)
}
func (m *SdkClusterPairGetTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairGetTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairGetTokenRequest proto.InternalMessageInfo

// Defines a response for the token request
type SdkClusterPairGetTokenResponse struct {
	// Contains authentication token for the cluster
	Result               *ClusterPairTokenGetResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SdkClusterPairGetTokenResponse) Reset()         { *m = SdkClusterPairGetTokenResponse{} }
func (m *SdkClusterPairGetTokenResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairGetTokenResponse) ProtoMessage()    {}
func (*SdkClusterPairGetTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{234}
}
func (m *SdkClusterPairGetTokenResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairGetTokenResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairGetTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairGetTokenResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairGetTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairGetTokenResponse.Merge(dst, src)
}
func (m *SdkClusterPairGetTokenResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairGetTokenResponse.Size(m)
}
func (m *SdkClusterPairGetTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairGetTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairGetTokenResponse proto.InternalMessageInfo

func (m *SdkClusterPairGetTokenResponse) GetResult() *ClusterPairTokenGetResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

// Empty request
type SdkClusterPairResetTokenRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairResetTokenRequest) Reset()         { *m = SdkClusterPairResetTokenRequest{} }
func (m *SdkClusterPairResetTokenRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairResetTokenRequest) ProtoMessage()    {}
func (*SdkClusterPairResetTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{235}
}
func (m *SdkClusterPairResetTokenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairResetTokenRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairResetTokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairResetTokenRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairResetTokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairResetTokenRequest.Merge(dst, src)
}
func (m *SdkClusterPairResetTokenRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairResetTokenRequest.Size(m)
}
func (m *SdkClusterPairResetTokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairResetTokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairResetTokenRequest proto.InternalMessageInfo

// Defines a response for the token request
type SdkClusterPairResetTokenResponse struct {
	// Contains authentication token for the cluster
	Result               *ClusterPairTokenGetResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *SdkClusterPairResetTokenResponse) Reset()         { *m = SdkClusterPairResetTokenResponse{} }
func (m *SdkClusterPairResetTokenResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairResetTokenResponse) ProtoMessage()    {}
func (*SdkClusterPairResetTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{236}
}
func (m *SdkClusterPairResetTokenResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairResetTokenResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairResetTokenResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairResetTokenResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairResetTokenResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairResetTokenResponse.Merge(dst, src)
}
func (m *SdkClusterPairResetTokenResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairResetTokenResponse.Size(m)
}
func (m *SdkClusterPairResetTokenResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairResetTokenResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairResetTokenResponse proto.InternalMessageInfo

func (m *SdkClusterPairResetTokenResponse) GetResult() *ClusterPairTokenGetResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

// Information about a cluster pair
type ClusterPairInfo struct {
	// ID of the cluster
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Name of the cluster
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The endpoint used for creating the pair
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint" json:"endpoint,omitempty"`
	// Current endpoints of the cluster
	CurrentEndpoints []string `protobuf:"bytes,4,rep,name=current_endpoints,json=currentEndpoints" json:"current_endpoints,omitempty"`
	// Flag used to determine if communication is over a secure channel
	Secure bool `protobuf:"varint,5,opt,name=secure" json:"secure,omitempty"`
	// Token associated with cluster
	Token string `protobuf:"bytes,6,opt,name=token" json:"token,omitempty"`
	// Key/value pair of options associated with the cluster
	// Opaque to openstorage and interpreted by the drivers
	Options map[string]string `protobuf:"bytes,7,rep,name=options" json:"options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mode for the cluster pair
	Mode                 ClusterPairMode_Mode `protobuf:"varint,8,opt,name=mode,enum=openstorage.api.ClusterPairMode_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ClusterPairInfo) Reset()         { *m = ClusterPairInfo{} }
func (m *ClusterPairInfo) String() string { return proto.CompactTextString(m) }
func (*ClusterPairInfo) ProtoMessage()    {}
func (*ClusterPairInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{237}
}
func (m *ClusterPairInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairInfo.Unmarshal(m, b)
}
func (m *ClusterPairInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairInfo.Marshal(b, m, deterministic)
}
func (dst *ClusterPairInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairInfo.Merge(dst, src)
}
func (m *ClusterPairInfo) XXX_Size() int {
	return xxx_messageInfo_ClusterPairInfo.Size(m)
}
func (m *ClusterPairInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairInfo proto.InternalMessageInfo

func (m *ClusterPairInfo) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ClusterPairInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ClusterPairInfo) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *ClusterPairInfo) GetCurrentEndpoints() []string {
	if m != nil {
		return m.CurrentEndpoints
	}
	return nil
}

func (m *ClusterPairInfo) GetSecure() bool {
	if m != nil {
		return m.Secure
	}
	return false
}

func (m *ClusterPairInfo) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *ClusterPairInfo) GetOptions() map[string]string {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ClusterPairInfo) GetMode() ClusterPairMode_Mode {
	if m != nil {
		return m.Mode
	}
	return ClusterPairMode_Default
}

// Defines a cluster pair inspect request
type SdkClusterPairInspectRequest struct {
	// ID of the cluster, if empty gets the default pair
	Id                   string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairInspectRequest) Reset()         { *m = SdkClusterPairInspectRequest{} }
func (m *SdkClusterPairInspectRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairInspectRequest) ProtoMessage()    {}
func (*SdkClusterPairInspectRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{238}
}
func (m *SdkClusterPairInspectRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairInspectRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairInspectRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairInspectRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairInspectRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairInspectRequest.Merge(dst, src)
}
func (m *SdkClusterPairInspectRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairInspectRequest.Size(m)
}
func (m *SdkClusterPairInspectRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairInspectRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairInspectRequest proto.InternalMessageInfo

func (m *SdkClusterPairInspectRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Reponse to get a cluster pair
type ClusterPairGetResponse struct {
	// Info about the cluster pair
	PairInfo             *ClusterPairInfo `protobuf:"bytes,1,opt,name=pair_info,json=pairInfo" json:"pair_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ClusterPairGetResponse) Reset()         { *m = ClusterPairGetResponse{} }
func (m *ClusterPairGetResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterPairGetResponse) ProtoMessage()    {}
func (*ClusterPairGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{239}
}
func (m *ClusterPairGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairGetResponse.Unmarshal(m, b)
}
func (m *ClusterPairGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairGetResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterPairGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairGetResponse.Merge(dst, src)
}
func (m *ClusterPairGetResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterPairGetResponse.Size(m)
}
func (m *ClusterPairGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairGetResponse proto.InternalMessageInfo

func (m *ClusterPairGetResponse) GetPairInfo() *ClusterPairInfo {
	if m != nil {
		return m.PairInfo
	}
	return nil
}

// Defines a cluster pair inspect response
type SdkClusterPairInspectResponse struct {
	// Information about cluster pair
	Result               *ClusterPairGetResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *SdkClusterPairInspectResponse) Reset()         { *m = SdkClusterPairInspectResponse{} }
func (m *SdkClusterPairInspectResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairInspectResponse) ProtoMessage()    {}
func (*SdkClusterPairInspectResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{240}
}
func (m *SdkClusterPairInspectResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairInspectResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairInspectResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairInspectResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairInspectResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairInspectResponse.Merge(dst, src)
}
func (m *SdkClusterPairInspectResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairInspectResponse.Size(m)
}
func (m *SdkClusterPairInspectResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairInspectResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairInspectResponse proto.InternalMessageInfo

func (m *SdkClusterPairInspectResponse) GetResult() *ClusterPairGetResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

// Empty Request
type SdkClusterPairEnumerateRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SdkClusterPairEnumerateRequest) Reset()         { *m = SdkClusterPairEnumerateRequest{} }
func (m *SdkClusterPairEnumerateRequest) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairEnumerateRequest) ProtoMessage()    {}
func (*SdkClusterPairEnumerateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{241}
}
func (m *SdkClusterPairEnumerateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairEnumerateRequest.Unmarshal(m, b)
}
func (m *SdkClusterPairEnumerateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairEnumerateRequest.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairEnumerateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairEnumerateRequest.Merge(dst, src)
}
func (m *SdkClusterPairEnumerateRequest) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairEnumerateRequest.Size(m)
}
func (m *SdkClusterPairEnumerateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairEnumerateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairEnumerateRequest proto.InternalMessageInfo

// Response to enumerate all the cluster pairs
type ClusterPairsEnumerateResponse struct {
	// ID of the default cluster pair
	DefaultId string `protobuf:"bytes,1,opt,name=default_id,json=defaultId" json:"default_id,omitempty"`
	// Pairs Info about the cluster pairs
	Pairs                map[string]*ClusterPairInfo `protobuf:"bytes,2,rep,name=pairs" json:"pairs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ClusterPairsEnumerateResponse) Reset()         { *m = ClusterPairsEnumerateResponse{} }
func (m *ClusterPairsEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*ClusterPairsEnumerateResponse) ProtoMessage()    {}
func (*ClusterPairsEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{242}
}
func (m *ClusterPairsEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusterPairsEnumerateResponse.Unmarshal(m, b)
}
func (m *ClusterPairsEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusterPairsEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *ClusterPairsEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterPairsEnumerateResponse.Merge(dst, src)
}
func (m *ClusterPairsEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_ClusterPairsEnumerateResponse.Size(m)
}
func (m *ClusterPairsEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterPairsEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterPairsEnumerateResponse proto.InternalMessageInfo

func (m *ClusterPairsEnumerateResponse) GetDefaultId() string {
	if m != nil {
		return m.DefaultId
	}
	return ""
}

func (m *ClusterPairsEnumerateResponse) GetPairs() map[string]*ClusterPairInfo {
	if m != nil {
		return m.Pairs
	}
	return nil
}

// Defines a list of cluster pair
type SdkClusterPairEnumerateResponse struct {
	// List of all the cluster pairs
	Result               *ClusterPairsEnumerateResponse `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *SdkClusterPairEnumerateResponse) Reset()         { *m = SdkClusterPairEnumerateResponse{} }
func (m *SdkClusterPairEnumerateResponse) String() string { return proto.CompactTextString(m) }
func (*SdkClusterPairEnumerateResponse) ProtoMessage()    {}
func (*SdkClusterPairEnumerateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{243}
}
func (m *SdkClusterPairEnumerateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SdkClusterPairEnumerateResponse.Unmarshal(m, b)
}
func (m *SdkClusterPairEnumerateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SdkClusterPairEnumerateResponse.Marshal(b, m, deterministic)
}
func (dst *SdkClusterPairEnumerateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdkClusterPairEnumerateResponse.Merge(dst, src)
}
func (m *SdkClusterPairEnumerateResponse) XXX_Size() int {
	return xxx_messageInfo_SdkClusterPairEnumerateResponse.Size(m)
}
func (m *SdkClusterPairEnumerateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SdkClusterPairEnumerateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SdkClusterPairEnumerateResponse proto.InternalMessageInfo

func (m *SdkClusterPairEnumerateResponse) GetResult() *ClusterPairsEnumerateResponse {
	if m != nil {
		return m.Result
	}
	return nil
}

type Catalog struct {
	// Name of the Directory/File
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Full Path of the Directory/File
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Type Directory or File
	Type string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	// File or Directory Size
	Size uint64 `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
	// Last Modified
	LastModified *timestamp.Timestamp `protobuf:"bytes,5,opt,name=LastModified" json:"LastModified,omitempty"`
	// Children
	Children             []*Catalog `protobuf:"bytes,6,rep,name=children" json:"children,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Catalog) Reset()         { *m = Catalog{} }
func (m *Catalog) String() string { return proto.CompactTextString(m) }
func (*Catalog) ProtoMessage()    {}
func (*Catalog) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{244}
}
func (m *Catalog) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Catalog.Unmarshal(m, b)
}
func (m *Catalog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Catalog.Marshal(b, m, deterministic)
}
func (dst *Catalog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Catalog.Merge(dst, src)
}
func (m *Catalog) XXX_Size() int {
	return xxx_messageInfo_Catalog.Size(m)
}
func (m *Catalog) XXX_DiscardUnknown() {
	xxx_messageInfo_Catalog.DiscardUnknown(m)
}

var xxx_messageInfo_Catalog proto.InternalMessageInfo

func (m *Catalog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Catalog) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Catalog) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Catalog) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Catalog) GetLastModified() *timestamp.Timestamp {
	if m != nil {
		return m.LastModified
	}
	return nil
}

func (m *Catalog) GetChildren() []*Catalog {
	if m != nil {
		return m.Children
	}
	return nil
}

type Report struct {
	// Directory count
	Directories int64 `protobuf:"varint,2,opt,name=directories" json:"directories,omitempty"`
	// File count
	Files                int64    `protobuf:"varint,3,opt,name=files" json:"files,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Report) Reset()         { *m = Report{} }
func (m *Report) String() string { return proto.CompactTextString(m) }
func (*Report) ProtoMessage()    {}
func (*Report) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{245}
}
func (m *Report) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Report.Unmarshal(m, b)
}
func (m *Report) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Report.Marshal(b, m, deterministic)
}
func (dst *Report) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Report.Merge(dst, src)
}
func (m *Report) XXX_Size() int {
	return xxx_messageInfo_Report.Size(m)
}
func (m *Report) XXX_DiscardUnknown() {
	xxx_messageInfo_Report.DiscardUnknown(m)
}

var xxx_messageInfo_Report proto.InternalMessageInfo

func (m *Report) GetDirectories() int64 {
	if m != nil {
		return m.Directories
	}
	return 0
}

func (m *Report) GetFiles() int64 {
	if m != nil {
		return m.Files
	}
	return 0
}

type CatalogResponse struct {
	// Root Catalog
	Root *Catalog `protobuf:"bytes,1,opt,name=root" json:"root,omitempty"`
	// Report of total directories and files count
	Report               *Report  `protobuf:"bytes,2,opt,name=report" json:"report,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CatalogResponse) Reset()         { *m = CatalogResponse{} }
func (m *CatalogResponse) String() string { return proto.CompactTextString(m) }
func (*CatalogResponse) ProtoMessage()    {}
func (*CatalogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{246}
}
func (m *CatalogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CatalogResponse.Unmarshal(m, b)
}
func (m *CatalogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CatalogResponse.Marshal(b, m, deterministic)
}
func (dst *CatalogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CatalogResponse.Merge(dst, src)
}
func (m *CatalogResponse) XXX_Size() int {
	return xxx_messageInfo_CatalogResponse.Size(m)
}
func (m *CatalogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CatalogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CatalogResponse proto.InternalMessageInfo

func (m *CatalogResponse) GetRoot() *Catalog {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *CatalogResponse) GetReport() *Report {
	if m != nil {
		return m.Report
	}
	return nil
}

// Locate response would be used to return a set of mounts
// and/or Container IDs and their mount paths
type LocateResponse struct {
	// Map of mounts
	// <host>: /var/lib/osd/<volumemount>
	Mounts map[string]string `protobuf:"bytes,1,rep,name=mounts" json:"mounts,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Map of docker id's and their mounts
	// <containerid>: /var/www
	Dockerids            map[string]string `protobuf:"bytes,2,rep,name=dockerids" json:"dockerids,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LocateResponse) Reset()         { *m = LocateResponse{} }
func (m *LocateResponse) String() string { return proto.CompactTextString(m) }
func (*LocateResponse) ProtoMessage()    {}
func (*LocateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{247}
}
func (m *LocateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocateResponse.Unmarshal(m, b)
}
func (m *LocateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocateResponse.Marshal(b, m, deterministic)
}
func (dst *LocateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocateResponse.Merge(dst, src)
}
func (m *LocateResponse) XXX_Size() int {
	return xxx_messageInfo_LocateResponse.Size(m)
}
func (m *LocateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LocateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LocateResponse proto.InternalMessageInfo

func (m *LocateResponse) GetMounts() map[string]string {
	if m != nil {
		return m.Mounts
	}
	return nil
}

func (m *LocateResponse) GetDockerids() map[string]string {
	if m != nil {
		return m.Dockerids
	}
	return nil
}

// VolumePlacementStrategy defines a strategy for placing volumes in the cluster which will be a series of rules
type VolumePlacementStrategy struct {
	// Rules defines a list of rules as part of the placement spec. All the rules specified will
	// be applied for volume placement.
	// Rules that have enforcement as "required" are strictly enforced while "preferred" are best effort.
	// In situations, where 2 or more rules conflict, the weight of the rules will dictate which wins.
	Rules                []*VolumePlacementRule `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *VolumePlacementStrategy) Reset()         { *m = VolumePlacementStrategy{} }
func (m *VolumePlacementStrategy) String() string { return proto.CompactTextString(m) }
func (*VolumePlacementStrategy) ProtoMessage()    {}
func (*VolumePlacementStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{248}
}
func (m *VolumePlacementStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumePlacementStrategy.Unmarshal(m, b)
}
func (m *VolumePlacementStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumePlacementStrategy.Marshal(b, m, deterministic)
}
func (dst *VolumePlacementStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumePlacementStrategy.Merge(dst, src)
}
func (m *VolumePlacementStrategy) XXX_Size() int {
	return xxx_messageInfo_VolumePlacementStrategy.Size(m)
}
func (m *VolumePlacementStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumePlacementStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_VolumePlacementStrategy proto.InternalMessageInfo

func (m *VolumePlacementStrategy) GetRules() []*VolumePlacementRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// VolumePlacementRule defines a single placement rule
type VolumePlacementRule struct {
	// AffectedReplicas defines the number of volume replicas affected by this rule. If not provided,
	// rule would affect all replicas
	// (optional)
	AffectedReplicas int32 `protobuf:"varint,1,opt,name=affected_replicas,json=affectedReplicas" json:"affected_replicas,omitempty"`
	// Weight defines the weight of the rule which allows to break the tie with other matching rules. A rule with
	// higher weight wins over a rule with lower weight.
	// (optional)
	Weight int64 `protobuf:"varint,2,opt,name=weight" json:"weight,omitempty"`
	// Enforcement specifies the rule enforcement policy. Can take values: required or preferred.
	// (optional)
	Enforcement VolumePlacementRule_EnforcementType `protobuf:"varint,3,opt,name=enforcement,enum=openstorage.api.VolumePlacementRule_EnforcementType" json:"enforcement,omitempty"`
	// Type is the type of the affinity rule
	Type VolumePlacementRule_AffinityRuleType `protobuf:"varint,4,opt,name=type,enum=openstorage.api.VolumePlacementRule_AffinityRuleType" json:"type,omitempty"`
	// MatchExpressions is a list of label selector requirements. The requirements are ANDed.
	MatchExpressions     []*LabelSelectorRequirement `protobuf:"bytes,5,rep,name=match_expressions,json=matchExpressions" json:"match_expressions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *VolumePlacementRule) Reset()         { *m = VolumePlacementRule{} }
func (m *VolumePlacementRule) String() string { return proto.CompactTextString(m) }
func (*VolumePlacementRule) ProtoMessage()    {}
func (*VolumePlacementRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{249}
}
func (m *VolumePlacementRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VolumePlacementRule.Unmarshal(m, b)
}
func (m *VolumePlacementRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VolumePlacementRule.Marshal(b, m, deterministic)
}
func (dst *VolumePlacementRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VolumePlacementRule.Merge(dst, src)
}
func (m *VolumePlacementRule) XXX_Size() int {
	return xxx_messageInfo_VolumePlacementRule.Size(m)
}
func (m *VolumePlacementRule) XXX_DiscardUnknown() {
	xxx_messageInfo_VolumePlacementRule.DiscardUnknown(m)
}

var xxx_messageInfo_VolumePlacementRule proto.InternalMessageInfo

func (m *VolumePlacementRule) GetAffectedReplicas() int32 {
	if m != nil {
		return m.AffectedReplicas
	}
	return 0
}

func (m *VolumePlacementRule) GetWeight() int64 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *VolumePlacementRule) GetEnforcement() VolumePlacementRule_EnforcementType {
	if m != nil {
		return m.Enforcement
	}
	return VolumePlacementRule_required
}

func (m *VolumePlacementRule) GetType() VolumePlacementRule_AffinityRuleType {
	if m != nil {
		return m.Type
	}
	return VolumePlacementRule_affinity
}

func (m *VolumePlacementRule) GetMatchExpressions() []*LabelSelectorRequirement {
	if m != nil {
		return m.MatchExpressions
	}
	return nil
}

// LabelSelectorRequirement is a selector that contains values, a key, and an operator that
// relates the key and values.
type LabelSelectorRequirement struct {
	// Key is the label key that the selector applies to.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// Operator represents a key's relationship to a set of values.
	// Valid operators are In, NotIn, Exists and DoesNotExist.
	Operator LabelSelectorRequirement_Operator `protobuf:"varint,2,opt,name=operator,enum=openstorage.api.LabelSelectorRequirement_Operator" json:"operator,omitempty"`
	// Values is an array of string values. If the operator is In or NotIn,
	// the values array must be non-empty. If the operator is Exists or DoesNotExist,
	// the values array must be empty. This array is replaced during a strategic
	// merge patch.
	Values               []string `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSelectorRequirement) Reset()         { *m = LabelSelectorRequirement{} }
func (m *LabelSelectorRequirement) String() string { return proto.CompactTextString(m) }
func (*LabelSelectorRequirement) ProtoMessage()    {}
func (*LabelSelectorRequirement) Descriptor() ([]byte, []int) {
	return fileDescriptor_api_05b7199aa6331e09, []int{250}
}
func (m *LabelSelectorRequirement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSelectorRequirement.Unmarshal(m, b)
}
func (m *LabelSelectorRequirement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSelectorRequirement.Marshal(b, m, deterministic)
}
func (dst *LabelSelectorRequirement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSelectorRequirement.Merge(dst, src)
}
func (m *LabelSelectorRequirement) XXX_Size() int {
	return xxx_messageInfo_LabelSelectorRequirement.Size(m)
}
func (m *LabelSelectorRequirement) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSelectorRequirement.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSelectorRequirement proto.InternalMessageInfo

func (m *LabelSelectorRequirement) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *LabelSelectorRequirement) GetOperator() LabelSelectorRequirement_Operator {
	if m != nil {
		return m.Operator
	}
	return LabelSelectorRequirement_In
}

func (m *LabelSelectorRequirement) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func init() {
	proto.RegisterType((*StorageResource)(nil), "openstorage.api.StorageResource")
	proto.RegisterType((*StoragePool)(nil), "openstorage.api.StoragePool")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.StoragePool.LabelsEntry")
	proto.RegisterType((*VolumeLocator)(nil), "openstorage.api.VolumeLocator")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.VolumeLocator.VolumeLabelsEntry")
	proto.RegisterType((*VolumeInspectOptions)(nil), "openstorage.api.VolumeInspectOptions")
	proto.RegisterType((*Source)(nil), "openstorage.api.Source")
	proto.RegisterType((*Group)(nil), "openstorage.api.Group")
	proto.RegisterType((*IoStrategy)(nil), "openstorage.api.IoStrategy")
	proto.RegisterType((*VolumeSpec)(nil), "openstorage.api.VolumeSpec")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.VolumeSpec.VolumeLabelsEntry")
	proto.RegisterType((*VolumeSpecUpdate)(nil), "openstorage.api.VolumeSpecUpdate")
	proto.RegisterType((*VolumeSpecPolicy)(nil), "openstorage.api.VolumeSpecPolicy")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.VolumeSpecPolicy.VolumeLabelsEntry")
	proto.RegisterType((*ReplicaSet)(nil), "openstorage.api.ReplicaSet")
	proto.RegisterType((*RuntimeStateMap)(nil), "openstorage.api.RuntimeStateMap")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.RuntimeStateMap.RuntimeStateEntry")
	proto.RegisterType((*Ownership)(nil), "openstorage.api.Ownership")
	proto.RegisterType((*Ownership_AccessControl)(nil), "openstorage.api.Ownership.AccessControl")
	proto.RegisterMapType((map[string]Ownership_AccessType)(nil), "openstorage.api.Ownership.AccessControl.CollaboratorsEntry")
	proto.RegisterMapType((map[string]Ownership_AccessType)(nil), "openstorage.api.Ownership.AccessControl.GroupsEntry")
	proto.RegisterType((*Volume)(nil), "openstorage.api.Volume")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.Volume.AttachInfoEntry")
	proto.RegisterType((*Stats)(nil), "openstorage.api.Stats")
	proto.RegisterType((*CapacityUsageInfo)(nil), "openstorage.api.CapacityUsageInfo")
	proto.RegisterType((*SdkStoragePolicy)(nil), "openstorage.api.SdkStoragePolicy")
	proto.RegisterType((*Alert)(nil), "openstorage.api.Alert")
	proto.RegisterType((*SdkAlertsTimeSpan)(nil), "openstorage.api.SdkAlertsTimeSpan")
	proto.RegisterType((*SdkAlertsCountSpan)(nil), "openstorage.api.SdkAlertsCountSpan")
	proto.RegisterType((*SdkAlertsOption)(nil), "openstorage.api.SdkAlertsOption")
	proto.RegisterType((*SdkAlertsResourceTypeQuery)(nil), "openstorage.api.SdkAlertsResourceTypeQuery")
	proto.RegisterType((*SdkAlertsAlertTypeQuery)(nil), "openstorage.api.SdkAlertsAlertTypeQuery")
	proto.RegisterType((*SdkAlertsResourceIdQuery)(nil), "openstorage.api.SdkAlertsResourceIdQuery")
	proto.RegisterType((*SdkAlertsQuery)(nil), "openstorage.api.SdkAlertsQuery")
	proto.RegisterType((*SdkAlertsEnumerateWithFiltersRequest)(nil), "openstorage.api.SdkAlertsEnumerateWithFiltersRequest")
	proto.RegisterType((*SdkAlertsEnumerateWithFiltersResponse)(nil), "openstorage.api.SdkAlertsEnumerateWithFiltersResponse")
	proto.RegisterType((*SdkAlertsDeleteRequest)(nil), "openstorage.api.SdkAlertsDeleteRequest")
	proto.RegisterType((*SdkAlertsDeleteResponse)(nil), "openstorage.api.SdkAlertsDeleteResponse")
	proto.RegisterType((*Alerts)(nil), "openstorage.api.Alerts")
	proto.RegisterType((*ObjectstoreInfo)(nil), "openstorage.api.ObjectstoreInfo")
	proto.RegisterType((*VolumeCreateRequest)(nil), "openstorage.api.VolumeCreateRequest")
	proto.RegisterType((*VolumeResponse)(nil), "openstorage.api.VolumeResponse")
	proto.RegisterType((*VolumeCreateResponse)(nil), "openstorage.api.VolumeCreateResponse")
	proto.RegisterType((*VolumeStateAction)(nil), "openstorage.api.VolumeStateAction")
	proto.RegisterType((*VolumeSetRequest)(nil), "openstorage.api.VolumeSetRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.VolumeSetRequest.OptionsEntry")
	proto.RegisterType((*VolumeSetResponse)(nil), "openstorage.api.VolumeSetResponse")
	proto.RegisterType((*SnapCreateRequest)(nil), "openstorage.api.SnapCreateRequest")
	proto.RegisterType((*SnapCreateResponse)(nil), "openstorage.api.SnapCreateResponse")
	proto.RegisterType((*VolumeInfo)(nil), "openstorage.api.VolumeInfo")
	proto.RegisterType((*VolumeConsumer)(nil), "openstorage.api.VolumeConsumer")
	proto.RegisterType((*GraphDriverChanges)(nil), "openstorage.api.GraphDriverChanges")
	proto.RegisterType((*ClusterResponse)(nil), "openstorage.api.ClusterResponse")
	proto.RegisterType((*ActiveRequest)(nil), "openstorage.api.ActiveRequest")
	proto.RegisterMapType((map[int64]string)(nil), "openstorage.api.ActiveRequest.ReqestKVEntry")
	proto.RegisterType((*ActiveRequests)(nil), "openstorage.api.ActiveRequests")
	proto.RegisterType((*GroupSnapCreateRequest)(nil), "openstorage.api.GroupSnapCreateRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.GroupSnapCreateRequest.LabelsEntry")
	proto.RegisterType((*GroupSnapCreateResponse)(nil), "openstorage.api.GroupSnapCreateResponse")
	proto.RegisterMapType((map[string]*SnapCreateResponse)(nil), "openstorage.api.GroupSnapCreateResponse.SnapshotsEntry")
	proto.RegisterType((*StorageNode)(nil), "openstorage.api.StorageNode")
	proto.RegisterMapType((map[string]*StorageResource)(nil), "openstorage.api.StorageNode.DisksEntry")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.StorageNode.NodeLabelsEntry")
	proto.RegisterType((*StorageCluster)(nil), "openstorage.api.StorageCluster")
	proto.RegisterType((*SdkOpenStoragePolicyCreateRequest)(nil), "openstorage.api.SdkOpenStoragePolicyCreateRequest")
	proto.RegisterType((*SdkOpenStoragePolicyCreateResponse)(nil), "openstorage.api.SdkOpenStoragePolicyCreateResponse")
	proto.RegisterType((*SdkOpenStoragePolicyEnumerateRequest)(nil), "openstorage.api.SdkOpenStoragePolicyEnumerateRequest")
	proto.RegisterType((*SdkOpenStoragePolicyEnumerateResponse)(nil), "openstorage.api.SdkOpenStoragePolicyEnumerateResponse")
	proto.RegisterType((*SdkOpenStoragePolicyInspectRequest)(nil), "openstorage.api.SdkOpenStoragePolicyInspectRequest")
	proto.RegisterType((*SdkOpenStoragePolicyInspectResponse)(nil), "openstorage.api.SdkOpenStoragePolicyInspectResponse")
	proto.RegisterType((*SdkOpenStoragePolicyDeleteRequest)(nil), "openstorage.api.SdkOpenStoragePolicyDeleteRequest")
	proto.RegisterType((*SdkOpenStoragePolicyDeleteResponse)(nil), "openstorage.api.SdkOpenStoragePolicyDeleteResponse")
	proto.RegisterType((*SdkOpenStoragePolicyUpdateRequest)(nil), "openstorage.api.SdkOpenStoragePolicyUpdateRequest")
	proto.RegisterType((*SdkOpenStoragePolicyUpdateResponse)(nil), "openstorage.api.SdkOpenStoragePolicyUpdateResponse")
	proto.RegisterType((*SdkOpenStoragePolicySetDefaultRequest)(nil), "openstorage.api.SdkOpenStoragePolicySetDefaultRequest")
	proto.RegisterType((*SdkOpenStoragePolicySetDefaultResponse)(nil), "openstorage.api.SdkOpenStoragePolicySetDefaultResponse")
	proto.RegisterType((*SdkOpenStoragePolicyReleaseRequest)(nil), "openstorage.api.SdkOpenStoragePolicyReleaseRequest")
	proto.RegisterType((*SdkOpenStoragePolicyReleaseResponse)(nil), "openstorage.api.SdkOpenStoragePolicyReleaseResponse")
	proto.RegisterType((*SdkOpenStoragePolicyDefaultInspectRequest)(nil), "openstorage.api.SdkOpenStoragePolicyDefaultInspectRequest")
	proto.RegisterType((*SdkOpenStoragePolicyDefaultInspectResponse)(nil), "openstorage.api.SdkOpenStoragePolicyDefaultInspectResponse")
	proto.RegisterType((*SdkSchedulePolicyCreateRequest)(nil), "openstorage.api.SdkSchedulePolicyCreateRequest")
	proto.RegisterType((*SdkSchedulePolicyCreateResponse)(nil), "openstorage.api.SdkSchedulePolicyCreateResponse")
	proto.RegisterType((*SdkSchedulePolicyUpdateRequest)(nil), "openstorage.api.SdkSchedulePolicyUpdateRequest")
	proto.RegisterType((*SdkSchedulePolicyUpdateResponse)(nil), "openstorage.api.SdkSchedulePolicyUpdateResponse")
	proto.RegisterType((*SdkSchedulePolicyEnumerateRequest)(nil), "openstorage.api.SdkSchedulePolicyEnumerateRequest")
	proto.RegisterType((*SdkSchedulePolicyEnumerateResponse)(nil), "openstorage.api.SdkSchedulePolicyEnumerateResponse")
	proto.RegisterType((*SdkSchedulePolicyInspectRequest)(nil), "openstorage.api.SdkSchedulePolicyInspectRequest")
	proto.RegisterType((*SdkSchedulePolicyInspectResponse)(nil), "openstorage.api.SdkSchedulePolicyInspectResponse")
	proto.RegisterType((*SdkSchedulePolicyDeleteRequest)(nil), "openstorage.api.SdkSchedulePolicyDeleteRequest")
	proto.RegisterType((*SdkSchedulePolicyDeleteResponse)(nil), "openstorage.api.SdkSchedulePolicyDeleteResponse")
	proto.RegisterType((*SdkSchedulePolicyIntervalDaily)(nil), "openstorage.api.SdkSchedulePolicyIntervalDaily")
	proto.RegisterType((*SdkSchedulePolicyIntervalWeekly)(nil), "openstorage.api.SdkSchedulePolicyIntervalWeekly")
	proto.RegisterType((*SdkSchedulePolicyIntervalMonthly)(nil), "openstorage.api.SdkSchedulePolicyIntervalMonthly")
	proto.RegisterType((*SdkSchedulePolicyIntervalPeriodic)(nil), "openstorage.api.SdkSchedulePolicyIntervalPeriodic")
	proto.RegisterType((*SdkSchedulePolicyInterval)(nil), "openstorage.api.SdkSchedulePolicyInterval")
	proto.RegisterType((*SdkSchedulePolicy)(nil), "openstorage.api.SdkSchedulePolicy")
	proto.RegisterType((*SdkCredentialCreateRequest)(nil), "openstorage.api.SdkCredentialCreateRequest")
	proto.RegisterType((*SdkCredentialCreateResponse)(nil), "openstorage.api.SdkCredentialCreateResponse")
	proto.RegisterType((*SdkAwsCredentialRequest)(nil), "openstorage.api.SdkAwsCredentialRequest")
	proto.RegisterType((*SdkAzureCredentialRequest)(nil), "openstorage.api.SdkAzureCredentialRequest")
	proto.RegisterType((*SdkGoogleCredentialRequest)(nil), "openstorage.api.SdkGoogleCredentialRequest")
	proto.RegisterType((*SdkAwsCredentialResponse)(nil), "openstorage.api.SdkAwsCredentialResponse")
	proto.RegisterType((*SdkAzureCredentialResponse)(nil), "openstorage.api.SdkAzureCredentialResponse")
	proto.RegisterType((*SdkGoogleCredentialResponse)(nil), "openstorage.api.SdkGoogleCredentialResponse")
	proto.RegisterType((*SdkCredentialEnumerateRequest)(nil), "openstorage.api.SdkCredentialEnumerateRequest")
	proto.RegisterType((*SdkCredentialEnumerateResponse)(nil), "openstorage.api.SdkCredentialEnumerateResponse")
	proto.RegisterType((*SdkCredentialInspectRequest)(nil), "openstorage.api.SdkCredentialInspectRequest")
	proto.RegisterType((*SdkCredentialInspectResponse)(nil), "openstorage.api.SdkCredentialInspectResponse")
	proto.RegisterType((*SdkCredentialDeleteRequest)(nil), "openstorage.api.SdkCredentialDeleteRequest")
	proto.RegisterType((*SdkCredentialDeleteResponse)(nil), "openstorage.api.SdkCredentialDeleteResponse")
	proto.RegisterType((*SdkCredentialValidateRequest)(nil), "openstorage.api.SdkCredentialValidateRequest")
	proto.RegisterType((*SdkCredentialValidateResponse)(nil), "openstorage.api.SdkCredentialValidateResponse")
	proto.RegisterType((*SdkVolumeAttachOptions)(nil), "openstorage.api.SdkVolumeAttachOptions")
	proto.RegisterType((*SdkVolumeMountRequest)(nil), "openstorage.api.SdkVolumeMountRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeMountRequest.DriverOptionsEntry")
	proto.RegisterType((*SdkVolumeMountResponse)(nil), "openstorage.api.SdkVolumeMountResponse")
	proto.RegisterType((*SdkVolumeUnmountOptions)(nil), "openstorage.api.SdkVolumeUnmountOptions")
	proto.RegisterType((*SdkVolumeUnmountRequest)(nil), "openstorage.api.SdkVolumeUnmountRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeUnmountRequest.DriverOptionsEntry")
	proto.RegisterType((*SdkVolumeUnmountResponse)(nil), "openstorage.api.SdkVolumeUnmountResponse")
	proto.RegisterType((*SdkVolumeAttachRequest)(nil), "openstorage.api.SdkVolumeAttachRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeAttachRequest.DriverOptionsEntry")
	proto.RegisterType((*SdkVolumeAttachResponse)(nil), "openstorage.api.SdkVolumeAttachResponse")
	proto.RegisterType((*SdkVolumeDetachOptions)(nil), "openstorage.api.SdkVolumeDetachOptions")
	proto.RegisterType((*SdkVolumeDetachRequest)(nil), "openstorage.api.SdkVolumeDetachRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeDetachRequest.DriverOptionsEntry")
	proto.RegisterType((*SdkVolumeDetachResponse)(nil), "openstorage.api.SdkVolumeDetachResponse")
	proto.RegisterType((*SdkVolumeCreateRequest)(nil), "openstorage.api.SdkVolumeCreateRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeCreateRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeCreateResponse)(nil), "openstorage.api.SdkVolumeCreateResponse")
	proto.RegisterType((*SdkVolumeCloneRequest)(nil), "openstorage.api.SdkVolumeCloneRequest")
	proto.RegisterType((*SdkVolumeCloneResponse)(nil), "openstorage.api.SdkVolumeCloneResponse")
	proto.RegisterType((*SdkVolumeDeleteRequest)(nil), "openstorage.api.SdkVolumeDeleteRequest")
	proto.RegisterType((*SdkVolumeDeleteResponse)(nil), "openstorage.api.SdkVolumeDeleteResponse")
	proto.RegisterType((*SdkVolumeInspectRequest)(nil), "openstorage.api.SdkVolumeInspectRequest")
	proto.RegisterType((*SdkVolumeInspectResponse)(nil), "openstorage.api.SdkVolumeInspectResponse")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeInspectResponse.LabelsEntry")
	proto.RegisterType((*SdkVolumeInspectWithFiltersRequest)(nil), "openstorage.api.SdkVolumeInspectWithFiltersRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeInspectWithFiltersRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeInspectWithFiltersResponse)(nil), "openstorage.api.SdkVolumeInspectWithFiltersResponse")
	proto.RegisterType((*SdkVolumeUpdateRequest)(nil), "openstorage.api.SdkVolumeUpdateRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeUpdateRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeUpdateResponse)(nil), "openstorage.api.SdkVolumeUpdateResponse")
	proto.RegisterType((*SdkVolumeStatsRequest)(nil), "openstorage.api.SdkVolumeStatsRequest")
	proto.RegisterType((*SdkVolumeStatsResponse)(nil), "openstorage.api.SdkVolumeStatsResponse")
	proto.RegisterType((*SdkVolumeCapacityUsageRequest)(nil), "openstorage.api.SdkVolumeCapacityUsageRequest")
	proto.RegisterType((*SdkVolumeCapacityUsageResponse)(nil), "openstorage.api.SdkVolumeCapacityUsageResponse")
	proto.RegisterType((*SdkVolumeEnumerateRequest)(nil), "openstorage.api.SdkVolumeEnumerateRequest")
	proto.RegisterType((*SdkVolumeEnumerateResponse)(nil), "openstorage.api.SdkVolumeEnumerateResponse")
	proto.RegisterType((*SdkVolumeEnumerateWithFiltersRequest)(nil), "openstorage.api.SdkVolumeEnumerateWithFiltersRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeEnumerateWithFiltersRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeEnumerateWithFiltersResponse)(nil), "openstorage.api.SdkVolumeEnumerateWithFiltersResponse")
	proto.RegisterType((*SdkVolumeSnapshotCreateRequest)(nil), "openstorage.api.SdkVolumeSnapshotCreateRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeSnapshotCreateRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeSnapshotCreateResponse)(nil), "openstorage.api.SdkVolumeSnapshotCreateResponse")
	proto.RegisterType((*SdkVolumeSnapshotRestoreRequest)(nil), "openstorage.api.SdkVolumeSnapshotRestoreRequest")
	proto.RegisterType((*SdkVolumeSnapshotRestoreResponse)(nil), "openstorage.api.SdkVolumeSnapshotRestoreResponse")
	proto.RegisterType((*SdkVolumeSnapshotEnumerateRequest)(nil), "openstorage.api.SdkVolumeSnapshotEnumerateRequest")
	proto.RegisterType((*SdkVolumeSnapshotEnumerateResponse)(nil), "openstorage.api.SdkVolumeSnapshotEnumerateResponse")
	proto.RegisterType((*SdkVolumeSnapshotEnumerateWithFiltersRequest)(nil), "openstorage.api.SdkVolumeSnapshotEnumerateWithFiltersRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkVolumeSnapshotEnumerateWithFiltersRequest.LabelsEntry")
	proto.RegisterType((*SdkVolumeSnapshotEnumerateWithFiltersResponse)(nil), "openstorage.api.SdkVolumeSnapshotEnumerateWithFiltersResponse")
	proto.RegisterType((*SdkVolumeSnapshotScheduleUpdateRequest)(nil), "openstorage.api.SdkVolumeSnapshotScheduleUpdateRequest")
	proto.RegisterType((*SdkVolumeSnapshotScheduleUpdateResponse)(nil), "openstorage.api.SdkVolumeSnapshotScheduleUpdateResponse")
	proto.RegisterType((*SdkClusterDomainsEnumerateRequest)(nil), "openstorage.api.SdkClusterDomainsEnumerateRequest")
	proto.RegisterType((*SdkClusterDomainsEnumerateResponse)(nil), "openstorage.api.SdkClusterDomainsEnumerateResponse")
	proto.RegisterType((*SdkClusterDomainInspectRequest)(nil), "openstorage.api.SdkClusterDomainInspectRequest")
	proto.RegisterType((*SdkClusterDomainInspectResponse)(nil), "openstorage.api.SdkClusterDomainInspectResponse")
	proto.RegisterType((*SdkClusterDomainActivateRequest)(nil), "openstorage.api.SdkClusterDomainActivateRequest")
	proto.RegisterType((*SdkClusterDomainActivateResponse)(nil), "openstorage.api.SdkClusterDomainActivateResponse")
	proto.RegisterType((*SdkClusterDomainDeactivateRequest)(nil), "openstorage.api.SdkClusterDomainDeactivateRequest")
	proto.RegisterType((*SdkClusterDomainDeactivateResponse)(nil), "openstorage.api.SdkClusterDomainDeactivateResponse")
	proto.RegisterType((*SdkClusterInspectCurrentRequest)(nil), "openstorage.api.SdkClusterInspectCurrentRequest")
	proto.RegisterType((*SdkClusterInspectCurrentResponse)(nil), "openstorage.api.SdkClusterInspectCurrentResponse")
	proto.RegisterType((*SdkNodeInspectRequest)(nil), "openstorage.api.SdkNodeInspectRequest")
	proto.RegisterType((*SdkNodeInspectResponse)(nil), "openstorage.api.SdkNodeInspectResponse")
	proto.RegisterType((*SdkNodeInspectCurrentRequest)(nil), "openstorage.api.SdkNodeInspectCurrentRequest")
	proto.RegisterType((*SdkNodeInspectCurrentResponse)(nil), "openstorage.api.SdkNodeInspectCurrentResponse")
	proto.RegisterType((*SdkNodeEnumerateRequest)(nil), "openstorage.api.SdkNodeEnumerateRequest")
	proto.RegisterType((*SdkNodeEnumerateResponse)(nil), "openstorage.api.SdkNodeEnumerateResponse")
	proto.RegisterType((*SdkObjectstoreInspectRequest)(nil), "openstorage.api.SdkObjectstoreInspectRequest")
	proto.RegisterType((*SdkObjectstoreInspectResponse)(nil), "openstorage.api.SdkObjectstoreInspectResponse")
	proto.RegisterType((*SdkObjectstoreCreateRequest)(nil), "openstorage.api.SdkObjectstoreCreateRequest")
	proto.RegisterType((*SdkObjectstoreCreateResponse)(nil), "openstorage.api.SdkObjectstoreCreateResponse")
	proto.RegisterType((*SdkObjectstoreDeleteRequest)(nil), "openstorage.api.SdkObjectstoreDeleteRequest")
	proto.RegisterType((*SdkObjectstoreDeleteResponse)(nil), "openstorage.api.SdkObjectstoreDeleteResponse")
	proto.RegisterType((*SdkObjectstoreUpdateRequest)(nil), "openstorage.api.SdkObjectstoreUpdateRequest")
	proto.RegisterType((*SdkObjectstoreUpdateResponse)(nil), "openstorage.api.SdkObjectstoreUpdateResponse")
	proto.RegisterType((*SdkCloudBackupCreateRequest)(nil), "openstorage.api.SdkCloudBackupCreateRequest")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkCloudBackupCreateRequest.LabelsEntry")
	proto.RegisterType((*SdkCloudBackupCreateResponse)(nil), "openstorage.api.SdkCloudBackupCreateResponse")
	proto.RegisterType((*SdkCloudBackupRestoreRequest)(nil), "openstorage.api.SdkCloudBackupRestoreRequest")
	proto.RegisterType((*SdkCloudBackupRestoreResponse)(nil), "openstorage.api.SdkCloudBackupRestoreResponse")
	proto.RegisterType((*SdkCloudBackupDeleteRequest)(nil), "openstorage.api.SdkCloudBackupDeleteRequest")
	proto.RegisterType((*SdkCloudBackupDeleteResponse)(nil), "openstorage.api.SdkCloudBackupDeleteResponse")
	proto.RegisterType((*SdkCloudBackupDeleteAllRequest)(nil), "openstorage.api.SdkCloudBackupDeleteAllRequest")
	proto.RegisterType((*SdkCloudBackupDeleteAllResponse)(nil), "openstorage.api.SdkCloudBackupDeleteAllResponse")
	proto.RegisterType((*SdkCloudBackupEnumerateWithFiltersRequest)(nil), "openstorage.api.SdkCloudBackupEnumerateWithFiltersRequest")
	proto.RegisterType((*SdkCloudBackupInfo)(nil), "openstorage.api.SdkCloudBackupInfo")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.SdkCloudBackupInfo.MetadataEntry")
	proto.RegisterType((*SdkCloudBackupEnumerateWithFiltersResponse)(nil), "openstorage.api.SdkCloudBackupEnumerateWithFiltersResponse")
	proto.RegisterType((*SdkCloudBackupStatus)(nil), "openstorage.api.SdkCloudBackupStatus")
	proto.RegisterType((*SdkCloudBackupStatusRequest)(nil), "openstorage.api.SdkCloudBackupStatusRequest")
	proto.RegisterType((*SdkCloudBackupStatusResponse)(nil), "openstorage.api.SdkCloudBackupStatusResponse")
	proto.RegisterMapType((map[string]*SdkCloudBackupStatus)(nil), "openstorage.api.SdkCloudBackupStatusResponse.StatusesEntry")
	proto.RegisterType((*SdkCloudBackupCatalogRequest)(nil), "openstorage.api.SdkCloudBackupCatalogRequest")
	proto.RegisterType((*SdkCloudBackupCatalogResponse)(nil), "openstorage.api.SdkCloudBackupCatalogResponse")
	proto.RegisterType((*SdkCloudBackupHistoryItem)(nil), "openstorage.api.SdkCloudBackupHistoryItem")
	proto.RegisterType((*SdkCloudBackupHistoryRequest)(nil), "openstorage.api.SdkCloudBackupHistoryRequest")
	proto.RegisterType((*SdkCloudBackupHistoryResponse)(nil), "openstorage.api.SdkCloudBackupHistoryResponse")
	proto.RegisterType((*SdkCloudBackupStateChangeRequest)(nil), "openstorage.api.SdkCloudBackupStateChangeRequest")
	proto.RegisterType((*SdkCloudBackupStateChangeResponse)(nil), "openstorage.api.SdkCloudBackupStateChangeResponse")
	proto.RegisterType((*SdkCloudBackupScheduleInfo)(nil), "openstorage.api.SdkCloudBackupScheduleInfo")
	proto.RegisterType((*SdkCloudBackupSchedCreateRequest)(nil), "openstorage.api.SdkCloudBackupSchedCreateRequest")
	proto.RegisterType((*SdkCloudBackupSchedCreateResponse)(nil), "openstorage.api.SdkCloudBackupSchedCreateResponse")
	proto.RegisterType((*SdkCloudBackupSchedDeleteRequest)(nil), "openstorage.api.SdkCloudBackupSchedDeleteRequest")
	proto.RegisterType((*SdkCloudBackupSchedDeleteResponse)(nil), "openstorage.api.SdkCloudBackupSchedDeleteResponse")
	proto.RegisterType((*SdkCloudBackupSchedEnumerateRequest)(nil), "openstorage.api.SdkCloudBackupSchedEnumerateRequest")
	proto.RegisterType((*SdkCloudBackupSchedEnumerateResponse)(nil), "openstorage.api.SdkCloudBackupSchedEnumerateResponse")
	proto.RegisterMapType((map[string]*SdkCloudBackupScheduleInfo)(nil), "openstorage.api.SdkCloudBackupSchedEnumerateResponse.CloudSchedListEntry")
	proto.RegisterType((*SdkRule)(nil), "openstorage.api.SdkRule")
	proto.RegisterType((*SdkRole)(nil), "openstorage.api.SdkRole")
	proto.RegisterType((*SdkRoleCreateRequest)(nil), "openstorage.api.SdkRoleCreateRequest")
	proto.RegisterType((*SdkRoleCreateResponse)(nil), "openstorage.api.SdkRoleCreateResponse")
	proto.RegisterType((*SdkRoleEnumerateRequest)(nil), "openstorage.api.SdkRoleEnumerateRequest")
	proto.RegisterType((*SdkRoleEnumerateResponse)(nil), "openstorage.api.SdkRoleEnumerateResponse")
	proto.RegisterType((*SdkRoleInspectRequest)(nil), "openstorage.api.SdkRoleInspectRequest")
	proto.RegisterType((*SdkRoleInspectResponse)(nil), "openstorage.api.SdkRoleInspectResponse")
	proto.RegisterType((*SdkRoleDeleteRequest)(nil), "openstorage.api.SdkRoleDeleteRequest")
	proto.RegisterType((*SdkRoleDeleteResponse)(nil), "openstorage.api.SdkRoleDeleteResponse")
	proto.RegisterType((*SdkRoleUpdateRequest)(nil), "openstorage.api.SdkRoleUpdateRequest")
	proto.RegisterType((*SdkRoleUpdateResponse)(nil), "openstorage.api.SdkRoleUpdateResponse")
	proto.RegisterType((*SdkIdentityCapabilitiesRequest)(nil), "openstorage.api.SdkIdentityCapabilitiesRequest")
	proto.RegisterType((*SdkIdentityCapabilitiesResponse)(nil), "openstorage.api.SdkIdentityCapabilitiesResponse")
	proto.RegisterType((*SdkIdentityVersionRequest)(nil), "openstorage.api.SdkIdentityVersionRequest")
	proto.RegisterType((*SdkIdentityVersionResponse)(nil), "openstorage.api.SdkIdentityVersionResponse")
	proto.RegisterType((*SdkServiceCapability)(nil), "openstorage.api.SdkServiceCapability")
	proto.RegisterType((*SdkServiceCapability_OpenStorageService)(nil), "openstorage.api.SdkServiceCapability.OpenStorageService")
	proto.RegisterType((*SdkVersion)(nil), "openstorage.api.SdkVersion")
	proto.RegisterType((*StorageVersion)(nil), "openstorage.api.StorageVersion")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.StorageVersion.DetailsEntry")
	proto.RegisterType((*CloudMigrate)(nil), "openstorage.api.CloudMigrate")
	proto.RegisterType((*CloudMigrateStartRequest)(nil), "openstorage.api.CloudMigrateStartRequest")
	proto.RegisterType((*SdkCloudMigrateStartRequest)(nil), "openstorage.api.SdkCloudMigrateStartRequest")
	proto.RegisterType((*SdkCloudMigrateStartRequest_MigrateVolume)(nil), "openstorage.api.SdkCloudMigrateStartRequest.MigrateVolume")
	proto.RegisterType((*SdkCloudMigrateStartRequest_MigrateVolumeGroup)(nil), "openstorage.api.SdkCloudMigrateStartRequest.MigrateVolumeGroup")
	proto.RegisterType((*SdkCloudMigrateStartRequest_MigrateAllVolumes)(nil), "openstorage.api.SdkCloudMigrateStartRequest.MigrateAllVolumes")
	proto.RegisterType((*CloudMigrateStartResponse)(nil), "openstorage.api.CloudMigrateStartResponse")
	proto.RegisterType((*SdkCloudMigrateStartResponse)(nil), "openstorage.api.SdkCloudMigrateStartResponse")
	proto.RegisterType((*CloudMigrateCancelRequest)(nil), "openstorage.api.CloudMigrateCancelRequest")
	proto.RegisterType((*SdkCloudMigrateCancelRequest)(nil), "openstorage.api.SdkCloudMigrateCancelRequest")
	proto.RegisterType((*SdkCloudMigrateCancelResponse)(nil), "openstorage.api.SdkCloudMigrateCancelResponse")
	proto.RegisterType((*CloudMigrateInfo)(nil), "openstorage.api.CloudMigrateInfo")
	proto.RegisterType((*CloudMigrateInfoList)(nil), "openstorage.api.CloudMigrateInfoList")
	proto.RegisterType((*SdkCloudMigrateStatusRequest)(nil), "openstorage.api.SdkCloudMigrateStatusRequest")
	proto.RegisterType((*CloudMigrateStatusRequest)(nil), "openstorage.api.CloudMigrateStatusRequest")
	proto.RegisterType((*CloudMigrateStatusResponse)(nil), "openstorage.api.CloudMigrateStatusResponse")
	proto.RegisterMapType((map[string]*CloudMigrateInfoList)(nil), "openstorage.api.CloudMigrateStatusResponse.InfoEntry")
	proto.RegisterType((*SdkCloudMigrateStatusResponse)(nil), "openstorage.api.SdkCloudMigrateStatusResponse")
	proto.RegisterType((*ClusterPairMode)(nil), "openstorage.api.ClusterPairMode")
	proto.RegisterType((*ClusterPairCreateRequest)(nil), "openstorage.api.ClusterPairCreateRequest")
	proto.RegisterType((*ClusterPairCreateResponse)(nil), "openstorage.api.ClusterPairCreateResponse")
	proto.RegisterType((*SdkClusterPairCreateRequest)(nil), "openstorage.api.SdkClusterPairCreateRequest")
	proto.RegisterType((*SdkClusterPairCreateResponse)(nil), "openstorage.api.SdkClusterPairCreateResponse")
	proto.RegisterType((*ClusterPairProcessRequest)(nil), "openstorage.api.ClusterPairProcessRequest")
	proto.RegisterType((*ClusterPairProcessResponse)(nil), "openstorage.api.ClusterPairProcessResponse")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.ClusterPairProcessResponse.OptionsEntry")
	proto.RegisterType((*SdkClusterPairDeleteRequest)(nil), "openstorage.api.SdkClusterPairDeleteRequest")
	proto.RegisterType((*SdkClusterPairDeleteResponse)(nil), "openstorage.api.SdkClusterPairDeleteResponse")
	proto.RegisterType((*ClusterPairTokenGetResponse)(nil), "openstorage.api.ClusterPairTokenGetResponse")
	proto.RegisterType((*SdkClusterPairGetTokenRequest)(nil), "openstorage.api.SdkClusterPairGetTokenRequest")
	proto.RegisterType((*SdkClusterPairGetTokenResponse)(nil), "openstorage.api.SdkClusterPairGetTokenResponse")
	proto.RegisterType((*SdkClusterPairResetTokenRequest)(nil), "openstorage.api.SdkClusterPairResetTokenRequest")
	proto.RegisterType((*SdkClusterPairResetTokenResponse)(nil), "openstorage.api.SdkClusterPairResetTokenResponse")
	proto.RegisterType((*ClusterPairInfo)(nil), "openstorage.api.ClusterPairInfo")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.ClusterPairInfo.OptionsEntry")
	proto.RegisterType((*SdkClusterPairInspectRequest)(nil), "openstorage.api.SdkClusterPairInspectRequest")
	proto.RegisterType((*ClusterPairGetResponse)(nil), "openstorage.api.ClusterPairGetResponse")
	proto.RegisterType((*SdkClusterPairInspectResponse)(nil), "openstorage.api.SdkClusterPairInspectResponse")
	proto.RegisterType((*SdkClusterPairEnumerateRequest)(nil), "openstorage.api.SdkClusterPairEnumerateRequest")
	proto.RegisterType((*ClusterPairsEnumerateResponse)(nil), "openstorage.api.ClusterPairsEnumerateResponse")
	proto.RegisterMapType((map[string]*ClusterPairInfo)(nil), "openstorage.api.ClusterPairsEnumerateResponse.PairsEntry")
	proto.RegisterType((*SdkClusterPairEnumerateResponse)(nil), "openstorage.api.SdkClusterPairEnumerateResponse")
	proto.RegisterType((*Catalog)(nil), "openstorage.api.Catalog")
	proto.RegisterType((*Report)(nil), "openstorage.api.Report")
	proto.RegisterType((*CatalogResponse)(nil), "openstorage.api.CatalogResponse")
	proto.RegisterType((*LocateResponse)(nil), "openstorage.api.LocateResponse")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.LocateResponse.DockeridsEntry")
	proto.RegisterMapType((map[string]string)(nil), "openstorage.api.LocateResponse.MountsEntry")
	proto.RegisterType((*VolumePlacementStrategy)(nil), "openstorage.api.VolumePlacementStrategy")
	proto.RegisterType((*VolumePlacementRule)(nil), "openstorage.api.VolumePlacementRule")
	proto.RegisterType((*LabelSelectorRequirement)(nil), "openstorage.api.LabelSelectorRequirement")
	proto.RegisterEnum("openstorage.api.Status", Status_name, Status_value)
	proto.RegisterEnum("openstorage.api.DriverType", DriverType_name, DriverType_value)
	proto.RegisterEnum("openstorage.api.FSType", FSType_name, FSType_value)
	proto.RegisterEnum("openstorage.api.GraphDriverChangeType", GraphDriverChangeType_name, GraphDriverChangeType_value)
	proto.RegisterEnum("openstorage.api.SeverityType", SeverityType_name, SeverityType_value)
	proto.RegisterEnum("openstorage.api.ResourceType", ResourceType_name, ResourceType_value)
	proto.RegisterEnum("openstorage.api.AlertActionType", AlertActionType_name, AlertActionType_value)
	proto.RegisterEnum("openstorage.api.VolumeActionParam", VolumeActionParam_name, VolumeActionParam_value)
	proto.RegisterEnum("openstorage.api.CosType", CosType_name, CosType_value)
	proto.RegisterEnum("openstorage.api.IoProfile", IoProfile_name, IoProfile_value)
	proto.RegisterEnum("openstorage.api.VolumeState", VolumeState_name, VolumeState_value)
	proto.RegisterEnum("openstorage.api.VolumeStatus", VolumeStatus_name, VolumeStatus_value)
	proto.RegisterEnum("openstorage.api.StorageMedium", StorageMedium_name, StorageMedium_value)
	proto.RegisterEnum("openstorage.api.AttachState", AttachState_name, AttachState_value)
	proto.RegisterEnum("openstorage.api.OperationFlags", OperationFlags_name, OperationFlags_value)
	proto.RegisterEnum("openstorage.api.SdkTimeWeekday", SdkTimeWeekday_name, SdkTimeWeekday_value)
	proto.RegisterEnum("openstorage.api.SdkCloudBackupOpType", SdkCloudBackupOpType_name, SdkCloudBackupOpType_value)
	proto.RegisterEnum("openstorage.api.SdkCloudBackupStatusType", SdkCloudBackupStatusType_name, SdkCloudBackupStatusType_value)
	proto.RegisterEnum("openstorage.api.SdkCloudBackupRequestedState", SdkCloudBackupRequestedState_name, SdkCloudBackupRequestedState_value)
	proto.RegisterEnum("openstorage.api.VolumeSpecPolicy_PolicyOp", VolumeSpecPolicy_PolicyOp_name, VolumeSpecPolicy_PolicyOp_value)
	proto.RegisterEnum("openstorage.api.Ownership_AccessType", Ownership_AccessType_name, Ownership_AccessType_value)
	proto.RegisterEnum("openstorage.api.SdkServiceCapability_OpenStorageService_Type", SdkServiceCapability_OpenStorageService_Type_name, SdkServiceCapability_OpenStorageService_Type_value)
	proto.RegisterEnum("openstorage.api.SdkVersion_Version", SdkVersion_Version_name, SdkVersion_Version_value)
	proto.RegisterEnum("openstorage.api.CloudMigrate_OperationType", CloudMigrate_OperationType_name, CloudMigrate_OperationType_value)
	proto.RegisterEnum("openstorage.api.CloudMigrate_Stage", CloudMigrate_Stage_name, CloudMigrate_Stage_value)
	proto.RegisterEnum("openstorage.api.CloudMigrate_Status", CloudMigrate_Status_name, CloudMigrate_Status_value)
	proto.RegisterEnum("openstorage.api.ClusterPairMode_Mode", ClusterPairMode_Mode_name, ClusterPairMode_Mode_value)
	proto.RegisterEnum("openstorage.api.VolumePlacementRule_EnforcementType", VolumePlacementRule_EnforcementType_name, VolumePlacementRule_EnforcementType_value)
	proto.RegisterEnum("openstorage.api.VolumePlacementRule_AffinityRuleType", VolumePlacementRule_AffinityRuleType_name, VolumePlacementRule_AffinityRuleType_value)
	proto.RegisterEnum("openstorage.api.LabelSelectorRequirement_Operator", LabelSelectorRequirement_Operator_name, LabelSelectorRequirement_Operator_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OpenStorageAlerts service

type OpenStorageAlertsClient interface {
	// Allows querying alerts.
	//
	// EnumerateWithFilters allows 3 different types of queries as defined below:
	//
	// * Query that takes only resource type as input
	// * Query that takes resource type and alert type as input and
	// * Query that takes resource id, alert type and resource type as input.
	//
	// #### Input
	// SdkAlertsEnumerateRequest takes a list of such queries and the returned
	// output is a collective ouput from each of these queries. In that sense,
	// the filtering of these queries has a behavior of OR operation.
	// Each query also has a list of optional options. These options allow
	// narrowing down the scope of alerts search. These options have a
	// behavior of an AND operation.
	//
	// #### Examples
	// To search by a resource type in a given time window would require
	// initializing SdkAlertsResourceTypeQuery query and pass in
	// SdkAlertsTimeSpan option into SdkAlertsQuery struct and finally
	// packing any other such queries into SdkAlertsEnumerateRequest object.
	// Alternatively, to search by both resource type and alert type, use
	// SdkAlertsAlertTypeQuery as query builder.
	// Finally to search all alerts of a given resource type and some
	// alerts of another resource type but with specific alert type,
	// use two queries, first initialized with SdkAlertsResourceTypeQuery
	// and second initialized with SdkAlertsAlertTypeQuery and both
	// eventually packed as list in SdkAlertsEnumerateRequest.
	EnumerateWithFilters(ctx context.Context, in *SdkAlertsEnumerateWithFiltersRequest, opts ...grpc.CallOption) (OpenStorageAlerts_EnumerateWithFiltersClient, error)
	// Delete alerts
	//
	// #### Delete
	// Delete allows 3 different types of queries as defined below:
	//
	// * Query that takes only resource type as input
	// * Query that takes resource type and alert type as input and
	// * Query that takes resource id, alert type and resource type as input.
	//
	// #### Input
	// SdkAlertsDeleteRequest takes a list of such queries and all alerts
	// that match at least one of the queries are deleted.
	Delete(ctx context.Context, in *SdkAlertsDeleteRequest, opts ...grpc.CallOption) (*SdkAlertsDeleteResponse, error)
}

type openStorageAlertsClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageAlertsClient(cc *grpc.ClientConn) OpenStorageAlertsClient {
	return &openStorageAlertsClient{cc}
}

func (c *openStorageAlertsClient) EnumerateWithFilters(ctx context.Context, in *SdkAlertsEnumerateWithFiltersRequest, opts ...grpc.CallOption) (OpenStorageAlerts_EnumerateWithFiltersClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OpenStorageAlerts_serviceDesc.Streams[0], c.cc, "/openstorage.api.OpenStorageAlerts/EnumerateWithFilters", opts...)
	if err != nil {
		return nil, err
	}
	x := &openStorageAlertsEnumerateWithFiltersClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type OpenStorageAlerts_EnumerateWithFiltersClient interface {
	Recv() (*SdkAlertsEnumerateWithFiltersResponse, error)
	grpc.ClientStream
}

type openStorageAlertsEnumerateWithFiltersClient struct {
	grpc.ClientStream
}

func (x *openStorageAlertsEnumerateWithFiltersClient) Recv() (*SdkAlertsEnumerateWithFiltersResponse, error) {
	m := new(SdkAlertsEnumerateWithFiltersResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *openStorageAlertsClient) Delete(ctx context.Context, in *SdkAlertsDeleteRequest, opts ...grpc.CallOption) (*SdkAlertsDeleteResponse, error) {
	out := new(SdkAlertsDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageAlerts/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageAlerts service

type OpenStorageAlertsServer interface {
	// Allows querying alerts.
	//
	// EnumerateWithFilters allows 3 different types of queries as defined below:
	//
	// * Query that takes only resource type as input
	// * Query that takes resource type and alert type as input and
	// * Query that takes resource id, alert type and resource type as input.
	//
	// #### Input
	// SdkAlertsEnumerateRequest takes a list of such queries and the returned
	// output is a collective ouput from each of these queries. In that sense,
	// the filtering of these queries has a behavior of OR operation.
	// Each query also has a list of optional options. These options allow
	// narrowing down the scope of alerts search. These options have a
	// behavior of an AND operation.
	//
	// #### Examples
	// To search by a resource type in a given time window would require
	// initializing SdkAlertsResourceTypeQuery query and pass in
	// SdkAlertsTimeSpan option into SdkAlertsQuery struct and finally
	// packing any other such queries into SdkAlertsEnumerateRequest object.
	// Alternatively, to search by both resource type and alert type, use
	// SdkAlertsAlertTypeQuery as query builder.
	// Finally to search all alerts of a given resource type and some
	// alerts of another resource type but with specific alert type,
	// use two queries, first initialized with SdkAlertsResourceTypeQuery
	// and second initialized with SdkAlertsAlertTypeQuery and both
	// eventually packed as list in SdkAlertsEnumerateRequest.
	EnumerateWithFilters(*SdkAlertsEnumerateWithFiltersRequest, OpenStorageAlerts_EnumerateWithFiltersServer) error
	// Delete alerts
	//
	// #### Delete
	// Delete allows 3 different types of queries as defined below:
	//
	// * Query that takes only resource type as input
	// * Query that takes resource type and alert type as input and
	// * Query that takes resource id, alert type and resource type as input.
	//
	// #### Input
	// SdkAlertsDeleteRequest takes a list of such queries and all alerts
	// that match at least one of the queries are deleted.
	Delete(context.Context, *SdkAlertsDeleteRequest) (*SdkAlertsDeleteResponse, error)
}

func RegisterOpenStorageAlertsServer(s *grpc.Server, srv OpenStorageAlertsServer) {
	s.RegisterService(&_OpenStorageAlerts_serviceDesc, srv)
}

func _OpenStorageAlerts_EnumerateWithFilters_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SdkAlertsEnumerateWithFiltersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(OpenStorageAlertsServer).EnumerateWithFilters(m, &openStorageAlertsEnumerateWithFiltersServer{stream})
}

type OpenStorageAlerts_EnumerateWithFiltersServer interface {
	Send(*SdkAlertsEnumerateWithFiltersResponse) error
	grpc.ServerStream
}

type openStorageAlertsEnumerateWithFiltersServer struct {
	grpc.ServerStream
}

func (x *openStorageAlertsEnumerateWithFiltersServer) Send(m *SdkAlertsEnumerateWithFiltersResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _OpenStorageAlerts_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkAlertsDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageAlertsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageAlerts/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageAlertsServer).Delete(ctx, req.(*SdkAlertsDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageAlerts_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageAlerts",
	HandlerType: (*OpenStorageAlertsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _OpenStorageAlerts_Delete_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "EnumerateWithFilters",
			Handler:       _OpenStorageAlerts_EnumerateWithFilters_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageRole service

type OpenStorageRoleClient interface {
	// Create a role for users in the system
	Create(ctx context.Context, in *SdkRoleCreateRequest, opts ...grpc.CallOption) (*SdkRoleCreateResponse, error)
	// List all roles
	Enumerate(ctx context.Context, in *SdkRoleEnumerateRequest, opts ...grpc.CallOption) (*SdkRoleEnumerateResponse, error)
	// Get information about a role
	Inspect(ctx context.Context, in *SdkRoleInspectRequest, opts ...grpc.CallOption) (*SdkRoleInspectResponse, error)
	// Delete an existing role
	Delete(ctx context.Context, in *SdkRoleDeleteRequest, opts ...grpc.CallOption) (*SdkRoleDeleteResponse, error)
	// Update an existing role
	Update(ctx context.Context, in *SdkRoleUpdateRequest, opts ...grpc.CallOption) (*SdkRoleUpdateResponse, error)
}

type openStorageRoleClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageRoleClient(cc *grpc.ClientConn) OpenStorageRoleClient {
	return &openStorageRoleClient{cc}
}

func (c *openStorageRoleClient) Create(ctx context.Context, in *SdkRoleCreateRequest, opts ...grpc.CallOption) (*SdkRoleCreateResponse, error) {
	out := new(SdkRoleCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageRole/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageRoleClient) Enumerate(ctx context.Context, in *SdkRoleEnumerateRequest, opts ...grpc.CallOption) (*SdkRoleEnumerateResponse, error) {
	out := new(SdkRoleEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageRole/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageRoleClient) Inspect(ctx context.Context, in *SdkRoleInspectRequest, opts ...grpc.CallOption) (*SdkRoleInspectResponse, error) {
	out := new(SdkRoleInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageRole/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageRoleClient) Delete(ctx context.Context, in *SdkRoleDeleteRequest, opts ...grpc.CallOption) (*SdkRoleDeleteResponse, error) {
	out := new(SdkRoleDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageRole/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageRoleClient) Update(ctx context.Context, in *SdkRoleUpdateRequest, opts ...grpc.CallOption) (*SdkRoleUpdateResponse, error) {
	out := new(SdkRoleUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageRole/Update", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageRole service

type OpenStorageRoleServer interface {
	// Create a role for users in the system
	Create(context.Context, *SdkRoleCreateRequest) (*SdkRoleCreateResponse, error)
	// List all roles
	Enumerate(context.Context, *SdkRoleEnumerateRequest) (*SdkRoleEnumerateResponse, error)
	// Get information about a role
	Inspect(context.Context, *SdkRoleInspectRequest) (*SdkRoleInspectResponse, error)
	// Delete an existing role
	Delete(context.Context, *SdkRoleDeleteRequest) (*SdkRoleDeleteResponse, error)
	// Update an existing role
	Update(context.Context, *SdkRoleUpdateRequest) (*SdkRoleUpdateResponse, error)
}

func RegisterOpenStorageRoleServer(s *grpc.Server, srv OpenStorageRoleServer) {
	s.RegisterService(&_OpenStorageRole_serviceDesc, srv)
}

func _OpenStorageRole_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkRoleCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageRoleServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageRole/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageRoleServer).Create(ctx, req.(*SdkRoleCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageRole_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkRoleEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageRoleServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageRole/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageRoleServer).Enumerate(ctx, req.(*SdkRoleEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageRole_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkRoleInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageRoleServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageRole/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageRoleServer).Inspect(ctx, req.(*SdkRoleInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageRole_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkRoleDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageRoleServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageRole/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageRoleServer).Delete(ctx, req.(*SdkRoleDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageRole_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkRoleUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageRoleServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageRole/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageRoleServer).Update(ctx, req.(*SdkRoleUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageRole_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageRole",
	HandlerType: (*OpenStorageRoleServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageRole_Create_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageRole_Enumerate_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageRole_Inspect_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageRole_Delete_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _OpenStorageRole_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageIdentity service

type OpenStorageIdentityClient interface {
	// Capabilities returns the supported services by the cluster.
	// This allows SDK implementations to advertise their supported
	// services as the API matures. With this information, clients
	// can determine supported services from storage clusters at
	// different versions.
	Capabilities(ctx context.Context, in *SdkIdentityCapabilitiesRequest, opts ...grpc.CallOption) (*SdkIdentityCapabilitiesResponse, error)
	// Version returns version information about the system.
	Version(ctx context.Context, in *SdkIdentityVersionRequest, opts ...grpc.CallOption) (*SdkIdentityVersionResponse, error)
}

type openStorageIdentityClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageIdentityClient(cc *grpc.ClientConn) OpenStorageIdentityClient {
	return &openStorageIdentityClient{cc}
}

func (c *openStorageIdentityClient) Capabilities(ctx context.Context, in *SdkIdentityCapabilitiesRequest, opts ...grpc.CallOption) (*SdkIdentityCapabilitiesResponse, error) {
	out := new(SdkIdentityCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageIdentity/Capabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageIdentityClient) Version(ctx context.Context, in *SdkIdentityVersionRequest, opts ...grpc.CallOption) (*SdkIdentityVersionResponse, error) {
	out := new(SdkIdentityVersionResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageIdentity/Version", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageIdentity service

type OpenStorageIdentityServer interface {
	// Capabilities returns the supported services by the cluster.
	// This allows SDK implementations to advertise their supported
	// services as the API matures. With this information, clients
	// can determine supported services from storage clusters at
	// different versions.
	Capabilities(context.Context, *SdkIdentityCapabilitiesRequest) (*SdkIdentityCapabilitiesResponse, error)
	// Version returns version information about the system.
	Version(context.Context, *SdkIdentityVersionRequest) (*SdkIdentityVersionResponse, error)
}

func RegisterOpenStorageIdentityServer(s *grpc.Server, srv OpenStorageIdentityServer) {
	s.RegisterService(&_OpenStorageIdentity_serviceDesc, srv)
}

func _OpenStorageIdentity_Capabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkIdentityCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageIdentityServer).Capabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageIdentity/Capabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageIdentityServer).Capabilities(ctx, req.(*SdkIdentityCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageIdentity_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkIdentityVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageIdentityServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageIdentity/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageIdentityServer).Version(ctx, req.(*SdkIdentityVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageIdentity_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageIdentity",
	HandlerType: (*OpenStorageIdentityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Capabilities",
			Handler:    _OpenStorageIdentity_Capabilities_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _OpenStorageIdentity_Version_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageCluster service

type OpenStorageClusterClient interface {
	// InspectCurrent returns information about the current cluster
	InspectCurrent(ctx context.Context, in *SdkClusterInspectCurrentRequest, opts ...grpc.CallOption) (*SdkClusterInspectCurrentResponse, error)
}

type openStorageClusterClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageClusterClient(cc *grpc.ClientConn) OpenStorageClusterClient {
	return &openStorageClusterClient{cc}
}

func (c *openStorageClusterClient) InspectCurrent(ctx context.Context, in *SdkClusterInspectCurrentRequest, opts ...grpc.CallOption) (*SdkClusterInspectCurrentResponse, error) {
	out := new(SdkClusterInspectCurrentResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCluster/InspectCurrent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageCluster service

type OpenStorageClusterServer interface {
	// InspectCurrent returns information about the current cluster
	InspectCurrent(context.Context, *SdkClusterInspectCurrentRequest) (*SdkClusterInspectCurrentResponse, error)
}

func RegisterOpenStorageClusterServer(s *grpc.Server, srv OpenStorageClusterServer) {
	s.RegisterService(&_OpenStorageCluster_serviceDesc, srv)
}

func _OpenStorageCluster_InspectCurrent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterInspectCurrentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterServer).InspectCurrent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCluster/InspectCurrent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterServer).InspectCurrent(ctx, req.(*SdkClusterInspectCurrentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageCluster_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageCluster",
	HandlerType: (*OpenStorageClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InspectCurrent",
			Handler:    _OpenStorageCluster_InspectCurrent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageClusterPair service

type OpenStorageClusterPairClient interface {
	// Creates Pair with a remote cluster and returns details about the remote cluster
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkClusterPairCreateRequest {
	//   Request : &api.ClusterPairCreateRequest {
	//                  RemoteClusterIp: "127.0.0.1",
	//                  RemoteClusterPort: 12345,
	//                  RemoteClusterToken: "<Auth-Token>",
	//                  SetDefault: true,
	//              }
	//        })
	// {%- endcodetabs %}
	Create(ctx context.Context, in *SdkClusterPairCreateRequest, opts ...grpc.CallOption) (*SdkClusterPairCreateResponse, error)
	// Inspect information about a cluster pair
	Inspect(ctx context.Context, in *SdkClusterPairInspectRequest, opts ...grpc.CallOption) (*SdkClusterPairInspectResponse, error)
	// Enumerate returns list of cluster pairs
	Enumerate(ctx context.Context, in *SdkClusterPairEnumerateRequest, opts ...grpc.CallOption) (*SdkClusterPairEnumerateResponse, error)
	// GetToken returns a auth token
	GetToken(ctx context.Context, in *SdkClusterPairGetTokenRequest, opts ...grpc.CallOption) (*SdkClusterPairGetTokenResponse, error)
	// ResetToken returns a auth token
	ResetToken(ctx context.Context, in *SdkClusterPairResetTokenRequest, opts ...grpc.CallOption) (*SdkClusterPairResetTokenResponse, error)
	// Delete a cluster pair
	Delete(ctx context.Context, in *SdkClusterPairDeleteRequest, opts ...grpc.CallOption) (*SdkClusterPairDeleteResponse, error)
}

type openStorageClusterPairClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageClusterPairClient(cc *grpc.ClientConn) OpenStorageClusterPairClient {
	return &openStorageClusterPairClient{cc}
}

func (c *openStorageClusterPairClient) Create(ctx context.Context, in *SdkClusterPairCreateRequest, opts ...grpc.CallOption) (*SdkClusterPairCreateResponse, error) {
	out := new(SdkClusterPairCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterPairClient) Inspect(ctx context.Context, in *SdkClusterPairInspectRequest, opts ...grpc.CallOption) (*SdkClusterPairInspectResponse, error) {
	out := new(SdkClusterPairInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterPairClient) Enumerate(ctx context.Context, in *SdkClusterPairEnumerateRequest, opts ...grpc.CallOption) (*SdkClusterPairEnumerateResponse, error) {
	out := new(SdkClusterPairEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterPairClient) GetToken(ctx context.Context, in *SdkClusterPairGetTokenRequest, opts ...grpc.CallOption) (*SdkClusterPairGetTokenResponse, error) {
	out := new(SdkClusterPairGetTokenResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/GetToken", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterPairClient) ResetToken(ctx context.Context, in *SdkClusterPairResetTokenRequest, opts ...grpc.CallOption) (*SdkClusterPairResetTokenResponse, error) {
	out := new(SdkClusterPairResetTokenResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/ResetToken", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterPairClient) Delete(ctx context.Context, in *SdkClusterPairDeleteRequest, opts ...grpc.CallOption) (*SdkClusterPairDeleteResponse, error) {
	out := new(SdkClusterPairDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterPair/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageClusterPair service

type OpenStorageClusterPairServer interface {
	// Creates Pair with a remote cluster and returns details about the remote cluster
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkClusterPairCreateRequest {
	//   Request : &api.ClusterPairCreateRequest {
	//                  RemoteClusterIp: "127.0.0.1",
	//                  RemoteClusterPort: 12345,
	//                  RemoteClusterToken: "<Auth-Token>",
	//                  SetDefault: true,
	//              }
	//        })
	// {%- endcodetabs %}
	Create(context.Context, *SdkClusterPairCreateRequest) (*SdkClusterPairCreateResponse, error)
	// Inspect information about a cluster pair
	Inspect(context.Context, *SdkClusterPairInspectRequest) (*SdkClusterPairInspectResponse, error)
	// Enumerate returns list of cluster pairs
	Enumerate(context.Context, *SdkClusterPairEnumerateRequest) (*SdkClusterPairEnumerateResponse, error)
	// GetToken returns a auth token
	GetToken(context.Context, *SdkClusterPairGetTokenRequest) (*SdkClusterPairGetTokenResponse, error)
	// ResetToken returns a auth token
	ResetToken(context.Context, *SdkClusterPairResetTokenRequest) (*SdkClusterPairResetTokenResponse, error)
	// Delete a cluster pair
	Delete(context.Context, *SdkClusterPairDeleteRequest) (*SdkClusterPairDeleteResponse, error)
}

func RegisterOpenStorageClusterPairServer(s *grpc.Server, srv OpenStorageClusterPairServer) {
	s.RegisterService(&_OpenStorageClusterPair_serviceDesc, srv)
}

func _OpenStorageClusterPair_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).Create(ctx, req.(*SdkClusterPairCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterPair_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).Inspect(ctx, req.(*SdkClusterPairInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterPair_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).Enumerate(ctx, req.(*SdkClusterPairEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterPair_GetToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairGetTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).GetToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/GetToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).GetToken(ctx, req.(*SdkClusterPairGetTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterPair_ResetToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairResetTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).ResetToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/ResetToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).ResetToken(ctx, req.(*SdkClusterPairResetTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterPair_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterPairDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterPairServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterPair/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterPairServer).Delete(ctx, req.(*SdkClusterPairDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageClusterPair_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageClusterPair",
	HandlerType: (*OpenStorageClusterPairServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageClusterPair_Create_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageClusterPair_Inspect_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageClusterPair_Enumerate_Handler,
		},
		{
			MethodName: "GetToken",
			Handler:    _OpenStorageClusterPair_GetToken_Handler,
		},
		{
			MethodName: "ResetToken",
			Handler:    _OpenStorageClusterPair_ResetToken_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageClusterPair_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageClusterDomains service

type OpenStorageClusterDomainsClient interface {
	// Enumerate returns names of all the cluster domains in the cluster
	Enumerate(ctx context.Context, in *SdkClusterDomainsEnumerateRequest, opts ...grpc.CallOption) (*SdkClusterDomainsEnumerateResponse, error)
	// Inspect returns information about a cluster domain and a
	// status indicating whether the cluster domain is active
	Inspect(ctx context.Context, in *SdkClusterDomainInspectRequest, opts ...grpc.CallOption) (*SdkClusterDomainInspectResponse, error)
	// Activates a cluster domain in the cluster.
	// All the nodes which are part of an active cluster domain
	// will participate in cluster quorum calculation
	Activate(ctx context.Context, in *SdkClusterDomainActivateRequest, opts ...grpc.CallOption) (*SdkClusterDomainActivateResponse, error)
	// Deactivates a cluster domain in the cluster.
	// All the nodes which are part of a deactivated cluster domain.
	// will not participate in cluster quorum calculation
	Deactivate(ctx context.Context, in *SdkClusterDomainDeactivateRequest, opts ...grpc.CallOption) (*SdkClusterDomainDeactivateResponse, error)
}

type openStorageClusterDomainsClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageClusterDomainsClient(cc *grpc.ClientConn) OpenStorageClusterDomainsClient {
	return &openStorageClusterDomainsClient{cc}
}

func (c *openStorageClusterDomainsClient) Enumerate(ctx context.Context, in *SdkClusterDomainsEnumerateRequest, opts ...grpc.CallOption) (*SdkClusterDomainsEnumerateResponse, error) {
	out := new(SdkClusterDomainsEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterDomains/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterDomainsClient) Inspect(ctx context.Context, in *SdkClusterDomainInspectRequest, opts ...grpc.CallOption) (*SdkClusterDomainInspectResponse, error) {
	out := new(SdkClusterDomainInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterDomains/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterDomainsClient) Activate(ctx context.Context, in *SdkClusterDomainActivateRequest, opts ...grpc.CallOption) (*SdkClusterDomainActivateResponse, error) {
	out := new(SdkClusterDomainActivateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterDomains/Activate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageClusterDomainsClient) Deactivate(ctx context.Context, in *SdkClusterDomainDeactivateRequest, opts ...grpc.CallOption) (*SdkClusterDomainDeactivateResponse, error) {
	out := new(SdkClusterDomainDeactivateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageClusterDomains/Deactivate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageClusterDomains service

type OpenStorageClusterDomainsServer interface {
	// Enumerate returns names of all the cluster domains in the cluster
	Enumerate(context.Context, *SdkClusterDomainsEnumerateRequest) (*SdkClusterDomainsEnumerateResponse, error)
	// Inspect returns information about a cluster domain and a
	// status indicating whether the cluster domain is active
	Inspect(context.Context, *SdkClusterDomainInspectRequest) (*SdkClusterDomainInspectResponse, error)
	// Activates a cluster domain in the cluster.
	// All the nodes which are part of an active cluster domain
	// will participate in cluster quorum calculation
	Activate(context.Context, *SdkClusterDomainActivateRequest) (*SdkClusterDomainActivateResponse, error)
	// Deactivates a cluster domain in the cluster.
	// All the nodes which are part of a deactivated cluster domain.
	// will not participate in cluster quorum calculation
	Deactivate(context.Context, *SdkClusterDomainDeactivateRequest) (*SdkClusterDomainDeactivateResponse, error)
}

func RegisterOpenStorageClusterDomainsServer(s *grpc.Server, srv OpenStorageClusterDomainsServer) {
	s.RegisterService(&_OpenStorageClusterDomains_serviceDesc, srv)
}

func _OpenStorageClusterDomains_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterDomainsEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterDomainsServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterDomains/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterDomainsServer).Enumerate(ctx, req.(*SdkClusterDomainsEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterDomains_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterDomainInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterDomainsServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterDomains/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterDomainsServer).Inspect(ctx, req.(*SdkClusterDomainInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterDomains_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterDomainActivateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterDomainsServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterDomains/Activate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterDomainsServer).Activate(ctx, req.(*SdkClusterDomainActivateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageClusterDomains_Deactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkClusterDomainDeactivateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageClusterDomainsServer).Deactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageClusterDomains/Deactivate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageClusterDomainsServer).Deactivate(ctx, req.(*SdkClusterDomainDeactivateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageClusterDomains_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageClusterDomains",
	HandlerType: (*OpenStorageClusterDomainsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageClusterDomains_Enumerate_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageClusterDomains_Inspect_Handler,
		},
		{
			MethodName: "Activate",
			Handler:    _OpenStorageClusterDomains_Activate_Handler,
		},
		{
			MethodName: "Deactivate",
			Handler:    _OpenStorageClusterDomains_Deactivate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageNode service

type OpenStorageNodeClient interface {
	// Inspect returns information about the specified node
	Inspect(ctx context.Context, in *SdkNodeInspectRequest, opts ...grpc.CallOption) (*SdkNodeInspectResponse, error)
	// InspectCurrent returns information about the storage node
	// where the client is currently connected to.
	InspectCurrent(ctx context.Context, in *SdkNodeInspectCurrentRequest, opts ...grpc.CallOption) (*SdkNodeInspectCurrentResponse, error)
	// Enumerate returns the ids of all the nodes in the current cluster
	Enumerate(ctx context.Context, in *SdkNodeEnumerateRequest, opts ...grpc.CallOption) (*SdkNodeEnumerateResponse, error)
}

type openStorageNodeClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageNodeClient(cc *grpc.ClientConn) OpenStorageNodeClient {
	return &openStorageNodeClient{cc}
}

func (c *openStorageNodeClient) Inspect(ctx context.Context, in *SdkNodeInspectRequest, opts ...grpc.CallOption) (*SdkNodeInspectResponse, error) {
	out := new(SdkNodeInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageNode/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageNodeClient) InspectCurrent(ctx context.Context, in *SdkNodeInspectCurrentRequest, opts ...grpc.CallOption) (*SdkNodeInspectCurrentResponse, error) {
	out := new(SdkNodeInspectCurrentResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageNode/InspectCurrent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageNodeClient) Enumerate(ctx context.Context, in *SdkNodeEnumerateRequest, opts ...grpc.CallOption) (*SdkNodeEnumerateResponse, error) {
	out := new(SdkNodeEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageNode/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageNode service

type OpenStorageNodeServer interface {
	// Inspect returns information about the specified node
	Inspect(context.Context, *SdkNodeInspectRequest) (*SdkNodeInspectResponse, error)
	// InspectCurrent returns information about the storage node
	// where the client is currently connected to.
	InspectCurrent(context.Context, *SdkNodeInspectCurrentRequest) (*SdkNodeInspectCurrentResponse, error)
	// Enumerate returns the ids of all the nodes in the current cluster
	Enumerate(context.Context, *SdkNodeEnumerateRequest) (*SdkNodeEnumerateResponse, error)
}

func RegisterOpenStorageNodeServer(s *grpc.Server, srv OpenStorageNodeServer) {
	s.RegisterService(&_OpenStorageNode_serviceDesc, srv)
}

func _OpenStorageNode_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkNodeInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageNodeServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageNode/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageNodeServer).Inspect(ctx, req.(*SdkNodeInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageNode_InspectCurrent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkNodeInspectCurrentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageNodeServer).InspectCurrent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageNode/InspectCurrent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageNodeServer).InspectCurrent(ctx, req.(*SdkNodeInspectCurrentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageNode_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkNodeEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageNodeServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageNode/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageNodeServer).Enumerate(ctx, req.(*SdkNodeEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageNode_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageNode",
	HandlerType: (*OpenStorageNodeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageNode_Inspect_Handler,
		},
		{
			MethodName: "InspectCurrent",
			Handler:    _OpenStorageNode_InspectCurrent_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageNode_Enumerate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageVolume service

type OpenStorageVolumeClient interface {
	// Create creates a volume according to the specification provided
	//
	// Requires access AccessType.Read when cloning from a parent volume.
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkVolumeCreateRequest{
	//   Name: "volume-12345-east",
	//   Spec: &api.VolumeSpec {
	//     Size: 1234567,
	//   },
	// })
	// {%- language name="Python", type="py" -%}
	// en_resp = client.Create(api_pb2.SdkVolumeCreateRequest(
	//   name="volume-12345-east",
	//   spec=api_pb2.VolumeSpec(size=1234567)))
	// {%- endcodetabs %}
	Create(ctx context.Context, in *SdkVolumeCreateRequest, opts ...grpc.CallOption) (*SdkVolumeCreateResponse, error)
	// Clone creates a new writable volume cloned from an existing volume
	//
	// Requires access AccessType.Read of volume
	Clone(ctx context.Context, in *SdkVolumeCloneRequest, opts ...grpc.CallOption) (*SdkVolumeCloneResponse, error)
	// Delete deletes the provided volume
	//
	// Requires access AccessType.Admin of volume
	Delete(ctx context.Context, in *SdkVolumeDeleteRequest, opts ...grpc.CallOption) (*SdkVolumeDeleteResponse, error)
	// Inspect returns information about a volume
	//
	// Requires access AccessType.Read of volume
	Inspect(ctx context.Context, in *SdkVolumeInspectRequest, opts ...grpc.CallOption) (*SdkVolumeInspectResponse, error)
	// Returns information for a list of volumes that match a filter.
	// This call is a helper function like calling
	// `OpenStorageVolume.EnumerateWithFilters` then having it
	// return the contents of each of those volumes
	// `OpenStorageVolume.Inspect()`. Take care in using this call
	// when requesting large number of volumes because it will
	// block until it has all the information requested before
	// returning.
	InspectWithFilters(ctx context.Context, in *SdkVolumeInspectWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeInspectWithFiltersResponse, error)
	// Update provides a method for manipulating the specification and attributes of a volume.
	// Set can be used to resize a volume, update labels, change replica count, and much more.
	//
	// Requires access AccessType.Write of volume
	Update(ctx context.Context, in *SdkVolumeUpdateRequest, opts ...grpc.CallOption) (*SdkVolumeUpdateResponse, error)
	// Stats returns the statistics for the requested volume
	//
	// Requires access AccessType.Read of volume
	Stats(ctx context.Context, in *SdkVolumeStatsRequest, opts ...grpc.CallOption) (*SdkVolumeStatsResponse, error)
	// CapacityUsage returns volume/snapshot's capacity usage details
	//
	// Requires access AccessType.Read of volume
	//
	// ##### Error codes:
	//
	// * codes.Aborted : Command was aborted and only total_bytes field is valid
	// * code.Unimmplemented : Command is not suported this kernel.Only total_bytes
	// field is valid;
	CapacityUsage(ctx context.Context, in *SdkVolumeCapacityUsageRequest, opts ...grpc.CallOption) (*SdkVolumeCapacityUsageResponse, error)
	// Enumerate returns a list of volume ids
	Enumerate(ctx context.Context, in *SdkVolumeEnumerateRequest, opts ...grpc.CallOption) (*SdkVolumeEnumerateResponse, error)
	// Enumerate returns a list of volume ids that match the labels if any are provided.
	EnumerateWithFilters(ctx context.Context, in *SdkVolumeEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeEnumerateWithFiltersResponse, error)
	// SnapshotCreate creates a snapshot of a volume. This creates an immutable (read-only),
	// point-in-time snapshot of a volume. To create a new writable volume from
	// a snapshot, please use OpenStorageVolume.Clone().
	//
	// Requires access AccessType.Read of volume
	SnapshotCreate(ctx context.Context, in *SdkVolumeSnapshotCreateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotCreateResponse, error)
	// SnapshotRestore restores a volume to a specified snapshot
	//
	// Requires access AccessType.Write of volume
	SnapshotRestore(ctx context.Context, in *SdkVolumeSnapshotRestoreRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotRestoreResponse, error)
	// SnapshotEnumerate returns a list of snapshots for a specific volume
	SnapshotEnumerate(ctx context.Context, in *SdkVolumeSnapshotEnumerateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotEnumerateResponse, error)
	// SnapshotEnumerate returns a list of snapshots.
	// To filter all the snapshots for a specific volume which may no longer exist,
	// specifiy a volume id.
	// Labels can also be used to filter the snapshot list.
	// If neither are provided all snapshots will be returned.
	SnapshotEnumerateWithFilters(ctx context.Context, in *SdkVolumeSnapshotEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotEnumerateWithFiltersResponse, error)
	// Sets the snapshot schedules. This information is saved in the VolumeSpec.snapshot_schedule
	// as `policy=<name>,...`. This function will overwrite any policy values
	// in the volume. To delete the policies in the volume send no policies.
	//
	// Requires access AccessType.Write of volume
	SnapshotScheduleUpdate(ctx context.Context, in *SdkVolumeSnapshotScheduleUpdateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotScheduleUpdateResponse, error)
}

type openStorageVolumeClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageVolumeClient(cc *grpc.ClientConn) OpenStorageVolumeClient {
	return &openStorageVolumeClient{cc}
}

func (c *openStorageVolumeClient) Create(ctx context.Context, in *SdkVolumeCreateRequest, opts ...grpc.CallOption) (*SdkVolumeCreateResponse, error) {
	out := new(SdkVolumeCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Clone(ctx context.Context, in *SdkVolumeCloneRequest, opts ...grpc.CallOption) (*SdkVolumeCloneResponse, error) {
	out := new(SdkVolumeCloneResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Clone", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Delete(ctx context.Context, in *SdkVolumeDeleteRequest, opts ...grpc.CallOption) (*SdkVolumeDeleteResponse, error) {
	out := new(SdkVolumeDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Inspect(ctx context.Context, in *SdkVolumeInspectRequest, opts ...grpc.CallOption) (*SdkVolumeInspectResponse, error) {
	out := new(SdkVolumeInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) InspectWithFilters(ctx context.Context, in *SdkVolumeInspectWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeInspectWithFiltersResponse, error) {
	out := new(SdkVolumeInspectWithFiltersResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/InspectWithFilters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Update(ctx context.Context, in *SdkVolumeUpdateRequest, opts ...grpc.CallOption) (*SdkVolumeUpdateResponse, error) {
	out := new(SdkVolumeUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Update", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Stats(ctx context.Context, in *SdkVolumeStatsRequest, opts ...grpc.CallOption) (*SdkVolumeStatsResponse, error) {
	out := new(SdkVolumeStatsResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Stats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) CapacityUsage(ctx context.Context, in *SdkVolumeCapacityUsageRequest, opts ...grpc.CallOption) (*SdkVolumeCapacityUsageResponse, error) {
	out := new(SdkVolumeCapacityUsageResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/CapacityUsage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) Enumerate(ctx context.Context, in *SdkVolumeEnumerateRequest, opts ...grpc.CallOption) (*SdkVolumeEnumerateResponse, error) {
	out := new(SdkVolumeEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) EnumerateWithFilters(ctx context.Context, in *SdkVolumeEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeEnumerateWithFiltersResponse, error) {
	out := new(SdkVolumeEnumerateWithFiltersResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/EnumerateWithFilters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) SnapshotCreate(ctx context.Context, in *SdkVolumeSnapshotCreateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotCreateResponse, error) {
	out := new(SdkVolumeSnapshotCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/SnapshotCreate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) SnapshotRestore(ctx context.Context, in *SdkVolumeSnapshotRestoreRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotRestoreResponse, error) {
	out := new(SdkVolumeSnapshotRestoreResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/SnapshotRestore", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) SnapshotEnumerate(ctx context.Context, in *SdkVolumeSnapshotEnumerateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotEnumerateResponse, error) {
	out := new(SdkVolumeSnapshotEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/SnapshotEnumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) SnapshotEnumerateWithFilters(ctx context.Context, in *SdkVolumeSnapshotEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotEnumerateWithFiltersResponse, error) {
	out := new(SdkVolumeSnapshotEnumerateWithFiltersResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/SnapshotEnumerateWithFilters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageVolumeClient) SnapshotScheduleUpdate(ctx context.Context, in *SdkVolumeSnapshotScheduleUpdateRequest, opts ...grpc.CallOption) (*SdkVolumeSnapshotScheduleUpdateResponse, error) {
	out := new(SdkVolumeSnapshotScheduleUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageVolume/SnapshotScheduleUpdate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageVolume service

type OpenStorageVolumeServer interface {
	// Create creates a volume according to the specification provided
	//
	// Requires access AccessType.Read when cloning from a parent volume.
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkVolumeCreateRequest{
	//   Name: "volume-12345-east",
	//   Spec: &api.VolumeSpec {
	//     Size: 1234567,
	//   },
	// })
	// {%- language name="Python", type="py" -%}
	// en_resp = client.Create(api_pb2.SdkVolumeCreateRequest(
	//   name="volume-12345-east",
	//   spec=api_pb2.VolumeSpec(size=1234567)))
	// {%- endcodetabs %}
	Create(context.Context, *SdkVolumeCreateRequest) (*SdkVolumeCreateResponse, error)
	// Clone creates a new writable volume cloned from an existing volume
	//
	// Requires access AccessType.Read of volume
	Clone(context.Context, *SdkVolumeCloneRequest) (*SdkVolumeCloneResponse, error)
	// Delete deletes the provided volume
	//
	// Requires access AccessType.Admin of volume
	Delete(context.Context, *SdkVolumeDeleteRequest) (*SdkVolumeDeleteResponse, error)
	// Inspect returns information about a volume
	//
	// Requires access AccessType.Read of volume
	Inspect(context.Context, *SdkVolumeInspectRequest) (*SdkVolumeInspectResponse, error)
	// Returns information for a list of volumes that match a filter.
	// This call is a helper function like calling
	// `OpenStorageVolume.EnumerateWithFilters` then having it
	// return the contents of each of those volumes
	// `OpenStorageVolume.Inspect()`. Take care in using this call
	// when requesting large number of volumes because it will
	// block until it has all the information requested before
	// returning.
	InspectWithFilters(context.Context, *SdkVolumeInspectWithFiltersRequest) (*SdkVolumeInspectWithFiltersResponse, error)
	// Update provides a method for manipulating the specification and attributes of a volume.
	// Set can be used to resize a volume, update labels, change replica count, and much more.
	//
	// Requires access AccessType.Write of volume
	Update(context.Context, *SdkVolumeUpdateRequest) (*SdkVolumeUpdateResponse, error)
	// Stats returns the statistics for the requested volume
	//
	// Requires access AccessType.Read of volume
	Stats(context.Context, *SdkVolumeStatsRequest) (*SdkVolumeStatsResponse, error)
	// CapacityUsage returns volume/snapshot's capacity usage details
	//
	// Requires access AccessType.Read of volume
	//
	// ##### Error codes:
	//
	// * codes.Aborted : Command was aborted and only total_bytes field is valid
	// * code.Unimmplemented : Command is not suported this kernel.Only total_bytes
	// field is valid;
	CapacityUsage(context.Context, *SdkVolumeCapacityUsageRequest) (*SdkVolumeCapacityUsageResponse, error)
	// Enumerate returns a list of volume ids
	Enumerate(context.Context, *SdkVolumeEnumerateRequest) (*SdkVolumeEnumerateResponse, error)
	// Enumerate returns a list of volume ids that match the labels if any are provided.
	EnumerateWithFilters(context.Context, *SdkVolumeEnumerateWithFiltersRequest) (*SdkVolumeEnumerateWithFiltersResponse, error)
	// SnapshotCreate creates a snapshot of a volume. This creates an immutable (read-only),
	// point-in-time snapshot of a volume. To create a new writable volume from
	// a snapshot, please use OpenStorageVolume.Clone().
	//
	// Requires access AccessType.Read of volume
	SnapshotCreate(context.Context, *SdkVolumeSnapshotCreateRequest) (*SdkVolumeSnapshotCreateResponse, error)
	// SnapshotRestore restores a volume to a specified snapshot
	//
	// Requires access AccessType.Write of volume
	SnapshotRestore(context.Context, *SdkVolumeSnapshotRestoreRequest) (*SdkVolumeSnapshotRestoreResponse, error)
	// SnapshotEnumerate returns a list of snapshots for a specific volume
	SnapshotEnumerate(context.Context, *SdkVolumeSnapshotEnumerateRequest) (*SdkVolumeSnapshotEnumerateResponse, error)
	// SnapshotEnumerate returns a list of snapshots.
	// To filter all the snapshots for a specific volume which may no longer exist,
	// specifiy a volume id.
	// Labels can also be used to filter the snapshot list.
	// If neither are provided all snapshots will be returned.
	SnapshotEnumerateWithFilters(context.Context, *SdkVolumeSnapshotEnumerateWithFiltersRequest) (*SdkVolumeSnapshotEnumerateWithFiltersResponse, error)
	// Sets the snapshot schedules. This information is saved in the VolumeSpec.snapshot_schedule
	// as `policy=<name>,...`. This function will overwrite any policy values
	// in the volume. To delete the policies in the volume send no policies.
	//
	// Requires access AccessType.Write of volume
	SnapshotScheduleUpdate(context.Context, *SdkVolumeSnapshotScheduleUpdateRequest) (*SdkVolumeSnapshotScheduleUpdateResponse, error)
}

func RegisterOpenStorageVolumeServer(s *grpc.Server, srv OpenStorageVolumeServer) {
	s.RegisterService(&_OpenStorageVolume_serviceDesc, srv)
}

func _OpenStorageVolume_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Create(ctx, req.(*SdkVolumeCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Clone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeCloneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Clone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Clone",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Clone(ctx, req.(*SdkVolumeCloneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Delete(ctx, req.(*SdkVolumeDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Inspect(ctx, req.(*SdkVolumeInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_InspectWithFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeInspectWithFiltersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).InspectWithFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/InspectWithFilters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).InspectWithFilters(ctx, req.(*SdkVolumeInspectWithFiltersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Update(ctx, req.(*SdkVolumeUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Stats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Stats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Stats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Stats(ctx, req.(*SdkVolumeStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_CapacityUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeCapacityUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).CapacityUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/CapacityUsage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).CapacityUsage(ctx, req.(*SdkVolumeCapacityUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).Enumerate(ctx, req.(*SdkVolumeEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_EnumerateWithFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeEnumerateWithFiltersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).EnumerateWithFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/EnumerateWithFilters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).EnumerateWithFilters(ctx, req.(*SdkVolumeEnumerateWithFiltersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_SnapshotCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeSnapshotCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).SnapshotCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/SnapshotCreate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).SnapshotCreate(ctx, req.(*SdkVolumeSnapshotCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_SnapshotRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeSnapshotRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).SnapshotRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/SnapshotRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).SnapshotRestore(ctx, req.(*SdkVolumeSnapshotRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_SnapshotEnumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeSnapshotEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).SnapshotEnumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/SnapshotEnumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).SnapshotEnumerate(ctx, req.(*SdkVolumeSnapshotEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_SnapshotEnumerateWithFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeSnapshotEnumerateWithFiltersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).SnapshotEnumerateWithFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/SnapshotEnumerateWithFilters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).SnapshotEnumerateWithFilters(ctx, req.(*SdkVolumeSnapshotEnumerateWithFiltersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageVolume_SnapshotScheduleUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeSnapshotScheduleUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageVolumeServer).SnapshotScheduleUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageVolume/SnapshotScheduleUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageVolumeServer).SnapshotScheduleUpdate(ctx, req.(*SdkVolumeSnapshotScheduleUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageVolume_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageVolume",
	HandlerType: (*OpenStorageVolumeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageVolume_Create_Handler,
		},
		{
			MethodName: "Clone",
			Handler:    _OpenStorageVolume_Clone_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageVolume_Delete_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageVolume_Inspect_Handler,
		},
		{
			MethodName: "InspectWithFilters",
			Handler:    _OpenStorageVolume_InspectWithFilters_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _OpenStorageVolume_Update_Handler,
		},
		{
			MethodName: "Stats",
			Handler:    _OpenStorageVolume_Stats_Handler,
		},
		{
			MethodName: "CapacityUsage",
			Handler:    _OpenStorageVolume_CapacityUsage_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageVolume_Enumerate_Handler,
		},
		{
			MethodName: "EnumerateWithFilters",
			Handler:    _OpenStorageVolume_EnumerateWithFilters_Handler,
		},
		{
			MethodName: "SnapshotCreate",
			Handler:    _OpenStorageVolume_SnapshotCreate_Handler,
		},
		{
			MethodName: "SnapshotRestore",
			Handler:    _OpenStorageVolume_SnapshotRestore_Handler,
		},
		{
			MethodName: "SnapshotEnumerate",
			Handler:    _OpenStorageVolume_SnapshotEnumerate_Handler,
		},
		{
			MethodName: "SnapshotEnumerateWithFilters",
			Handler:    _OpenStorageVolume_SnapshotEnumerateWithFilters_Handler,
		},
		{
			MethodName: "SnapshotScheduleUpdate",
			Handler:    _OpenStorageVolume_SnapshotScheduleUpdate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageMountAttach service

type OpenStorageMountAttachClient interface {
	// Attach attaches device to the host that the client is communicating with.
	//
	// Requires access AccessType.Write of volume
	Attach(ctx context.Context, in *SdkVolumeAttachRequest, opts ...grpc.CallOption) (*SdkVolumeAttachResponse, error)
	// Detaches a the volume from the host
	//
	// Requires access AccessType.Write of volume
	Detach(ctx context.Context, in *SdkVolumeDetachRequest, opts ...grpc.CallOption) (*SdkVolumeDetachResponse, error)
	// Mount mounts an attached volume in the host that the client is communicating with
	//
	// Requires access AccessType.Write of volume
	Mount(ctx context.Context, in *SdkVolumeMountRequest, opts ...grpc.CallOption) (*SdkVolumeMountResponse, error)
	// Unmount unmounts a mounted volume in the host that the client is communicating with
	//
	// Requires access AccessType.Write of volume
	Unmount(ctx context.Context, in *SdkVolumeUnmountRequest, opts ...grpc.CallOption) (*SdkVolumeUnmountResponse, error)
}

type openStorageMountAttachClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageMountAttachClient(cc *grpc.ClientConn) OpenStorageMountAttachClient {
	return &openStorageMountAttachClient{cc}
}

func (c *openStorageMountAttachClient) Attach(ctx context.Context, in *SdkVolumeAttachRequest, opts ...grpc.CallOption) (*SdkVolumeAttachResponse, error) {
	out := new(SdkVolumeAttachResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMountAttach/Attach", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageMountAttachClient) Detach(ctx context.Context, in *SdkVolumeDetachRequest, opts ...grpc.CallOption) (*SdkVolumeDetachResponse, error) {
	out := new(SdkVolumeDetachResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMountAttach/Detach", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageMountAttachClient) Mount(ctx context.Context, in *SdkVolumeMountRequest, opts ...grpc.CallOption) (*SdkVolumeMountResponse, error) {
	out := new(SdkVolumeMountResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMountAttach/Mount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageMountAttachClient) Unmount(ctx context.Context, in *SdkVolumeUnmountRequest, opts ...grpc.CallOption) (*SdkVolumeUnmountResponse, error) {
	out := new(SdkVolumeUnmountResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMountAttach/Unmount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageMountAttach service

type OpenStorageMountAttachServer interface {
	// Attach attaches device to the host that the client is communicating with.
	//
	// Requires access AccessType.Write of volume
	Attach(context.Context, *SdkVolumeAttachRequest) (*SdkVolumeAttachResponse, error)
	// Detaches a the volume from the host
	//
	// Requires access AccessType.Write of volume
	Detach(context.Context, *SdkVolumeDetachRequest) (*SdkVolumeDetachResponse, error)
	// Mount mounts an attached volume in the host that the client is communicating with
	//
	// Requires access AccessType.Write of volume
	Mount(context.Context, *SdkVolumeMountRequest) (*SdkVolumeMountResponse, error)
	// Unmount unmounts a mounted volume in the host that the client is communicating with
	//
	// Requires access AccessType.Write of volume
	Unmount(context.Context, *SdkVolumeUnmountRequest) (*SdkVolumeUnmountResponse, error)
}

func RegisterOpenStorageMountAttachServer(s *grpc.Server, srv OpenStorageMountAttachServer) {
	s.RegisterService(&_OpenStorageMountAttach_serviceDesc, srv)
}

func _OpenStorageMountAttach_Attach_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeAttachRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMountAttachServer).Attach(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMountAttach/Attach",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMountAttachServer).Attach(ctx, req.(*SdkVolumeAttachRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageMountAttach_Detach_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeDetachRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMountAttachServer).Detach(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMountAttach/Detach",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMountAttachServer).Detach(ctx, req.(*SdkVolumeDetachRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageMountAttach_Mount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeMountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMountAttachServer).Mount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMountAttach/Mount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMountAttachServer).Mount(ctx, req.(*SdkVolumeMountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageMountAttach_Unmount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkVolumeUnmountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMountAttachServer).Unmount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMountAttach/Unmount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMountAttachServer).Unmount(ctx, req.(*SdkVolumeUnmountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageMountAttach_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageMountAttach",
	HandlerType: (*OpenStorageMountAttachServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Attach",
			Handler:    _OpenStorageMountAttach_Attach_Handler,
		},
		{
			MethodName: "Detach",
			Handler:    _OpenStorageMountAttach_Detach_Handler,
		},
		{
			MethodName: "Mount",
			Handler:    _OpenStorageMountAttach_Mount_Handler,
		},
		{
			MethodName: "Unmount",
			Handler:    _OpenStorageMountAttach_Unmount_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageMigrate service

type OpenStorageMigrateClient interface {
	// Start a migration operation
	Start(ctx context.Context, in *SdkCloudMigrateStartRequest, opts ...grpc.CallOption) (*SdkCloudMigrateStartResponse, error)
	// Cancel a migration operation
	Cancel(ctx context.Context, in *SdkCloudMigrateCancelRequest, opts ...grpc.CallOption) (*SdkCloudMigrateCancelResponse, error)
	// Inspect the status of migration operation
	Status(ctx context.Context, in *SdkCloudMigrateStatusRequest, opts ...grpc.CallOption) (*SdkCloudMigrateStatusResponse, error)
}

type openStorageMigrateClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageMigrateClient(cc *grpc.ClientConn) OpenStorageMigrateClient {
	return &openStorageMigrateClient{cc}
}

func (c *openStorageMigrateClient) Start(ctx context.Context, in *SdkCloudMigrateStartRequest, opts ...grpc.CallOption) (*SdkCloudMigrateStartResponse, error) {
	out := new(SdkCloudMigrateStartResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMigrate/Start", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageMigrateClient) Cancel(ctx context.Context, in *SdkCloudMigrateCancelRequest, opts ...grpc.CallOption) (*SdkCloudMigrateCancelResponse, error) {
	out := new(SdkCloudMigrateCancelResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMigrate/Cancel", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageMigrateClient) Status(ctx context.Context, in *SdkCloudMigrateStatusRequest, opts ...grpc.CallOption) (*SdkCloudMigrateStatusResponse, error) {
	out := new(SdkCloudMigrateStatusResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageMigrate/Status", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageMigrate service

type OpenStorageMigrateServer interface {
	// Start a migration operation
	Start(context.Context, *SdkCloudMigrateStartRequest) (*SdkCloudMigrateStartResponse, error)
	// Cancel a migration operation
	Cancel(context.Context, *SdkCloudMigrateCancelRequest) (*SdkCloudMigrateCancelResponse, error)
	// Inspect the status of migration operation
	Status(context.Context, *SdkCloudMigrateStatusRequest) (*SdkCloudMigrateStatusResponse, error)
}

func RegisterOpenStorageMigrateServer(s *grpc.Server, srv OpenStorageMigrateServer) {
	s.RegisterService(&_OpenStorageMigrate_serviceDesc, srv)
}

func _OpenStorageMigrate_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudMigrateStartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMigrateServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMigrate/Start",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMigrateServer).Start(ctx, req.(*SdkCloudMigrateStartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageMigrate_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudMigrateCancelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMigrateServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMigrate/Cancel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMigrateServer).Cancel(ctx, req.(*SdkCloudMigrateCancelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageMigrate_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudMigrateStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageMigrateServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageMigrate/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageMigrateServer).Status(ctx, req.(*SdkCloudMigrateStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageMigrate_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageMigrate",
	HandlerType: (*OpenStorageMigrateServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Start",
			Handler:    _OpenStorageMigrate_Start_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _OpenStorageMigrate_Cancel_Handler,
		},
		{
			MethodName: "Status",
			Handler:    _OpenStorageMigrate_Status_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageObjectstore service

type OpenStorageObjectstoreClient interface {
	// Inspect returns information about the object store endpoint
	Inspect(ctx context.Context, in *SdkObjectstoreInspectRequest, opts ...grpc.CallOption) (*SdkObjectstoreInspectResponse, error)
	// Creates creates an object store endpoint on specified volume
	Create(ctx context.Context, in *SdkObjectstoreCreateRequest, opts ...grpc.CallOption) (*SdkObjectstoreCreateResponse, error)
	// Delete destroys the object store endpoint on the volume
	Delete(ctx context.Context, in *SdkObjectstoreDeleteRequest, opts ...grpc.CallOption) (*SdkObjectstoreDeleteResponse, error)
	// Updates provided objectstore status.
	// This call can be used to stop and start the server while maintaining the same
	// object storage id.
	Update(ctx context.Context, in *SdkObjectstoreUpdateRequest, opts ...grpc.CallOption) (*SdkObjectstoreUpdateResponse, error)
}

type openStorageObjectstoreClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageObjectstoreClient(cc *grpc.ClientConn) OpenStorageObjectstoreClient {
	return &openStorageObjectstoreClient{cc}
}

func (c *openStorageObjectstoreClient) Inspect(ctx context.Context, in *SdkObjectstoreInspectRequest, opts ...grpc.CallOption) (*SdkObjectstoreInspectResponse, error) {
	out := new(SdkObjectstoreInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageObjectstore/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageObjectstoreClient) Create(ctx context.Context, in *SdkObjectstoreCreateRequest, opts ...grpc.CallOption) (*SdkObjectstoreCreateResponse, error) {
	out := new(SdkObjectstoreCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageObjectstore/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageObjectstoreClient) Delete(ctx context.Context, in *SdkObjectstoreDeleteRequest, opts ...grpc.CallOption) (*SdkObjectstoreDeleteResponse, error) {
	out := new(SdkObjectstoreDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageObjectstore/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageObjectstoreClient) Update(ctx context.Context, in *SdkObjectstoreUpdateRequest, opts ...grpc.CallOption) (*SdkObjectstoreUpdateResponse, error) {
	out := new(SdkObjectstoreUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageObjectstore/Update", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageObjectstore service

type OpenStorageObjectstoreServer interface {
	// Inspect returns information about the object store endpoint
	Inspect(context.Context, *SdkObjectstoreInspectRequest) (*SdkObjectstoreInspectResponse, error)
	// Creates creates an object store endpoint on specified volume
	Create(context.Context, *SdkObjectstoreCreateRequest) (*SdkObjectstoreCreateResponse, error)
	// Delete destroys the object store endpoint on the volume
	Delete(context.Context, *SdkObjectstoreDeleteRequest) (*SdkObjectstoreDeleteResponse, error)
	// Updates provided objectstore status.
	// This call can be used to stop and start the server while maintaining the same
	// object storage id.
	Update(context.Context, *SdkObjectstoreUpdateRequest) (*SdkObjectstoreUpdateResponse, error)
}

func RegisterOpenStorageObjectstoreServer(s *grpc.Server, srv OpenStorageObjectstoreServer) {
	s.RegisterService(&_OpenStorageObjectstore_serviceDesc, srv)
}

func _OpenStorageObjectstore_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkObjectstoreInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageObjectstoreServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageObjectstore/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageObjectstoreServer).Inspect(ctx, req.(*SdkObjectstoreInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageObjectstore_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkObjectstoreCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageObjectstoreServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageObjectstore/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageObjectstoreServer).Create(ctx, req.(*SdkObjectstoreCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageObjectstore_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkObjectstoreDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageObjectstoreServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageObjectstore/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageObjectstoreServer).Delete(ctx, req.(*SdkObjectstoreDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageObjectstore_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkObjectstoreUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageObjectstoreServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageObjectstore/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageObjectstoreServer).Update(ctx, req.(*SdkObjectstoreUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageObjectstore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageObjectstore",
	HandlerType: (*OpenStorageObjectstoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageObjectstore_Inspect_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _OpenStorageObjectstore_Create_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageObjectstore_Delete_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _OpenStorageObjectstore_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageCredentials service

type OpenStorageCredentialsClient interface {
	// Create is used to submit cloud credentials. It will return an
	// id of the credentials once they are verified to work.
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkCredentialCreateRequest{
	//     Name: "awscred",
	//     CredentialType: &api.SdkCredentialCreateRequest_AwsCredential{
	//       AwsCredential: &api.SdkAwsCredentialRequest{
	//       AccessKey: "dummy-access",
	//       SecretKey: "dummy-secret",
	//       Endpoint:  "dummy-endpoint",
	//       Region:    "dummy-region",
	//     },
	//   },
	// })
	// {%- language name="Python", type="py" -%}
	// en_resp = client.Create(api_pb2.SdkCredentialCreateRequest(
	//   name='awscred',
	//   aws_credential=api_pb2.SdkAwsCredentialRequest(
	//     access_key='dummy-access',
	//     secret_key='dumm-secret',
	//     endpoint='dummy-endpoint',
	//     region='dummy-region')))
	// {%- endcodetabs %}
	Create(ctx context.Context, in *SdkCredentialCreateRequest, opts ...grpc.CallOption) (*SdkCredentialCreateResponse, error)
	// Enumerate returns a list of credential ids
	Enumerate(ctx context.Context, in *SdkCredentialEnumerateRequest, opts ...grpc.CallOption) (*SdkCredentialEnumerateResponse, error)
	// Inspect returns the information about a credential, but does not return the secret key.
	Inspect(ctx context.Context, in *SdkCredentialInspectRequest, opts ...grpc.CallOption) (*SdkCredentialInspectResponse, error)
	// Delete a specified credential
	Delete(ctx context.Context, in *SdkCredentialDeleteRequest, opts ...grpc.CallOption) (*SdkCredentialDeleteResponse, error)
	// Validate is used to validate credentials
	Validate(ctx context.Context, in *SdkCredentialValidateRequest, opts ...grpc.CallOption) (*SdkCredentialValidateResponse, error)
}

type openStorageCredentialsClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageCredentialsClient(cc *grpc.ClientConn) OpenStorageCredentialsClient {
	return &openStorageCredentialsClient{cc}
}

func (c *openStorageCredentialsClient) Create(ctx context.Context, in *SdkCredentialCreateRequest, opts ...grpc.CallOption) (*SdkCredentialCreateResponse, error) {
	out := new(SdkCredentialCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCredentials/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCredentialsClient) Enumerate(ctx context.Context, in *SdkCredentialEnumerateRequest, opts ...grpc.CallOption) (*SdkCredentialEnumerateResponse, error) {
	out := new(SdkCredentialEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCredentials/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCredentialsClient) Inspect(ctx context.Context, in *SdkCredentialInspectRequest, opts ...grpc.CallOption) (*SdkCredentialInspectResponse, error) {
	out := new(SdkCredentialInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCredentials/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCredentialsClient) Delete(ctx context.Context, in *SdkCredentialDeleteRequest, opts ...grpc.CallOption) (*SdkCredentialDeleteResponse, error) {
	out := new(SdkCredentialDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCredentials/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCredentialsClient) Validate(ctx context.Context, in *SdkCredentialValidateRequest, opts ...grpc.CallOption) (*SdkCredentialValidateResponse, error) {
	out := new(SdkCredentialValidateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCredentials/Validate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageCredentials service

type OpenStorageCredentialsServer interface {
	// Create is used to submit cloud credentials. It will return an
	// id of the credentials once they are verified to work.
	//
	// ##### Example
	// {% codetabs name="Golang", type="go" -%}
	// id, err := client.Create(context.Background(), &api.SdkCredentialCreateRequest{
	//     Name: "awscred",
	//     CredentialType: &api.SdkCredentialCreateRequest_AwsCredential{
	//       AwsCredential: &api.SdkAwsCredentialRequest{
	//       AccessKey: "dummy-access",
	//       SecretKey: "dummy-secret",
	//       Endpoint:  "dummy-endpoint",
	//       Region:    "dummy-region",
	//     },
	//   },
	// })
	// {%- language name="Python", type="py" -%}
	// en_resp = client.Create(api_pb2.SdkCredentialCreateRequest(
	//   name='awscred',
	//   aws_credential=api_pb2.SdkAwsCredentialRequest(
	//     access_key='dummy-access',
	//     secret_key='dumm-secret',
	//     endpoint='dummy-endpoint',
	//     region='dummy-region')))
	// {%- endcodetabs %}
	Create(context.Context, *SdkCredentialCreateRequest) (*SdkCredentialCreateResponse, error)
	// Enumerate returns a list of credential ids
	Enumerate(context.Context, *SdkCredentialEnumerateRequest) (*SdkCredentialEnumerateResponse, error)
	// Inspect returns the information about a credential, but does not return the secret key.
	Inspect(context.Context, *SdkCredentialInspectRequest) (*SdkCredentialInspectResponse, error)
	// Delete a specified credential
	Delete(context.Context, *SdkCredentialDeleteRequest) (*SdkCredentialDeleteResponse, error)
	// Validate is used to validate credentials
	Validate(context.Context, *SdkCredentialValidateRequest) (*SdkCredentialValidateResponse, error)
}

func RegisterOpenStorageCredentialsServer(s *grpc.Server, srv OpenStorageCredentialsServer) {
	s.RegisterService(&_OpenStorageCredentials_serviceDesc, srv)
}

func _OpenStorageCredentials_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCredentialCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCredentialsServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCredentials/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCredentialsServer).Create(ctx, req.(*SdkCredentialCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCredentials_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCredentialEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCredentialsServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCredentials/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCredentialsServer).Enumerate(ctx, req.(*SdkCredentialEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCredentials_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCredentialInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCredentialsServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCredentials/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCredentialsServer).Inspect(ctx, req.(*SdkCredentialInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCredentials_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCredentialDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCredentialsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCredentials/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCredentialsServer).Delete(ctx, req.(*SdkCredentialDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCredentials_Validate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCredentialValidateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCredentialsServer).Validate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCredentials/Validate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCredentialsServer).Validate(ctx, req.(*SdkCredentialValidateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageCredentials_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageCredentials",
	HandlerType: (*OpenStorageCredentialsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageCredentials_Create_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageCredentials_Enumerate_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageCredentials_Inspect_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageCredentials_Delete_Handler,
		},
		{
			MethodName: "Validate",
			Handler:    _OpenStorageCredentials_Validate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageSchedulePolicy service

type OpenStorageSchedulePolicyClient interface {
	// Create creates a new snapshot schedule. They can be setup daily,
	// weekly, or monthly.
	Create(ctx context.Context, in *SdkSchedulePolicyCreateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyCreateResponse, error)
	// Update a snapshot schedule
	Update(ctx context.Context, in *SdkSchedulePolicyUpdateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyUpdateResponse, error)
	// Enumerate returns a list of schedules
	Enumerate(ctx context.Context, in *SdkSchedulePolicyEnumerateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyEnumerateResponse, error)
	// Inspect returns information about a specified schedule
	Inspect(ctx context.Context, in *SdkSchedulePolicyInspectRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyInspectResponse, error)
	// Delete removes a snapshot schedule
	Delete(ctx context.Context, in *SdkSchedulePolicyDeleteRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyDeleteResponse, error)
}

type openStorageSchedulePolicyClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageSchedulePolicyClient(cc *grpc.ClientConn) OpenStorageSchedulePolicyClient {
	return &openStorageSchedulePolicyClient{cc}
}

func (c *openStorageSchedulePolicyClient) Create(ctx context.Context, in *SdkSchedulePolicyCreateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyCreateResponse, error) {
	out := new(SdkSchedulePolicyCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageSchedulePolicy/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageSchedulePolicyClient) Update(ctx context.Context, in *SdkSchedulePolicyUpdateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyUpdateResponse, error) {
	out := new(SdkSchedulePolicyUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageSchedulePolicy/Update", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageSchedulePolicyClient) Enumerate(ctx context.Context, in *SdkSchedulePolicyEnumerateRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyEnumerateResponse, error) {
	out := new(SdkSchedulePolicyEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageSchedulePolicy/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageSchedulePolicyClient) Inspect(ctx context.Context, in *SdkSchedulePolicyInspectRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyInspectResponse, error) {
	out := new(SdkSchedulePolicyInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageSchedulePolicy/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageSchedulePolicyClient) Delete(ctx context.Context, in *SdkSchedulePolicyDeleteRequest, opts ...grpc.CallOption) (*SdkSchedulePolicyDeleteResponse, error) {
	out := new(SdkSchedulePolicyDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageSchedulePolicy/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageSchedulePolicy service

type OpenStorageSchedulePolicyServer interface {
	// Create creates a new snapshot schedule. They can be setup daily,
	// weekly, or monthly.
	Create(context.Context, *SdkSchedulePolicyCreateRequest) (*SdkSchedulePolicyCreateResponse, error)
	// Update a snapshot schedule
	Update(context.Context, *SdkSchedulePolicyUpdateRequest) (*SdkSchedulePolicyUpdateResponse, error)
	// Enumerate returns a list of schedules
	Enumerate(context.Context, *SdkSchedulePolicyEnumerateRequest) (*SdkSchedulePolicyEnumerateResponse, error)
	// Inspect returns information about a specified schedule
	Inspect(context.Context, *SdkSchedulePolicyInspectRequest) (*SdkSchedulePolicyInspectResponse, error)
	// Delete removes a snapshot schedule
	Delete(context.Context, *SdkSchedulePolicyDeleteRequest) (*SdkSchedulePolicyDeleteResponse, error)
}

func RegisterOpenStorageSchedulePolicyServer(s *grpc.Server, srv OpenStorageSchedulePolicyServer) {
	s.RegisterService(&_OpenStorageSchedulePolicy_serviceDesc, srv)
}

func _OpenStorageSchedulePolicy_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkSchedulePolicyCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageSchedulePolicyServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageSchedulePolicy/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageSchedulePolicyServer).Create(ctx, req.(*SdkSchedulePolicyCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageSchedulePolicy_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkSchedulePolicyUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageSchedulePolicyServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageSchedulePolicy/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageSchedulePolicyServer).Update(ctx, req.(*SdkSchedulePolicyUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageSchedulePolicy_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkSchedulePolicyEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageSchedulePolicyServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageSchedulePolicy/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageSchedulePolicyServer).Enumerate(ctx, req.(*SdkSchedulePolicyEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageSchedulePolicy_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkSchedulePolicyInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageSchedulePolicyServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageSchedulePolicy/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageSchedulePolicyServer).Inspect(ctx, req.(*SdkSchedulePolicyInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageSchedulePolicy_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkSchedulePolicyDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageSchedulePolicyServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageSchedulePolicy/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageSchedulePolicyServer).Delete(ctx, req.(*SdkSchedulePolicyDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageSchedulePolicy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageSchedulePolicy",
	HandlerType: (*OpenStorageSchedulePolicyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageSchedulePolicy_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _OpenStorageSchedulePolicy_Update_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStorageSchedulePolicy_Enumerate_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStorageSchedulePolicy_Inspect_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageSchedulePolicy_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStorageCloudBackup service

type OpenStorageCloudBackupClient interface {
	// Creates a backup request for a specified volume. Use
	// OpenStorageCloudBackup.Status() to get the current status of the
	// backup request.
	//
	// Requires access AccessType.Read of volume
	Create(ctx context.Context, in *SdkCloudBackupCreateRequest, opts ...grpc.CallOption) (*SdkCloudBackupCreateResponse, error)
	// Restore creates a new volume from a backup id. The newly created volume
	// has an ha_level (number of replicas) of only 1. To increase the number of
	// replicas, use OpenStorageVolume.Set() to change the ha_level.
	Restore(ctx context.Context, in *SdkCloudBackupRestoreRequest, opts ...grpc.CallOption) (*SdkCloudBackupRestoreResponse, error)
	// Deletes a backup stored in the cloud. If the backup is an incremental
	// backup and other backups are dependent on it, it will not be able to be deleted.
	Delete(ctx context.Context, in *SdkCloudBackupDeleteRequest, opts ...grpc.CallOption) (*SdkCloudBackupDeleteResponse, error)
	// DeleteAll deletes all the backups in the cloud for the specified volume.
	DeleteAll(ctx context.Context, in *SdkCloudBackupDeleteAllRequest, opts ...grpc.CallOption) (*SdkCloudBackupDeleteAllResponse, error)
	// Return a list of backups for the specified volume
	EnumerateWithFilters(ctx context.Context, in *SdkCloudBackupEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkCloudBackupEnumerateWithFiltersResponse, error)
	// Status returns the status of any cloud backups of a volume
	Status(ctx context.Context, in *SdkCloudBackupStatusRequest, opts ...grpc.CallOption) (*SdkCloudBackupStatusResponse, error)
	// Catalog returns a list of the contents in the backup
	Catalog(ctx context.Context, in *SdkCloudBackupCatalogRequest, opts ...grpc.CallOption) (*SdkCloudBackupCatalogResponse, error)
	// History returns a list of backups for a specified volume
	History(ctx context.Context, in *SdkCloudBackupHistoryRequest, opts ...grpc.CallOption) (*SdkCloudBackupHistoryResponse, error)
	// StateChange can be used to stop, pause, and restart a backup
	StateChange(ctx context.Context, in *SdkCloudBackupStateChangeRequest, opts ...grpc.CallOption) (*SdkCloudBackupStateChangeResponse, error)
	// Create cloud backup schedule
	SchedCreate(ctx context.Context, in *SdkCloudBackupSchedCreateRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedCreateResponse, error)
	// Delete cloud backup schedule
	SchedDelete(ctx context.Context, in *SdkCloudBackupSchedDeleteRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedDeleteResponse, error)
	// Enumerate cloud backup schedules
	SchedEnumerate(ctx context.Context, in *SdkCloudBackupSchedEnumerateRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedEnumerateResponse, error)
}

type openStorageCloudBackupClient struct {
	cc *grpc.ClientConn
}

func NewOpenStorageCloudBackupClient(cc *grpc.ClientConn) OpenStorageCloudBackupClient {
	return &openStorageCloudBackupClient{cc}
}

func (c *openStorageCloudBackupClient) Create(ctx context.Context, in *SdkCloudBackupCreateRequest, opts ...grpc.CallOption) (*SdkCloudBackupCreateResponse, error) {
	out := new(SdkCloudBackupCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) Restore(ctx context.Context, in *SdkCloudBackupRestoreRequest, opts ...grpc.CallOption) (*SdkCloudBackupRestoreResponse, error) {
	out := new(SdkCloudBackupRestoreResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/Restore", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) Delete(ctx context.Context, in *SdkCloudBackupDeleteRequest, opts ...grpc.CallOption) (*SdkCloudBackupDeleteResponse, error) {
	out := new(SdkCloudBackupDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) DeleteAll(ctx context.Context, in *SdkCloudBackupDeleteAllRequest, opts ...grpc.CallOption) (*SdkCloudBackupDeleteAllResponse, error) {
	out := new(SdkCloudBackupDeleteAllResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/DeleteAll", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) EnumerateWithFilters(ctx context.Context, in *SdkCloudBackupEnumerateWithFiltersRequest, opts ...grpc.CallOption) (*SdkCloudBackupEnumerateWithFiltersResponse, error) {
	out := new(SdkCloudBackupEnumerateWithFiltersResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/EnumerateWithFilters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) Status(ctx context.Context, in *SdkCloudBackupStatusRequest, opts ...grpc.CallOption) (*SdkCloudBackupStatusResponse, error) {
	out := new(SdkCloudBackupStatusResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/Status", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) Catalog(ctx context.Context, in *SdkCloudBackupCatalogRequest, opts ...grpc.CallOption) (*SdkCloudBackupCatalogResponse, error) {
	out := new(SdkCloudBackupCatalogResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/Catalog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) History(ctx context.Context, in *SdkCloudBackupHistoryRequest, opts ...grpc.CallOption) (*SdkCloudBackupHistoryResponse, error) {
	out := new(SdkCloudBackupHistoryResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/History", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) StateChange(ctx context.Context, in *SdkCloudBackupStateChangeRequest, opts ...grpc.CallOption) (*SdkCloudBackupStateChangeResponse, error) {
	out := new(SdkCloudBackupStateChangeResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/StateChange", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) SchedCreate(ctx context.Context, in *SdkCloudBackupSchedCreateRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedCreateResponse, error) {
	out := new(SdkCloudBackupSchedCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/SchedCreate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) SchedDelete(ctx context.Context, in *SdkCloudBackupSchedDeleteRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedDeleteResponse, error) {
	out := new(SdkCloudBackupSchedDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/SchedDelete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStorageCloudBackupClient) SchedEnumerate(ctx context.Context, in *SdkCloudBackupSchedEnumerateRequest, opts ...grpc.CallOption) (*SdkCloudBackupSchedEnumerateResponse, error) {
	out := new(SdkCloudBackupSchedEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStorageCloudBackup/SchedEnumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStorageCloudBackup service

type OpenStorageCloudBackupServer interface {
	// Creates a backup request for a specified volume. Use
	// OpenStorageCloudBackup.Status() to get the current status of the
	// backup request.
	//
	// Requires access AccessType.Read of volume
	Create(context.Context, *SdkCloudBackupCreateRequest) (*SdkCloudBackupCreateResponse, error)
	// Restore creates a new volume from a backup id. The newly created volume
	// has an ha_level (number of replicas) of only 1. To increase the number of
	// replicas, use OpenStorageVolume.Set() to change the ha_level.
	Restore(context.Context, *SdkCloudBackupRestoreRequest) (*SdkCloudBackupRestoreResponse, error)
	// Deletes a backup stored in the cloud. If the backup is an incremental
	// backup and other backups are dependent on it, it will not be able to be deleted.
	Delete(context.Context, *SdkCloudBackupDeleteRequest) (*SdkCloudBackupDeleteResponse, error)
	// DeleteAll deletes all the backups in the cloud for the specified volume.
	DeleteAll(context.Context, *SdkCloudBackupDeleteAllRequest) (*SdkCloudBackupDeleteAllResponse, error)
	// Return a list of backups for the specified volume
	EnumerateWithFilters(context.Context, *SdkCloudBackupEnumerateWithFiltersRequest) (*SdkCloudBackupEnumerateWithFiltersResponse, error)
	// Status returns the status of any cloud backups of a volume
	Status(context.Context, *SdkCloudBackupStatusRequest) (*SdkCloudBackupStatusResponse, error)
	// Catalog returns a list of the contents in the backup
	Catalog(context.Context, *SdkCloudBackupCatalogRequest) (*SdkCloudBackupCatalogResponse, error)
	// History returns a list of backups for a specified volume
	History(context.Context, *SdkCloudBackupHistoryRequest) (*SdkCloudBackupHistoryResponse, error)
	// StateChange can be used to stop, pause, and restart a backup
	StateChange(context.Context, *SdkCloudBackupStateChangeRequest) (*SdkCloudBackupStateChangeResponse, error)
	// Create cloud backup schedule
	SchedCreate(context.Context, *SdkCloudBackupSchedCreateRequest) (*SdkCloudBackupSchedCreateResponse, error)
	// Delete cloud backup schedule
	SchedDelete(context.Context, *SdkCloudBackupSchedDeleteRequest) (*SdkCloudBackupSchedDeleteResponse, error)
	// Enumerate cloud backup schedules
	SchedEnumerate(context.Context, *SdkCloudBackupSchedEnumerateRequest) (*SdkCloudBackupSchedEnumerateResponse, error)
}

func RegisterOpenStorageCloudBackupServer(s *grpc.Server, srv OpenStorageCloudBackupServer) {
	s.RegisterService(&_OpenStorageCloudBackup_serviceDesc, srv)
}

func _OpenStorageCloudBackup_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).Create(ctx, req.(*SdkCloudBackupCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).Restore(ctx, req.(*SdkCloudBackupRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).Delete(ctx, req.(*SdkCloudBackupDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_DeleteAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupDeleteAllRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).DeleteAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/DeleteAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).DeleteAll(ctx, req.(*SdkCloudBackupDeleteAllRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_EnumerateWithFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupEnumerateWithFiltersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).EnumerateWithFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/EnumerateWithFilters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).EnumerateWithFilters(ctx, req.(*SdkCloudBackupEnumerateWithFiltersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_Status_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).Status(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/Status",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).Status(ctx, req.(*SdkCloudBackupStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_Catalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).Catalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/Catalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).Catalog(ctx, req.(*SdkCloudBackupCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_History_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).History(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/History",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).History(ctx, req.(*SdkCloudBackupHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_StateChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupStateChangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).StateChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/StateChange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).StateChange(ctx, req.(*SdkCloudBackupStateChangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_SchedCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupSchedCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).SchedCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/SchedCreate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).SchedCreate(ctx, req.(*SdkCloudBackupSchedCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_SchedDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupSchedDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).SchedDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/SchedDelete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).SchedDelete(ctx, req.(*SdkCloudBackupSchedDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStorageCloudBackup_SchedEnumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkCloudBackupSchedEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStorageCloudBackupServer).SchedEnumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStorageCloudBackup/SchedEnumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStorageCloudBackupServer).SchedEnumerate(ctx, req.(*SdkCloudBackupSchedEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStorageCloudBackup_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStorageCloudBackup",
	HandlerType: (*OpenStorageCloudBackupServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStorageCloudBackup_Create_Handler,
		},
		{
			MethodName: "Restore",
			Handler:    _OpenStorageCloudBackup_Restore_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStorageCloudBackup_Delete_Handler,
		},
		{
			MethodName: "DeleteAll",
			Handler:    _OpenStorageCloudBackup_DeleteAll_Handler,
		},
		{
			MethodName: "EnumerateWithFilters",
			Handler:    _OpenStorageCloudBackup_EnumerateWithFilters_Handler,
		},
		{
			MethodName: "Status",
			Handler:    _OpenStorageCloudBackup_Status_Handler,
		},
		{
			MethodName: "Catalog",
			Handler:    _OpenStorageCloudBackup_Catalog_Handler,
		},
		{
			MethodName: "History",
			Handler:    _OpenStorageCloudBackup_History_Handler,
		},
		{
			MethodName: "StateChange",
			Handler:    _OpenStorageCloudBackup_StateChange_Handler,
		},
		{
			MethodName: "SchedCreate",
			Handler:    _OpenStorageCloudBackup_SchedCreate_Handler,
		},
		{
			MethodName: "SchedDelete",
			Handler:    _OpenStorageCloudBackup_SchedDelete_Handler,
		},
		{
			MethodName: "SchedEnumerate",
			Handler:    _OpenStorageCloudBackup_SchedEnumerate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

// Client API for OpenStoragePolicy service

type OpenStoragePolicyClient interface {
	// Creates a storage policy
	Create(ctx context.Context, in *SdkOpenStoragePolicyCreateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyCreateResponse, error)
	// Enumerate returns a list of storage policies
	Enumerate(ctx context.Context, in *SdkOpenStoragePolicyEnumerateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyEnumerateResponse, error)
	// Inspect returns information about a specified storage policy
	Inspect(ctx context.Context, in *SdkOpenStoragePolicyInspectRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyInspectResponse, error)
	// Updates specified storage policy
	Update(ctx context.Context, in *SdkOpenStoragePolicyUpdateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyUpdateResponse, error)
	// Deletes specified storage policy
	Delete(ctx context.Context, in *SdkOpenStoragePolicyDeleteRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyDeleteResponse, error)
	// Set specified storage policy as default policy
	SetDefault(ctx context.Context, in *SdkOpenStoragePolicySetDefaultRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicySetDefaultResponse, error)
	// DefaultInspect return default storage policy if any, otherwise
	// empty response
	DefaultInspect(ctx context.Context, in *SdkOpenStoragePolicyDefaultInspectRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyDefaultInspectResponse, error)
	// Release specified storage policy constraint for volume
	// creation
	Release(ctx context.Context, in *SdkOpenStoragePolicyReleaseRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyReleaseResponse, error)
}

type openStoragePolicyClient struct {
	cc *grpc.ClientConn
}

func NewOpenStoragePolicyClient(cc *grpc.ClientConn) OpenStoragePolicyClient {
	return &openStoragePolicyClient{cc}
}

func (c *openStoragePolicyClient) Create(ctx context.Context, in *SdkOpenStoragePolicyCreateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyCreateResponse, error) {
	out := new(SdkOpenStoragePolicyCreateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) Enumerate(ctx context.Context, in *SdkOpenStoragePolicyEnumerateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyEnumerateResponse, error) {
	out := new(SdkOpenStoragePolicyEnumerateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Enumerate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) Inspect(ctx context.Context, in *SdkOpenStoragePolicyInspectRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyInspectResponse, error) {
	out := new(SdkOpenStoragePolicyInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Inspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) Update(ctx context.Context, in *SdkOpenStoragePolicyUpdateRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyUpdateResponse, error) {
	out := new(SdkOpenStoragePolicyUpdateResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Update", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) Delete(ctx context.Context, in *SdkOpenStoragePolicyDeleteRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyDeleteResponse, error) {
	out := new(SdkOpenStoragePolicyDeleteResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) SetDefault(ctx context.Context, in *SdkOpenStoragePolicySetDefaultRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicySetDefaultResponse, error) {
	out := new(SdkOpenStoragePolicySetDefaultResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/SetDefault", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) DefaultInspect(ctx context.Context, in *SdkOpenStoragePolicyDefaultInspectRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyDefaultInspectResponse, error) {
	out := new(SdkOpenStoragePolicyDefaultInspectResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/DefaultInspect", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openStoragePolicyClient) Release(ctx context.Context, in *SdkOpenStoragePolicyReleaseRequest, opts ...grpc.CallOption) (*SdkOpenStoragePolicyReleaseResponse, error) {
	out := new(SdkOpenStoragePolicyReleaseResponse)
	err := grpc.Invoke(ctx, "/openstorage.api.OpenStoragePolicy/Release", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenStoragePolicy service

type OpenStoragePolicyServer interface {
	// Creates a storage policy
	Create(context.Context, *SdkOpenStoragePolicyCreateRequest) (*SdkOpenStoragePolicyCreateResponse, error)
	// Enumerate returns a list of storage policies
	Enumerate(context.Context, *SdkOpenStoragePolicyEnumerateRequest) (*SdkOpenStoragePolicyEnumerateResponse, error)
	// Inspect returns information about a specified storage policy
	Inspect(context.Context, *SdkOpenStoragePolicyInspectRequest) (*SdkOpenStoragePolicyInspectResponse, error)
	// Updates specified storage policy
	Update(context.Context, *SdkOpenStoragePolicyUpdateRequest) (*SdkOpenStoragePolicyUpdateResponse, error)
	// Deletes specified storage policy
	Delete(context.Context, *SdkOpenStoragePolicyDeleteRequest) (*SdkOpenStoragePolicyDeleteResponse, error)
	// Set specified storage policy as default policy
	SetDefault(context.Context, *SdkOpenStoragePolicySetDefaultRequest) (*SdkOpenStoragePolicySetDefaultResponse, error)
	// DefaultInspect return default storage policy if any, otherwise
	// empty response
	DefaultInspect(context.Context, *SdkOpenStoragePolicyDefaultInspectRequest) (*SdkOpenStoragePolicyDefaultInspectResponse, error)
	// Release specified storage policy constraint for volume
	// creation
	Release(context.Context, *SdkOpenStoragePolicyReleaseRequest) (*SdkOpenStoragePolicyReleaseResponse, error)
}

func RegisterOpenStoragePolicyServer(s *grpc.Server, srv OpenStoragePolicyServer) {
	s.RegisterService(&_OpenStoragePolicy_serviceDesc, srv)
}

func _OpenStoragePolicy_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyCreateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Create(ctx, req.(*SdkOpenStoragePolicyCreateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_Enumerate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyEnumerateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Enumerate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Enumerate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Enumerate(ctx, req.(*SdkOpenStoragePolicyEnumerateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_Inspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Inspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Inspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Inspect(ctx, req.(*SdkOpenStoragePolicyInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Update(ctx, req.(*SdkOpenStoragePolicyUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Delete(ctx, req.(*SdkOpenStoragePolicyDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_SetDefault_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicySetDefaultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).SetDefault(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/SetDefault",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).SetDefault(ctx, req.(*SdkOpenStoragePolicySetDefaultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_DefaultInspect_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyDefaultInspectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).DefaultInspect(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/DefaultInspect",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).DefaultInspect(ctx, req.(*SdkOpenStoragePolicyDefaultInspectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenStoragePolicy_Release_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SdkOpenStoragePolicyReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenStoragePolicyServer).Release(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/openstorage.api.OpenStoragePolicy/Release",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenStoragePolicyServer).Release(ctx, req.(*SdkOpenStoragePolicyReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenStoragePolicy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "openstorage.api.OpenStoragePolicy",
	HandlerType: (*OpenStoragePolicyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _OpenStoragePolicy_Create_Handler,
		},
		{
			MethodName: "Enumerate",
			Handler:    _OpenStoragePolicy_Enumerate_Handler,
		},
		{
			MethodName: "Inspect",
			Handler:    _OpenStoragePolicy_Inspect_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _OpenStoragePolicy_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OpenStoragePolicy_Delete_Handler,
		},
		{
			MethodName: "SetDefault",
			Handler:    _OpenStoragePolicy_SetDefault_Handler,
		},
		{
			MethodName: "DefaultInspect",
			Handler:    _OpenStoragePolicy_DefaultInspect_Handler,
		},
		{
			MethodName: "Release",
			Handler:    _OpenStoragePolicy_Release_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/api.proto",
}

func init() { proto.RegisterFile("api/api.proto", fileDescriptor_api_05b7199aa6331e09) }

var fileDescriptor_api_05b7199aa6331e09 = []byte{
	// 12995 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0xbd, 0x5b, 0x8c, 0x1c, 0x49,
	0x76, 0x18, 0xca, 0xac, 0xea, 0x47, 0xf5, 0xe9, 0x57, 0x76, 0x90, 0xd3, 0x2c, 0x16, 0xdf, 0x39,
	0xc3, 0x21, 0xa7, 0x87, 0xec, 0xe6, 0xf4, 0x90, 0x33, 0x43, 0x72, 0x66, 0x77, 0x9b, 0xdd, 0xd5,
	0xec, 0x12, 0xfb, 0x35, 0x59, 0xdd, 0xe4, 0xcc, 0xea, 0x51, 0x9b, 0xac, 0x0a, 0xb2, 0x73, 0x58,
	0x55, 0x59, 0x53, 0x99, 0xd5, 0x33, 0xbd, 0xbb, 0x23, 0x09, 0xc2, 0x15, 0x74, 0x2f, 0xb4, 0x57,
	0xab, 0x95, 0xb4, 0x12, 0x56, 0x2b, 0xdd, 0x2b, 0xc3, 0x90, 0x60, 0xeb, 0x61, 0x58, 0xb2, 0x61,
	0x58, 0x82, 0x2c, 0x01, 0xfb, 0x61, 0x59, 0xb2, 0x21, 0x7d, 0xc8, 0xfe, 0x32, 0xf4, 0x21, 0x58,
	0x36, 0x24, 0xd8, 0xd0, 0x87, 0x61, 0x7f, 0x18, 0xb0, 0x61, 0x23, 0x4e, 0x44, 0x66, 0x46, 0xe4,
	0xa3, 0x2a, 0x8b, 0xe4, 0xae, 0x3f, 0xfc, 0xd3, 0x5d, 0x11, 0x71, 0xe2, 0xc4, 0x89, 0x13, 0x27,
	0x4e, 0x9c, 0x38, 0x11, 0x71, 0x12, 0xa6, 0xad, 0x8e, 0xbd, 0x64, 0x75, 0xec, 0xc5, 0x4e, 0xd7,
	0xf1, 0x1c, 0x32, 0xeb, 0x74, 0x68, 0xdb, 0xf5, 0x9c, 0xae, 0xf5, 0x84, 0x2e, 0x5a, 0x1d, 0xbb,
	0x74, 0xfe, 0x89, 0xe3, 0x3c, 0x69, 0xd2, 0x25, 0x2c, 0x7e, 0xd4, 0x7b, 0xbc, 0xe4, 0xd9, 0x2d,
	0xea, 0x7a, 0x56, 0xab, 0xc3, 0x6b, 0x94, 0xce, 0x08, 0x00, 0xc4, 0xd3, 0x6e, 0x3b, 0x9e, 0xe5,
	0xd9, 0x4e, 0xdb, 0xe5, 0xa5, 0xc6, 0xdf, 0xcd, 0xc3, 0x6c, 0x95, 0xa3, 0x33, 0xa9, 0xeb, 0xf4,
	0xba, 0x75, 0x4a, 0x66, 0x20, 0x67, 0x37, 0x8a, 0xda, 0x05, 0xed, 0xca, 0x84, 0x99, 0xb3, 0x1b,
	0x84, 0xc0, 0x48, 0xc7, 0xf2, 0x0e, 0x8a, 0x39, 0xcc, 0xc1, 0xdf, 0xe4, 0x2d, 0x18, 0x6b, 0xd1,
	0x86, 0xdd, 0x6b, 0x15, 0xf3, 0x17, 0xb4, 0x2b, 0x33, 0xcb, 0xe7, 0x16, 0x23, 0x84, 0x2d, 0x0a,
	0xac, 0x5b, 0x08, 0x65, 0x0a, 0x68, 0x32, 0x0f, 0x63, 0x4e, 0xbb, 0x69, 0xb7, 0x69, 0x71, 0xe4,
	0x82, 0x76, 0xa5, 0x60, 0x8a, 0x14, 0x6b, 0xc3, 0x76, 0x3a, 0x6e, 0x71, 0xf4, 0x82, 0x76, 0x65,
	0xc4, 0xc4, 0xdf, 0xe4, 0x34, 0x4c, 0xb8, 0xf4, 0xe3, 0xda, 0x27, 0x5d, 0xdb, 0xa3, 0xc5, 0xb1,
	0x0b, 0xda, 0x15, 0xcd, 0x2c, 0xb8, 0xf4, 0xe3, 0x87, 0x2c, 0x4d, 0x4e, 0x01, 0xfb, 0x5d, 0xeb,
	0x52, 0xab, 0x51, 0x1c, 0xc7, 0xb2, 0x71, 0x97, 0x7e, 0x6c, 0x52, 0xab, 0xc1, 0xda, 0xe8, 0x5a,
	0xed, 0x86, 0xf9, 0xb0, 0x58, 0xc0, 0x02, 0x91, 0x62, 0x6d, 0xb8, 0xf6, 0x97, 0x69, 0x71, 0x82,
	0xb7, 0xc1, 0x7e, 0xb3, 0xbc, 0x9e, 0x4b, 0x1b, 0x45, 0xe0, 0x79, 0xec, 0x37, 0xb9, 0x04, 0x33,
	0x5d, 0xc1, 0xa6, 0x9a, 0xdb, 0xa1, 0xb4, 0x51, 0x9c, 0xc4, 0x9e, 0x4f, 0xfb, 0xb9, 0x55, 0x96,
	0x49, 0xde, 0x86, 0x89, 0xa6, 0xe5, 0x7a, 0x35, 0xb7, 0x6e, 0xb5, 0x8b, 0x53, 0x17, 0xb4, 0x2b,
	0x93, 0xcb, 0xa5, 0x45, 0xce, 0xec, 0x45, 0x7f, 0x34, 0x16, 0xf7, 0xfc, 0xd1, 0x30, 0x0b, 0x0c,
	0xb8, 0x5a, 0xb7, 0xda, 0xa4, 0x04, 0x85, 0x16, 0xf5, 0xac, 0x86, 0xe5, 0x59, 0xc5, 0x69, 0xe4,
	0x42, 0x90, 0x26, 0x27, 0x60, 0xb4, 0x6e, 0xd5, 0x0f, 0x68, 0x71, 0x06, 0x0b, 0x78, 0xc2, 0xf8,
	0xd3, 0x1c, 0x4c, 0x0a, 0x7e, 0xee, 0x3a, 0x4e, 0x93, 0x8d, 0x50, 0x65, 0x0d, 0x47, 0x68, 0xd4,
	0xcc, 0x55, 0xd6, 0xc8, 0x02, 0xe4, 0x57, 0x1d, 0x17, 0x07, 0x68, 0x66, 0xb9, 0x18, 0x1b, 0x8a,
	0x55, 0xc7, 0xdd, 0x3b, 0xea, 0x50, 0x93, 0x01, 0xb1, 0x91, 0xdb, 0x1a, 0x6a, 0xe4, 0xf8, 0x7f,
	0x72, 0x06, 0x26, 0x4c, 0xcb, 0x6e, 0x6c, 0xd2, 0x43, 0xda, 0xc4, 0xc1, 0x9b, 0x30, 0xc3, 0x0c,
	0x56, 0xba, 0xe7, 0x78, 0x56, 0xb3, 0xca, 0x18, 0x3c, 0x8e, 0xcc, 0x0c, 0x33, 0x18, 0x97, 0xf7,
	0x19, 0x97, 0x0b, 0x9c, 0xcb, 0xec, 0x37, 0xf9, 0x02, 0x8c, 0x35, 0xad, 0x47, 0xb4, 0xe9, 0x16,
	0x27, 0x2e, 0xe4, 0xaf, 0x4c, 0x2e, 0x5f, 0x49, 0xa3, 0x83, 0xf5, 0x78, 0x71, 0x13, 0x41, 0xcb,
	0x6d, 0xaf, 0x7b, 0x64, 0x8a, 0x7a, 0xa5, 0x5b, 0x30, 0x29, 0x65, 0x13, 0x1d, 0xf2, 0x4f, 0xe9,
	0x91, 0x90, 0x5b, 0xf6, 0x93, 0x31, 0xf3, 0xd0, 0x6a, 0xf6, 0xa8, 0x90, 0x5c, 0x9e, 0xb8, 0x9d,
	0x7b, 0x47, 0x33, 0xbe, 0x93, 0x83, 0xe9, 0x07, 0x4e, 0xb3, 0xd7, 0xa2, 0x9b, 0x4e, 0xdd, 0xf2,
	0x9c, 0x2e, 0x23, 0xb1, 0x6d, 0xb5, 0xa8, 0xa8, 0x8e, 0xbf, 0xc9, 0x3e, 0x4c, 0x1f, 0x22, 0x50,
	0x4d, 0x50, 0x9a, 0x43, 0x4a, 0xaf, 0xc7, 0x28, 0x55, 0x50, 0xf9, 0x29, 0x89, 0xe2, 0xa9, 0x43,
	0x29, 0x8b, 0xbc, 0x03, 0x13, 0xce, 0x27, 0x6d, 0xda, 0x75, 0x0f, 0xec, 0x0e, 0x0e, 0x02, 0x13,
	0x9c, 0x28, 0xca, 0x1d, 0x1f, 0xc2, 0x0c, 0x81, 0xc9, 0x55, 0x18, 0x7d, 0xd2, 0x75, 0x7a, 0x1d,
	0xe4, 0xff, 0xe4, 0xf2, 0x7c, 0xac, 0xd6, 0x3d, 0x56, 0x6a, 0x72, 0x20, 0x72, 0x16, 0x40, 0x90,
	0x6f, 0x37, 0xd8, 0xcc, 0xca, 0xb3, 0x21, 0xe3, 0x39, 0x95, 0x86, 0x5b, 0xfa, 0x3c, 0xcc, 0xc5,
	0x28, 0x1d, 0x8a, 0x89, 0x0b, 0x70, 0x82, 0x23, 0xa8, 0xb4, 0xdd, 0x0e, 0xad, 0x7b, 0x3b, 0x1d,
	0xd4, 0x2c, 0x8c, 0x95, 0x0d, 0x4a, 0x3b, 0x88, 0xa4, 0x60, 0xe2, 0x6f, 0xe3, 0x06, 0x8c, 0x55,
	0xb9, 0x76, 0x99, 0x87, 0xb1, 0x8e, 0xd5, 0xa5, 0x6d, 0x4f, 0x34, 0x22, 0x52, 0x38, 0x3b, 0xd9,
	0x5c, 0x13, 0x5a, 0x86, 0xfd, 0x36, 0x4e, 0xc2, 0x28, 0xf6, 0x28, 0xaa, 0x92, 0x8c, 0x35, 0x80,
	0x8a, 0x53, 0xf5, 0xba, 0x96, 0x47, 0x9f, 0x1c, 0x31, 0x5d, 0x60, 0xb9, 0x47, 0xed, 0x7a, 0xcd,
	0x76, 0x44, 0xa3, 0xe3, 0x98, 0xae, 0x38, 0x4c, 0x87, 0x50, 0xab, 0xdb, 0x3c, 0xaa, 0x59, 0xf5,
	0xa7, 0x88, 0xba, 0x60, 0x16, 0x30, 0x63, 0xa5, 0xfe, 0xd4, 0xf8, 0x43, 0x00, 0xe0, 0x3d, 0xa8,
	0x76, 0x68, 0x9d, 0xc9, 0x30, 0xed, 0x1c, 0xd0, 0x16, 0xed, 0x5a, 0x4d, 0x81, 0x27, 0xcc, 0x08,
	0xb4, 0x47, 0x4e, 0xd2, 0x1e, 0x4b, 0x30, 0xf6, 0xd8, 0xe9, 0xb6, 0x2c, 0x4f, 0xcc, 0xa5, 0x93,
	0xb1, 0x01, 0x59, 0xaf, 0xe2, 0xcc, 0x13, 0x60, 0x6c, 0x48, 0x1e, 0x35, 0x9d, 0xfa, 0xd3, 0x1a,
	0xa2, 0x62, 0xa3, 0x98, 0x37, 0x27, 0x30, 0x07, 0xe7, 0xc9, 0x29, 0x28, 0x1c, 0x58, 0xb5, 0x26,
	0x4e, 0xb1, 0x51, 0x2c, 0x1c, 0x3f, 0xb0, 0xf8, 0x04, 0x5b, 0x80, 0x7c, 0xdd, 0x71, 0x51, 0x0d,
	0xf6, 0x9d, 0xe2, 0x75, 0xc7, 0x25, 0xb7, 0x00, 0x6c, 0xa7, 0xd6, 0xe9, 0x3a, 0x8f, 0xed, 0x26,
	0x9f, 0x8d, 0x33, 0x09, 0x12, 0x56, 0x71, 0x76, 0x39, 0x84, 0x39, 0x61, 0xfb, 0x3f, 0xd9, 0xe8,
	0x34, 0x68, 0xa3, 0xd7, 0xa1, 0x38, 0x57, 0x0b, 0xa6, 0x48, 0x91, 0xd7, 0x61, 0xce, 0x6d, 0x5b,
	0x1d, 0xf7, 0xc0, 0xf1, 0x6a, 0x76, 0xdb, 0xa3, 0xdd, 0x43, 0xab, 0x89, 0x8a, 0x74, 0xda, 0xd4,
	0xfd, 0x82, 0x8a, 0xc8, 0x27, 0x66, 0x74, 0xde, 0x00, 0xce, 0x9b, 0x6b, 0x29, 0xf3, 0x86, 0x31,
	0x7f, 0xe0, 0xa4, 0x99, 0x87, 0x31, 0xf7, 0xc0, 0xea, 0x0a, 0x65, 0x5c, 0x30, 0x45, 0x8a, 0xbc,
	0x0b, 0x93, 0x5d, 0xda, 0x69, 0xda, 0x75, 0xab, 0xe6, 0x52, 0x4f, 0xe8, 0xe1, 0xd3, 0xb1, 0x96,
	0x4c, 0x0e, 0x53, 0xa5, 0x9e, 0x09, 0xdd, 0xe0, 0x37, 0xeb, 0x96, 0xf5, 0xe4, 0x49, 0x97, 0x3e,
	0xe1, 0xda, 0x9e, 0x73, 0x7e, 0x9a, 0x77, 0x4b, 0x2a, 0x08, 0x74, 0x1c, 0x6d, 0xd7, 0xbb, 0x47,
	0x1d, 0x8f, 0x36, 0x84, 0x7e, 0x0e, 0x33, 0xc8, 0x39, 0x80, 0x8e, 0xe5, 0xba, 0x9d, 0x83, 0xae,
	0xe5, 0xd2, 0xe2, 0x2c, 0x8a, 0xaa, 0x94, 0xa3, 0x70, 0xd0, 0xad, 0x1f, 0xd0, 0x46, 0xaf, 0x49,
	0x8b, 0x3a, 0x82, 0x05, 0x1c, 0xac, 0x8a, 0x7c, 0x36, 0xe9, 0xdc, 0xba, 0xd5, 0xa4, 0xc5, 0x39,
	0xa4, 0x85, 0x27, 0x90, 0x07, 0x9e, 0x5d, 0x7f, 0x7a, 0x54, 0x24, 0x82, 0x07, 0x98, 0x0a, 0xd5,
	0xc2, 0x4b, 0x59, 0xd4, 0xc2, 0x25, 0x98, 0xc1, 0x1f, 0x35, 0xda, 0x7e, 0xec, 0x74, 0xeb, 0xb4,
	0x51, 0x9c, 0x47, 0x6c, 0xd3, 0x98, 0x5b, 0x16, 0x99, 0xac, 0x3f, 0x75, 0xa7, 0xd5, 0xe9, 0x52,
	0x97, 0x69, 0xee, 0x93, 0x08, 0x22, 0xe5, 0xb0, 0x55, 0xac, 0x6e, 0xb9, 0x75, 0xab, 0x41, 0x1b,
	0xc5, 0x22, 0x9f, 0x58, 0x7e, 0x9a, 0x14, 0x61, 0xfc, 0x23, 0xa7, 0xd7, 0x6d, 0x5b, 0xcd, 0xe2,
	0x29, 0x3e, 0x1f, 0x45, 0x92, 0xd5, 0xe2, 0x03, 0x77, 0x78, 0xa3, 0x58, 0xe2, 0xb5, 0xfc, 0x34,
	0x39, 0x0f, 0x93, 0x1f, 0xf7, 0x68, 0x8f, 0xd6, 0x1a, 0xb4, 0xe3, 0x1d, 0x14, 0x4f, 0x63, 0xd7,
	0x01, 0xb3, 0xd6, 0x58, 0x0e, 0xb9, 0x05, 0xa7, 0x90, 0xb8, 0x5a, 0xaf, 0xed, 0xf6, 0x3a, 0x1d,
	0xa7, 0xeb, 0xd1, 0x46, 0xed, 0xb1, 0x5b, 0xf3, 0x8e, 0x3a, 0xb4, 0x78, 0x06, 0xb1, 0xcd, 0x23,
	0xc0, 0x7e, 0x58, 0xbe, 0x8e, 0xf3, 0x82, 0x8d, 0x5d, 0xdb, 0x69, 0xd8, 0x6e, 0xdd, 0xea, 0x36,
	0x8a, 0x67, 0xf9, 0xd8, 0x05, 0x19, 0x4c, 0x88, 0x6c, 0xa7, 0xe6, 0x0a, 0x7d, 0x52, 0x3c, 0x97,
	0x22, 0x44, 0xa1, 0xca, 0x31, 0xc1, 0x0e, 0xd5, 0xcf, 0x43, 0x20, 0x9d, 0xa6, 0x55, 0xa7, 0x2d,
	0xda, 0xf6, 0x42, 0x24, 0xe7, 0x11, 0xc9, 0x95, 0x14, 0x99, 0xdf, 0xf5, 0x2b, 0x04, 0x18, 0xe7,
	0x3a, 0xd1, 0x2c, 0x36, 0x52, 0xa2, 0x66, 0xad, 0xe3, 0x34, 0xed, 0xfa, 0x51, 0xf1, 0x02, 0x37,
	0x44, 0x5c, 0x7f, 0x65, 0x64, 0x99, 0xea, 0x7a, 0x72, 0x71, 0x88, 0xf5, 0xe4, 0xf9, 0x97, 0x80,
	0xff, 0x31, 0x0e, 0x7a, 0x38, 0x89, 0xf7, 0x3b, 0x0d, 0xcb, 0x63, 0xc2, 0x2b, 0x69, 0xca, 0x8d,
	0x63, 0x42, 0x57, 0x9e, 0x8e, 0xea, 0xb6, 0x0d, 0x2d, 0xd4, 0x6e, 0x57, 0x33, 0x69, 0xb7, 0x8d,
	0x1c, 0xd7, 0x6f, 0x77, 0x86, 0xd3, 0x6f, 0x1b, 0x79, 0x59, 0xc3, 0x15, 0x55, 0x0d, 0xb7, 0x31,
	0x12, 0xe8, 0xb8, 0x6b, 0xa9, 0x3a, 0x6e, 0x63, 0x34, 0x41, 0xcb, 0x15, 0x55, 0x8d, 0xb4, 0x31,
	0xf6, 0x82, 0x74, 0xd2, 0x85, 0xb8, 0x22, 0xd9, 0x18, 0x57, 0x54, 0xc9, 0xb5, 0x54, 0x55, 0xb2,
	0x51, 0x48, 0x50, 0x26, 0xf3, 0x8a, 0x32, 0xd9, 0x98, 0xf0, 0xd5, 0x49, 0x51, 0x55, 0x27, 0x1b,
	0x10, 0x28, 0x94, 0x45, 0x5f, 0xa1, 0x1c, 0xef, 0xa7, 0x50, 0x36, 0x26, 0x7d, 0x95, 0x52, 0x0a,
	0xe7, 0x3b, 0x2a, 0x8a, 0x8d, 0xa9, 0x70, 0xc6, 0x9f, 0x91, 0x66, 0x3c, 0xea, 0x89, 0x8d, 0x69,
	0x69, 0xce, 0x5f, 0x54, 0xe7, 0xfc, 0x29, 0xa4, 0x70, 0x46, 0x99, 0xf5, 0x8a, 0x78, 0x97, 0x86,
	0x31, 0x97, 0xce, 0xc9, 0x93, 0xfe, 0x34, 0xb6, 0x3d, 0xdb, 0x67, 0xda, 0x9f, 0x19, 0x6a, 0xda,
	0xdf, 0x05, 0x28, 0x30, 0xc1, 0xae, 0x39, 0x1d, 0xef, 0xee, 0x0c, 0x4c, 0xf9, 0xc2, 0x8d, 0xe9,
	0x09, 0x18, 0xaf, 0x3b, 0x2e, 0xfe, 0xd4, 0x61, 0x26, 0x14, 0x56, 0xcc, 0x99, 0x02, 0xe0, 0x12,
	0x87, 0xa9, 0x93, 0xf0, 0x52, 0x4c, 0xea, 0x7c, 0x30, 0xce, 0x26, 0x1f, 0x4d, 0x28, 0x01, 0xb1,
	0x8a, 0xbe, 0x14, 0x60, 0xc1, 0x24, 0x4c, 0xe0, 0x00, 0x07, 0x58, 0x70, 0x50, 0xfd, 0x22, 0xae,
	0xfb, 0x59, 0x62, 0x1a, 0x26, 0xc5, 0x20, 0xf9, 0x7d, 0xf0, 0x87, 0x05, 0xd3, 0x73, 0x30, 0x2b,
	0x0d, 0x0d, 0x66, 0xcd, 0xc2, 0x74, 0xc0, 0x3d, 0x96, 0x61, 0xfc, 0xed, 0x94, 0x3c, 0xff, 0x85,
	0x3e, 0xf2, 0xe7, 0xbf, 0x96, 0x3a, 0xff, 0x73, 0x29, 0xf3, 0x3f, 0xff, 0x2c, 0xf3, 0x7f, 0xe4,
	0x59, 0xe7, 0xff, 0x68, 0x96, 0xf9, 0x3f, 0x96, 0x3a, 0xff, 0x3f, 0x88, 0x5a, 0x39, 0xe3, 0x68,
	0xe5, 0xbc, 0xd9, 0xc7, 0xca, 0xe1, 0x0c, 0x1a, 0x68, 0xeb, 0x84, 0x9a, 0xa5, 0xd0, 0x5f, 0xb3,
	0x4c, 0x3c, 0x8f, 0x66, 0x81, 0xac, 0x9a, 0x65, 0x72, 0xb0, 0x66, 0x99, 0x4a, 0xd3, 0x2c, 0xd3,
	0x69, 0x9a, 0x65, 0x66, 0x68, 0xcd, 0x32, 0xdb, 0x4f, 0xb3, 0xe8, 0x83, 0x34, 0xcb, 0x5c, 0x82,
	0x66, 0x39, 0x27, 0x1b, 0x74, 0xc4, 0xd7, 0x0f, 0xa1, 0x49, 0x77, 0x2d, 0xc9, 0x3a, 0x3c, 0x8e,
	0x88, 0xf4, 0x04, 0xfb, 0x70, 0x07, 0xa6, 0x85, 0x42, 0xa0, 0x5d, 0xb6, 0x11, 0x2c, 0x2e, 0xa3,
	0x64, 0x2e, 0x0c, 0x16, 0x08, 0xfe, 0x6f, 0xa7, 0x63, 0x4e, 0x31, 0x04, 0x3b, 0xa2, 0x3e, 0x79,
	0x00, 0x73, 0x92, 0x56, 0x11, 0x48, 0xdf, 0x1c, 0x1a, 0xe9, 0xac, 0x98, 0x65, 0x01, 0xde, 0xf7,
	0x61, 0xc6, 0x57, 0x10, 0x02, 0xe9, 0x8d, 0xa1, 0x91, 0x4e, 0x23, 0x86, 0x00, 0xe5, 0x01, 0x94,
	0x92, 0xb4, 0x98, 0x40, 0x7f, 0x73, 0x68, 0xf4, 0xc5, 0xe8, 0x74, 0x0b, 0x5a, 0x52, 0x94, 0xfa,
	0x5b, 0x38, 0x68, 0x73, 0x7d, 0x94, 0xfa, 0xdb, 0x43, 0x29, 0xf5, 0xe7, 0xb7, 0x88, 0x96, 0xa0,
	0xe0, 0x77, 0x82, 0x4c, 0xc0, 0x68, 0xf9, 0xe3, 0x9e, 0xd5, 0xd4, 0x8f, 0x91, 0x49, 0x18, 0xdf,
	0xb2, 0xdb, 0x76, 0xab, 0xd7, 0xd2, 0x35, 0x4c, 0x58, 0x9f, 0x62, 0x22, 0xf7, 0x7f, 0xe8, 0x32,
	0x12, 0x4c, 0x32, 0x9f, 0x86, 0xd8, 0x44, 0x4b, 0x5e, 0x70, 0x0c, 0x80, 0x50, 0xb9, 0xb1, 0x61,
	0x68, 0x3b, 0x0d, 0xea, 0x16, 0x35, 0x74, 0x6e, 0xf0, 0x84, 0xf1, 0x1b, 0x1a, 0xcc, 0x9a, 0xbd,
	0xb6, 0x67, 0xb7, 0x68, 0xd5, 0xb3, 0x3c, 0xba, 0x65, 0x75, 0xc8, 0x43, 0x98, 0xee, 0xf2, 0xac,
	0x9a, 0xcb, 0xf2, 0xb0, 0xc6, 0xe4, 0xf2, 0x72, 0x5c, 0x75, 0xaa, 0x15, 0x95, 0xb4, 0xd0, 0xd5,
	0x5d, 0x29, 0x8b, 0x09, 0x4c, 0x0c, 0x64, 0x28, 0x81, 0xf9, 0xf6, 0x08, 0x4c, 0x04, 0xd6, 0x0b,
	0x83, 0x43, 0xfb, 0x45, 0xd4, 0xe5, 0x09, 0xf2, 0x2e, 0x8c, 0x58, 0xf5, 0x26, 0x77, 0xf0, 0x25,
	0xed, 0x29, 0x82, 0xfa, 0x8b, 0x2b, 0xf5, 0x3a, 0x75, 0xdd, 0x55, 0xa7, 0xed, 0x75, 0x9d, 0xa6,
	0x89, 0xb5, 0x4a, 0x3f, 0x99, 0x87, 0x69, 0x25, 0x9f, 0x6c, 0xc2, 0x18, 0x8e, 0x9f, 0x2b, 0xd8,
	0x70, 0x23, 0x2b, 0x46, 0xae, 0x9e, 0x7d, 0x3f, 0x1c, 0xc7, 0x41, 0x2c, 0x98, 0xae, 0x3b, 0xcd,
	0xa6, 0xf5, 0xc8, 0xc1, 0x19, 0xea, 0xbb, 0xc9, 0xee, 0x64, 0x46, 0xba, 0x2a, 0xd7, 0xe6, 0xb8,
	0x55, 0x8c, 0xa5, 0x2f, 0xc1, 0xa4, 0xd4, 0x72, 0x02, 0x7f, 0xef, 0xc8, 0xfc, 0x9d, 0x59, 0xbe,
	0x34, 0xb0, 0x6d, 0xf4, 0x96, 0x84, 0xc3, 0x50, 0x7a, 0x02, 0x24, 0x4e, 0xc6, 0x77, 0xa1, 0x21,
	0xe3, 0x2a, 0x40, 0x58, 0x40, 0x0a, 0x30, 0x62, 0x52, 0xab, 0xa1, 0x1f, 0x63, 0xca, 0x02, 0x3d,
	0xdb, 0xba, 0xc6, 0x7e, 0xae, 0x34, 0x5a, 0x76, 0x5b, 0xcf, 0x19, 0xdf, 0x98, 0x80, 0x31, 0xae,
	0x90, 0x62, 0x6e, 0xf9, 0x25, 0x18, 0xe3, 0x0e, 0x7b, 0x21, 0x16, 0x71, 0xe7, 0x13, 0xf7, 0xb8,
	0x99, 0x02, 0x2c, 0x74, 0x13, 0xe4, 0xb3, 0xb8, 0x09, 0x4a, 0x50, 0xe8, 0x52, 0xab, 0xe1, 0xb4,
	0x9b, 0x47, 0xc2, 0x57, 0x1f, 0xa4, 0xc9, 0x3b, 0x30, 0xde, 0xe4, 0xce, 0x4e, 0x34, 0xa2, 0x26,
	0x13, 0x9c, 0xc8, 0x8a, 0x4b, 0xd4, 0xf4, 0xc1, 0xc9, 0x75, 0x18, 0xad, 0xb3, 0xc9, 0x82, 0x76,
	0x55, 0x7f, 0x87, 0x39, 0x07, 0x24, 0x4b, 0x30, 0xe2, 0x76, 0x68, 0x1d, 0xb7, 0x79, 0x49, 0x8a,
	0x3c, 0x5c, 0x43, 0x4c, 0x04, 0x64, 0x53, 0xa8, 0xe7, 0x5a, 0x4f, 0xa8, 0xf0, 0x36, 0xf3, 0x84,
	0xea, 0xad, 0x9f, 0x18, 0xc2, 0x5b, 0x1f, 0xfa, 0xf8, 0x20, 0x9b, 0x8f, 0xef, 0x26, 0x33, 0x7e,
	0x2c, 0xaf, 0xe7, 0xa2, 0xe1, 0x34, 0xb3, 0x7c, 0x36, 0x8d, 0x64, 0x04, 0x32, 0x05, 0x30, 0x59,
	0x86, 0x51, 0xae, 0x99, 0xa6, 0xb0, 0xd6, 0x99, 0x3e, 0xb5, 0xa8, 0xc9, 0x41, 0xc9, 0x79, 0x98,
	0xb4, 0x3c, 0xcf, 0x62, 0x5a, 0xbb, 0xe6, 0xb4, 0xd1, 0xd8, 0x9a, 0x30, 0xc1, 0xcf, 0xda, 0x69,
	0x93, 0x55, 0x98, 0x09, 0x00, 0x38, 0xf6, 0x99, 0x14, 0xec, 0x2b, 0x08, 0xc6, 0xb1, 0x4f, 0xfb,
	0x75, 0xaa, 0x7e, 0x2b, 0x0d, 0x7a, 0x68, 0xd7, 0x69, 0x0d, 0x8f, 0x81, 0x84, 0x6b, 0x8b, 0x67,
	0xed, 0x5a, 0xde, 0x01, 0xb9, 0x0a, 0xc4, 0xa5, 0xf5, 0x5e, 0x97, 0xe9, 0xf8, 0x10, 0xce, 0xf7,
	0x6d, 0x61, 0xc9, 0x5a, 0x08, 0x1d, 0x10, 0xcd, 0xc1, 0xe6, 0x50, 0x75, 0x0b, 0xa2, 0x11, 0x60,
	0x23, 0x00, 0xb0, 0xdb, 0x8f, 0x9d, 0x22, 0x41, 0x6d, 0x72, 0x39, 0x85, 0x1f, 0x82, 0xf0, 0x4a,
	0xfb, 0xb1, 0xc3, 0x35, 0x87, 0xc0, 0xc4, 0x32, 0xc8, 0xe7, 0x60, 0x4a, 0x32, 0x97, 0xdd, 0xe2,
	0x71, 0x44, 0xd5, 0xd7, 0x5e, 0x9e, 0x0c, 0xed, 0x65, 0x97, 0x94, 0xa3, 0xab, 0xc6, 0x09, 0x44,
	0x70, 0x61, 0xd0, 0xaa, 0xa1, 0xae, 0x11, 0x4c, 0x22, 0x69, 0xb7, 0xeb, 0x74, 0xd1, 0x3f, 0x37,
	0x61, 0xf2, 0x04, 0xf9, 0x3e, 0xd0, 0xc5, 0xfe, 0xa1, 0xee, 0xb4, 0xdd, 0x5e, 0x8b, 0x76, 0xdd,
	0xe2, 0x3c, 0xe2, 0x3f, 0x9f, 0xd2, 0xd7, 0x55, 0x01, 0x67, 0xce, 0x1e, 0x2a, 0x69, 0x97, 0x8d,
	0xc0, 0x63, 0xb7, 0xd6, 0xa5, 0x68, 0x49, 0x74, 0xe9, 0xc7, 0x3d, 0xbb, 0x1b, 0x38, 0xed, 0xf4,
	0xc7, 0xae, 0x89, 0x05, 0xa6, 0xc8, 0x2f, 0xbd, 0x07, 0xb3, 0x11, 0xae, 0x0d, 0xb5, 0x62, 0xfd,
	0xff, 0x39, 0x18, 0x65, 0x1d, 0x73, 0x19, 0x0c, 0xd3, 0x09, 0x2e, 0xdf, 0xea, 0x99, 0x3c, 0x41,
	0x4e, 0xc2, 0x38, 0xfb, 0x51, 0x6b, 0xb9, 0xc2, 0x59, 0x3e, 0xc6, 0x92, 0x5b, 0x2e, 0x39, 0x0b,
	0x80, 0x05, 0x8f, 0x8e, 0x3c, 0xca, 0x37, 0x7b, 0x23, 0xe6, 0x04, 0xcb, 0xb9, 0xcb, 0x32, 0xc8,
	0x3c, 0x8c, 0xe1, 0x59, 0x9f, 0x8b, 0xfa, 0x66, 0xc4, 0x14, 0x29, 0x72, 0x0a, 0x0a, 0xf8, 0x8b,
	0x21, 0xe4, 0xe7, 0x83, 0xe3, 0x98, 0xde, 0x72, 0x99, 0x2c, 0xf1, 0x22, 0x8e, 0x72, 0x0c, 0x4b,
	0x01, 0xb3, 0x38, 0xce, 0xf3, 0x68, 0x0d, 0x76, 0xba, 0xce, 0x93, 0x2e, 0x75, 0x5d, 0x71, 0x32,
	0x05, 0xb8, 0x1b, 0xc4, 0x1c, 0x72, 0x1c, 0x46, 0x6d, 0x87, 0x61, 0x2e, 0xf8, 0x27, 0x8f, 0x9c,
	0x50, 0x44, 0x58, 0xc3, 0xb3, 0x41, 0x7e, 0x5e, 0x38, 0x81, 0x39, 0x78, 0x74, 0xc5, 0x90, 0xfa,
	0x26, 0x56, 0xcb, 0x15, 0x67, 0x87, 0xe0, 0x67, 0x6d, 0xb9, 0xc6, 0x8f, 0x6a, 0x30, 0xb7, 0x6a,
	0x75, 0xac, 0xba, 0xed, 0x1d, 0xed, 0x33, 0xf5, 0x83, 0xd2, 0x78, 0x19, 0x66, 0xe9, 0xa7, 0xf5,
	0x66, 0xcf, 0xb5, 0x0f, 0x7d, 0x82, 0x35, 0x74, 0xf2, 0xcf, 0x04, 0xd9, 0x9c, 0xe8, 0x8b, 0xbe,
	0x09, 0x25, 0xa0, 0x70, 0xbb, 0x6c, 0x4e, 0xf2, 0xbc, 0xa0, 0x5f, 0x9e, 0xe3, 0x59, 0x4d, 0x89,
	0x97, 0x79, 0x13, 0x30, 0x0b, 0x01, 0x8c, 0x7f, 0xad, 0x81, 0x5e, 0x6d, 0x3c, 0xad, 0x2a, 0x9e,
	0xc2, 0xa4, 0x43, 0xae, 0x5b, 0x30, 0x26, 0x9c, 0x8b, 0x7c, 0x19, 0xb9, 0x38, 0xd0, 0x4a, 0x37,
	0x45, 0x05, 0x36, 0xfc, 0xe8, 0x6e, 0xc5, 0xe6, 0x0b, 0x26, 0x4f, 0x30, 0xea, 0xad, 0x66, 0xd3,
	0xf9, 0xa4, 0xd6, 0x43, 0x77, 0xa0, 0x58, 0x3c, 0x26, 0x31, 0x4f, 0x78, 0x08, 0x15, 0x97, 0xce,
	0xe8, 0x10, 0x2e, 0x1d, 0xe3, 0x9f, 0xe5, 0x61, 0x74, 0xa5, 0x49, 0xbb, 0x9e, 0xb4, 0x1c, 0xe6,
	0x71, 0x39, 0xbc, 0x05, 0x05, 0x97, 0x1e, 0xd2, 0xae, 0xed, 0x1d, 0x89, 0xb5, 0x39, 0xae, 0x78,
	0xab, 0x02, 0x00, 0xf5, 0x75, 0x00, 0xce, 0x86, 0xdb, 0x62, 0x38, 0xb9, 0x23, 0x99, 0xf3, 0x72,
	0x02, 0x73, 0x70, 0x8d, 0x2e, 0xc2, 0x78, 0x8b, 0xba, 0xb8, 0xa4, 0xf0, 0x73, 0x4f, 0x3f, 0xc9,
	0xfa, 0x11, 0x1c, 0xb7, 0x07, 0xfd, 0x48, 0x5f, 0x54, 0x42, 0x60, 0x36, 0x7e, 0x5d, 0x71, 0xde,
	0x5e, 0xb3, 0x1b, 0x28, 0xb8, 0x13, 0x6c, 0xaf, 0xce, 0xb3, 0x2a, 0xd8, 0x1d, 0x3f, 0x25, 0x3c,
	0x9c, 0x67, 0x13, 0xd4, 0x16, 0x07, 0xe0, 0xdd, 0xf1, 0xc1, 0x19, 0xbd, 0xf5, 0x26, 0x0d, 0xfd,
	0x07, 0xa6, 0x9f, 0x64, 0xb3, 0xdc, 0xf3, 0x9a, 0x42, 0xa0, 0xd9, 0x4f, 0xd6, 0xf5, 0x5e, 0xdb,
	0xfe, 0xb8, 0x47, 0x6b, 0x9e, 0xf5, 0x84, 0xbb, 0x04, 0xcc, 0x09, 0x9e, 0xb3, 0x67, 0x3d, 0xc1,
	0xe3, 0x68, 0xa7, 0xd7, 0xf6, 0x70, 0x29, 0xcb, 0x9b, 0x3c, 0x41, 0x6e, 0x01, 0x3c, 0xb6, 0xbb,
	0x6c, 0x31, 0xa5, 0x34, 0xcb, 0xd1, 0xf7, 0x04, 0x42, 0x57, 0x29, 0x6d, 0x1b, 0x3f, 0xae, 0xc1,
	0x5c, 0xb5, 0xf1, 0x14, 0x87, 0xd0, 0x65, 0x10, 0xd5, 0x8e, 0xd5, 0x66, 0x08, 0x5d, 0xcf, 0x62,
	0x03, 0x60, 0x0b, 0xe9, 0x1c, 0x80, 0x10, 0xa1, 0x59, 0x9a, 0xdc, 0x84, 0x02, 0x6d, 0x37, 0x78,
	0xc5, 0xdc, 0xc0, 0x8a, 0xe3, 0xb4, 0xdd, 0x60, 0x29, 0x63, 0x1b, 0x48, 0x40, 0xc6, 0x2a, 0xeb,
	0x14, 0xd2, 0x71, 0x1a, 0x26, 0x5a, 0x76, 0xbb, 0xc6, 0xbb, 0xcc, 0x45, 0xab, 0xd0, 0xb2, 0xdb,
	0x08, 0x80, 0x85, 0xd6, 0xa7, 0xa2, 0x30, 0x27, 0x0a, 0xad, 0x4f, 0xb1, 0xd0, 0xf8, 0x7a, 0x0e,
	0x66, 0x03, 0x84, 0xfc, 0x20, 0x94, 0xdc, 0x87, 0x39, 0x86, 0xcd, 0x17, 0x33, 0x2e, 0x5d, 0x5a,
	0x06, 0xd1, 0xdc, 0x38, 0x66, 0xce, 0xb6, 0xec, 0xb6, 0x9c, 0x45, 0xce, 0x03, 0xd8, 0x6e, 0xcd,
	0x1f, 0x57, 0x3c, 0xc9, 0xdc, 0x38, 0x66, 0x4e, 0xd8, 0xee, 0xaa, 0x18, 0xdb, 0x15, 0x2e, 0x8b,
	0x35, 0xb7, 0x63, 0xb5, 0x85, 0x85, 0x67, 0xc4, 0x5b, 0x89, 0xb2, 0x7e, 0xe3, 0x98, 0x59, 0xf0,
	0xfc, 0x61, 0x58, 0x03, 0xc0, 0xde, 0x71, 0x1c, 0xfc, 0x8c, 0xf9, 0xe5, 0x74, 0x1c, 0x01, 0xdf,
	0x18, 0x21, 0x75, 0x3f, 0x71, 0x77, 0x14, 0xf2, 0x6c, 0xa7, 0xf6, 0x25, 0x28, 0x05, 0x90, 0xb2,
	0xa0, 0xbe, 0xdf, 0xa3, 0xdd, 0x23, 0x72, 0x17, 0xa6, 0x03, 0xf9, 0xef, 0xcb, 0x17, 0x45, 0xc6,
	0xa7, 0xba, 0x52, 0xca, 0xf8, 0x2a, 0x9c, 0x0c, 0x5a, 0x58, 0xf1, 0x67, 0xeb, 0x0b, 0x43, 0x1f,
	0xd1, 0x0a, 0xb9, 0x88, 0x56, 0x30, 0xfe, 0x3f, 0x0d, 0x8a, 0xb1, 0x0e, 0x56, 0x1a, 0xdf, 0xab,
	0xf6, 0xa3, 0x1a, 0x24, 0x1f, 0xd5, 0x20, 0xc6, 0x5f, 0xe4, 0x60, 0x26, 0x20, 0x90, 0x93, 0xf5,
	0x83, 0x70, 0x5c, 0x21, 0xab, 0xf6, 0x31, 0xcb, 0x16, 0x13, 0xee, 0xf5, 0xf4, 0x91, 0x8e, 0x8d,
	0xdf, 0xc6, 0x31, 0x73, 0xae, 0x1b, 0x1b, 0xd4, 0x3d, 0xd0, 0x43, 0x8a, 0x05, 0xee, 0xb4, 0x2d,
	0x6b, 0xca, 0xc8, 0x6d, 0x1c, 0x33, 0x67, 0x2c, 0x75, 0x2c, 0x1f, 0xc2, 0x9c, 0xd4, 0x51, 0x81,
	0x96, 0x0b, 0xf8, 0x6b, 0x83, 0x49, 0x16, 0x23, 0xc2, 0xa6, 0x54, 0x37, 0x32, 0x48, 0x37, 0x60,
	0xc4, 0xe9, 0x78, 0xcc, 0xda, 0x48, 0x36, 0xea, 0x22, 0xf3, 0xd9, 0x44, 0xe8, 0xbb, 0xe3, 0x30,
	0x8a, 0x24, 0x18, 0x16, 0xbc, 0x12, 0x40, 0x94, 0xdb, 0xcc, 0x0e, 0xb3, 0x3c, 0xfa, 0xd0, 0xf6,
	0x0e, 0xd6, 0xed, 0xa6, 0x47, 0xbb, 0x2e, 0x33, 0xb7, 0xa8, 0xcb, 0xb4, 0xe5, 0x38, 0xab, 0x60,
	0x53, 0x7f, 0xb7, 0x7d, 0x3e, 0xbd, 0x25, 0x24, 0xcc, 0xf4, 0xe1, 0x8d, 0x87, 0x70, 0x69, 0x40,
	0x13, 0x6e, 0xc7, 0x69, 0xbb, 0x94, 0x2c, 0xc2, 0x18, 0x72, 0xcd, 0x6f, 0x22, 0xbe, 0xb7, 0x43,
	0x24, 0xa6, 0x80, 0x32, 0xaa, 0x30, 0x1f, 0x20, 0x5e, 0xa3, 0x4d, 0xea, 0xd1, 0x17, 0x40, 0xed,
	0x29, 0x69, 0x3e, 0xfa, 0x48, 0x39, 0x7d, 0xc6, 0x5b, 0x30, 0xc6, 0xf3, 0xd9, 0x26, 0x14, 0x69,
	0x18, 0x40, 0x28, 0x07, 0x32, 0xfe, 0x55, 0x0e, 0x66, 0x77, 0x1e, 0x7d, 0x44, 0xeb, 0x1e, 0x03,
	0xe1, 0x66, 0x14, 0x81, 0x91, 0x5e, 0x2f, 0xd8, 0x09, 0xe3, 0x6f, 0xa6, 0x9b, 0x83, 0xab, 0x2e,
	0xc2, 0x60, 0x2d, 0xf8, 0x37, 0x5d, 0xd8, 0x7a, 0x48, 0xdb, 0xd6, 0xa3, 0x26, 0x6d, 0x08, 0x43,
	0xc5, 0x4f, 0xf2, 0x03, 0x75, 0xdc, 0xaa, 0xf1, 0x85, 0xdd, 0xdf, 0x8b, 0xcd, 0xc3, 0x98, 0x55,
	0x67, 0x63, 0x2e, 0x6e, 0x61, 0x88, 0x14, 0x4e, 0x49, 0xdc, 0xbb, 0xd7, 0x98, 0xb1, 0xcc, 0x17,
	0xed, 0x09, 0x9e, 0x73, 0x9f, 0xa2, 0x1d, 0xe1, 0xd2, 0x7a, 0x97, 0x7a, 0x58, 0x3c, 0xce, 0x8b,
	0x79, 0x0e, 0x2b, 0xc6, 0xfb, 0x03, 0x8d, 0x8e, 0x63, 0xb7, 0x3d, 0x66, 0x6e, 0xe2, 0x75, 0x9c,
	0x20, 0x83, 0xbc, 0x06, 0x7a, 0xbd, 0xd7, 0xed, 0xd2, 0xb6, 0x57, 0xf3, 0x33, 0x71, 0xa1, 0x9e,
	0x30, 0x67, 0x45, 0x7e, 0x59, 0x64, 0xe3, 0x0e, 0x8a, 0x93, 0xd1, 0x71, 0xba, 0x7c, 0x5f, 0x9a,
	0x37, 0x05, 0x65, 0xbb, 0x4e, 0xd7, 0xc3, 0x1b, 0x70, 0xf4, 0x09, 0xa3, 0x9f, 0xdf, 0x5c, 0x13,
	0x29, 0xe3, 0xb7, 0x35, 0x38, 0x2e, 0xb6, 0x12, 0x5d, 0x6a, 0x85, 0x83, 0x2e, 0xed, 0xe7, 0xb5,
	0xe1, 0xf6, 0xf3, 0x43, 0x3b, 0x21, 0xfc, 0xed, 0x7c, 0x3e, 0xe3, 0x76, 0xde, 0x78, 0x15, 0x66,
	0x78, 0x5e, 0x20, 0xec, 0xc1, 0x76, 0x4a, 0x93, 0xb6, 0x53, 0x46, 0xc7, 0xbf, 0x8d, 0xe4, 0x77,
	0x4d, 0x40, 0x47, 0xdd, 0x26, 0x1b, 0x20, 0x76, 0x4f, 0x6c, 0xbb, 0x84, 0x20, 0x82, 0xf4, 0xb4,
	0x5d, 0x97, 0x8f, 0xc9, 0x9c, 0x39, 0x54, 0xd2, 0xc6, 0x1f, 0x6b, 0xbe, 0xb3, 0x18, 0xb7, 0x79,
	0x2b, 0x5c, 0x46, 0x6e, 0xc3, 0x18, 0xdf, 0x81, 0x0a, 0x9d, 0x6f, 0xa4, 0xa0, 0xe5, 0xe0, 0xbb,
	0x56, 0xd7, 0x6a, 0x99, 0xa2, 0x06, 0x79, 0x07, 0x46, 0x5b, 0x81, 0x79, 0x91, 0xad, 0x2a, 0xaf,
	0xc0, 0x44, 0x0f, 0x7f, 0xf0, 0x3d, 0x35, 0x5f, 0x0c, 0x26, 0x30, 0xc7, 0xdf, 0x73, 0xcb, 0x5b,
	0xf3, 0x91, 0xe8, 0x16, 0xde, 0xf8, 0xc3, 0x5c, 0x70, 0x90, 0x47, 0xbd, 0x17, 0x21, 0x16, 0x7c,
	0x94, 0x73, 0x59, 0x9d, 0x36, 0xb7, 0x83, 0x19, 0x97, 0x66, 0xba, 0xc4, 0x38, 0x1d, 0xcc, 0xca,
	0x0d, 0x18, 0x77, 0xf8, 0xd5, 0x33, 0xa1, 0xca, 0x17, 0xd3, 0x2a, 0x07, 0x5d, 0x5b, 0x14, 0x77,
	0xd5, 0xb8, 0xcb, 0xc0, 0xaf, 0x5e, 0xba, 0x0d, 0x53, 0x72, 0xc1, 0x50, 0xbb, 0xe2, 0x9f, 0x0a,
	0xa5, 0x81, 0x35, 0x23, 0xa4, 0x6f, 0x09, 0xc6, 0xb8, 0xd4, 0x08, 0x0e, 0x9e, 0x4c, 0x13, 0x32,
	0x01, 0xf6, 0x02, 0xc5, 0xf3, 0xe7, 0x98, 0xa9, 0xdd, 0xb6, 0x3a, 0xea, 0x54, 0x8f, 0x4e, 0x07,
	0x69, 0x8c, 0x73, 0xc3, 0x8d, 0xb1, 0xec, 0x20, 0xcc, 0x47, 0x1c, 0x84, 0xa7, 0xa0, 0xd0, 0x76,
	0x6a, 0x5d, 0xea, 0x75, 0x7d, 0xe7, 0xe1, 0x78, 0xdb, 0x31, 0x59, 0xd2, 0xf8, 0x18, 0x88, 0x4c,
	0x95, 0xe0, 0xd3, 0xf7, 0xc3, 0xbc, 0xef, 0x0c, 0xc1, 0x82, 0xb0, 0xf7, 0x9c, 0x6f, 0x97, 0xd2,
	0x5c, 0x22, 0x0a, 0x1a, 0xf3, 0xc4, 0x61, 0x42, 0xae, 0xe1, 0xf9, 0xd7, 0xfc, 0x70, 0xfd, 0x50,
	0xd6, 0x0a, 0x2d, 0xb2, 0x56, 0x24, 0xdd, 0x75, 0xbe, 0x09, 0xe3, 0xa2, 0xe1, 0x2c, 0x5a, 0xcb,
	0x87, 0x35, 0x7e, 0x4b, 0xf3, 0x35, 0x97, 0xef, 0xa7, 0x49, 0xdc, 0x7f, 0x9f, 0x81, 0x09, 0xf6,
	0xdf, 0xed, 0x58, 0x75, 0x5f, 0xaa, 0xc2, 0x0c, 0x56, 0x23, 0xd8, 0x94, 0x4e, 0x98, 0xf8, 0x9b,
	0x9c, 0x84, 0xf1, 0xb6, 0xd3, 0x40, 0xf2, 0xc5, 0xb2, 0xc5, 0x92, 0x95, 0x06, 0x53, 0x02, 0xb8,
	0x53, 0xae, 0x61, 0x23, 0xa3, 0x1c, 0x17, 0xe6, 0x6c, 0xb3, 0x96, 0x82, 0x62, 0xc4, 0x38, 0x26,
	0x15, 0xa3, 0x41, 0xdb, 0x00, 0x72, 0xaf, 0x6b, 0x75, 0x0e, 0xd6, 0xba, 0xf6, 0x21, 0xed, 0xae,
	0x1e, 0x58, 0xed, 0x27, 0xd4, 0x0d, 0x18, 0xa2, 0x49, 0x0c, 0xb9, 0x0d, 0x23, 0x4f, 0xed, 0x76,
	0x43, 0x68, 0xa9, 0x57, 0x13, 0xfc, 0xc8, 0x11, 0x34, 0x68, 0xdd, 0x62, 0x1d, 0xe3, 0x32, 0xcc,
	0xae, 0x36, 0x7b, 0xae, 0x47, 0xbb, 0x03, 0xf4, 0xf9, 0xcf, 0x6b, 0x30, 0xcd, 0x26, 0xfa, 0x61,
	0x20, 0xba, 0x1b, 0x50, 0x30, 0xe9, 0xc7, 0xd4, 0xf5, 0xee, 0x3f, 0x10, 0xd6, 0xc3, 0xd5, 0xb8,
	0xf5, 0x20, 0xd7, 0x58, 0xf4, 0xc1, 0xf9, 0x34, 0x0f, 0x6a, 0x97, 0xee, 0xc0, 0xb4, 0x52, 0x24,
	0x4f, 0xf4, 0xfc, 0xa0, 0x89, 0xfe, 0x65, 0x98, 0x51, 0x5a, 0x71, 0x89, 0x01, 0x53, 0xe2, 0xf7,
	0xaa, 0xb4, 0x73, 0x54, 0xf2, 0xc8, 0x5a, 0xa4, 0x37, 0xe2, 0x90, 0xe4, 0x5c, 0xff, 0x1e, 0x98,
	0x6a, 0x25, 0xe3, 0xcf, 0x34, 0x98, 0x47, 0x2f, 0xfd, 0xe0, 0x89, 0x7d, 0x1f, 0xc6, 0x36, 0xe5,
	0x5b, 0xcb, 0x6f, 0x26, 0xbb, 0xfb, 0x63, 0x88, 0xd4, 0xab, 0xd6, 0xe2, 0x46, 0x82, 0x7a, 0x95,
	0x38, 0x1f, 0xbd, 0x4a, 0xfc, 0x1c, 0x37, 0xb1, 0xff, 0x46, 0x83, 0x93, 0x31, 0x42, 0x84, 0x60,
	0xec, 0xc3, 0x84, 0x7f, 0x34, 0xe9, 0x5b, 0xa3, 0x6f, 0x0f, 0xee, 0x05, 0xaf, 0xbc, 0x58, 0xf5,
	0x6b, 0xf2, 0x9e, 0x84, 0x98, 0x42, 0x79, 0xcb, 0x49, 0xf2, 0x56, 0xb2, 0x60, 0x46, 0xad, 0x92,
	0xd0, 0x8d, 0x5b, 0x72, 0x37, 0x12, 0xf7, 0xc6, 0x31, 0x3a, 0xe4, 0xbe, 0xfe, 0xfd, 0xd1, 0xe0,
	0x1a, 0xff, 0xb6, 0xd3, 0x88, 0x9b, 0x26, 0x3a, 0xe4, 0xeb, 0x9d, 0x1e, 0x22, 0xd7, 0x4c, 0xf6,
	0x13, 0x7d, 0x0e, 0xb4, 0x55, 0x43, 0xbf, 0x9e, 0x70, 0x98, 0x16, 0x5a, 0xb4, 0x85, 0x37, 0xeb,
	0x99, 0x92, 0x65, 0x85, 0xe8, 0xa3, 0xe4, 0x1e, 0xd3, 0xf1, 0x16, 0x6d, 0xa1, 0x87, 0x52, 0x14,
	0x3d, 0xee, 0x52, 0xea, 0xbb, 0x4c, 0x5b, 0xb4, 0xb5, 0xde, 0xa5, 0x78, 0xc7, 0xd8, 0x3a, 0x7c,
	0x52, 0x6b, 0x3a, 0x16, 0x77, 0x3b, 0xe5, 0xcd, 0x71, 0xeb, 0xf0, 0xc9, 0xa6, 0x63, 0xf1, 0x13,
	0x25, 0x6e, 0x0e, 0x8f, 0xa7, 0x1c, 0x75, 0x44, 0xce, 0x2c, 0xde, 0x83, 0xd1, 0x86, 0xed, 0x3e,
	0xf5, 0xaf, 0xf0, 0x5f, 0x4e, 0xbb, 0xc2, 0xcf, 0x7a, 0xbb, 0xb8, 0xc6, 0x20, 0xf9, 0x60, 0xf0,
	0x5a, 0x64, 0x19, 0x46, 0x3b, 0x8e, 0x13, 0xdc, 0x0f, 0x3e, 0xd3, 0xef, 0x05, 0x80, 0xc9, 0x41,
	0x99, 0xf2, 0x6b, 0x3d, 0x69, 0x79, 0x35, 0xbb, 0xe3, 0xdb, 0xb6, 0x2c, 0x59, 0xe9, 0xb0, 0x82,
	0x86, 0xe5, 0x59, 0xac, 0x60, 0x8a, 0x17, 0xb0, 0x64, 0x05, 0x0f, 0xb2, 0x0e, 0x1c, 0xd7, 0x43,
	0x9d, 0xc8, 0xcf, 0x2e, 0x82, 0x34, 0xd9, 0x82, 0x49, 0x54, 0xa5, 0xe2, 0x06, 0x8f, 0x9e, 0xa2,
	0x55, 0xe4, 0x6e, 0xb0, 0x3f, 0xf2, 0x14, 0x81, 0x76, 0x90, 0x41, 0x16, 0xe1, 0xb8, 0x7f, 0x84,
	0xde, 0xad, 0x21, 0x62, 0x6c, 0x75, 0x0e, 0x5b, 0x9d, 0x0b, 0x8a, 0x18, 0x0a, 0xa6, 0x91, 0x4b,
	0x5f, 0x04, 0x08, 0xb9, 0x92, 0x20, 0x6f, 0x6f, 0xa9, 0xf2, 0x76, 0x21, 0x8d, 0x30, 0x7f, 0xb3,
	0x2b, 0x1f, 0x68, 0xbe, 0x07, 0xb3, 0x11, 0x52, 0x87, 0x9a, 0x97, 0x14, 0x66, 0x04, 0x72, 0xa1,
	0xae, 0x25, 0xe9, 0xd0, 0xb2, 0x49, 0x07, 0x17, 0xef, 0x9c, 0xfc, 0x8e, 0x08, 0xd9, 0x91, 0x0f,
	0x57, 0x3f, 0xa3, 0x05, 0x17, 0xab, 0x8d, 0xa7, 0x3b, 0x1d, 0xda, 0x56, 0x3c, 0xd5, 0xaa, 0x6a,
	0xdb, 0x88, 0xdd, 0x83, 0xd5, 0x52, 0x5c, 0xd5, 0x51, 0x8f, 0x77, 0xe4, 0xaa, 0xac, 0xf1, 0x0a,
	0x18, 0xfd, 0x9a, 0x13, 0xf6, 0xc2, 0xab, 0xb8, 0xb3, 0x8f, 0x41, 0x05, 0x3b, 0x70, 0x5f, 0x1b,
	0xf7, 0x70, 0x7b, 0xde, 0x0f, 0x4e, 0x28, 0xb2, 0x4d, 0xd0, 0x95, 0x0e, 0x84, 0xbb, 0xeb, 0x0c,
	0x5d, 0x98, 0x95, 0xbb, 0xc0, 0xf6, 0xd9, 0xef, 0x24, 0x77, 0x42, 0xbc, 0xc2, 0xf0, 0x99, 0x96,
	0x60, 0x6b, 0x18, 0x0e, 0xbc, 0xdc, 0xb7, 0xa6, 0x20, 0xf7, 0xc5, 0xf1, 0xfb, 0xed, 0xe4, 0xe1,
	0x55, 0x5d, 0x0e, 0x49, 0x94, 0xa6, 0x0c, 0x54, 0xc4, 0xad, 0x90, 0x22, 0x3d, 0xfc, 0x94, 0xe1,
	0x7b, 0x26, 0x3d, 0x7e, 0x73, 0x82, 0xa8, 0x3b, 0xc9, 0x52, 0x51, 0xa5, 0xde, 0x1a, 0x7d, 0x6c,
	0xf5, 0x9a, 0x7d, 0x47, 0xe8, 0x0a, 0xbc, 0x3a, 0xa8, 0xb2, 0x68, 0x26, 0x85, 0x18, 0x93, 0x36,
	0xa9, 0xe5, 0x06, 0x22, 0x7a, 0x29, 0x79, 0xc4, 0x03, 0x28, 0x81, 0xec, 0x75, 0x78, 0x2d, 0x99,
	0xdd, 0xd8, 0xa6, 0x2a, 0x59, 0xc6, 0x21, 0x2c, 0x64, 0x01, 0x7e, 0xe1, 0xc2, 0xd4, 0x82, 0x73,
	0x0c, 0x44, 0x68, 0xd1, 0x24, 0x45, 0x71, 0x1f, 0x66, 0x83, 0x2b, 0x4c, 0x4a, 0x63, 0x89, 0x9e,
	0x70, 0x15, 0x93, 0x39, 0xe3, 0x2a, 0x69, 0xe3, 0x22, 0x9c, 0x4f, 0x6d, 0x2e, 0x90, 0xbf, 0x38,
	0x45, 0xaa, 0xf0, 0x7d, 0xd7, 0x29, 0x8a, 0x08, 0xdf, 0xcb, 0x38, 0x23, 0x54, 0x90, 0x98, 0xde,
	0x6a, 0xa0, 0xe8, 0xa4, 0x02, 0x89, 0x81, 0xfb, 0x1c, 0x14, 0x22, 0xca, 0x2a, 0x0b, 0xcd, 0x41,
	0x1d, 0xe3, 0x66, 0x02, 0xb5, 0x19, 0x74, 0xd4, 0x0f, 0xc1, 0x85, 0xf4, 0x6a, 0x82, 0xb4, 0xdb,
	0xc1, 0x99, 0x65, 0x76, 0x66, 0x8a, 0x1a, 0xc6, 0x8d, 0x84, 0x31, 0x1b, 0xac, 0x8f, 0x92, 0x58,
	0x1f, 0x51, 0x46, 0x9b, 0x09, 0x88, 0xfd, 0xdb, 0x8b, 0x6b, 0x96, 0xdd, 0xc4, 0xe3, 0xd7, 0x03,
	0xa7, 0xd7, 0x15, 0x0f, 0x37, 0xf1, 0x37, 0x99, 0x87, 0xb1, 0x96, 0xdd, 0xee, 0x79, 0x7c, 0x09,
	0x1e, 0x35, 0x45, 0xca, 0xf8, 0x51, 0x2d, 0x91, 0x7d, 0x1c, 0xdd, 0x43, 0x4a, 0x9f, 0x36, 0x8f,
	0xc8, 0x1b, 0x90, 0x6f, 0x58, 0x47, 0x62, 0x39, 0x4e, 0xf4, 0xd3, 0xee, 0xd9, 0x2d, 0xca, 0x80,
	0x1b, 0xd6, 0x91, 0xc9, 0x60, 0x03, 0x12, 0x72, 0x89, 0x24, 0xe4, 0x15, 0x12, 0xbe, 0x94, 0x38,
	0x12, 0xe2, 0x90, 0xdb, 0x69, 0x7b, 0x07, 0x4d, 0x34, 0x29, 0x7c, 0x12, 0x46, 0x87, 0x6f, 0xe1,
	0xbd, 0x04, 0x69, 0xf5, 0x5b, 0xd8, 0xa5, 0x5d, 0xdb, 0x69, 0xd8, 0x75, 0x52, 0x84, 0x71, 0x97,
	0xd6, 0x9d, 0x76, 0xc3, 0x3f, 0x2e, 0xf7, 0x93, 0xc6, 0x7f, 0xcf, 0xc1, 0xa9, 0xd4, 0xfa, 0xdc,
	0x09, 0xea, 0x59, 0x76, 0x5b, 0x54, 0x13, 0x29, 0xb2, 0x01, 0xa3, 0x0d, 0x36, 0x1c, 0xc5, 0x7f,
	0xc1, 0x85, 0x67, 0x69, 0xb0, 0xf0, 0x28, 0xc3, 0xb8, 0x71, 0xcc, 0xe4, 0x08, 0xd8, 0x16, 0xeb,
	0x13, 0x1c, 0x89, 0xe2, 0x1f, 0x73, 0x54, 0xd7, 0xb3, 0xa3, 0xe2, 0x43, 0xb8, 0x71, 0xcc, 0x14,
	0x28, 0xc8, 0x36, 0x8c, 0xb7, 0x38, 0x53, 0x8b, 0x7f, 0xc2, 0xb1, 0xbd, 0x91, 0x1d, 0x9b, 0x18,
	0x8e, 0x8d, 0x63, 0xa6, 0x8f, 0x84, 0xbc, 0x0f, 0x85, 0x8e, 0x60, 0x61, 0xf1, 0x5f, 0x72, 0x84,
	0xcb, 0xd9, 0x11, 0xfa, 0xdc, 0xdf, 0x38, 0x66, 0x06, 0x68, 0xee, 0x4e, 0xc3, 0x24, 0xff, 0x8d,
	0x1e, 0x04, 0xe3, 0x63, 0x3c, 0xca, 0x55, 0xeb, 0x27, 0xba, 0x38, 0x36, 0x60, 0xc2, 0xd7, 0x64,
	0xfe, 0x6e, 0x74, 0x21, 0x3b, 0x29, 0x66, 0x58, 0xd9, 0xf8, 0xa3, 0x3c, 0x9e, 0x2a, 0xae, 0x76,
	0x69, 0x83, 0xb6, 0x3d, 0xdb, 0x6a, 0xaa, 0xfa, 0x3f, 0xa9, 0xf1, 0x79, 0x18, 0x7b, 0xd4, 0xab,
	0x3f, 0xa5, 0x9e, 0xb0, 0x44, 0x45, 0x8a, 0x5c, 0x82, 0x19, 0x71, 0x09, 0xd5, 0x76, 0xda, 0xe8,
	0xb0, 0xe7, 0x76, 0xe9, 0x74, 0x98, 0x7b, 0x9f, 0x46, 0x1e, 0x57, 0x8d, 0x0c, 0xf3, 0xfa, 0xc4,
	0x84, 0x19, 0xeb, 0x13, 0xb7, 0x56, 0x0f, 0x68, 0xf5, 0x05, 0x2e, 0xf9, 0x30, 0xec, 0x13, 0x37,
	0xec, 0x95, 0xe8, 0xcf, 0xc6, 0x31, 0x73, 0xda, 0x92, 0xf3, 0xc9, 0x07, 0xa0, 0x5b, 0x5f, 0xee,
	0x75, 0xa9, 0x8c, 0x55, 0xc8, 0x5e, 0x22, 0x47, 0x57, 0x18, 0x70, 0x12, 0xde, 0x59, 0x4b, 0x2d,
	0x21, 0xdf, 0x0f, 0x73, 0xfc, 0xd8, 0x5c, 0x46, 0xfd, 0x27, 0x7d, 0x4e, 0x06, 0xef, 0x21, 0x74,
	0x12, 0x6e, 0xfd, 0x49, 0xa4, 0xe8, 0xee, 0x1c, 0xcc, 0x86, 0x58, 0xb9, 0xf0, 0xdc, 0x85, 0xd3,
	0x89, 0x03, 0x29, 0x34, 0xfc, 0xcb, 0x30, 0x2d, 0xd5, 0x08, 0x76, 0xc9, 0x53, 0x61, 0x66, 0xa5,
	0x61, 0xfc, 0xa6, 0xc6, 0x4f, 0x9c, 0x12, 0x58, 0x17, 0x39, 0xaa, 0xd1, 0xfa, 0x1f, 0xd5, 0xe4,
	0xa2, 0x47, 0x35, 0x25, 0xbc, 0x55, 0xc0, 0x0f, 0x61, 0xb8, 0x58, 0x04, 0x69, 0xe9, 0x70, 0x65,
	0x44, 0x3e, 0x5c, 0x41, 0x1f, 0xbb, 0xed, 0x5a, 0x8f, 0x9a, 0xb4, 0xe6, 0xba, 0xfc, 0x8d, 0x5b,
	0xc1, 0x04, 0x91, 0x55, 0x75, 0x9b, 0x46, 0x0d, 0xb5, 0x55, 0xf2, 0x90, 0xe0, 0xad, 0x99, 0x3a,
	0x3f, 0x7d, 0x97, 0x44, 0x78, 0x52, 0xe4, 0xa1, 0xff, 0x8e, 0x1f, 0xfb, 0x20, 0x48, 0x48, 0x34,
	0x88, 0xac, 0xfb, 0xf4, 0xc8, 0x78, 0x80, 0x93, 0x23, 0x65, 0x60, 0x58, 0x97, 0x3b, 0x5d, 0xe7,
	0x23, 0x5a, 0xf7, 0x42, 0x7e, 0x4e, 0x88, 0x9c, 0x0a, 0xba, 0x0c, 0x3e, 0x72, 0xc5, 0x4c, 0xe0,
	0xa8, 0xc7, 0x59, 0x9a, 0xe1, 0xfd, 0x29, 0x71, 0xd4, 0xad, 0xf2, 0x59, 0x8c, 0x94, 0xca, 0xe8,
	0x5c, 0x94, 0xd1, 0xdf, 0x15, 0x4e, 0x7e, 0x9e, 0xdf, 0x2d, 0x88, 0x72, 0x52, 0x50, 0x14, 0x65,
	0x65, 0x2e, 0xc6, 0x4a, 0xe3, 0x5d, 0x94, 0xbe, 0x38, 0xa7, 0xc2, 0x3e, 0x49, 0xac, 0xca, 0x45,
	0x58, 0x65, 0x9c, 0x87, 0xb3, 0x8a, 0xec, 0xc6, 0x0c, 0xac, 0x7b, 0x68, 0x0a, 0x24, 0x02, 0x88,
	0x16, 0x2e, 0xc1, 0x8c, 0x22, 0xdf, 0xfe, 0x15, 0xf6, 0x69, 0x59, 0xc0, 0xdd, 0xd8, 0x2c, 0x89,
	0xd8, 0x4f, 0x99, 0x66, 0xc9, 0x9f, 0xe4, 0xe1, 0x4c, 0x32, 0x92, 0x21, 0xe6, 0x5a, 0xa0, 0x5a,
	0x73, 0x89, 0xaa, 0x35, 0xaf, 0xa8, 0xd6, 0x67, 0xd7, 0x99, 0xd5, 0x34, 0x9d, 0xf9, 0x5a, 0x06,
	0x9d, 0xc9, 0xbb, 0x13, 0x57, 0x9a, 0x1f, 0xa6, 0x2b, 0xcd, 0xd7, 0x33, 0x29, 0xcd, 0x00, 0x71,
	0x4c, 0x6b, 0xfe, 0x40, 0x1f, 0xad, 0x79, 0x35, 0x9b, 0xd6, 0x0c, 0x90, 0x67, 0x52, 0x9b, 0x2b,
	0x91, 0xf5, 0x4f, 0xb5, 0x5c, 0x33, 0xc9, 0xc3, 0xd9, 0x88, 0x4c, 0x45, 0xcc, 0xd8, 0xd5, 0x88,
	0xb4, 0x3c, 0xb0, 0x9a, 0xb6, 0xbc, 0xa3, 0xc9, 0xd4, 0x46, 0x74, 0x86, 0x84, 0x48, 0x44, 0x2b,
	0x3f, 0x82, 0x17, 0x10, 0xc4, 0x71, 0x26, 0x1e, 0x7e, 0xfa, 0xd1, 0x23, 0xce, 0xc3, 0xa4, 0xd0,
	0xcc, 0x92, 0x1e, 0x14, 0xca, 0xda, 0x3f, 0xc6, 0xe8, 0xa7, 0xba, 0x2f, 0xc1, 0x8c, 0x28, 0xae,
	0x3b, 0x6d, 0x8f, 0x7e, 0xea, 0x0b, 0xe7, 0x34, 0xcf, 0x5d, 0xe5, 0x99, 0xc6, 0xef, 0xe5, 0xe0,
	0xa5, 0x80, 0x82, 0x2d, 0xa6, 0x18, 0xfc, 0x0e, 0xf6, 0x3d, 0x1f, 0x52, 0xcf, 0x59, 0x73, 0xd1,
	0x73, 0xd6, 0x95, 0xf0, 0x28, 0x92, 0x1f, 0x15, 0x5d, 0x4e, 0x12, 0x82, 0x84, 0x6e, 0x07, 0x67,
	0x90, 0xe4, 0x4b, 0x30, 0xd3, 0xc0, 0xa3, 0x93, 0x9a, 0x7a, 0xa8, 0x79, 0x2b, 0x1d, 0x93, 0x4c,
	0xfe, 0x22, 0x3f, 0x77, 0x51, 0xce, 0x37, 0xa7, 0x1b, 0x72, 0x5e, 0xe9, 0x0b, 0x40, 0xe2, 0x40,
	0x43, 0x39, 0x07, 0x8b, 0xd2, 0xe8, 0x89, 0xc6, 0xc5, 0xb8, 0xfe, 0x0c, 0x5f, 0x92, 0x79, 0xd1,
	0x7e, 0x1b, 0x39, 0xe3, 0x8f, 0xec, 0x02, 0xcc, 0x35, 0x50, 0xd6, 0x6a, 0x12, 0x0b, 0x79, 0x9c,
	0x8d, 0x59, 0x5e, 0xb0, 0x15, 0x30, 0xf2, 0x3e, 0xbc, 0xdc, 0x76, 0x6a, 0x0d, 0xda, 0xb4, 0x8e,
	0x6a, 0x8f, 0xe8, 0x63, 0x07, 0xef, 0x96, 0x37, 0xa9, 0x67, 0xb7, 0x9f, 0xd4, 0x22, 0x03, 0x50,
	0x30, 0xcf, 0xb5, 0x9d, 0x35, 0x06, 0x79, 0x17, 0x01, 0xd7, 0x04, 0x5c, 0x80, 0xcc, 0xf8, 0xc3,
	0x5c, 0x9c, 0xa8, 0x17, 0x31, 0xda, 0x77, 0xa3, 0xa3, 0x7d, 0x25, 0x7d, 0x8c, 0x54, 0x5e, 0x84,
	0xc3, 0xfd, 0x28, 0x65, 0xb8, 0xef, 0x0c, 0x44, 0xf5, 0xbd, 0x1c, 0xf0, 0x12, 0x1a, 0x00, 0x91,
	0xe6, 0xc5, 0x90, 0xff, 0x72, 0x2e, 0x36, 0x97, 0x33, 0x31, 0x57, 0x9a, 0x2b, 0xb9, 0x67, 0x9c,
	0x2b, 0x56, 0x8c, 0x79, 0x79, 0x64, 0xde, 0xed, 0x41, 0x98, 0xbe, 0x97, 0xbc, 0xbb, 0x2d, 0x09,
	0x9f, 0xdf, 0xba, 0x58, 0x79, 0x23, 0xd7, 0x32, 0xb4, 0xd8, 0xb5, 0x8c, 0x47, 0x12, 0x6b, 0xd7,
	0xa8, 0xac, 0x26, 0x83, 0xbb, 0xd7, 0x9a, 0x7c, 0xf7, 0x7a, 0x19, 0x5e, 0xea, 0xf1, 0xe1, 0x09,
	0x67, 0x0d, 0xde, 0x45, 0xe1, 0x13, 0xe5, 0xb8, 0x28, 0xf4, 0x27, 0x0a, 0x2b, 0x52, 0xc7, 0x8f,
	0xe7, 0xbd, 0xf0, 0xf1, 0x53, 0x68, 0x7f, 0xae, 0xf1, 0x53, 0x08, 0xfc, 0x9e, 0x8c, 0xdf, 0x29,
	0x69, 0xfc, 0xfc, 0xd6, 0x85, 0xe8, 0xff, 0x7b, 0x4d, 0x62, 0xdd, 0xe0, 0xad, 0xe8, 0xd0, 0xb7,
	0x62, 0xee, 0x07, 0x31, 0xb2, 0xf2, 0x29, 0x67, 0xb8, 0xc9, 0xad, 0xbf, 0xe8, 0x70, 0x59, 0x6f,
	0x49, 0x2c, 0x88, 0x6c, 0xd4, 0xfa, 0x89, 0x88, 0xb1, 0x21, 0xad, 0xb1, 0xab, 0x4d, 0xa7, 0xdd,
	0x97, 0x3b, 0xa7, 0x61, 0x82, 0x87, 0x82, 0x92, 0xee, 0xf0, 0xf1, 0x8c, 0x4a, 0xc3, 0xb8, 0x29,
	0x33, 0x9a, 0x63, 0xca, 0x42, 0xc0, 0x4d, 0x45, 0xb4, 0x65, 0x53, 0xa9, 0x6f, 0x35, 0x75, 0xc8,
	0x15, 0xf3, 0xe8, 0x13, 0xa9, 0x28, 0x62, 0x8d, 0xf7, 0x9d, 0x2d, 0x9f, 0x8f, 0xce, 0x96, 0xb4,
	0x1b, 0x2d, 0x6a, 0x30, 0xad, 0x60, 0xae, 0x18, 0x7f, 0xa3, 0x49, 0x3a, 0x38, 0x6a, 0xc2, 0x0f,
	0x7d, 0xcd, 0x28, 0xc9, 0x9c, 0xdf, 0x8a, 0x48, 0xdb, 0xcd, 0x74, 0x69, 0x8b, 0xb4, 0xff, 0xa2,
	0xe5, 0xed, 0xbf, 0xe6, 0xd0, 0x43, 0xad, 0xb4, 0x95, 0x70, 0xb3, 0x36, 0xa9, 0x13, 0x0f, 0x23,
	0x9d, 0xf8, 0xfc, 0xc0, 0x4e, 0xc4, 0x11, 0x27, 0x75, 0xe7, 0x39, 0x36, 0x35, 0xc1, 0xbb, 0xcb,
	0xd1, 0x2c, 0xef, 0x2e, 0x25, 0x41, 0x19, 0x7b, 0x16, 0x41, 0x79, 0x1e, 0xbe, 0x7f, 0x84, 0xa7,
	0x45, 0xe9, 0xdc, 0x11, 0xd2, 0xb6, 0x0a, 0xe3, 0x5c, 0x8c, 0xfc, 0x83, 0x81, 0xd7, 0x32, 0x4b,
	0x8a, 0xe9, 0xd7, 0x34, 0xfe, 0x8b, 0xac, 0x3b, 0xd5, 0x43, 0x93, 0xbe, 0x13, 0x69, 0x08, 0x9d,
	0xa8, 0x60, 0x4d, 0x1c, 0xd4, 0x9b, 0x42, 0x23, 0x8f, 0x0c, 0x7c, 0xfa, 0x24, 0x70, 0x21, 0xf8,
	0xf3, 0xb0, 0x58, 0x56, 0x2d, 0x91, 0xb3, 0x9b, 0xef, 0x97, 0xb4, 0x25, 0xbe, 0xaf, 0xcb, 0xc4,
	0x8f, 0x4b, 0x30, 0xd3, 0x76, 0xbc, 0x5a, 0xbd, 0xd7, 0xea, 0x35, 0x2d, 0xcf, 0x3e, 0xa4, 0x62,
	0xad, 0x9f, 0x6e, 0x3b, 0xde, 0x6a, 0x90, 0x69, 0xac, 0x4b, 0xdc, 0x16, 0xc8, 0xc5, 0x68, 0x5e,
	0xe5, 0x0f, 0x4f, 0x5d, 0xa1, 0x3a, 0xe6, 0x13, 0x8f, 0xf5, 0x5d, 0xfe, 0xe4, 0xd4, 0x35, 0xde,
	0xc5, 0x9d, 0x9d, 0x50, 0xc4, 0xf2, 0x13, 0xb7, 0x4c, 0x8a, 0xd5, 0x43, 0xc7, 0x48, 0x62, 0x6d,
	0x41, 0x8d, 0x09, 0xc7, 0xeb, 0xa2, 0xa0, 0x86, 0x2f, 0x77, 0xf9, 0x23, 0xd0, 0xb4, 0x73, 0x9e,
	0xd8, 0x2b, 0x3b, 0x73, 0xae, 0x1e, 0xcd, 0x32, 0x4e, 0xa3, 0xe3, 0x8d, 0xb7, 0x1a, 0xf3, 0xd5,
	0xdc, 0xc1, 0x1d, 0x75, 0xac, 0x30, 0xf4, 0x04, 0x49, 0x17, 0x9f, 0xb4, 0xc8, 0xc5, 0x27, 0xe3,
	0x9f, 0xe6, 0xf0, 0xaa, 0x40, 0xa4, 0x76, 0x46, 0x55, 0xf5, 0x61, 0x44, 0x92, 0x57, 0xd2, 0x25,
	0xb9, 0x0f, 0xea, 0xff, 0x9d, 0xca, 0xea, 0x79, 0x26, 0xc2, 0x3a, 0x1e, 0x93, 0xf7, 0xeb, 0x5e,
	0xb6, 0x21, 0xf8, 0x4b, 0x4d, 0x92, 0x29, 0xff, 0x06, 0x97, 0x6a, 0x8b, 0x0d, 0xba, 0xf1, 0x19,
	0x1b, 0x99, 0x6a, 0x64, 0x64, 0xfa, 0x6c, 0xc6, 0x12, 0x5b, 0x7c, 0xd1, 0xeb, 0xe1, 0x5d, 0x3c,
	0x0b, 0x4c, 0x6e, 0x30, 0xdc, 0x4a, 0x84, 0xf1, 0x3f, 0x1a, 0x81, 0xdb, 0xc4, 0x8f, 0xa2, 0xd2,
	0x30, 0x6a, 0x09, 0x38, 0x4c, 0x8a, 0xcf, 0x2a, 0x32, 0xf1, 0x29, 0xd2, 0x40, 0x2e, 0xd6, 0x80,
	0x81, 0xc7, 0x85, 0x29, 0x0d, 0x08, 0x15, 0xf7, 0x05, 0x3c, 0xf0, 0x53, 0x61, 0xa2, 0x33, 0xb2,
	0xbf, 0x06, 0xd9, 0x93, 0x2c, 0x83, 0x04, 0x0c, 0xc1, 0x7b, 0x98, 0xe3, 0x02, 0x85, 0x44, 0xb3,
	0x2f, 0x3c, 0x73, 0x87, 0x4a, 0x6d, 0x26, 0x44, 0x7f, 0xa3, 0xc1, 0xd5, 0x74, 0xb4, 0x09, 0xf3,
	0xb9, 0x2f, 0xab, 0xac, 0x40, 0x7c, 0xf8, 0x61, 0x57, 0x65, 0xb0, 0xf8, 0x0c, 0x39, 0xc1, 0x9f,
	0x47, 0x98, 0x6a, 0x70, 0x2d, 0x63, 0xf3, 0xcf, 0xc8, 0xcc, 0xcf, 0xf0, 0x0e, 0x8b, 0xda, 0x80,
	0x7f, 0xb4, 0x37, 0xc4, 0x42, 0xff, 0x16, 0x9c, 0x8c, 0x07, 0xa6, 0xc1, 0x9b, 0xd1, 0xc8, 0xd6,
	0x09, 0xf3, 0xa5, 0x68, 0x3c, 0xaa, 0x6d, 0x56, 0x68, 0xbc, 0x06, 0x97, 0x07, 0x36, 0xaf, 0xdc,
	0x96, 0x10, 0x17, 0xdc, 0xd6, 0x9c, 0x96, 0x65, 0xb7, 0xdd, 0xd8, 0x02, 0xf1, 0x00, 0x25, 0x2e,
	0x15, 0x48, 0x30, 0xe9, 0x3a, 0x9c, 0xa8, 0x73, 0x90, 0x5a, 0x03, 0x61, 0x04, 0xa9, 0x9c, 0x4b,
	0xa4, 0x2e, 0x57, 0xe7, 0x74, 0xee, 0xf2, 0x43, 0x02, 0xb9, 0x20, 0xb2, 0xa1, 0x58, 0x84, 0xe3,
	0x09, 0x38, 0x05, 0xa3, 0xe6, 0x62, 0x28, 0x8d, 0x36, 0x4e, 0xf1, 0x64, 0x8c, 0xe1, 0x58, 0x0e,
	0x83, 0x92, 0x8d, 0x90, 0xed, 0xd6, 0xac, 0xba, 0x64, 0x58, 0x14, 0x6c, 0x97, 0x5f, 0x4a, 0x36,
	0xde, 0x8f, 0xb7, 0x87, 0x25, 0xd2, 0x08, 0x0f, 0xdb, 0x05, 0xae, 0x44, 0x52, 0x50, 0x8a, 0x51,
	0xab, 0xc6, 0x47, 0x6d, 0x8d, 0x5a, 0xcf, 0xd9, 0xf0, 0x2b, 0xf1, 0x51, 0x96, 0x91, 0x8a, 0xa6,
	0x2f, 0xca, 0x3d, 0x16, 0xbc, 0x5d, 0xe5, 0xaf, 0xb3, 0x7c, 0x71, 0xf9, 0x41, 0xb9, 0x07, 0x51,
	0x10, 0x31, 0x0a, 0xb7, 0x60, 0x5c, 0x50, 0x20, 0x0c, 0x9b, 0xf3, 0x69, 0x37, 0x3b, 0xfd, 0xbb,
	0xf2, 0x3e, 0xbc, 0x71, 0x1d, 0x8d, 0xc4, 0x6d, 0xa7, 0x11, 0xdd, 0x7d, 0x4a, 0xaf, 0x02, 0x34,
	0xf9, 0x55, 0x80, 0xf1, 0x7d, 0x68, 0xf9, 0x29, 0x35, 0x02, 0x99, 0x1d, 0x61, 0x30, 0x82, 0x86,
	0x33, 0xfd, 0xae, 0xbd, 0x9a, 0x08, 0x69, 0x9c, 0xc3, 0xc3, 0x01, 0x09, 0x57, 0xa4, 0xf3, 0xef,
	0xa3, 0x75, 0x98, 0x54, 0xfe, 0xcc, 0x4d, 0x72, 0x83, 0x99, 0x65, 0xc4, 0x66, 0xe6, 0x4d, 0xdc,
	0x11, 0x47, 0x8a, 0x44, 0x43, 0xf8, 0x02, 0xa5, 0x21, 0xdb, 0x0c, 0xe3, 0x9c, 0x1f, 0xae, 0x51,
	0xc6, 0x4e, 0x28, 0xcf, 0x0a, 0x15, 0x4e, 0x5e, 0x82, 0x19, 0x27, 0x2c, 0x0c, 0x19, 0x3a, 0x2d,
	0xe5, 0x56, 0x1a, 0x46, 0x07, 0xfb, 0x9a, 0x84, 0x46, 0x90, 0xb0, 0x03, 0x44, 0xc6, 0x23, 0x5d,
	0x9e, 0x4d, 0xba, 0xca, 0x1b, 0x79, 0xe6, 0x68, 0xce, 0x49, 0x75, 0xf9, 0xc5, 0x5a, 0xe3, 0x36,
	0x9e, 0xdc, 0x48, 0x80, 0xd9, 0xcd, 0x1c, 0xc3, 0x89, 0x76, 0x3a, 0x62, 0x3f, 0xbc, 0x70, 0x62,
	0xd7, 0xa2, 0xc4, 0xaa, 0xfe, 0x97, 0x8c, 0x4c, 0x3e, 0x17, 0x25, 0x3b, 0xe2, 0x8e, 0xf9, 0x81,
	0x68, 0x2b, 0xea, 0x02, 0x93, 0xad, 0x15, 0x32, 0x0f, 0x63, 0xfc, 0x49, 0xa8, 0x50, 0x71, 0x22,
	0x15, 0x6f, 0x3d, 0xb2, 0x7e, 0x7c, 0x2b, 0xc7, 0xcf, 0xd2, 0x9a, 0x4e, 0xaf, 0x71, 0xd7, 0xaa,
	0x3f, 0xed, 0x75, 0x86, 0x30, 0x3c, 0x63, 0x07, 0x69, 0xb9, 0xe4, 0x63, 0xd7, 0xc7, 0xbd, 0x66,
	0x53, 0x3c, 0xb0, 0xc2, 0xdf, 0x6c, 0xa6, 0x7b, 0x96, 0xfb, 0x54, 0x7a, 0xff, 0xc3, 0x92, 0x95,
	0x06, 0xd9, 0x0d, 0xec, 0x8e, 0x51, 0xb4, 0x3b, 0xde, 0x49, 0xb2, 0x3b, 0xd2, 0x88, 0x7d, 0xd1,
	0x66, 0xc6, 0xdb, 0xfc, 0x1c, 0x31, 0xde, 0x9a, 0x10, 0x38, 0xa9, 0x17, 0x9a, 0xdc, 0x0b, 0xe3,
	0x3b, 0x5a, 0xb4, 0x66, 0xdc, 0x4c, 0x7d, 0x84, 0xf9, 0x12, 0x57, 0x79, 0x46, 0xa5, 0xc1, 0xf4,
	0x7e, 0x97, 0x83, 0xd7, 0x04, 0xeb, 0x25, 0xeb, 0x7e, 0x4e, 0x14, 0x71, 0xe3, 0x00, 0x17, 0xb8,
	0xd8, 0x28, 0xe4, 0x13, 0x46, 0x21, 0xf5, 0xc5, 0x95, 0xd4, 0x89, 0x51, 0xa5, 0x13, 0x0d, 0x7e,
	0x00, 0x9a, 0xd0, 0x07, 0xd1, 0xfd, 0x05, 0x98, 0x8b, 0xd0, 0x19, 0x74, 0x66, 0x56, 0xa1, 0x52,
	0x6d, 0x25, 0xa7, 0xb4, 0xd2, 0x8b, 0x8a, 0x5f, 0xcc, 0xc7, 0x99, 0xce, 0xa8, 0x4c, 0xe2, 0x97,
	0x18, 0xe1, 0x45, 0x4c, 0x8b, 0x84, 0x66, 0xc5, 0xb4, 0xb0, 0x85, 0x65, 0x13, 0x29, 0x5f, 0x69,
	0x06, 0x77, 0x51, 0x0c, 0x98, 0x76, 0xbb, 0xf5, 0x58, 0xcf, 0x27, 0xdd, 0x6e, 0xfd, 0xc1, 0x30,
	0xf3, 0x23, 0x58, 0x90, 0x93, 0x9a, 0x12, 0xd4, 0xfc, 0xaa, 0x86, 0x97, 0x9b, 0x25, 0x98, 0x7e,
	0x86, 0x7d, 0x16, 0xca, 0xce, 0x02, 0xf8, 0xb6, 0x45, 0x78, 0x3d, 0x44, 0xe4, 0x24, 0x11, 0x9e,
	0x24, 0x52, 0x3a, 0xe4, 0xad, 0x66, 0x53, 0x3c, 0x8e, 0x64, 0x3f, 0x8d, 0xff, 0x96, 0xc3, 0x98,
	0x24, 0x12, 0x9d, 0xf8, 0x5c, 0x31, 0xfa, 0x48, 0x28, 0x46, 0x60, 0x2e, 0x4e, 0xe0, 0xab, 0x30,
	0x2b, 0xc1, 0x48, 0x8f, 0x2e, 0xa6, 0x03, 0x28, 0x14, 0x7e, 0x25, 0x7e, 0xcd, 0xc8, 0x30, 0xf1,
	0x6b, 0xb6, 0xa4, 0x6f, 0x98, 0x70, 0x65, 0xf3, 0xc6, 0x00, 0x65, 0xc3, 0x3a, 0xb3, 0xb8, 0x25,
	0xea, 0x88, 0x07, 0x79, 0xc1, 0x67, 0x4f, 0x56, 0x82, 0xb7, 0x25, 0x3c, 0x04, 0xf8, 0x6b, 0x03,
	0x90, 0xf1, 0x35, 0x86, 0x87, 0x5d, 0xe3, 0x15, 0x4b, 0x77, 0x60, 0x5a, 0xc1, 0x3e, 0x94, 0xb2,
	0x7a, 0x8a, 0x57, 0xda, 0x07, 0x8a, 0x88, 0x98, 0xbb, 0xef, 0xc1, 0x38, 0x9f, 0x46, 0xbe, 0xff,
	0xf3, 0xe5, 0x0c, 0x7d, 0x37, 0xfd, 0x3a, 0xc6, 0xaf, 0x8e, 0xc0, 0x89, 0xa4, 0xee, 0xf4, 0x9f,
	0xaf, 0xef, 0xc1, 0x98, 0xd3, 0x09, 0x42, 0x81, 0x24, 0x45, 0x1e, 0x54, 0x71, 0xee, 0x74, 0x38,
	0x7b, 0x78, 0x25, 0x89, 0xc3, 0xf9, 0x67, 0xe4, 0x70, 0x18, 0x15, 0xab, 0xe1, 0x88, 0xef, 0xf7,
	0xf8, 0x51, 0xb1, 0xd6, 0x9c, 0x36, 0x8d, 0x04, 0xf1, 0x19, 0x1d, 0x26, 0x88, 0xcf, 0x0a, 0xcc,
	0xd4, 0x9d, 0x56, 0x87, 0xcd, 0x5c, 0x11, 0xca, 0x67, 0x70, 0x78, 0xc0, 0xe9, 0xa0, 0x06, 0xa2,
	0x90, 0x54, 0xf4, 0xb8, 0xa2, 0xa2, 0x63, 0xf3, 0xa5, 0x10, 0x9f, 0x2f, 0x04, 0x46, 0xd0, 0xcb,
	0x38, 0x81, 0x86, 0x22, 0xfe, 0x8e, 0xcf, 0x62, 0x48, 0x98, 0xc5, 0xe7, 0x61, 0x92, 0xb3, 0x84,
	0xbf, 0xd0, 0x9b, 0xe4, 0x91, 0xc0, 0x30, 0x8b, 0xbf, 0xd1, 0x3b, 0x0f, 0x93, 0xd4, 0xb3, 0x6a,
	0xfe, 0x05, 0xe6, 0x29, 0x1e, 0xaa, 0x81, 0x7a, 0x56, 0x95, 0xe7, 0x30, 0x3b, 0x95, 0x87, 0x52,
	0xb5, 0x1b, 0x22, 0x7e, 0xdf, 0x38, 0xa6, 0x2b, 0x0d, 0xc3, 0x8e, 0x6a, 0x77, 0xf1, 0xbe, 0x2a,
	0x8b, 0x71, 0x71, 0x02, 0x46, 0x9b, 0x4e, 0xdd, 0x6a, 0x0a, 0x83, 0x86, 0x27, 0xe4, 0x85, 0x24,
	0xaf, 0x2c, 0x24, 0xff, 0x36, 0xb6, 0xe6, 0xfa, 0x6d, 0x09, 0x91, 0x7f, 0x08, 0x05, 0x2e, 0x05,
	0x81, 0xcf, 0xff, 0x4e, 0x26, 0x01, 0x0a, 0x9f, 0x63, 0x8a, 0xda, 0x62, 0xe6, 0xfb, 0xc8, 0x4a,
	0x8f, 0x60, 0x5a, 0x29, 0x1a, 0x14, 0x72, 0x73, 0x72, 0xa0, 0xe0, 0x8b, 0x86, 0xa5, 0xd9, 0xfd,
	0xa5, 0x98, 0x29, 0x62, 0x79, 0x56, 0xd3, 0x79, 0xf2, 0xc2, 0xd6, 0x49, 0xe3, 0x4e, 0x74, 0xb9,
	0x0f, 0x5a, 0x10, 0xfc, 0x2b, 0x41, 0x01, 0xaf, 0x23, 0xb5, 0x3d, 0x7f, 0x3b, 0x12, 0xa4, 0x8d,
	0xdf, 0xd7, 0xd0, 0x3f, 0x2d, 0xd5, 0xde, 0xb0, 0x59, 0xf7, 0x8e, 0x2a, 0x1e, 0x6d, 0x65, 0x5a,
	0x90, 0x14, 0x3d, 0x9e, 0x1b, 0x46, 0x8f, 0x3f, 0xbf, 0x5a, 0x30, 0xee, 0x46, 0xb9, 0x2b, 0xa8,
	0x1f, 0x62, 0x45, 0x35, 0xda, 0x51, 0xfe, 0x05, 0x38, 0x04, 0xff, 0xb6, 0x60, 0xea, 0x80, 0x67,
	0xd5, 0x9a, 0xb6, 0xeb, 0x47, 0x8f, 0x59, 0x18, 0x40, 0xad, 0xc4, 0x47, 0x73, 0x52, 0xd4, 0xdf,
	0xb4, 0x5d, 0xcf, 0xf8, 0x59, 0x4d, 0xec, 0xd2, 0x95, 0x8e, 0x51, 0xfe, 0x5a, 0x5d, 0xda, 0x51,
	0x27, 0x5a, 0xa8, 0xe4, 0x01, 0xcc, 0x76, 0x39, 0x4c, 0x10, 0x56, 0x93, 0xeb, 0xe4, 0x6b, 0x03,
	0xe8, 0x31, 0xfd, 0x5a, 0x3c, 0xce, 0xe6, 0x4c, 0x57, 0x49, 0x07, 0xee, 0xa8, 0x64, 0xa2, 0x84,
	0x39, 0xf3, 0x57, 0x1a, 0xbf, 0x02, 0x28, 0x41, 0x09, 0xe7, 0x16, 0x9a, 0x0b, 0x2f, 0xca, 0xb2,
	0x52, 0x2f, 0xed, 0xe7, 0x9f, 0xe3, 0xd2, 0x3e, 0xd3, 0x81, 0x2d, 0xeb, 0xd3, 0x9a, 0xbf, 0x64,
	0xf2, 0x85, 0x03, 0x5a, 0xd6, 0xa7, 0x9c, 0x7c, 0x37, 0xd8, 0xe4, 0x8c, 0x86, 0x9b, 0x1c, 0xe3,
	0x28, 0x36, 0x40, 0x0c, 0x9f, 0xba, 0xbd, 0xda, 0x07, 0xbd, 0xce, 0x00, 0xb8, 0x7b, 0x50, 0x3e,
	0x28, 0x7a, 0x7d, 0x90, 0x18, 0x4b, 0x2c, 0x33, 0x67, 0x10, 0x09, 0x66, 0xe1, 0x71, 0xd1, 0xfb,
	0xb1, 0x61, 0x90, 0x9b, 0x0e, 0x4e, 0xcd, 0x88, 0xd0, 0x19, 0x81, 0x6f, 0x32, 0x60, 0xb6, 0xfe,
	0x48, 0x6d, 0xa4, 0x61, 0xec, 0x26, 0xf6, 0x46, 0xb5, 0xd6, 0x87, 0xc3, 0xf8, 0x72, 0x22, 0x91,
	0x11, 0x43, 0x9c, 0xbf, 0xfe, 0x8b, 0x02, 0xc5, 0xfc, 0x28, 0x3f, 0xc9, 0x4f, 0xb1, 0xfa, 0xc0,
	0x89, 0x4e, 0xbb, 0x2a, 0xc3, 0xa5, 0x99, 0x58, 0xc9, 0xc2, 0xf0, 0x18, 0xc2, 0xc5, 0xd5, 0x80,
	0xf3, 0x6c, 0x5a, 0xf2, 0xb5, 0x41, 0x1a, 0x0e, 0x96, 0x59, 0x6a, 0xc3, 0xf1, 0x04, 0xb0, 0x84,
	0x75, 0x62, 0x45, 0x5d, 0x27, 0x86, 0x92, 0x01, 0x69, 0xb5, 0xb8, 0x05, 0xe3, 0xd5, 0xc6, 0x53,
	0xb3, 0xd7, 0x44, 0xad, 0xed, 0xd2, 0xee, 0xa1, 0x5d, 0x0f, 0x1c, 0xb9, 0x41, 0x9a, 0x09, 0xad,
	0xd5, 0xb1, 0x7d, 0x5f, 0x34, 0xfe, 0x36, 0xb6, 0x78, 0x55, 0xa7, 0x49, 0x13, 0x6f, 0xb8, 0x2c,
	0xc2, 0x68, 0x57, 0x7a, 0x03, 0x53, 0x4c, 0x22, 0x90, 0xb5, 0x6b, 0x72, 0x30, 0x63, 0x0d, 0xed,
	0x44, 0x86, 0x4e, 0x95, 0xfb, 0xab, 0x30, 0xd2, 0x75, 0x9a, 0xbe, 0x13, 0x2d, 0x19, 0x8d, 0xd3,
	0xa4, 0x26, 0x42, 0x19, 0x65, 0xf4, 0x18, 0xca, 0x58, 0x02, 0x11, 0x1e, 0x06, 0x0d, 0xf7, 0xc3,
	0xb1, 0x8c, 0x98, 0xfc, 0x5c, 0x47, 0x3f, 0x5c, 0xa4, 0x28, 0x0c, 0xee, 0x21, 0x3b, 0xc2, 0x79,
	0xc2, 0x78, 0x3d, 0xa0, 0x29, 0xc3, 0x8b, 0x40, 0x7e, 0x74, 0xad, 0x00, 0x3f, 0x53, 0x0f, 0x16,
	0x02, 0x76, 0x0e, 0x7e, 0xef, 0x77, 0x32, 0x20, 0x30, 0x32, 0xa5, 0xc2, 0x31, 0x51, 0x3d, 0x4d,
	0xcf, 0x3a, 0x26, 0xaa, 0x47, 0x69, 0x48, 0x34, 0x17, 0x70, 0xa3, 0x5d, 0x41, 0xa5, 0xed, 0x1d,
	0xad, 0x5a, 0x1d, 0xeb, 0x91, 0xdd, 0xb4, 0x3d, 0x9b, 0xfa, 0x46, 0xa2, 0xd1, 0xc4, 0xfd, 0x71,
	0x32, 0x84, 0x68, 0xb2, 0x02, 0x53, 0x75, 0x29, 0x5f, 0x4c, 0xe8, 0x44, 0x2b, 0xab, 0xca, 0x85,
	0x3f, 0x40, 0x73, 0x64, 0x2a, 0x55, 0xc5, 0x41, 0xbb, 0xdf, 0xda, 0x03, 0xda, 0x75, 0x6d, 0xa7,
	0xed, 0x93, 0xf2, 0x4d, 0xbe, 0x70, 0xc5, 0x4a, 0x05, 0x19, 0xef, 0xc2, 0xa4, 0xdb, 0x78, 0x5a,
	0x3b, 0xe4, 0xd9, 0x82, 0x01, 0xa7, 0x13, 0x4f, 0xce, 0x44, 0x4d, 0x70, 0x83, 0xdf, 0xe4, 0x16,
	0x8c, 0xfb, 0x35, 0x73, 0xfd, 0x3d, 0xea, 0x7e, 0x6d, 0x1f, 0xde, 0xf8, 0x83, 0x3c, 0x0e, 0x69,
	0xac, 0x6f, 0x64, 0x0f, 0xc6, 0xc5, 0x6c, 0x17, 0xd4, 0xbc, 0x93, 0x89, 0x27, 0x8b, 0xd2, 0xcb,
	0x68, 0x51, 0xb8, 0x71, 0xcc, 0xf4, 0x51, 0x95, 0xfe, 0x28, 0x07, 0x24, 0x0e, 0x41, 0xde, 0x17,
	0x81, 0x7e, 0xf8, 0x63, 0xce, 0xf7, 0x9e, 0xb5, 0xa5, 0x45, 0x1e, 0x6a, 0x07, 0xdf, 0x0a, 0xfc,
	0x85, 0x06, 0x23, 0x18, 0x2a, 0x72, 0x12, 0xc6, 0xf7, 0xb7, 0xef, 0x6f, 0xef, 0x3c, 0xdc, 0xe6,
	0x5f, 0xa2, 0x58, 0xdd, 0xdc, 0xaf, 0xee, 0x95, 0x4d, 0x5d, 0x23, 0x3a, 0x4c, 0xad, 0x6e, 0xee,
	0xec, 0xaf, 0xd5, 0xee, 0xae, 0xac, 0xde, 0xdf, 0xdf, 0xd5, 0x73, 0x64, 0x16, 0x26, 0x57, 0xcd,
	0xf2, 0x5a, 0x79, 0x7b, 0xaf, 0xb2, 0xb2, 0x59, 0xd5, 0xf3, 0xa4, 0x00, 0x23, 0xdb, 0x3b, 0x6b,
	0x65, 0x7d, 0x84, 0x10, 0x98, 0xd9, 0xb9, 0xfb, 0x7d, 0xe5, 0xd5, 0xbd, 0x5a, 0x75, 0x6f, 0xc7,
	0x5c, 0xb9, 0x57, 0xd6, 0x47, 0xc9, 0x71, 0x98, 0xad, 0xae, 0x6e, 0x94, 0xd7, 0xf6, 0x37, 0xcb,
	0xb5, 0xdd, 0x9d, 0xcd, 0xca, 0xea, 0x87, 0xfa, 0x18, 0x01, 0x18, 0x7b, 0xb0, 0xb3, 0xb9, 0xbf,
	0x55, 0xd6, 0xc7, 0xd9, 0xef, 0x95, 0xcd, 0xb2, 0xb9, 0x57, 0xd5, 0x0b, 0xac, 0xb5, 0xad, 0x9d,
	0xfd, 0xed, 0xbd, 0xda, 0xca, 0xde, 0xde, 0xca, 0xea, 0x86, 0x3e, 0x81, 0xe1, 0xef, 0x77, 0x36,
	0xcb, 0x3a, 0x70, 0x4a, 0x90, 0xac, 0xda, 0xee, 0x4a, 0xc5, 0xd4, 0x27, 0xf1, 0x2b, 0x19, 0x95,
	0x7b, 0xe6, 0xca, 0x5e, 0x59, 0x9f, 0x62, 0x6d, 0x8b, 0x46, 0xfd, 0x66, 0xa6, 0xef, 0x8e, 0x71,
	0x96, 0x19, 0xbf, 0xa3, 0x01, 0x84, 0x62, 0xc1, 0x34, 0x4e, 0xcb, 0xfa, 0xc8, 0xf1, 0x9f, 0xd9,
	0xf2, 0x04, 0xe6, 0xda, 0x6d, 0xc7, 0x7f, 0x97, 0xca, 0x13, 0x2c, 0xb7, 0x63, 0x79, 0xf5, 0x03,
	0xf1, 0x2e, 0x95, 0x27, 0x48, 0x31, 0x14, 0x26, 0x11, 0xf0, 0xd7, 0x97, 0x95, 0x0d, 0x18, 0xf7,
	0x9b, 0x29, 0xc2, 0x89, 0xad, 0xfd, 0xea, 0x5e, 0x6d, 0x63, 0xe5, 0x41, 0xb9, 0xf6, 0xc5, 0xb2,
	0xb9, 0x53, 0x7b, 0xb0, 0xb2, 0xb9, 0x5f, 0xe6, 0x91, 0xfc, 0xb7, 0x58, 0x9b, 0xe2, 0x27, 0x6b,
	0x48, 0xbf, 0xc1, 0x7e, 0xee, 0x32, 0xec, 0xfa, 0xb1, 0x52, 0x4e, 0xd7, 0x8c, 0x7f, 0xae, 0x05,
	0x01, 0x36, 0x7c, 0x8c, 0xf3, 0x30, 0xc6, 0xef, 0xae, 0xfa, 0xe6, 0x26, 0x4f, 0xc9, 0xe4, 0xe4,
	0x14, 0x72, 0xc8, 0x3a, 0x8c, 0x37, 0xa8, 0x67, 0xd9, 0xc1, 0x45, 0x85, 0xab, 0x03, 0xa4, 0x7e,
	0x71, 0x8d, 0x83, 0x8b, 0xb8, 0x67, 0xa2, 0x72, 0xe9, 0x36, 0x4c, 0xc9, 0x05, 0x43, 0xb9, 0x4e,
	0x7e, 0x3b, 0x07, 0x53, 0xb8, 0xaa, 0x6e, 0xd9, 0x4f, 0x98, 0xe6, 0x37, 0x6a, 0x30, 0xcd, 0x3f,
	0xd6, 0x62, 0x3b, 0x6d, 0x14, 0xbf, 0x59, 0x98, 0xac, 0xb4, 0x0f, 0xad, 0xa6, 0xdd, 0x60, 0x49,
	0xfd, 0x18, 0x1b, 0x4c, 0x01, 0x2c, 0x8e, 0xb7, 0x74, 0x8d, 0xcc, 0xc1, 0xb4, 0xc8, 0xe3, 0x66,
	0xaa, 0x9e, 0x23, 0xf3, 0x40, 0x94, 0x2c, 0xbc, 0x79, 0xa2, 0xe7, 0x8d, 0x6d, 0x0c, 0x3f, 0xfe,
	0x84, 0x32, 0x99, 0x11, 0x88, 0x31, 0xad, 0x1f, 0x63, 0xd2, 0xc6, 0x17, 0x77, 0xfe, 0x95, 0x15,
	0xe1, 0x74, 0xd5, 0x73, 0x0c, 0x54, 0xbe, 0x73, 0xc5, 0xe5, 0x7a, 0xcd, 0x69, 0x53, 0x7d, 0xc4,
	0xe8, 0xc0, 0x98, 0x70, 0xc0, 0xcc, 0xc1, 0x74, 0x88, 0xd0, 0xeb, 0xb9, 0x1c, 0xe3, 0xfb, 0x3d,
	0xda, 0xa3, 0x0d, 0x5d, 0xe3, 0x1d, 0xb1, 0x99, 0x7d, 0x6c, 0x7f, 0x99, 0x36, 0xf4, 0x1c, 0x99,
	0x01, 0xa8, 0xb4, 0xfd, 0x50, 0xe2, 0x7a, 0x9e, 0x01, 0xaf, 0x5b, 0x76, 0x93, 0x36, 0xf4, 0x11,
	0x32, 0x05, 0x85, 0x55, 0xe1, 0xa1, 0xd0, 0x47, 0x31, 0x65, 0xb5, 0xeb, 0x94, 0x95, 0x8d, 0x19,
	0xbf, 0xa7, 0x41, 0x51, 0xe6, 0x59, 0xd5, 0xb3, 0xba, 0xc1, 0x12, 0x58, 0x81, 0x09, 0xc7, 0xe7,
	0x9f, 0x50, 0x07, 0x71, 0x53, 0x46, 0xae, 0xbd, 0xa8, 0xb0, 0xdb, 0x0c, 0x6b, 0x0f, 0x72, 0x54,
	0x9e, 0x86, 0x09, 0xcf, 0xea, 0x3e, 0xa1, 0x5e, 0xe8, 0x10, 0x28, 0xf0, 0x0c, 0xd5, 0xe9, 0xac,
	0x9c, 0x32, 0x18, 0xff, 0x39, 0x1f, 0xfa, 0x25, 0x92, 0xe8, 0x57, 0x1b, 0xd5, 0xa2, 0x8d, 0xa6,
	0x39, 0xb3, 0xc9, 0x7e, 0x70, 0x87, 0x55, 0xbc, 0xf9, 0xba, 0x9d, 0x6a, 0xc0, 0x25, 0x34, 0xbb,
	0xa8, 0x88, 0xca, 0xc6, 0xb1, 0xe0, 0xa6, 0x2b, 0x05, 0xf1, 0x71, 0xad, 0x1a, 0xbf, 0xd7, 0x24,
	0x5e, 0x7e, 0x7d, 0xfe, 0xd9, 0x91, 0xf3, 0x4f, 0x54, 0x1d, 0x33, 0x27, 0x0f, 0xc3, 0x24, 0x79,
	0x04, 0x93, 0x56, 0xb3, 0x59, 0xf3, 0xef, 0x45, 0x8a, 0x37, 0x60, 0x9f, 0x7b, 0x96, 0x56, 0x56,
	0x9a, 0x4d, 0xde, 0x90, 0xbb, 0x71, 0xcc, 0x04, 0x2b, 0x48, 0x95, 0xae, 0x46, 0xe6, 0x48, 0x5f,
	0x17, 0x50, 0x69, 0x29, 0x69, 0xfa, 0x28, 0xfe, 0x26, 0x4d, 0xf1, 0x37, 0x95, 0x8e, 0xc3, 0x5c,
	0x8c, 0x02, 0x3f, 0x9a, 0xf3, 0x0d, 0x38, 0x95, 0x40, 0xf6, 0xa0, 0xa3, 0x9c, 0x47, 0xa1, 0x6b,
	0x20, 0xb1, 0xe2, 0x5d, 0x18, 0xeb, 0x52, 0xb7, 0xd7, 0xf4, 0x8a, 0x69, 0x6f, 0x98, 0x53, 0xeb,
	0x9a, 0xa2, 0x66, 0x94, 0x32, 0x3e, 0xcb, 0x06, 0x6d, 0xe1, 0x8d, 0x46, 0x8c, 0x32, 0xb5, 0xe2,
	0x1a, 0x8c, 0x8b, 0xcd, 0x79, 0x26, 0xd2, 0x94, 0xca, 0xa6, 0x5f, 0xd5, 0x7f, 0x06, 0x97, 0x00,
	0x28, 0xac, 0xc9, 0x7f, 0x32, 0x0a, 0xba, 0x5c, 0x8c, 0x5b, 0xf8, 0x54, 0xbf, 0xc3, 0x80, 0xe9,
	0xfc, 0x2a, 0xcc, 0xa2, 0x9b, 0x4f, 0xda, 0xfc, 0x0b, 0xaf, 0x3f, 0x66, 0x07, 0xdb, 0xff, 0x05,
	0x98, 0x53, 0xe0, 0xd0, 0xf8, 0xe5, 0x73, 0x7c, 0x56, 0x82, 0xc4, 0x13, 0x82, 0x2b, 0xa0, 0x77,
	0x69, 0xcb, 0xf1, 0xe4, 0x53, 0x2a, 0x7e, 0xd2, 0x35, 0xc3, 0xf3, 0x1f, 0x48, 0xf7, 0x50, 0x71,
	0xe3, 0x16, 0x7a, 0xd2, 0x78, 0x84, 0xc1, 0x69, 0x29, 0x17, 0xdd, 0x0a, 0xd3, 0x7e, 0x98, 0x5b,
	0x97, 0x29, 0x6d, 0x11, 0x6a, 0xec, 0xe5, 0xfe, 0x1a, 0x0e, 0xf5, 0xbb, 0x39, 0x25, 0x6a, 0x72,
	0xed, 0xff, 0x6e, 0xe0, 0xba, 0x2a, 0x20, 0x8a, 0x57, 0x06, 0xa2, 0x90, 0x83, 0x53, 0xdd, 0x81,
	0x49, 0xfc, 0x1e, 0x8c, 0xf8, 0x48, 0xc1, 0xe0, 0x2f, 0xc2, 0x00, 0x03, 0x17, 0xdf, 0x2f, 0xb8,
	0x08, 0x53, 0x18, 0x34, 0xae, 0xd6, 0xa5, 0x96, 0xeb, 0xb4, 0x85, 0x6b, 0x78, 0x12, 0xf3, 0x4c,
	0xcc, 0x8a, 0x78, 0xc3, 0x27, 0x9f, 0xcf, 0x1b, 0x3e, 0x35, 0xac, 0x37, 0x3c, 0xe2, 0x97, 0x9e,
	0x8e, 0xf9, 0xa5, 0x55, 0x5f, 0xfe, 0x4c, 0xd4, 0x97, 0x1f, 0x71, 0x5b, 0xcf, 0x46, 0xdd, 0xd6,
	0xc6, 0x16, 0x9c, 0x88, 0xca, 0x2d, 0xdb, 0x9a, 0x93, 0x9b, 0x30, 0x22, 0x79, 0x05, 0x2e, 0xf6,
	0x1d, 0x12, 0xdc, 0x78, 0x23, 0x78, 0xc2, 0x74, 0x54, 0x7d, 0xdd, 0x43, 0x4e, 0x47, 0xa5, 0x72,
	0x38, 0x1d, 0xab, 0x31, 0x25, 0x26, 0x35, 0xf1, 0x8c, 0xb3, 0xce, 0xf8, 0x23, 0x0d, 0x4a, 0x49,
	0x58, 0x83, 0xdd, 0xd5, 0x88, 0xf0, 0x4b, 0x25, 0x3f, 0xa9, 0x48, 0xaf, 0xba, 0x18, 0x7e, 0xd3,
	0x06, 0x51, 0x94, 0x7e, 0x08, 0x26, 0xfa, 0x7d, 0xb0, 0x65, 0xa0, 0x9b, 0x3c, 0x69, 0xc0, 0x64,
	0x4b, 0xae, 0x11, 0xd3, 0x56, 0x91, 0xbe, 0xac, 0x46, 0xd4, 0xf5, 0xeb, 0x43, 0xf4, 0x26, 0xd0,
	0xd7, 0xef, 0x06, 0x01, 0x40, 0x77, 0x2d, 0xbb, 0xbb, 0xe5, 0x34, 0xa8, 0xf1, 0x1a, 0x8c, 0xb0,
	0xff, 0xcc, 0x62, 0x13, 0x41, 0xa4, 0xf4, 0x63, 0xe4, 0x04, 0xe8, 0x6b, 0xb6, 0x6b, 0xf1, 0x48,
	0xa1, 0x75, 0xe7, 0x90, 0x76, 0x8f, 0x74, 0xcd, 0xf8, 0xbf, 0x72, 0xcc, 0x72, 0x0a, 0xaa, 0xab,
	0x7e, 0x11, 0x3c, 0x53, 0x47, 0x65, 0x15, 0x0c, 0x58, 0x27, 0x3c, 0x53, 0x67, 0x05, 0xfe, 0xb5,
	0xac, 0x0e, 0xbf, 0x27, 0xa0, 0xc0, 0x62, 0x2c, 0xed, 0x1c, 0x7e, 0x74, 0x7a, 0x4e, 0x81, 0xc6,
	0x90, 0xda, 0xd7, 0xe1, 0x44, 0x04, 0xde, 0x73, 0x9e, 0xd2, 0xb6, 0xd0, 0xb0, 0x44, 0xa9, 0xb0,
	0xc7, 0x4a, 0xf8, 0x43, 0x66, 0xaf, 0xd6, 0xe0, 0x3d, 0x12, 0x27, 0xbd, 0xe0, 0x06, 0x91, 0xbc,
	0xc8, 0x2d, 0x18, 0x69, 0x39, 0x0d, 0x7e, 0x54, 0x36, 0x93, 0x38, 0x5e, 0x0a, 0x9b, 0x16, 0xb7,
	0xf0, 0x52, 0x14, 0xab, 0x62, 0x7c, 0xc2, 0x24, 0x39, 0xc6, 0x05, 0xf9, 0x6a, 0x81, 0xca, 0x86,
	0x46, 0x32, 0x1b, 0x1a, 0x09, 0x6c, 0x50, 0xaf, 0x4b, 0x48, 0xd0, 0x78, 0x4d, 0xee, 0x91, 0xb0,
	0xfd, 0x52, 0x46, 0x60, 0x35, 0x3a, 0x4f, 0x5f, 0xeb, 0xd7, 0x2b, 0xa5, 0x6e, 0x38, 0x4d, 0x7d,
	0xab, 0x21, 0xad, 0x7f, 0x59, 0xac, 0x86, 0x94, 0xba, 0x81, 0x14, 0xfe, 0x63, 0x4d, 0xe1, 0xe0,
	0x6e, 0xd7, 0xa9, 0x53, 0xd7, 0x95, 0x04, 0x49, 0x7c, 0x70, 0x20, 0xce, 0x41, 0x5e, 0x10, 0x72,
	0x30, 0x4d, 0x30, 0x72, 0xa9, 0x82, 0xe1, 0x8f, 0x7b, 0x7e, 0xf8, 0x71, 0xff, 0x4e, 0x8e, 0x29,
	0x9b, 0x38, 0xd9, 0xdf, 0xfd, 0x91, 0x27, 0xef, 0x40, 0x31, 0x02, 0x1f, 0x06, 0xb3, 0xe7, 0x01,
	0x61, 0xe7, 0x95, 0x4a, 0xe5, 0x20, 0xb2, 0xbd, 0x19, 0x8d, 0xcf, 0xfd, 0x4e, 0xbf, 0x2e, 0x47,
	0xfa, 0xf4, 0x5d, 0x88, 0xd4, 0xfd, 0x6e, 0x54, 0x86, 0x55, 0x77, 0x60, 0xff, 0xfd, 0x4b, 0x70,
	0xf9, 0x25, 0x56, 0x5b, 0x98, 0x74, 0x6f, 0xc2, 0x69, 0xa9, 0x10, 0x47, 0xfc, 0x9e, 0x14, 0x10,
	0xfc, 0x04, 0x8c, 0x72, 0xf9, 0x10, 0xc1, 0x8e, 0x31, 0x11, 0x18, 0x8a, 0x41, 0xbd, 0x7b, 0xd4,
	0xc3, 0xaa, 0xbe, 0xf3, 0xec, 0xb1, 0x7c, 0x59, 0x58, 0x05, 0x10, 0x88, 0xd7, 0x22, 0xb3, 0xe2,
	0x6a, 0x3f, 0x26, 0x47, 0xc9, 0x0a, 0xe6, 0x85, 0x72, 0xc1, 0x95, 0x41, 0x9a, 0xd4, 0x8d, 0x90,
	0x72, 0x20, 0x5f, 0x70, 0x8d, 0x82, 0xbc, 0x50, 0x62, 0xfe, 0x53, 0x4e, 0x59, 0x2b, 0x12, 0xaf,
	0xc3, 0x24, 0x3d, 0xdf, 0xe8, 0x17, 0x73, 0xe6, 0x75, 0x98, 0x8b, 0x7e, 0x66, 0x81, 0x8b, 0xe5,
	0x84, 0xa9, 0x47, 0xbe, 0xb3, 0x80, 0xdf, 0x81, 0xe0, 0x9f, 0xaf, 0x13, 0x47, 0x53, 0x22, 0x15,
	0x0e, 0xe2, 0x98, 0x34, 0x88, 0xe4, 0x5e, 0x28, 0xe7, 0xfc, 0x53, 0xd0, 0xd7, 0xfa, 0xf5, 0x1a,
	0xef, 0xc3, 0x24, 0x0a, 0x77, 0xa0, 0x20, 0x0a, 0x43, 0x2b, 0x88, 0xe7, 0x9a, 0x17, 0x8b, 0x51,
	0xc9, 0x8e, 0xf8, 0xe6, 0x23, 0xac, 0x37, 0x1e, 0xc2, 0xbc, 0x2a, 0x90, 0xd2, 0x05, 0x99, 0x89,
	0x8e, 0x65, 0x77, 0xe5, 0x13, 0xb9, 0x0b, 0x83, 0x78, 0x61, 0x16, 0x3a, 0xe2, 0x97, 0xf1, 0xa5,
	0xe8, 0x6c, 0x88, 0xfa, 0xfd, 0x3f, 0x1f, 0x11, 0xaf, 0xcb, 0xfd, 0x90, 0x27, 0x49, 0xd6, 0x85,
	0xe8, 0x74, 0x8a, 0x9d, 0x69, 0xfc, 0x47, 0x0d, 0xce, 0x4a, 0xe5, 0x6e, 0xe2, 0xd3, 0x30, 0xb1,
	0xb6, 0x4b, 0x7a, 0x42, 0xe4, 0x54, 0x1a, 0x64, 0x07, 0x46, 0x59, 0x87, 0xfc, 0xc3, 0x9e, 0x5b,
	0xfd, 0x48, 0x8c, 0x63, 0x5f, 0x14, 0xd9, 0x18, 0x2d, 0x19, 0xf1, 0x94, 0xbe, 0x08, 0x10, 0x66,
	0x3e, 0x4b, 0xb0, 0xe0, 0x28, 0xc3, 0xa5, 0xa1, 0xb7, 0xa3, 0xd3, 0x3e, 0xde, 0xdd, 0xf5, 0x08,
	0xcf, 0x17, 0x87, 0xeb, 0x50, 0xc0, 0xfa, 0x3f, 0xd3, 0x60, 0x5c, 0xdc, 0x8e, 0x48, 0x3c, 0x24,
	0x4b, 0x8a, 0xc0, 0x9f, 0x14, 0x05, 0x9f, 0x88, 0xaf, 0xcc, 0xf3, 0xe3, 0x64, 0xfe, 0x8d, 0xf9,
	0xcf, 0xc1, 0xd4, 0xa6, 0xe5, 0x7a, 0x5b, 0x4e, 0xc3, 0x7e, 0x6c, 0xd3, 0x46, 0x86, 0x4b, 0x48,
	0x0a, 0x3c, 0xb9, 0x01, 0x85, 0xfa, 0x81, 0xdd, 0x6c, 0x74, 0x71, 0x6a, 0x27, 0x9f, 0xd1, 0xf9,
	0x37, 0x3b, 0x02, 0x48, 0xe3, 0x0b, 0x30, 0x66, 0x52, 0x66, 0x3d, 0x92, 0x0b, 0x30, 0xd9, 0xb0,
	0xbb, 0xb4, 0xee, 0x39, 0xf8, 0x01, 0x1d, 0xf1, 0xdd, 0x3e, 0x29, 0x0b, 0x2f, 0x54, 0xda, 0xcd,
	0xe0, 0x8b, 0x7d, 0x3c, 0x61, 0x74, 0x60, 0x36, 0x7a, 0x61, 0x04, 0x0f, 0x82, 0x1c, 0x2f, 0xf5,
	0x20, 0xc8, 0x87, 0x47, 0x28, 0xb2, 0xc4, 0x06, 0x27, 0x30, 0x60, 0x93, 0xde, 0x7f, 0x73, 0x0a,
	0x4d, 0x01, 0x66, 0xfc, 0x52, 0x0e, 0x66, 0xf0, 0x8b, 0x0e, 0x54, 0xb6, 0xee, 0x31, 0x38, 0x84,
	0x7f, 0x02, 0x14, 0xb7, 0xee, 0xd5, 0x0a, 0x8b, 0x18, 0x60, 0xc5, 0xbf, 0x30, 0xcc, 0xab, 0x92,
	0x4d, 0x98, 0x68, 0x38, 0xf5, 0xa7, 0xb4, 0x6b, 0x37, 0x7c, 0xc9, 0x5f, 0x1c, 0x84, 0x67, 0xcd,
	0xaf, 0x20, 0x22, 0xb5, 0x07, 0x08, 0x4a, 0xb7, 0x60, 0x52, 0x6a, 0x64, 0x18, 0x65, 0x56, 0x7a,
	0x17, 0x66, 0x54, 0xbc, 0x43, 0xa9, 0xc2, 0x7d, 0x38, 0xc9, 0x1d, 0x1b, 0xbb, 0x4d, 0xab, 0x4e,
	0x5b, 0xe8, 0x73, 0xe0, 0x5f, 0x08, 0x27, 0xb7, 0xfd, 0x43, 0x5c, 0xce, 0xa5, 0x57, 0x52, 0xde,
	0x0c, 0x07, 0x15, 0xe5, 0x03, 0xdd, 0xdf, 0xcd, 0xfb, 0xdf, 0xdf, 0x51, 0x8a, 0xd9, 0xa2, 0x64,
	0x3d, 0x7e, 0x4c, 0xeb, 0x6c, 0xc3, 0x2f, 0xbe, 0x3f, 0xea, 0x8a, 0xe3, 0x0b, 0xdd, 0x2f, 0x10,
	0xdf, 0x28, 0xe5, 0x9f, 0xc9, 0xa4, 0xf6, 0x93, 0x03, 0xff, 0x23, 0x74, 0x22, 0x45, 0x1e, 0xc0,
	0x24, 0x6d, 0xe3, 0x05, 0x5d, 0x86, 0x57, 0x58, 0x97, 0x37, 0xb2, 0x90, 0xb7, 0x58, 0x0e, 0xeb,
	0xa1, 0x0b, 0x59, 0x46, 0xc4, 0x76, 0xb0, 0x38, 0xf9, 0x46, 0x10, 0xe1, 0xcd, 0x4c, 0x08, 0x57,
	0x1e, 0x3f, 0xb6, 0xdb, 0xb6, 0x77, 0xc4, 0x12, 0xe1, 0x89, 0x14, 0x79, 0x00, 0x73, 0x2d, 0xcb,
	0xab, 0x1f, 0xd4, 0xe8, 0xa7, 0x9d, 0x2e, 0x75, 0x5d, 0x5c, 0x2b, 0x47, 0x53, 0x9e, 0x90, 0xe3,
	0xc5, 0xf3, 0x2a, 0x6d, 0xe2, 0xdc, 0x11, 0xdf, 0x2e, 0xc5, 0x06, 0x74, 0xc4, 0x51, 0x0e, 0x51,
	0x18, 0x8b, 0x30, 0x1b, 0xe9, 0x02, 0x99, 0x82, 0x82, 0xff, 0x1d, 0x54, 0xfd, 0x18, 0x99, 0x86,
	0x89, 0x4e, 0x97, 0x3e, 0xa6, 0x5d, 0x96, 0xd4, 0x8c, 0x65, 0xd0, 0xa3, 0x14, 0xb2, 0x0a, 0x96,
	0xc8, 0xd3, 0x8f, 0x11, 0x1d, 0xa6, 0xac, 0xb6, 0x67, 0xfb, 0x50, 0xba, 0x66, 0xfc, 0xa5, 0x06,
	0xc5, 0x34, 0x92, 0x12, 0x64, 0x6b, 0x1b, 0x0a, 0xc1, 0xe7, 0xef, 0xf9, 0xe5, 0xa0, 0xe5, 0xcc,
	0x3d, 0x5c, 0xf4, 0x3f, 0x76, 0x6f, 0x06, 0x38, 0xd8, 0xa8, 0xa3, 0x78, 0xfa, 0xc6, 0xb6, 0x48,
	0x19, 0xf7, 0xa1, 0x10, 0x7c, 0x1a, 0x7f, 0x0c, 0x72, 0x95, 0x36, 0x3f, 0x75, 0xda, 0x76, 0xbc,
	0x4a, 0x5b, 0xd7, 0x08, 0xc0, 0x58, 0xf9, 0x53, 0xdb, 0xf5, 0x5c, 0x7e, 0x06, 0xb2, 0xe6, 0x50,
	0x77, 0xdb, 0xf1, 0x30, 0x4b, 0xcf, 0xb3, 0x0a, 0xf7, 0x3c, 0x7d, 0x84, 0xfd, 0xdf, 0xf4, 0xf4,
	0xd1, 0x85, 0xbf, 0xcd, 0x05, 0x47, 0x21, 0xb3, 0x30, 0x59, 0xdd, 0x5b, 0xd9, 0xdb, 0xaf, 0xd6,
	0xb6, 0x77, 0xb6, 0xcb, 0xfa, 0x31, 0x29, 0xa3, 0xb2, 0x5d, 0xd9, 0xd3, 0x35, 0xc6, 0x53, 0x91,
	0xb1, 0x73, 0x5f, 0xcf, 0xf1, 0x13, 0x3a, 0x9e, 0x5c, 0x5f, 0xdf, 0xac, 0x6c, 0x97, 0xf5, 0x3c,
	0x6b, 0x51, 0xe4, 0x95, 0x4d, 0x73, 0xc7, 0xd4, 0x47, 0x48, 0x11, 0x4e, 0x04, 0x68, 0xf7, 0x6a,
	0x95, 0xed, 0xda, 0xfb, 0xfb, 0x3b, 0xe6, 0xfe, 0x96, 0x3e, 0x4a, 0x4e, 0xc2, 0x71, 0x51, 0xb2,
	0x56, 0x5e, 0xdd, 0xd9, 0xda, 0xaa, 0x54, 0xab, 0x95, 0x9d, 0x6d, 0x7d, 0x8c, 0xcc, 0x03, 0x11,
	0x05, 0x5b, 0x2b, 0x95, 0xed, 0xbd, 0xf2, 0xf6, 0xca, 0xf6, 0x6a, 0x59, 0x1f, 0x97, 0x2a, 0xf8,
	0x27, 0x83, 0x6b, 0x3b, 0x0f, 0xb7, 0xf5, 0x02, 0x39, 0x0d, 0x27, 0xa3, 0x05, 0xe5, 0x7b, 0xe6,
	0xca, 0x5a, 0x79, 0x4d, 0x9f, 0x90, 0x6a, 0x6d, 0x97, 0xcb, 0x6b, 0xd5, 0x9a, 0x59, 0xbe, 0xbb,
	0xb3, 0xb3, 0xa7, 0x03, 0x39, 0x03, 0xc5, 0x48, 0x2d, 0xb3, 0x7c, 0x77, 0x65, 0x13, 0x1b, 0x9b,
	0x24, 0x17, 0xe0, 0x4c, 0x14, 0xa7, 0x59, 0x79, 0xc0, 0x60, 0x76, 0x37, 0x57, 0x56, 0xcb, 0xfa,
	0x14, 0x79, 0x19, 0xce, 0x27, 0xf5, 0xac, 0xb6, 0xbd, 0x13, 0x1c, 0x97, 0x4e, 0x93, 0x19, 0x80,
	0xa0, 0x2f, 0x1f, 0xe8, 0x33, 0x0b, 0xdf, 0xd2, 0x00, 0x78, 0x78, 0x1a, 0x94, 0xc1, 0x13, 0xa0,
	0x23, 0x5a, 0xb3, 0xb6, 0xf7, 0xe1, 0x6e, 0xd9, 0xe7, 0x7c, 0x24, 0x77, 0xbd, 0xb2, 0x59, 0xd6,
	0x35, 0xf2, 0x12, 0xcc, 0xc9, 0xb9, 0x77, 0x37, 0x77, 0x56, 0xef, 0xf3, 0x43, 0x33, 0x39, 0x9b,
	0x1f, 0xd8, 0xea, 0x79, 0x72, 0x0a, 0x5e, 0x92, 0xf3, 0xc5, 0x59, 0x6b, 0x79, 0x4d, 0x1f, 0x89,
	0x62, 0xba, 0x67, 0xae, 0xec, 0x6e, 0xe8, 0xa3, 0x0b, 0x7f, 0x4f, 0x83, 0x31, 0xfe, 0x69, 0x6b,
	0x36, 0x8e, 0xeb, 0x55, 0x85, 0xa6, 0x39, 0x98, 0xf6, 0x73, 0xee, 0xee, 0x99, 0xeb, 0x55, 0x7e,
	0x96, 0xec, 0x67, 0x95, 0x3f, 0xd8, 0xbb, 0xc1, 0x05, 0xce, 0xcf, 0x59, 0xdf, 0xaf, 0x32, 0x81,
	0x98, 0x85, 0xc9, 0x00, 0xd1, 0x7a, 0x55, 0x1f, 0x91, 0x33, 0x1e, 0xac, 0x57, 0xf5, 0x51, 0x39,
	0xe3, 0x83, 0xf5, 0xaa, 0x3e, 0x26, 0x67, 0x7c, 0x71, 0xbd, 0xaa, 0x8f, 0xcb, 0x4d, 0x7f, 0xb0,
	0x5e, 0x3d, 0x5c, 0xd6, 0x0b, 0x0b, 0xbf, 0xa1, 0xc1, 0x4b, 0x89, 0x1f, 0x9d, 0x21, 0x17, 0xe1,
	0x2c, 0xf6, 0xa7, 0x26, 0x7a, 0xb8, 0xba, 0xb1, 0xb2, 0x7d, 0xaf, 0xac, 0x74, 0xe5, 0x12, 0x5c,
	0x4c, 0x05, 0xd9, 0xda, 0x59, 0xab, 0xac, 0x57, 0xca, 0x6b, 0xba, 0x46, 0x0c, 0x38, 0x97, 0x0a,
	0xb6, 0xb2, 0xc6, 0x84, 0x2b, 0x47, 0x5e, 0x81, 0x0b, 0xa9, 0x30, 0x6b, 0xe5, 0xcd, 0xf2, 0x5e,
	0x79, 0x4d, 0xcf, 0x2f, 0x78, 0x30, 0xa5, 0x7c, 0xda, 0x93, 0x09, 0x78, 0xf9, 0x41, 0xd9, 0xac,
	0xec, 0x7d, 0xa8, 0x10, 0xc6, 0x44, 0x55, 0xc9, 0x5f, 0xd9, 0x5c, 0x31, 0xb7, 0x74, 0x8d, 0x8d,
	0xa5, 0x5a, 0xf0, 0x70, 0xc5, 0xdc, 0xae, 0x6c, 0xdf, 0xd3, 0x73, 0x38, 0xbf, 0x22, 0xb8, 0xf6,
	0x2a, 0xeb, 0x1f, 0xea, 0xf9, 0x85, 0xaf, 0x69, 0x30, 0x25, 0x7f, 0xc7, 0x91, 0x35, 0x6b, 0x96,
	0xab, 0x3b, 0xfb, 0xe6, 0xaa, 0xca, 0x8f, 0x22, 0x9c, 0x50, 0xf3, 0xc5, 0x59, 0xbe, 0x96, 0x54,
	0x63, 0xad, 0xac, 0xe7, 0x18, 0x3d, 0x6a, 0xbe, 0x7f, 0xc1, 0x20, 0xcf, 0xfa, 0xa0, 0x16, 0x21,
	0x67, 0xf4, 0x91, 0x85, 0x9f, 0xd0, 0x60, 0x16, 0x3f, 0xf5, 0xc7, 0x3f, 0xe6, 0x85, 0x14, 0x95,
	0x60, 0x1e, 0xef, 0x0a, 0xd4, 0x56, 0x56, 0xf7, 0x2a, 0x3b, 0xdb, 0x0a, 0x55, 0x67, 0xa0, 0x18,
	0x2f, 0xe3, 0x3c, 0xd5, 0xb5, 0xe4, 0xd2, 0x55, 0xb3, 0xbc, 0xb2, 0xc7, 0xe8, 0x4b, 0x2c, 0xdd,
	0xdf, 0x5d, 0x63, 0xa5, 0xf9, 0x85, 0x8f, 0xfc, 0xef, 0x76, 0x49, 0x9f, 0x55, 0x63, 0x55, 0x78,
	0xb7, 0xfd, 0x3a, 0xbb, 0x2b, 0xe6, 0xca, 0x96, 0x4f, 0xcc, 0x69, 0x38, 0x99, 0x54, 0xba, 0xb3,
	0xbe, 0xae, 0x6b, 0xac, 0x17, 0x89, 0x85, 0xdb, 0x7a, 0x6e, 0x61, 0x19, 0xc6, 0x57, 0x9d, 0xe0,
	0xcb, 0xff, 0x02, 0xdb, 0x38, 0xe4, 0x37, 0x77, 0x1e, 0x72, 0x65, 0xbd, 0x55, 0x5e, 0xab, 0xec,
	0x6f, 0xe9, 0x39, 0x56, 0xbc, 0x51, 0xb9, 0xb7, 0xa1, 0xe7, 0x17, 0x7e, 0x18, 0x26, 0x2a, 0xce,
	0x6e, 0xd7, 0x61, 0xa6, 0x22, 0x63, 0x75, 0x65, 0xa7, 0xb6, 0x6b, 0xee, 0x30, 0x2d, 0x50, 0xab,
	0x96, 0xdf, 0xdf, 0xe7, 0x37, 0x35, 0xf4, 0x63, 0x6c, 0x1a, 0x4b, 0x45, 0xe6, 0xca, 0xf6, 0xda,
	0xce, 0x16, 0x3f, 0x58, 0x97, 0xb2, 0xd7, 0xee, 0x72, 0x21, 0x51, 0xb2, 0x6a, 0x66, 0x79, 0x6b,
	0x87, 0xf1, 0x82, 0x29, 0x71, 0xa9, 0x64, 0x75, 0xab, 0xaa, 0x8f, 0x2c, 0x7c, 0x2b, 0x07, 0x93,
	0xd2, 0xc7, 0xd7, 0x58, 0x3b, 0xa2, 0x7f, 0x4c, 0x95, 0xc9, 0x62, 0xa3, 0x64, 0xef, 0x96, 0xb7,
	0xd7, 0x98, 0x4c, 0xca, 0x0c, 0xe1, 0x25, 0x2b, 0x0f, 0x56, 0x2a, 0x9b, 0x2b, 0x77, 0x37, 0x85,
	0xe8, 0xa8, 0x65, 0x78, 0x33, 0x84, 0x4d, 0x93, 0x58, 0xd1, 0x5a, 0x59, 0x14, 0x8d, 0x48, 0xfc,
	0x0f, 0x8b, 0xf6, 0x56, 0x37, 0x58, 0x73, 0xa3, 0x4c, 0x4a, 0x95, 0x42, 0xbe, 0xf4, 0x8c, 0xc5,
	0x08, 0xf4, 0x27, 0xe4, 0x38, 0x39, 0x07, 0x25, 0xa5, 0x64, 0xcf, 0xfc, 0x50, 0xb4, 0xc6, 0x30,
	0x16, 0x62, 0x35, 0xcd, 0x32, 0xd3, 0xe8, 0x65, 0x7d, 0x62, 0xe1, 0xeb, 0x9a, 0x7f, 0xaf, 0xa0,
	0xea, 0x7f, 0x39, 0x52, 0x6e, 0x3c, 0x5c, 0x3d, 0xcf, 0xc2, 0xa9, 0x68, 0xfe, 0x5e, 0x6d, 0xd7,
	0x2c, 0x57, 0xcb, 0xdb, 0x6c, 0x2d, 0x3d, 0x01, 0xba, 0x5a, 0x8c, 0x77, 0x71, 0x62, 0xc8, 0x70,
	0x81, 0xcb, 0x47, 0x18, 0x8a, 0x2b, 0xa6, 0x58, 0xdf, 0x46, 0x16, 0x7e, 0x10, 0xa6, 0xc5, 0x95,
	0x8f, 0x2d, 0xda, 0xb0, 0x7b, 0x2d, 0xbe, 0x1a, 0xf2, 0x25, 0x8b, 0x0b, 0x57, 0x6d, 0x6b, 0xe5,
	0xde, 0x76, 0x79, 0xaf, 0xb2, 0xaa, 0x1f, 0xe3, 0x6b, 0xab, 0x52, 0x58, 0xad, 0x32, 0x65, 0x87,
	0xab, 0xa4, 0x92, 0xbf, 0xfd, 0x60, 0xab, 0xac, 0xe7, 0x16, 0x28, 0x4c, 0xf2, 0x18, 0x76, 0x5c,
	0x16, 0x4e, 0xc1, 0x4b, 0x7c, 0xc4, 0x7c, 0x5e, 0x7f, 0xb0, 0x57, 0x36, 0xb7, 0x51, 0x1c, 0xa3,
	0x45, 0x6c, 0xe9, 0xc6, 0x22, 0x8d, 0x2d, 0xa6, 0x89, 0x45, 0xb5, 0xea, 0xc3, 0xca, 0xde, 0xea,
	0x86, 0x9e, 0x5b, 0xd8, 0x83, 0x99, 0xe0, 0x52, 0xc3, 0x7a, 0xd3, 0x7a, 0xc2, 0x36, 0x4e, 0xfa,
	0xce, 0x6e, 0x6d, 0x7d, 0x73, 0xe5, 0x5e, 0xb5, 0x16, 0x5e, 0x66, 0x9a, 0x83, 0xe9, 0x20, 0x17,
	0x39, 0x8d, 0xca, 0x31, 0xc8, 0xe2, 0x83, 0x58, 0x5b, 0xdf, 0x31, 0x57, 0x19, 0xf1, 0x7f, 0xaa,
	0xe1, 0x17, 0x71, 0xa5, 0xa0, 0xf8, 0xa8, 0x2f, 0x95, 0x9c, 0x6a, 0xaf, 0xdd, 0xb0, 0x8e, 0xb8,
	0x3c, 0xab, 0x25, 0x5b, 0x0e, 0x96, 0x70, 0xf5, 0xab, 0x94, 0xec, 0xf5, 0xa8, 0xcb, 0x8a, 0x72,
	0xc8, 0x6c, 0xa5, 0xe8, 0x21, 0x6d, 0xb4, 0x79, 0x21, 0x0e, 0x5b, 0xa4, 0xde, 0x41, 0xaf, 0x8b,
	0x65, 0x23, 0xf1, 0xd6, 0xd6, 0xbb, 0x36, 0x2b, 0x19, 0x8d, 0xd7, 0xaa, 0x5a, 0x5e, 0xaf, 0xcb,
	0xca, 0xc6, 0x16, 0xbe, 0x1a, 0x7d, 0x48, 0xc4, 0x1f, 0xfd, 0x90, 0xf3, 0xd1, 0x97, 0x23, 0x3c,
	0x7f, 0xbf, 0xfd, 0xb4, 0xed, 0x7c, 0xc2, 0x2c, 0xc4, 0x0b, 0xd1, 0x3b, 0xfb, 0x1c, 0xc0, 0xff,
	0xad, 0x6b, 0x6c, 0xe1, 0x4c, 0x7c, 0x4f, 0xc4, 0x6f, 0xd4, 0xec, 0x74, 0xf4, 0xdc, 0xc2, 0xbf,
	0xcb, 0xe1, 0xbd, 0xcf, 0xc4, 0xd7, 0x01, 0x68, 0x0e, 0xa5, 0x94, 0x85, 0x64, 0xbc, 0x2a, 0x1e,
	0xdd, 0x27, 0x00, 0x6d, 0x3b, 0x1e, 0x9e, 0xf7, 0xe3, 0xc5, 0x9b, 0x0b, 0xc9, 0xaf, 0x53, 0x18,
	0x1c, 0xde, 0xe1, 0xc9, 0xf5, 0x6b, 0x6e, 0xe5, 0x91, 0x83, 0x68, 0xf2, 0x6c, 0x09, 0x4f, 0x03,
	0xda, 0xb5, 0x7a, 0x2e, 0x5e, 0xdb, 0xe9, 0x83, 0xa8, 0xea, 0x39, 0x9d, 0x0e, 0x6d, 0xe8, 0xa3,
	0xfd, 0x10, 0xf1, 0xd0, 0x08, 0xfa, 0x58, 0x3f, 0x18, 0x71, 0x47, 0x68, 0xbc, 0x1f, 0x8c, 0xb8,
	0x74, 0x54, 0x58, 0xf8, 0xfd, 0x84, 0xe7, 0xb0, 0xf2, 0xab, 0x01, 0x72, 0x39, 0x7a, 0xc9, 0x5b,
	0x2d, 0x0f, 0xb9, 0x7d, 0x29, 0x7a, 0x65, 0x5c, 0x05, 0x44, 0x16, 0xe8, 0x5a, 0x7c, 0x50, 0x22,
	0xaf, 0x16, 0xa8, 0xcb, 0xaf, 0x67, 0xbd, 0x12, 0xbd, 0xd3, 0xae, 0xc2, 0x31, 0x6e, 0xe9, 0xf9,
	0xe5, 0x7f, 0x98, 0x83, 0x39, 0xe9, 0x9a, 0xa2, 0xf8, 0x0a, 0xf0, 0xaf, 0x69, 0x70, 0x22, 0xe9,
	0x89, 0x1d, 0xb9, 0x99, 0xfe, 0xb5, 0xe1, 0x3e, 0xaf, 0x36, 0x4b, 0x6f, 0x0d, 0x5b, 0x4d, 0x38,
	0xeb, 0xcf, 0xfe, 0xd8, 0x9f, 0xff, 0xd5, 0xcf, 0xe6, 0x4e, 0x1a, 0x64, 0xe9, 0xf0, 0x8d, 0x25,
	0xfe, 0x6d, 0xe4, 0xa5, 0xc7, 0x1c, 0xe6, 0xb6, 0xb6, 0x70, 0x5d, 0x23, 0x5d, 0x18, 0xe3, 0xfe,
	0x7d, 0x72, 0x39, 0xbd, 0x09, 0xe5, 0xfc, 0xa0, 0x74, 0x65, 0x30, 0xa0, 0x68, 0xfd, 0x25, 0x6c,
	0x7d, 0xd6, 0x80, 0xb0, 0xf5, 0xdb, 0xda, 0xc2, 0xf2, 0xbf, 0x19, 0x81, 0x59, 0x89, 0x65, 0x78,
	0x9d, 0xbc, 0x05, 0x63, 0xfc, 0x24, 0x8b, 0x5c, 0x4a, 0xbb, 0x13, 0xac, 0x9c, 0xa6, 0x95, 0x5e,
	0x1d, 0x04, 0x26, 0x68, 0x38, 0x81, 0x34, 0xcc, 0x18, 0x13, 0x8c, 0x86, 0xae, 0xd3, 0xa4, 0x8c,
	0x04, 0xe2, 0xc2, 0x44, 0xc0, 0x37, 0x72, 0x25, 0x0d, 0x55, 0xd4, 0x69, 0x5a, 0x7a, 0x2d, 0x03,
	0xa4, 0x68, 0x77, 0x0e, 0xdb, 0x9d, 0x24, 0x61, 0xbb, 0xe4, 0xab, 0x30, 0x2e, 0x1c, 0xbd, 0x24,
	0x95, 0x7a, 0xd5, 0x25, 0x5d, 0xba, 0x3c, 0x10, 0x4e, 0x34, 0x77, 0x01, 0x9b, 0x2b, 0x91, 0x62,
	0xd0, 0xdc, 0x92, 0xcd, 0x41, 0x96, 0xbe, 0xd2, 0xb6, 0x5a, 0xf4, 0x33, 0xf2, 0x71, 0x30, 0xd2,
	0xa9, 0x1c, 0x56, 0xc7, 0xf9, 0xd5, 0x41, 0x60, 0xa2, 0xe9, 0x22, 0x36, 0x4d, 0x16, 0xf4, 0xb0,
	0x69, 0xd1, 0x64, 0x0b, 0xc6, 0xc4, 0x85, 0x92, 0xd4, 0x26, 0x95, 0x4b, 0xe6, 0xe9, 0x4d, 0x46,
	0xe2, 0x12, 0x88, 0x41, 0x2d, 0x29, 0x83, 0xba, 0xfc, 0x8f, 0x72, 0x70, 0x5c, 0x92, 0x2b, 0xff,
	0x22, 0x36, 0xf9, 0x79, 0x0d, 0xa6, 0xe4, 0x9b, 0xe1, 0x24, 0xf1, 0x8b, 0x28, 0x7d, 0x6e, 0x99,
	0x97, 0xae, 0x67, 0xaf, 0xe0, 0x47, 0xde, 0x41, 0x0a, 0xcf, 0x92, 0xd3, 0x8c, 0x42, 0x9b, 0x43,
	0xda, 0xd4, 0x5d, 0x92, 0xaf, 0x93, 0x93, 0x1f, 0xd3, 0xc2, 0xeb, 0xb6, 0x0b, 0xfd, 0x9a, 0x50,
	0x6f, 0x9a, 0x97, 0x5e, 0xcf, 0x04, 0x2b, 0x28, 0x39, 0x87, 0x94, 0x14, 0xc9, 0x7c, 0x84, 0x12,
	0x71, 0xc7, 0x76, 0xf9, 0xb7, 0x35, 0xe5, 0xbe, 0xb6, 0xff, 0x35, 0xbc, 0x5f, 0xd4, 0x60, 0x46,
	0x8d, 0x71, 0x42, 0xae, 0x27, 0x5f, 0xf6, 0x4b, 0x8f, 0x15, 0x53, 0x7a, 0x63, 0x88, 0x1a, 0x49,
	0x8c, 0x13, 0xa7, 0x92, 0x81, 0x2c, 0x8b, 0x03, 0xac, 0xe5, 0xbf, 0x1d, 0x83, 0xf9, 0x38, 0xcd,
	0xbb, 0x96, 0xdd, 0x65, 0x3c, 0xf5, 0x35, 0xc9, 0xd5, 0x3e, 0xad, 0xc7, 0x8e, 0xe7, 0x4b, 0xd7,
	0x32, 0x42, 0x0b, 0x3a, 0x4f, 0x23, 0x9d, 0x2f, 0x19, 0xba, 0x44, 0x27, 0x9e, 0x63, 0x30, 0xf5,
	0xf2, 0x75, 0x2d, 0x9c, 0xea, 0x83, 0xf0, 0x46, 0x66, 0xfc, 0x62, 0x56, 0x70, 0xff, 0x09, 0x14,
	0xd2, 0x71, 0x9e, 0x9c, 0x8d, 0xd2, 0x11, 0xce, 0x7f, 0xbb, 0xf1, 0x19, 0xf9, 0xbf, 0x35, 0x59,
	0xe3, 0x2d, 0x0d, 0x68, 0x24, 0xa6, 0xf8, 0xae, 0x67, 0xaf, 0xa0, 0x6a, 0x05, 0x12, 0xe3, 0x0f,
	0xf9, 0x49, 0x0d, 0x0a, 0xfe, 0xe9, 0x2e, 0x19, 0xd4, 0xdd, 0xc8, 0x39, 0x71, 0x69, 0x29, 0x33,
	0x7c, 0x92, 0xf8, 0x2b, 0xfc, 0xe1, 0x87, 0x9a, 0x3f, 0xa7, 0x01, 0x84, 0x07, 0xbc, 0x64, 0x50,
	0x47, 0x63, 0xc7, 0xc5, 0x7d, 0x65, 0x3c, 0xf9, 0xf4, 0xd8, 0xb8, 0x88, 0x34, 0x9d, 0x36, 0x52,
	0x68, 0x62, 0x12, 0xf4, 0x35, 0x2d, 0x50, 0xd7, 0x83, 0xc4, 0x58, 0xd5, 0xda, 0xd7, 0x32, 0x42,
	0xab, 0xe2, 0xb3, 0x10, 0x17, 0x9f, 0xaf, 0x84, 0x97, 0x04, 0x3e, 0x5b, 0xfe, 0xdd, 0x51, 0x38,
	0x15, 0x9f, 0x70, 0x22, 0x58, 0x18, 0xf9, 0x69, 0x45, 0xb8, 0x96, 0xfb, 0x50, 0x90, 0x12, 0x83,
	0xac, 0xf4, 0xe6, 0x50, 0x75, 0x04, 0xed, 0x25, 0xa4, 0xfd, 0x04, 0x21, 0x12, 0xed, 0x0d, 0x41,
	0xd2, 0xaf, 0x49, 0x33, 0x70, 0x69, 0x20, 0xf2, 0xc8, 0x1c, 0xbc, 0x9e, 0xbd, 0x82, 0x20, 0xe5,
	0x1d, 0x24, 0x65, 0x99, 0x5c, 0x8f, 0x93, 0x12, 0xce, 0xc3, 0x84, 0x78, 0x5d, 0x9f, 0x91, 0x5f,
	0xd7, 0xa0, 0xe0, 0x47, 0x00, 0x23, 0x83, 0x1b, 0x8e, 0xc4, 0x1f, 0xeb, 0x2b, 0x7d, 0x29, 0xe1,
	0xc5, 0x6e, 0x21, 0xad, 0x6f, 0x1a, 0x6f, 0x24, 0xd0, 0xea, 0x07, 0x04, 0x4b, 0x21, 0xf6, 0x77,
	0x34, 0x80, 0x30, 0x6a, 0x58, 0x86, 0x91, 0x8e, 0xc5, 0x2d, 0xcb, 0x30, 0xd2, 0x09, 0x61, 0xc9,
	0xee, 0x20, 0xc9, 0x37, 0x8d, 0x37, 0x13, 0x48, 0x6e, 0xd0, 0xfe, 0x44, 0x2f, 0x7f, 0x3b, 0xaf,
	0x98, 0x9b, 0xf8, 0x65, 0xe2, 0x1f, 0x19, 0x60, 0x8a, 0xc5, 0xe3, 0x8f, 0x25, 0x9b, 0x62, 0x09,
	0x51, 0xc7, 0xd4, 0x15, 0xac, 0xed, 0x34, 0x14, 0x53, 0x8c, 0x87, 0x70, 0xf8, 0x8c, 0x7c, 0x23,
	0xbe, 0xbc, 0x5e, 0x1b, 0xd0, 0x40, 0x64, 0x6d, 0x5d, 0xcc, 0x0a, 0x9e, 0x64, 0x21, 0x2a, 0x64,
	0x89, 0x55, 0x35, 0x83, 0x51, 0x9c, 0x14, 0xa5, 0x2c, 0xd9, 0x28, 0x4e, 0x0c, 0x5a, 0xa6, 0x1a,
	0xc5, 0x48, 0xc3, 0xf2, 0x5f, 0xcf, 0x29, 0xfb, 0x27, 0x71, 0xf1, 0xdf, 0x0d, 0x16, 0xf1, 0xcb,
	0x19, 0x43, 0xc2, 0x97, 0xae, 0x0c, 0x06, 0x14, 0x54, 0xcc, 0x23, 0x15, 0xba, 0x31, 0xc9, 0xa8,
	0x10, 0x0f, 0x1a, 0x98, 0xce, 0x3d, 0x84, 0x51, 0x0c, 0xbd, 0x9e, 0x2c, 0x12, 0xf1, 0x28, 0xef,
	0xa5, 0xcb, 0x03, 0xe1, 0x44, 0x8b, 0x67, 0xb0, 0xc5, 0x79, 0x63, 0x4e, 0x6a, 0x71, 0xa9, 0xce,
	0x40, 0x58, 0xbb, 0x5f, 0xed, 0xbf, 0x07, 0x4b, 0x88, 0xee, 0xde, 0xaf, 0xb3, 0x11, 0x05, 0x7f,
	0x1e, 0x9b, 0x3e, 0xb5, 0x70, 0x52, 0x6e, 0xfa, 0x2b, 0xc1, 0x65, 0xf7, 0xcf, 0xc8, 0x4f, 0x48,
	0x9a, 0xf2, 0x4a, 0x86, 0x38, 0xd7, 0x7d, 0x06, 0x3d, 0x31, 0x22, 0xb6, 0x71, 0x19, 0x29, 0xb8,
	0x48, 0xce, 0xcb, 0x14, 0x04, 0x33, 0x42, 0xa2, 0xe4, 0xd7, 0x35, 0x20, 0xf1, 0xa8, 0xdc, 0xe4,
	0xcd, 0x67, 0x88, 0x70, 0x5e, 0xba, 0x31, 0x5c, 0x25, 0x41, 0xea, 0x6b, 0x48, 0xea, 0xcb, 0xc6,
	0xb9, 0x04, 0x52, 0x3f, 0xb1, 0xbd, 0x83, 0x70, 0xeb, 0x4c, 0x7e, 0x24, 0xd8, 0xdb, 0x5c, 0xce,
	0x18, 0xa0, 0xbb, 0xdf, 0xa0, 0x45, 0xf6, 0x37, 0x06, 0xd2, 0x71, 0xa6, 0x94, 0x36, 0x68, 0x9c,
	0x80, 0x51, 0x0c, 0x5c, 0xdd, 0x4f, 0x5a, 0xe5, 0x28, 0xdb, 0xfd, 0xa4, 0x55, 0x09, 0x98, 0xad,
	0x9a, 0x94, 0x7e, 0xeb, 0x18, 0x1d, 0x5b, 0x19, 0xae, 0x5f, 0xd0, 0x60, 0x5a, 0x09, 0x4f, 0x9d,
	0x6c, 0xcc, 0xa5, 0x87, 0xd2, 0x4e, 0x36, 0xe6, 0xfa, 0x04, 0xcf, 0x4e, 0xa6, 0x0c, 0xa3, 0x68,
	0x2b, 0x94, 0x1d, 0xc9, 0x8a, 0x6c, 0x21, 0x43, 0xd4, 0xe9, 0xbe, 0x1b, 0xab, 0x94, 0xd0, 0xd9,
	0xc6, 0x71, 0x24, 0x66, 0x9a, 0xc8, 0x6a, 0x84, 0xfc, 0xea, 0x50, 0x8e, 0x9f, 0x81, 0xc1, 0xaf,
	0x93, 0x1d, 0x3f, 0x83, 0x83, 0x4a, 0xfb, 0x66, 0xaf, 0x71, 0x5c, 0xe6, 0x94, 0x24, 0xbe, 0xdf,
	0xd4, 0x60, 0x46, 0x8d, 0xb4, 0x4c, 0x96, 0x86, 0x0c, 0x02, 0x9d, 0x6c, 0x26, 0xf5, 0x0b, 0xe2,
	0xec, 0xaf, 0x41, 0xc6, 0x4b, 0x8a, 0x64, 0x09, 0x58, 0xa4, 0xeb, 0x57, 0x34, 0x98, 0x8d, 0x04,
	0x57, 0x26, 0x19, 0xda, 0x51, 0x23, 0xe8, 0x25, 0x5b, 0x45, 0xfd, 0x23, 0x37, 0x5f, 0x41, 0xd2,
	0x0c, 0xe3, 0x6c, 0x22, 0x69, 0x4b, 0x22, 0x64, 0x1d, 0x23, 0xf1, 0xdb, 0x1a, 0xcc, 0xc5, 0xe2,
	0x0a, 0x27, 0xdb, 0x42, 0xfd, 0x03, 0x41, 0x97, 0xde, 0x1c, 0xaa, 0x8e, 0xea, 0xd2, 0x23, 0xc9,
	0x3c, 0x24, 0x7f, 0xae, 0xc1, 0x99, 0x7e, 0x51, 0x8f, 0xc9, 0x7b, 0xcf, 0x15, 0xac, 0xb9, 0xf4,
	0xb9, 0x67, 0xad, 0x2e, 0xc8, 0xbf, 0x81, 0xe4, 0x2f, 0x1a, 0xaf, 0x25, 0xf3, 0x59, 0x88, 0x68,
	0x54, 0xd9, 0x7d, 0x47, 0x83, 0xf9, 0xe4, 0x58, 0xc7, 0xe4, 0xed, 0xc1, 0x04, 0x25, 0x06, 0x67,
	0x2e, 0xbd, 0x33, 0x7c, 0x45, 0xd1, 0x87, 0x9b, 0xd8, 0x87, 0x25, 0x63, 0x21, 0xa9, 0x0f, 0x4b,
	0x41, 0x60, 0x98, 0x48, 0x27, 0x96, 0xbf, 0x35, 0xa2, 0x78, 0x2d, 0xf0, 0xe6, 0x17, 0x3f, 0x6c,
	0x22, 0x3f, 0x0c, 0x63, 0xe2, 0xd7, 0xe5, 0x8c, 0x9f, 0x76, 0xea, 0xb7, 0x9a, 0xa8, 0x5f, 0x61,
	0x52, 0xb7, 0x9b, 0x78, 0x8f, 0xcd, 0x42, 0x80, 0x25, 0xfe, 0x8f, 0xf1, 0xf7, 0x87, 0x99, 0x09,
	0x32, 0xa8, 0x7d, 0xe5, 0xd3, 0x44, 0xfd, 0x4d, 0x90, 0x6c, 0xed, 0xf3, 0x6f, 0x37, 0xb1, 0xf6,
	0xbf, 0x0c, 0xa3, 0xc8, 0x8e, 0x7e, 0x8b, 0x99, 0xfc, 0x15, 0xb8, 0x7e, 0x8b, 0x99, 0xfa, 0xc1,
	0x36, 0x45, 0xe5, 0xc8, 0x8d, 0xe3, 0x6f, 0xd6, 0xf6, 0x8f, 0x69, 0x30, 0x2e, 0xbe, 0xf9, 0x45,
	0xae, 0x64, 0xfd, 0x2a, 0x59, 0x3f, 0x03, 0x28, 0xfa, 0x01, 0x31, 0xb1, 0x9a, 0x1b, 0x27, 0xa3,
	0x24, 0x88, 0xaf, 0x55, 0x31, 0xd9, 0xf8, 0xad, 0xbc, 0xe2, 0x85, 0x13, 0x4f, 0x8c, 0x18, 0x6d,
	0xa3, 0x78, 0x4c, 0x94, 0xe6, 0x05, 0x48, 0x7e, 0x69, 0x5b, 0xba, 0x96, 0x11, 0x3a, 0xdd, 0x3e,
	0x6d, 0x71, 0x38, 0xdf, 0x17, 0xc1, 0xdf, 0x75, 0x92, 0x81, 0x78, 0x95, 0x87, 0xa2, 0x69, 0xce,
	0xac, 0xd4, 0xe7, 0xa2, 0x62, 0xeb, 0x64, 0x14, 0x63, 0x74, 0x2c, 0xd5, 0x11, 0x52, 0x8c, 0x97,
	0x7f, 0x89, 0x2b, 0x4b, 0x37, 0xc3, 0x27, 0x70, 0x83, 0xc9, 0x51, 0x9f, 0x74, 0x19, 0xa7, 0x90,
	0x9c, 0xe3, 0x24, 0xce, 0x96, 0xe5, 0xbf, 0x52, 0xe7, 0xb2, 0x14, 0x42, 0x97, 0xad, 0x0f, 0xfd,
	0x9d, 0x7f, 0xa9, 0x91, 0x99, 0x93, 0x09, 0x4c, 0x8f, 0xc0, 0x6c, 0xbc, 0x81, 0x04, 0xbe, 0x4e,
	0x50, 0x99, 0x4a, 0x21, 0x7f, 0x25, 0xfb, 0x5a, 0x0d, 0x0f, 0xfc, 0xd9, 0x40, 0xff, 0x68, 0x5a,
	0xf4, 0xe5, 0xd2, 0xb5, 0x8c, 0xd0, 0x49, 0xfe, 0x51, 0x99, 0x34, 0x36, 0x84, 0x3f, 0x3d, 0xc0,
	0xbb, 0x95, 0x16, 0x55, 0x79, 0x20, 0x11, 0x91, 0xcd, 0x8f, 0xb0, 0xe7, 0x17, 0x2e, 0xc6, 0xf8,
	0x13, 0xe3, 0xcb, 0xcf, 0x6a, 0x81, 0x41, 0x3f, 0x88, 0x24, 0x75, 0x19, 0xb9, 0x96, 0x11, 0x5a,
	0x90, 0x74, 0x15, 0x49, 0x7a, 0xb5, 0x34, 0x98, 0x24, 0xa6, 0x16, 0xfe, 0x7a, 0x54, 0x75, 0x74,
	0x07, 0x01, 0xcc, 0x5c, 0xb6, 0x01, 0x11, 0xe3, 0x98, 0x1c, 0x08, 0x2a, 0xf9, 0x13, 0xe2, 0xa5,
	0xab, 0xd9, 0x80, 0x55, 0x17, 0x9b, 0x31, 0x8b, 0x8e, 0x97, 0xb0, 0x75, 0x36, 0x88, 0x3f, 0xae,
	0x78, 0xfd, 0x16, 0xfb, 0xe3, 0x8d, 0xd9, 0x3e, 0x4b, 0x99, 0xe1, 0x05, 0x29, 0x27, 0x91, 0x94,
	0x39, 0x12, 0x25, 0x85, 0xed, 0x43, 0x82, 0xf9, 0x36, 0xa0, 0x77, 0x91, 0xe9, 0x76, 0x2d, 0x23,
	0xb4, 0xa0, 0x60, 0x09, 0x29, 0x78, 0x8d, 0x5c, 0x8e, 0x50, 0x20, 0x79, 0xf8, 0xe4, 0xa8, 0x73,
	0x9f, 0xc9, 0x4e, 0xdc, 0x01, 0x63, 0xa4, 0x4a, 0xf9, 0xd5, 0x6c, 0xc0, 0xea, 0xfe, 0x7a, 0xe1,
	0x7c, 0x94, 0xac, 0x28, 0x39, 0xdf, 0xd6, 0xa0, 0xe0, 0x7f, 0xa8, 0x96, 0x0c, 0xe8, 0x7b, 0xe4,
	0xab, 0xb8, 0xa5, 0xc5, 0xac, 0xe0, 0x82, 0xa8, 0xeb, 0x48, 0xd4, 0x02, 0xb9, 0x12, 0x25, 0xea,
	0x50, 0x40, 0x46, 0xa9, 0x5b, 0xfe, 0x9f, 0xaa, 0x8b, 0x39, 0xf2, 0xd9, 0xfd, 0xaf, 0x85, 0x6a,
	0x6b, 0x69, 0x70, 0x94, 0xbe, 0x0c, 0xfb, 0x94, 0xe4, 0x0a, 0xaa, 0xd3, 0xc4, 0x38, 0xc1, 0xa8,
	0xf7, 0xed, 0xb9, 0x0e, 0x83, 0xb4, 0xb9, 0x02, 0xfb, 0x5a, 0xa8, 0x2d, 0x32, 0x90, 0xa3, 0x2a,
	0x8c, 0xeb, 0xd9, 0x2b, 0xa8, 0xe4, 0x94, 0x52, 0xc9, 0xf9, 0x99, 0xc1, 0x0e, 0x78, 0xb5, 0x81,
	0x6c, 0x5b, 0x91, 0xd4, 0x3a, 0xaa, 0xd9, 0x40, 0x12, 0xe9, 0x52, 0xd6, 0xc1, 0xeb, 0x59, 0x22,
	0x2b, 0x2a, 0x73, 0xf3, 0x8d, 0x21, 0x6a, 0x08, 0x72, 0x5e, 0x47, 0x72, 0x2e, 0x91, 0x97, 0x93,
	0xc8, 0x89, 0x1e, 0x87, 0x4b, 0x4b, 0x50, 0x86, 0x11, 0x54, 0xe7, 0xe7, 0xf5, 0xec, 0x15, 0x54,
	0xc3, 0x66, 0xe1, 0x74, 0x22, 0x69, 0x9c, 0xa4, 0xe5, 0xff, 0x30, 0x13, 0x39, 0xd5, 0x0c, 0x6e,
	0x9e, 0x64, 0x38, 0xd5, 0x4c, 0x0e, 0x7a, 0x5f, 0xba, 0x96, 0x11, 0x3a, 0xf9, 0x54, 0x33, 0x08,
	0x6c, 0x81, 0x52, 0xf6, 0xff, 0x6a, 0x41, 0xc4, 0x21, 0x32, 0x38, 0x12, 0xa8, 0xb2, 0x21, 0x5f,
	0xcc, 0x0a, 0x9e, 0x64, 0x08, 0xca, 0x74, 0xc8, 0x1b, 0xf1, 0x9f, 0x19, 0x78, 0x46, 0x96, 0x1c,
	0x37, 0x7e, 0x20, 0x53, 0x22, 0x83, 0x27, 0xe4, 0x6a, 0xe1, 0xe5, 0x18, 0x31, 0xfc, 0xff, 0xd2,
	0x57, 0x82, 0x98, 0x20, 0x9f, 0x91, 0x6f, 0x6a, 0x30, 0x11, 0xc4, 0x68, 0x4f, 0x3b, 0x7a, 0x4a,
	0x0d, 0x1c, 0x9f, 0x76, 0xf4, 0xd4, 0x27, 0xfc, 0xbb, 0xf0, 0x89, 0x19, 0xa5, 0x18, 0x75, 0xfc,
	0x9b, 0xd3, 0x56, 0x13, 0xad, 0xe6, 0x3f, 0x48, 0x73, 0x4c, 0xdd, 0x1e, 0xd0, 0x62, 0x3f, 0x67,
	0xc0, 0x9d, 0x67, 0xaa, 0x2b, 0x08, 0xbf, 0x86, 0x84, 0x5f, 0x36, 0x8c, 0x18, 0xe1, 0xd4, 0xaf,
	0x26, 0x7b, 0xac, 0xfe, 0x9f, 0xd0, 0xec, 0xbf, 0x9a, 0x31, 0x34, 0x73, 0xb6, 0xd1, 0x8e, 0x18,
	0xfd, 0xca, 0x6e, 0x4d, 0x21, 0x8b, 0x47, 0x56, 0xf1, 0x67, 0x82, 0xff, 0xc6, 0x6f, 0xe0, 0x0c,
	0x53, 0x62, 0x31, 0x0f, 0x9c, 0x09, 0x91, 0x77, 0x72, 0x7d, 0x66, 0x42, 0x9d, 0x43, 0x32, 0x7a,
	0x7e, 0x51, 0x83, 0x71, 0x11, 0x0b, 0x78, 0x20, 0x3d, 0x6a, 0xf4, 0xe2, 0x81, 0xf4, 0x44, 0x02,
	0x15, 0x47, 0x16, 0x76, 0x99, 0x1e, 0x11, 0x7f, 0x78, 0xe9, 0x2b, 0x4a, 0x7c, 0xde, 0xcf, 0xc8,
	0x2f, 0x6b, 0x30, 0x29, 0x05, 0xfa, 0x25, 0x6f, 0x64, 0x18, 0x0f, 0x35, 0x52, 0x71, 0x69, 0x79,
	0x98, 0x2a, 0xaa, 0x59, 0x64, 0x9c, 0x49, 0x1c, 0x47, 0x5a, 0x47, 0x68, 0xe1, 0xcf, 0x9b, 0x94,
	0x22, 0xe0, 0x0e, 0xa6, 0x2f, 0x16, 0xa8, 0x77, 0x30, 0x7d, 0xf1, 0x00, 0xbb, 0x7d, 0xe6, 0x6d,
	0xe0, 0x40, 0x62, 0xd4, 0xfd, 0x96, 0x4f, 0x9d, 0xd0, 0x74, 0x99, 0xa8, 0x53, 0xd5, 0xdd, 0xf2,
	0x30, 0x55, 0x04, 0x75, 0x6f, 0x23, 0x75, 0x6f, 0x2c, 0x2c, 0xa5, 0x53, 0x17, 0xa8, 0x3d, 0x29,
	0x9c, 0xef, 0x67, 0xe4, 0xef, 0x68, 0x30, 0xa3, 0x06, 0xc3, 0x25, 0x37, 0x86, 0x8c, 0x9d, 0xcb,
	0xa9, 0xbe, 0xf9, 0x4c, 0x11, 0x77, 0xfd, 0xe9, 0x4b, 0xfa, 0xb0, 0x75, 0xf9, 0xeb, 0xa0, 0x9c,
	0x39, 0x0a, 0x13, 0xf3, 0x1b, 0xe1, 0x1a, 0x9b, 0xc8, 0xb1, 0x58, 0x0d, 0x55, 0x06, 0xde, 0x1c,
	0xaa, 0x4e, 0x92, 0x9b, 0x5e, 0xd4, 0x95, 0x0d, 0xbb, 0x5f, 0x50, 0x0c, 0xbb, 0x9b, 0x99, 0x9a,
	0x88, 0x71, 0xf2, 0xad, 0x61, 0xab, 0xa9, 0xc6, 0x00, 0x49, 0x22, 0x8e, 0xfc, 0x8a, 0x64, 0xdd,
	0x65, 0xeb, 0x7a, 0xc4, 0xc0, 0xbb, 0x31, 0x5c, 0x25, 0x41, 0xd3, 0x02, 0xd2, 0xf4, 0x0a, 0x31,
	0x12, 0x68, 0x8a, 0x9a, 0x78, 0xdf, 0x08, 0x8d, 0xf4, 0x6c, 0x03, 0xaa, 0xda, 0xe9, 0x6f, 0x0e,
	0x55, 0x47, 0x1d, 0xd0, 0x52, 0xda, 0x80, 0x7e, 0x33, 0xb4, 0x59, 0xb2, 0xd1, 0xa4, 0x4e, 0xe5,
	0x37, 0x87, 0xaa, 0xa3, 0x4e, 0x89, 0x85, 0x52, 0x12, 0xcf, 0x04, 0xaf, 0x7e, 0x53, 0x03, 0xa8,
	0x86, 0xa1, 0x7b, 0xb2, 0x89, 0x4c, 0x58, 0xc1, 0xa7, 0xef, 0xed, 0xa1, 0xeb, 0x25, 0x19, 0x03,
	0x51, 0x1a, 0x45, 0xd0, 0x01, 0x41, 0x2b, 0x63, 0xe3, 0x3f, 0xd0, 0x60, 0x46, 0xa0, 0xf0, 0x85,
	0xf0, 0x76, 0x46, 0xd6, 0xc8, 0x95, 0xfa, 0xda, 0x31, 0x03, 0xeb, 0x26, 0xdd, 0xf7, 0x48, 0x21,
	0x9d, 0xfc, 0x12, 0xda, 0xce, 0x4d, 0x6a, 0xb9, 0x34, 0xe3, 0x74, 0x11, 0xd0, 0xc3, 0x4d, 0x97,
	0xa0, 0x92, 0xa0, 0xed, 0x55, 0xa4, 0xed, 0x82, 0x91, 0x48, 0x5b, 0x97, 0x03, 0xdf, 0xd6, 0x16,
	0xee, 0x9e, 0x81, 0xe3, 0x75, 0xa7, 0x15, 0x6d, 0x62, 0x57, 0xfb, 0x62, 0xde, 0xea, 0xd8, 0x8f,
	0xc6, 0x30, 0xb0, 0xc0, 0x9b, 0xff, 0x2b, 0x00, 0x00, 0xff, 0xff, 0xb3, 0x77, 0x22, 0xf8, 0xac,
	0xcd, 0x00, 0x00,
}
