# Contributing

The specification and code is licensed under the Apache 2.0 license found in
the [LICENSE](../LICENSE) file of this repository.

## Style

See the [Style Guide](../STYLEGUIDE.md).

## Sign your work

The sign-off is a simple line at the end of the explanation for the
patch, which certifies that you wrote it or otherwise have the right to
pass it on as an open-source patch.  The rules are pretty simple: if you
can certify the below (from
[developercertificate.org](http://developercertificate.org/)):

You can add the sign off when creating the git commit via:

```
git commit -s
```

then you just add a line to every git commit message:

```
Signed-off-by: Joe Smith <joe@gmail.com>
```

using your real name (sorry, no pseudonyms or anonymous contributions.)

## Pull Requests

* All code provided to openstorage should have unit tests.
* Large PRs should have first been proposed through as an issue. The PR should point back to the issue as `Implementation of #...`
* Try to keep PRs "small" to make it easy to review.

