package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlertContacts invokes the emr.ListAlertContacts API synchronously
// api document: https://help.aliyun.com/api/emr/listalertcontacts.html
func (client *Client) ListAlertContacts(request *ListAlertContactsRequest) (response *ListAlertContactsResponse, err error) {
	response = CreateListAlertContactsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlertContactsWithChan invokes the emr.ListAlertContacts API asynchronously
// api document: https://help.aliyun.com/api/emr/listalertcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAlertContactsWithChan(request *ListAlertContactsRequest) (<-chan *ListAlertContactsResponse, <-chan error) {
	responseChan := make(chan *ListAlertContactsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlertContacts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlertContactsWithCallback invokes the emr.ListAlertContacts API asynchronously
// api document: https://help.aliyun.com/api/emr/listalertcontacts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAlertContactsWithCallback(request *ListAlertContactsRequest, callback func(response *ListAlertContactsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlertContactsResponse
		var err error
		defer close(result)
		response, err = client.ListAlertContacts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlertContactsRequest is the request struct for api ListAlertContacts
type ListAlertContactsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FromApp         string           `position:"Query" name:"FromApp"`
	Ids             string           `position:"Query" name:"Ids"`
	UserId          string           `position:"Query" name:"UserId"`
}

// ListAlertContactsResponse is the response struct for api ListAlertContacts
type ListAlertContactsResponse struct {
	*responses.BaseResponse
	AlertContactList []AlertContact `json:"AlertContactList" xml:"AlertContactList"`
}

// CreateListAlertContactsRequest creates a request to invoke ListAlertContacts API
func CreateListAlertContactsRequest() (request *ListAlertContactsRequest) {
	request = &ListAlertContactsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListAlertContacts", "emr", "openAPI")
	return
}

// CreateListAlertContactsResponse creates a response to parse from ListAlertContacts response
func CreateListAlertContactsResponse() (response *ListAlertContactsResponse) {
	response = &ListAlertContactsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
