package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIndustryInfo invokes the industry_brain.GetIndustryInfo API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfo.html
func (client *Client) GetIndustryInfo(request *GetIndustryInfoRequest) (response *GetIndustryInfoResponse, err error) {
	response = CreateGetIndustryInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetIndustryInfoWithChan invokes the industry_brain.GetIndustryInfo API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIndustryInfoWithChan(request *GetIndustryInfoRequest) (<-chan *GetIndustryInfoResponse, <-chan error) {
	responseChan := make(chan *GetIndustryInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIndustryInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIndustryInfoWithCallback invokes the industry_brain.GetIndustryInfo API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getindustryinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIndustryInfoWithCallback(request *GetIndustryInfoRequest, callback func(response *GetIndustryInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIndustryInfoResponse
		var err error
		defer close(result)
		response, err = client.GetIndustryInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIndustryInfoRequest is the request struct for api GetIndustryInfo
type GetIndustryInfoRequest struct {
	*requests.RpcRequest
	IndustryCode string `position:"Query" name:"IndustryCode"`
}

// GetIndustryInfoResponse is the response struct for api GetIndustryInfo
type GetIndustryInfoResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	IndustryInfo IndustryInfo `json:"IndustryInfo" xml:"IndustryInfo"`
}

// CreateGetIndustryInfoRequest creates a request to invoke GetIndustryInfo API
func CreateGetIndustryInfoRequest() (request *GetIndustryInfoRequest) {
	request = &GetIndustryInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetIndustryInfo", "", "")
	return
}

// CreateGetIndustryInfoResponse creates a response to parse from GetIndustryInfo response
func CreateGetIndustryInfoResponse() (response *GetIndustryInfoResponse) {
	response = &GetIndustryInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
