//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rtc

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApps invokes the rtc.DescribeApps API synchronously
// api document: https://help.aliyun.com/api/rtc/describeapps.html
func (client *Client) DescribeApps(request *DescribeAppsRequest) (response *DescribeAppsResponse, err error) {
	response = CreateDescribeAppsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppsWithChan invokes the rtc.DescribeApps API asynchronously
// api document: https://help.aliyun.com/api/rtc/describeapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppsWithChan(request *DescribeAppsRequest) (<-chan *DescribeAppsResponse, <-chan error) {
	responseChan := make(chan *DescribeAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppsWithCallback invokes the rtc.DescribeApps API asynchronously
// api document: https://help.aliyun.com/api/rtc/describeapps.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAppsWithCallback(request *DescribeAppsRequest, callback func(response *DescribeAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppsResponse
		var err error
		defer close(result)
		response, err = client.DescribeApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppsRequest is the request struct for api DescribeApps
type DescribeAppsRequest struct {
	*requests.RpcRequest
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
	Status   string           `position:"Query" name:"Status"`
	Order    string           `position:"Query" name:"Order"`
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeAppsResponse is the response struct for api DescribeApps
type DescribeAppsResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	TotalNum  int                  `json:"TotalNum" xml:"TotalNum"`
	TotalPage int                  `json:"TotalPage" xml:"TotalPage"`
	AppList   DescribeAppsAppList0 `json:"AppList" xml:"AppList"`
}

type DescribeAppsAppList0 struct {
	App []DescribeAppsApp1 `json:"App" xml:"App"`
}

type DescribeAppsApp1 struct {
	Status       int      `json:"Status" xml:"Status"`
	AppId        string   `json:"AppId" xml:"AppId"`
	AppName      string   `json:"AppName" xml:"AppName"`
	CreateTime   string   `json:"CreateTime" xml:"CreateTime"`
	AppType      string   `json:"AppType" xml:"AppType"`
	BillType     string   `json:"BillType" xml:"BillType"`
	ServiceAreas []string `json:"ServiceAreas" xml:"ServiceAreas"`
}

// CreateDescribeAppsRequest creates a request to invoke DescribeApps API
func CreateDescribeAppsRequest() (request *DescribeAppsRequest) {
	request = &DescribeAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeApps", "rtc", "openAPI")
	return
}

// CreateDescribeAppsResponse creates a response to parse from DescribeApps response
func CreateDescribeAppsResponse() (response *DescribeAppsResponse) {
	response = &DescribeAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
