package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIPv6TranslatorAclList invokes the vpc.CreateIPv6TranslatorAclList API synchronously
// api document: https://help.aliyun.com/api/vpc/createipv6translatoracllist.html
func (client *Client) CreateIPv6TranslatorAclList(request *CreateIPv6TranslatorAclListRequest) (response *CreateIPv6TranslatorAclListResponse, err error) {
	response = CreateCreateIPv6TranslatorAclListResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIPv6TranslatorAclListWithChan invokes the vpc.CreateIPv6TranslatorAclList API asynchronously
// api document: https://help.aliyun.com/api/vpc/createipv6translatoracllist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateIPv6TranslatorAclListWithChan(request *CreateIPv6TranslatorAclListRequest) (<-chan *CreateIPv6TranslatorAclListResponse, <-chan error) {
	responseChan := make(chan *CreateIPv6TranslatorAclListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIPv6TranslatorAclList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIPv6TranslatorAclListWithCallback invokes the vpc.CreateIPv6TranslatorAclList API asynchronously
// api document: https://help.aliyun.com/api/vpc/createipv6translatoracllist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateIPv6TranslatorAclListWithCallback(request *CreateIPv6TranslatorAclListRequest, callback func(response *CreateIPv6TranslatorAclListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIPv6TranslatorAclListResponse
		var err error
		defer close(result)
		response, err = client.CreateIPv6TranslatorAclList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIPv6TranslatorAclListRequest is the request struct for api CreateIPv6TranslatorAclList
type CreateIPv6TranslatorAclListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AclName              string           `position:"Query" name:"AclName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateIPv6TranslatorAclListResponse is the response struct for api CreateIPv6TranslatorAclList
type CreateIPv6TranslatorAclListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	AclId     string `json:"AclId" xml:"AclId"`
}

// CreateCreateIPv6TranslatorAclListRequest creates a request to invoke CreateIPv6TranslatorAclList API
func CreateCreateIPv6TranslatorAclListRequest() (request *CreateIPv6TranslatorAclListRequest) {
	request = &CreateIPv6TranslatorAclListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateIPv6TranslatorAclList", "vpc", "openAPI")
	return
}

// CreateCreateIPv6TranslatorAclListResponse creates a response to parse from CreateIPv6TranslatorAclList response
func CreateCreateIPv6TranslatorAclListResponse() (response *CreateIPv6TranslatorAclListResponse) {
	response = &CreateIPv6TranslatorAclListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
