var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/**
 * Unwrap the result of `Promise.allSettled` call as `[fulfilledValues, rejectedReasons]` tuple.
 */
const unwrapPromiseSettledResults = (results) => {
    const fulfilledValues = results
        .filter((r) => r.status === 'fulfilled')
        .map((r) => r.value);
    const rejectedReasons = results
        .filter((r) => r.status === 'rejected')
        .map((r) => r.reason);
    return [fulfilledValues, rejectedReasons];
};
/**
 * Await `Promise.allSettled(promises)` and unwrap the resulting objects.
 *
 * `Promise.allSettled` never rejects, therefore the resulting `Promise` never rejects.
 */
export const settleAllPromises = (promises) => __awaiter(void 0, void 0, void 0, function* () {
    const results = yield Promise.allSettled(promises);
    return unwrapPromiseSettledResults(results);
});
//# sourceMappingURL=promise.js.map