# SNAFU user's guide

Once you've got a high-level idea of what SNAFU can do by looking at
the [quick example](crate) and some [more examples](guide::examples),
take a peek at [our design philosophy](guide::philosophy).

For more advanced usage, take a deeper dive into [how the `Snafu`
macro works](guide::the_macro), how to create [opaque error
types](guide::opaque), how to create [error structs](guide::structs),
how to use [generic types and lifetimes](guide::generics), and what
[attributes are available](guide::attributes).

For optional features of the crate, see our [list of feature
flags](guide::feature_flags).

If you are targeting an older release of Rust, you will be
interested in [the compatibility section](guide::compatibility).

For upgrading from a previous version, review the [upgrading
guide](guide::upgrading).

For comparisons and migration tips from another error library,
see the [comparison list](guide::comparison).
