/*
 * Application Insights JavaScript SDK - Channel, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
import { __extendsFn as __extends } from "@microsoft/applicationinsights-shims";
import { utlGetSessionStorage, utlSetSessionStorage } from "@microsoft/applicationinsights-common";
import { getJSON, arrForEach, isFunction, arrIndexOf, isString, dumpObj, isArray, getExceptionName, _throwInternal } from "@microsoft/applicationinsights-core-js";
import dynamicProto from "@microsoft/dynamicproto-js";
var BaseSendBuffer = /** @class */ (function () {
    function BaseSendBuffer(logger, config) {
        var _buffer = [];
        var _bufferFullMessageSent = false;
        this._get = function () {
            return _buffer;
        };
        this._set = function (buffer) {
            _buffer = buffer;
            return _buffer;
        };
        dynamicProto(BaseSendBuffer, this, function (_self) {
            _self.enqueue = function (payload) {
                if (_self.count() >= config.eventsLimitInMem()) {
                    // sent internal log only once per page view
                    if (!_bufferFullMessageSent) {
                        _throwInternal(logger, 2 /* eLoggingSeverity.WARNING */, 105 /* _eInternalMessageId.InMemoryStorageBufferFull */, "Maximum in-memory buffer size reached: " + _self.count(), true);
                        _bufferFullMessageSent = true;
                    }
                    return;
                }
                _buffer.push(payload);
            };
            _self.count = function () {
                return _buffer.length;
            };
            _self.size = function () {
                var size = _buffer.length;
                for (var lp = 0; lp < _buffer.length; lp++) {
                    size += _buffer[lp].length;
                }
                if (!config.emitLineDelimitedJson()) {
                    size += 2;
                }
                return size;
            };
            _self.clear = function () {
                _buffer = [];
                _bufferFullMessageSent = false;
            };
            _self.getItems = function () {
                return _buffer.slice(0);
            };
            _self.batchPayloads = function (payload) {
                if (payload && payload.length > 0) {
                    var batch = config.emitLineDelimitedJson() ?
                        payload.join("\n") :
                        "[" + payload.join(",") + "]";
                    return batch;
                }
                return null;
            };
        });
    }
// Removed Stub for BaseSendBuffer.prototype.enqueue.
// Removed Stub for BaseSendBuffer.prototype.count.
// Removed Stub for BaseSendBuffer.prototype.size.
// Removed Stub for BaseSendBuffer.prototype.clear.
// Removed Stub for BaseSendBuffer.prototype.getItems.
// Removed Stub for BaseSendBuffer.prototype.batchPayloads.
    return BaseSendBuffer;
}());
/*
 * An array based send buffer.
 */
var ArraySendBuffer = /** @class */ (function (_super) {
    __extends(ArraySendBuffer, _super);
    function ArraySendBuffer(logger, config) {
        var _this = _super.call(this, logger, config) || this;
        dynamicProto(ArraySendBuffer, _this, function (_self, _base) {
            _self.markAsSent = function (payload) {
                _base.clear();
            };
            _self.clearSent = function (payload) {
                // not supported
            };
        });
        return _this;
    }
// Removed Stub for ArraySendBuffer.prototype.markAsSent.
// Removed Stub for ArraySendBuffer.prototype.clearSent.
    return ArraySendBuffer;
}(BaseSendBuffer));
export { ArraySendBuffer };
/*
 * Session storage buffer holds a copy of all unsent items in the browser session storage.
 */
var SessionStorageSendBuffer = /** @class */ (function (_super) {
    __extends(SessionStorageSendBuffer, _super);
    function SessionStorageSendBuffer(logger, config) {
        var _this = _super.call(this, logger, config) || this;
        var _bufferFullMessageSent = false;
        dynamicProto(SessionStorageSendBuffer, _this, function (_self, _base) {
            var bufferItems = _getBuffer(SessionStorageSendBuffer.BUFFER_KEY);
            var notDeliveredItems = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
            var buffer = _self._set(bufferItems.concat(notDeliveredItems));
            // If the buffer has too many items, drop items from the end.
            if (buffer.length > SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                buffer.length = SessionStorageSendBuffer.MAX_BUFFER_SIZE;
            }
            _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, []);
            _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, buffer);
            _self.enqueue = function (payload) {
                if (_self.count() >= SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                    // sent internal log only once per page view
                    if (!_bufferFullMessageSent) {
                        _throwInternal(logger, 2 /* eLoggingSeverity.WARNING */, 67 /* _eInternalMessageId.SessionStorageBufferFull */, "Maximum buffer size reached: " + _self.count(), true);
                        _bufferFullMessageSent = true;
                    }
                    return;
                }
                _base.enqueue(payload);
                _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._get());
            };
            _self.clear = function () {
                _base.clear();
                _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._get());
                _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, []);
                _bufferFullMessageSent = false;
            };
            _self.markAsSent = function (payload) {
                _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._set(_removePayloadsFromBuffer(payload, _self._get())));
                var sentElements = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
                if (sentElements instanceof Array && payload instanceof Array) {
                    sentElements = sentElements.concat(payload);
                    if (sentElements.length > SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                        // We send telemetry normally. If the SENT_BUFFER is too big we don't add new elements
                        // until we receive a response from the backend and the buffer has free space again (see clearSent method)
                        _throwInternal(logger, 1 /* eLoggingSeverity.CRITICAL */, 67 /* _eInternalMessageId.SessionStorageBufferFull */, "Sent buffer reached its maximum size: " + sentElements.length, true);
                        sentElements.length = SessionStorageSendBuffer.MAX_BUFFER_SIZE;
                    }
                    _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, sentElements);
                }
            };
            _self.clearSent = function (payload) {
                var sentElements = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
                sentElements = _removePayloadsFromBuffer(payload, sentElements);
                _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, sentElements);
            };
            function _removePayloadsFromBuffer(payloads, buffer) {
                var remaining = [];
                arrForEach(buffer, function (value) {
                    if (!isFunction(value) && arrIndexOf(payloads, value) === -1) {
                        remaining.push(value);
                    }
                });
                return remaining;
            }
            function _getBuffer(key) {
                var prefixedKey = key;
                try {
                    prefixedKey = config.namePrefix && config.namePrefix() ? config.namePrefix() + "_" + prefixedKey : prefixedKey;
                    var bufferJson = utlGetSessionStorage(logger, prefixedKey);
                    if (bufferJson) {
                        var buffer_1 = getJSON().parse(bufferJson);
                        if (isString(buffer_1)) {
                            // When using some version prototype.js the stringify / parse cycle does not decode array's correctly
                            buffer_1 = getJSON().parse(buffer_1);
                        }
                        if (buffer_1 && isArray(buffer_1)) {
                            return buffer_1;
                        }
                    }
                }
                catch (e) {
                    _throwInternal(logger, 1 /* eLoggingSeverity.CRITICAL */, 42 /* _eInternalMessageId.FailedToRestoreStorageBuffer */, " storage key: " + prefixedKey + ", " + getExceptionName(e), { exception: dumpObj(e) });
                }
                return [];
            }
            function _setBuffer(key, buffer) {
                var prefixedKey = key;
                try {
                    prefixedKey = config.namePrefix && config.namePrefix() ? config.namePrefix() + "_" + prefixedKey : prefixedKey;
                    var bufferJson = JSON.stringify(buffer);
                    utlSetSessionStorage(logger, prefixedKey, bufferJson);
                }
                catch (e) {
                    // if there was an error, clear the buffer
                    // telemetry is stored in the _buffer array so we won't loose any items
                    utlSetSessionStorage(logger, prefixedKey, JSON.stringify([]));
                    _throwInternal(logger, 2 /* eLoggingSeverity.WARNING */, 41 /* _eInternalMessageId.FailedToSetStorageBuffer */, " storage key: " + prefixedKey + ", " + getExceptionName(e) + ". Buffer cleared", { exception: dumpObj(e) });
                }
            }
        });
        return _this;
    }
// Removed Stub for SessionStorageSendBuffer.prototype.enqueue.
// Removed Stub for SessionStorageSendBuffer.prototype.clear.
// Removed Stub for SessionStorageSendBuffer.prototype.markAsSent.
// Removed Stub for SessionStorageSendBuffer.prototype.clearSent.
    SessionStorageSendBuffer.BUFFER_KEY = "AI_buffer";
    SessionStorageSendBuffer.SENT_BUFFER_KEY = "AI_sentBuffer";
    // Maximum number of payloads stored in the buffer. If the buffer is full, new elements will be dropped.
    SessionStorageSendBuffer.MAX_BUFFER_SIZE = 2000;
    return SessionStorageSendBuffer;
}(BaseSendBuffer));
export { SessionStorageSendBuffer };
