/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeMeasurements, dataSanitizeProperties, dataSanitizeString, dataSanitizeUrl } from "./Common/DataSanitizer";
import { AjaxHelperParseDependencyPath } from "../Util";
import { msToTimeSpan } from "../HelperFuncs";
var RemoteDependencyData = /** @class */ (function () {
    /**
     * Constructs a new instance of the RemoteDependencyData object
     */
    function RemoteDependencyData(logger, id, absoluteUrl, commandName, value, success, resultCode, method, requestAPI, correlationContext, properties, measurements) {
        if (requestAPI === void 0) { requestAPI = "Ajax"; }
        this.aiDataContract = {
            id: 1 /* FieldType.Required */,
            ver: 1 /* FieldType.Required */,
            name: 0 /* FieldType.Default */,
            resultCode: 0 /* FieldType.Default */,
            duration: 0 /* FieldType.Default */,
            success: 0 /* FieldType.Default */,
            data: 0 /* FieldType.Default */,
            target: 0 /* FieldType.Default */,
            type: 0 /* FieldType.Default */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */,
            kind: 0 /* FieldType.Default */,
            value: 0 /* FieldType.Default */,
            count: 0 /* FieldType.Default */,
            min: 0 /* FieldType.Default */,
            max: 0 /* FieldType.Default */,
            stdDev: 0 /* FieldType.Default */,
            dependencyKind: 0 /* FieldType.Default */,
            dependencySource: 0 /* FieldType.Default */,
            commandName: 0 /* FieldType.Default */,
            dependencyTypeName: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self.id = id;
        _self.duration = msToTimeSpan(value);
        _self.success = success;
        _self.resultCode = resultCode + "";
        _self.type = dataSanitizeString(logger, requestAPI);
        var dependencyFields = AjaxHelperParseDependencyPath(logger, absoluteUrl, method, commandName);
        _self.data = dataSanitizeUrl(logger, commandName) || dependencyFields.data; // get a value from hosturl if commandName not available
        _self.target = dataSanitizeString(logger, dependencyFields.target);
        if (correlationContext) {
            _self.target = "".concat(_self.target, " | ").concat(correlationContext);
        }
        _self.name = dataSanitizeString(logger, dependencyFields.name);
        _self.properties = dataSanitizeProperties(logger, properties);
        _self.measurements = dataSanitizeMeasurements(logger, measurements);
    }
    RemoteDependencyData.envelopeType = "Microsoft.ApplicationInsights.{0}.RemoteDependency";
    RemoteDependencyData.dataType = "RemoteDependencyData";
    return RemoteDependencyData;
}());
export { RemoteDependencyData };
