/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */

// Licensed under the
export { Util, CorrelationIdHelper, DateTimeUtils, dateTimeUtilsNow, dateTimeUtilsDuration, UrlHelper, isInternalApplicationInsightsEndpoint, createDistributedTraceContextFromTrace } from "./Util";
export { parseConnectionString, ConnectionStringParser } from "./ConnectionStringParser";
export { RequestHeaders } from "./RequestResponseHeaders";
export { DisabledPropertyName, ProcessLegacy, SampleRate, HttpMethod, DEFAULT_BREEZE_ENDPOINT, strNotSpecified } from "./Constants";
export { Envelope } from "./Telemetry/Common/Envelope";
export { Event } from "./Telemetry/Event";
export { Exception } from "./Telemetry/Exception";
export { Metric } from "./Telemetry/Metric";
export { PageView } from "./Telemetry/PageView";
export { RemoteDependencyData } from "./Telemetry/RemoteDependencyData";
export { Trace } from "./Telemetry/Trace";
export { PageViewPerformance } from "./Telemetry/PageViewPerformance";
export { Data } from "./Telemetry/Common/Data";
export { SeverityLevel } from "./Interfaces/Contracts/SeverityLevel";
export { ConfigurationManager } from "./Interfaces/IConfig";
export { ContextTagKeys } from "./Interfaces/Contracts/ContextTagKeys";
export { DataSanitizer, dataSanitizeKeyAndAddUniqueness, dataSanitizeKey, dataSanitizeString, dataSanitizeUrl, dataSanitizeMessage, dataSanitizeException, dataSanitizeProperties, dataSanitizeMeasurements, dataSanitizeId, dataSanitizeInput, dsPadNumber } from "./Telemetry/Common/DataSanitizer";
export { TelemetryItemCreator, createTelemetryItem } from "./TelemetryItemCreator";
export { CtxTagKeys, Extensions } from "./Interfaces/PartAExtensions";
export { DistributedTracingModes } from "./Enums";
export { stringToBoolOrDefault, msToTimeSpan, getExtensionByName, isCrossOriginError } from "./HelperFuncs";
export { isBeaconsSupported as isBeaconApiSupported, createTraceParent, parseTraceParent, isValidTraceId, isValidSpanId, isValidTraceParent, isSampledFlag, formatTraceParent, findW3cTraceParent } from "@microsoft/applicationinsights-core-js";
export { createDomEvent } from "./DomHelperFuncs";
export { utlDisableStorage, utlEnableStorage, utlCanUseLocalStorage, utlGetLocalStorage, utlSetLocalStorage, utlRemoveStorage, utlCanUseSessionStorage, utlGetSessionStorageKeys, utlGetSessionStorage, utlSetSessionStorage, utlRemoveSessionStorage } from "./StorageHelperFuncs";
export { urlParseUrl, urlGetAbsoluteUrl, urlGetPathName, urlGetCompleteUrl, urlParseHost, urlParseFullHost } from "./UrlHelperFuncs";
export var PropertiesPluginIdentifier = "AppInsightsPropertiesPlugin";
export var BreezeChannelIdentifier = "AppInsightsChannelPlugin";
export var AnalyticsPluginIdentifier = "ApplicationInsightsAnalytics";
