/*
 * Application Insights JavaScript SDK - Properties Plugin, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeString } from "@microsoft/applicationinsights-common";
import { generateW3CId, getLocation } from "@microsoft/applicationinsights-core-js";
var TelemetryTrace = /** @class */ (function () {
    function TelemetryTrace(id, parentId, name, logger) {
        var _self = this;
        _self.traceID = id || generateW3CId();
        _self.parentID = parentId;
        var location = getLocation();
        if (!name && location && location.pathname) {
            name = location.pathname;
        }
        _self.name = dataSanitizeString(logger, name);
    }
    return TelemetryTrace;
}());
export { TelemetryTrace };
