/*
 * Application Insights JavaScript SDK - Properties Plugin, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
/**
 * PropertiesPlugin.ts
 * @copyright Microsoft 2018
 */
import { __extendsFn as __extends } from "@microsoft/applicationinsights-shims";
import dynamicProto from "@microsoft/dynamicproto-js";
import { BaseTelemetryPlugin, isNullOrUndefined, _InternalLogMessage, getNavigator, objForEachKey, getSetValue, _logInternalMessage } from "@microsoft/applicationinsights-core-js";
import { TelemetryContext } from "./TelemetryContext";
import { PageView, BreezeChannelIdentifier, PropertiesPluginIdentifier, createDistributedTraceContextFromTrace } from "@microsoft/applicationinsights-common";
var PropertiesPlugin = /** @class */ (function (_super) {
    __extends(PropertiesPlugin, _super);
    function PropertiesPlugin() {
        var _this = _super.call(this) || this;
        _this.priority = 110;
        _this.identifier = PropertiesPluginIdentifier;
        var _extensionConfig;
        var _distributedTraceCtx;
        var _previousTraceCtx;
        dynamicProto(PropertiesPlugin, _this, function (_self, _base) {
            _initDefaults();
            _self.initialize = function (config, core, extensions, pluginChain) {
                _base.initialize(config, core, extensions, pluginChain);
                var ctx = _self._getTelCtx();
                var identifier = _self.identifier;
                var defaultConfig = PropertiesPlugin.getDefaultConfig();
                _extensionConfig = _extensionConfig || {};
                objForEachKey(defaultConfig, function (field, value) {
                    _extensionConfig[field] = function () { return ctx.getConfig(identifier, field, value()); };
                });
                _previousTraceCtx = core.getTraceCtx(false);
                _self.context = new TelemetryContext(core, _extensionConfig, _previousTraceCtx);
                _distributedTraceCtx = createDistributedTraceContextFromTrace(_self.context.telemetryTrace, _previousTraceCtx);
                core.setTraceCtx(_distributedTraceCtx);
                _self.context.appId = function () {
                    var breezeChannel = core.getPlugin(BreezeChannelIdentifier);
                    return breezeChannel ? breezeChannel.plugin["_appId"] : null;
                };
                // Test hook to allow accessing the internal values -- explicitly not defined as an available property on the class
                _self["_extConfig"] = _extensionConfig;
            };
            /**
             * Add Part A fields to the event
             * @param event The event that needs to be processed
             */
            _self.processTelemetry = function (event, itemCtx) {
                if (isNullOrUndefined(event)) {
                    // TODO(barustum): throw an internal event once we have support for internal logging
                }
                else {
                    itemCtx = _self._getTelCtx(itemCtx);
                    // If the envelope is PageView, reset the internal message count so that we can send internal telemetry for the new page.
                    if (event.name === PageView.envelopeType) {
                        itemCtx.diagLog().resetInternalMessageCount();
                    }
                    var theContext = (_self.context || {});
                    if (theContext.session) {
                        // If customer did not provide custom session id update the session manager
                        if (typeof _self.context.session.id !== "string" && theContext.sessionManager) {
                            theContext.sessionManager.update();
                        }
                    }
                    var userCtx = theContext.user;
                    if (userCtx && !userCtx.isUserCookieSet) {
                        userCtx.update(theContext.user.id);
                    }
                    _processTelemetryInternal(event, itemCtx);
                    if (userCtx && userCtx.isNewUser) {
                        userCtx.isNewUser = false;
                        var message = new _InternalLogMessage(72 /* _eInternalMessageId.SendBrowserInfoOnUserInit */, ((getNavigator() || {}).userAgent || ""));
                        _logInternalMessage(itemCtx.diagLog(), 1 /* eLoggingSeverity.CRITICAL */, message);
                    }
                    _self.processNext(event, itemCtx);
                }
            };
            _self._doTeardown = function (unloadCtx, unloadState) {
                var core = (unloadCtx || {}).core();
                if (core && core.getTraceCtx) {
                    var traceCtx = core.getTraceCtx(false);
                    if (traceCtx === _distributedTraceCtx) {
                        core.setTraceCtx(_previousTraceCtx);
                    }
                }
                _initDefaults();
            };
            function _initDefaults() {
                _extensionConfig = null;
                _distributedTraceCtx = null;
                _previousTraceCtx = null;
            }
            function _processTelemetryInternal(evt, itemCtx) {
                // Set Part A fields
                getSetValue(evt, "tags", []);
                getSetValue(evt, "ext", {});
                var ctx = _self.context;
                ctx.applySessionContext(evt, itemCtx);
                ctx.applyApplicationContext(evt, itemCtx);
                ctx.applyDeviceContext(evt, itemCtx);
                ctx.applyOperationContext(evt, itemCtx);
                ctx.applyUserContext(evt, itemCtx);
                ctx.applyOperatingSystemContxt(evt, itemCtx);
                ctx.applyWebContext(evt, itemCtx);
                ctx.applyLocationContext(evt, itemCtx); // legacy tags
                ctx.applyInternalContext(evt, itemCtx); // legacy tags
                ctx.cleanUp(evt, itemCtx);
            }
        });
        return _this;
    }
    PropertiesPlugin.getDefaultConfig = function () {
        var defaultConfig = {
            instrumentationKey: function () { return undefined; },
            accountId: function () { return null; },
            sessionRenewalMs: function () { return 30 * 60 * 1000; },
            samplingPercentage: function () { return 100; },
            sessionExpirationMs: function () { return 24 * 60 * 60 * 1000; },
            cookieDomain: function () { return null; },
            sdkExtension: function () { return null; },
            isBrowserLinkTrackingEnabled: function () { return false; },
            appId: function () { return null; },
            getSessionId: function () { return null; },
            namePrefix: function () { return undefined; },
            sessionCookiePostfix: function () { return undefined; },
            userCookiePostfix: function () { return undefined; },
            idLength: function () { return 22; },
            getNewId: function () { return null; }
        };
        return defaultConfig;
    };
// Removed Stub for PropertiesPlugin.prototype.initialize.
// Removed Stub for PropertiesPlugin.prototype.processTelemetry.
    return PropertiesPlugin;
}(BaseTelemetryPlugin));
export default PropertiesPlugin;
