/*
 * Application Insights JavaScript SDK - Web, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import dynamicProto from "@microsoft/dynamicproto-js";
import { AppInsightsCore, hasWindow, hasDocument, isReactNative, doPerf, objForEachKey, proxyAssign, proxyFunctions, arrForEach, isString, isFunction, isNullOrUndefined, isArray, throwError, addPageUnloadEventListener, addPageHideEventListener, createUniqueNamespace, removePageUnloadEventListener, removePageHideEventListener, mergeEvtNamespace, _throwInternal, arrIndexOf } from "@microsoft/applicationinsights-core-js";
import { AnalyticsPlugin } from "@microsoft/applicationinsights-analytics-js";
import { Sender } from "@microsoft/applicationinsights-channel-js";
import { PropertiesPlugin } from "@microsoft/applicationinsights-properties-js";
import { AjaxPlugin as DependenciesPlugin } from "@microsoft/applicationinsights-dependencies-js";
import { Util, CorrelationIdHelper, UrlHelper, DateTimeUtils, ConnectionStringParser, RequestHeaders, DisabledPropertyName, ProcessLegacy, SampleRate, HttpMethod, DEFAULT_BREEZE_ENDPOINT, Envelope, Event, Exception, Metric, PageView, RemoteDependencyData, Trace, PageViewPerformance, Data, SeverityLevel, ConfigurationManager, ContextTagKeys, DataSanitizer, TelemetryItemCreator, CtxTagKeys, Extensions, DistributedTracingModes, PropertiesPluginIdentifier, BreezeChannelIdentifier, AnalyticsPluginIdentifier, parseConnectionString } from "@microsoft/applicationinsights-common";
"use strict";
var _internalSdkSrc;
// This is an exclude list of properties that should not be updated during initialization
// They include a combination of private and internal property names
var _ignoreUpdateSnippetProperties = [
    "snippet", "dependencies", "properties", "_snippetVersion", "appInsightsNew", "getSKUDefaults"
];
// Re-exposing the Common classes as Telemetry, the list was taken by reviewing the generated code for the build while using
// the previous configuration :-
// import * as Common from "@microsoft/applicationinsights-common"
// export const Telemetry = Common;
var fieldType = {
    Default: 0 /* FieldType.Default */,
    Required: 1 /* FieldType.Required */,
    Array: 2 /* FieldType.Array */,
    Hidden: 4 /* FieldType.Hidden */
};
/**
 * Telemetry type classes, e.g. PageView, Exception, etc
 */
export var Telemetry = {
    __proto__: null,
    PropertiesPluginIdentifier: PropertiesPluginIdentifier,
    BreezeChannelIdentifier: BreezeChannelIdentifier,
    AnalyticsPluginIdentifier: AnalyticsPluginIdentifier,
    Util: Util,
    CorrelationIdHelper: CorrelationIdHelper,
    UrlHelper: UrlHelper,
    DateTimeUtils: DateTimeUtils,
    ConnectionStringParser: ConnectionStringParser,
    FieldType: fieldType,
    RequestHeaders: RequestHeaders,
    DisabledPropertyName: DisabledPropertyName,
    ProcessLegacy: ProcessLegacy,
    SampleRate: SampleRate,
    HttpMethod: HttpMethod,
    DEFAULT_BREEZE_ENDPOINT: DEFAULT_BREEZE_ENDPOINT,
    Envelope: Envelope,
    Event: Event,
    Exception: Exception,
    Metric: Metric,
    PageView: PageView,
    RemoteDependencyData: RemoteDependencyData,
    Trace: Trace,
    PageViewPerformance: PageViewPerformance,
    Data: Data,
    SeverityLevel: SeverityLevel,
    ConfigurationManager: ConfigurationManager,
    ContextTagKeys: ContextTagKeys,
    DataSanitizer: DataSanitizer,
    TelemetryItemCreator: TelemetryItemCreator,
    CtxTagKeys: CtxTagKeys,
    Extensions: Extensions,
    DistributedTracingModes: DistributedTracingModes
};
/**
 * Application Insights API
 * @class Initialization
 * @implements {IApplicationInsights}
 */
var Initialization = /** @class */ (function () {
    function Initialization(snippet) {
        var _this = this;
        // NOTE!: DON'T set default values here, instead set them in the _initDefaults() function as it is also called during teardown()
        var dependencies;
        var properties;
        var _sender;
        var _snippetVersion;
        var _evtNamespace;
        var _houseKeepingNamespace;
        var _core;
        dynamicProto(Initialization, this, function (_self) {
            _initDefaults();
            // initialize the queue and config in case they are undefined
            _snippetVersion = "" + (snippet.sv || snippet.version || "");
            snippet.queue = snippet.queue || [];
            snippet.version = snippet.version || 2.0; // Default to new version
            var config = snippet.config || {};
            if (config.connectionString) {
                var cs = parseConnectionString(config.connectionString);
                var ingest = cs.ingestionendpoint;
                config.endpointUrl = ingest ? "".concat(ingest, "/v2/track") : config.endpointUrl; // only add /v2/track when from connectionstring
                config.instrumentationKey = cs.instrumentationkey || config.instrumentationKey;
            }
            _self.appInsights = new AnalyticsPlugin();
            properties = new PropertiesPlugin();
            dependencies = new DependenciesPlugin();
            _sender = new Sender();
            _core = new AppInsightsCore();
            _self.core = _core;
            var isErrMessageDisabled = isNullOrUndefined(config.disableIkeyDeprecationMessage) ? true : config.disableIkeyDeprecationMessage;
            if (!config.connectionString && !isErrMessageDisabled) {
                _throwInternal(_core.logger, 1 /* eLoggingSeverity.CRITICAL */, 106 /* _eInternalMessageId.InstrumentationKeyDeprecation */, "Instrumentation key support will end soon, see aka.ms/IkeyMigrate");
            }
            _self.snippet = snippet;
            _self.config = config;
            _getSKUDefaults();
            _self.flush = function (async) {
                if (async === void 0) { async = true; }
                doPerf(_core, function () { return "AISKU.flush"; }, function () {
                    arrForEach(_core.getTransmissionControls(), function (channels) {
                        arrForEach(channels, function (channel) {
                            channel.flush(async);
                        });
                    });
                }, null, async);
            };
            _self.onunloadFlush = function (async) {
                if (async === void 0) { async = true; }
                arrForEach(_core.getTransmissionControls(), function (channels) {
                    arrForEach(channels, function (channel) {
                        if (channel.onunloadFlush) {
                            channel.onunloadFlush();
                        }
                        else {
                            channel.flush(async);
                        }
                    });
                });
            };
            _self.loadAppInsights = function (legacyMode, logger, notificationManager) {
                if (legacyMode === void 0) { legacyMode = false; }
                function _updateSnippetProperties(snippet) {
                    if (snippet) {
                        var snippetVer = "";
                        if (!isNullOrUndefined(_snippetVersion)) {
                            snippetVer += _snippetVersion;
                        }
                        if (legacyMode) {
                            snippetVer += ".lg";
                        }
                        if (_self.context && _self.context.internal) {
                            _self.context.internal.snippetVer = snippetVer || "-";
                        }
                        // apply updated properties to the global instance (snippet)
                        objForEachKey(_self, function (field, value) {
                            if (isString(field) &&
                                !isFunction(value) &&
                                field && field[0] !== "_" && // Don't copy "internal" values
                                arrIndexOf(_ignoreUpdateSnippetProperties, field) === -1) {
                                snippet[field] = value;
                            }
                        });
                    }
                }
                // dont allow additional channels/other extensions for legacy mode; legacy mode is only to allow users to switch with no code changes!
                if (legacyMode && _self.config.extensions && _self.config.extensions.length > 0) {
                    throwError("Extensions not allowed in legacy mode");
                }
                doPerf(_self.core, function () { return "AISKU.loadAppInsights"; }, function () {
                    var extensions = [];
                    extensions.push(_sender);
                    extensions.push(properties);
                    extensions.push(dependencies);
                    extensions.push(_self.appInsights);
                    // initialize core
                    _core.initialize(_self.config, extensions, logger, notificationManager);
                    _self.context = properties.context;
                    if (_internalSdkSrc && _self.context) {
                        _self.context.internal.sdkSrc = _internalSdkSrc;
                    }
                    _updateSnippetProperties(_self.snippet);
                    // Empty queue of all api calls logged prior to sdk download
                    _self.emptyQueue();
                    _self.pollInternalLogs();
                    _self.addHousekeepingBeforeUnload(_this);
                });
                return _self;
            };
            _self.updateSnippetDefinitions = function (snippet) {
                // apply full appInsights to the global instance
                // Note: This must be called before loadAppInsights is called
                proxyAssign(snippet, _self, function (name) {
                    // Not excluding names prefixed with "_" as we need to proxy some functions like _onError
                    return name && arrIndexOf(_ignoreUpdateSnippetProperties, name) === -1;
                });
            };
            _self.emptyQueue = function () {
                // call functions that were queued before the main script was loaded
                try {
                    if (isArray(_self.snippet.queue)) {
                        // note: do not check length in the for-loop conditional in case something goes wrong and the stub methods are not overridden.
                        var length_1 = _self.snippet.queue.length;
                        for (var i = 0; i < length_1; i++) {
                            var call = _self.snippet.queue[i];
                            call();
                        }
                        _self.snippet.queue = undefined;
                        delete _self.snippet.queue;
                    }
                }
                catch (exception) {
                    var properties_1 = {};
                    if (exception && isFunction(exception.toString)) {
                        properties_1.exception = exception.toString();
                    }
                    // need from core
                    // Microsoft.ApplicationInsights._InternalLogging.throwInternal(
                    //     eLoggingSeverity.WARNING,
                    //     _eInternalMessageId.FailedToSendQueuedTelemetry,
                    //     "Failed to send queued telemetry",
                    //     properties);
                }
            };
            _self.addHousekeepingBeforeUnload = function (appInsightsInstance) {
                // Add callback to push events when the user navigates away
                if (hasWindow() || hasDocument()) {
                    var performHousekeeping = function () {
                        // Adds the ability to flush all data before the page unloads.
                        // Note: This approach tries to push a sync request with all the pending events onbeforeunload.
                        // Firefox does not respect this.Other browsers DO push out the call with < 100% hit rate.
                        // Telemetry here will help us analyze how effective this approach is.
                        // Another approach would be to make this call sync with a acceptable timeout to reduce the
                        // impact on user experience.
                        // appInsightsInstance.context._sender.triggerSend();
                        appInsightsInstance.onunloadFlush(false);
                        // Back up the current session to local storage
                        // This lets us close expired sessions after the cookies themselves expire
                        if (isFunction(_this.core.getPlugin)) {
                            var loadedPlugin = _this.core.getPlugin(PropertiesPluginIdentifier);
                            if (loadedPlugin) {
                                var propertiesPlugin = loadedPlugin.plugin;
                                if (propertiesPlugin && propertiesPlugin.context && propertiesPlugin.context._sessionManager) {
                                    propertiesPlugin.context._sessionManager.backup();
                                }
                            }
                        }
                    };
                    var added = false;
                    var excludePageUnloadEvents = appInsightsInstance.appInsights.config.disablePageUnloadEvents;
                    if (!_houseKeepingNamespace) {
                        _houseKeepingNamespace = mergeEvtNamespace(_evtNamespace, _core.evtNamespace && _core.evtNamespace());
                    }
                    if (!appInsightsInstance.appInsights.config.disableFlushOnBeforeUnload) {
                        // Hook the unload event for the document, window and body to ensure that the client events are flushed to the server
                        // As just hooking the window does not always fire (on chrome) for page navigation's.
                        if (addPageUnloadEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace)) {
                            added = true;
                        }
                        // We also need to hook the pagehide and visibilitychange events as not all versions of Safari support load/unload events.
                        if (addPageHideEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace)) {
                            added = true;
                        }
                        // A reactNative app may not have a window and therefore the beforeunload/pagehide events -- so don't
                        // log the failure in this case
                        if (!added && !isReactNative()) {
                            _throwInternal(appInsightsInstance.appInsights.core.logger, 1 /* eLoggingSeverity.CRITICAL */, 19 /* _eInternalMessageId.FailedToAddHandlerForOnBeforeUnload */, "Could not add handler for beforeunload and pagehide");
                        }
                    }
                    if (!added && !appInsightsInstance.appInsights.config.disableFlushOnUnload) {
                        // If we didn't add the normal set then attempt to add the pagehide and visibilitychange only
                        addPageHideEventListener(performHousekeeping, excludePageUnloadEvents, _houseKeepingNamespace);
                    }
                }
            };
            _self.getSender = function () {
                return _sender;
            };
            _self.unload = function (isAsync, unloadComplete, cbTimeout) {
                _self.onunloadFlush(isAsync);
                // Remove any registered event handlers
                if (_houseKeepingNamespace) {
                    removePageUnloadEventListener(null, _houseKeepingNamespace);
                    removePageHideEventListener(null, _houseKeepingNamespace);
                }
                _core.unload && _core.unload(isAsync, unloadComplete, cbTimeout);
            };
            proxyFunctions(_self, _self.appInsights, [
                "getCookieMgr",
                "trackEvent",
                "trackPageView",
                "trackPageViewPerformance",
                "trackException",
                "_onerror",
                "trackTrace",
                "trackMetric",
                "startTrackPage",
                "stopTrackPage",
                "startTrackEvent",
                "stopTrackEvent"
            ]);
            proxyFunctions(_self, _getCurrentDependencies, [
                "trackDependencyData",
                "addDependencyListener"
            ]);
            proxyFunctions(_self, _core, [
                "addTelemetryInitializer",
                "pollInternalLogs",
                "stopPollingInternalLogs",
                "getPlugin",
                "addPlugin",
                "evtNamespace",
                "addUnloadCb",
                "getTraceCtx"
            ]);
            proxyFunctions(_self, function () {
                var context = properties.context;
                return context ? context.user : null;
            }, [
                "setAuthenticatedUserContext",
                "clearAuthenticatedUserContext"
            ]);
            function _getSKUDefaults() {
                _self.config.diagnosticLogInterval =
                    _self.config.diagnosticLogInterval && _self.config.diagnosticLogInterval > 0 ? _self.config.diagnosticLogInterval : 10000;
            }
            // Using a function to support the dynamic adding / removal of plugins, so this will always return the current value
            function _getCurrentDependencies() {
                return dependencies;
            }
            function _initDefaults() {
                _evtNamespace = createUniqueNamespace("AISKU");
                _houseKeepingNamespace = null;
                dependencies = null;
                properties = null;
                _sender = null;
                _snippetVersion = null;
            }
        });
    }
    // Analytics Plugin
// Removed Stub for Initialization.prototype.getCookieMgr.
// Removed Stub for Initialization.prototype.trackEvent.
// Removed Stub for Initialization.prototype.trackPageView.
// Removed Stub for Initialization.prototype.trackPageViewPerformance.
// Removed Stub for Initialization.prototype.trackException.
// Removed Stub for Initialization.prototype._onerror.
// Removed Stub for Initialization.prototype.trackTrace.
// Removed Stub for Initialization.prototype.trackMetric.
// Removed Stub for Initialization.prototype.startTrackPage.
// Removed Stub for Initialization.prototype.stopTrackPage.
// Removed Stub for Initialization.prototype.startTrackEvent.
// Removed Stub for Initialization.prototype.stopTrackEvent.
// Removed Stub for Initialization.prototype.addTelemetryInitializer.
    // Properties Plugin
// Removed Stub for Initialization.prototype.setAuthenticatedUserContext.
// Removed Stub for Initialization.prototype.clearAuthenticatedUserContext.
    // Dependencies Plugin
// Removed Stub for Initialization.prototype.trackDependencyData.
    // Misc
// Removed Stub for Initialization.prototype.flush.
// Removed Stub for Initialization.prototype.onunloadFlush.
// Removed Stub for Initialization.prototype.loadAppInsights.
// Removed Stub for Initialization.prototype.updateSnippetDefinitions.
// Removed Stub for Initialization.prototype.emptyQueue.
// Removed Stub for Initialization.prototype.pollInternalLogs.
// Removed Stub for Initialization.prototype.stopPollingInternalLogs.
// Removed Stub for Initialization.prototype.addHousekeepingBeforeUnload.
// Removed Stub for Initialization.prototype.getSender.
// Removed Stub for Initialization.prototype.unload.
// Removed Stub for Initialization.prototype.getPlugin.
// Removed Stub for Initialization.prototype.addPlugin.
// Removed Stub for Initialization.prototype.evtNamespace.
// Removed Stub for Initialization.prototype.addUnloadCb.
// Removed Stub for Initialization.prototype.addDependencyListener.
// Removed Stub for Initialization.prototype.getTraceCtx.
    return Initialization;
}());
export { Initialization };
// tslint:disable-next-line
(function () {
    var sdkSrc = null;
    var isModule = false;
    var cdns = [
        "://js.monitor.azure.com/",
        "://az416426.vo.msecnd.net/"
    ];
    try {
        // Try and determine whether the sdk is being loaded from the CDN
        // currentScript is only valid during initial processing
        var scrpt = (document || {}).currentScript;
        if (scrpt) {
            sdkSrc = scrpt.src;
            // } else {
            //     // We need to update to at least typescript 2.9 for this to work :-(
            //     // Leaving as a stub for now so after we upgrade this breadcrumb is available
            //     let meta = import.meta;
            //     sdkSrc = (meta || {}).url;
            //     isModule = true;
        }
    }
    catch (e) {
        // eslint-disable-next-line no-empty
    }
    if (sdkSrc) {
        try {
            var url = sdkSrc.toLowerCase();
            if (url) {
                var src = "";
                for (var idx = 0; idx < cdns.length; idx++) {
                    if (url.indexOf(cdns[idx]) !== -1) {
                        src = "cdn" + (idx + 1);
                        if (url.indexOf("/scripts/") === -1) {
                            if (url.indexOf("/next/") !== -1) {
                                src += "-next";
                            }
                            else if (url.indexOf("/beta/") !== -1) {
                                src += "-beta";
                            }
                        }
                        _internalSdkSrc = src + (isModule ? ".mod" : "");
                        break;
                    }
                }
            }
        }
        catch (e) {
            // eslint-disable-next-line no-empty
        }
    }
})();
