"use strict";
/**********************************************************************
 * Copyright (c) 2023 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Main = void 0;
const code_workspace_1 = require("./code-workspace");
const devworkspace_id_1 = require("./devworkspace-id");
const node_extra_certificate_1 = require("./node-extra-certificate");
const openvsix_registry_1 = require("./openvsix-registry");
const vscode_launcher_1 = require("./vscode-launcher");
const webview_resources_1 = require("./webview-resources");
/**
 * Mandatory environment variables:
 *  env.PROJECTS_ROOT
 *  env.DEVWORKSPACE_FLATTENED_DEVFILE
 *  env.VSCODE_NODEJS_RUNTIME_DIR
 */
class Main {
    async start() {
        await new devworkspace_id_1.DevWorkspaceId().configure();
        await new openvsix_registry_1.OpenVSIXRegistry().configure();
        await new webview_resources_1.WebviewResources().configure();
        await new node_extra_certificate_1.NodeExtraCertificate().configure();
        await new code_workspace_1.CodeWorkspace().generate();
        await new vscode_launcher_1.VSCodeLauncher().launch();
    }
}
exports.Main = Main;
//# sourceMappingURL=main.js.map