export interface IDynamicProtoRollupOptions {
    tagname?: string;
    comment?: string;
    sourcemap?: boolean;
}
/**
 * Simple Rush plugin to remove code that is wrapped between specific comments, this is used to
 * remove the boilerplate code require by typescript to define methods as prototype level while
 * using @ms-dynamicProto project to support minification. This can also be used to remove "debug"
 * functions from the production code.
 */
export default function dynamicRemove(options?: IDynamicProtoRollupOptions): {
    name: string;
    renderChunk(code: string, chunk: any): any;
    transform: (code: string, id: string) => any;
};
