/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

import { localize } from 'vs/nls';
import { Extensions, IConfigurationNode, IConfigurationRegistry } from 'vs/platform/configuration/common/configurationRegistry';
import { Registry } from 'vs/platform/registry/common/platform';

const configuration: IConfigurationNode = {
	id: 'accessibility',
	title: localize('accessibilityConfigurationTitle', "Accessibility"),
	type: 'object',
	properties: {
		'accessibility.verbosity.terminal': {
			description: localize('verbosity.terminal.description', 'Provide information about how to access the terminal accessibility help menu when the terminal is focused'),
			type: 'boolean',
			default: true,
			tags: ['accessibility']
		},
		'accessibility.verbosity.diff-editor': {
			description: localize('verbosity.diff-editor.description', 'Provide information about how to navigate changes in the diff editor when it is focused'),
			type: 'boolean',
			default: true,
			tags: ['accessibility']
		},
		'accessibility.verbosity.chatInput': {
			description: localize('verbosity.chatInput.description', 'Provide information about how to access the interactive session accessibility help menu when the interactive input is focused'),
			type: 'boolean',
			default: true,
			tags: ['accessibility']
		}
	}
};

export function registerAccessibilityConfiguration() {
	const configurationRegistry = Registry.as<IConfigurationRegistry>(Extensions.Configuration);
	configurationRegistry.registerConfiguration(configuration);
}
