"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.GithubResolver = void 0;
var github_url_1 = require("./github-url");
var inversify_1 = require("inversify");
/**
 * Providing a github URL it provides a github URL object allowing to interact
 */
var GithubResolver = /** @class */ (function () {
    function GithubResolver() {
    }
    GithubResolver_1 = GithubResolver;
    GithubResolver.prototype.resolve = function (link) {
        var match = GithubResolver_1.GITHUB_URL_PATTERN.exec(link);
        if (!match) {
            throw new Error("Invalid github URL: " + link);
        }
        var repoUser = this.getGroup(match, 'repoUser');
        var repoName = this.getGroup(match, 'repoName');
        var branchName = this.getGroup(match, 'branchName', 'HEAD');
        var subFolder = this.getGroup(match, 'subFolder');
        return new github_url_1.GithubUrl(repoUser, repoName, branchName, subFolder);
    };
    GithubResolver.prototype.getGroup = function (match, groupName, defaultValue) {
        if (match.groups && match.groups[groupName]) {
            return match.groups[groupName];
        }
        return defaultValue || '';
    };
    var GithubResolver_1;
    // eslint-disable-next-line max-len
    GithubResolver.GITHUB_URL_PATTERN = /^(?:http)(?:s)?(?:\:\/\/)github\.com\/(?<repoUser>[^\/]+)\/(?<repoName>[^\/]+)((\/)|(?:\/(blob|tree)\/(?<branchName>[^\/]+)(?:\/(?<subFolder>.*))?))?$/;
    GithubResolver = GithubResolver_1 = __decorate([
        (0, inversify_1.injectable)()
    ], GithubResolver);
    return GithubResolver;
}());
exports.GithubResolver = GithubResolver;
//# sourceMappingURL=github-resolver.js.map