"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.Main = void 0;
var axios = __importStar(require("axios"));
var fs = __importStar(require("fs-extra"));
var generate_1 = require("./generate");
var github_resolver_1 = require("./github/github-resolver");
var jsYaml = __importStar(require("js-yaml"));
var inversify_binding_1 = require("./inversify/inversify-binding");
var url_fetcher_1 = require("./fetch/url-fetcher");
var plugin_registry_resolver_1 = require("./plugin-registry/plugin-registry-resolver");
var Main = /** @class */ (function () {
    function Main() {
    }
    Main.prototype.doStart = function () {
        return __awaiter(this, void 0, void 0, function () {
            var devfilePath, devfileUrl, outputFile, editorPath, pluginRegistryUrl, editorEntry, projects, args, axiosInstance, inversifyBinbding, container, devfileContent, editorContent, githubResolver, githubUrl, devfileParsed, editorDevfile, generate;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        projects = [];
                        args = process.argv.slice(2);
                        args.forEach(function (arg) {
                            if (arg.startsWith('--devfile-path:')) {
                                devfilePath = arg.substring('--devfile-path:'.length);
                            }
                            if (arg.startsWith('--devfile-url:')) {
                                devfileUrl = arg.substring('--devfile-url:'.length);
                            }
                            if (arg.startsWith('--plugin-registry-url:')) {
                                pluginRegistryUrl = arg.substring('--plugin-registry-url:'.length);
                            }
                            if (arg.startsWith('--editor-entry:')) {
                                editorEntry = arg.substring('--editor-entry:'.length);
                            }
                            if (arg.startsWith('--editor-path:')) {
                                editorPath = arg.substring('--editor-path:'.length);
                            }
                            if (arg.startsWith('--output-file:')) {
                                outputFile = arg.substring('--output-file:'.length);
                            }
                            if (arg.startsWith('--project.')) {
                                var name = arg.substring('--project.'.length, arg.indexOf('='));
                                var location = arg.substring(arg.indexOf('=') + 1);
                                projects.push({ name: name, location: location });
                            }
                        });
                        if (!editorPath && !editorEntry) {
                            throw new Error('missing --editor-path: or --editor-entry: parameter');
                        }
                        if (editorEntry && !pluginRegistryUrl) {
                            pluginRegistryUrl = 'https://eclipse-che.github.io/che-plugin-registry/main/v3';
                            console.log("No plug-in registry url. Setting to " + pluginRegistryUrl);
                        }
                        if (!devfilePath && !devfileUrl) {
                            throw new Error('missing --devfile-path: or --devfile-url: parameter');
                        }
                        if (!outputFile) {
                            throw new Error('missing --output-file: parameter');
                        }
                        axiosInstance = axios["default"];
                        inversifyBinbding = new inversify_binding_1.InversifyBinding();
                        return [4 /*yield*/, inversifyBinbding.initBindings({
                                pluginRegistryUrl: pluginRegistryUrl,
                                insertDevWorkspaceTemplatesAsPlugin: true,
                                axiosInstance: axiosInstance
                            })];
                    case 1:
                        container = _a.sent();
                        container.bind(generate_1.Generate).toSelf().inSingletonScope();
                        if (!devfileUrl) return [3 /*break*/, 3];
                        githubResolver = container.get(github_resolver_1.GithubResolver);
                        githubUrl = githubResolver.resolve(devfileUrl);
                        return [4 /*yield*/, container.get(url_fetcher_1.UrlFetcher).fetchText(githubUrl.getContentUrl('devfile.yaml'))];
                    case 2:
                        // user devfile
                        devfileContent = _a.sent();
                        devfileParsed = jsYaml.load(devfileContent);
                        // is there projects in the devfile ?
                        if (devfileParsed && !devfileParsed.projects) {
                            // no, so add the current project being cloned
                            devfileParsed.projects = [
                                {
                                    name: githubUrl.getRepoName(),
                                    git: {
                                        remotes: { origin: githubUrl.getCloneUrl() },
                                        checkoutFrom: { revision: githubUrl.getBranchName() }
                                    }
                                },
                            ];
                        }
                        // get back the content
                        devfileContent = jsYaml.dump(devfileParsed);
                        return [3 /*break*/, 5];
                    case 3: return [4 /*yield*/, fs.readFile(devfilePath)];
                    case 4:
                        devfileContent = _a.sent();
                        _a.label = 5;
                    case 5:
                        // enhance projects
                        devfileContent = this.replaceIfExistingProjects(devfileContent, projects);
                        if (!editorEntry) return [3 /*break*/, 7];
                        return [4 /*yield*/, container.get(plugin_registry_resolver_1.PluginRegistryResolver).loadDevfilePlugin(editorEntry)];
                    case 6:
                        editorDevfile = _a.sent();
                        editorContent = jsYaml.dump(editorDevfile);
                        return [3 /*break*/, 9];
                    case 7: return [4 /*yield*/, fs.readFile(editorPath)];
                    case 8:
                        editorContent = _a.sent();
                        _a.label = 9;
                    case 9:
                        generate = container.get(generate_1.Generate);
                        return [2 /*return*/, generate.generate(devfileContent, editorContent, outputFile)];
                }
            });
        });
    };
    Main.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            var error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.doStart()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, true];
                    case 2:
                        error_1 = _a.sent();
                        console.error('stack=' + error_1.stack);
                        console.error('Unable to start', error_1);
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    // Update project entry based on the projects passed as parameter
    Main.prototype.replaceIfExistingProjects = function (devfileContent, projects) {
        // do nothing if no override
        if (projects.length === 0) {
            return devfileContent;
        }
        var devfileParsed = jsYaml.load(devfileContent);
        if (!devfileParsed || !devfileParsed.projects) {
            return devfileContent;
        }
        devfileParsed.projects = devfileParsed.projects.map(function (project) {
            var userProjectConfiguration = projects.find(function (p) { return p.name === project.name; });
            if (userProjectConfiguration) {
                if (userProjectConfiguration.location.endsWith('.zip')) {
                    // delete git section and use instead zip
                    delete project.git;
                    project.zip = { location: userProjectConfiguration.location };
                }
                else {
                    project.git.remotes.origin = userProjectConfiguration.location;
                }
            }
            return project;
        });
        return jsYaml.dump(devfileParsed);
    };
    return Main;
}());
exports.Main = Main;
//# sourceMappingURL=main.js.map