"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheTheiaComponentUpdater = void 0;
const inversify_1 = require("inversify");
const che_theia_component_finder_1 = require("./che-theia-component-finder");
let CheTheiaComponentUpdater = class CheTheiaComponentUpdater {
    async insert(devfileContext, cheTheiaExtensions) {
        // skip stuff if no extensions need to be installed in che-theia component
        if (cheTheiaExtensions.length === 0) {
            return;
        }
        const theiaComponent = await this.cheTheiaComponentFinder.find(devfileContext);
        // add attributes
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        let attributes = theiaComponent.attributes;
        if (!attributes) {
            attributes = {};
            theiaComponent.attributes = attributes;
        }
        // grab list of extensions
        const cheTheiaVsix = cheTheiaExtensions
            .map(extension => extension.extensions)
            .reduce((acc, val) => acc.concat(val), []);
        // grab list of extensions
        const cheTheiaPreferencesArray = cheTheiaExtensions.map(extension => extension.preferences);
        const cheTheiaPreferences = Object.assign({}, ...cheTheiaPreferencesArray);
        attributes['che-theia.eclipse.org/vscode-extensions'] = cheTheiaVsix;
        // add preferences only if there are one
        if (cheTheiaPreferences && Object.keys(cheTheiaPreferences).length > 0) {
            attributes['che-theia.eclipse.org/vscode-preferences'] = cheTheiaPreferences;
        }
    }
};
__decorate([
    inversify_1.inject(che_theia_component_finder_1.CheTheiaComponentFinder),
    __metadata("design:type", che_theia_component_finder_1.CheTheiaComponentFinder)
], CheTheiaComponentUpdater.prototype, "cheTheiaComponentFinder", void 0);
CheTheiaComponentUpdater = __decorate([
    inversify_1.injectable()
], CheTheiaComponentUpdater);
exports.CheTheiaComponentUpdater = CheTheiaComponentUpdater;
//# sourceMappingURL=che-theia-component-updater.js.map