/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { VSCodeExtensionEntry, VSCodeExtensionEntryWithSidecar } from '../api/vscode-extension-entry';
import { DevfileContext } from '../api/devfile-context';
import { VSCodeExtensionDevContainer } from './vscode-extension-dev-container';
/**
 * This class is responsible to:
 *  - add annotations about vsix files to add on che-theia component
 *  - add sidecar components + their vsix files
 *  - add vsix installer component
 */
export declare class DevWorkspaceUpdater {
    private sidecarComponentsCreator;
    private cheTheiaComponentUpdater;
    private devContainerComponentUpdater;
    private insertTemplates;
    update(devfileContext: DevfileContext, cheTheiaExtensions: VSCodeExtensionEntry[], extensionsWithSidecars: VSCodeExtensionEntryWithSidecar[], extensionsForDevContainer: VSCodeExtensionDevContainer | undefined): Promise<void>;
}
//# sourceMappingURL=devworkspace-updater.d.ts.map