/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SdkScope;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\b\u0010!\u001a\u00020\"H\u0016J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "component1", "component2", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "copy", "dependencies", "", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.core"})
public final class SdkInfo
implements IdeaModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        String string = this.sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.name");
        objectArray[0] = string;
        return KotlinIdeaAnalysisBundle.message("sdk.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new SdkScope(this.getProject(), this.sdk);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    public SdkInfo(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        this.project = project;
        this.sdk = sdk;
        Name name = Name.special((String)("<sdk " + this.sdk.getName() + '>'));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.special(\"<sdk ${sdk.name}>\")");
        this.name = name;
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Nullable
    public Name getStableName() {
        return IdeaModuleInfo.DefaultImpls.getStableName(this);
    }

    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @NotNull
    public final Sdk component2() {
        return this.sdk;
    }

    @NotNull
    public final SdkInfo copy(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        return new SdkInfo(project, sdk);
    }

    public static /* synthetic */ SdkInfo copy$default(SdkInfo sdkInfo, Project project, Sdk sdk, int n, Object object) {
        if ((n & 1) != 0) {
            project = sdkInfo.getProject();
        }
        if ((n & 2) != 0) {
            sdk = sdkInfo.sdk;
        }
        return sdkInfo.copy(project, sdk);
    }

    @NotNull
    public String toString() {
        return "SdkInfo(project=" + this.getProject() + ", sdk=" + this.sdk + ")";
    }

    public int hashCode() {
        Project project = this.getProject();
        Sdk sdk = this.sdk;
        return (project != null ? project.hashCode() : 0) * 31 + (sdk != null ? sdk.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SdkInfo)) break block3;
                SdkInfo sdkInfo = (SdkInfo)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)sdkInfo.getProject()) || !Intrinsics.areEqual((Object)this.sdk, (Object)sdkInfo.sdk)) break block3;
            }
            return true;
        }
        return false;
    }
}

