/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001eH\u0007J\u0015\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0002J\u0015\u0010(\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b)J\u0016\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010-\u001a\u00020.2\u0006\u0010!\u001a\u00020\u0004H\u0002J\f\u0010/\u001a\u00020\u0004*\u000200H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "FUS_RECORDER", "", "IDEA_HEADLESS_STATISTICS_DEVICE_ID", "IDEA_HEADLESS_STATISTICS_SALT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$intellij_platform_statistics", "()Lcom/intellij/openapi/diagnostic/Logger;", "SALT_PREFERENCE_KEY", "bucket", "", "getBucket$annotations", "getBucket", "()I", "build", "getBuild", "()Ljava/lang/String;", "build$delegate", "Lkotlin/Lazy;", "configurations", "", "Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "defaultConfiguration", "anonymize", "data", "getEventLogDataPath", "Ljava/nio/file/Path;", "getEventLogSettingsPath", "getHeadlessDeviceIdProperty", "recorderId", "getHeadlessDeviceIdProperty$intellij_platform_statistics", "getHeadlessSaltProperty", "getHeadlessSaltProperty$intellij_platform_statistics", "getOrCreate", "getRecorderBasedProperty", "property", "getSaltPropertyKey", "getSaltPropertyKey$intellij_platform_statistics", "hashSha256", "salt", "", "isDefaultRecorderId", "", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogConfiguration {
    @NotNull
    private static final Logger LOG;
    private static final String FUS_RECORDER = "FUS";
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    private static final String IDEA_HEADLESS_STATISTICS_DEVICE_ID = "idea.headless.statistics.device.id";
    private static final String IDEA_HEADLESS_STATISTICS_SALT = "idea.headless.statistics.salt";
    private static final EventLogRecorderConfiguration defaultConfiguration;
    private static final Map<String, EventLogRecorderConfiguration> configurations;
    @NotNull
    private static final Lazy build$delegate;
    private static final int bucket;
    public static final EventLogConfiguration INSTANCE;

    @NotNull
    public final Logger getLOG$intellij_platform_statistics() {
        return LOG;
    }

    @NotNull
    public final String getBuild() {
        Lazy lazy = build$delegate;
        EventLogConfiguration eventLogConfiguration = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Deprecated(message="Use bucket from configuration created with getOrCreate method")
    public static /* synthetic */ void getBucket$annotations() {
    }

    public final int getBucket() {
        return bucket;
    }

    @Deprecated(message="Call method on configuration created with getOrCreate method")
    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return defaultConfiguration.anonymize(data);
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.asStringWithoutProductCodeAndSnapshot()");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final EventLogRecorderConfiguration getOrCreate(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (this.isDefaultRecorderId(recorderId)) {
            return defaultConfiguration;
        }
        EventLogConfiguration eventLogConfiguration = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (eventLogConfiguration) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl3 = false;
            Map<String, EventLogRecorderConfiguration> map = configurations;
            String key$iv = recorderId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                EventLogRecorderConfiguration answer$iv = new EventLogRecorderConfiguration(recorderId);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            EventLogRecorderConfiguration eventLogRecorderConfiguration = (EventLogRecorderConfiguration)object;
            return eventLogRecorderConfiguration;
        }
    }

    @NotNull
    public final String hashSha256(@NotNull byte[] salt, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        MessageDigest md = DigestUtil.sha256();
        md.update(salt);
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        md.update(byArray);
        String string2 = StringUtil.toHexString((byte[])md.digest());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.toHexString(md.digest())");
        return string2;
    }

    @NotNull
    public final Path getEventLogDataPath() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log-data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026resolve(\"event-log-data\")");
        return path;
    }

    @JvmStatic
    @NotNull
    public static final Path getEventLogSettingsPath() {
        Path path = INSTANCE.getEventLogDataPath().resolve("settings");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getEventLogDataPath().resolve(\"settings\")");
        return path;
    }

    @NotNull
    public final String getSaltPropertyKey$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.isDefaultRecorderId(recorderId) ? SALT_PREFERENCE_KEY : StringUtil.toLowerCase((String)recorderId) + "_" + SALT_PREFERENCE_KEY;
    }

    @NotNull
    public final String getHeadlessDeviceIdProperty$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_DEVICE_ID);
    }

    @NotNull
    public final String getHeadlessSaltProperty$intellij_platform_statistics(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_SALT);
    }

    private final String getRecorderBasedProperty(String recorderId, String property) {
        return this.isDefaultRecorderId(recorderId) ? property : property + "." + StringUtil.toLowerCase((String)recorderId);
    }

    private final boolean isDefaultRecorderId(String recorderId) {
        return Intrinsics.areEqual((Object)FUS_RECORDER, (Object)recorderId);
    }

    private EventLogConfiguration() {
    }

    static {
        EventLogConfiguration eventLogConfiguration;
        INSTANCE = eventLogConfiguration = new EventLogConfiguration();
        Logger logger2 = Logger.getInstance(EventLogConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Event\u2026onfiguration::class.java)");
        LOG = logger2;
        defaultConfiguration = new EventLogRecorderConfiguration(FUS_RECORDER);
        configurations = new HashMap();
        build$delegate = LazyKt.lazy((Function0)build.2.INSTANCE);
        bucket = defaultConfiguration.getBucket();
    }

    public static final /* synthetic */ String access$asBuildNumber(EventLogConfiguration $this, BuildNumber $this$access_u24asBuildNumber) {
        return $this.asBuildNumber($this$access_u24asBuildNumber);
    }
}

