/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.UtilKt;
import org.jetbrains.plugins.groovy.annotator.intentions.AddParenthesisToLambdaParameterAction;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrRemoveModifierFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator30;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkDefaultModifier", "", "modifierList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/GrModifierList;", "checkSingleArgumentLambda", "lambda", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "visitLambdaExpression", "expression", "visitModifierList", "intellij.groovy.psi"})
public final class GroovyAnnotator30
extends GroovyElementVisitor {
    private final AnnotationHolder holder;

    @Override
    public void visitModifierList(@NotNull GrModifierList modifierList) {
        Intrinsics.checkNotNullParameter((Object)modifierList, (String)"modifierList");
        this.checkDefaultModifier(modifierList);
    }

    private final void checkDefaultModifier(GrModifierList modifierList) {
        block5: {
            PsiElement modifier;
            block4: {
                PsiElement psiElement = modifierList.getModifier("default");
                if (psiElement == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"modifierList.getModifier\u2026difier.DEFAULT) ?: return");
                modifier = psiElement;
                PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)modifier, PsiClass.class);
                if (psiClass == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"PsiTreeUtil.getParentOfT\u2026ss::class.java) ?: return");
                PsiClass parentClass = psiClass;
                if (!parentClass.isInterface()) break block4;
                PsiClass psiClass2 = parentClass;
                if (!(psiClass2 instanceof GrTypeDefinition)) {
                    psiClass2 = null;
                }
                GrTypeDefinition grTypeDefinition = (GrTypeDefinition)psiClass2;
                if (grTypeDefinition == null) break block5;
                if (!grTypeDefinition.isTrait()) break block5;
            }
            String string = GroovyBundle.message("illegal.default.modifier", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"illegal.default.modifier\")");
            String message = string;
            AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.WARNING, message).range(modifier);
            Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"holder.newAnnotation(Hig\u2026 message).range(modifier)");
            AnnotationBuilder builder = annotationBuilder;
            LocalQuickFix localQuickFix = new GrRemoveModifierFix("default", GroovyBundle.message("illegal.default.modifier.fix", new Object[0]));
            TextRange textRange = modifier.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"modifier.textRange");
            builder = UtilKt.registerLocalFix(builder, localQuickFix, modifier, message, ProblemHighlightType.WARNING, textRange);
            builder.create();
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkSingleArgumentLambda(expression);
        super.visitLambdaExpression(expression);
    }

    private final void checkSingleArgumentLambda(GrLambdaExpression lambda2) {
        GrParameterList grParameterList = lambda2.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"lambda.parameterList");
        GrParameterList parameterList = grParameterList;
        if (parameterList.getLParen() != null) {
            return;
        }
        PsiElement parent2 = lambda2.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariable || psiElement instanceof GrParenthesizedExpression) {
            return;
        }
        if (psiElement instanceof GrArgumentList && ((GrArgumentList)parent2).getParent() instanceof GrMethodCallExpression) {
            return;
        }
        this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("illegal.single.argument.lambda", new Object[0])).range((PsiElement)parameterList).withFix((IntentionAction)new AddParenthesisToLambdaParameterAction(lambda2)).create();
    }

    public GroovyAnnotator30(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }
}

