/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.AnnotationFixRegistrar;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighterFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.ReferenceFixesKt;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"illegalJvmNameSymbols", "Lkotlin/text/Regex;", "getIllegalJvmNameSymbols", "()Lkotlin/text/Regex;", "checkInnerClassReferenceFromInstanceContext", "", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "checkUnresolvedCodeReference", "annotationHolder", "isResolvedStaticImport", "", "refElement", "intellij.groovy.psi"})
public final class ImplKt {
    @NotNull
    private static final Regex illegalJvmNameSymbols;

    public static final void checkUnresolvedCodeReference(@NotNull GrCodeReferenceElement ref, @NotNull AnnotationHolder annotationHolder) {
        IntentionAction it;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"annotationHolder");
        AnnotationSession annotationSession = annotationHolder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"annotationHolder.currentAnnotationSession");
        if (!GrReferenceHighlighterFactory.shouldHighlight(annotationSession.getFile())) {
            return;
        }
        PsiElement $this$parentOfType$iv = ref;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GroovyDocPsiElement.class, (boolean)true) != null) {
            return;
        }
        if (ref.getParent() instanceof GrPackageDefinition) {
            return;
        }
        PsiElement psiElement = ref.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ref.referenceNameElement ?: return");
        PsiElement nameElement = psiElement;
        String string = ref.getReferenceName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.referenceName ?: return");
        String referenceName = string;
        if (ImplKt.isResolvedStaticImport(ref)) {
            return;
        }
        if (ref.resolve() != null) {
            return;
        }
        AnnotationBuilder annotationBuilder = annotationHolder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.resolve", referenceName)).range(nameElement).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"annotationHolder.newAnno\u2026Type.LIKE_UNKNOWN_SYMBOL)");
        AnnotationBuilder builder = annotationBuilder;
        Iterable $this$forEach$iv = ReferenceFixesKt.generateCreateClassActions(ref);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IntentionAction)element$iv;
            boolean bl = false;
            builder.withFix(it);
        }
        $this$forEach$iv = ReferenceFixesKt.generateAddImportActions(ref);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IntentionAction)element$iv;
            boolean bl = false;
            builder.withFix(it);
        }
        AnnotationFixRegistrar fixRegistrar = new AnnotationFixRegistrar(builder);
        UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)((PsiReference)ref), (QuickFixActionRegistrar)fixRegistrar);
        QuickFixFactory.getInstance().registerOrderEntryFixes((QuickFixActionRegistrar)fixRegistrar, (PsiReference)ref);
        builder.create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isResolvedStaticImport(GrCodeReferenceElement refElement) {
        PsiElement parent2 = refElement.getParent();
        if (!(parent2 instanceof GrImportStatement)) return false;
        if (!((GrImportStatement)parent2).isStatic()) return false;
        GroovyResolveResult[] groovyResolveResultArray = refElement.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResultArray, (String)"refElement.multiResolve(false)");
        GroovyResolveResult[] groovyResolveResultArray2 = groovyResolveResultArray;
        boolean bl = false;
        GroovyResolveResult[] groovyResolveResultArray3 = groovyResolveResultArray2;
        boolean bl2 = false;
        if (groovyResolveResultArray3.length != 0) return true;
        return false;
    }

    public static final void checkInnerClassReferenceFromInstanceContext(@NotNull GrCodeReferenceElement ref, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElement psiElement = ref.getReferenceNameElement();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ref.referenceNameElement ?: return");
        PsiElement nameElement = psiElement;
        PsiElement parent2 = ref.getParent();
        if (!(parent2 instanceof GrNewExpression) || PsiImplUtil.hasArguments((GrCall)parent2)) {
            return;
        }
        if (!GrStaticChecker.isInStaticContext(ref)) {
            return;
        }
        PsiElement psiElement2 = ref.resolve();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass = (PsiClass)psiElement2;
        if (psiClass == null) {
            return;
        }
        PsiClass resolved = psiClass;
        if (!com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)resolved)) {
            return;
        }
        String string = resolved.getQualifiedName();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolved.qualifiedName ?: return");
        String qname = string;
        PsiClass psiClass2 = resolved.getContainingClass();
        if (psiClass2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"resolved.containingClass ?: return");
        PsiClass outerClass = psiClass2;
        if (PsiUtil.hasEnclosingInstanceInScope(outerClass, parent2, true)) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("cannot.reference.non.static", qname)).range(nameElement).create();
    }

    @NotNull
    public static final Regex getIllegalJvmNameSymbols() {
        return illegalJvmNameSymbols;
    }

    static {
        String string = "[.;\\[/<>:]";
        boolean bl = false;
        illegalJvmNameSymbols = new Regex(string);
    }
}

