/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.rename.GrRenameHelper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/impl/DefaultRenameHelper;", "Lorg/jetbrains/plugins/groovy/refactoring/rename/GrRenameHelper;", "()V", "getNewMemberName", "", "member", "Lcom/intellij/psi/PsiMember;", "newOriginalName", "isQualificationNeeded", "", "manager", "Lcom/intellij/psi/PsiManager;", "before", "Lcom/intellij/psi/PsiElement;", "after", "intellij.groovy"})
public final class DefaultRenameHelper
implements GrRenameHelper {
    @Override
    @Nullable
    public String getNewMemberName(@NotNull PsiMember member, @NotNull String newOriginalName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)newOriginalName, (String)"newOriginalName");
        if (!(member instanceof GrAccessorMethod)) {
            return null;
        }
        if (((GrAccessorMethod)member).isSetter()) {
            string = GroovyPropertyUtils.getSetterName(newOriginalName);
        } else {
            String string2 = ((GrAccessorMethod)member).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"member.name");
            string = GroovyPropertyUtils.getAccessorName(StringsKt.startsWith$default((String)string2, (String)"is", (boolean)false, (int)2, null) ? "is" : "get", newOriginalName);
        }
        return string;
    }

    @Override
    public boolean isQualificationNeeded(@NotNull PsiManager manager, @NotNull PsiElement before, @NotNull PsiElement after) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return before instanceof GrAccessorMethod && (!(after instanceof GrAccessorMethod) || !manager.areElementsEquivalent((PsiElement)((GrAccessorMethod)before).getProperty(), (PsiElement)((GrAccessorMethod)after).getProperty()));
    }
}

