/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Preconditions;

public final class Iterables {
    private Iterables() {
    }

    public static boolean isNullOrEmpty(@Nullable Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        return !iterable.iterator().hasNext();
    }

    public static int sizeOf(@Nonnull Iterable<?> iterable) {
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ++size;
            iterator.next();
        }
        return size;
    }

    public static <T> List<T> nonNullElementsIn(Iterable<T> i) {
        if (Iterables.isNullOrEmpty(i)) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNull = new ArrayList<T>();
        for (T element : i) {
            if (element == null) continue;
            nonNull.add(element);
        }
        return nonNull;
    }
}

