/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ArgumentsKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.InternalArgument;
import org.jetbrains.kotlin.cli.common.arguments.ManualLanguageFeatureSetting;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a!\u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\n\u00a2\u0006\u0002\u0010\f\u001a#\u0010\r\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u000b*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\f\u001a9\u0010\u000e\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u0007*\u00020\u000f2\u0006\u0010\u0006\u001a\u0002H\n2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0014\u001a!\u0010\u0015\u001a\u00020\t\"\b\b\u0000\u0010\n*\u00020\u0007*\u00020\u000f2\u0006\u0010\u0006\u001a\u0002H\n\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"KOTLIN_HOME_PROPERTY", "", "computeKotlinPaths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "reportArgumentParseProblems", "", "A", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/cli/common/arguments/CommonToolArguments;)V", "reportUnsafeInternalArgumentsIfAny", "setupCommonArguments", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "createMetadataVersion", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lkotlin/jvm/functions/Function1;)V", "setupLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)V", "cli"})
public final class ArgumentsKt {
    @NotNull
    public static final String KOTLIN_HOME_PROPERTY = "kotlin.home";

    public static final <A extends CommonCompilerArguments> void setupCommonArguments(@NotNull CompilerConfiguration $receiver, @NotNull A arguments2, @Nullable Function1<? super int[], ? extends BinaryVersion> createMetadataVersion) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        $receiver.put(CommonConfigurationKeys.DISABLE_INLINE, arguments2.getNoInline());
        $receiver.put(CommonConfigurationKeys.USE_FIR, arguments2.getUseFir());
        $receiver.put(CommonConfigurationKeys.EXPECT_ACTUAL_LINKER, arguments2.getExpectActualLinker());
        $receiver.putIfNotNull(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, arguments2.getIntellijPluginRoot());
        $receiver.put(CommonConfigurationKeys.REPORT_OUTPUT_FILES, arguments2.getReportOutputFiles());
        $receiver.put(CommonConfigurationKeys.DESERIALIZE_FAKE_OVERRIDES, arguments2.getDeserializeFakeOverrides());
        String metadataVersionString = arguments2.getMetadataVersion();
        if (metadataVersionString != null) {
            int[] versionArray = BinaryVersion.Companion.parseVersionArray(metadataVersionString);
            MessageCollector messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (versionArray == null) {
                messageCollector.report(CompilerMessageSeverity.ERROR, "Invalid metadata version: " + metadataVersionString, null);
            } else {
                if (createMetadataVersion == null) {
                    throw (Throwable)new IllegalStateException("Unable to create metadata version: missing argument");
                }
                $receiver.put(CommonConfigurationKeys.METADATA_VERSION, createMetadataVersion.invoke((int[])versionArray));
            }
        }
        ArgumentsKt.setupLanguageVersionSettings($receiver, arguments2);
    }

    public static /* synthetic */ void setupCommonArguments$default(CompilerConfiguration compilerConfiguration, CommonCompilerArguments commonCompilerArguments, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        ArgumentsKt.setupCommonArguments(compilerConfiguration, commonCompilerArguments, function1);
    }

    public static final <A extends CommonCompilerArguments> void setupLanguageVersionSettings(@NotNull CompilerConfiguration $receiver, @NotNull A arguments2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        MessageCollector messageCollector = $receiver.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector, "getNotNull(CLIConfigurat\u2026ys.MESSAGE_COLLECTOR_KEY)");
        CommonConfigurationKeysKt.setLanguageVersionSettings($receiver, arguments2.toLanguageVersionSettings(messageCollector));
    }

    @Nullable
    public static final KotlinPaths computeKotlinPaths(@NotNull MessageCollector messageCollector, @NotNull CommonCompilerArguments arguments2) {
        KotlinPaths kotlinPaths;
        KotlinPaths kotlinPaths2;
        File file2;
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        String kotlinHomeProperty = System.getProperty(KOTLIN_HOME_PROPERTY);
        if (arguments2.getKotlinHome() != null) {
            String string2 = arguments2.getKotlinHome();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            file2 = new File(string2);
        } else {
            file2 = kotlinHomeProperty != null ? new File(kotlinHomeProperty) : null;
        }
        File kotlinHome = file2;
        if (kotlinHome == null) {
            kotlinPaths2 = PathUtil.getKotlinPathsForCompiler();
        } else if (kotlinHome.isDirectory()) {
            kotlinPaths2 = new KotlinPathsFromHomeDir(kotlinHome);
        } else {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Kotlin home does not exist or is not a directory: " + kotlinHome, null);
            kotlinPaths2 = null;
        }
        if (kotlinPaths2 != null) {
            KotlinPaths kotlinPaths3 = kotlinPaths2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinPaths it = kotlinPaths3;
            boolean bl3 = false;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + it.getHomePath(), null);
            kotlinPaths = kotlinPaths3;
        } else {
            kotlinPaths = null;
        }
        return kotlinPaths;
    }

    /*
     * WARNING - void declaration
     */
    public static final <A extends CommonToolArguments> void reportArgumentParseProblems(@NotNull MessageCollector $receiver, @NotNull A arguments2) {
        Object key;
        boolean bl;
        Map.Entry entry;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        ArgumentParseErrors argumentParseErrors = arguments2.getErrors();
        if (argumentParseErrors == null) {
            return;
        }
        ArgumentParseErrors errors = argumentParseErrors;
        for (String string2 : errors.getUnknownExtraFlags()) {
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, "Flag is not supported by this version of the compiler: " + string2, null, 4, null);
        }
        for (String string3 : errors.getExtraArgumentsPassedInObsoleteForm()) {
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, "Advanced option value is passed in an obsolete form. Please use the '=' character to specify the value: " + string3 + "=...", null, 4, null);
        }
        Object object = errors.getDuplicateArguments();
        boolean bl2 = false;
        Iterator<Object> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry2;
            entry = entry2 = (Map.Entry)iterator2.next();
            bl = false;
            object = (String)entry.getKey();
            entry = entry2;
            bl = false;
            String value2 = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)key + " is passed multiple times. Only the last value will be used: " + value2, null, 4, null);
        }
        key = errors.getDeprecatedArguments();
        boolean value2 = false;
        iterator2 = key.entrySet().iterator();
        while (iterator2.hasNext()) {
            void deprecatedName;
            Map.Entry entry3;
            entry = entry3 = (Map.Entry)iterator2.next();
            bl = false;
            key = (String)entry.getKey();
            entry = entry3;
            bl = false;
            String newName2 = (String)entry.getValue();
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, "Argument " + (String)deprecatedName + " is deprecated. Please use " + newName2 + " instead", null, 4, null);
        }
        for (String string4 : errors.getArgfileErrors()) {
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, string4, null, 4, null);
        }
        ArgumentsKt.reportUnsafeInternalArgumentsIfAny($receiver, arguments2);
        for (String string5 : errors.getInternalArgumentsParsingProblems()) {
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, string5, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <A extends CommonToolArguments> void reportUnsafeInternalArgumentsIfAny(MessageCollector $receiver, A arguments2) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = arguments2.getInternalArguments();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            InternalArgument it = (InternalArgument)element$iv$iv;
            boolean bl = false;
            if (it instanceof ManualLanguageFeatureSetting && ((ManualLanguageFeatureSetting)it).getLanguageFeature().getKind() == LanguageFeature.Kind.BUG_FIX && ((ManualLanguageFeatureSetting)it).getState() == LanguageFeature.State.ENABLED) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsafeArguments = (List)destination$iv$iv;
        $this$filterNot$iv = unsafeArguments;
        boolean bl = false;
        if (!$this$filterNot$iv.isEmpty()) {
            Function1 function1 = reportUnsafeInternalArgumentsIfAny.unsafeArgumentsString.1.INSTANCE;
            iterable = null;
            int n = 0;
            CharSequence charSequence = "\n";
            CharSequence charSequence2 = "\n\n";
            CharSequence charSequence3 = "\n";
            String unsafeArgumentsString2 = CollectionsKt.joinToString$default(unsafeArguments, charSequence, charSequence3, charSequence2, n, (CharSequence)((Object)iterable), function1, 24, null);
            MessageCollector.DefaultImpls.report$default($receiver, CompilerMessageSeverity.STRONG_WARNING, "ATTENTION!\nThis build uses unsafe internal compiler arguments:\n" + unsafeArgumentsString2 + "This mode is not recommended for production use,\n" + "as no stability/compatibility guarantees are given on\n" + "compiler or generated code. Use it at your own risk!\n", null, 4, null);
        }
    }
}

