/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.internal.ApkDiffEntry;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import com.android.tools.apk.analyzer.internal.ApkFileByFileEntry;
import com.google.archivepatcher.explainer.EntryExplanation;
import com.google.archivepatcher.explainer.PatchExplainer;
import com.google.archivepatcher.generator.DeltaGenerator;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.bsdiff.BsDiffDeltaGenerator;
import com.google.archivepatcher.shared.Compressor;
import com.google.archivepatcher.shared.DeflateCompressor;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApkFileByFileDiffParser {
    public static DefaultMutableTreeNode createTreeNode(ArchiveContext oldFile, ArchiveContext newFile) throws IOException, InterruptedException {
        ArchiveNode oldRoot = ArchiveTreeStructure.create(oldFile);
        ArchiveNode newRoot = ArchiveTreeStructure.create(newFile);
        PatchExplainer explainer = new PatchExplainer((Compressor)new DeflateCompressor(), (DeltaGenerator)new BsDiffDeltaGenerator());
        HashMap<String, Long> pathsToDiffSize = new HashMap<String, Long>();
        List explanationList = explainer.explainPatch(oldFile.getArchive().getPath().toFile(), newFile.getArchive().getPath().toFile(), new RecommendationModifier[0]);
        for (EntryExplanation explanation : explanationList) {
            String path = new String(explanation.getPath().getData(), "UTF8");
            pathsToDiffSize.put(path, explanation.getCompressedSizeInPatch());
        }
        return ApkFileByFileDiffParser.createTreeNode(oldRoot, newRoot, pathsToDiffSize);
    }

    @VisibleForTesting
    static DefaultMutableTreeNode createTreeNode(ArchiveNode oldFile, ArchiveNode newFile, Map<String, Long> pathsToDiffSize) throws IOException {
        String name;
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both old and new files are null");
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        long oldSize = 0L;
        long newSize = 0L;
        long patchSize = 0L;
        HashSet<String> childrenInOldFile = new HashSet<String>();
        ArchiveEntry data = oldFile == null ? newFile.getData() : oldFile.getData();
        String string = name = data.getPath().getFileName() != null ? data.getPath().getFileName().toString() : data.getArchive().getPath().getFileName().toString();
        if (oldFile != null) {
            if (!oldFile.getChildren().isEmpty()) {
                for (ArchiveNode oldChild : oldFile.getChildren()) {
                    ArchiveNode newChild = null;
                    if (newFile != null) {
                        for (ArchiveNode archiveNode : newFile.getChildren()) {
                            if (!archiveNode.getData().getPath().getFileName().toString().equals(oldChild.getData().getPath().getFileName().toString())) continue;
                            newChild = archiveNode;
                            break;
                        }
                    }
                    childrenInOldFile.add(oldChild.getData().getPath().getFileName().toString());
                    DefaultMutableTreeNode childNode = ApkFileByFileDiffParser.createTreeNode(oldChild, newChild, pathsToDiffSize);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                    patchSize += entry.getSize();
                }
                if (Files.size(oldFile.getData().getPath()) > 0L) {
                    oldSize = Files.size(oldFile.getData().getPath());
                } else if (oldFile.getParent() == null) {
                    oldSize = Files.size(oldFile.getData().getArchive().getPath());
                }
            } else {
                oldSize += Files.size(oldFile.getData().getPath());
            }
        }
        if (newFile != null) {
            String relPath;
            if (!newFile.getChildren().isEmpty()) {
                for (ArchiveNode newChild : newFile.getChildren()) {
                    if (childrenInOldFile.contains(newChild.getData().getPath().getFileName().toString())) continue;
                    DefaultMutableTreeNode childNode = ApkFileByFileDiffParser.createTreeNode(null, newChild, pathsToDiffSize);
                    node.add(childNode);
                    ApkDiffEntry entry = (ApkDiffEntry)childNode.getUserObject();
                    oldSize += entry.getOldSize();
                    newSize += entry.getNewSize();
                    patchSize += entry.getSize();
                }
                if (Files.size(newFile.getData().getPath()) > 0L) {
                    newSize = Files.size(newFile.getData().getPath());
                    relPath = newFile.getData().getArchive().getContentRoot().relativize(newFile.getData().getPath()).toString();
                    if (pathsToDiffSize.containsKey(relPath)) {
                        patchSize = pathsToDiffSize.get(relPath);
                    }
                } else if (newFile.getParent() == null) {
                    newSize = Files.size(newFile.getData().getArchive().getPath());
                }
            } else {
                newSize += Files.size(newFile.getData().getPath());
                relPath = newFile.getData().getArchive().getContentRoot().relativize(newFile.getData().getPath()).toString();
                if (pathsToDiffSize.containsKey(relPath)) {
                    patchSize = pathsToDiffSize.get(relPath);
                }
            }
        }
        node.setUserObject(new ApkFileByFileEntry(name, oldFile, newFile, oldSize, newSize, patchSize));
        ApkEntry.sort(node);
        return node;
    }
}

