/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.Ksuid;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b*\u00020\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"generateName", "", "fileName", "refreshVfs", "", "Ljava/nio/file/Path;", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "relativePath", "data", "", "intellij.platform.testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"$this$writeChild");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        VirtualFile virtualFile = VfsTestUtil.createFile($this$writeChild, relativePath, data);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsTestUtil.createFile(this, relativePath, data)");
        return virtualFile;
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile $this$writeChild, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)$this$writeChild, (String)"$this$writeChild");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        VirtualFile virtualFile = VfsTestUtil.createFile($this$writeChild, relativePath, data);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsTestUtil.createFile(this, relativePath, data)");
        return virtualFile;
    }

    public static final void refreshVfs(@NotNull Path $this$refreshVfs) {
        Intrinsics.checkNotNullParameter((Object)$this$refreshVfs, (String)"$this$refreshVfs");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            return;
        }
        VirtualFile virtualFile = localFileSystem.refreshAndFindFileByNioFile($this$refreshVfs);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"(LocalFileSystem.getInst\u2026ByNioFile(this) ?: return");
        VirtualFile virtualFile2 = virtualFile;
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
    }

    private static final String generateName(String fileName) {
        StringBuilder nameBuilder = new StringBuilder(fileName.length() + 1 + 27);
        int extIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
        CharSequence charSequence = fileName;
        boolean bl = false;
        if (charSequence.length() > 0 && extIndex != 0) {
            if (extIndex == -1) {
                nameBuilder.append(fileName);
            } else {
                nameBuilder.append(fileName, 0, extIndex);
            }
            nameBuilder.append('_');
        }
        nameBuilder.append(Ksuid.generate());
        if (extIndex != -1) {
            nameBuilder.append(fileName, extIndex, fileName.length());
        }
        String string = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameBuilder.toString()");
        return string;
    }

    public static final /* synthetic */ String access$generateName(String fileName) {
        return TemporaryDirectoryKt.generateName(fileName);
    }
}

