/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import gnu.trove.TFloatArrayList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AxisComponent
extends AnimatedComponent {
    private static final BasicStroke DEFAULT_AXIS_STROKE = new BasicStroke(1.0f);
    private static final int MARKER_LABEL_OFFSET_PX = 5;
    private static final int MAXIMUM_LABEL_WIDTH = 50;
    private static final int DEFAULT_MAJOR_MARKER_LENGTH = 10;
    private static final int DEFAULT_MINOR_MARKER_LENGTH = 4;
    @VisibleForTesting
    static final float REMOVE_MAJOR_TICK_DENSITY = 1.1f;
    private static final JBColor DEFAULT_VERT_AXIS_TICK_COLOR = new JBColor(new Color(0, 0, 0, 64), new Color(255, 255, 255, 102));
    private static final JBColor DEFAULT_HORIZ_AXIS_TICK_COLOR = new JBColor(new Color(0xB9B9B9), new Color(0x656464));
    @Nullable
    private JLabel myLabel;
    private int myAxisLength;
    private final TFloatArrayList myMajorMarkerPositions;
    private final TFloatArrayList myMinorMarkerPositions;
    @NotNull
    private final List<String> myMarkerLabels;
    @NotNull
    private Color myMarkerColor;
    private float myMarkerLabelDensity;
    private String myMaxLabel;
    private String myMinLabel;
    private AxisComponentModel myModel;
    @NotNull
    private final AxisOrientation myOrientation;
    private boolean myCalculateMarkers;
    private int myMajorMarkerLength;
    private int myMinorMarkerLength;
    private int myStartMargin;
    private int myEndMargin;
    private boolean myShowMin;
    private boolean myShowMax;
    private boolean myShowUnitAtMax;
    private boolean myShowAxisLine;
    private boolean myShowLabels;
    private boolean myHideTickAtMin;

    public AxisComponent(@NotNull AxisComponentModel model2, @NotNull AxisOrientation orientation) {
        if (model2 == null) {
            AxisComponent.$$$reportNull$$$0(0);
        }
        if (orientation == null) {
            AxisComponent.$$$reportNull$$$0(1);
        }
        this.myMajorMarkerLength = 10;
        this.myMinorMarkerLength = 4;
        this.myShowAxisLine = true;
        this.myShowLabels = true;
        this.myModel = model2;
        this.myMajorMarkerPositions = new TFloatArrayList();
        this.myMinorMarkerPositions = new TFloatArrayList();
        this.myMarkerLabels = new ArrayList<String>();
        this.myOrientation = orientation;
        switch (this.myOrientation) {
            case LEFT: 
            case RIGHT: {
                this.myMarkerColor = DEFAULT_VERT_AXIS_TICK_COLOR;
                break;
            }
            default: {
                this.myMarkerColor = DEFAULT_HORIZ_AXIS_TICK_COLOR;
            }
        }
        if (!this.myModel.getLabel().isEmpty()) {
            switch (this.myOrientation) {
                case LEFT: 
                case RIGHT: {
                    this.myLabel = new RotatedLabel(this.myModel.getLabel());
                    this.myLabel.setSize(this.mDefaultFontMetrics.getHeight(), this.mDefaultFontMetrics.stringWidth(this.myModel.getLabel()));
                    break;
                }
                default: {
                    this.myLabel = new JBLabel(this.myModel.getLabel());
                    this.myLabel.setSize(this.mDefaultFontMetrics.stringWidth(this.myModel.getLabel()), this.mDefaultFontMetrics.getHeight());
                }
            }
            this.myLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        }
        this.setForeground(AdtUiUtils.DEFAULT_FONT_COLOR);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myModel.addDependency(this.myAspectObserver).onChange(AxisComponentModel.Aspect.AXIS, this::modelChanged);
        this.myCalculateMarkers = true;
    }

    private void modelChanged() {
        this.myCalculateMarkers = true;
        this.opaqueRepaint();
    }

    @Nullable
    public String getLabel() {
        return this.myLabel == null ? null : this.myLabel.getText();
    }

    @NotNull
    @VisibleForTesting
    public AxisOrientation getOrientation() {
        AxisOrientation axisOrientation = this.myOrientation;
        if (axisOrientation == null) {
            AxisComponent.$$$reportNull$$$0(2);
        }
        return axisOrientation;
    }

    @VisibleForTesting
    float getMarkerLabelDensity() {
        return this.myMarkerLabelDensity;
    }

    void calculateMarkers(@NotNull Dimension dimension) {
        if (dimension == null) {
            AxisComponent.$$$reportNull$$$0(3);
        }
        this.myMarkerLabels.clear();
        this.myMajorMarkerPositions.reset();
        this.myMinorMarkerPositions.reset();
        double currentMinValueRelative = this.myModel.getRange().getMin() - this.myModel.getZero();
        double currentMaxValueRelative = this.myModel.getRange().getMax() - this.myModel.getZero();
        double range = this.myModel.getRange().getLength();
        double labelRange = this.myModel.getDataRange();
        BaseAxisFormatter formatter = this.myModel.getFormatter();
        float majorInterval = formatter.getMajorInterval(range);
        float minorInterval = formatter.getMinorInterval(majorInterval);
        float minorScale = range == 0.0 ? 1.0f : (float)((double)minorInterval / range);
        double firstMarkerValue = Math.floor(currentMinValueRelative / (double)majorInterval) * (double)majorInterval;
        float firstMarkerOffset = (float)((double)minorScale * (firstMarkerValue - currentMinValueRelative) / (double)minorInterval);
        int numMarkers = (int)Math.floor((currentMaxValueRelative - firstMarkerValue) / (double)minorInterval) + 1;
        int numMinorPerMajor = (int)(majorInterval / minorInterval);
        int drawableHeight = dimension.height - this.myStartMargin - this.myEndMargin;
        int numMajorMarkers = (int)Math.floor((currentMaxValueRelative - firstMarkerValue) / (double)majorInterval) + 1;
        this.myMarkerLabelDensity = (float)drawableHeight / ((float)numMajorMarkers * (float)(this.mDefaultFontMetrics.getMaxAscent() + this.mDefaultFontMetrics.getMaxDescent()));
        for (int i = 0; i < numMarkers; ++i) {
            float markerOffset;
            double markerValue = firstMarkerValue + (double)((float)i * minorInterval);
            if (!this.myModel.getMarkerRange().contains(markerValue) || (markerOffset = firstMarkerOffset + (float)i * minorScale) < 0.0f && i > 0 || markerOffset > 1.0f) continue;
            if (i % numMinorPerMajor == 0) {
                this.myMajorMarkerPositions.add(markerOffset);
                this.myMarkerLabels.add(formatter.getFormattedString(labelRange, markerValue, !this.myShowUnitAtMax));
                continue;
            }
            this.myMinorMarkerPositions.add(markerOffset);
        }
        if (this.myShowMin && this.myModel.getMarkerRange().contains(currentMinValueRelative)) {
            this.myMinLabel = formatter.getFormattedString(labelRange, currentMinValueRelative, !this.myShowUnitAtMax);
        }
        if (this.myShowMax && this.myModel.getMarkerRange().contains(currentMaxValueRelative)) {
            this.myMaxLabel = formatter.getFormattedString(labelRange, currentMaxValueRelative, true);
        }
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (this.myCalculateMarkers) {
            this.calculateMarkers(dim);
            this.myCalculateMarkers = false;
        }
        Point startPoint = new Point();
        Point endPoint = new Point();
        Point labelPoint = new Point();
        switch (this.myOrientation) {
            case LEFT: {
                startPoint.x = endPoint.x = dim.width - 1;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = 0;
                labelPoint.y = endPoint.y;
                break;
            }
            case BOTTOM: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                endPoint.y = 0;
                startPoint.y = 0;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = startPoint.x;
                labelPoint.y = this.getHeight() - (this.mDefaultFontMetrics.getMaxAscent() + this.mDefaultFontMetrics.getMaxDescent());
                break;
            }
            case RIGHT: {
                endPoint.x = 0;
                startPoint.x = 0;
                startPoint.y = dim.height - this.myStartMargin - 1;
                endPoint.y = this.myEndMargin;
                this.myAxisLength = startPoint.y - endPoint.y;
                labelPoint.x = this.getWidth() - this.mDefaultFontMetrics.getMaxAdvance();
                labelPoint.y = endPoint.y;
                break;
            }
            case TOP: {
                startPoint.x = this.myStartMargin;
                endPoint.x = dim.width - this.myEndMargin - 1;
                startPoint.y = endPoint.y = dim.height - 1;
                this.myAxisLength = endPoint.x - startPoint.x;
                labelPoint.x = 0;
                labelPoint.y = 0;
            }
        }
        if (this.myAxisLength > 0) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(DEFAULT_AXIS_STROKE);
            if (this.myShowAxisLine) {
                g.setColor(this.myMarkerColor);
                g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            }
            this.drawMarkers(g, startPoint);
            if (this.myLabel != null) {
                AffineTransform initialTransform = g.getTransform();
                g.translate(labelPoint.x, labelPoint.y);
                this.myLabel.paint(g);
                g.setTransform(initialTransform);
            }
        }
    }

    private void drawMarkers(Graphics2D g2d, Point origin) {
        float scaledPosition;
        int i;
        g2d.setFont(this.getFont());
        if (this.myShowLabels) {
            if (this.myShowMin && this.myMinLabel != null) {
                this.drawMarkerLabel(g2d, 0.0f, origin, this.myMinLabel, true);
            }
            if (this.myShowMax && this.myMaxLabel != null && this.myMajorMarkerPositions.size() > 1) {
                this.drawMarkerLabel(g2d, this.myAxisLength, origin, this.myMaxLabel, true);
            }
        }
        boolean skipRendering = (this.myOrientation == AxisOrientation.LEFT || this.myOrientation == AxisOrientation.RIGHT) && this.myMarkerLabelDensity < 1.1f;
        Line2D.Float line = new Line2D.Float();
        if (!skipRendering) {
            for (i = 0; i < this.myMinorMarkerPositions.size(); ++i) {
                scaledPosition = this.myMinorMarkerPositions.get(i) * (float)this.myAxisLength;
                this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMinorMarkerLength);
            }
        }
        for (i = 0; i < this.myMajorMarkerPositions.size(); ++i) {
            if (i > 0 && i < this.myMajorMarkerPositions.size() - 1 && skipRendering) continue;
            scaledPosition = this.myMajorMarkerPositions.get(i) * (float)this.myAxisLength;
            this.drawMarkerLine(g2d, line, scaledPosition, origin, this.myMajorMarkerLength);
            if (!this.myShowLabels) continue;
            boolean reserveMinMaxBufferZone = this.myShowMin || this.myShowMax || this.myHideTickAtMin && scaledPosition == 0.0f;
            this.drawMarkerLabel(g2d, scaledPosition, origin, this.myMarkerLabels.get(i), !reserveMinMaxBufferZone);
        }
    }

    private void drawMarkerLine(Graphics2D g2d, Line2D.Float line, float markerOffset, Point origin, int markerLength) {
        if (this.myHideTickAtMin && markerOffset == 0.0f) {
            return;
        }
        float markerStartX = 0.0f;
        float markerStartY = 0.0f;
        float markerEndX = 0.0f;
        float markerEndY = 0.0f;
        switch (this.myOrientation) {
            case LEFT: {
                markerStartX = origin.x - markerLength;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = origin.x;
                break;
            }
            case RIGHT: {
                markerStartX = 0.0f;
                markerStartY = markerEndY = (float)origin.y - markerOffset;
                markerEndX = markerLength;
                break;
            }
            case TOP: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = origin.y - markerLength;
                markerEndY = origin.y;
                break;
            }
            case BOTTOM: {
                markerStartX = markerEndX = (float)origin.x + markerOffset;
                markerStartY = 0.0f;
                markerEndY = markerLength;
            }
        }
        line.setLine(markerStartX, markerStartY, markerEndX, markerEndY);
        g2d.setColor(this.myMarkerColor);
        g2d.draw(line);
    }

    private void drawMarkerLabel(Graphics2D g2d, float markerOffset, Point origin, String value, boolean alwaysRender) {
        float reserved;
        float labelY;
        float labelX;
        int stringAscent = this.mDefaultFontMetrics.getAscent();
        int stringLength = this.mDefaultFontMetrics.stringWidth(value);
        switch (this.myOrientation) {
            case LEFT: {
                labelX = origin.x - (this.myMajorMarkerLength + stringLength + 5);
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case RIGHT: {
                labelX = this.myMajorMarkerLength + 5;
                labelY = (float)origin.y - markerOffset + (float)stringAscent * 0.5f;
                reserved = stringAscent;
                break;
            }
            case TOP: {
                labelX = (float)origin.x + markerOffset + 5.0f;
                labelY = origin.y - this.myMinorMarkerLength;
                reserved = stringLength;
                break;
            }
            case BOTTOM: {
                labelX = (float)origin.x + markerOffset + 5.0f;
                labelY = this.myMinorMarkerLength + stringAscent;
                reserved = stringLength;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected orientation: " + this.myOrientation));
            }
        }
        if (alwaysRender || markerOffset - reserved > 0.0f && markerOffset + reserved < (float)this.myAxisLength) {
            g2d.setColor(this.getForeground());
            g2d.drawString(value, labelX, labelY);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Math.max(this.myMajorMarkerLength, this.myMinorMarkerLength) + 5 + 50;
        int height = 1;
        return this.myOrientation == AxisOrientation.LEFT || this.myOrientation == AxisOrientation.RIGHT ? new Dimension(width, height) : new Dimension(height, width);
    }

    public AxisComponentModel getModel() {
        return this.myModel;
    }

    public void setShowAxisLine(boolean showAxisLine) {
        this.myShowAxisLine = showAxisLine;
    }

    public void setShowMin(boolean showMin) {
        this.myShowMin = showMin;
    }

    public void setShowMax(boolean showMax) {
        this.myShowMax = showMax;
    }

    public void setShowUnitAtMax(boolean showUnitAtMax) {
        this.myShowUnitAtMax = showUnitAtMax;
    }

    public void setHideTickAtMin(boolean hideTickAtMin) {
        this.myHideTickAtMin = hideTickAtMin;
    }

    public void setMarkerLengths(int majorMarker, int minorMarker) {
        this.myMajorMarkerLength = majorMarker;
        this.myMinorMarkerLength = minorMarker;
    }

    public void setMargins(int startMargin, int endMargin) {
        this.myStartMargin = startMargin;
        this.myEndMargin = endMargin;
    }

    public void setMarkerColor(@NotNull Color markerColor) {
        if (markerColor == null) {
            AxisComponent.$$$reportNull$$$0(4);
        }
        this.myMarkerColor = markerColor;
    }

    public void setShowLabels(boolean show) {
        this.myShowLabels = show;
    }

    @VisibleForTesting
    String getMinLabel() {
        return this.myMinLabel;
    }

    @VisibleForTesting
    String getMaxLabel() {
        return this.myMaxLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/AxisComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/AxisComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateMarkers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMarkerColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AxisOrientation {
        LEFT,
        BOTTOM,
        RIGHT,
        TOP;

    }
}

