/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.LegendConfig;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class LineConfig {
    public static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f);
    public static final BasicStroke DEFAULT_DASH_STROKE = new BasicStroke(2.0f, 2, 2, 10.0f, new float[]{4.0f, 6.0f}, 0.0f);
    private static final Color[] COLORS = new Color[]{new JBColor(7057110, 7057110), new JBColor(0xFF0000, 0xFF0000), new JBColor(16616764, 16616764), new JBColor(65442, 65442), new JBColor(4080, 4080), new JBColor(13101504, 13101504), new JBColor(10394312, 10394312), new JBColor(14342891, 14342891), new JBColor(0x969696, 0x969696), new JBColor(0xD9D9D9, 0xD9D9D9)};
    private boolean myIsStepped;
    private double myDataBucketInterval;
    private boolean myIsFilled;
    private boolean myIsStacked;
    private boolean myAdjustDash;
    private boolean myIsDash;
    private float myDashLength;
    private double myAdjustedDashPhase;
    @NotNull
    private LegendConfig.IconType myLegendIconType;
    @NotNull
    private Stroke myStroke;
    @NotNull
    private Color mColor;

    public LineConfig(@NotNull Color color) {
        if (color == null) {
            LineConfig.$$$reportNull$$$0(0);
        }
        this.myIsStepped = false;
        this.myDataBucketInterval = 0.0;
        this.myIsFilled = false;
        this.myIsStacked = false;
        this.myAdjustDash = false;
        this.myIsDash = false;
        this.myDashLength = 0.0f;
        this.myAdjustedDashPhase = 0.0;
        this.mColor = color;
        this.myStroke = DEFAULT_LINE_STROKE;
        this.myLegendIconType = LegendConfig.IconType.NONE;
    }

    public static LineConfig copyOf(@NotNull LineConfig otherConfig) {
        if (otherConfig == null) {
            LineConfig.$$$reportNull$$$0(1);
        }
        LineConfig config = new LineConfig(otherConfig.getColor());
        config.setStepped(otherConfig.isStepped());
        config.setDataBucketInterval(otherConfig.myDataBucketInterval);
        config.setFilled(otherConfig.isFilled());
        config.setStacked(otherConfig.isStacked());
        config.setAdjustDash(otherConfig.isAdjustDash());
        config.setLegendIconType(otherConfig.getLegendIconType());
        config.setStroke(otherConfig.getStroke());
        config.setAdjustedDashPhase(otherConfig.getAdjustedDashPhase());
        return config;
    }

    @NotNull
    public LineConfig setStepped(boolean isStepped) {
        this.myIsStepped = isStepped;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(2);
        }
        return lineConfig;
    }

    public boolean isStepped() {
        return this.myIsStepped;
    }

    @NotNull
    public LineConfig setDataBucketInterval(double bucketInterval) {
        this.myDataBucketInterval = bucketInterval;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(3);
        }
        return lineConfig;
    }

    public double getDataBucketInterval() {
        return this.myDataBucketInterval;
    }

    @NotNull
    public LineConfig setFilled(boolean isFilled) {
        this.myIsFilled = isFilled;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(4);
        }
        return lineConfig;
    }

    public boolean isFilled() {
        return this.myIsFilled;
    }

    @NotNull
    public LineConfig setStacked(boolean isStacked) {
        this.myIsStacked = isStacked;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(5);
        }
        return lineConfig;
    }

    public boolean isStacked() {
        return this.myIsStacked;
    }

    @NotNull
    public LineConfig setAdjustDash(boolean adjustDash) {
        this.myAdjustDash = adjustDash;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(6);
        }
        return lineConfig;
    }

    public boolean isAdjustDash() {
        return this.myAdjustDash;
    }

    public boolean isDash() {
        return this.myIsDash;
    }

    public float getDashLength() {
        return this.myDashLength;
    }

    public void setAdjustedDashPhase(double dashPhase) {
        this.myAdjustedDashPhase = dashPhase;
    }

    public double getAdjustedDashPhase() {
        return this.myAdjustedDashPhase;
    }

    @NotNull
    public Color getColor() {
        Color color = this.mColor;
        if (color == null) {
            LineConfig.$$$reportNull$$$0(7);
        }
        return color;
    }

    @NotNull
    public LineConfig setColor(@NotNull Color color) {
        if (color == null) {
            LineConfig.$$$reportNull$$$0(8);
        }
        this.mColor = color;
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(9);
        }
        return lineConfig;
    }

    @NotNull
    public LineConfig setStroke(@NotNull Stroke stroke) {
        if (stroke == null) {
            LineConfig.$$$reportNull$$$0(10);
        }
        this.myStroke = stroke;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.myStroke;
            float[] dashArray = basicStroke.getDashArray();
            this.myAdjustDash = this.myIsDash = dashArray != null;
            this.myDashLength = 0.0f;
            if (this.myIsDash) {
                for (float value : dashArray) {
                    this.myDashLength += value;
                }
            }
        } else {
            this.myIsDash = false;
            this.myDashLength = 0.0f;
        }
        LineConfig lineConfig = this;
        if (lineConfig == null) {
            LineConfig.$$$reportNull$$$0(11);
        }
        return lineConfig;
    }

    @NotNull
    public Stroke getStroke() {
        Stroke stroke = this.myStroke;
        if (stroke == null) {
            LineConfig.$$$reportNull$$$0(12);
        }
        return stroke;
    }

    @NotNull
    public Stroke getAdjustedStroke() {
        if (!(this.myStroke instanceof BasicStroke) || !this.myAdjustDash) {
            Stroke stroke = this.myStroke;
            if (stroke == null) {
                LineConfig.$$$reportNull$$$0(13);
            }
            return stroke;
        }
        BasicStroke stroke = (BasicStroke)this.myStroke;
        return new BasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), (float)this.myAdjustedDashPhase);
    }

    public LineConfig setLegendIconType(@NotNull LegendConfig.IconType legendIconType) {
        if (legendIconType == null) {
            LineConfig.$$$reportNull$$$0(14);
        }
        this.myLegendIconType = legendIconType;
        return this;
    }

    @NotNull
    public LegendConfig.IconType getLegendIconType() {
        LegendConfig.IconType iconType = this.myLegendIconType;
        if (iconType == null) {
            LineConfig.$$$reportNull$$$0(15);
        }
        return iconType;
    }

    @NotNull
    public static Color getColor(int index) {
        Color color = COLORS[index % COLORS.length];
        if (color == null) {
            LineConfig.$$$reportNull$$$0(16);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherConfig";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/linechart/LineConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stroke";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legendIconType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/linechart/LineConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setStepped";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setDataBucketInterval";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setFilled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setStacked";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setAdjustDash";
                break;
            }
            case 7: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setStroke";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStroke";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedStroke";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegendIconType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyOf";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setStroke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setLegendIconType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

