/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public final class TimeAxisFormatter
extends BaseAxisFormatter {
    private static final int[] MULTIPLIERS = new int[]{1000, 1000, 60, 60, 24};
    private static final int[] BASES = new int[]{10, 10, 60, 60, 24};
    private static final int[] MIN_INTERVALS = new int[]{10, 10, 1, 1, 1};
    private static final String[] UNITS = new String[]{"us", "ms", "s", "m", "h"};
    private static final TIntArrayList[] BASE_FACTORS;
    public static final TimeAxisFormatter DEFAULT;
    public static final TimeAxisFormatter DEFAULT_WITHOUT_MINOR_TICKS;

    public TimeAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        String string = TimeFormatter.getSimplifiedClockString((long)value);
        if (string == null) {
            TimeAxisFormatter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getNumUnits() {
        return UNITS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        String string = UNITS[index];
        if (string == null) {
            TimeAxisFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getUnitBase(int index) {
        return BASES[index];
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return MULTIPLIERS[index];
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return MIN_INTERVALS[index];
    }

    @Override
    @NotNull
    protected TIntArrayList getUnitBaseFactors(int index) {
        TIntArrayList tIntArrayList = BASE_FACTORS[index];
        if (tIntArrayList == null) {
            TimeAxisFormatter.$$$reportNull$$$0(2);
        }
        return tIntArrayList;
    }

    static {
        DEFAULT = new TimeAxisFormatter(5, 10, 5);
        DEFAULT_WITHOUT_MINOR_TICKS = new TimeAxisFormatter(1, 10, 5);
        int size = BASES.length;
        BASE_FACTORS = new TIntArrayList[size];
        for (int i = 0; i < size; ++i) {
            TimeAxisFormatter.BASE_FACTORS[i] = TimeAxisFormatter.getMultiplierFactors(BASES[i]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/adtui/model/formatter/TimeAxisFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitBaseFactors";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

