/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.trackgroup;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrackGroupModel
extends DragAndDropListModel<TrackModel> {
    private static final AtomicInteger TRACK_ID_GENERATOR = new AtomicInteger();
    private final String myTitle;
    private final String myTitleInfo;
    private final boolean myCollapsedInitially;
    private final boolean myHideHeader;
    private final boolean myTrackSelectable;
    private final AspectObserver myObserver = new AspectObserver();

    private TrackGroupModel(Builder builder) {
        this.myTitle = builder.myTitle;
        this.myTitleInfo = builder.myTitleInfo;
        this.myCollapsedInitially = builder.myCollapsedInitially;
        this.myHideHeader = builder.myHideHeader;
        this.myTrackSelectable = builder.myTrackSelectable;
    }

    public <M, R extends Enum> void addTrackModel(@NotNull TrackModel.Builder<M, R> builder) {
        if (builder == null) {
            TrackGroupModel.$$$reportNull$$$0(0);
        }
        TrackModel trackModel = builder.setId(TRACK_ID_GENERATOR.getAndIncrement()).build();
        this.insertOrderedElement(trackModel);
        trackModel.getAspectModel().addDependency(this.myObserver).onChange(TrackModel.Aspect.COLLAPSE_CHANGE, () -> {
            int index = this.indexOf(trackModel);
            if (index != -1) {
                this.fireContentsChanged(this, index, index);
            }
        });
    }

    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitleInfo() {
        return this.myTitleInfo;
    }

    public boolean isCollapsedInitially() {
        return this.myCollapsedInitially;
    }

    public boolean getHideHeader() {
        return this.myHideHeader;
    }

    public boolean isTrackSelectable() {
        return this.myTrackSelectable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/adtui/model/trackgroup/TrackGroupModel", "addTrackModel"));
    }

    public static final class Builder {
        private String myTitle = "";
        private String myTitleInfo = null;
        private boolean myCollapsedInitially = false;
        private boolean myHideHeader = false;
        private boolean myTrackSelectable = false;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.myTitle = title;
            return this;
        }

        public Builder setTitleInfo(@Nullable String titleInfo) {
            this.myTitleInfo = titleInfo;
            return this;
        }

        public Builder setCollapsedInitially(boolean collapsedInitially) {
            this.myCollapsedInitially = collapsedInitially;
            return this;
        }

        public Builder setHideHeader(boolean hideHeader) {
            this.myHideHeader = hideHeader;
            return this;
        }

        public Builder setTrackSelectable(boolean trackSelectable) {
            this.myTrackSelectable = trackSelectable;
            return this;
        }

        public TrackGroupModel build() {
            return new TrackGroupModel(this);
        }
    }
}

