/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.jetbrains.annotations.NotNull;
import sun.swing.MenuItemLayoutHelper;

public final class CommonMenuPaintHelper {
    private CommonMenuPaintHelper() {
    }

    public static void paintIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color holdColor) {
        Icon icon;
        if (graphics == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(0);
        }
        if (layoutHelper == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(1);
        }
        if (layoutResult == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(2);
        }
        if (holdColor == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(3);
        }
        if (layoutHelper.getIcon() == null) {
            return;
        }
        ButtonModel model2 = layoutHelper.getMenuItem().getModel();
        if (!model2.isEnabled()) {
            icon = layoutHelper.getMenuItem().getDisabledIcon();
        } else if (model2.isPressed() && model2.isArmed()) {
            icon = layoutHelper.getMenuItem().getPressedIcon();
            if (icon == null) {
                icon = layoutHelper.getMenuItem().getIcon();
            }
        } else {
            icon = layoutHelper.getMenuItem().getIcon();
        }
        if (icon != null) {
            icon.paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getIconRect().x, layoutResult.getIconRect().y);
            graphics.setColor(holdColor);
        }
    }

    public static void paintAccText(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color disabledForeground, @NotNull Color acceleratorForeground, @NotNull Color acceleratorSelectionForeground) {
        if (graphics == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(4);
        }
        if (layoutHelper == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(5);
        }
        if (layoutResult == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(6);
        }
        if (disabledForeground == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(7);
        }
        if (acceleratorForeground == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(8);
        }
        if (acceleratorSelectionForeground == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(9);
        }
        if (layoutHelper.getAccText().equals("")) {
            return;
        }
        ButtonModel model2 = layoutHelper.getMenuItem().getModel();
        graphics.setFont(layoutHelper.getAccFontMetrics().getFont());
        if (!model2.isEnabled()) {
            if (disabledForeground != null) {
                graphics.setColor(disabledForeground);
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
            } else {
                graphics.setColor(layoutHelper.getMenuItem().getBackground().brighter());
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
                graphics.setColor(layoutHelper.getMenuItem().getBackground().darker());
                UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)(layoutResult.getAccRect().x - 1), (int)(layoutResult.getAccRect().y + layoutHelper.getFontMetrics().getAscent() - 1));
            }
        } else {
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(acceleratorSelectionForeground);
            } else {
                graphics.setColor(acceleratorForeground);
            }
            UIUtilities.drawString((JComponent)layoutHelper.getMenuItem(), (Graphics)graphics, (String)layoutHelper.getAccText(), (int)layoutResult.getAccRect().x, (int)(layoutResult.getAccRect().y + layoutHelper.getAccFontMetrics().getAscent()));
        }
    }

    public static void paintArrowIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color foreground) {
        if (graphics == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(10);
        }
        if (layoutHelper == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(11);
        }
        if (layoutResult == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(12);
        }
        if (foreground == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(13);
        }
        if (layoutHelper.getArrowIcon() != null) {
            ButtonModel model2 = layoutHelper.getMenuItem().getModel();
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(foreground);
            }
            if (layoutHelper.useCheckAndArrow()) {
                layoutHelper.getArrowIcon().paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getArrowRect().x, layoutResult.getArrowRect().y);
            }
        }
    }

    public static void paintArrowIconCustom(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult) {
        if (graphics == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(14);
        }
        if (layoutHelper == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(15);
        }
        if (layoutResult == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(16);
        }
        if (layoutHelper.getArrowIcon() != null && layoutHelper.useCheckAndArrow()) {
            int arrowWidth = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH();
            int arrowHeight = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT();
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle rect = layoutResult.getArrowRect();
            float x = rect.x + (rect.width - arrowHeight);
            float y = (float)rect.y + (float)rect.height / 2.0f;
            Path2D.Float triangle = new Path2D.Float();
            triangle.moveTo(x + (float)arrowHeight, y);
            triangle.lineTo(x, y - (float)arrowWidth / 2.0f);
            triangle.lineTo(x, y + (float)arrowWidth / 2.0f);
            triangle.lineTo(x + (float)arrowHeight, y);
            GraphicsUtilKt.setColorAndAlpha(g2d, StandardColors.DROPDOWN_ARROW_COLOR);
            g2d.fill(triangle);
        }
    }

    public static void paintCheckIcon(@NotNull Graphics graphics, @NotNull MenuItemLayoutHelper layoutHelper, @NotNull MenuItemLayoutHelper.LayoutResult layoutResult, @NotNull Color holdColor, @NotNull Color foreground) {
        if (graphics == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(17);
        }
        if (layoutHelper == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(18);
        }
        if (layoutResult == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(19);
        }
        if (holdColor == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(20);
        }
        if (foreground == null) {
            CommonMenuPaintHelper.$$$reportNull$$$0(21);
        }
        if (layoutHelper.getCheckIcon() != null) {
            ButtonModel model2 = layoutHelper.getMenuItem().getModel();
            if (model2.isArmed() || layoutHelper.getMenuItem() instanceof JMenu && model2.isSelected()) {
                graphics.setColor(foreground);
            } else {
                graphics.setColor(holdColor);
            }
            if (layoutHelper.useCheckAndArrow()) {
                layoutHelper.getCheckIcon().paintIcon(layoutHelper.getMenuItem(), graphics, layoutResult.getCheckRect().x, layoutResult.getCheckRect().y);
            }
            graphics.setColor(holdColor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutHelper";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutResult";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holdColor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledForeground";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceleratorForeground";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceleratorSelectionForeground";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/stdui/menu/CommonMenuPaintHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paintIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "paintAccText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "paintArrowIcon";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "paintArrowIconCustom";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "paintCheckIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

