/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.util.IncorrectOperationException;
import de.plushnikov.intellij.plugin.psi.LombokLightIdentifier;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.psi.LombokLightParameterListBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightReferenceListBuilder;
import icons.LombokIcons;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightMethodBuilder
extends LightMethodBuilder
implements SyntheticElement {
    private PsiMethod myMethod;
    private ASTNode myASTNode;
    private PsiCodeBlock myBodyCodeBlock;
    private String myReturnTypeAsText;

    public LombokLightMethodBuilder(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(1);
        }
        super(manager, (Language)JavaLanguage.INSTANCE, name, (PsiParameterList)new LombokLightParameterListBuilder(manager, (Language)JavaLanguage.INSTANCE), (PsiModifierList)new LombokLightModifierList(manager), (PsiReferenceList)new LombokLightReferenceListBuilder(manager, (Language)JavaLanguage.INSTANCE, PsiReferenceList.Role.THROWS_LIST), (PsiTypeParameterList)new LightTypeParameterListBuilder(manager, (Language)JavaLanguage.INSTANCE));
        this.setBaseIcon(LombokIcons.Nodes.LombokMethod);
    }

    public LombokLightMethodBuilder withNavigationElement(PsiElement navigationElement) {
        this.setNavigationElement(navigationElement);
        return this;
    }

    public LombokLightMethodBuilder withModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String modifier) {
        if (modifier == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(2);
        }
        this.addModifier(modifier);
        return this;
    }

    public LombokLightMethodBuilder withModifier(String ... modifiers) {
        if (modifiers == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(3);
        }
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
        return this;
    }

    public LombokLightMethodBuilder withMethodReturnType(PsiType returnType) {
        this.setMethodReturnType(returnType);
        return this;
    }

    public LightMethodBuilder setMethodReturnType(PsiType returnType) {
        this.myReturnTypeAsText = returnType.getPresentableText();
        return super.setMethodReturnType(returnType);
    }

    public LombokLightMethodBuilder withFinalParameter(@NotNull String name, @NotNull PsiType type) {
        if (name == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(4);
        }
        if (type == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(5);
        }
        LombokLightParameter lombokLightParameter = this.createParameter(name, type);
        lombokLightParameter.setModifiers("final");
        return this.withParameter(lombokLightParameter);
    }

    public LombokLightMethodBuilder withParameter(@NotNull String name, @NotNull PsiType type) {
        if (name == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(6);
        }
        if (type == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(7);
        }
        return this.withParameter(this.createParameter(name, type));
    }

    @NotNull
    private LombokLightParameter createParameter(@NotNull String name, @NotNull PsiType type) {
        if (name == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(8);
        }
        if (type == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(9);
        }
        return new LombokLightParameter(name, type, (PsiElement)this, (Language)JavaLanguage.INSTANCE);
    }

    public LombokLightMethodBuilder withParameter(@NotNull LombokLightParameter psiParameter) {
        if (psiParameter == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(10);
        }
        this.addParameter((PsiParameter)psiParameter);
        return this;
    }

    public LombokLightMethodBuilder withException(@NotNull PsiClassType type) {
        if (type == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(11);
        }
        this.addException(type);
        return this;
    }

    public LombokLightMethodBuilder withContainingClass(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(12);
        }
        this.setContainingClass(containingClass);
        return this;
    }

    public LombokLightMethodBuilder withTypeParameter(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(13);
        }
        this.addTypeParameter(typeParameter);
        return this;
    }

    public LombokLightMethodBuilder withConstructor(boolean isConstructor) {
        this.setConstructor(isConstructor);
        return this;
    }

    public LombokLightMethodBuilder withBody(@NotNull PsiCodeBlock codeBlock) {
        if (codeBlock == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(14);
        }
        this.myBodyCodeBlock = codeBlock;
        return this;
    }

    public LombokLightMethodBuilder withAnnotation(@NotNull String annotation) {
        if (annotation == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(15);
        }
        this.getModifierList().addAnnotation(annotation);
        return this;
    }

    public LombokLightMethodBuilder withAnnotations(Iterable<String> annotations) {
        LombokLightModifierList modifierList = this.getModifierList();
        annotations.forEach(arg_0 -> ((PsiModifierList)modifierList).addAnnotation(arg_0));
        return this;
    }

    public LightMethodBuilder addTypeParameter(PsiTypeParameter parameter) {
        ((LightTypeParameterListBuilder)this.getTypeParameterList()).addParameter(parameter);
        return this;
    }

    @NotNull
    public LombokLightModifierList getModifierList() {
        LombokLightModifierList lombokLightModifierList = (LombokLightModifierList)super.getModifierList();
        if (lombokLightModifierList == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(16);
        }
        return lombokLightModifierList;
    }

    @NotNull
    public LombokLightParameterListBuilder getParameterList() {
        LombokLightParameterListBuilder lombokLightParameterListBuilder = (LombokLightParameterListBuilder)super.getParameterList();
        if (lombokLightParameterListBuilder == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(17);
        }
        return lombokLightParameterListBuilder;
    }

    public PsiCodeBlock getBody() {
        return this.myBodyCodeBlock;
    }

    public PsiIdentifier getNameIdentifier() {
        return new LombokLightIdentifier(this.myManager, this.getName());
    }

    public PsiElement getParent() {
        PsiElement result = super.getParent();
        result = null != result ? result : this.getContainingClass();
        return result;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass != null ? containingClass.getContainingFile() : null;
    }

    public String getText() {
        ASTNode node = this.getNode();
        if (null != node) {
            return node.getText();
        }
        return "";
    }

    public ASTNode getNode() {
        if (null == this.myASTNode) {
            PsiElement myPsiMethod = this.getOrCreateMyPsiMethod();
            this.myASTNode = null == myPsiMethod ? null : myPsiMethod.getNode();
        }
        return this.myASTNode;
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    private String getAllModifierProperties(LightModifierList modifierList) {
        StringBuilder builder = new StringBuilder();
        for (String modifier : modifierList.getModifiers()) {
            if ("packageLocal".equals(modifier)) continue;
            builder.append(modifier).append(' ');
        }
        return builder.toString();
    }

    private PsiMethod rebuildMethodFromString() {
        PsiMethod result;
        try {
            StringBuilder methodTextDeclaration = new StringBuilder();
            methodTextDeclaration.append(this.getAllModifierProperties(this.getModifierList()));
            PsiType returnType = this.getReturnType();
            if (null != returnType && returnType.isValid()) {
                methodTextDeclaration.append(returnType.getCanonicalText()).append(' ');
            }
            methodTextDeclaration.append(this.getName());
            methodTextDeclaration.append('(');
            if (this.getParameterList().getParametersCount() > 0) {
                for (PsiParameter parameter : this.getParameterList().getParameters()) {
                    methodTextDeclaration.append(parameter.getType().getCanonicalText()).append(' ').append(parameter.getName()).append(',');
                }
                methodTextDeclaration.deleteCharAt(methodTextDeclaration.length() - 1);
            }
            methodTextDeclaration.append(')');
            methodTextDeclaration.append('{').append("  ").append('}');
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
            result = elementFactory.createMethodFromText(methodTextDeclaration.toString(), (PsiElement)this.getContainingClass());
            if (null != this.getBody()) {
                result.getBody().replace((PsiElement)this.getBody());
            }
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public PsiElement copy() {
        PsiElement myPsiMethod = this.getOrCreateMyPsiMethod();
        return null == myPsiMethod ? null : myPsiMethod.copy();
    }

    private PsiElement getOrCreateMyPsiMethod() {
        if (null == this.myMethod) {
            this.myMethod = this.rebuildMethodFromString();
        }
        return this.myMethod;
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement myPsiMethod = this.getOrCreateMyPsiMethod();
        PsiElement[] psiElementArray = null == myPsiMethod ? PsiElement.EMPTY_ARRAY : myPsiMethod.getChildren();
        if (psiElementArray == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    public String toString() {
        return "LombokLightMethodBuilder: " + this.getName();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiClass containingClass;
        if (newElement == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(19);
        }
        if (null != (containingClass = this.getContainingClass())) {
            CheckUtil.checkWritable((PsiElement)containingClass);
            return containingClass.add(newElement);
        }
        return null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LombokLightMethodBuilder.$$$reportNull$$$0(20);
        }
        return this;
    }

    public boolean equals(Object o) {
        PsiClass thatContainingClass;
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightMethodBuilder that = (LombokLightMethodBuilder)((Object)o);
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.isConstructor() != that.isConstructor()) {
            return false;
        }
        PsiClass containingClass = this.getContainingClass();
        if (!Objects.equals(containingClass, thatContainingClass = that.getContainingClass())) {
            return false;
        }
        if (!this.getModifierList().equals((Object)that.getModifierList())) {
            return false;
        }
        if (!this.getParameterList().equals((Object)that.getParameterList())) {
            return false;
        }
        return Objects.equals(this.myReturnTypeAsText, that.myReturnTypeAsText);
    }

    public int hashCode() {
        return 1;
    }

    public void delete() throws IncorrectOperationException {
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightMethodBuilder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightMethodBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withModifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withFinalParameter";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "withException";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withContainingClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withTypeParameter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withBody";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withAnnotation";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

