/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    @NotNull
    private final Editor myEditor;
    private final int myOffset;
    private final int myInvocationCount;
    private final CompletionProcess myProcess;
    private boolean isTestingMode;
    private boolean completeOnlyNotImported;

    @ApiStatus.Internal
    public CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, @NotNull CompletionType completionType, int offset, int invocationCount, @NotNull Editor editor, @NotNull CompletionProcess process) {
        if (position == null) {
            CompletionParameters.$$$reportNull$$$0(0);
        }
        if (originalFile == null) {
            CompletionParameters.$$$reportNull$$$0(1);
        }
        if (completionType == null) {
            CompletionParameters.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CompletionParameters.$$$reportNull$$$0(3);
        }
        if (process == null) {
            CompletionParameters.$$$reportNull$$$0(4);
        }
        this.isTestingMode = false;
        this.completeOnlyNotImported = false;
        PsiUtilCore.ensureValid(position);
        assert (position.getTextRange().containsOffset(offset)) : position;
        this.myPosition = position;
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
        this.myEditor = editor;
        this.myProcess = process;
    }

    @NotNull
    public CompletionParameters withType(@NotNull CompletionType type) {
        if (type == null) {
            CompletionParameters.$$$reportNull$$$0(5);
        }
        return new CompletionParameters(this.myPosition, this.myOriginalFile, type, this.myOffset, this.myInvocationCount, this.myEditor, this.myProcess);
    }

    @NotNull
    public CompletionParameters withInvocationCount(int newCount) {
        return new CompletionParameters(this.myPosition, this.myOriginalFile, this.myCompletionType, this.myOffset, newCount, this.myEditor, this.myProcess);
    }

    @NotNull
    public PsiElement getPosition() {
        PsiElement psiElement = this.myPosition;
        if (psiElement == null) {
            CompletionParameters.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile;
        if (psiFile == null) {
            CompletionParameters.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            CompletionParameters.$$$reportNull$$$0(8);
        }
        return completionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }

    public boolean isAutoPopup() {
        return this.myInvocationCount == 0;
    }

    @NotNull
    public CompletionParameters withPosition(@NotNull PsiElement element, int offset) {
        if (element == null) {
            CompletionParameters.$$$reportNull$$$0(9);
        }
        return new CompletionParameters(element, this.myOriginalFile, this.myCompletionType, offset, this.myInvocationCount, this.myEditor, this.myProcess);
    }

    public boolean isExtendedCompletion() {
        return this.myCompletionType == CompletionType.BASIC && this.myInvocationCount >= 2;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            CompletionParameters.$$$reportNull$$$0(10);
        }
        return editor;
    }

    @NotNull
    public CompletionProcess getProcess() {
        CompletionProcess completionProcess = this.myProcess;
        if (completionProcess == null) {
            CompletionParameters.$$$reportNull$$$0(11);
        }
        return completionProcess;
    }

    public boolean isTestingMode() {
        return this.isTestingMode;
    }

    public void setIsTestingMode(boolean runTestingMode) {
        this.isTestingMode = runTestingMode;
    }

    public boolean isCompleteOnlyNotImported() {
        return this.completeOnlyNotImported;
    }

    public void setCompleteOnlyNotImported(boolean onlyNonImported) {
        this.completeOnlyNotImported = onlyNonImported;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionParameters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

