/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Editor
extends UserDataHolder {
    public static final Editor[] EMPTY_ARRAY = new Editor[0];

    @NotNull
    public Document getDocument();

    public boolean isViewer();

    @NotNull
    public JComponent getComponent();

    @NotNull
    public JComponent getContentComponent();

    public void setBorder(@Nullable Border var1);

    public Insets getInsets();

    @NotNull
    public SelectionModel getSelectionModel();

    @NotNull
    public MarkupModel getMarkupModel();

    @NotNull
    public FoldingModel getFoldingModel();

    @NotNull
    public ScrollingModel getScrollingModel();

    @NotNull
    public CaretModel getCaretModel();

    @NotNull
    public SoftWrapModel getSoftWrapModel();

    @NotNull
    public EditorSettings getSettings();

    @NotNull
    public EditorColorsScheme getColorsScheme();

    public int getLineHeight();

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition var1);

    public int logicalPositionToOffset(@NotNull LogicalPosition var1);

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition var1);

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition var1);

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition var1);

    default public int visualPositionToOffset(@NotNull VisualPosition pos) {
        if (pos == null) {
            Editor.$$$reportNull$$$0(0);
        }
        return this.logicalPositionToOffset(this.visualToLogicalPosition(pos));
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1, boolean var2, boolean var3);

    default public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        return this.offsetToVisualPosition((int)offset, (boolean)false, (boolean)beforeSoftWrap).line;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D var1);

    @NotNull
    default public Point offsetToXY(int offset) {
        Point point = this.offsetToXY(offset, false, false);
        if (point == null) {
            Editor.$$$reportNull$$$0(1);
        }
        return point;
    }

    @NotNull
    default public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point point = this.visualPositionToXY(visualPosition);
        if (point == null) {
            Editor.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset) {
        Point2D point2D = this.offsetToPoint2D(offset, false, false);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(3);
        }
        return point2D;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point2D point2D = this.visualPositionToPoint2D(visualPosition);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(4);
        }
        return point2D;
    }

    default public int visualLineToY(int visualLine) {
        return this.visualPositionToXY((VisualPosition)new VisualPosition((int)visualLine, (int)0)).y;
    }

    default public int yToVisualLine(int y) {
        return this.xyToVisualPosition((Point)new Point((int)0, (int)y)).line;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener var1);

    default public void addEditorMouseListener(@NotNull EditorMouseListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            Editor.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            Editor.$$$reportNull$$$0(6);
        }
        this.addEditorMouseListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeEditorMouseListener(listener2));
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener var1);

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    default public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            Editor.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            Editor.$$$reportNull$$$0(8);
        }
        this.addEditorMouseMotionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeEditorMouseMotionListener(listener2));
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public boolean isDisposed();

    @Nullable
    public Project getProject();

    public boolean isInsertMode();

    public boolean isColumnMode();

    public boolean isOneLineMode();

    @NotNull
    public EditorGutter getGutter();

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent var1);

    public void setHeaderComponent(@Nullable JComponent var1);

    public boolean hasHeaderComponent();

    @Nullable
    public JComponent getHeaderComponent();

    @NotNull
    public IndentsModel getIndentsModel();

    @NotNull
    public InlayModel getInlayModel();

    @NotNull
    public EditorKind getEditorKind();

    default public int getAscent() {
        return (int)((float)this.getContentComponent().getFontMetrics(this.getColorsScheme().getFont(EditorFontType.PLAIN)).getAscent() * this.getColorsScheme().getLineSpacing());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/Editor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/Editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToPoint2D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToOffset";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

