/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRequestCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefClient
implements JBCefDisposable {
    private static final Logger LOG = Logger.getInstance(JBCefClient.class);
    @ApiStatus.Experimental
    @NotNull
    public static final String JBCEFCLIENT_JSQUERY_POOL_SIZE_PROP = "JBCefClient.JSQuery.poolSize";
    @NotNull
    private final Map<String, Object> myProperties;
    @NotNull
    private final PropertyChangeSupport myPropertyChangeSupport;
    private static final int JS_QUERY_SLOT_POOL_DEF_SIZE = RegistryManager.getInstance().intValue("ide.browser.jcef.jsQueryPoolSize");
    private static final int JS_QUERY_SLOT_POOL_MAX_SIZE = 10000;
    @NotNull
    private final CefClient myCefClient;
    @NotNull
    private final DisposeHelper myDisposeHelper;
    @Nullable
    private volatile JSQueryPool myJSQueryPool;
    @NotNull
    private final AtomicInteger myJSQueryCounter;
    private final HandlerSupport<CefContextMenuHandler> myContextMenuHandler;
    private final HandlerSupport<CefDialogHandler> myDialogHandler;
    private final HandlerSupport<CefDisplayHandler> myDisplayHandler;
    private final HandlerSupport<CefDownloadHandler> myDownloadHandler;
    private final HandlerSupport<CefDragHandler> myDragHandler;
    private final HandlerSupport<CefFocusHandler> myFocusHandler;
    private final HandlerSupport<CefJSDialogHandler> myJSDialogHandler;
    private final HandlerSupport<CefKeyboardHandler> myKeyboardHandler;
    private final HandlerSupport<CefLifeSpanHandler> myLifeSpanHandler;
    private final HandlerSupport<CefLoadHandler> myLoadHandler;
    private final HandlerSupport<CefRequestHandler> myRequestHandler;

    JBCefClient(@NotNull CefClient client) {
        if (client == null) {
            JBCefClient.$$$reportNull$$$0(0);
        }
        this.myProperties = new HashMap<String, Object>();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myDisposeHelper = new DisposeHelper();
        this.myJSQueryCounter = new AtomicInteger(0);
        this.myContextMenuHandler = new HandlerSupport();
        this.myDialogHandler = new HandlerSupport();
        this.myDisplayHandler = new HandlerSupport();
        this.myDownloadHandler = new HandlerSupport();
        this.myDragHandler = new HandlerSupport();
        this.myFocusHandler = new HandlerSupport();
        this.myJSDialogHandler = new HandlerSupport();
        this.myKeyboardHandler = new HandlerSupport();
        this.myLifeSpanHandler = new HandlerSupport();
        this.myLoadHandler = new HandlerSupport();
        this.myRequestHandler = new HandlerSupport();
        this.myCefClient = client;
        Disposer.register((Disposable)JBCefApp.getInstance().getDisposable(), (Disposable)this);
        Runnable createPool = () -> {
            if (this.myJSQueryPool != null) {
                LOG.warn("JSQueryPool has already been created, this request will be ignored");
                return;
            }
            this.myJSQueryPool = JSQueryPool.create(this);
        };
        this.addPropertyChangeListener(JBCEFCLIENT_JSQUERY_POOL_SIZE_PROP, evt -> {
            if (evt.getNewValue() != null) {
                createPool.run();
            }
        });
        if (JS_QUERY_SLOT_POOL_DEF_SIZE > 0) {
            createPool.run();
        }
    }

    @NotNull
    public CefClient getCefClient() {
        CefClient cefClient = this.myCefClient;
        if (cefClient == null) {
            JBCefClient.$$$reportNull$$$0(1);
        }
        return cefClient;
    }

    public void dispose() {
        this.myDisposeHelper.dispose(() -> {
            try {
                this.myCefClient.dispose();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            JBCefClient.$$$reportNull$$$0(2);
        }
        Map<String, Object> map = this.myProperties;
        synchronized (map) {
            Object oldValue = this.myProperties.put(name, value);
            this.myPropertyChangeSupport.firePropertyChange(name, oldValue, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getProperty(@NotNull String name) {
        if (name == null) {
            JBCefClient.$$$reportNull$$$0(3);
        }
        Map<String, Object> map = this.myProperties;
        synchronized (map) {
            return this.myProperties.get(name);
        }
    }

    void addPropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener2) {
        if (name == null) {
            JBCefClient.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            JBCefClient.$$$reportNull$$$0(5);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(name, listener2);
    }

    void removePropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener2) {
        if (name == null) {
            JBCefClient.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            JBCefClient.$$$reportNull$$$0(7);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(name, listener2);
    }

    @Nullable
    JSQueryPool getJSQueryPool() {
        return this.myJSQueryPool;
    }

    synchronized void notifyBrowserCreated(@NotNull JBCefBrowser browser) {
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(8);
        }
        if (this.myJSQueryPool == null) {
            this.myJSQueryPool = JSQueryPool.create(this);
        }
    }

    int nextJSQueryIndex() {
        return this.myJSQueryCounter.incrementAndGet();
    }

    public JBCefClient addContextMenuHandler(@NotNull CefContextMenuHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(9);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(10);
        }
        return this.myContextMenuHandler.add(handler, browser, () -> this.myCefClient.addContextMenuHandler(new CefContextMenuHandler(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler -> handler.onBeforeContextMenu(browser, frame, params, model));
            }

            public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
                return JBCefClient.this.myContextMenuHandler.handleBoolean(browser, handler -> handler.onContextMenuCommand(browser, frame, params, commandId, eventFlags));
            }

            public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
                JBCefClient.this.myContextMenuHandler.handle(browser, handler -> handler.onContextMenuDismissed(browser, frame));
            }
        }));
    }

    public void removeContextMenuHandler(@NotNull CefContextMenuHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(11);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(12);
        }
        this.myContextMenuHandler.remove(handler, browser, () -> this.myCefClient.removeContextMenuHandler());
    }

    public JBCefClient addDialogHandler(@NotNull CefDialogHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(13);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(14);
        }
        return this.myDialogHandler.add(handler, browser, () -> this.myCefClient.addDialogHandler(new CefDialogHandler(){

            public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, int selectedAcceptFilter, CefFileDialogCallback callback) {
                return JBCefClient.this.myDialogHandler.handleBoolean(browser, handler -> handler.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, selectedAcceptFilter, callback));
            }
        }));
    }

    public void removeDialogHandler(@NotNull CefDialogHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(15);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(16);
        }
        this.myDialogHandler.remove(handler, browser, () -> this.myCefClient.removeDialogHandler());
    }

    public JBCefClient addDisplayHandler(@NotNull CefDisplayHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(17);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(18);
        }
        return this.myDisplayHandler.add(handler, browser, () -> this.myCefClient.addDisplayHandler(new CefDisplayHandler(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onAddressChange(browser, frame, url));
            }

            public void onTitleChange(CefBrowser browser, String title) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onTitleChange(browser, title));
            }

            public boolean onTooltip(CefBrowser browser, String text) {
                return JBCefClient.this.myDisplayHandler.handleBoolean(browser, handler -> handler.onTooltip(browser, text));
            }

            public void onStatusMessage(CefBrowser browser, String value) {
                JBCefClient.this.myDisplayHandler.handle(browser, handler -> handler.onStatusMessage(browser, value));
            }

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                return JBCefClient.this.myDisplayHandler.handleBoolean(browser, handler -> handler.onConsoleMessage(browser, level, message, source, line));
            }
        }));
    }

    public void removeDisplayHandler(@NotNull CefDisplayHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(19);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(20);
        }
        this.myDisplayHandler.remove(handler, browser, () -> this.myCefClient.removeDisplayHandler());
    }

    public JBCefClient addDownloadHandler(@NotNull CefDownloadHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(21);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(22);
        }
        return this.myDownloadHandler.add(handler, browser, () -> this.myCefClient.addDownloadHandler(new CefDownloadHandler(){

            public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler -> handler.onBeforeDownload(browser, downloadItem, suggestedName, callback));
            }

            public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
                JBCefClient.this.myDownloadHandler.handle(browser, handler -> handler.onDownloadUpdated(browser, downloadItem, callback));
            }
        }));
    }

    public void removeDownloadHandle(@NotNull CefDownloadHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(23);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(24);
        }
        this.myDownloadHandler.remove(handler, browser, () -> this.myCefClient.removeDownloadHandler());
    }

    public JBCefClient addDragHandler(@NotNull CefDragHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(25);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(26);
        }
        return this.myDragHandler.add(handler, browser, () -> this.myCefClient.addDragHandler(new CefDragHandler(){

            public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
                return JBCefClient.this.myDragHandler.handleBoolean(browser, handler -> handler.onDragEnter(browser, dragData, mask));
            }
        }));
    }

    public void removeDragHandler(@NotNull CefDragHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(27);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(28);
        }
        this.myDragHandler.remove(handler, browser, () -> this.myCefClient.removeDragHandler());
    }

    public JBCefClient addFocusHandler(@NotNull CefFocusHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(29);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(30);
        }
        return this.myFocusHandler.add(handler, browser, () -> this.myCefClient.addFocusHandler(new CefFocusHandler(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                JBCefClient.this.myFocusHandler.handle(browser, handler -> handler.onTakeFocus(browser, next));
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                return JBCefClient.this.myFocusHandler.handleBoolean(browser, handler -> handler.onSetFocus(browser, source));
            }

            public void onGotFocus(CefBrowser browser) {
                JBCefClient.this.myFocusHandler.handle(browser, handler -> handler.onGotFocus(browser));
            }
        }));
    }

    public void removeFocusHandler(@NotNull CefFocusHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(31);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(32);
        }
        this.myFocusHandler.remove(handler, browser, () -> this.myCefClient.removeFocusHandler());
    }

    public JBCefClient addJSDialogHandler(@NotNull CefJSDialogHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(33);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(34);
        }
        return this.myJSDialogHandler.add(handler, browser, () -> this.myCefClient.addJSDialogHandler(new CefJSDialogHandler(){

            public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
                return JBCefClient.this.myJSDialogHandler.handleBoolean(browser, handler -> handler.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message));
            }

            public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
                return JBCefClient.this.myJSDialogHandler.handleBoolean(browser, handler -> handler.onBeforeUnloadDialog(browser, message_text, is_reload, callback));
            }

            public void onResetDialogState(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler -> handler.onResetDialogState(browser));
            }

            public void onDialogClosed(CefBrowser browser) {
                JBCefClient.this.myJSDialogHandler.handle(browser, handler -> handler.onDialogClosed(browser));
            }
        }));
    }

    public void removeJSDialogHandler(@NotNull CefJSDialogHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(35);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(36);
        }
        this.myJSDialogHandler.remove(handler, browser, () -> this.myCefClient.removeJSDialogHandler());
    }

    public JBCefClient addKeyboardHandler(@NotNull CefKeyboardHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(37);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(38);
        }
        return this.myKeyboardHandler.add(handler, browser, () -> this.myCefClient.addKeyboardHandler(new CefKeyboardHandler(){

            public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
                return JBCefClient.this.myKeyboardHandler.handleBoolean(browser, handler -> handler.onPreKeyEvent(browser, event, is_keyboard_shortcut));
            }

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
                return JBCefClient.this.myKeyboardHandler.handleBoolean(browser, handler -> handler.onKeyEvent(browser, event));
            }
        }));
    }

    public void removeKeyboardHandler(@NotNull CefKeyboardHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(39);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(40);
        }
        this.myKeyboardHandler.remove(handler, browser, () -> this.myCefClient.removeKeyboardHandler());
    }

    public JBCefClient addLifeSpanHandler(@NotNull CefLifeSpanHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(41);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(42);
        }
        return this.myLifeSpanHandler.add(handler, browser, () -> this.myCefClient.addLifeSpanHandler(new CefLifeSpanHandler(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                return JBCefClient.this.myLifeSpanHandler.handleBoolean(browser, handler -> handler.onBeforePopup(browser, frame, target_url, target_frame_name));
            }

            public void onAfterCreated(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onAfterCreated(browser));
            }

            public void onAfterParentChanged(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onAfterParentChanged(browser));
            }

            public boolean doClose(CefBrowser browser) {
                return JBCefClient.this.myLifeSpanHandler.handleBoolean(browser, handler -> handler.doClose(browser));
            }

            public void onBeforeClose(CefBrowser browser) {
                JBCefClient.this.myLifeSpanHandler.handle(browser, handler -> handler.onBeforeClose(browser));
            }
        }));
    }

    public void removeLifeSpanHandler(@NotNull CefLifeSpanHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(43);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(44);
        }
        this.myLifeSpanHandler.remove(handler, browser, () -> this.myCefClient.removeLifeSpanHandler());
    }

    public JBCefClient addLoadHandler(@NotNull CefLoadHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(45);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(46);
        }
        return this.myLoadHandler.add(handler, browser, () -> this.myCefClient.addLoadHandler(new CefLoadHandler(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward));
            }

            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadStart(browser, frame, transitionType));
            }

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadEnd(browser, frame, httpStatusCode));
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                JBCefClient.this.myLoadHandler.handle(browser, handler -> handler.onLoadError(browser, frame, errorCode, errorText, failedUrl));
            }
        }));
    }

    public void removeLoadHandler(@NotNull CefLoadHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(47);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(48);
        }
        this.myLoadHandler.remove(handler, browser, () -> this.myCefClient.removeLoadHandler());
    }

    public JBCefClient addRequestHandler(@NotNull CefRequestHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(49);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(50);
        }
        return this.myRequestHandler.add(handler, browser, () -> this.myCefClient.addRequestHandler(new CefRequestHandler(){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect));
            }

            @Nullable
            public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                return JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.getResourceRequestHandler(browser, frame, request, isNavigation, isDownload, requestInitiator, disableDefaultHandling));
            }

            public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback));
            }

            public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefRequestCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onQuotaRequest(browser, origin_url, new_size, callback));
            }

            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefRequestCallback callback) {
                return JBCefClient.this.myRequestHandler.handleBoolean(browser, handler -> handler.onCertificateError(browser, cert_error, request_url, callback));
            }

            public void onPluginCrashed(CefBrowser browser, String pluginPath) {
                JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.onPluginCrashed(browser, pluginPath));
            }

            public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
                JBCefClient.this.myRequestHandler.handle(browser, handler -> handler.onRenderProcessTerminated(browser, status));
            }
        }));
    }

    public void removeRequestHandler(@NotNull CefRequestHandler handler, @NotNull CefBrowser browser) {
        if (handler == null) {
            JBCefClient.$$$reportNull$$$0(51);
        }
        if (browser == null) {
            JBCefClient.$$$reportNull$$$0(52);
        }
        this.myRequestHandler.remove(handler, browser, () -> this.myCefClient.removeRequestHandler());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefClient";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyBrowserCreated";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addContextMenuHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeContextMenuHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addDialogHandler";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeDialogHandler";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addDisplayHandler";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeDisplayHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addDownloadHandler";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeDownloadHandle";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addDragHandler";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeDragHandler";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addFocusHandler";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeFocusHandler";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addJSDialogHandler";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeJSDialogHandler";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardHandler";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeKeyboardHandler";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addLifeSpanHandler";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeLifeSpanHandler";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addLoadHandler";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "removeLoadHandler";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addRequestHandler";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "removeRequestHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface HandlerRunnable<T> {
        public void handle(T var1);
    }

    private static interface HandlerCallable<T, R> {
        @Nullable
        public R handle(T var1);
    }

    private class HandlerSupport<T> {
        private volatile Map<CefBrowser, List<T>> myMap;

        private HandlerSupport() {
        }

        private synchronized void syncInitMap() {
            if (this.myMap == null) {
                this.myMap = Collections.synchronizedMap(new LinkedHashMap());
            }
        }

        private synchronized List<T> syncInitList(@NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<Object> list;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(0);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(1);
            }
            if ((list = this.myMap.get(browser)) == null) {
                if (this.myMap.isEmpty()) {
                    onInit.run();
                }
                list = Collections.synchronizedList(new LinkedList());
                this.myMap.put(browser, list);
            }
            return list;
        }

        private synchronized void syncRemoveFromMap(@NotNull List<T> list, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            if (list == null) {
                HandlerSupport.$$$reportNull$$$0(2);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(3);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(4);
            }
            if (list.isEmpty()) {
                this.myMap.remove(browser);
                if (this.myMap.isEmpty()) {
                    onClear.run();
                }
            }
        }

        public JBCefClient add(@NotNull T handler, @NotNull CefBrowser browser, @NotNull Runnable onInit) {
            List<T> list;
            if (handler == null) {
                HandlerSupport.$$$reportNull$$$0(5);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(6);
            }
            if (onInit == null) {
                HandlerSupport.$$$reportNull$$$0(7);
            }
            if (this.myMap == null) {
                this.syncInitMap();
            }
            if ((list = this.myMap.get(browser)) == null) {
                list = this.syncInitList(browser, onInit);
            }
            list.add(handler);
            return JBCefClient.this;
        }

        public void remove(@NotNull T handler, @NotNull CefBrowser browser, @NotNull Runnable onClear) {
            List<T> list;
            if (handler == null) {
                HandlerSupport.$$$reportNull$$$0(8);
            }
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(9);
            }
            if (onClear == null) {
                HandlerSupport.$$$reportNull$$$0(10);
            }
            if (this.myMap != null && (list = this.myMap.get(browser)) != null) {
                list.remove(handler);
                if (list.isEmpty()) {
                    this.syncRemoveFromMap(list, browser, onClear);
                }
            }
        }

        public void clear() {
            if (this.myMap != null) {
                this.myMap.clear();
            }
        }

        @Nullable
        public List<T> get(@NotNull CefBrowser browser) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(11);
            }
            return this.myMap != null ? this.myMap.get(browser) : null;
        }

        @Nullable
        public <R> R handle(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, R> callable) {
            List<Object> list;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(12);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(13);
            }
            if ((list = this.get(browser)) == null) {
                return null;
            }
            Ref lastResult = new Ref(null);
            list.forEach(handler -> lastResult.set(callable.handle(handler)));
            return (R)lastResult.get();
        }

        public <R> boolean handleBoolean(@NotNull CefBrowser browser, @NotNull HandlerCallable<T, Boolean> callable) {
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(14);
            }
            if (callable == null) {
                HandlerSupport.$$$reportNull$$$0(15);
            }
            return (Boolean)ObjectUtils.notNull((Object)this.handle(browser, callable), (Object)Boolean.FALSE);
        }

        public void handle(@NotNull CefBrowser browser, @NotNull HandlerRunnable<T> runnable) {
            List<Object> list;
            if (browser == null) {
                HandlerSupport.$$$reportNull$$$0(16);
            }
            if (runnable == null) {
                HandlerSupport.$$$reportNull$$$0(17);
            }
            if ((list = this.get(browser)) == null) {
                return;
            }
            list.forEach(handler -> runnable.handle(handler));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onInit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onClear";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/jcef/JBCefClient$HandlerSupport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncInitList";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncRemoveFromMap";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 12: 
                case 13: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handle";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleBoolean";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class JSQueryPool {
        private final JBCefJSQuery.JSQueryFunc[] pool;
        private int currentFreeSlot;

        @Nullable
        static JSQueryPool create(@NotNull JBCefClient client) {
            Object size;
            int poolSize;
            if (client == null) {
                JSQueryPool.$$$reportNull$$$0(0);
            }
            int n = poolSize = (size = client.getProperty(JBCefClient.JBCEFCLIENT_JSQUERY_POOL_SIZE_PROP)) instanceof Integer ? (Integer)size : JS_QUERY_SLOT_POOL_DEF_SIZE;
            if (poolSize > 0) {
                poolSize = Math.min(poolSize, 10000);
                return new JSQueryPool(client, poolSize);
            }
            return null;
        }

        JSQueryPool(@NotNull JBCefClient client, int poolSize) {
            if (client == null) {
                JSQueryPool.$$$reportNull$$$0(1);
            }
            this.pool = new JBCefJSQuery.JSQueryFunc[poolSize];
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = new JBCefJSQuery.JSQueryFunc(client, i, true);
            }
        }

        @Nullable
        public JBCefJSQuery.JSQueryFunc getFreeSlot() {
            if (this.currentFreeSlot >= this.pool.length) {
                LOG.warn("JavaScript query pool is over [size: " + this.pool.length + "]", new Throwable());
                return null;
            }
            return this.pool[this.currentFreeSlot++];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "client";
            objectArray2[1] = "com/intellij/ui/jcef/JBCefClient$JSQueryPool";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

