/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.EventsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import io.grpc.StatusRuntimeException;
import org.jetbrains.annotations.NotNull;

public class EventDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final EventsTable myEventsTable;
    @NotNull
    private final EventServiceGrpc.EventServiceBlockingStub myEventPollingService;

    public EventDataPoller(@NotNull Common.Session session, @NotNull EventsTable eventTable, @NotNull EventServiceGrpc.EventServiceBlockingStub pollingService) {
        if (session == null) {
            EventDataPoller.$$$reportNull$$$0(0);
        }
        if (eventTable == null) {
            EventDataPoller.$$$reportNull$$$0(1);
        }
        if (pollingService == null) {
            EventDataPoller.$$$reportNull$$$0(2);
        }
        super(POLLING_DELAY_NS);
        this.myDataRequestStartTimestampNs = Long.MIN_VALUE;
        this.myEventsTable = eventTable;
        this.myEventPollingService = pollingService;
        this.mySession = session;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(Long.MAX_VALUE);
        EventProfiler.ActivityDataResponse activityResponse = this.myEventPollingService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : activityResponse.getDataList()) {
            long id = data.getHash();
            EventProfiler.ActivityData cached_data = this.myEventsTable.findActivityDataOrNull(this.mySession, id);
            if (cached_data != null) {
                EventProfiler.ActivityData.Builder builder = cached_data.toBuilder();
                for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                    if (!cached_data.getStateChangesList().contains(state)) {
                        builder.addStateChanges(state);
                    }
                    if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                    this.myDataRequestStartTimestampNs = state.getTimestamp();
                }
                this.myEventsTable.insertOrReplace(id, this.mySession, builder.build());
                continue;
            }
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
            for (EventProfiler.ActivityStateData state : data.getStateChangesList()) {
                if (state.getTimestamp() <= this.myDataRequestStartTimestampNs) continue;
                this.myDataRequestStartTimestampNs = state.getTimestamp();
            }
        }
        EventProfiler.SystemDataResponse systemResponse = this.myEventPollingService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : systemResponse.getDataList()) {
            long id = data.getEventId();
            this.myEventsTable.insertOrReplace(id, this.mySession, data);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "eventTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pollingService";
                break;
            }
        }
        objectArray[1] = "com/android/tools/datastore/poller/EventDataPoller";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

