/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.Stage;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilerMonitorView<T extends ProfilerMonitor>
extends AspectObserver {
    private static final int MINIMUM_MONITOR_HEIGHT = JBUI.scale((int)50);
    @NotNull
    private final T myMonitor;
    private JPanel myContainer;

    public ProfilerMonitorView(@NotNull T monitor) {
        if (monitor == null) {
            ProfilerMonitorView.$$$reportNull$$$0(0);
        }
        this.myMonitor = monitor;
        this.myContainer = new JBPanel();
        this.myContainer.setOpaque(true);
        this.myContainer.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.myContainer.setMinimumSize(new Dimension(0, MINIMUM_MONITOR_HEIGHT));
        this.myContainer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ((ProfilerMonitor)((Object)ProfilerMonitorView.this.myMonitor)).setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ((ProfilerMonitor)((Object)ProfilerMonitorView.this.myMonitor)).setFocus(false);
            }
        });
        this.myMonitor.addDependency((AspectObserver)this).onChange((Enum)ProfilerMonitor.Aspect.ENABLE, this::monitorEnabledChanged);
        this.monitorEnabledChanged();
        this.myMonitor.addDependency((AspectObserver)this).onChange((Enum)ProfilerMonitor.Aspect.FOCUS, this::focusChanged);
        this.focusChanged();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myContainer;
        if (jPanel == null) {
            ProfilerMonitorView.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void focusChanged() {
        if (((ProfilerMonitor)((Object)this.myMonitor)).isEnabled()) {
            boolean highlight = ((ProfilerMonitor)((Object)this.myMonitor)).isFocused() && ((ProfilerMonitor)((Object)this.myMonitor)).canExpand();
            this.myContainer.setBackground(highlight ? ProfilerColors.MONITOR_FOCUSED : ProfilerColors.DEFAULT_BACKGROUND);
        } else {
            this.myContainer.setBackground(ProfilerColors.MONITOR_DISABLED);
        }
    }

    @NotNull
    protected final T getMonitor() {
        T t = this.myMonitor;
        if (t == null) {
            ProfilerMonitorView.$$$reportNull$$$0(2);
        }
        return t;
    }

    public float getVerticalWeight() {
        return 1.0f;
    }

    @NotNull
    public String getDisabledMessage() {
        return "Advanced profiling is unavailable for the selected process";
    }

    private void monitorEnabledChanged() {
        this.myContainer.removeAll();
        if (((ProfilerMonitor)((Object)this.getMonitor())).isEnabled()) {
            this.myContainer.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            this.populateUi(this.myContainer);
        } else {
            this.myContainer.setBackground(ProfilerColors.MONITOR_DISABLED);
            this.populateDisabledView(this.myContainer);
        }
    }

    protected void populateDisabledView(JPanel container) {
        boolean canConfigureAdvancedProfiling;
        TabularLayout layout = new TabularLayout("*,Fit-,*", "*");
        this.myContainer.setLayout((LayoutManager)layout);
        boolean bl = canConfigureAdvancedProfiling = ((ProfilerMonitor)((Object)this.myMonitor)).getProfilers().getDevice() != null && ((ProfilerMonitor)((Object)this.myMonitor)).getProfilers().getDevice().getFeatureLevel() < 26;
        if (canConfigureAdvancedProfiling) {
            layout.setRowSizing(0, "6*");
            layout.setRowSizing(1, "4*");
        }
        JLabel disabledMessage = new JLabel(this.getDisabledMessage());
        disabledMessage.setHorizontalAlignment(0);
        disabledMessage.setVerticalAlignment(0);
        disabledMessage.setFont(ProfilerFonts.H2_FONT);
        this.myContainer.add((Component)disabledMessage, new TabularLayout.Constraint(0, 0, 3));
        if (canConfigureAdvancedProfiling) {
            HyperlinkLabel linkToConfigMessage = new HyperlinkLabel();
            linkToConfigMessage.setHyperlinkText("Configure this setting in the ", "Run Configuration", "");
            linkToConfigMessage.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    ((ProfilerMonitor)((Object)ProfilerMonitorView.this.myMonitor)).getProfilers().getIdeServices().enableAdvancedProfiling();
                }
            });
            this.myContainer.add((Component)linkToConfigMessage, new TabularLayout.Constraint(1, 1));
            linkToConfigMessage.setFont(ProfilerFonts.STANDARD_FONT);
        }
    }

    public void registerTooltip(@NotNull RangeTooltipComponent tooltip, Stage stage) {
        if (tooltip == null) {
            ProfilerMonitorView.$$$reportNull$$$0(3);
        }
        JComponent component = this.getComponent();
        component.addMouseListener(new ProfilerTooltipMouseAdapter(stage, () -> ((ProfilerMonitor)((Object)((Object)this.myMonitor))).isEnabled() ? ((ProfilerMonitor)((Object)((Object)this.myMonitor))).buildTooltip() : null));
        tooltip.registerListenersOn(component);
    }

    protected abstract void populateUi(JPanel var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "monitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/ProfilerMonitorView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/ProfilerMonitorView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

